(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25093,        876]*)
(*NotebookOutlinePosition[     25759,        899]*)
(*  CellTagsIndexPosition[     25715,        895]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejemplo: l\[IAcute]mite e integral impropia.", "Subtitle"],

Cell[TextData[{
  "C\[AAcute]lculo del \[AAcute]rea bajo la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y\  = \ \[ExponentialE]\^\(\(-x\^2\)/2\)\)]],
  " en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, \(\(\[Infinity]\)\([\)\)\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(Needs["\<Graphics`Colors`\>"];\)\), "\[IndentingNewLine]", 
    \(Needs["\<Graphics`FilledPlot`\>"]\)}], "Input"],

Cell[BoxData[
    \(\(\(f[
        x_]\)\(\ \)\(:=\)\(\ \)\(\[ExponentialE]\^\(\(-x\^2\)/
            2\)\)\(\ \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(g1\  = \ 
        Plot[f[x], {x, \(-3\), 3}, 
          AspectRatio \[Rule] 
            Automatic, \[IndentingNewLine]Ticks \[Rule] {Automatic, {0.5, 
                1}}, PlotStyle \[Rule] {Blue}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .16667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.00396824 0.15873 [
[.02381 -0.00853 -6 -9 ]
[.02381 -0.00853 6 0 ]
[.18254 -0.00853 -6 -9 ]
[.18254 -0.00853 6 0 ]
[.34127 -0.00853 -6 -9 ]
[.34127 -0.00853 6 0 ]
[.65873 -0.00853 -3 -9 ]
[.65873 -0.00853 3 0 ]
[.81746 -0.00853 -3 -9 ]
[.81746 -0.00853 3 0 ]
[.97619 -0.00853 -3 -9 ]
[.97619 -0.00853 3 0 ]
[.4875 .08333 -18 -4.5 ]
[.4875 .08333 0 4.5 ]
[.4875 .1627 -6 -4.5 ]
[.4875 .1627 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .00397 m
.02381 .01022 L
s
[(-3)] .02381 -0.00853 0 1 Mshowa
.18254 .00397 m
.18254 .01022 L
s
[(-2)] .18254 -0.00853 0 1 Mshowa
.34127 .00397 m
.34127 .01022 L
s
[(-1)] .34127 -0.00853 0 1 Mshowa
.65873 .00397 m
.65873 .01022 L
s
[(1)] .65873 -0.00853 0 1 Mshowa
.81746 .00397 m
.81746 .01022 L
s
[(2)] .81746 -0.00853 0 1 Mshowa
.97619 .00397 m
.97619 .01022 L
s
[(3)] .97619 -0.00853 0 1 Mshowa
.125 Mabswid
.05556 .00397 m
.05556 .00772 L
s
.0873 .00397 m
.0873 .00772 L
s
.11905 .00397 m
.11905 .00772 L
s
.15079 .00397 m
.15079 .00772 L
s
.21429 .00397 m
.21429 .00772 L
s
.24603 .00397 m
.24603 .00772 L
s
.27778 .00397 m
.27778 .00772 L
s
.30952 .00397 m
.30952 .00772 L
s
.37302 .00397 m
.37302 .00772 L
s
.40476 .00397 m
.40476 .00772 L
s
.43651 .00397 m
.43651 .00772 L
s
.46825 .00397 m
.46825 .00772 L
s
.53175 .00397 m
.53175 .00772 L
s
.56349 .00397 m
.56349 .00772 L
s
.59524 .00397 m
.59524 .00772 L
s
.62698 .00397 m
.62698 .00772 L
s
.69048 .00397 m
.69048 .00772 L
s
.72222 .00397 m
.72222 .00772 L
s
.75397 .00397 m
.75397 .00772 L
s
.78571 .00397 m
.78571 .00772 L
s
.84921 .00397 m
.84921 .00772 L
s
.88095 .00397 m
.88095 .00772 L
s
.9127 .00397 m
.9127 .00772 L
s
.94444 .00397 m
.94444 .00772 L
s
.25 Mabswid
0 .00397 m
1 .00397 L
s
.5 .08333 m
.50625 .08333 L
s
[(0.5)] .4875 .08333 1 0 Mshowa
.5 .1627 m
.50625 .1627 L
s
[(1)] .4875 .1627 1 0 Mshowa
.5 0 m
.5 .16667 L
s
0 0 m
1 0 L
1 .16667 L
0 .16667 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .00573 m
.04262 .00647 L
.06244 .00752 L
.08255 .00897 L
.10458 .0111 L
.12415 .01359 L
.14509 .017 L
.16496 .02108 L
.18653 .02655 L
.22646 .03993 L
.26733 .05818 L
.30668 .07958 L
.34452 .10221 L
.3848 .12595 L
.42358 .14533 L
.44471 .15336 L
.45443 .15629 L
.4648 .15884 L
.47015 .15992 L
.47519 .16077 L
.48009 .16145 L
.48461 .16195 L
.4889 .16231 L
.49106 .16245 L
.49344 .16256 L
.49469 .16261 L
.49582 .16264 L
.49714 .16267 L
.49838 .16269 L
.49953 .1627 L
.50059 .1627 L
.50175 .16269 L
.50299 .16267 L
.50413 .16264 L
.50537 .16261 L
.50788 .1625 L
.5102 .16237 L
.51236 .16222 L
.51725 .16176 L
.52246 .16112 L
.53204 .1595 L
.54074 .15755 L
.55993 .15178 L
.58073 .14344 L
.62164 .12231 L
.66105 .09884 L
.69893 .07634 L
.73927 .05493 L
.7781 .03817 L
.79785 .03126 L
Mistroke
.81938 .02494 L
.85914 .01624 L
.87885 .01317 L
.89983 .01062 L
.92129 .00866 L
.94147 .00729 L
.95956 .00637 L
.97619 .00573 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 48},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0000B2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00C@3oool4000002X0oooo1P00000Y0?ooo`L00000D`3oool7000002P0
oooo1P00000Z0?ooo`@00000B@3oool004`0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0AP3oool00540oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo05L0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo04H0oooo001A
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`1G
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`16
0?ooo`00@`3oool6000000H0oooo0P00000Q0?ooo`H000001P3oool00`000000oooo0?ooo`0P0?oo
o`H000001P3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool0;03oool2000004T0oooo001A0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`160?ooo`00D@3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1G0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0/0?ooo`030000
003oool0oooo04H0oooo001<0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02P0oooo0`00001G0?ooo`<00000:`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`160?ooo`00C@3oool4000002/0oooo1000000]0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool0:P3oool4000002/0oooo100000190?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00f03oool00`000000oooo0?ooo`3E0?ooo`00A03oool7000000P0003oo`00000<000000P0003o
1`0000130?ooo`00B`3oool00`000000oooo0?ooo`050?ooo`d0003o1`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`060?ooo``0003o1`3oool00`000000oooo0?ooo`180?ooo`00B`3oool00`000000oooo0?ooo`0B
0?ooo`H0003o503oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02`0oooo00<00000
0?ooo`3oool0;03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00d0oooo30000?lC
0?ooo`030000003oool0oooo04P0oooo001V0?ooo`H0003oK03oool00`000000oooo0?ooo`1V0?oo
o`D0003oJP3oool006`0oooo1P000?mV0?ooo`030000003oool0oooo0680oooo10000?m_0?ooo`00
LP3oool60000of00oooo00<000000?ooo`3oool0GP3oool40000og<0oooo001h0?ooo`D0003oF`3o
ool00`000000oooo0?ooo`1K0?ooo`<0003oM`3oool007d0oooo0`000?mH0?ooo`030000003oool0
oooo05L0oooo10000?mj0?ooo`00P03oool30000oeD0oooo00<000000?ooo`3oool0E03oool30000
ogh0oooo00230?ooo`<0003oDP3oool00`000000oooo0?ooo`1A0?ooo`<0003oP@3oool008H0oooo
0P000?m@0?ooo`030000003oool0oooo04h0oooo0`000?n40?ooo`00R03oool20000odh0oooo00<0
00000?ooo`3oool0C03oool20000ohL0oooo002:0?ooo`80003oC03oool00`000000oooo0?ooo`1:
0?ooo`80003oR@3oool008`0oooo0P000?m:0?ooo`030000003oool0oooo04P0oooo0P000?n;0?oo
o`00SP3oool20000odP0oooo00<000000?ooo`3oool0AP3oool20000ohd0oooo002@0?ooo`80003o
AP3oool00`000000oooo0?ooo`140?ooo`80003oS`3oool00980oooo0P000?m40?ooo`030000003o
ool0oooo0480oooo0P000?nA0?ooo`00U03oool20000od80oooo00<000000?ooo`3oool0@03oool2
0000oi<0oooo002F0?ooo`80003o@03oool00`000000oooo0?ooo`0n0?ooo`80003oU@3oool009P0
oooo0P000?ln0?ooo`030000003oool0oooo03`0oooo0P000?nG0?ooo`00VP3oool20000oal0oooo
100000060?ooo`8000001P3oool4000000L0oooo00<000000?ooo`3oool0>P3oool20000oiT0oooo
002L0?ooo`80003o703oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo0P00
00050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0h0?ooo`80003oV`3oool009h0oooo0P000?lJ0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03H0oooo0P000?nM
0?ooo`00X03oool20000oaP0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00@0oooo0`00000e0?ooo`030000o`3oool0oooo09d0oooo002R0?ooo`03
0000o`3oool0oooo01D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0<`3oool20000oj00oooo002S0?ooo`80003o
5@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo100000070?ooo`030000
003oool0oooo0340oooo0P000?nR0?ooo`00Y@3oool20000oa<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0<03o
ool00`000?l0oooo0?ooo`2R0?ooo`00Y`3oool00`000?l0oooo0?ooo`0@0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo02h0oooo0P000?nU0?ooo`00Z03oool20000oa40oooo1000000>0?ooo`D000001P3oool00`00
0000oooo0?ooo`0]0?ooo`030000o`3oool0oooo0:D0oooo002Z0?ooo`030000o`3oool0oooo02/0
oooo00<000000?ooo`3oool0:`3oool20000ojP0oooo002[0?ooo`80003o:`3oool00`000000oooo
0?ooo`0Y0?ooo`80003oZP3oool00:d0oooo0P000?lY0?ooo`030000003oool0oooo02P0oooo00<0
003o0?ooo`3oool0ZP3oool00:l0oooo00<0003o0?ooo`3oool09P3oool00`000000oooo0?ooo`0V
0?ooo`80003o[@3oool00;00oooo0P000?lV0?ooo`030000003oool0oooo02@0oooo0P000?n_0?oo
o`00/P3oool20000ob@0oooo00<000000?ooo`3oool08P3oool20000ok40oooo002d0?ooo`80003o
8P3oool00`000000oooo0?ooo`0Q0?ooo`030000o`3oool0oooo0;40oooo002f0?ooo`030000o`3o
ool0oooo01l0oooo00<000000?ooo`3oool07`3oool20000ok@0oooo002g0?ooo`80003o7`3oool0
0`000000oooo0?ooo`0M0?ooo`80003o]P3oool00;T0oooo0P000?lM0?ooo`030000003oool0oooo
01/0oooo0P000?nh0?ooo`00^`3oool20000oa/0oooo00<000000?ooo`3oool06@3oool20000okX0
oooo002m0?ooo`80003o6@3oool00`000000oooo0?ooo`0G0?ooo`80003o_03oool00;l0oooo0P00
0?lG0?ooo`030000003oool0oooo01D0oooo0P000?nn0?ooo`00`@3oool20000oaD0oooo00<00000
0?ooo`3oool04`3oool20000ol00oooo00330?ooo`@0003o1@3oool7000000D0oooo00<000000?oo
o`3oool04@3oool20000ol80oooo00370?ooo`80003o1P3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00d0oooo10000?o40?ooo`00b@3oool30000o`<0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`080?ooo`D0003ob03oool00<`0oooo1`000?l50?ooo`030000003o
ool0oooo0080oooo1P000?o=0?ooo`00c`3oool010000000oooo0?ooo`3oool:0000om<0oooo003?
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0e@3oool00<l0oooo00<000000?oo
o`3oool0gP3oool00<d0oooo0`00003P0?ooo`00c`3oool00`000000oooo0?ooo`3N0?ooo`00o`3o
oona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {71, 0}} -> {-4.6014, -0.365705, 0.0318846, \
0.0318846}}]
}, Open  ]],

Cell[TextData[{
  "Para cada t, el \[AAcute]rea bajo la curva  ",
  Cell[BoxData[
      \(TraditionalForm\`y\  = \ f(x)\)]],
  ", entre 0 y t, es dada por:"
}], "Text"],

Cell[BoxData[
    \(F[t_]\  := \ \[Integral]\_0\%t f[x] \[DifferentialD]x\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Limit[F[t], t \[Rule] \[Infinity]]\)], "Input"],

Cell[BoxData[
    \(\@\(\[Pi]\/2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Con el \[UAcute]ltimo comando se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_0\%\[Infinity]\( \
\[ExponentialE]\^\(\(-x\^2\)/2\)\) \[DifferentialD]x\  = \ \@\(\[Pi]/2\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(g2\  = 
        FilledPlot[f[x], {x, 0, 3}, Fills \[Rule] {Cyan}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[g1, g2];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .16667 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.00396825 0.15873 [
[.02381 -0.00853 -6 -9 ]
[.02381 -0.00853 6 0 ]
[.18254 -0.00853 -6 -9 ]
[.18254 -0.00853 6 0 ]
[.34127 -0.00853 -6 -9 ]
[.34127 -0.00853 6 0 ]
[.65873 -0.00853 -3 -9 ]
[.65873 -0.00853 3 0 ]
[.81746 -0.00853 -3 -9 ]
[.81746 -0.00853 3 0 ]
[.97619 -0.00853 -3 -9 ]
[.97619 -0.00853 3 0 ]
[.4875 .08333 -18 -4.5 ]
[.4875 .08333 0 4.5 ]
[.4875 .1627 -6 -4.5 ]
[.4875 .1627 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .00397 m
.02381 .01022 L
s
[(-3)] .02381 -0.00853 0 1 Mshowa
.18254 .00397 m
.18254 .01022 L
s
[(-2)] .18254 -0.00853 0 1 Mshowa
.34127 .00397 m
.34127 .01022 L
s
[(-1)] .34127 -0.00853 0 1 Mshowa
.65873 .00397 m
.65873 .01022 L
s
[(1)] .65873 -0.00853 0 1 Mshowa
.81746 .00397 m
.81746 .01022 L
s
[(2)] .81746 -0.00853 0 1 Mshowa
.97619 .00397 m
.97619 .01022 L
s
[(3)] .97619 -0.00853 0 1 Mshowa
.125 Mabswid
.05556 .00397 m
.05556 .00772 L
s
.0873 .00397 m
.0873 .00772 L
s
.11905 .00397 m
.11905 .00772 L
s
.15079 .00397 m
.15079 .00772 L
s
.21429 .00397 m
.21429 .00772 L
s
.24603 .00397 m
.24603 .00772 L
s
.27778 .00397 m
.27778 .00772 L
s
.30952 .00397 m
.30952 .00772 L
s
.37302 .00397 m
.37302 .00772 L
s
.40476 .00397 m
.40476 .00772 L
s
.43651 .00397 m
.43651 .00772 L
s
.46825 .00397 m
.46825 .00772 L
s
.53175 .00397 m
.53175 .00772 L
s
.56349 .00397 m
.56349 .00772 L
s
.59524 .00397 m
.59524 .00772 L
s
.62698 .00397 m
.62698 .00772 L
s
.69048 .00397 m
.69048 .00772 L
s
.72222 .00397 m
.72222 .00772 L
s
.75397 .00397 m
.75397 .00772 L
s
.78571 .00397 m
.78571 .00772 L
s
.84921 .00397 m
.84921 .00772 L
s
.88095 .00397 m
.88095 .00772 L
s
.9127 .00397 m
.9127 .00772 L
s
.94444 .00397 m
.94444 .00772 L
s
.25 Mabswid
0 .00397 m
1 .00397 L
s
.5 .08333 m
.50625 .08333 L
s
[(0.5)] .4875 .08333 1 0 Mshowa
.5 .1627 m
.50625 .1627 L
s
[(1)] .4875 .1627 1 0 Mshowa
.5 0 m
.5 .16667 L
s
0 0 m
1 0 L
1 .16667 L
0 .16667 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .00573 m
.04262 .00647 L
.06244 .00752 L
.08255 .00897 L
.10458 .0111 L
.12415 .01359 L
.14509 .017 L
.16496 .02108 L
.18653 .02655 L
.22646 .03993 L
.26733 .05818 L
.30668 .07958 L
.34452 .10221 L
.3848 .12595 L
.42358 .14533 L
.44471 .15336 L
.45443 .15629 L
.4648 .15884 L
.47015 .15992 L
.47519 .16077 L
.48009 .16145 L
.48461 .16195 L
.4889 .16231 L
.49106 .16245 L
.49344 .16256 L
.49469 .16261 L
.49582 .16264 L
.49714 .16267 L
.49838 .16269 L
.49953 .1627 L
.50059 .1627 L
.50175 .16269 L
.50299 .16267 L
.50413 .16264 L
.50537 .16261 L
.50788 .1625 L
.5102 .16237 L
.51236 .16222 L
.51725 .16176 L
.52246 .16112 L
.53204 .1595 L
.54074 .15755 L
.55993 .15178 L
.58073 .14344 L
.62164 .12231 L
.66105 .09884 L
.69893 .07634 L
.73927 .05493 L
.7781 .03817 L
.79785 .03126 L
Mistroke
.81938 .02494 L
.85914 .01624 L
.87885 .01317 L
.89983 .01062 L
.92129 .00866 L
.94147 .00729 L
.95956 .00637 L
.97619 .00573 L
Mfstroke
0 g
.5 .1627 m
.50059 .1627 L
.50112 .16269 L
.50174 .16269 L
.50232 .16268 L
.50336 .16266 L
.50449 .16263 L
.50573 .1626 L
.50704 .16254 L
.5094 .16242 L
.51184 .16226 L
.51412 .16207 L
.51932 .16153 L
.52462 .1608 L
.52947 .15999 L
.54039 .15764 L
.56024 .15167 L
.57934 .14406 L
.59966 .1343 L
.61922 .12368 L
.64001 .11154 L
.66005 .09944 L
.67932 .08782 L
.69982 .07583 L
.71957 .06494 L
.73855 .05528 L
.75877 .046 L
.77822 .03813 L
.7989 .03092 L
.81882 .02508 L
.83799 .02042 L
.85838 .01638 L
.87801 .01328 L
.89689 .01094 L
.91699 .009 L
.93633 .0076 L
.9569 .00649 L
.97619 .00573 L
s
0 1 1 r
.5 .1627 m
.50059 .1627 L
.50112 .16269 L
.50174 .16269 L
.50232 .16268 L
.50336 .16266 L
.50449 .16263 L
.50573 .1626 L
.50704 .16254 L
.5094 .16242 L
.51184 .16226 L
.51412 .16207 L
.51932 .16153 L
.52462 .1608 L
.52947 .15999 L
.54039 .15764 L
.56024 .15167 L
.57934 .14406 L
.59966 .1343 L
.61922 .12368 L
.64001 .11154 L
.66005 .09944 L
.67932 .08782 L
.69982 .07583 L
.71957 .06494 L
.73855 .05528 L
.75877 .046 L
.77822 .03813 L
.7989 .03092 L
.81882 .02508 L
.83799 .02042 L
.85838 .01638 L
.87801 .01328 L
.89689 .01094 L
.91699 .009 L
.93633 .0076 L
.9569 .00649 L
.97619 .00573 L
.97619 .00397 L
.5 .00397 L
F
0 g
.5 .1627 m
.50059 .1627 L
.50112 .16269 L
.50174 .16269 L
.50232 .16268 L
.50336 .16266 L
.50449 .16263 L
.50573 .1626 L
.50704 .16254 L
.5094 .16242 L
.51184 .16226 L
.51412 .16207 L
.51932 .16153 L
.52462 .1608 L
.52947 .15999 L
.54039 .15764 L
.56024 .15167 L
.57934 .14406 L
.59966 .1343 L
.61922 .12368 L
.64001 .11154 L
.66005 .09944 L
.67932 .08782 L
.69982 .07583 L
.71957 .06494 L
.73855 .05528 L
.75877 .046 L
.77822 .03813 L
.7989 .03092 L
.81882 .02508 L
.83799 .02042 L
.85838 .01638 L
.87801 .01328 L
.89689 .01094 L
.91699 .009 L
.93633 .0076 L
.9569 .00649 L
.97619 .00573 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 48},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0000B2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00C@3oool4000002X0oooo1P00000Y0?ooo`L00000D`3oool7000002P0
oooo1P00000Z0?ooo`@00000B@3oool004`0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`1G0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0AP3oool00540oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo05L0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo04H0oooo001A
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`1G
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`16
0?ooo`00@`3oool6000000H0oooo0P00000Q0?ooo`H000001P3oool00`000000oooo0?ooo`0P0?oo
o`H000001P3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool0;03oool2000004T0oooo001A0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`160?ooo`00D@3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1G0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0/0?ooo`030000
003oool0oooo04H0oooo001<0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02P0oooo0`00001G0?ooo`<00000:`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`160?ooo`00C@3oool4000002/0oooo1000000]0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool0:P3oool4000002/0oooo100000190?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00f03oool00`000000oooo0?ooo`3E0?ooo`00A03oool7000000P0003oo`00000K000004<0oooo
001;0?ooo`030000003oool0oooo00D0oooo3@000?l70?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooogX00?oo2`0000000`000?l0oooo0?oo
o`050?ooo`030000003oool0oooo04P0oooo001;0?ooo`030000003oool0oooo0180oooo1P000?lD
0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0;03ooom^003oo``000004`3oool0
0`000000oooo0?ooo`180?ooo`00IP3oool60000of`0ooooJ@00ool5000006X0oooo001/0?ooo`H0
003oIP3ooomV003oo`<00000K`3oool00780oooo1P000?mP0?ooof800?oo1000001b0?ooo`00N03o
ool50000oe/0ooooG@00ool5000007H0oooo001m0?ooo`<0003oF03ooomK003oo`80000000<0003o
0?ooo`3oool0N03oool00800oooo0`000?mE0?oooeP00?oo0`00001m0?ooo`00P`3oool30000oe80
ooooE000ool400000800oooo00260?ooo`80003oD03ooomA003oo`<00000Q03oool008P0oooo0P00
0?m>0?ooodl00?oo0P0000270?ooo`00RP3oool20000od`0ooooC@00ool2000008T0oooo002<0?oo
o`80003oBP3ooom;003oo`800000R`3oool008h0oooo0P000?m80?ooodT00?oo0P00002=0?ooo`00
T03oool20000odH0ooooA`00ool2000008l0oooo002B0?ooo`80003oA03ooom5003oo`800000T@3o
ool009@0oooo0P000?m20?oood<00?oo0P00002C0?ooo`00UP3oool20000od00oooo@@00ool20000
09D0oooo002H0?ooo`80003o?P3ooolo003oo`800000U`3oool009X0oooo0P000?lO0?ooo`@00000
1P3oool2000000H0oooo100000070?ooocd00?oo0P00002I0?ooo`00W03oool20000oa`0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00@0oooo>`00ool2000009/0oooo002N0?ooo`80003o6P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oooli
003oo`800000W@3oool00:00oooo0P000?lH0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`040?ooocP00?oo00<000000?ooo`3oool0W@3oool00:80
oooo00<0003o0?ooo`3oool05@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0103ooolf003oo`800000X03oool00:<0oooo0P000?lE0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool02`3oool4000000L0oooo=@00ool00`000000oooo
0?ooo`2P0?ooo`00Y@3oool20000oa<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo00P0oooo<`00ool200000:<0oooo002W0?ooo`030000o`3oool0
oooo0100oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo00P0oooo<@00ool200000:D0oooo002X0?ooo`80003o4@3oool4000000h0oooo1@0000060?oo
obl00?oo0P00002W0?ooo`00ZP3oool00`000?l0oooo0?ooo`0[0?ooobd00?oo0P0000000`000?l0
oooo0?ooo`2V0?ooo`00Z`3oool20000ob/0oooo;000ool00`000000003o0?ooo`2Y0?ooo`00[@3o
ool20000obT0oooo:P00ool200000:`0oooo002_0?ooo`030000o`3oool0oooo02H0oooo:@00ool0
0`000000003o0?ooo`2/0?ooo`00/03oool20000obH0oooo9`00ool200000:l0oooo002b0?ooo`80
003o903ooolU003oo`800000/@3oool00;@0oooo0P000?lR0?ooob<00?oo0P00002c0?ooo`00]P3o
ool00`000?l0oooo0?ooo`0O0?ooob400?oo0P0000000`000?l0oooo0?ooo`2b0?ooo`00]`3oool2
0000oal0oooo7`00ool2000000030000o`3oool0oooo0;@0oooo002i0?ooo`80003o7@3ooolM003o
o`80000000<0003o0?ooo`3oool0]P3oool00;/0oooo0P000?lK0?oooa/00?oo0P0000000`000?l0
oooo0?ooo`2h0?ooo`00_@3oool20000oaT0oooo6@00ool2000000030000o`3oool0oooo0;X0oooo
002o0?ooo`80003o5`3ooolF003oo`<0000000<0003o0?ooo`3oool0_03oool00<40oooo0P000?lE
0?oooa@00?oo0P0000020000ol00oooo00330?ooo`@0003o1@3oool7000000D0oooo4@00ool30000
0080003o`P3oool00<L0oooo0P000?l60?ooo`030000003oool0oooo00H0oooo3P00ool3000000<0
003oa03oool00<T0oooo0`000?l30?ooo`030000003oool0oooo00H0oooo2`00ool300000080003o
b03oool00<`0oooo1`000?l50?ooo`H00?oo1@00003=0?ooo`00c`3oool010000000oooo0?ooo`3o
ool50000o`H00000dP3oool00<l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3E
0?ooo`00c`3oool00`000000oooo0?ooo`3N0?ooo`00c@3oool300000>00oooo003?0?ooo`030000
003oool0oooo0=h0oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {71, 0}} -> {-4.6014, -0.365705, 0.0318846, \
0.0318846}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 959}},
WindowSize->{733, 858},
WindowMargins->{{204, Automatic}, {Automatic, 20}},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 64, 0, 95, "Subtitle"],
Cell[1843, 55, 275, 8, 51, "Text"],
Cell[2121, 65, 136, 2, 68, "Input"],
Cell[2260, 69, 128, 3, 47, "Input"],

Cell[CellGroupData[{
Cell[2413, 76, 236, 5, 68, "Input"],
Cell[2652, 83, 10423, 321, 84, 3359, 229, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[13090, 407, 168, 5, 47, "Text"],
Cell[13261, 414, 86, 1, 62, "Input"],

Cell[CellGroupData[{
Cell[13372, 419, 67, 1, 42, "Input"],
Cell[13442, 422, 48, 1, 73, "Output"]
}, Open  ]],
Cell[13505, 426, 236, 6, 63, "Text"],
Cell[13744, 434, 103, 2, 42, "Input"],

Cell[CellGroupData[{
Cell[13872, 440, 50, 1, 42, "Input"],
Cell[13925, 443, 11140, 429, 84, 5182, 351, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

