(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    451463,      18128]*)
(*NotebookOutlinePosition[    452137,      18151]*)
(*  CellTagsIndexPosition[    452093,      18147]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Ejemplo: Selector del ViewPoint\n\n",
  StyleBox["Este ejemplo, usa elementos tomados de  los programas:  \
\"RealTimePlot dialog\" de  Tom Wickham-Jones,  \"A Modal Input Dialog\"  y \
\"A Button Palette\"  en J/Link User Guide de Tood Gayley, para definir un \
procedimiento que usando \"en vivo\" un gr\[AAcute]fico en tres dimensiones, \
permita rotarlo apropiadamente a fin de buscar el valor para la \
opci\[OAcute]n ViewPoint,  que produzca el gr\[AAcute]fico en la orientaci\
\[OAcute]n deseada.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Definici\[OAcute]n de procedimientos.", "Subsection"],

Cell[TextData[{
  "Needs[\"JLink`\"]\n\nUseFrontEndForRendering=False;\n\ncreateWindow[] :=\n\
\tModule[{frame, sliderHor, sliderVer, listener, listen, okButton, tok},\n\t\t\
InstallJava[];\n\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\", \
\"Selector del ViewPoint\"];\n\t\tdrawArea = \
JavaNew[\"com.wolfram.jlink.MathCanvas\"];\n\t\tdrawArea@",
  StyleBox["setUsesFE[",
    PageWidth->Infinity,
    ShowSpecialCharacters->False],
  "UseFrontEndForRendering",
  StyleBox["];",
    PageWidth->Infinity,
    ShowSpecialCharacters->False],
  "\n\t\tdrawArea@setSize[400, 272];",
  StyleBox["\n",
    PageWidth->Infinity,
    ShowSpecialCharacters->False,
    FontFamily->"Courier New",
    FontSize->10],
  "\t\tJavaBlock[\n\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];\
\n\t\t\tsliderHor = JavaNew[\"java.awt.Scrollbar\", Scrollbar`HORIZONTAL, 30, \
1, 0, 90];\n\t\t\tsliderVer = JavaNew[\"java.awt.Scrollbar\", \
Scrollbar`VERTICAL, 15, 1, 0, 90];\n\t\t\tokButton = \
JavaNew[\"java.awt.Button\", \"OK\"];\n\t\t\tframe@add[sliderHor, \
ReturnAsJavaObject[BorderLayout`NORTH]];\n\t\t\tframe@add[sliderVer, \
ReturnAsJavaObject[BorderLayout`EAST]];\n\t\t\tframe@add[drawArea, \
ReturnAsJavaObject[BorderLayout`CENTER]];\n\t\t    frame@add[okButton, \
ReturnAsJavaObject[BorderLayout`SOUTH]];\n\t\t\tframe@pack[];\n\t\t\tlistener \
= JavaNew[\"com.wolfram.jlink.MathAdjustmentListener\"];\n\t\t\tlisten = \
JavaNew[\"com.wolfram.jlink.MathAdjustmentListener\"];\n\t\t\t\
listener@setHandler[\"adjustmentValueChanged\", \"sliderHorFunc\"];\n\t\t\t\
sliderHor@addAdjustmentListener[listener];\n\t\t\t\
listen@setHandler[\"adjustmentValueChanged\", \"sliderVerFunc\"];\n\t\t\t\
sliderVer@addAdjustmentListener[listen];\n\t\t\t\
okButton@addActionListener[JavaNew[\"com.wolfram.jlink.MathActionListener\",\n\
\t\t\t \"buttonFunc\"]];\n\t\t\ttok = ShareFrontEnd[];\n\t\t\t\
frame@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"]; \n\t\t\t\
frame@setLocation[200, 200];\n\t\t\tJavaShow[frame]\n\t\t];\n\t\tframe\n\t]\n\
\nsliderHorFunc[evt_, type_, scrollPos_] :=\n\tJavaBlock[\n\t    theta = \
(90-scrollPos)*Pi/45;\n\t    draw3D[];\n\t\tReleaseObject[evt]\n\t]\n\t\n\
sliderVerFunc[evt_, type_, scrollPos_] :=\n\tJavaBlock[\n\t    phi = \
scrollPos*Pi/45;\n\t    draw3D[];\t\t\n\t\tReleaseObject[evt]\n\t]\t\n\n\
draw3D[] :=\n\t\tBlock[{ $DisplayFunction = Identity, obj},\n\t\t\t\tobj = \
Show[expr, SphericalRegion->True,\n\t\t\t \t ViewPoint->{ rho Sin[phi] \
Cos[theta], rho Sin[phi] Sin[theta], rho  Cos[phi]}];\n\t\t\t\t\
drawArea@setMathCommand[ToString[obj, InputForm]];\n\t\t\t\t\
drawArea@repaintNow[]\n\t\t\t]\n\nbuttonFunc[event_, _] :=\n  JavaBlock[\n\t\t\
NotebookApply[SelectedNotebook[],\n\t\t  ToString[ViewPoint->{ rho Sin[phi] \
Cos[theta], rho Sin[phi] Sin[theta], rho  Cos[phi]},InputForm]];\n\t\t \
Show[expr, SphericalRegion->True,\n\t\t\t \t ViewPoint->{ rho Sin[phi] \
Cos[theta], rho Sin[phi] Sin[theta], rho  Cos[phi]}];  \n\t\t\
ReleaseJavaObject[event];\n\t\tEndModal[]; \n\t\tfrm@dispose[];\n\t]\n  \n\n\
SelectorViewPoint[text_] :=\n\tJavaBlock[\n\t\tBlock[{frm, lastScrollPos, \
rho, phi, theta, expr},\n\t\t    expr = text;\n\t\t    rho = 6.0; phi = Pi/3; \
theta = Pi/6;\n\t\t    frm = createWindow[];\n\t\t\tfrm@setModal[];\n\t\t\t\
DoModal[];\n\t\t\tfrm@dispose[];\n\t\t]\n\t]"
}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ilustraci\[OAcute]n de una corrida.", "Subsection"],

Cell["\<\
SelectorViewPoint recibe el resultado de un comando Plot3D o \
ParametricPlot3D, crea una ventana JAVA con barras que permiten girar el gr\
\[AAcute]fico a fin de buscar el mejor \[AAcute]ngulo desde el cual se quiere \
observarlo. Al presionar el bot\[OAcute]n Ok se obtiene el valor para el \
ViewPoint correspondiente al \[UAcute]ltimo gr\[AAcute]fico mostrado en la \
ventana. Si se desea que este resultado sea insertado en la l\[IAcute]nea de \
comando, debe moverse el punto de inserci\[OAcute]n al lugar apropiado en la \
l\[IAcute]nea de comando.   \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[{\((u + t)\) Sin[u] Cos[t], \ \((u + t)\) Sin[u] 
              Sin[t], \ \((u + t)\) Cos[u]}, \ {t, 0, 3  Pi/2}, \ {u, 0, 
            5  Pi/2}, \ PlotPoints -> 30, \ Boxed -> False, \ Axes -> False] // 
        SelectorViewPoint;\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.09165 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0587803 1.17789 -1.4718e-016 1.17789 [
[ 0 0 0 0 ]
[ 1 1.09165 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.09165 L
0 1.09165 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.71235 .53533 m .68597 .5457 L .70571 .61249 L p .577 .49 .72 r
F P
0 g
s
.68597 .5457 m .71235 .53533 L .6808 .47703 L p .582 .542 .775 r
F P
0 g
s
.6808 .47703 m .66143 .48379 L .68597 .5457 L p .582 .542 .775 r
F P
0 g
s
.53012 .73322 m .5773 .73393 L .57925 .78819 L p .684 .398 .483 r
F P
0 g
s
.5773 .73393 m .62349 .73048 L .62354 .78382 L p .641 .363 .482 r
F P
0 g
s
.62354 .78382 m .57925 .78819 L .5773 .73393 L p .641 .363 .482 r
F P
0 g
s
.48289 .72823 m .53012 .73322 L .53395 .78869 L p .724 .431 .481 r
F P
0 g
s
.57925 .78819 m .53395 .78869 L .53012 .73322 L p .684 .398 .483 r
F P
0 g
s
.73772 .59925 m .70571 .61249 L .71917 .68059 L p .557 .428 .659 r
F P
0 g
s
.70571 .61249 m .73772 .59925 L .71235 .53533 L p .577 .49 .72 r
F P
0 g
s
.62349 .73048 m .66781 .72304 L .66596 .77576 L p .594 .324 .477 r
F P
0 g
s
.66596 .77576 m .62354 .78382 L .62349 .73048 L p .594 .324 .477 r
F P
0 g
s
.43657 .71888 m .48289 .72823 L .48856 .78521 L p .763 .462 .475 r
F P
0 g
s
.53395 .78869 m .48856 .78521 L .48289 .72823 L p .724 .431 .481 r
F P
0 g
s
.66143 .48379 m .6808 .47703 L .64516 .42741 L p .553 .581 .837 r
F P
0 g
s
.64516 .42741 m .63366 .42998 L .66143 .48379 L p .553 .581 .837 r
F P
0 g
s
.66781 .72304 m .70938 .71186 L .70566 .76421 L p .54 .278 .467 r
F P
0 g
s
.70566 .76421 m .66596 .77576 L .66781 .72304 L p .54 .278 .467 r
F P
0 g
s
.73516 .5227 m .71235 .53533 L .73772 .59925 L p .539 .472 .729 r
F P
0 g
s
.71235 .53533 m .73516 .5227 L .69741 .46862 L p .552 .533 .788 r
F P
0 g
s
.69741 .46862 m .6808 .47703 L .71235 .53533 L p .552 .533 .788 r
F P
0 g
s
.39216 .70516 m .43657 .71888 L .44401 .77769 L p .803 .493 .465 r
F P
0 g
s
.48856 .78521 m .44401 .77769 L .43657 .71888 L p .763 .462 .475 r
F P
0 g
s
.71917 .68059 m .75493 .66538 L .73772 .59925 L p .557 .428 .659 r
F P
0 g
s
.76555 .58332 m .73772 .59925 L .75493 .66538 L p .51 .4 .664 r
F P
0 g
s
.73772 .59925 m .76555 .58332 L .73516 .5227 L p .539 .472 .729 r
F P
0 g
s
.725 .7461 m .76219 .72987 L .75898 .70135 L p .525 .348 .584 r
F P
0 g
s
.70938 .71186 m .74738 .6972 L .74661 .70449 L p .474 .222 .452 r
F P
0 g
s
.74485 .70494 m .70938 .71186 L .74661 .70449 L .474 .222 .452 r
F
.74661 .70449 m .725 .7461 L .75898 .70135 L .525 .348 .584 r
F
.74738 .6972 m .76962 .68545 L p .75042 .70118 L .388 .15 .427 r
F P
0 g
s
.78615 .64722 m .75493 .66538 L .75824 .69478 L p .463 .305 .58 r
F P
0 g
s
.75824 .69478 m .76219 .72987 L p .77404 .68897 L .463 .305 .58 r
F P
0 g
s
.78102 .67943 m .78002 .68667 L p .7607 .69387 L .388 .15 .427 r
F P
0 g
s
.78002 .68667 m .76219 .72987 L .79091 .68248 L .463 .305 .58 r
F
.76219 .72987 m .79471 .71066 L .79091 .68248 L p F P
0 g
s
.78102 .67943 m .79987 .6659 L p .78327 .68311 L .271 .051 .385 r
F P
0 g
s
.81213 .62655 m .78615 .64722 L .79004 .67608 L p .385 .251 .573 r
F P
0 g
s
.79004 .67608 m .79471 .71066 L p .80335 .66894 L .385 .251 .573 r
F P
0 g
s
.80955 .65894 m .80834 .66616 L p .79212 .67497 L .271 .051 .385 r
F P
0 g
s
.80834 .66616 m .79471 .71066 L .81751 .66106 L .385 .251 .573 r
F
.79471 .71066 m .82185 .68888 L .81751 .66106 L p F P
0 g
s
.82185 .68888 m .79471 .71066 L .78935 .76937 L p .268 .071 .417 r
F P
0 g
s
.78935 .76937 m .81553 .74791 L .82185 .68888 L p .268 .071 .417 r
F P
0 g
s
.84295 .66504 m .82185 .68888 L .81553 .74791 L p .1 0 .355 r
F P
0 g
s
.82209 .68954 m .80072 .71169 L .80834 .66616 L p .1 0 .314 r
F P
0 g
s
.80834 .66616 m .80955 .65894 L p .81097 .6624 L .1 0 .314 r
F P
0 g
s
.80955 .65894 m .82458 .64395 L p .81654 .65485 L .1 0 .314 r
F P
0 g
s
.81097 .6624 m .80998 .66 L .81654 .65485 L .1 0 .314 r
F
.80998 .66 m .80955 .65894 L .81654 .65485 L F
.83226 .60388 m .81213 .62655 L .81654 .65485 L p .277 .179 .559 r
F P
0 g
s
.81654 .65485 m .82185 .68888 L p .82702 .64663 L .277 .179 .559 r
F P
0 g
s
.80335 .66894 m .79212 .67497 L .80834 .66616 L .271 .051 .385 r
F
.78002 .68667 m .78102 .67943 L p .78327 .68311 L F P
0 g
s
.77404 .68897 m .7607 .69387 L .78002 .68667 L .388 .15 .427 r
F
.74661 .70449 m .74738 .6972 L p .75042 .70118 L F P
0 g
s
.71055 .71321 m .70938 .71186 L .74485 .70494 L .474 .222 .452 r
F
.7461 .70494 m .725 .7461 L .74661 .70449 L .525 .348 .584 r
F
.73978 .70623 m .73783 .71151 L .74628 .70458 L F
.73783 .71151 m .725 .7461 L .74628 .70458 L F
.73978 .70623 m .74485 .70494 L .7466 .7046 L .474 .222 .452 r
F
.71055 .71321 m .74485 .70494 L .73978 .70623 L F
.75898 .70135 m .75493 .66538 L p .73978 .70623 L .525 .348 .584 r
F P
0 g
s
.76962 .68545 m .78102 .67943 L p .75042 .70118 L .388 .15 .427 r
F P
0 g
s
.79091 .68248 m .78615 .64722 L p .77404 .68897 L .463 .305 .58 r
F P
0 g
s
.79987 .6659 m .80955 .65894 L p .78327 .68311 L .271 .051 .385 r
F P
0 g
s
.81213 .62655 m .80335 .66894 L .80809 .66631 L .385 .251 .573 r
F
.81751 .66106 m .81654 .65485 L p .80809 .66631 L F P
0 g
s
.81654 .65485 m .81213 .62655 L p .80809 .66631 L .385 .251 .573 r
F P
0 g
s
.82185 .68888 m .84295 .66504 L .83816 .63761 L p .277 .179 .559 r
F P
0 g
s
.83232 .63624 m .83093 .64346 L p .81765 .65421 L .1 0 .314 r
F P
0 g
s
.82458 .64395 m .83232 .63624 L p .81097 .6624 L .1 0 .314 r
F P
0 g
s
.83816 .63761 m .8371 .63159 L p .83288 .63956 L .277 .179 .559 r
F P
0 g
s
.83093 .64346 m .83232 .63624 L p .83288 .63956 L 0 0 .187 r
F P
0 g
s
.83288 .63956 m .83073 .64363 L .83093 .64346 L .277 .179 .559 r
F
.83288 .63956 m .83093 .64346 L .83816 .63761 L F
.82702 .64663 m .82185 .68888 L .83816 .63761 L F
.83735 .66587 m .82209 .68954 L .83093 .64346 L p 0 0 .187 r
F P
0 g
s
.83735 .66587 m .83093 .64346 L .83288 .63956 L 0 0 .187 r
F
.83232 .63624 m .84316 .62015 L p .83288 .63956 L F P
0 g
s
.84602 .57978 m .83226 .60388 L .8371 .63159 L p .122 .076 .528 r
F P
0 g
s
.83934 .64439 m .84295 .66504 L p .84426 .62862 L .122 .076 .528 r
F P
0 g
s
.84295 .66504 m .85747 .63969 L .8512 .60686 L p .122 .076 .528 r
F P
0 g
s
.851 .60747 m .84295 .66504 L .8512 .60686 L .122 .076 .528 r
F
.84875 .61185 m .85511 .59508 L p .8512 .60686 L 0 0 0 r
F P
0 g
s
.84846 .61512 m .84866 .61284 L .8512 .60686 L 0 0 0 r
F
.84866 .61284 m .84875 .61185 L .8512 .60686 L F
.85304 .55488 m .84602 .57978 L .8512 .60686 L p 0 0 .46 r
F P
0 g
s
.8512 .60686 m .85334 .61806 L p .85526 .59731 L 0 0 .46 r
F P
0 g
s
.85526 .59731 m .85334 .61806 L .85552 .60226 L 0 0 .46 r
F
.84426 .62862 m .84295 .66504 L .84983 .61582 L .122 .076 .528 r
F
.84426 .62862 m .84983 .61582 L .84734 .61895 L F
.84722 .6191 m .851 .60747 L .84846 .61512 L F
.84426 .62862 m .84734 .61895 L .84722 .6191 L F
.84734 .61895 m .851 .60747 L .84722 .6191 L F
.84875 .61185 m .84722 .6191 L p .83826 .63017 L 0 0 .187 r
F P
0 g
s
.84448 .62255 m .83826 .63017 L .84722 .6191 L 0 0 .187 r
F
.84722 .6191 m .84875 .61185 L p .84846 .61512 L 0 0 0 r
F P
0 g
s
.8371 .63159 m .83934 .64439 L p .84448 .62255 L .122 .076 .528 r
F P
0 g
s
.84316 .62015 m .84875 .61185 L p .83785 .63089 L 0 0 .187 r
F P
0 g
s
.85113 .60651 m .84602 .57978 L p .84448 .62255 L .122 .076 .528 r
F P
0 g
s
.84448 .62255 m .84426 .62862 L .84722 .6191 L .122 .076 .528 r
F
.84448 .62255 m .84722 .6191 L .85113 .60651 L F
.83288 .63956 m .83673 .6323 L .83785 .63089 L 0 0 .187 r
F
.83673 .6323 m .84316 .62015 L .83785 .63089 L F
.84722 .6191 m .84719 .61922 L p .84448 .62255 L F P
0 g
s
.84448 .62255 m .83934 .64439 L .84426 .62862 L .122 .076 .528 r
F
.84719 .61922 m .83735 .66587 L p .83825 .63038 L 0 0 .187 r
F P
0 g
s
.83825 .63038 m .83826 .63017 L .84448 .62255 L 0 0 .187 r
F
.83825 .63038 m .84448 .62255 L .84719 .61922 L F
.84734 .61895 m .84983 .61582 L .851 .60747 L .122 .076 .528 r
F
.84846 .61512 m .851 .60747 L .85113 .60651 L F
.85747 .63969 m .865 .61348 L .85959 .58695 L p 0 0 .46 r
F P
0 g
s
.8584 .58641 m .85677 .5937 L p .85157 .60613 L 0 0 0 r
F P
0 g
s
.85511 .59508 m .8584 .58641 L p .84846 .61512 L 0 0 0 r
F P
0 g
s
.85304 .55488 m .85668 .5939 L .85727 .58972 L 0 0 .46 r
F
.85844 .58131 m .85837 .58096 L p .85727 .58972 L F P
0 g
s
.85837 .58096 m .85304 .55488 L p .85727 .58972 L 0 0 .46 r
F P
0 g
s
.85526 .59731 m .85747 .63969 L .85959 .58695 L 0 0 .46 r
F
.84612 .64127 m .84846 .61512 L .85157 .60613 L 0 0 0 r
F
.85677 .5937 m .84612 .64127 L p .85157 .60613 L F P
0 g
s
.84612 .64127 m .84719 .61922 L .84845 .6152 L 0 0 0 r
F
.84814 .61637 m .84612 .64127 L .85677 .5937 L p .838 .779 .275 r
F P
0 g
s
.85677 .5937 m .8584 .58641 L p .85727 .58972 L .838 .779 .275 r
F P
0 g
s
.85304 .55488 m .85526 .59731 L .85668 .5939 L 0 0 .46 r
F
.85304 .55488 m .8512 .60686 L .85526 .59731 L F
.8584 .58641 m .8601 .5694 L p .85844 .58131 L .838 .779 .275 r
F P
0 g
s
.85727 .58972 m .85806 .5874 L .85844 .58131 L .838 .779 .275 r
F
.85806 .5874 m .8584 .58641 L .85844 .58131 L F
.85311 .52987 m .85304 .55488 L .85844 .58131 L p 0 0 .316 r
F P
0 g
s
.85311 .52987 m .85844 .58131 L .85904 .57157 L 0 0 .316 r
F
.85724 .5898 m .85727 .58972 L .86021 .56828 L .838 .779 .275 r
F
.8601 .5694 m .86021 .56828 L p .85727 .58972 L F P
0 g
s
.8512 .60686 m .85113 .60651 L p .851 .60747 L .122 .076 .528 r
F P
0 g
s
.84719 .61922 m .84722 .6191 L p .84845 .6152 L 0 0 0 r
F P
0 g
s
.84845 .6152 m .84722 .6191 L .84846 .61512 L 0 0 0 r
F
.84814 .61637 m .85724 .5898 L .85844 .5804 L .838 .779 .275 r
F
.85311 .52987 m .85904 .57157 L .85928 .56813 L 0 0 .316 r
F
.86098 .56059 m .85796 .5438 L p .8586 .55562 L .985 .84 .455 r
F P
0 g
s
.85905 .56401 m .86041 .56161 L .8586 .55562 L .985 .84 .455 r
F
.86041 .56161 m .86098 .56059 L .8586 .55562 L F
.85311 .52987 m .85928 .56813 L .85905 .56401 L 0 0 .316 r
F
.8586 .55562 m .85853 .55527 L p .85905 .56401 L F P
0 g
s
.85853 .55527 m .85311 .52987 L p .85905 .56401 L 0 0 .316 r
F P
0 g
s
.85929 .56793 m .86098 .56059 L p .85905 .56401 L .985 .84 .455 r
F P
0 g
s
.85976 .56106 m .8586 .55562 L p .85928 .56813 L 0 0 .316 r
F P
0 g
s
.84602 .57978 m .8371 .63159 L .84448 .62255 L .122 .076 .528 r
F
.84336 .59183 m .84814 .61637 L .85929 .56793 L p .985 .84 .455 r
F P
0 g
s
.84336 .59183 m .85929 .56793 L .85905 .56401 L .985 .84 .455 r
F
.85304 .55488 m .85311 .52987 L .82374 .48034 L p 0 .109 .643 r
F P
0 g
s
.81721 .4592 m .82374 .48034 L .85311 .52987 L p 0 0 .552 r
F P
0 g
s
.85311 .52987 m .84622 .50548 L .81721 .4592 L p 0 0 .552 r
F P
0 g
s
.84622 .50548 m .85311 .52987 L .8586 .55562 L p .761 .489 0 r
F P
0 g
s
.84622 .50548 m .8586 .55562 L .85774 .55279 L .761 .489 0 r
F
.84336 .59183 m .85905 .56401 L .85822 .55496 L .985 .84 .455 r
F
.84336 .59183 m .85822 .55496 L .85805 .55435 L F
.84602 .57978 m .85304 .55488 L .82409 .50215 L p .141 .209 .673 r
F P
0 g
s
.82374 .48034 m .82409 .50215 L .85304 .55488 L p 0 .109 .643 r
F P
0 g
s
.85467 .54262 m .84336 .59183 L p .85814 .55412 L .985 .84 .455 r
F P
0 g
s
.85796 .5438 m .8564 .53511 L p .85905 .56401 L .985 .84 .455 r
F P
0 g
s
.85929 .56793 m .85844 .5804 L .86074 .56245 L .838 .779 .275 r
F
.8606 .56225 m .85929 .56793 L p .86074 .56245 L F P
0 g
s
.86021 .56828 m .86098 .56059 L p .85724 .5898 L .838 .779 .275 r
F P
0 g
s
.865 .61348 m .8653 .58708 L .85976 .56106 L p 0 0 .316 r
F P
0 g
s
.85904 .57157 m .865 .61348 L .85976 .56106 L 0 0 .316 r
F
.83226 .60388 m .84602 .57978 L .81822 .52396 L p .28 .278 .679 r
F P
0 g
s
.82409 .50215 m .81822 .52396 L .84602 .57978 L p .141 .209 .673 r
F P
0 g
s
.82374 .48034 m .81721 .4592 L .77526 .42471 L p .037 .313 .8 r
F P
0 g
s
.76467 .40948 m .77526 .42471 L .81721 .4592 L p 0 .252 .759 r
F P
0 g
s
.81721 .4592 m .80472 .43938 L .76467 .40948 L p 0 .252 .759 r
F P
0 g
s
.80472 .43938 m .81721 .4592 L .84622 .50548 L p .602 .184 0 r
F P
0 g
s
.84622 .50548 m .83256 .48243 L .80472 .43938 L p .602 .184 0 r
F P
0 g
s
.83256 .48243 m .84622 .50548 L .85166 .53052 L p .928 .589 .141 r
F P
0 g
s
.83195 .56834 m .85375 .53871 L .85093 .52994 L .994 .806 .543 r
F
.85054 .52934 m .85093 .52994 L .85066 .52909 L F
.83195 .56834 m .85093 .52994 L .85054 .52934 L F
.84309 .51826 m .83195 .56834 L p .85066 .52909 L F P
0 g
s
.84622 .50548 m .85571 .54605 L .85476 .54269 L .761 .489 0 r
F
.83195 .56834 m .84336 .59183 L .8547 .54249 L p .994 .806 .543 r
F P
0 g
s
.85375 .53871 m .85476 .54269 L .8547 .54249 L .761 .489 0 r
F
.85166 .53052 m .84622 .50548 L p .85476 .54269 L F P
0 g
s
.84622 .50548 m .85774 .55279 L .85571 .54605 L .761 .489 0 r
F
.8547 .54249 m .8564 .53511 L p .85375 .53871 L .994 .806 .543 r
F P
0 g
s
.83195 .56834 m .8547 .54249 L .85375 .53871 L .994 .806 .543 r
F
.83256 .48243 m .85166 .53052 L .84533 .52146 L .928 .589 .141 r
F
.84874 .51903 m .84477 .5107 L p .85375 .53871 L .994 .806 .543 r
F P
0 g
s
.8528 .53574 m .85166 .53052 L p .85375 .53871 L .761 .489 0 r
F P
0 g
s
.85375 .53871 m .8547 .54249 L .8528 .53574 L .761 .489 0 r
F
.81822 .52396 m .80628 .54516 L .83226 .60388 L p .28 .278 .679 r
F P
0 g
s
.81822 .52396 m .82409 .50215 L .78181 .45826 L p .293 .388 .789 r
F P
0 g
s
.78105 .44115 m .78181 .45826 L .82409 .50215 L p .182 .356 .803 r
F P
0 g
s
.82409 .50215 m .82374 .48034 L .78105 .44115 L p .182 .356 .803 r
F P
0 g
s
.77526 .42471 m .78105 .44115 L .82374 .48034 L p .037 .313 .8 r
F P
0 g
s
.81258 .46142 m .83256 .48243 L .83782 .50672 L p .949 .596 .288 r
F P
0 g
s
.81427 .54655 m .84149 .51456 L .83678 .50627 L .957 .749 .581 r
F
.83615 .50571 m .83678 .50627 L .8363 .50543 L F
.81427 .54655 m .83678 .50627 L .83615 .50571 L F
.82488 .49569 m .81427 .54655 L p .8363 .50543 L F P
0 g
s
.83256 .48243 m .84533 .52146 L .84325 .51832 L .928 .589 .141 r
F
.81427 .54655 m .83195 .56834 L .84312 .51812 L p .957 .749 .581 r
F P
0 g
s
.84149 .51456 m .84325 .51832 L .84312 .51812 L .928 .589 .141 r
F
.83782 .50672 m .83256 .48243 L p .84325 .51832 L F P
0 g
s
.84312 .51812 m .84477 .5107 L p .84149 .51456 L .957 .749 .581 r
F P
0 g
s
.81427 .54655 m .84312 .51812 L .84149 .51456 L .957 .749 .581 r
F
.81258 .46142 m .83782 .50672 L .82823 .49855 L .949 .596 .288 r
F
.83271 .49582 m .82646 .48811 L p .84149 .51456 L .957 .749 .581 r
F P
0 g
s
.8389 .51175 m .83782 .50672 L p .84149 .51456 L .928 .589 .141 r
F P
0 g
s
.84149 .51456 m .84312 .51812 L .8389 .51175 L .928 .589 .141 r
F
.84429 .53666 m .8236 .5141 L .81852 .48978 L p .949 .596 .288 r
F P
0 g
s
.81852 .48978 m .81258 .46142 L p .82823 .49855 L .949 .596 .288 r
F P
0 g
s
.82646 .48811 m .82488 .49569 L p .8363 .50543 L .957 .749 .581 r
F P
0 g
s
.82823 .49855 m .84429 .53666 L .81852 .48978 L .949 .596 .288 r
F
.83782 .50672 m .84429 .53666 L p .82823 .49855 L F P
0 g
s
.84477 .5107 m .83271 .49582 L p .84149 .51456 L .957 .749 .581 r
F P
0 g
s
.85834 .56123 m .84429 .53666 L .8389 .51175 L p .928 .589 .141 r
F P
0 g
s
.84477 .5107 m .84309 .51826 L p .85066 .52909 L .994 .806 .543 r
F P
0 g
s
.84533 .52146 m .85834 .56123 L .8389 .51175 L .928 .589 .141 r
F
.85166 .53052 m .85834 .56123 L p .84533 .52146 L F P
0 g
s
.8564 .53511 m .84874 .51903 L p .85375 .53871 L .994 .806 .543 r
F P
0 g
s
.8653 .58708 m .85834 .56123 L .8528 .53574 L p .761 .489 0 r
F P
0 g
s
.8564 .53511 m .85467 .54262 L p .85814 .55412 L .985 .84 .455 r
F P
0 g
s
.85571 .54605 m .8653 .58708 L .8528 .53574 L .761 .489 0 r
F
.85805 .55435 m .85822 .55496 L .85814 .55412 L .985 .84 .455 r
F
.85571 .54605 m .85976 .56106 L .85895 .55992 L .761 .489 0 r
F
.85774 .55279 m .85976 .56106 L .85571 .54605 L F
.8586 .55562 m .85976 .56106 L p .85774 .55279 L F P
0 g
s
.85976 .56106 m .8653 .58708 L p .85895 .55992 L .761 .489 0 r
F P
0 g
s
.86098 .56059 m .8606 .56225 L p .86074 .56245 L .838 .779 .275 r
F P
0 g
s
.85929 .56793 m .84814 .61637 L p .85844 .5804 L .838 .779 .275 r
F P
0 g
s
.85844 .58131 m .865 .61348 L p .85904 .57157 L 0 0 .316 r
F P
0 g
s
.85959 .58695 m .85844 .58131 L p .85668 .5939 L 0 0 .46 r
F P
0 g
s
.85724 .5898 m .85677 .5937 L .85727 .58972 L .838 .779 .275 r
F
.84814 .61637 m .85675 .59375 L .85724 .5898 L F
.85675 .59375 m .85677 .5937 L .85724 .5898 L F
.85334 .61806 m .85747 .63969 L p .85552 .60226 L 0 0 .46 r
F P
0 g
s
.84612 .64127 m .83735 .66587 L .84719 .61922 L p 0 0 0 r
F P
0 g
s
.83735 .66587 m .83288 .63956 L .83826 .63017 L 0 0 .187 r
F
.83226 .60388 m .82702 .64663 L .83073 .64363 L .277 .179 .559 r
F
.8371 .63159 m .83226 .60388 L p .83073 .64363 L F P
0 g
s
.82209 .68954 m .81097 .6624 L .81765 .65421 L .1 0 .314 r
F
.83093 .64346 m .82209 .68954 L p .81765 .65421 L F P
0 g
s
.83226 .60388 m .81654 .65485 L .82702 .64663 L .277 .179 .559 r
F
.82209 .68954 m .80834 .66616 L .81097 .6624 L .1 0 .314 r
F
.80809 .66631 m .80797 .6667 L .80834 .66616 L .385 .251 .573 r
F
.80797 .6667 m .79471 .71066 L .80834 .66616 L F
.80335 .66894 m .80226 .67421 L .80809 .66631 L F
.80226 .67421 m .79471 .71066 L .80809 .66631 L F
.80834 .66616 m .80832 .66628 L p .80335 .66894 L .271 .051 .385 r
F P
0 g
s
.81213 .62655 m .79004 .67608 L .80335 .66894 L .385 .251 .573 r
F
.80072 .71169 m .78327 .68311 L .79212 .67497 L .271 .051 .385 r
F
.80832 .66628 m .80072 .71169 L p .79212 .67497 L F P
0 g
s
.79471 .71066 m .76219 .72987 L .75795 .78842 L p .383 .164 .452 r
F P
0 g
s
.75795 .78842 m .78935 .76937 L .79471 .71066 L p .383 .164 .452 r
F P
0 g
s
.80072 .71169 m .77377 .73181 L .78002 .68667 L p .271 .051 .385 r
F P
0 g
s
.80072 .71169 m .78002 .68667 L .78327 .68311 L .271 .051 .385 r
F
.77972 .68678 m .77957 .68716 L .78002 .68667 L .463 .305 .58 r
F
.77957 .68716 m .76219 .72987 L .78002 .68667 L F
.77404 .68897 m .77251 .69426 L .77972 .68678 L F
.77251 .69426 m .76219 .72987 L .77972 .68678 L F
.78002 .68667 m .78 .68678 L p .77404 .68897 L .388 .15 .427 r
F P
0 g
s
.78615 .64722 m .75824 .69478 L .77404 .68897 L .463 .305 .58 r
F
.77377 .73181 m .75042 .70118 L .7607 .69387 L .388 .15 .427 r
F
.78 .68678 m .77377 .73181 L p .7607 .69387 L F P
0 g
s
.76219 .72987 m .725 .7461 L .72202 .80468 L p .468 .232 .473 r
F P
0 g
s
.72202 .80468 m .75795 .78842 L .76219 .72987 L p .468 .232 .473 r
F P
0 g
s
.77377 .73181 m .74185 .74945 L .74661 .70449 L p .388 .15 .427 r
F P
0 g
s
.77377 .73181 m .74661 .70449 L .75042 .70118 L .388 .15 .427 r
F
.74628 .70458 m .7461 .70494 L .74661 .70449 L .525 .348 .584 r
F
.74661 .70449 m .7466 .7046 L p .74485 .70494 L .474 .222 .452 r
F P
0 g
s
.72183 .71051 m .725 .7461 L p .73978 .70623 L .525 .348 .584 r
F P
0 g
s
.7466 .7046 m .74185 .74945 L p .71055 .71321 L .474 .222 .452 r
F P
0 g
s
.75493 .66538 m .71917 .68059 L .72183 .71051 L p .525 .348 .584 r
F P
0 g
s
.75493 .66538 m .72183 .71051 L .73978 .70623 L .525 .348 .584 r
F
.6808 .47703 m .69741 .46862 L .65494 .42386 L p .526 .582 .854 r
F P
0 g
s
.65494 .42386 m .64516 .42741 L .6808 .47703 L p .526 .582 .854 r
F P
0 g
s
.74185 .74945 m .70566 .76421 L .70938 .71186 L p .474 .222 .452 r
F P
0 g
s
.75387 .50821 m .73516 .5227 L .76555 .58332 L p .495 .454 .741 r
F P
0 g
s
.73516 .5227 m .75387 .50821 L .71091 .45886 L p .518 .526 .803 r
F P
0 g
s
.71091 .45886 m .69741 .46862 L .73516 .5227 L p .518 .526 .803 r
F P
0 g
s
.63366 .42998 m .64516 .42741 L .60772 .38909 L p .035 .345 .823 r
F P
0 g
s
.60772 .38909 m .6044 .38719 L .63366 .42998 L p .035 .345 .823 r
F P
0 g
s
.35072 .68711 m .39216 .70516 L .40127 .7661 L p .844 .525 .448 r
F P
0 g
s
.44401 .77769 m .40127 .7661 L .39216 .70516 L p .803 .493 .465 r
F P
0 g
s
.69741 .46862 m .71091 .45886 L .66279 .41954 L p .497 .585 .874 r
F P
0 g
s
.66279 .41954 m .65494 .42386 L .69741 .46862 L p .497 .585 .874 r
F P
0 g
s
.75493 .66538 m .78615 .64722 L .76555 .58332 L p .51 .4 .664 r
F P
0 g
s
.78858 .56512 m .76555 .58332 L .78615 .64722 L p .452 .367 .67 r
F P
0 g
s
.76555 .58332 m .78858 .56512 L .75387 .50821 L p .495 .454 .741 r
F P
0 g
s
.64516 .42741 m .65494 .42386 L .61051 .39071 L p 0 .275 .766 r
F P
0 g
s
.61051 .39071 m .60772 .38909 L .64516 .42741 L p 0 .275 .766 r
F P
0 g
s
.53395 .78869 m .57925 .78819 L .58238 .82655 L p .631 .261 .323 r
F P
0 g
s
.57925 .78819 m .62354 .78382 L .6217 .82146 L p .577 .215 .318 r
F P
0 g
s
.6217 .82146 m .58238 .82655 L .57925 .78819 L p .577 .215 .318 r
F P
0 g
s
.65494 .42386 m .66279 .41954 L .61274 .39213 L p 0 .185 .639 r
F P
0 g
s
.61274 .39213 m .61051 .39071 L .65169 .42143 L p 0 .185 .639 r
F P
0 g
s
.65169 .42143 m .65298 .42239 L p .65119 .42104 L 0 .185 .639 r
F P
0 g
s
.61274 .39213 m .65169 .42143 L .65119 .42104 L 0 .185 .639 r
F
.61274 .39213 m .65298 .42239 L .65143 .42121 L F
.61435 .39343 m .61274 .39213 L .65921 .41758 L p .483 0 0 r
F P
0 g
s
.61435 .39343 m .65921 .41758 L .65863 .41728 L .483 0 0 r
F
.61435 .39343 m .66063 .41836 L .65884 .41741 L F
.65921 .41758 m .66063 .41836 L p .65863 .41728 L F P
0 g
s
.66063 .41836 m .66279 .41954 L p .65884 .41741 L .483 0 0 r
F P
0 g
s
.66279 .41954 m .66856 .41469 L .61528 .39379 L p .483 0 0 r
F P
0 g
s
.6159 .39426 m .66279 .41954 L .61528 .39379 L .483 0 0 r
F
.61528 .39379 m .61435 .39343 L p .6159 .39426 L F P
0 g
s
.61534 .39466 m .61435 .39343 L .66856 .41469 L p .549 0 0 r
F P
0 g
s
.66856 .41469 m .67215 .40954 L .61755 .39524 L p .549 0 0 r
F P
0 g
s
.6182 .39573 m .66856 .41469 L .61755 .39524 L .549 0 0 r
F
.61755 .39524 m .61534 .39466 L p .6182 .39573 L F P
0 g
s
.61569 .3959 m .61534 .39466 L .66979 .40892 L p .558 0 0 r
F P
0 g
s
.66979 .40892 m .67215 .40954 L p .66772 .40847 L .558 0 0 r
F P
0 g
s
.61569 .3959 m .66979 .40892 L .66772 .40847 L .558 0 0 r
F
.67215 .40954 m .67351 .40434 L .61794 .39623 L p F P
0 g
s
.61872 .39663 m .67215 .40954 L .61794 .39623 L .558 0 0 r
F
.61794 .39623 m .61569 .3959 L p .61872 .39663 L F P
0 g
s
.61543 .39722 m .61569 .3959 L .67351 .40434 L p .533 0 0 r
F P
0 g
s
.67351 .40434 m .67269 .39932 L .6164 .39725 L p .533 0 0 r
F P
0 g
s
.6164 .39725 m .61543 .39722 L p .61728 .39745 L .533 0 0 r
F P
0 g
s
.61728 .39745 m .67351 .40434 L .6164 .39725 L .533 0 0 r
F
.65298 .42239 m .65494 .42386 L p .65143 .42121 L 0 .185 .639 r
F P
0 g
s
.721 .44813 m .71091 .45886 L .75387 .50821 L p .48 .521 .822 r
F P
0 g
s
.71091 .45886 m .721 .44813 L .66856 .41469 L p .465 .592 .896 r
F P
0 g
s
.66856 .41469 m .66279 .41954 L .71091 .45886 L p .465 .592 .896 r
F P
0 g
s
.48856 .78521 m .53395 .78869 L .5421 .82829 L p .679 .299 .319 r
F P
0 g
s
.58238 .82655 m .5421 .82829 L .53395 .78869 L p .631 .261 .323 r
F P
0 g
s
.76808 .49232 m .75387 .50821 L .78858 .56512 L p .443 .435 .755 r
F P
0 g
s
.75387 .50821 m .76808 .49232 L .721 .44813 L p .48 .521 .822 r
F P
0 g
s
.62354 .78382 m .66596 .77576 L .65928 .81316 L p .514 .159 .302 r
F P
0 g
s
.65928 .81316 m .6217 .82146 L .62354 .78382 L p .514 .159 .302 r
F P
0 g
s
.31333 .66486 m .35072 .68711 L .36139 .75052 L p .887 .557 .42 r
F P
0 g
s
.40127 .7661 m .36139 .75052 L .35072 .68711 L p .844 .525 .448 r
F P
0 g
s
.44401 .77769 m .48856 .78521 L .5017 .82657 L p .723 .331 .305 r
F P
0 g
s
.5421 .82829 m .5017 .82657 L .48856 .78521 L p .679 .299 .319 r
F P
0 g
s
.66596 .77576 m .70566 .76421 L .69433 .80185 L p .436 .087 .274 r
F P
0 g
s
.69433 .80185 m .65928 .81316 L .66596 .77576 L p .436 .087 .274 r
F P
0 g
s
.78615 .64722 m .81213 .62655 L .78858 .56512 L p .452 .367 .67 r
F P
0 g
s
.80628 .54516 m .78858 .56512 L .81213 .62655 L p .379 .328 .675 r
F P
0 g
s
.78858 .56512 m .80628 .54516 L .76808 .49232 L p .443 .435 .755 r
F P
0 g
s
.57085 .36419 m .5755 .35789 L .6044 .38719 L p .848 .808 .811 r
F P
0 g
s
.6044 .38719 m .60772 .38909 L .57085 .36419 L p .848 .808 .811 r
F P
0 g
s
.72748 .4368 m .721 .44813 L .76808 .49232 L p .436 .517 .843 r
F P
0 g
s
.721 .44813 m .72748 .4368 L .67215 .40954 L p .43 .603 .919 r
F P
0 g
s
.67215 .40954 m .66856 .41469 L .721 .44813 L p .43 .603 .919 r
F P
0 g
s
.40127 .7661 m .44401 .77769 L .46206 .82135 L p .765 .357 .279 r
F P
0 g
s
.5017 .82657 m .46206 .82135 L .44401 .77769 L p .723 .331 .305 r
F P
0 g
s
.60772 .38909 m .61051 .39071 L .56699 .3709 L p .835 .774 .793 r
F P
0 g
s
.56699 .3709 m .57085 .36419 L .60772 .38909 L p .835 .774 .793 r
F P
0 g
s
.77746 .47549 m .76808 .49232 L .80628 .54516 L p .377 .414 .772 r
F P
0 g
s
.76808 .49232 m .77746 .47549 L .72748 .4368 L p .436 .517 .843 r
F P
0 g
s
.70566 .76421 m .74185 .74945 L .72614 .78778 L p .334 0 .227 r
F P
0 g
s
.72614 .78778 m .69433 .80185 L .70566 .76421 L p .334 0 .227 r
F P
0 g
s
.61051 .39071 m .61274 .39213 L .56401 .3779 L p .82 .741 .778 r
F P
0 g
s
.56401 .3779 m .56699 .3709 L .61051 .39071 L p .82 .741 .778 r
F P
0 g
s
.61274 .39213 m .61435 .39343 L .56194 .38509 L p .802 .712 .765 r
F P
0 g
s
.56194 .38509 m .56401 .3779 L .61274 .39213 L p .802 .712 .765 r
F P
0 g
s
.67351 .40434 m .67215 .40954 L .72748 .4368 L p .395 .619 .941 r
F P
0 g
s
.28113 .63862 m .31333 .66486 L .3254 .73105 L p .928 .589 .375 r
F P
0 g
s
.36139 .75052 m .3254 .73105 L .31333 .66486 L p .887 .557 .42 r
F P
0 g
s
.73024 .42526 m .72748 .4368 L .77746 .47549 L p .384 .516 .867 r
F P
0 g
s
.72748 .4368 m .73024 .42526 L .67351 .40434 L p .395 .619 .941 r
F P
0 g
s
.55887 .48077 m .56939 .486 L .55851 .52576 L p .712 .599 .729 r
F P
0 g
s
.55851 .52576 m .5431 .52038 L .55887 .48077 L p .712 .599 .729 r
F P
0 g
s
.5739 .52949 m .55851 .52576 L .56939 .486 L p .687 .578 .728 r
F P
0 g
s
.5431 .52038 m .55851 .52576 L .55145 .56389 L p .734 .58 .682 r
F P
0 g
s
.55851 .52576 m .5739 .52949 L .57011 .56689 L p .705 .554 .679 r
F P
0 g
s
.57011 .56689 m .55145 .56389 L .55851 .52576 L p .705 .554 .679 r
F P
0 g
s
.61435 .39343 m .61534 .39466 L .56081 .39237 L p .784 .684 .754 r
F P
0 g
s
.56081 .39237 m .56194 .38509 L .61435 .39343 L p .784 .684 .754 r
F P
0 g
s
.36139 .75052 m .40127 .7661 L .42409 .81262 L p .804 .378 .236 r
F P
0 g
s
.46206 .82135 m .42409 .81262 L .40127 .7661 L p .765 .357 .279 r
F P
0 g
s
.54868 .47437 m .55887 .48077 L .5431 .52038 L p .735 .622 .732 r
F P
0 g
s
.5431 .52038 m .5281 .51331 L .54868 .47437 L p .735 .622 .732 r
F P
0 g
s
.5281 .51331 m .5431 .52038 L .53268 .55892 L p .763 .607 .685 r
F P
0 g
s
.55145 .56389 m .53268 .55892 L .5431 .52038 L p .734 .58 .682 r
F P
0 g
s
.56939 .486 m .57995 .4901 L .5739 .52949 L p .687 .578 .728 r
F P
0 g
s
.58885 .53165 m .5739 .52949 L .57995 .4901 L p .66 .558 .729 r
F P
0 g
s
.5739 .52949 m .58885 .53165 L .58815 .56802 L p .675 .528 .678 r
F P
0 g
s
.58815 .56802 m .57011 .56689 L .5739 .52949 L p .675 .528 .678 r
F P
0 g
s
.81213 .62655 m .83226 .60388 L .80628 .54516 L p .379 .328 .675 r
F P
0 g
s
.53914 .46682 m .54868 .47437 L .5281 .51331 L p .758 .646 .737 r
F P
0 g
s
.5281 .51331 m .51397 .50456 L .53914 .46682 L p .758 .646 .737 r
F P
0 g
s
.51397 .50456 m .5281 .51331 L .51433 .55191 L p .791 .637 .69 r
F P
0 g
s
.53268 .55892 m .51433 .55191 L .5281 .51331 L p .763 .607 .685 r
F P
0 g
s
.80628 .54516 m .81822 .52396 L .77746 .47549 L p .377 .414 .772 r
F P
0 g
s
.57995 .4901 m .59025 .4931 L .58885 .53165 L p .66 .558 .729 r
F P
0 g
s
.60298 .53238 m .58885 .53165 L .59025 .4931 L p .631 .538 .731 r
F P
0 g
s
.58885 .53165 m .60298 .53238 L .60512 .56744 L p .642 .503 .679 r
F P
0 g
s
.60512 .56744 m .58815 .56802 L .58885 .53165 L p .642 .503 .679 r
F P
0 g
s
.57525 .43794 m .5794 .44292 L .55887 .48077 L p .69 .611 .763 r
F P
0 g
s
.55887 .48077 m .54868 .47437 L .57525 .43794 L p .69 .611 .763 r
F P
0 g
s
.56939 .486 m .55887 .48077 L .5794 .44292 L p .668 .594 .764 r
F P
0 g
s
.53268 .55892 m .55145 .56389 L .54835 .59792 L p .745 .543 .621 r
F P
0 g
s
.55145 .56389 m .57011 .56689 L .56861 .59988 L p .711 .513 .619 r
F P
0 g
s
.56861 .59988 m .54835 .59792 L .55145 .56389 L p .711 .513 .619 r
F P
0 g
s
.5794 .44292 m .58372 .44743 L .56939 .486 L p .668 .594 .764 r
F P
0 g
s
.57995 .4901 m .56939 .486 L .58372 .44743 L p .644 .578 .766 r
F P
0 g
s
.57011 .56689 m .58815 .56802 L .58811 .59986 L p .675 .482 .618 r
F P
0 g
s
.58811 .59986 m .56861 .59988 L .57011 .56689 L p .675 .482 .618 r
F P
0 g
s
.61534 .39466 m .61569 .3959 L .5606 .39962 L p .764 .659 .746 r
F P
0 g
s
.5606 .39962 m .56081 .39237 L .61534 .39466 L p .764 .659 .746 r
F P
0 g
s
.57139 .4325 m .57525 .43794 L .54868 .47437 L p .71 .629 .765 r
F P
0 g
s
.54868 .47437 m .53914 .46682 L .57139 .4325 L p .71 .629 .765 r
F P
0 g
s
.74185 .74945 m .77377 .73181 L .75404 .77126 L p .193 0 .151 r
F P
0 g
s
.75404 .77126 m .72614 .78778 L .74185 .74945 L p .193 0 .151 r
F P
0 g
s
.58372 .44743 m .58806 .45147 L .57995 .4901 L p .644 .578 .766 r
F P
0 g
s
.59025 .4931 m .57995 .4901 L .58806 .45147 L p .617 .563 .77 r
F P
0 g
s
.51433 .55191 m .53268 .55892 L .52786 .59383 L p .779 .575 .623 r
F P
0 g
s
.54835 .59792 m .52786 .59383 L .53268 .55892 L p .745 .543 .621 r
F P
0 g
s
.58815 .56802 m .60512 .56744 L .60636 .59801 L p .635 .451 .616 r
F P
0 g
s
.60636 .59801 m .58811 .59986 L .58815 .56802 L p .635 .451 .616 r
F P
0 g
s
.56795 .42661 m .57139 .4325 L .53914 .46682 L p .73 .649 .768 r
F P
0 g
s
.53914 .46682 m .53057 .45816 L .56795 .42661 L p .73 .649 .768 r
F P
0 g
s
.53057 .45816 m .53914 .46682 L .51397 .50456 L p .781 .672 .744 r
F P
0 g
s
.59025 .4931 m .60002 .4951 L .60298 .53238 L p .631 .538 .731 r
F P
0 g
s
.61594 .53181 m .60298 .53238 L .60002 .4951 L p .598 .519 .736 r
F P
0 g
s
.60298 .53238 m .61594 .53181 L .62061 .56535 L p .605 .477 .68 r
F P
0 g
s
.62061 .56535 m .60512 .56744 L .60298 .53238 L p .605 .477 .68 r
F P
0 g
s
.51397 .50456 m .50117 .49416 L .53057 .45816 L p .781 .672 .744 r
F P
0 g
s
.50117 .49416 m .51397 .50456 L .49693 .54287 L p .819 .669 .697 r
F P
0 g
s
.51433 .55191 m .49693 .54287 L .51397 .50456 L p .791 .637 .69 r
F P
0 g
s
.58806 .45147 m .59232 .45506 L .59025 .4931 L p .617 .563 .77 r
F P
0 g
s
.60002 .4951 m .59025 .4931 L .59232 .45506 L p .588 .548 .777 r
F P
0 g
s
.67269 .39932 m .67351 .40434 L .73024 .42526 L p .36 .638 .96 r
F P
0 g
s
.78181 .45826 m .77746 .47549 L .81822 .52396 L p .293 .388 .789 r
F P
0 g
s
.77746 .47549 m .78181 .45826 L .73024 .42526 L p .384 .516 .867 r
F P
0 g
s
.61569 .3959 m .61543 .39722 L .56128 .40676 L p .743 .635 .74 r
F P
0 g
s
.56128 .40676 m .5606 .39962 L .61569 .3959 L p .743 .635 .74 r
F P
0 g
s
.49693 .54287 m .51433 .55191 L .50772 .58755 L p .813 .609 .626 r
F P
0 g
s
.52786 .59383 m .50772 .58755 L .51433 .55191 L p .779 .575 .623 r
F P
0 g
s
.56504 .42033 m .56795 .42661 L .53057 .45816 L p .748 .669 .774 r
F P
0 g
s
.53057 .45816 m .52327 .44847 L .56504 .42033 L p .748 .669 .774 r
F P
0 g
s
.52327 .44847 m .53057 .45816 L .50117 .49416 L p .802 .7 .753 r
F P
0 g
s
.60512 .56744 m .62061 .56535 L .62292 .59455 L p .591 .416 .613 r
F P
0 g
s
.62292 .59455 m .60636 .59801 L .60512 .56744 L p .591 .416 .613 r
F P
0 g
s
.59232 .45506 m .59637 .45824 L .60002 .4951 L p .588 .548 .777 r
F P
0 g
s
.60902 .49619 m .60002 .4951 L .59637 .45824 L p .554 .533 .787 r
F P
0 g
s
.60002 .4951 m .60902 .49619 L .61594 .53181 L p .598 .519 .736 r
F P
0 g
s
.62744 .53014 m .61594 .53181 L .60902 .49619 L p .561 .499 .743 r
F P
0 g
s
.61594 .53181 m .62744 .53014 L .63427 .56195 L p .562 .449 .683 r
F P
0 g
s
.63427 .56195 m .62061 .56535 L .61594 .53181 L p .562 .449 .683 r
F P
0 g
s
.50117 .49416 m .49015 .48222 L .52327 .44847 L p .802 .7 .753 r
F P
0 g
s
.49015 .48222 m .50117 .49416 L .48106 .53181 L p .848 .706 .705 r
F P
0 g
s
.49693 .54287 m .48106 .53181 L .50117 .49416 L p .819 .669 .697 r
F P
0 g
s
.61458 .39868 m .61543 .39722 L .67269 .39932 L p .487 0 0 r
F P
0 g
s
.61543 .39722 m .61458 .39868 L .56278 .41368 L p .722 .613 .735 r
F P
0 g
s
.56278 .41368 m .56128 .40676 L .61543 .39722 L p .722 .613 .735 r
F P
0 g
s
.56278 .41368 m .56504 .42033 L .52327 .44847 L p .765 .691 .781 r
F P
0 g
s
.52327 .44847 m .51753 .43785 L .56278 .41368 L p .765 .691 .781 r
F P
0 g
s
.51753 .43785 m .52327 .44847 L .49015 .48222 L p .823 .732 .764 r
F P
0 g
s
.6132 .40034 m .61134 .40225 L .56795 .42661 L p .675 .572 .731 r
F P
0 g
s
.56795 .42661 m .56504 .42033 L .6132 .40034 L p .675 .572 .731 r
F P
0 g
s
.57139 .4325 m .56795 .42661 L .61134 .40225 L p .649 .552 .732 r
F P
0 g
s
.61134 .40225 m .60909 .40446 L .57139 .4325 L p .649 .552 .732 r
F P
0 g
s
.57525 .43794 m .57139 .4325 L .60909 .40446 L p .62 .533 .734 r
F P
0 g
s
.61458 .39868 m .6132 .40034 L .56504 .42033 L p .699 .592 .732 r
F P
0 g
s
.56504 .42033 m .56278 .41368 L .61458 .39868 L p .699 .592 .732 r
F P
0 g
s
.60909 .40446 m .60653 .40698 L .57525 .43794 L p .62 .533 .734 r
F P
0 g
s
.5794 .44292 m .57525 .43794 L .60653 .40698 L p .588 .514 .738 r
F P
0 g
s
.56128 .40676 m .56278 .41368 L .51753 .43785 L p .781 .715 .791 r
F P
0 g
s
.48106 .53181 m .49693 .54287 L .48854 .57906 L p .849 .646 .628 r
F P
0 g
s
.50772 .58755 m .48854 .57906 L .49693 .54287 L p .813 .609 .626 r
F P
0 g
s
.72927 .41391 m .73024 .42526 L .78181 .45826 L p .323 .517 .891 r
F P
0 g
s
.73024 .42526 m .72927 .41391 L .67269 .39932 L p .36 .638 .96 r
F P
0 g
s
.54835 .59792 m .56861 .59988 L .5693 .62649 L p .701 .448 .539 r
F P
0 g
s
.56861 .59988 m .58811 .59986 L .58869 .62526 L p .658 .412 .536 r
F P
0 g
s
.58869 .62526 m .5693 .62649 L .56861 .59988 L p .658 .412 .536 r
F P
0 g
s
.52786 .59383 m .54835 .59792 L .54906 .62577 L p .742 .484 .539 r
F P
0 g
s
.5693 .62649 m .54906 .62577 L .54835 .59792 L p .701 .448 .539 r
F P
0 g
s
.75795 .78842 m .72202 .80468 L .70929 .85157 L p .351 .032 .276 r
F P
0 g
s
.60653 .40698 m .60375 .40984 L .5794 .44292 L p .588 .514 .738 r
F P
0 g
s
.58372 .44743 m .5794 .44292 L .60375 .40984 L p .551 .493 .744 r
F P
0 g
s
.5606 .39962 m .56128 .40676 L .5136 .42647 L p .795 .741 .803 r
F P
0 g
s
.51753 .43785 m .5136 .42647 L .56128 .40676 L p .781 .715 .791 r
F P
0 g
s
.59637 .45824 m .60012 .46105 L .60902 .49619 L p .554 .533 .787 r
F P
0 g
s
.61704 .4965 m .60902 .49619 L .60012 .46105 L p .513 .519 .799 r
F P
0 g
s
.60902 .49619 m .61704 .4965 L .62744 .53014 L p .561 .499 .743 r
F P
0 g
s
.62061 .56535 m .63427 .56195 L .63743 .58973 L p .539 .377 .61 r
F P
0 g
s
.63743 .58973 m .62292 .59455 L .62061 .56535 L p .539 .377 .61 r
F P
0 g
s
.56081 .39237 m .5606 .39962 L .51172 .4145 L p .807 .768 .817 r
F P
0 g
s
.5136 .42647 m .51172 .4145 L .5606 .39962 L p .795 .741 .803 r
F P
0 g
s
.60375 .40984 m .60083 .41306 L .58372 .44743 L p .551 .493 .744 r
F P
0 g
s
.58806 .45147 m .58372 .44743 L .60083 .41306 L p .507 .472 .752 r
F P
0 g
s
.58811 .59986 m .60636 .59801 L .60671 .62224 L p .61 .371 .53 r
F P
0 g
s
.60671 .62224 m .58869 .62526 L .58811 .59986 L p .61 .371 .53 r
F P
0 g
s
.50772 .58755 m .52786 .59383 L .52848 .62294 L p .782 .519 .538 r
F P
0 g
s
.54906 .62577 m .52848 .62294 L .52786 .59383 L p .742 .484 .539 r
F P
0 g
s
.67269 .39932 m .66976 .39473 L .61458 .39868 L p .487 0 0 r
F P
0 g
s
.6132 .40034 m .61458 .39868 L .66761 .39488 L p .422 0 0 r
F P
0 g
s
.6132 .40034 m .66761 .39488 L .66558 .39514 L .422 0 0 r
F
.66761 .39488 m .66976 .39473 L p .66558 .39514 L F P
0 g
s
.66976 .39473 m .66487 .39076 L .6132 .40034 L p .422 0 0 r
F P
0 g
s
.61134 .40225 m .6132 .40034 L .66119 .39145 L p .335 0 0 r
F P
0 g
s
.66119 .39145 m .66169 .39135 L p .661 .3915 L .335 0 0 r
F P
0 g
s
.61134 .40225 m .66119 .39145 L .661 .3915 L .335 0 0 r
F
.61134 .40225 m .66169 .39135 L .66106 .39153 L F
.61134 .40225 m .66291 .39113 L .661 .3916 L F
.66169 .39135 m .66291 .39113 L p .66106 .39153 L F P
0 g
s
.66291 .39113 m .66487 .39076 L p .661 .3916 L .335 0 0 r
F P
0 g
s
.66487 .39076 m .65823 .38763 L .61215 .402 L p .335 0 0 r
F P
0 g
s
.61306 .40189 m .66487 .39076 L .61215 .402 L .335 0 0 r
F
.61215 .402 m .61134 .40225 L p .61306 .40189 L F P
0 g
s
.60909 .40446 m .61134 .40225 L .655 .38864 L p .221 0 0 r
F P
0 g
s
.655 .38864 m .65823 .38763 L p .65384 .38914 L .221 0 0 r
F P
0 g
s
.60909 .40446 m .655 .38864 L .65384 .38914 L .221 0 0 r
F
.6501 .38549 m .61791 .40137 L p .65823 .38763 L F P
0 g
s
.6098 .40413 m .60909 .40446 L p .61067 .40392 L .221 0 0 r
F P
0 g
s
.61067 .40392 m .65823 .38763 L .6098 .40413 L .221 0 0 r
F
.60653 .40698 m .60909 .40446 L .6501 .38549 L p .068 0 0 r
F P
0 g
s
.60787 .4061 m .60653 .40698 L p .60888 .40582 L .068 0 0 r
F P
0 g
s
.64076 .38447 m .61252 .40383 L p .6501 .38549 L .068 0 0 r
F P
0 g
s
.60888 .40582 m .6501 .38549 L .60787 .4061 L .068 0 0 r
F
.60375 .40984 m .60653 .40698 L .64076 .38447 L p 0 0 0 r
F P
0 g
s
.63055 .38465 m .61981 .38608 L .6021 .41125 L p 0 0 0 r
F P
0 g
s
.6021 .41125 m .60083 .41306 L p .60323 .41077 L 0 0 0 r
F P
0 g
s
.64076 .38447 m .63055 .38465 L .60554 .40816 L p 0 0 0 r
F P
0 g
s
.60554 .40816 m .60375 .40984 L p .60672 .40781 L 0 0 0 r
F P
0 g
s
.60672 .40781 m .64076 .38447 L .60554 .40816 L 0 0 0 r
F
.60083 .41306 m .60375 .40984 L .63055 .38465 L p F P
0 g
s
.60323 .41077 m .63055 .38465 L .6021 .41125 L 0 0 0 r
F
.56194 .38509 m .56081 .39237 L .51205 .40216 L p .816 .796 .833 r
F P
0 g
s
.51172 .4145 m .51205 .40216 L .56081 .39237 L p .807 .768 .817 r
F P
0 g
s
.66976 .39473 m .67269 .39932 L .72927 .41391 L p .329 .662 .973 r
F P
0 g
s
.63722 .52757 m .62744 .53014 L .61704 .4965 L p .516 .477 .752 r
F P
0 g
s
.62744 .53014 m .63722 .52757 L .64583 .55749 L p .51 .418 .686 r
F P
0 g
s
.64583 .55749 m .63427 .56195 L .62744 .53014 L p .51 .418 .686 r
F P
0 g
s
.5136 .42647 m .51753 .43785 L .48136 .46888 L p .842 .767 .779 r
F P
0 g
s
.49015 .48222 m .48136 .46888 L .51753 .43785 L p .823 .732 .764 r
F P
0 g
s
.60083 .41306 m .59788 .41663 L .58806 .45147 L p .507 .472 .752 r
F P
0 g
s
.59232 .45506 m .58806 .45147 L .59788 .41663 L p .452 .447 .762 r
F P
0 g
s
.56401 .3779 m .56194 .38509 L .51473 .38968 L p .821 .826 .852 r
F P
0 g
s
.51205 .40216 m .51473 .38968 L .56194 .38509 L p .816 .796 .833 r
F P
0 g
s
.48136 .46888 m .49015 .48222 L .46729 .51886 L p .877 .748 .716 r
F P
0 g
s
.48106 .53181 m .46729 .51886 L .49015 .48222 L p .848 .706 .705 r
F P
0 g
s
.56699 .3709 m .56401 .3779 L .51981 .37734 L p .821 .855 .873 r
F P
0 g
s
.51473 .38968 m .51981 .37734 L .56401 .3779 L p .821 .826 .852 r
F P
0 g
s
.3254 .73105 m .36139 .75052 L .38871 .80046 L p .835 .389 .167 r
F P
0 g
s
.42409 .81262 m .38871 .80046 L .36139 .75052 L p .804 .378 .236 r
F P
0 g
s
.60012 .46105 m .60347 .46354 L .61704 .4965 L p .513 .519 .799 r
F P
0 g
s
.6239 .49618 m .61704 .4965 L .60347 .46354 L p .464 .504 .814 r
F P
0 g
s
.61704 .4965 m .6239 .49618 L .63722 .52757 L p .516 .477 .752 r
F P
0 g
s
.60636 .59801 m .62292 .59455 L .62295 .61765 L p .554 .323 .52 r
F P
0 g
s
.62295 .61765 m .60671 .62224 L .60636 .59801 L p .554 .323 .52 r
F P
0 g
s
.57085 .36419 m .56699 .3709 L .52727 .36541 L p .813 .883 .896 r
F P
0 g
s
.51981 .37734 m .52727 .36541 L .56699 .3709 L p .821 .855 .873 r
F P
0 g
s
.5421 .82829 m .58238 .82655 L .5865 .84606 L p .463 0 0 r
F P
0 g
s
.58238 .82655 m .6217 .82146 L .61806 .84051 L p .383 0 0 r
F P
0 g
s
.61806 .84051 m .5865 .84606 L .58238 .82655 L p .383 0 0 r
F P
0 g
s
.59788 .41663 m .59498 .42053 L .59232 .45506 L p .452 .447 .762 r
F P
0 g
s
.59637 .45824 m .59232 .45506 L .59498 .42053 L p .381 .418 .774 r
F P
0 g
s
.5755 .35789 m .57085 .36419 L .53702 .35418 L p .796 .907 .918 r
F P
0 g
s
.52727 .36541 m .53702 .35418 L .57085 .36419 L p .813 .883 .896 r
F P
0 g
s
.48854 .57906 m .50772 .58755 L .50817 .61793 L p .823 .555 .534 r
F P
0 g
s
.52848 .62294 m .50817 .61793 L .50772 .58755 L p .782 .519 .538 r
F P
0 g
s
.53702 .35418 m .54888 .34393 L .5755 .35789 L p .796 .907 .918 r
F P
0 g
s
.46729 .51886 m .48106 .53181 L .47095 .56837 L p .886 .689 .63 r
F P
0 g
s
.48854 .57906 m .47095 .56837 L .48106 .53181 L p .849 .646 .628 r
F P
0 g
s
.77377 .73181 m .80072 .71169 L .77742 .75263 L p 0 0 .03 r
F P
0 g
s
.77742 .75263 m .75404 .77126 L .77377 .73181 L p 0 0 .03 r
F P
0 g
s
.5017 .82657 m .5421 .82829 L .55413 .84895 L p .525 .018 0 r
F P
0 g
s
.5865 .84606 m .55413 .84895 L .5421 .82829 L p .463 0 0 r
F P
0 g
s
.63427 .56195 m .64583 .55749 L .64957 .58382 L p .474 .33 .605 r
F P
0 g
s
.64957 .58382 m .63743 .58973 L .63427 .56195 L p .474 .33 .605 r
F P
0 g
s
.6217 .82146 m .65928 .81316 L .64812 .83242 L p .279 0 0 r
F P
0 g
s
.64812 .83242 m .61806 .84051 L .6217 .82146 L p .279 0 0 r
F P
0 g
s
.59498 .42053 m .59222 .42474 L .59637 .45824 L p .381 .418 .774 r
F P
0 g
s
.60012 .46105 m .59637 .45824 L .59222 .42474 L p .285 .379 .784 r
F P
0 g
s
.51172 .4145 m .5136 .42647 L .4752 .45435 L p .86 .805 .796 r
F P
0 g
s
.48136 .46888 m .4752 .45435 L .5136 .42647 L p .842 .767 .779 r
F P
0 g
s
.64512 .52431 m .63722 .52757 L .6239 .49618 L p .461 .453 .763 r
F P
0 g
s
.63722 .52757 m .64512 .52431 L .65505 .55226 L p .445 .38 .69 r
F P
0 g
s
.65505 .55226 m .64583 .55749 L .63722 .52757 L p .445 .38 .69 r
F P
0 g
s
.62292 .59455 m .63743 .58973 L .63704 .61175 L p .484 .265 .505 r
F P
0 g
s
.63704 .61175 m .62295 .61765 L .62292 .59455 L p .484 .265 .505 r
F P
0 g
s
.60347 .46354 m .60635 .46576 L .6239 .49618 L p .464 .504 .814 r
F P
0 g
s
.62947 .49537 m .6239 .49618 L .60635 .46576 L p .401 .487 .833 r
F P
0 g
s
.6239 .49618 m .62947 .49537 L .64512 .52431 L p .461 .453 .763 r
F P
0 g
s
.25527 .60872 m .28113 .63862 L .29443 .70792 L p .956 .614 .297 r
F P
0 g
s
.3254 .73105 m .29443 .70792 L .28113 .63862 L p .928 .589 .375 r
F P
0 g
s
.59222 .42474 m .58967 .42925 L .60012 .46105 L p .285 .379 .784 r
F P
0 g
s
.60347 .46354 m .60012 .46105 L .58967 .42925 L p .149 .325 .785 r
F P
0 g
s
.72927 .41391 m .72467 .40317 L .66976 .39473 L p .329 .662 .973 r
F P
0 g
s
.66487 .39076 m .66976 .39473 L .72467 .40317 L p .308 .689 .977 r
F P
0 g
s
.47095 .56837 m .48854 .57906 L .48873 .6107 L p .866 .595 .525 r
F P
0 g
s
.50817 .61793 m .48873 .6107 L .48854 .57906 L p .823 .555 .534 r
F P
0 g
s
.4752 .45435 m .48136 .46888 L .45616 .50417 L p .905 .795 .728 r
F P
0 g
s
.46729 .51886 m .45616 .50417 L .48136 .46888 L p .877 .748 .716 r
F P
0 g
s
.46206 .82135 m .5017 .82657 L .52166 .84909 L p .573 .052 0 r
F P
0 g
s
.55413 .84895 m .52166 .84909 L .5017 .82657 L p .525 .018 0 r
F P
0 g
s
.78181 .45826 m .78105 .44115 L .72927 .41391 L p .323 .517 .891 r
F P
0 g
s
.65928 .81316 m .69433 .80185 L .67604 .82197 L p .14 0 0 r
F P
0 g
s
.67604 .82197 m .64812 .83242 L .65928 .81316 L p .14 0 0 r
F P
0 g
s
.51205 .40216 m .51172 .4145 L .47204 .43888 L p .873 .847 .816 r
F P
0 g
s
.4752 .45435 m .47204 .43888 L .51172 .4145 L p .86 .805 .796 r
F P
0 g
s
.72467 .40317 m .72927 .41391 L .78105 .44115 L p .253 .521 .911 r
F P
0 g
s
.58967 .42925 m .5874 .434 L .60347 .46354 L p .149 .325 .785 r
F P
0 g
s
.60635 .46576 m .60347 .46354 L .5874 .434 L p 0 .241 .756 r
F P
0 g
s
.70929 .85157 m .74102 .8363 L .75795 .78842 L p .351 .032 .276 r
F P
0 g
s
.78935 .76937 m .75795 .78842 L .74102 .8363 L p .221 0 .213 r
F P
0 g
s
.54906 .62577 m .5693 .62649 L .57194 .64528 L p .664 .339 .413 r
F P
0 g
s
.5693 .62649 m .58869 .62526 L .58977 .64288 L p .609 .291 .406 r
F P
0 g
s
.58977 .64288 m .57194 .64528 L .5693 .62649 L p .609 .291 .406 r
F P
0 g
s
.64583 .55749 m .65505 .55226 L .65915 .57711 L p .386 .268 .595 r
F P
0 g
s
.65915 .57711 m .64957 .58382 L .64583 .55749 L p .386 .268 .595 r
F P
0 g
s
.52848 .62294 m .54906 .62577 L .5532 .64588 L p .714 .381 .413 r
F P
0 g
s
.57194 .64528 m .5532 .64588 L .54906 .62577 L p .664 .339 .413 r
F P
0 g
s
.45616 .50417 m .46729 .51886 L .45556 .5556 L p .925 .738 .63 r
F P
0 g
s
.47095 .56837 m .45556 .5556 L .46729 .51886 L p .886 .689 .63 r
F P
0 g
s
.60635 .46576 m .60871 .46778 L .62947 .49537 L p .401 .487 .833 r
F P
0 g
s
.63367 .49424 m .62947 .49537 L .60871 .46778 L p .318 .467 .851 r
F P
0 g
s
.62947 .49537 m .63367 .49424 L .65099 .52061 L p .388 .424 .777 r
F P
0 g
s
.65099 .52061 m .64512 .52431 L .62947 .49537 L p .388 .424 .777 r
F P
0 g
s
.58869 .62526 m .60671 .62224 L .60623 .63886 L p .544 .232 .39 r
F P
0 g
s
.60623 .63886 m .58977 .64288 L .58869 .62526 L p .544 .232 .39 r
F P
0 g
s
.63743 .58973 m .64957 .58382 L .6487 .60482 L p .39 .187 .48 r
F P
0 g
s
.6487 .60482 m .63704 .61175 L .63743 .58973 L p .39 .187 .48 r
F P
0 g
s
.64512 .52431 m .65099 .52061 L .66182 .54653 L p .356 .331 .693 r
F P
0 g
s
.66182 .54653 m .65505 .55226 L .64512 .52431 L p .356 .331 .693 r
F P
0 g
s
.5874 .434 m .58546 .43895 L .60635 .46576 L p 0 .241 .756 r
F P
0 g
s
.60871 .46778 m .60635 .46576 L .58546 .43895 L p 0 .118 .654 r
F P
0 g
s
.50817 .61793 m .52848 .62294 L .53406 .64455 L p .761 .419 .405 r
F P
0 g
s
.5532 .64588 m .53406 .64455 L .52848 .62294 L p .714 .381 .413 r
F P
0 g
s
.60671 .62224 m .62295 .61765 L .62093 .63342 L p .461 .156 .361 r
F P
0 g
s
.62093 .63342 m .60623 .63886 L .60671 .62224 L p .461 .156 .361 r
F P
0 g
s
.51473 .38968 m .51205 .40216 L .47217 .42278 L p .878 .892 .838 r
F P
0 g
s
.47204 .43888 m .47217 .42278 L .51205 .40216 L p .873 .847 .816 r
F P
0 g
s
.72467 .40317 m .71665 .39341 L .66487 .39076 L p .308 .689 .977 r
F P
0 g
s
.65823 .38763 m .66487 .39076 L .71665 .39341 L p .303 .721 .974 r
F P
0 g
s
.45556 .5556 m .47095 .56837 L .47081 .60128 L p .911 .638 .51 r
F P
0 g
s
.48873 .6107 m .47081 .60128 L .47095 .56837 L p .866 .595 .525 r
F P
0 g
s
.47204 .43888 m .4752 .45435 L .44821 .48796 L p .93 .85 .741 r
F P
0 g
s
.45616 .50417 m .44821 .48796 L .4752 .45435 L p .905 .795 .728 r
F P
0 g
s
.58546 .43895 m .5839 .44407 L .60871 .46778 L p 0 .118 .654 r
F P
0 g
s
.60871 .46778 m .61051 .46968 L .63367 .49424 L p .318 .467 .851 r
F P
0 g
s
.61051 .46968 m .60871 .46778 L .5839 .44407 L p .54 .028 0 r
F P
0 g
s
.42409 .81262 m .46206 .82135 L .48983 .84647 L p .608 .069 0 r
F P
0 g
s
.52166 .84909 m .48983 .84647 L .46206 .82135 L p .573 .052 0 r
F P
0 g
s
.59788 .41663 m .60083 .41306 L .61981 .38608 L p .655 .887 .535 r
F P
0 g
s
.69433 .80185 m .72614 .78778 L .70123 .80936 L p 0 0 0 r
F P
0 g
s
.70123 .80936 m .67604 .82197 L .69433 .80185 L p 0 0 0 r
F P
0 g
s
.48873 .6107 m .50817 .61793 L .51508 .64119 L p .808 .455 .388 r
F P
0 g
s
.53406 .64455 m .51508 .64119 L .50817 .61793 L p .761 .419 .405 r
F P
0 g
s
.63645 .49295 m .63367 .49424 L .61051 .46968 L p .205 .437 .863 r
F P
0 g
s
.63367 .49424 m .63645 .49295 L .6548 .51671 L p .288 .387 .79 r
F P
0 g
s
.6548 .51671 m .65099 .52061 L .63367 .49424 L p .288 .387 .79 r
F P
0 g
s
.65505 .55226 m .66182 .54653 L .66602 .56992 L p .259 .18 .573 r
F P
0 g
s
.66602 .56992 m .65915 .57711 L .65505 .55226 L p .259 .18 .573 r
F P
0 g
s
.61981 .38608 m .60889 .38876 L .59788 .41663 L p .655 .887 .535 r
F P
0 g
s
.59498 .42053 m .59788 .41663 L .60889 .38876 L p .849 .968 .648 r
F P
0 g
s
.62295 .61765 m .63704 .61175 L .63354 .62682 L p .349 .052 .312 r
F P
0 g
s
.63354 .62682 m .62093 .63342 L .62295 .61765 L p .349 .052 .312 r
F P
0 g
s
.64957 .58382 m .65915 .57711 L .65773 .59716 L p .253 .075 .435 r
F P
0 g
s
.65773 .59716 m .6487 .60482 L .64957 .58382 L p .253 .075 .435 r
F P
0 g
s
.65099 .52061 m .6548 .51671 L .66607 .54058 L p .228 .261 .688 r
F P
0 g
s
.66607 .54058 m .66182 .54653 L .65099 .52061 L p .228 .261 .688 r
F P
0 g
s
.5839 .44407 m .58273 .44929 L .61051 .46968 L p .54 .028 0 r
F P
0 g
s
.61173 .47151 m .61051 .46968 L .58273 .44929 L p .687 .147 0 r
F P
0 g
s
.61051 .46968 m .61173 .47151 L .63645 .49295 L p .205 .437 .863 r
F P
0 g
s
.47277 .54623 m .48553 .55789 L .50698 .53 L p .821 .706 .737 r
F P
0 g
s
.50698 .53 m .49662 .51939 L .47277 .54623 L p .821 .706 .737 r
F P
0 g
s
.49662 .51939 m .50698 .53 L .53231 .50802 L p .766 .677 .764 r
F P
0 g
s
.51981 .37734 m .51473 .38968 L .47583 .40639 L p .871 .935 .86 r
F P
0 g
s
.47217 .42278 m .47583 .40639 L .51473 .38968 L p .878 .892 .838 r
F P
0 g
s
.44821 .48796 m .45616 .50417 L .44301 .54091 L p .963 .795 .626 r
F P
0 g
s
.45556 .5556 m .44301 .54091 L .45616 .50417 L p .925 .738 .63 r
F P
0 g
s
.60889 .38876 m .59812 .39266 L .59498 .42053 L p .849 .968 .648 r
F P
0 g
s
.59222 .42474 m .59498 .42053 L .59812 .39266 L p .941 .963 .702 r
F P
0 g
s
.80072 .71169 m .82209 .68954 L .79576 .73232 L p 0 0 0 r
F P
0 g
s
.79576 .73232 m .77742 .75263 L .80072 .71169 L p 0 0 0 r
F P
0 g
s
.53231 .50802 m .52484 .49903 L .49662 .51939 L p .766 .677 .764 r
F P
0 g
s
.52484 .49903 m .53231 .50802 L .55913 .49294 L p .703 .612 .752 r
F P
0 g
s
.29443 .70792 m .3254 .73105 L .3569 .78499 L p .845 .382 .057 r
F P
0 g
s
.38871 .80046 m .3569 .78499 L .3254 .73105 L p .835 .389 .167 r
F P
0 g
s
.59812 .39266 m .58782 .39771 L .59222 .42474 L p .941 .963 .702 r
F P
0 g
s
.58967 .42925 m .59222 .42474 L .58782 .39771 L p .963 .914 .715 r
F P
0 g
s
.78105 .44115 m .77526 .42471 L .72467 .40317 L p .253 .521 .911 r
F P
0 g
s
.71665 .39341 m .72467 .40317 L .77526 .42471 L p .177 .525 .92 r
F P
0 g
s
.71665 .39341 m .70553 .38497 L .65823 .38763 L p .303 .721 .974 r
F P
0 g
s
.6501 .38549 m .65823 .38763 L .70553 .38497 L p .318 .757 .967 r
F P
0 g
s
.63782 .49168 m .63645 .49295 L .61173 .47151 L p .048 .39 .85 r
F P
0 g
s
.63645 .49295 m .63782 .49168 L .65656 .51283 L p .144 .331 .793 r
F P
0 g
s
.65656 .51283 m .6548 .51671 L .63645 .49295 L p .144 .331 .793 r
F P
0 g
s
.58273 .44929 m .58198 .45458 L .61173 .47151 L p .687 .147 0 r
F P
0 g
s
.61237 .47335 m .61173 .47151 L .58198 .45458 L p .733 .213 0 r
F P
0 g
s
.61173 .47151 m .61237 .47335 L .63782 .49168 L p .048 .39 .85 r
F P
0 g
s
.47081 .60128 m .48873 .6107 L .49684 .63577 L p .854 .489 .358 r
F P
0 g
s
.51508 .64119 m .49684 .63577 L .48873 .6107 L p .808 .455 .388 r
F P
0 g
s
.58782 .39771 m .5783 .40378 L .58967 .42925 L p .963 .914 .715 r
F P
0 g
s
.5874 .434 m .58967 .42925 L .5783 .40378 L p .95 .853 .711 r
F P
0 g
s
.47081 .60128 m .45506 .58976 L .45556 .5556 L p .911 .638 .51 r
F P
0 g
s
.45588 .57814 m .4703 .5901 L .48553 .55789 L p .87 .711 .682 r
F P
0 g
s
.48553 .55789 m .47277 .54623 L .45588 .57814 L p .87 .711 .682 r
F P
0 g
s
.48832 .50738 m .49662 .51939 L .52484 .49903 L p .788 .704 .772 r
F P
0 g
s
.52484 .49903 m .51885 .48904 L .48832 .50738 L p .788 .704 .772 r
F P
0 g
s
.51885 .48904 m .52484 .49903 L .55477 .48597 L p .727 .635 .756 r
F P
0 g
s
.55913 .49294 m .55477 .48597 L .52484 .49903 L p .703 .612 .752 r
F P
0 g
s
.5783 .40378 m .56978 .41075 L .5874 .434 L p .95 .853 .711 r
F P
0 g
s
.58546 .43895 m .5874 .434 L .56978 .41075 L p .923 .794 .701 r
F P
0 g
s
.63704 .61175 m .6487 .60482 L .64381 .61933 L p .184 0 .227 r
F P
0 g
s
.64381 .61933 m .63354 .62682 L .63704 .61175 L p .184 0 .227 r
F P
0 g
s
.47217 .42278 m .47204 .43888 L .4439 .47054 L p .946 .909 .752 r
F P
0 g
s
.44821 .48796 m .4439 .47054 L .47204 .43888 L p .93 .85 .741 r
F P
0 g
s
.44301 .54091 m .45556 .5556 L .45506 .58976 L p .956 .685 .482 r
F P
0 g
s
.55477 .48597 m .55913 .49294 L .58513 .4852 L p .632 .47 .646 r
F P
0 g
s
.56978 .41075 m .56248 .41845 L .58546 .43895 L p .923 .794 .701 r
F P
0 g
s
.5839 .44407 m .58546 .43895 L .56248 .41845 L p .891 .742 .69 r
F P
0 g
s
.52727 .36541 m .51981 .37734 L .48313 .39011 L p .843 .971 .879 r
F P
0 g
s
.47583 .40639 m .48313 .39011 L .51981 .37734 L p .871 .935 .86 r
F P
0 g
s
.66182 .54653 m .66607 .54058 L .67015 .56256 L p .06 .044 .523 r
F P
0 g
s
.67015 .56256 m .66602 .56992 L .66182 .54653 L p .06 .044 .523 r
F P
0 g
s
.46254 .53289 m .47277 .54623 L .49662 .51939 L p .848 .743 .747 r
F P
0 g
s
.49662 .51939 m .48832 .50738 L .46254 .53289 L p .848 .743 .747 r
F P
0 g
s
.74102 .8363 m .76868 .81863 L .78935 .76937 L p .221 0 .213 r
F P
0 g
s
.81553 .74791 m .78935 .76937 L .76868 .81863 L p .033 0 .111 r
F P
0 g
s
.56248 .41845 m .55654 .42672 L .5839 .44407 L p .891 .742 .69 r
F P
0 g
s
.58273 .44929 m .5839 .44407 L .55654 .42672 L p .859 .697 .68 r
F P
0 g
s
.55477 .48597 m .55126 .47841 L .51885 .48904 L p .727 .635 .756 r
F P
0 g
s
.55126 .47841 m .55477 .48597 L .58387 .4804 L p .669 .5 .648 r
F P
0 g
s
.58513 .4852 m .58387 .4804 L .55477 .48597 L p .632 .47 .646 r
F P
0 g
s
.58198 .45458 m .58163 .45988 L .61237 .47335 L p .733 .213 0 r
F P
0 g
s
.61246 .47525 m .61237 .47335 L .58163 .45988 L p .725 .24 .092 r
F P
0 g
s
.63784 .49056 m .63782 .49168 L .61237 .47335 L p 0 .313 .778 r
F P
0 g
s
.62853 .48494 m .63784 .49056 L p .63158 .48633 L 0 .313 .778 r
F P
0 g
s
.61237 .47335 m .61246 .47525 L .62853 .48494 L p 0 .313 .778 r
F P
0 g
s
.63158 .48633 m .61237 .47335 L .62853 .48494 L 0 .313 .778 r
F
.63659 .48975 m .63784 .49056 L .61246 .47525 L p 0 .207 .619 r
F P
0 g
s
.63422 .48937 m .63659 .48975 L .6151 .47883 L p .49 0 0 r
F P
0 g
s
.6151 .47883 m .61204 .47728 L p .61384 .47826 L .49 0 0 r
F P
0 g
s
.63422 .48937 m .6151 .47883 L .61384 .47826 L .49 0 0 r
F
.65915 .57711 m .66602 .56992 L .66403 .58909 L p .038 0 .347 r
F P
0 g
s
.66403 .58909 m .65773 .59716 L .65915 .57711 L p .038 0 .347 r
F P
0 g
s
.6548 .51671 m .65656 .51283 L .66785 .53472 L p .029 .153 .66 r
F P
0 g
s
.66785 .53472 m .66607 .54058 L .6548 .51671 L p .029 .153 .66 r
F P
0 g
s
.55654 .42672 m .55206 .43537 L .58273 .44929 L p .859 .697 .68 r
F P
0 g
s
.58198 .45458 m .58273 .44929 L .55206 .43537 L p .828 .657 .672 r
F P
0 g
s
.5532 .64588 m .57194 .64528 L .57612 .65545 L p .55 .123 .182 r
F P
0 g
s
.57194 .64528 m .58977 .64288 L .59122 .65203 L p .466 .045 .155 r
F P
0 g
s
.59122 .65203 m .57612 .65545 L .57194 .64528 L p .466 .045 .155 r
F P
0 g
s
.72614 .78778 m .75404 .77126 L .72316 .79485 L p 0 0 0 r
F P
0 g
s
.72316 .79485 m .70123 .80936 L .72614 .78778 L p 0 0 0 r
F P
0 g
s
.55206 .43537 m .54907 .44423 L .58198 .45458 L p .828 .657 .672 r
F P
0 g
s
.58163 .45988 m .58198 .45458 L .54907 .44423 L p .796 .622 .665 r
F P
0 g
s
.51465 .47817 m .51885 .48904 L .55126 .47841 L p .749 .659 .762 r
F P
0 g
s
.55126 .47841 m .54879 .47034 L .51465 .47817 L p .749 .659 .762 r
F P
0 g
s
.54879 .47034 m .55126 .47841 L .58284 .47544 L p .703 .529 .651 r
F P
0 g
s
.58387 .4804 m .58284 .47544 L .55126 .47841 L p .669 .5 .648 r
F P
0 g
s
.53406 .64455 m .5532 .64588 L .56014 .65734 L p .618 .181 .188 r
F P
0 g
s
.57612 .65545 m .56014 .65734 L .5532 .64588 L p .55 .123 .182 r
F P
0 g
s
.58977 .64288 m .60623 .63886 L .60504 .64725 L p .355 0 .101 r
F P
0 g
s
.60504 .64725 m .59122 .65203 L .58977 .64288 L p .355 0 .101 r
F P
0 g
s
.70553 .38497 m .69172 .37817 L .6501 .38549 L p .318 .757 .967 r
F P
0 g
s
.64076 .38447 m .6501 .38549 L .69172 .37817 L p .358 .798 .96 r
F P
0 g
s
.48251 .49418 m .48832 .50738 L .51885 .48904 L p .809 .735 .783 r
F P
0 g
s
.51885 .48904 m .51465 .47817 L .48251 .49418 L p .809 .735 .783 r
F P
0 g
s
.38871 .80046 m .42409 .81262 L .45941 .84109 L p .623 .066 0 r
F P
0 g
s
.48983 .84647 m .45941 .84109 L .42409 .81262 L p .608 .069 0 r
F P
0 g
s
.54907 .44423 m .54758 .45312 L .58163 .45988 L p .796 .622 .665 r
F P
0 g
s
.58168 .46515 m .58163 .45988 L .54758 .45312 L p .766 .589 .659 r
F P
0 g
s
.58163 .45988 m .58168 .46515 L .61246 .47525 L p .725 .24 .092 r
F P
0 g
s
.63782 .49168 m .63784 .49056 L .65635 .50921 L p 0 .243 .758 r
F P
0 g
s
.65635 .50921 m .65656 .51283 L .63782 .49168 L p 0 .243 .758 r
F P
0 g
s
.54758 .45312 m .54752 .46187 L .58168 .46515 L p .766 .589 .659 r
F P
0 g
s
.58209 .47035 m .58168 .46515 L .54752 .46187 L p .735 .559 .654 r
F P
0 g
s
.58168 .46515 m .58209 .47035 L .61204 .47728 L p .694 .243 .176 r
F P
0 g
s
.61204 .47728 m .61246 .47525 L .58168 .46515 L p .694 .243 .176 r
F P
0 g
s
.51252 .4666 m .51465 .47817 L .54879 .47034 L p .77 .686 .77 r
F P
0 g
s
.54879 .47034 m .54752 .46187 L .51252 .4666 L p .77 .686 .77 r
F P
0 g
s
.54752 .46187 m .54879 .47034 L .58209 .47035 L p .735 .559 .654 r
F P
0 g
s
.58284 .47544 m .58209 .47035 L .54879 .47034 L p .703 .529 .651 r
F P
0 g
s
.58209 .47035 m .58284 .47544 L .61114 .47948 L p .654 .231 .23 r
F P
0 g
s
.61114 .47948 m .61204 .47728 L .58209 .47035 L p .654 .231 .23 r
F P
0 g
s
.61246 .47525 m .61204 .47728 L .63659 .48975 L p 0 .207 .619 r
F P
0 g
s
.51508 .64119 m .53406 .64455 L .54373 .65757 L p .675 .224 .175 r
F P
0 g
s
.56014 .65734 m .54373 .65757 L .53406 .64455 L p .618 .181 .188 r
F P
0 g
s
.53702 .35418 m .52727 .36541 L .49409 .37437 L p .784 .99 .887 r
F P
0 g
s
.48313 .39011 m .49409 .37437 L .52727 .36541 L p .843 .971 .879 r
F P
0 g
s
.60623 .63886 m .62093 .63342 L .61725 .64129 L p .196 0 .008 r
F P
0 g
s
.61725 .64129 m .60504 .64725 L .60623 .63886 L p .196 0 .008 r
F P
0 g
s
.58284 .47544 m .58387 .4804 L .60986 .4819 L p .607 .209 .263 r
F P
0 g
s
.60986 .4819 m .61114 .47948 L .58284 .47544 L p .607 .209 .263 r
F P
0 g
s
.4439 .47054 m .44821 .48796 L .43389 .52452 L p .991 .855 .608 r
F P
0 g
s
.44301 .54091 m .43389 .52452 L .44821 .48796 L p .963 .795 .626 r
F P
0 g
s
.6487 .60482 m .65773 .59716 L .65159 .61123 L p 0 0 .076 r
F P
0 g
s
.65159 .61123 m .64381 .61933 L .6487 .60482 L p 0 0 .076 r
F P
0 g
s
.44211 .57629 m .45506 .58976 L .45683 .59493 L p .925 .538 .219 r
F P
0 g
s
.45683 .59493 m .45769 .59743 L p .45397 .59238 L .925 .538 .219 r
F P
0 g
s
.45397 .59238 m .44211 .57629 L .45683 .59493 L .925 .538 .219 r
F
.4326 .5611 m .44211 .57629 L .44399 .58184 L p .898 .522 .069 r
F P
0 g
s
.44399 .58184 m .44492 .58457 L p .44195 .5789 L .898 .522 .069 r
F P
0 g
s
.44195 .5789 m .4326 .5611 L .44399 .58184 L .898 .522 .069 r
F
.42711 .54449 m .4326 .5611 L .43455 .56704 L p .739 .423 0 r
F P
0 g
s
.43455 .56704 m .43553 .57003 L p .43347 .56379 L .739 .423 0 r
F P
0 g
s
.43347 .56379 m .42711 .54449 L .43455 .56704 L .739 .423 0 r
F
.43508 .56868 m .4337 .56449 L .43553 .57003 L F
.4337 .56449 m .42711 .54449 L .43376 .56467 L F
.4337 .56449 m .43376 .56467 L .43553 .57003 L F
.43126 .55713 m .43124 .55706 L .42395 .56894 L .992 .833 .463 r
F
.42836 .54968 m .42395 .56894 L p .43058 .55813 L F P
0 g
s
.43124 .55706 m .43008 .5541 L .43058 .55813 L .992 .833 .463 r
F
.43008 .5541 m .42836 .54968 L .43058 .55813 L F
.43178 .56864 m .43313 .56278 L p .43126 .56404 L F P
0 g
s
.43126 .55713 m .42395 .56894 L .43313 .56278 L .992 .833 .463 r
F
.4368 .5739 m .43553 .57003 L .42799 .58505 L .992 .794 .539 r
F
.43313 .56278 m .43239 .56602 L p .43553 .57003 L F P
0 g
s
.43239 .56602 m .42799 .58505 L p .43553 .57003 L .992 .794 .539 r
F P
0 g
s
.43553 .57003 m .4326 .5611 L p .43763 .57271 L .898 .522 .069 r
F P
0 g
s
.42951 .5518 m .42711 .54449 L .43559 .57021 L .739 .423 0 r
F
.44227 .57958 m .4326 .5611 L .44239 .57975 L .898 .522 .069 r
F
.43768 .57279 m .43525 .5692 L .4368 .5739 L .992 .794 .539 r
F
.44 .58359 m .44128 .57794 L p .43861 .57937 L F P
0 g
s
.43768 .57279 m .42799 .58505 L .44128 .57794 L .992 .794 .539 r
F
.44688 .58814 m .44492 .58457 L .43631 .59989 L .954 .739 .574 r
F
.44128 .57794 m .44056 .58109 L p .44492 .58457 L F P
0 g
s
.44056 .58109 m .43631 .59989 L p .44492 .58457 L .954 .739 .574 r
F P
0 g
s
.44492 .58457 m .44211 .57629 L p .44782 .58689 L .925 .538 .219 r
F P
0 g
s
.44423 .58332 m .44227 .57958 L .44492 .58457 L .898 .522 .069 r
F
.44227 .57958 m .44239 .57975 L .44492 .58457 L F
.4356 .56803 m .4326 .5611 L .44498 .58475 L F
.45439 .59302 m .44211 .57629 L .45456 .59318 L .925 .538 .219 r
F
.44792 .58699 m .44448 .58378 L .44688 .58814 L .954 .739 .574 r
F
.45182 .59694 m .45299 .59151 L p .4497 .59316 L F P
0 g
s
.44792 .58699 m .43631 .59989 L .45299 .59151 L .954 .739 .574 r
F
.46024 .60064 m .45769 .59743 L .44832 .61312 L .91 .689 .59 r
F
.45299 .59151 m .45233 .59455 L p .45769 .59743 L F P
0 g
s
.45233 .59455 m .44832 .61312 L p .45769 .59743 L .91 .689 .59 r
F P
0 g
s
.44832 .61312 m .46341 .62449 L .46663 .60844 L p .91 .689 .59 r
F P
0 g
s
.46392 .60514 m .44832 .61312 L .46663 .60844 L .91 .689 .59 r
F
.46139 .59943 m .44832 .61312 L .46767 .60322 L F
.47995 .62832 m .46505 .6189 L .45769 .59743 L p .898 .519 .307 r
F P
0 g
s
.45769 .59743 m .45506 .58976 L p .46124 .59934 L .898 .519 .307 r
F P
0 g
s
.45678 .59629 m .45439 .59302 L .45769 .59743 L .925 .538 .219 r
F
.45439 .59302 m .45456 .59318 L .45769 .59743 L F
.44561 .58279 m .44211 .57629 L .45775 .5976 L F
.45506 .58976 m .47081 .60128 L .47244 .6061 L p .898 .519 .307 r
F P
0 g
s
.46125 .59935 m .45506 .58976 L .47244 .6061 L .898 .519 .307 r
F
.4703 .5901 m .45299 .59151 L .45709 .59668 L .91 .689 .59 r
F
.46139 .59943 m .45709 .59668 L .46024 .60064 L F
.4703 .5901 m .45709 .59668 L .46139 .59943 L F
.46663 .60844 m .46767 .60322 L p .46392 .60514 L F P
0 g
s
.47995 .62832 m .46125 .59935 L .46139 .59943 L .898 .519 .307 r
F
.47244 .6061 m .47262 .60663 L p .46139 .59943 L F P
0 g
s
.47262 .60663 m .47995 .62832 L p .46139 .59943 L .898 .519 .307 r
F P
0 g
s
.47995 .62832 m .45769 .59743 L .46124 .59934 L .898 .519 .307 r
F
.45775 .5976 m .46505 .6189 L p .44561 .58279 L .925 .538 .219 r
F P
0 g
s
.45506 .58976 m .44211 .57629 L .44301 .54091 L p .956 .685 .482 r
F P
0 g
s
.45588 .57814 m .44128 .57794 L .44448 .58378 L .954 .739 .574 r
F
.45588 .57814 m .44448 .58378 L .44792 .58699 L F
.43631 .59989 m .44832 .61312 L .45182 .59694 L p F P
0 g
s
.4497 .59316 m .43631 .59989 L .45182 .59694 L .954 .739 .574 r
F
.46505 .6189 m .45274 .60766 L .44492 .58457 L p .925 .538 .219 r
F P
0 g
s
.46505 .6189 m .44492 .58457 L .44782 .58689 L .925 .538 .219 r
F
.44498 .58475 m .45274 .60766 L p .4356 .56803 L .898 .522 .069 r
F P
0 g
s
.43389 .52452 m .44301 .54091 L .44211 .57629 L p .99 .731 .427 r
F P
0 g
s
.44211 .57629 m .4326 .5611 L .43389 .52452 L p .99 .731 .427 r
F P
0 g
s
.44435 .56435 m .43313 .56278 L .43525 .5692 L .992 .794 .539 r
F
.44435 .56435 m .43525 .5692 L .43768 .57279 L F
.42799 .58505 m .43631 .59989 L .44 .58359 L p F P
0 g
s
.43861 .57937 m .42799 .58505 L .44 .58359 L .992 .794 .539 r
F
.45274 .60766 m .44363 .59482 L .43553 .57003 L p .898 .522 .069 r
F P
0 g
s
.45274 .60766 m .43553 .57003 L .43763 .57271 L .898 .522 .069 r
F
.44363 .59482 m .43829 .58064 L .43008 .5541 L p .739 .423 0 r
F P
0 g
s
.43008 .5541 m .42907 .55084 L p .43124 .55706 L .739 .423 0 r
F P
0 g
s
.42907 .55084 m .42711 .54449 L p .42933 .55125 L .739 .423 0 r
F P
0 g
s
.43124 .55706 m .42907 .55084 L .42933 .55125 L .739 .423 0 r
F
.42466 .55195 m .42395 .56894 L .42836 .54968 L p .876 .795 .305 r
F P
0 g
s
.42811 .48798 m .42876 .50675 L .42711 .54449 L p .818 .674 .129 r
F P
0 g
s
.4326 .5611 m .42711 .54449 L .42876 .50675 L p .972 .749 .32 r
F P
0 g
s
.42787 .53447 m .4274 .53238 L .42913 .54616 L 0 0 .369 r
F
.42876 .50675 m .43389 .52452 L .4326 .5611 L p .972 .749 .32 r
F P
0 g
s
.42912 .54633 m .42926 .54575 L p .42919 .54035 L .876 .795 .305 r
F P
0 g
s
.42926 .54575 m .43234 .5323 L p .42919 .54035 L .876 .795 .305 r
F P
0 g
s
.42919 .54035 m .42919 .54035 L .42926 .54575 L .876 .795 .305 r
F
.44363 .59482 m .43008 .5541 L .43124 .55706 L .739 .423 0 r
F
.43559 .57021 m .44363 .59482 L p .43124 .55706 L F P
0 g
s
.43632 .54896 m .43234 .5323 L .42912 .54633 L p .992 .833 .463 r
F P
0 g
s
.43632 .54896 m .42912 .54633 L .42944 .54891 L .992 .833 .463 r
F
.42711 .54449 m .42615 .52684 L .42811 .48798 L p .818 .674 .129 r
F P
0 g
s
.4274 .53238 m .42615 .52684 L .42924 .54808 L 0 0 .369 r
F
.42923 .54722 m .42924 .54808 L .42991 .55268 L F
.4274 .53238 m .42924 .54808 L .42923 .54722 L F
.43389 .52452 m .42876 .50675 L .4439 .47054 L p .991 .855 .608 r
F P
0 g
s
.42808 .5336 m .4291 .53715 L p .42936 .53003 L 0 0 .504 r
F P
0 g
s
.43234 .5323 m .43288 .51474 L .42973 .529 L p .876 .795 .305 r
F P
0 g
s
.42973 .529 m .42985 .52843 L p .43191 .52289 L 0 0 0 r
F P
0 g
s
.42985 .52843 m .43288 .51474 L p .43191 .52289 L 0 0 0 r
F P
0 g
s
.43191 .52289 m .43191 .52289 L .42985 .52843 L 0 0 0 r
F
.43632 .54896 m .4357 .54896 L .43578 .54984 L .992 .833 .463 r
F
.42711 .54449 m .43008 .5541 L p .42995 .55316 L 0 0 .369 r
F P
0 g
s
.4357 .54896 m .42944 .54891 L .43578 .54984 L .992 .833 .463 r
F
.43124 .55706 m .42951 .5518 L .43312 .56274 L .739 .423 0 r
F
.42615 .52684 m .42711 .54449 L p .42995 .55316 L 0 0 .369 r
F P
0 g
s
.42991 .55268 m .42615 .52684 L .43008 .5541 L 0 0 .369 r
F
.42944 .54891 m .42853 .5489 L .42946 .54902 L .992 .833 .463 r
F
.42944 .54891 m .42946 .54902 L .43578 .54984 L F
.43578 .54984 m .42853 .5489 L .43126 .55713 L F
.43313 .56278 m .43632 .54896 L p .43126 .55713 L F P
0 g
s
.44435 .56435 m .43632 .54896 L .43313 .56278 L p .992 .794 .539 r
F P
0 g
s
.43632 .54896 m .44435 .56435 L .46254 .53289 L p .941 .813 .689 r
F P
0 g
s
.46254 .53289 m .4554 .5181 L .43632 .54896 L p .941 .813 .689 r
F P
0 g
s
.43234 .5323 m .43632 .54896 L .4554 .5181 L p .969 .874 .686 r
F P
0 g
s
.4554 .5181 m .45183 .50215 L .43234 .5323 L p .969 .874 .686 r
F P
0 g
s
.43288 .51474 m .43234 .5323 L .45183 .50215 L p .97 .932 .662 r
F P
0 g
s
.4372 .56549 m .44079 .54977 L .43305 .51982 L p 0 0 .504 r
F P
0 g
s
.45183 .50215 m .45224 .48538 L .43288 .51474 L p .97 .932 .662 r
F P
0 g
s
.43831 .49677 m .43288 .51474 L .45224 .48538 L p .895 .945 .586 r
F P
0 g
s
.43288 .51474 m .43831 .49677 L .43533 .51125 L p 0 0 0 r
F P
0 g
s
.43288 .51474 m .43533 .51125 L .43434 .51481 L 0 0 0 r
F
.43299 .51962 m .44079 .54977 L p .43975 .50523 L .123 .107 .566 r
F P
0 g
s
.43533 .51125 m .43831 .49677 L p .43975 .50524 L 0 0 .159 r
F P
0 g
s
.45224 .48538 m .45697 .46821 L .43831 .49677 L p .895 .945 .586 r
F P
0 g
s
.44889 .47889 m .43831 .49677 L .45697 .46821 L p .68 .843 .423 r
F P
0 g
s
.43831 .49677 m .44889 .47889 L .44617 .49363 L p 0 0 .159 r
F P
0 g
s
.43831 .49677 m .44617 .49363 L .44473 .49658 L 0 0 .159 r
F
.45224 .48538 m .45183 .50215 L .47959 .48001 L p .916 .89 .791 r
F P
0 g
s
.47959 .48001 m .4799 .46518 L .45224 .48538 L p .916 .89 .791 r
F P
0 g
s
.45697 .46821 m .45224 .48538 L .4799 .46518 L p .917 .947 .803 r
F P
0 g
s
.44207 .50203 m .44934 .53398 L p .45286 .48797 L .282 .206 .591 r
F P
0 g
s
.44889 .47889 m .45288 .48795 L .45286 .48797 L .073 0 .298 r
F
.44617 .49363 m .44627 .49307 L p .45286 .48797 L F P
0 g
s
.44627 .49307 m .44889 .47889 L p .45286 .48797 L .073 0 .298 r
F P
0 g
s
.4554 .5181 m .46254 .53289 L .48832 .50738 L p .874 .786 .76 r
F P
0 g
s
.48832 .50738 m .48251 .49418 L .4554 .5181 L p .874 .786 .76 r
F P
0 g
s
.45183 .50215 m .4554 .5181 L .48251 .49418 L p .898 .835 .775 r
F P
0 g
s
.48251 .49418 m .47959 .48001 L .45183 .50215 L p .898 .835 .775 r
F P
0 g
s
.44934 .53398 m .463 .51865 L .4565 .48516 L p .282 .206 .591 r
F P
0 g
s
.4799 .46518 m .48368 .45001 L .45697 .46821 L p .917 .947 .803 r
F P
0 g
s
.46621 .45112 m .45697 .46821 L .48368 .45001 L p .882 .99 .8 r
F P
0 g
s
.45697 .46821 m .46621 .45112 L .44889 .47889 L p .68 .843 .423 r
F P
0 g
s
.4647 .46169 m .44889 .47889 L .46621 .45112 L p 0 0 0 r
F P
0 g
s
.44889 .47889 m .4647 .46169 L .46234 .4767 L p .073 0 .298 r
F P
0 g
s
.45646 .48495 m .463 .51865 L p .47126 .47167 L .393 .277 .601 r
F P
0 g
s
.4647 .46169 m .47132 .47164 L .47126 .47167 L .262 .04 .376 r
F
.46234 .4767 m .46242 .47615 L p .47126 .47167 L F P
0 g
s
.46242 .47615 m .4647 .46169 L p .47126 .47167 L .262 .04 .376 r
F P
0 g
s
.463 .51865 m .48174 .50435 L .47615 .4692 L p .393 .277 .601 r
F P
0 g
s
.51252 .4666 m .51271 .45455 L .4799 .46518 L p .844 .808 .815 r
F P
0 g
s
.48368 .45001 m .4799 .46518 L .51271 .45455 L p .856 .849 .836 r
F P
0 g
s
.51271 .45455 m .51539 .44226 L .48368 .45001 L p .856 .849 .836 r
F P
0 g
s
.4911 .4349 m .48368 .45001 L .51539 .44226 L p .859 .893 .859 r
F P
0 g
s
.48368 .45001 m .4911 .4349 L .46621 .45112 L p .882 .99 .8 r
F P
0 g
s
.4647 .46169 m .48562 .4458 L .48372 .46111 L p .262 .04 .376 r
F P
0 g
s
.4799 .46518 m .47959 .48001 L .51252 .4666 L p .844 .808 .815 r
F P
0 g
s
.47612 .46899 m .47615 .4692 L p .48395 .46102 L .475 .33 .604 r
F P
0 g
s
.48395 .46102 m .48372 .46111 L .47612 .46899 L .475 .33 .604 r
F
.48562 .4458 m .49486 .45693 L .49475 .45697 L .391 .147 .42 r
F
.48372 .46111 m .48379 .46056 L p .49475 .45697 L F P
0 g
s
.48379 .46056 m .48562 .4458 L p .49475 .45697 L .391 .147 .42 r
F P
0 g
s
.47959 .48001 m .48251 .49418 L .51465 .47817 L p .828 .77 .797 r
F P
0 g
s
.51465 .47817 m .51252 .4666 L .47959 .48001 L p .828 .77 .797 r
F P
0 g
s
.48174 .50435 m .50534 .49168 L .50084 .45498 L p .475 .33 .604 r
F P
0 g
s
.48174 .50435 m .50084 .45498 L .49487 .45693 L .475 .33 .604 r
F
.49475 .45698 m .49487 .45693 L .49475 .45697 L F
.48174 .50435 m .49487 .45693 L .49475 .45698 L F
.51539 .44226 m .52066 .43001 L .4911 .4349 L p .859 .893 .859 r
F P
0 g
s
.48562 .4458 m .51135 .43182 L .50971 .45081 L p .391 .147 .42 r
F P
0 g
s
.48562 .4458 m .50971 .45081 L .50855 .45129 L .391 .147 .42 r
F
.47615 .4692 m .48174 .50435 L p .49475 .45698 L .475 .33 .604 r
F P
0 g
s
.48562 .4458 m .50855 .45129 L .49486 .45693 L .391 .147 .42 r
F
.49475 .45698 m .49697 .4489 L .48425 .4613 L .475 .33 .604 r
F
.49475 .45698 m .48425 .4613 L .47615 .4692 L F
.49486 .45693 m .50965 .45155 L .49487 .45693 L .391 .147 .42 r
F
.50855 .45129 m .50965 .45155 L .49486 .45693 L F
.49697 .4489 m .49756 .44676 L .48331 .46169 L .475 .33 .604 r
F
.48425 .4613 m .48331 .46169 L .47615 .4692 L F
.49697 .4489 m .48331 .46169 L .48425 .4613 L F
.50971 .45081 m .50965 .45155 L p .50855 .45129 L .391 .147 .42 r
F P
0 g
s
.49475 .45697 m .50783 .47255 L .48372 .46111 L .391 .147 .42 r
F
.49486 .45693 m .49487 .45693 L .49475 .45697 L F
.49487 .45693 m .50783 .47255 L .49475 .45697 L F
.50084 .45498 m .49913 .44104 L p .49475 .45697 L .475 .33 .604 r
F P
0 g
s
.50965 .45155 m .50783 .47255 L p .49487 .45693 L .391 .147 .42 r
F P
0 g
s
.50783 .47255 m .48067 .48567 L .48372 .46111 L p .391 .147 .42 r
F P
0 g
s
.48395 .46102 m .49756 .44676 L .48372 .46111 L .475 .33 .604 r
F
.463 .51865 m .47615 .4692 L .47126 .47167 L .393 .277 .601 r
F
.48067 .48567 m .45854 .50081 L .46123 .48375 L p .262 .04 .376 r
F P
0 g
s
.47126 .47167 m .46234 .4767 L .45646 .48495 L .393 .277 .601 r
F
.46123 .48375 m .46234 .4767 L p .46641 .4787 L .262 .04 .376 r
F P
0 g
s
.46641 .4787 m .48067 .48567 L .46123 .48375 L .262 .04 .376 r
F
.48372 .46111 m .48332 .46431 L p .48096 .46397 L F P
0 g
s
.4647 .46169 m .48372 .46111 L .48096 .46397 L .262 .04 .376 r
F
.4647 .46169 m .48332 .46431 L .48236 .46489 L F
.47132 .47164 m .48323 .46505 L .47132 .47164 L F
.4647 .46169 m .48236 .46489 L .47132 .47164 L F
.48236 .46489 m .48323 .46505 L .47132 .47164 L F
.44889 .47889 m .46234 .4767 L .46023 .47966 L .073 0 .298 r
F
.47301 .46173 m .47404 .45589 L .46051 .47825 L .393 .277 .601 r
F
.44889 .47889 m .46185 .47977 L .46112 .48044 L .073 0 .298 r
F
.45288 .48795 m .46174 .48051 L .45288 .48795 L F
.44889 .47889 m .46112 .48044 L .45288 .48795 L F
.46112 .48044 m .46174 .48051 L .45288 .48795 L F
.4536 .4784 m .45405 .47253 L .44478 .49535 L .282 .206 .591 r
F
.45286 .48797 m .44617 .49363 L .44207 .50203 L F
.44079 .54977 m .44934 .53398 L .44207 .50203 L p .123 .107 .566 r
F P
0 g
s
.44079 .54977 m .44207 .50203 L .43975 .50523 L .123 .107 .566 r
F
.43975 .50524 m .44245 .50124 L .43994 .50639 L 0 0 .159 r
F
.43831 .49677 m .44563 .49656 L .43975 .50524 L F
.44207 .50203 m .4394 .49031 L p .43975 .50523 L .123 .107 .566 r
F P
0 g
s
.43994 .50639 m .44402 .49934 L .44179 .51731 L 0 0 .159 r
F
.44563 .49656 m .44549 .49731 L p .44402 .49934 L F P
0 g
s
.44549 .49731 m .44179 .51731 L p .44402 .49934 L 0 0 .159 r
F P
0 g
s
.44245 .50124 m .44563 .49656 L .43994 .50639 L 0 0 .159 r
F
.44577 .49445 m .44478 .49535 L .44207 .50203 L .282 .206 .591 r
F
.4536 .4784 m .44478 .49535 L .44577 .49445 L F
.46179 .47746 m .46051 .47825 L .45646 .48495 L .393 .277 .601 r
F
.47301 .46173 m .46051 .47825 L .46179 .47746 L F
.49913 .44104 m .47404 .45589 L .47612 .46899 L p .475 .33 .604 r
F P
0 g
s
.49756 .44676 m .49913 .44104 L .47612 .46899 L .475 .33 .604 r
F
.47404 .45589 m .45405 .47253 L .45572 .48118 L p .393 .277 .601 r
F P
0 g
s
.45572 .48118 m .45646 .48495 L p .46051 .47825 L .393 .277 .601 r
F P
0 g
s
.46051 .47825 m .47404 .45589 L .45572 .48118 L .393 .277 .601 r
F
.48332 .46431 m .48323 .46505 L p .48236 .46489 L .262 .04 .376 r
F P
0 g
s
.47615 .4692 m .47612 .46899 L p .47132 .47164 L .393 .277 .601 r
F P
0 g
s
.48323 .46505 m .48067 .48567 L p .47132 .47164 L .262 .04 .376 r
F P
0 g
s
.47126 .47167 m .47132 .47164 L .47404 .45589 L .393 .277 .601 r
F
.47612 .46899 m .47404 .45589 L p .47132 .47164 L F P
0 g
s
.47126 .47167 m .47301 .46173 L .46234 .4767 L .393 .277 .601 r
F
.47132 .47164 m .48067 .48567 L .46234 .4767 L .262 .04 .376 r
F
.46234 .4767 m .46185 .47977 L p .46023 .47966 L .073 0 .298 r
F P
0 g
s
.45405 .47253 m .4394 .49031 L .44127 .49855 L p .282 .206 .591 r
F P
0 g
s
.44127 .49855 m .44207 .50203 L p .44478 .49535 L .282 .206 .591 r
F P
0 g
s
.44478 .49535 m .45405 .47253 L .44127 .49855 L .282 .206 .591 r
F
.46185 .47977 m .46174 .48051 L p .46112 .48044 L .073 0 .298 r
F P
0 g
s
.4565 .48516 m .45646 .48495 L p .45288 .48795 L .282 .206 .591 r
F P
0 g
s
.44934 .53398 m .4565 .48516 L .45286 .48797 L .282 .206 .591 r
F
.46174 .48051 m .45854 .50081 L p .45288 .48795 L .073 0 .298 r
F P
0 g
s
.45286 .48797 m .45288 .48795 L .45405 .47253 L .282 .206 .591 r
F
.45646 .48495 m .45405 .47253 L p .45288 .48795 L F P
0 g
s
.45286 .48797 m .4536 .4784 L .44617 .49363 L .282 .206 .591 r
F
.45854 .50081 m .44179 .51731 L .44617 .49363 L p .073 0 .298 r
F P
0 g
s
.45288 .48795 m .45854 .50081 L .44617 .49363 L .073 0 .298 r
F
.44617 .49363 m .44563 .49656 L p .44473 .49658 L 0 0 .159 r
F P
0 g
s
.43975 .50524 m .43954 .49614 L .43533 .51125 L .123 .107 .566 r
F
.43975 .50523 m .43533 .51125 L .43299 .51962 L F
.4372 .56549 m .43305 .51982 L .43192 .52286 L 0 0 .504 r
F
.43288 .51474 m .4345 .51482 L .43191 .52289 L 0 0 0 r
F
.4345 .51482 m .43459 .51482 L .43192 .52286 L F
.4345 .51482 m .43192 .52286 L .43191 .52289 L F
.43234 .5323 m .42973 .529 L .42951 .53176 L .876 .795 .305 r
F
.43086 .51433 m .43015 .50861 L .4291 .53715 L 0 0 .504 r
F
.42787 .53447 m .42913 .54616 L .42913 .54548 L 0 0 .369 r
F
.42853 .5489 m .42836 .54968 L p .43124 .55706 L .992 .833 .463 r
F P
0 g
s
.4274 .53238 m .42991 .55268 L .43014 .55429 L 0 0 .369 r
F
.43234 .5323 m .42913 .53169 L .42919 .54035 L .876 .795 .305 r
F
.43124 .55706 m .43312 .56274 L .43559 .57021 L .739 .423 0 r
F
.43553 .57003 m .43559 .57021 L p .43508 .56868 L F P
0 g
s
.43014 .55429 m .43829 .58064 L p .42787 .53447 L 0 0 .369 r
F P
0 g
s
.42919 .54035 m .42919 .5403 L .42466 .55195 L .876 .795 .305 r
F
.42913 .53169 m .42896 .53245 L p .42919 .5403 L F P
0 g
s
.4291 .53715 m .42615 .52684 L p .42919 .5403 L 0 0 .369 r
F P
0 g
s
.42896 .53245 m .42466 .55195 L p .42919 .5403 L .876 .795 .305 r
F P
0 g
s
.42915 .53734 m .4291 .53715 L p .42919 .54031 L 0 0 .369 r
F P
0 g
s
.42919 .54031 m .4291 .53715 L .42919 .5403 L 0 0 .369 r
F
.4291 .53715 m .4372 .56549 L p .43192 .52286 L 0 0 .504 r
F P
0 g
s
.43192 .52286 m .43108 .51612 L .42983 .52934 L 0 0 .504 r
F
.43192 .52286 m .42983 .52934 L .4291 .53715 L F
.43108 .51612 m .43086 .51433 L .4307 .51633 L F
.43108 .51612 m .4307 .51633 L .4291 .53715 L F
.44179 .51731 m .43052 .53456 L .43475 .51406 L p 0 0 .159 r
F P
0 g
s
.43475 .51406 m .43533 .51125 L p .43698 .51281 L 0 0 .159 r
F P
0 g
s
.43698 .51281 m .44179 .51731 L .43475 .51406 L 0 0 .159 r
F
.43975 .50524 m .44179 .51731 L .43533 .51125 L F
.4394 .49031 m .43015 .50861 L .43299 .51962 L p .123 .107 .566 r
F P
0 g
s
.43954 .49614 m .4394 .49031 L .43299 .51962 L .123 .107 .566 r
F
.43533 .51125 m .43459 .51482 L p .43434 .51481 L 0 0 0 r
F P
0 g
s
.43305 .51982 m .43299 .51962 L p .43192 .52286 L 0 0 .504 r
F P
0 g
s
.43192 .52286 m .43299 .51962 L .43192 .52286 L 0 0 .504 r
F
.43459 .51482 m .43052 .53456 L p .43191 .52289 L 0 0 0 r
F P
0 g
s
.43299 .51962 m .43015 .50861 L p .43192 .52286 L 0 0 .504 r
F P
0 g
s
.42973 .529 m .42913 .53169 L p .42951 .53176 L .876 .795 .305 r
F P
0 g
s
.44128 .57794 m .44435 .56435 L p .43768 .57279 L .992 .794 .539 r
F P
0 g
s
.43829 .58064 m .4372 .56549 L .42915 .53734 L p 0 0 .369 r
F P
0 g
s
.43829 .58064 m .42915 .53734 L .42919 .54031 L 0 0 .369 r
F
.43052 .53456 m .42466 .55195 L .42973 .529 L p 0 0 0 r
F P
0 g
s
.43191 .52289 m .43052 .53456 L .42973 .529 L 0 0 0 r
F
.43015 .50861 m .42615 .52684 L .42808 .5336 L p 0 0 .504 r
F P
0 g
s
.42936 .53003 m .43015 .50861 L .42808 .5336 L 0 0 .504 r
F
.42913 .54548 m .42913 .54616 L .43014 .55429 L 0 0 .369 r
F
.42836 .54968 m .42912 .54633 L p .42663 .5469 L .876 .795 .305 r
F P
0 g
s
.42919 .54035 m .42663 .5469 L .42912 .54633 L .876 .795 .305 r
F
.42663 .5469 m .42466 .55195 L .42836 .54968 L F
.43008 .5541 m .43014 .55429 L p .42991 .55268 L 0 0 .369 r
F P
0 g
s
.42912 .54633 m .42853 .5489 L p .42944 .54891 L .992 .833 .463 r
F P
0 g
s
.42395 .56894 m .42799 .58505 L .43178 .56864 L p .992 .833 .463 r
F P
0 g
s
.43126 .56404 m .42395 .56894 L .43178 .56864 L .992 .833 .463 r
F
.45588 .57814 m .44435 .56435 L .44128 .57794 L p .954 .739 .574 r
F P
0 g
s
.44492 .58457 m .44498 .58475 L p .44423 .58332 L .898 .522 .069 r
F P
0 g
s
.45299 .59151 m .45588 .57814 L p .44792 .58699 L .954 .739 .574 r
F P
0 g
s
.4703 .5901 m .45588 .57814 L .45299 .59151 L p .91 .689 .59 r
F P
0 g
s
.45769 .59743 m .45775 .5976 L p .45678 .59629 L .925 .538 .219 r
F P
0 g
s
.46767 .60322 m .4703 .5901 L p .46139 .59943 L .91 .689 .59 r
F P
0 g
s
.49684 .63577 m .47995 .62832 L .47081 .60128 L p .854 .489 .358 r
F P
0 g
s
.58387 .4804 m .58513 .4852 L .60825 .48458 L p .553 .177 .281 r
F P
0 g
s
.60825 .48458 m .60986 .4819 L .58387 .4804 L p .553 .177 .281 r
F P
0 g
s
.51271 .45455 m .51252 .4666 L .54752 .46187 L p .789 .714 .781 r
F P
0 g
s
.54752 .46187 m .54758 .45312 L .51271 .45455 L p .789 .714 .781 r
F P
0 g
s
.44435 .56435 m .45588 .57814 L .47277 .54623 L p .906 .758 .686 r
F P
0 g
s
.47277 .54623 m .46254 .53289 L .44435 .56435 L p .906 .758 .686 r
F P
0 g
s
.81553 .74791 m .83585 .7245 L .84295 .66504 L p .1 0 .355 r
F P
0 g
s
.85747 .63969 m .84295 .66504 L .83585 .7245 L p 0 0 .242 r
F P
0 g
s
.23692 .57561 m .25527 .60872 L .26958 .68142 L p .935 .607 .162 r
F P
0 g
s
.29443 .70792 m .26958 .68142 L .25527 .60872 L p .956 .614 .297 r
F P
0 g
s
.61204 .47728 m .61114 .47948 L .63422 .48937 L p .49 0 0 r
F P
0 g
s
.77526 .42471 m .76467 .40948 L .71665 .39341 L p .177 .525 .92 r
F P
0 g
s
.70553 .38497 m .71665 .39341 L .76467 .40948 L p .101 .529 .91 r
F P
0 g
s
.69172 .37817 m .67572 .37324 L .64076 .38447 L p .358 .798 .96 r
F P
0 g
s
.63055 .38465 m .64076 .38447 L .67572 .37324 L p .419 .843 .956 r
F P
0 g
s
.66607 .54058 m .66785 .53472 L .67161 .55533 L p 0 0 .401 r
F P
0 g
s
.67161 .55533 m .67015 .56256 L .66607 .54058 L p 0 0 .401 r
F P
0 g
s
.47583 .40639 m .47217 .42278 L .44365 .45226 L p .935 .963 .752 r
F P
0 g
s
.4439 .47054 m .44365 .45226 L .47217 .42278 L p .946 .909 .752 r
F P
0 g
s
.65656 .51283 m .65635 .50921 L .66726 .52919 L p 0 0 .562 r
F P
0 g
s
.66726 .52919 m .66785 .53472 L .65656 .51283 L p 0 0 .562 r
F P
0 g
s
.62093 .63342 m .63354 .62682 L .62758 .63439 L p 0 0 0 r
F P
0 g
s
.62758 .63439 m .61725 .64129 L .62093 .63342 L p 0 0 0 r
F P
0 g
s
.51539 .44226 m .51271 .45455 L .54758 .45312 L p .806 .745 .795 r
F P
0 g
s
.54758 .45312 m .54907 .44423 L .51539 .44226 L p .806 .745 .795 r
F P
0 g
s
.65432 .50605 m .65635 .50921 L .63784 .49056 L p 0 .107 .633 r
F P
0 g
s
.63784 .49056 m .63659 .48975 L .65432 .50605 L p 0 .107 .633 r
F P
0 g
s
.49684 .63577 m .51508 .64119 L .52738 .65608 L p .723 .255 .14 r
F P
0 g
s
.54373 .65757 m .52738 .65608 L .51508 .64119 L p .675 .224 .175 r
F P
0 g
s
.66602 .56992 m .67015 .56256 L .66757 .58092 L p 0 0 .17 r
F P
0 g
s
.66757 .58092 m .66403 .58909 L .66602 .56992 L p 0 0 .17 r
F P
0 g
s
.54888 .34393 m .53702 .35418 L .50861 .35959 L p .688 .98 .878 r
F P
0 g
s
.49409 .37437 m .50861 .35959 L .53702 .35418 L p .784 .99 .887 r
F P
0 g
s
.61114 .47948 m .60986 .4819 L .63089 .48952 L p .55 0 0 r
F P
0 g
s
.63089 .48952 m .63422 .48937 L .61114 .47948 L p .55 0 0 r
F P
0 g
s
.52066 .43001 m .51539 .44226 L .54907 .44423 L p .821 .778 .812 r
F P
0 g
s
.54907 .44423 m .55206 .43537 L .52066 .43001 L p .821 .778 .812 r
F P
0 g
s
.65773 .59716 m .66403 .58909 L .65679 .60282 L p 0 0 0 r
F P
0 g
s
.65679 .60282 m .65159 .61123 L .65773 .59716 L p 0 0 0 r
F P
0 g
s
.67572 .37324 m .65809 .37036 L .63055 .38465 L p .419 .843 .956 r
F P
0 g
s
.61981 .38608 m .63055 .38465 L .65809 .37036 L p .498 .888 .957 r
F P
0 g
s
.50861 .35959 m .52645 .34624 L .54888 .34393 L p .688 .98 .878 r
F P
0 g
s
.63354 .62682 m .64381 .61933 L .63582 .62679 L p 0 0 0 r
F P
0 g
s
.63582 .62679 m .62758 .63439 L .63354 .62682 L p 0 0 0 r
F P
0 g
s
.52855 .41812 m .52066 .43001 L .55206 .43537 L p .832 .813 .832 r
F P
0 g
s
.55206 .43537 m .55654 .42672 L .52855 .41812 L p .832 .813 .832 r
F P
0 g
s
.80863 .71077 m .79576 .73232 L .82209 .68954 L p .62 .806 .383 r
F P
0 g
s
.82209 .68954 m .83735 .66587 L .80863 .71077 L p .62 .806 .383 r
F P
0 g
s
.63659 .48975 m .63422 .48937 L .65068 .50353 L p .583 .047 0 r
F P
0 g
s
.65068 .50353 m .65432 .50605 L .63659 .48975 L p .583 .047 0 r
F P
0 g
s
.60986 .4819 m .60825 .48458 L .6268 .49027 L p .554 .015 0 r
F P
0 g
s
.6268 .49027 m .63089 .48952 L .60986 .4819 L p .554 .015 0 r
F P
0 g
s
.47995 .62832 m .49684 .63577 L .51161 .65281 L p .76 .272 .076 r
F P
0 g
s
.52738 .65608 m .51161 .65281 L .49684 .63577 L p .723 .255 .14 r
F P
0 g
s
.75404 .77126 m .77742 .75263 L .74134 .77875 L p .531 .872 .615 r
F P
0 g
s
.74134 .77875 m .72316 .79485 L .75404 .77126 L p .531 .872 .615 r
F P
0 g
s
.65635 .50921 m .65432 .50605 L .66451 .52426 L p .629 .236 0 r
F P
0 g
s
.66451 .52426 m .66726 .52919 L .65635 .50921 L p .629 .236 0 r
F P
0 g
s
.65809 .37036 m .63944 .36964 L .61981 .38608 L p .498 .888 .957 r
F P
0 g
s
.60889 .38876 m .61981 .38608 L .63944 .36964 L p .584 .926 .958 r
F P
0 g
s
.53899 .40689 m .52855 .41812 L .55654 .42672 L p .838 .85 .854 r
F P
0 g
s
.55654 .42672 m .56248 .41845 L .53899 .40689 L p .838 .85 .854 r
F P
0 g
s
.66785 .53472 m .66726 .52919 L .67053 .54853 L p 0 0 .147 r
F P
0 g
s
.67053 .54853 m .67161 .55533 L .66785 .53472 L p 0 0 .147 r
F P
0 g
s
.74102 .8363 m .70929 .85157 L .6863 .88173 L p .06 0 0 r
F P
0 g
s
.44365 .45226 m .4439 .47054 L .42876 .50675 L p .977 .901 .557 r
F P
0 g
s
.66847 .57295 m .66757 .58092 L .67015 .56256 L p .731 .671 .122 r
F P
0 g
s
.67015 .56256 m .67161 .55533 L .66847 .57295 L p .731 .671 .122 r
F P
0 g
s
.48313 .39011 m .47583 .40639 L .44777 .43355 L p .87 .988 .722 r
F P
0 g
s
.44365 .45226 m .44777 .43355 L .47583 .40639 L p .935 .963 .752 r
F P
0 g
s
.55182 .39664 m .53899 .40689 L .56248 .41845 L p .835 .886 .879 r
F P
0 g
s
.56248 .41845 m .56978 .41075 L .55182 .39664 L p .835 .886 .879 r
F P
0 g
s
.3569 .78499 m .38871 .80046 L .43119 .83304 L p .609 .039 0 r
F P
0 g
s
.45941 .84109 m .43119 .83304 L .38871 .80046 L p .623 .066 0 r
F P
0 g
s
.63944 .36964 m .62038 .3711 L .60889 .38876 L p .584 .926 .958 r
F P
0 g
s
.59812 .39266 m .60889 .38876 L .62038 .3711 L p .668 .95 .955 r
F P
0 g
s
.76467 .40948 m .74966 .39596 L .70553 .38497 L p .101 .529 .91 r
F P
0 g
s
.69172 .37817 m .70553 .38497 L .74966 .39596 L p .039 .535 .88 r
F P
0 g
s
.76868 .81863 m .79162 .79891 L .81553 .74791 L p .033 0 .111 r
F P
0 g
s
.83585 .7245 m .81553 .74791 L .79162 .79891 L p 0 0 0 r
F P
0 g
s
.26958 .68142 m .29443 .70792 L .32964 .76642 L p .8 .337 0 r
F P
0 g
s
.3569 .78499 m .32964 .76642 L .29443 .70792 L p .845 .382 .057 r
F P
0 g
s
.64381 .61933 m .65159 .61123 L .64188 .61874 L p .69 .922 .598 r
F P
0 g
s
.64188 .61874 m .63582 .62679 L .64381 .61933 L p .69 .922 .598 r
F P
0 g
s
.63422 .48937 m .63089 .48952 L .64569 .5018 L p .7 .159 0 r
F P
0 g
s
.64569 .5018 m .65068 .50353 L .63422 .48937 L p .7 .159 0 r
F P
0 g
s
.56678 .38767 m .55182 .39664 L .56978 .41075 L p .82 .919 .903 r
F P
0 g
s
.56978 .41075 m .5783 .40378 L .56678 .38767 L p .82 .919 .903 r
F P
0 g
s
.66403 .58909 m .66757 .58092 L .65944 .5944 L p .82 .883 .452 r
F P
0 g
s
.65944 .5944 m .65679 .60282 L .66403 .58909 L p .82 .883 .452 r
F P
0 g
s
.62038 .3711 m .60154 .37469 L .59812 .39266 L p .668 .95 .955 r
F P
0 g
s
.58782 .39771 m .59812 .39266 L .60154 .37469 L p .737 .956 .944 r
F P
0 g
s
.56014 .65734 m .57612 .65545 L .58135 .65695 L p .206 0 0 r
F P
0 g
s
.57612 .65545 m .59122 .65203 L .59288 .65277 L p .037 0 0 r
F P
0 g
s
.59288 .65277 m .58135 .65695 L .57612 .65545 L p .037 0 0 r
F P
0 g
s
.5835 .38028 m .56678 .38767 L .5783 .40378 L p .788 .944 .926 r
F P
0 g
s
.5783 .40378 m .58782 .39771 L .5835 .38028 L p .788 .944 .926 r
F P
0 g
s
.6013 .64065 m .59457 .64594 L .59334 .65092 L p .745 .993 .842 r
F P
0 g
s
.59122 .65203 m .60504 .64725 L .60454 .64733 L p 0 0 0 r
F P
0 g
s
.5998 .64885 m .59122 .65203 L .60454 .64733 L 0 0 0 r
F
.60454 .64733 m .60333 .64754 L p .5998 .64885 L F P
0 g
s
.60333 .64754 m .59288 .65277 L .59122 .65203 L p 0 0 0 r
F P
0 g
s
.59334 .65092 m .59288 .65277 L p .5944 .65058 L .745 .993 .842 r
F P
0 g
s
.6013 .64065 m .59334 .65092 L .5944 .65058 L .745 .993 .842 r
F
.45202 .64861 m .46658 .65848 L .46341 .62449 L p .93 .62 .435 r
F P
0 g
s
.46341 .62449 m .44832 .61312 L .45202 .64861 L p .93 .62 .435 r
F P
0 g
s
.60154 .37469 m .5835 .38028 L .58782 .39771 L p .737 .956 .944 r
F P
0 g
s
.54373 .65757 m .56014 .65734 L .56905 .65996 L p .327 0 0 r
F P
0 g
s
.58135 .65695 m .56905 .65996 L .56014 .65734 L p .206 0 0 r
F P
0 g
s
.60504 .64725 m .61725 .64129 L .61243 .64145 L p .454 .851 .654 r
F P
0 g
s
.61243 .64145 m .60333 .64754 L .60504 .64725 L p .454 .851 .654 r
F P
0 g
s
.65432 .50605 m .65068 .50353 L .65986 .52014 L p .838 .391 0 r
F P
0 g
s
.65986 .52014 m .66451 .52426 L .65432 .50605 L p .838 .391 0 r
F P
0 g
s
.46505 .6189 m .47995 .62832 L .49696 .64779 L p .774 .268 0 r
F P
0 g
s
.51161 .65281 m .49696 .64779 L .47995 .62832 L p .76 .272 .076 r
F P
0 g
s
.52738 .65608 m .54373 .65757 L .55634 .66169 L p .412 0 0 r
F P
0 g
s
.56905 .65996 m .55634 .66169 L .54373 .65757 L p .327 0 0 r
F P
0 g
s
.66726 .52919 m .66451 .52426 L .66718 .54243 L p .928 .62 .153 r
F P
0 g
s
.66718 .54243 m .67053 .54853 L .66726 .52919 L p .928 .62 .153 r
F P
0 g
s
.63089 .48952 m .6268 .49027 L .63964 .50097 L p .72 .214 .029 r
F P
0 g
s
.63964 .50097 m .64569 .5018 L .63089 .48952 L p .72 .214 .029 r
F P
0 g
s
.61725 .64129 m .62758 .63439 L .62 .63466 L p .692 .974 .779 r
F P
0 g
s
.62 .63466 m .61243 .64145 L .61725 .64129 L p .692 .974 .779 r
F P
0 g
s
.65159 .61123 m .65679 .60282 L .6457 .6105 L p .884 .988 .731 r
F P
0 g
s
.6457 .6105 m .64188 .61874 L .65159 .61123 L p .884 .988 .731 r
F P
0 g
s
.67161 .55533 m .67053 .54853 L .66689 .56548 L p .97 .809 .386 r
F P
0 g
s
.66689 .56548 m .66847 .57295 L .67161 .55533 L p .97 .809 .386 r
F P
0 g
s
.56931 .84852 m .5472 .85049 L .53652 .84991 L p .052 0 0 r
F P
0 g
s
.55413 .84895 m .5865 .84606 L .58914 .84531 L p 0 0 0 r
F P
0 g
s
.57537 .84652 m .55413 .84895 L .58914 .84531 L 0 0 0 r
F
.58914 .84531 m .59136 .84468 L p .57537 .84652 L F P
0 g
s
.59136 .84468 m .56931 .84852 L .55413 .84895 L p 0 0 0 r
F P
0 g
s
.52166 .84909 m .55413 .84895 L .56222 .84872 L p .052 0 0 r
F P
0 g
s
.56222 .84872 m .56931 .84852 L p .54864 .84877 L .052 0 0 r
F P
0 g
s
.54864 .84877 m .52166 .84909 L .56222 .84872 L .052 0 0 r
F
.5472 .85049 m .52557 .85059 L .511 .84891 L p .125 0 0 r
F P
0 g
s
.53652 .84991 m .52166 .84909 L p .5497 .84876 L .052 0 0 r
F P
0 g
s
.56931 .84852 m .53652 .84991 L .5497 .84876 L .052 0 0 r
F
.48983 .84647 m .52166 .84909 L .535 .84982 L p .125 0 0 r
F P
0 g
s
.535 .84982 m .5472 .85049 L p .52208 .84873 L .125 0 0 r
F P
0 g
s
.50477 .84752 m .48983 .84647 L .5062 .84769 L .125 0 0 r
F
.52208 .84873 m .50477 .84752 L .535 .84982 L F
.50477 .84752 m .5062 .84769 L .535 .84982 L F
.511 .84891 m .48983 .84647 L p .52391 .84886 L F P
0 g
s
.45941 .84109 m .48983 .84647 L .50812 .84858 L p .169 0 0 r
F P
0 g
s
.5472 .85049 m .511 .84891 L .52391 .84886 L .125 0 0 r
F
.50812 .84858 m .52557 .85059 L p .49635 .84639 L .169 0 0 r
F P
0 g
s
.49635 .84639 m .45941 .84109 L .50812 .84858 L .169 0 0 r
F
.48687 .84575 m .45941 .84109 L p .49635 .84639 L F P
0 g
s
.49909 .84679 m .49716 .84662 L .49635 .84639 L .169 0 0 r
F
.49716 .84662 m .48687 .84575 L .49635 .84639 L F
.52557 .85059 m .50497 .84882 L .48687 .84575 L p F P
0 g
s
.52557 .85059 m .48687 .84575 L .49909 .84679 L .169 0 0 r
F
.43119 .83304 m .45941 .84109 L .48226 .84497 L p .183 0 0 r
F P
0 g
s
.48226 .84497 m .50497 .84882 L p .47212 .84179 L .183 0 0 r
F P
0 g
s
.47212 .84179 m .43119 .83304 L .48226 .84497 L .183 0 0 r
F
.48597 .84527 m .46479 .84054 L p .49167 .84598 L F P
0 g
s
.49167 .84598 m .46479 .84054 L .47585 .84259 L .183 0 0 r
F
.48597 .84527 m .46915 .84005 L .44538 .83342 L p 0 .42 .714 r
F P
0 g
s
.43119 .83304 m .40597 .82243 L .3569 .78499 L p .609 .039 0 r
F P
0 g
s
.44538 .83342 m .40597 .82243 L p .45485 .83639 L 0 .42 .714 r
F P
0 g
s
.48597 .84527 m .44538 .83342 L .45485 .83639 L 0 .42 .714 r
F
.46479 .84054 m .43119 .83304 L p .47585 .84259 L .183 0 0 r
F P
0 g
s
.50497 .84882 m .48646 .84536 L p .49167 .84598 L .183 0 0 r
F P
0 g
s
.48646 .84536 m .48597 .84527 L p .49167 .84598 L .183 0 0 r
F P
0 g
s
.5865 .84606 m .61806 .84051 L .61281 .83904 L p .183 .708 .687 r
F P
0 g
s
.61281 .83904 m .59136 .84468 L .5865 .84606 L p .183 .708 .687 r
F P
0 g
s
.61806 .84051 m .64812 .83242 L .63318 .83167 L p .335 .812 .76 r
F P
0 g
s
.63318 .83167 m .61281 .83904 L .61806 .84051 L p .335 .812 .76 r
F P
0 g
s
.49409 .37437 m .48313 .39011 L .45648 .41488 L p .716 .944 .639 r
F P
0 g
s
.44777 .43355 m .45648 .41488 L .48313 .39011 L p .87 .988 .722 r
F P
0 g
s
.66757 .58092 m .66847 .57295 L .65967 .58625 L p .971 .925 .614 r
F P
0 g
s
.65967 .58625 m .65944 .5944 L .66757 .58092 L p .971 .925 .614 r
F P
0 g
s
.51161 .65281 m .52738 .65608 L .54361 .66207 L p .467 0 0 r
F P
0 g
s
.55634 .66169 m .54361 .66207 L .52738 .65608 L p .412 0 0 r
F P
0 g
s
.6863 .88173 m .71088 .86848 L .74102 .8363 L p .06 0 0 r
F P
0 g
s
.76868 .81863 m .74102 .8363 L .71088 .86848 L p 0 0 0 r
F P
0 g
s
.74966 .39596 m .73079 .3846 L .69172 .37817 L p .039 .535 .88 r
F P
0 g
s
.67572 .37324 m .69172 .37817 L .73079 .3846 L p .003 .546 .836 r
F P
0 g
s
.65068 .50353 m .64569 .5018 L .65366 .51699 L p .875 .444 .17 r
F P
0 g
s
.65366 .51699 m .65986 .52014 L .65068 .50353 L p .875 .444 .17 r
F P
0 g
s
.62758 .63439 m .63582 .62679 L .62589 .62738 L p .836 .997 .835 r
F P
0 g
s
.62589 .62738 m .62 .63466 L .62758 .63439 L p .836 .997 .835 r
F P
0 g
s
.83585 .7245 m .84981 .69968 L .85747 .63969 L p 0 0 .242 r
F P
0 g
s
.865 .61348 m .85747 .63969 L .84981 .69968 L p 0 0 .049 r
F P
0 g
s
.44777 .43355 m .44365 .45226 L .42811 .48798 L p .86 .877 .439 r
F P
0 g
s
.42876 .50675 m .42811 .48798 L .44365 .45226 L p .977 .901 .557 r
F P
0 g
s
.64812 .83242 m .67604 .82197 L .652 .82271 L p .492 .903 .831 r
F P
0 g
s
.652 .82271 m .63318 .83167 L .64812 .83242 L p .492 .903 .831 r
F P
0 g
s
.77742 .75263 m .79576 .73232 L .75539 .76139 L p .738 .979 .742 r
F P
0 g
s
.75539 .76139 m .74134 .77875 L .77742 .75263 L p .738 .979 .742 r
F P
0 g
s
.50221 .42028 m .4911 .4349 L .52066 .43001 L p .849 .935 .882 r
F P
0 g
s
.52066 .43001 m .52855 .41812 L .50221 .42028 L p .849 .935 .882 r
F P
0 g
s
.66451 .52426 m .65986 .52014 L .66185 .53724 L p .965 .643 .344 r
F P
0 g
s
.66185 .53724 m .66718 .54243 L .66451 .52426 L p .965 .643 .344 r
F P
0 g
s
.65679 .60282 m .65944 .5944 L .64735 .60233 L p .937 .943 .768 r
F P
0 g
s
.64735 .60233 m .6457 .6105 L .65679 .60282 L p .937 .943 .768 r
F P
0 g
s
.74966 .39596 m .7552 .40095 L p .75961 .4038 L 0 .178 .658 r
F P
0 g
s
.80472 .43938 m .78669 .42151 L .74966 .39596 L p 0 .178 .658 r
F P
0 g
s
.74966 .39596 m .78669 .42151 L p .74111 .39141 L .459 0 0 r
F P
0 g
s
.73079 .3846 m .73804 .38896 L p .74111 .39141 L .459 0 0 r
F P
0 g
s
.73804 .38896 m .74966 .39596 L p .74111 .39141 L .459 0 0 r
F P
0 g
s
.73079 .3846 m .70872 .37577 L .67572 .37324 L p .003 .546 .836 r
F P
0 g
s
.73673 .39383 m .70872 .37577 L p .75024 .39869 L .524 0 0 r
F P
0 g
s
.76376 .40616 m .73079 .3846 L p .77328 .41266 L .459 0 0 r
F P
0 g
s
.76467 .40948 m .80472 .43938 L p .75961 .4038 L 0 .178 .658 r
F P
0 g
s
.7552 .40095 m .76467 .40948 L p .75961 .4038 L 0 .178 .658 r
F P
0 g
s
.76376 .40616 m .75403 .40172 L p .75024 .39869 L .524 0 0 r
F P
0 g
s
.75403 .40172 m .73673 .39383 L p .75024 .39869 L .524 0 0 r
F P
0 g
s
.78669 .42151 m .77876 .4162 L p .77328 .41266 L .459 0 0 r
F P
0 g
s
.77876 .4162 m .76376 .40616 L p .77328 .41266 L .459 0 0 r
F P
0 g
s
.4405 .63702 m .45202 .64861 L .44832 .61312 L p .967 .654 .366 r
F P
0 g
s
.44832 .61312 m .43631 .59989 L .4405 .63702 L p .967 .654 .366 r
F P
0 g
s
.63582 .62679 m .64188 .61874 L .63004 .61982 L p .892 .954 .836 r
F P
0 g
s
.63004 .61982 m .62589 .62738 L .63582 .62679 L p .892 .954 .836 r
F P
0 g
s
.45274 .60766 m .46505 .6189 L .48399 .64107 L p .737 .229 0 r
F P
0 g
s
.49696 .64779 m .48399 .64107 L .46505 .6189 L p .774 .268 0 r
F P
0 g
s
.67053 .54853 m .66718 .54243 L .66311 .55875 L p .994 .789 .519 r
F P
0 g
s
.66311 .55875 m .66689 .56548 L .67053 .54853 L p .994 .789 .519 r
F P
0 g
s
.5198 .65868 m .50961 .65497 L .50117 .65039 L p .474 0 0 r
F P
0 g
s
.49696 .64779 m .51161 .65281 L .51846 .65568 L p .492 0 0 r
F P
0 g
s
.51329 .6541 m .49696 .64779 L .51846 .65568 L .492 0 0 r
F
.53128 .66106 m .5198 .65868 L .49696 .64779 L p F P
0 g
s
.48399 .64107 m .49696 .64779 L .5198 .65868 L p .474 0 0 r
F P
0 g
s
.50117 .65039 m .48399 .64107 L p .50588 .65184 L .474 0 0 r
F P
0 g
s
.5198 .65868 m .50117 .65039 L .50588 .65184 L .474 0 0 r
F
.51846 .65568 m .53128 .66106 L p .51329 .6541 L .492 0 0 r
F P
0 g
s
.54361 .66207 m .53128 .66106 L .51161 .65281 L p .467 0 0 r
F P
0 g
s
.64569 .5018 m .63964 .50097 L .64627 .51495 L p .843 .446 .294 r
F P
0 g
s
.64627 .51495 m .65366 .51699 L .64569 .5018 L p .843 .446 .294 r
F P
0 g
s
.83735 .66587 m .84612 .64127 L .81573 .6885 L p .864 .94 .572 r
F P
0 g
s
.81573 .6885 m .80863 .71077 L .83735 .66587 L p .864 .94 .572 r
F P
0 g
s
.66847 .57295 m .66689 .56548 L .65767 .57863 L p .974 .865 .669 r
F P
0 g
s
.65767 .57863 m .65967 .58625 L .66847 .57295 L p .974 .865 .669 r
F P
0 g
s
.50861 .35959 m .49409 .37437 L .46984 .39679 L p 0 0 0 r
F P
0 g
s
.45648 .41488 m .46984 .39679 L .49409 .37437 L p .716 .944 .639 r
F P
0 g
s
.65809 .37036 m .67572 .37324 L .70872 .37577 L p .004 .569 .794 r
F P
0 g
s
.67604 .82197 m .70123 .80936 L .66886 .81231 L p .631 .962 .883 r
F P
0 g
s
.66886 .81231 m .652 .82271 L .67604 .82197 L p .631 .962 .883 r
F P
0 g
s
.51691 .40658 m .50221 .42028 L .52855 .41812 L p .816 .969 .901 r
F P
0 g
s
.52855 .41812 m .53899 .40689 L .51691 .40658 L p .816 .969 .901 r
F P
0 g
s
.32964 .76642 m .3569 .78499 L .40597 .82243 L p .544 0 0 r
F P
0 g
s
.2272 .53989 m .23692 .57561 L .25196 .652 L p .787 .518 0 r
F P
0 g
s
.26958 .68142 m .25196 .652 L .23692 .57561 L p .935 .607 .162 r
F P
0 g
s
.64188 .61874 m .6457 .6105 L .63244 .61219 L p .896 .889 .816 r
F P
0 g
s
.63244 .61219 m .63004 .61982 L .64188 .61874 L p .896 .889 .816 r
F P
0 g
s
.65944 .5944 m .65967 .58625 L .64695 .59448 L p .925 .869 .764 r
F P
0 g
s
.64695 .59448 m .64735 .60233 L .65944 .5944 L p .925 .869 .764 r
F P
0 g
s
.65986 .52014 m .65366 .51699 L .65495 .53314 L p .922 .614 .441 r
F P
0 g
s
.65495 .53314 m .66185 .53724 L .65986 .52014 L p .922 .614 .441 r
F P
0 g
s
.58135 .65695 m .59288 .65277 L .59457 .64594 L p .578 .936 .787 r
F P
0 g
s
.59288 .65277 m .60333 .64754 L .6013 .64065 L p .745 .993 .842 r
F P
0 g
s
.46821 .68164 m .48097 .68912 L .46658 .65848 L p .882 .454 .163 r
F P
0 g
s
.46658 .65848 m .45202 .64861 L .46821 .68164 L p .882 .454 .163 r
F P
0 g
s
.56905 .65996 m .58135 .65695 L .58704 .65056 L p .374 .823 .702 r
F P
0 g
s
.59457 .64594 m .58704 .65056 L .58135 .65695 L p .578 .936 .787 r
F P
0 g
s
.79162 .79891 m .80932 .77755 L .83585 .7245 L p 0 0 0 r
F P
0 g
s
.84981 .69968 m .83585 .7245 L .80932 .77755 L p 0 0 0 r
F P
0 g
s
.60333 .64754 m .61243 .64145 L .60708 .6348 L p .847 .988 .855 r
F P
0 g
s
.60708 .6348 m .6013 .64065 L .60333 .64754 L p .847 .988 .855 r
F P
0 g
s
.57276 .65639 m .55634 .66169 L .5769 .65554 L 0 0 0 r
F
.5769 .65554 m .57893 .65439 L p .57276 .65639 L F P
0 g
s
.57893 .65439 m .57049 .65738 L .55634 .66169 L p 0 0 0 r
F P
0 g
s
.54361 .66207 m .55634 .66169 L .56748 .65829 L p 0 0 0 r
F P
0 g
s
.56748 .65829 m .57049 .65738 L p .563 .65868 L 0 0 0 r
F P
0 g
s
.563 .65868 m .54361 .66207 L .56748 .65829 L 0 0 0 r
F
.57049 .65738 m .56199 .65945 L .54813 .66142 L p F P
0 g
s
.54813 .66142 m .54361 .66207 L p .55297 .66043 L 0 0 0 r
F P
0 g
s
.57049 .65738 m .54813 .66142 L .55297 .66043 L 0 0 0 r
F
.53128 .66106 m .54361 .66207 L .55796 .66003 L p .094 0 0 r
F P
0 g
s
.55796 .66003 m .56199 .65945 L p .55326 .65991 L .094 0 0 r
F P
0 g
s
.55326 .65991 m .53128 .66106 L .55796 .66003 L .094 0 0 r
F
.56199 .65945 m .55373 .66059 L .53708 .66094 L p F P
0 g
s
.53708 .66094 m .53128 .66106 L p .54236 .66048 L .094 0 0 r
F P
0 g
s
.56199 .65945 m .53708 .66094 L .54236 .66048 L .094 0 0 r
F
.5198 .65868 m .53128 .66106 L .54863 .6607 L p .166 0 0 r
F P
0 g
s
.54863 .6607 m .55373 .66059 L p .54387 .66004 L .166 0 0 r
F P
0 g
s
.54387 .66004 m .5198 .65868 L .54863 .6607 L .166 0 0 r
F
.55373 .66059 m .546 .6608 L .5269 .65925 L p F P
0 g
s
.55373 .66059 m .5269 .65925 L .53245 .65939 L .166 0 0 r
F
.5269 .65925 m .5198 .65868 L p .53245 .65939 L F P
0 g
s
.50961 .65497 m .5198 .65868 L .546 .6608 L p .196 0 0 r
F P
0 g
s
.546 .6608 m .53913 .66012 L .51798 .65643 L p .196 0 0 r
F P
0 g
s
.51798 .65643 m .50961 .65497 L p .52362 .65722 L .196 0 0 r
F P
0 g
s
.546 .6608 m .51798 .65643 L .52362 .65722 L .196 0 0 r
F
.55634 .66169 m .56905 .65996 L .5769 .65554 L p 0 0 0 r
F P
0 g
s
.58704 .65056 m .57893 .65439 L .56905 .65996 L p .374 .823 .702 r
F P
0 g
s
.66718 .54243 m .66185 .53724 L .65748 .553 L p .949 .73 .574 r
F P
0 g
s
.65748 .553 m .66311 .55875 L .66718 .54243 L p .949 .73 .574 r
F P
0 g
s
.61243 .64145 m .62 .63466 L .61178 .62853 L p .89 .944 .84 r
F P
0 g
s
.61178 .62853 m .60708 .6348 L .61243 .64145 L p .89 .944 .84 r
F P
0 g
s
.53499 .39425 m .51691 .40658 L .53899 .40689 L p .751 .983 .908 r
F P
0 g
s
.53899 .40689 m .55182 .39664 L .53499 .39425 L p .751 .983 .908 r
F P
0 g
s
.71088 .86848 m .73216 .85342 L .76868 .81863 L p 0 0 0 r
F P
0 g
s
.79162 .79891 m .76868 .81863 L .73216 .85342 L p 0 0 0 r
F P
0 g
s
.42811 .48798 m .43231 .46868 L .44777 .43355 L p .86 .877 .439 r
F P
0 g
s
.45648 .41488 m .44777 .43355 L .43231 .46868 L p 0 0 0 r
F P
0 g
s
.66689 .56548 m .66311 .55875 L .65372 .57178 L p .933 .792 .682 r
F P
0 g
s
.65372 .57178 m .65767 .57863 L .66689 .56548 L p .933 .792 .682 r
F P
0 g
s
.6457 .6105 m .64735 .60233 L .63316 .60468 L p .878 .823 .79 r
F P
0 g
s
.63316 .60468 m .63244 .61219 L .6457 .6105 L p .878 .823 .79 r
F P
0 g
s
.70872 .37577 m .68424 .36974 L .65809 .37036 L p .004 .569 .794 r
F P
0 g
s
.63944 .36964 m .65809 .37036 L .68424 .36974 L p .044 .61 .768 r
F P
0 g
s
.62 .63466 m .62589 .62738 L .61531 .62198 L p .896 .884 .813 r
F P
0 g
s
.61531 .62198 m .61178 .62853 L .62 .63466 L p .896 .884 .813 r
F P
0 g
s
.65366 .51699 m .64627 .51495 L .64689 .53026 L p .867 .576 .492 r
F P
0 g
s
.64689 .53026 m .65495 .53314 L .65366 .51699 L p .867 .576 .492 r
F P
0 g
s
.52645 .34624 m .50861 .35959 L .48774 .37983 L p 0 0 0 r
F P
0 g
s
.46984 .39679 m .48774 .37983 L .50861 .35959 L p 0 0 0 r
F P
0 g
s
.65967 .58625 m .65767 .57863 L .64472 .58715 L p .892 .799 .75 r
F P
0 g
s
.64472 .58715 m .64695 .59448 L .65967 .58625 L p .892 .799 .75 r
F P
0 g
s
.48399 .64107 m .47324 .63279 L .45274 .60766 L p .737 .229 0 r
F P
0 g
s
.44363 .59482 m .45274 .60766 L .47324 .63279 L p .601 .135 0 r
F P
0 g
s
.70123 .80936 m .72316 .79485 L .6834 .80068 L p .734 .982 .909 r
F P
0 g
s
.6834 .80068 m .66886 .81231 L .70123 .80936 L p .734 .982 .909 r
F P
0 g
s
.43262 .62394 m .4405 .63702 L .43631 .59989 L p .961 .66 .24 r
F P
0 g
s
.43631 .59989 m .42799 .58505 L .43262 .62394 L p .961 .66 .24 r
F P
0 g
s
.32964 .76642 m .30793 .74505 L .26958 .68142 L p .8 .337 0 r
F P
0 g
s
.25196 .652 m .26958 .68142 L .30793 .74505 L p .645 .229 0 r
F P
0 g
s
.62589 .62738 m .63004 .61982 L .61764 .61529 L p .882 .823 .785 r
F P
0 g
s
.61764 .61529 m .61531 .62198 L .62589 .62738 L p .882 .823 .785 r
F P
0 g
s
.55607 .38372 m .53499 .39425 L .55182 .39664 L p .649 .967 .897 r
F P
0 g
s
.55182 .39664 m .56678 .38767 L .55607 .38372 L p .649 .967 .897 r
F P
0 g
s
.66185 .53724 m .65495 .53314 L .65041 .54836 L p .893 .674 .599 r
F P
0 g
s
.65041 .54836 m .65748 .553 L .66185 .53724 L p .893 .674 .599 r
F P
0 g
s
.79576 .73232 m .80863 .71077 L .765 .74316 L p .857 .997 .805 r
F P
0 g
s
.765 .74316 m .75539 .76139 L .79576 .73232 L p .857 .997 .805 r
F P
0 g
s
.64735 .60233 m .64695 .59448 L .63234 .59749 L p .85 .765 .767 r
F P
0 g
s
.63234 .59749 m .63316 .60468 L .64735 .60233 L p .85 .765 .767 r
F P
0 g
s
.68424 .36974 m .6582 .36669 L .63944 .36964 L p .044 .61 .768 r
F P
0 g
s
.62038 .3711 m .63944 .36964 L .6582 .36669 L p .121 .672 .765 r
F P
0 g
s
.66311 .55875 m .65748 .553 L .6482 .56587 L p .885 .729 .683 r
F P
0 g
s
.6482 .56587 m .65372 .57178 L .66311 .55875 L p .885 .729 .683 r
F P
0 g
s
.63004 .61982 m .63244 .61219 L .61881 .6086 L p .859 .767 .759 r
F P
0 g
s
.61881 .6086 m .61764 .61529 L .63004 .61982 L p .859 .767 .759 r
F P
0 g
s
.57963 .37541 m .55607 .38372 L .56678 .38767 L p .516 .916 .867 r
F P
0 g
s
.56678 .38767 m .5835 .38028 L .57997 .37584 L p .516 .916 .867 r
F P
0 g
s
.56678 .38767 m .57997 .37584 L .57864 .37635 L .516 .916 .867 r
F
.57661 .38551 m .54722 .3942 L .55454 .38553 L p .1 0 0 r
F P
0 g
s
.55454 .38553 m .55607 .38372 L p .55868 .38395 L .1 0 0 r
F P
0 g
s
.55868 .38395 m .57661 .38551 L .55454 .38553 L .1 0 0 r
F
.57997 .37584 m .57963 .37541 L p .57864 .37635 L .516 .916 .867 r
F P
0 g
s
.59633 .56201 m .59641 .56614 L .60005 .57191 L p .601 .372 .541 r
F P
0 g
s
.60005 .57191 m .59851 .56799 L .59633 .56201 L p .601 .372 .541 r
F P
0 g
s
.65767 .57863 m .65372 .57178 L .64094 .58054 L p .854 .739 .736 r
F P
0 g
s
.64094 .58054 m .64472 .58715 L .65767 .57863 L p .854 .739 .736 r
F P
0 g
s
.47324 .63279 m .48399 .64107 L .50961 .65497 L p .398 0 0 r
F P
0 g
s
.6582 .36669 m .6315 .36668 L .62038 .3711 L p .121 .672 .765 r
F P
0 g
s
.60154 .37469 m .62038 .3711 L .6315 .36668 L p .233 .751 .786 r
F P
0 g
s
.45822 .67271 m .46821 .68164 L .45202 .64861 L p .859 .424 .003 r
F P
0 g
s
.45202 .64861 m .4405 .63702 L .45822 .67271 L p .859 .424 .003 r
F P
0 g
s
.43231 .46868 m .42811 .48798 L .42615 .52684 L p 0 0 .106 r
F P
0 g
s
.48774 .37983 m .50993 .36456 L .52645 .34624 L p 0 0 0 r
F P
0 g
s
.60503 .36964 m .57963 .37541 L .5835 .38028 L p .37 .838 .825 r
F P
0 g
s
.5835 .38028 m .60154 .37469 L .60472 .37007 L p .37 .838 .825 r
F P
0 g
s
.5835 .38028 m .60472 .37007 L .60342 .37043 L .37 .838 .825 r
F
.60826 .37998 m .57661 .38551 L .57913 .37709 L p .25 0 0 r
F P
0 g
s
.57913 .37709 m .57963 .37541 L p .58318 .37598 L .25 0 0 r
F P
0 g
s
.58318 .37598 m .60826 .37998 L .57913 .37709 L .25 0 0 r
F
.60472 .37007 m .60503 .36964 L p .60342 .37043 L .37 .838 .825 r
F P
0 g
s
.60164 .57612 m .60005 .57191 L .59641 .56614 L p .647 .408 .543 r
F P
0 g
s
.59641 .56614 m .59649 .57027 L .60164 .57612 L p .647 .408 .543 r
F P
0 g
s
.6315 .36668 m .60503 .36964 L .60154 .37469 L p .233 .751 .786 r
F P
0 g
s
.64695 .59448 m .64472 .58715 L .63017 .59078 L p .819 .713 .748 r
F P
0 g
s
.63017 .59078 m .63234 .59749 L .64695 .59448 L p .819 .713 .748 r
F P
0 g
s
.63244 .61219 m .63316 .60468 L .61887 .60206 L p .832 .716 .737 r
F P
0 g
s
.61887 .60206 m .61881 .6086 L .63244 .61219 L p .832 .716 .737 r
F P
0 g
s
.65495 .53314 m .64689 .53026 L .64236 .54497 L p .841 .627 .612 r
F P
0 g
s
.64236 .54497 m .65041 .54836 L .65495 .53314 L p .841 .627 .612 r
F P
0 g
s
.48005 .43463 m .46621 .45112 L .4911 .4349 L p .781 .991 .759 r
F P
0 g
s
.4911 .4349 m .50221 .42028 L .48005 .43463 L p .781 .991 .759 r
F P
0 g
s
.84981 .69968 m .85702 .67403 L .865 .61348 L p 0 0 .049 r
F P
0 g
s
.8653 .58708 m .865 .61348 L .85702 .67403 L p .828 .726 .198 r
F P
0 g
s
.60764 .57513 m .60447 .5713 L .59851 .56799 L p .592 .388 .574 r
F P
0 g
s
.59851 .56799 m .60005 .57191 L .60764 .57513 L p .592 .388 .574 r
F P
0 g
s
.60316 .58061 m .60164 .57612 L .59649 .57027 L p .689 .442 .543 r
F P
0 g
s
.59649 .57027 m .59657 .57442 L .60316 .58061 L p .689 .442 .543 r
F P
0 g
s
.65748 .553 m .65041 .54836 L .64151 .56105 L p .839 .676 .681 r
F P
0 g
s
.64151 .56105 m .6482 .56587 L .65748 .553 L p .839 .676 .681 r
F P
0 g
s
.59457 .64594 m .6013 .64065 L .59922 .62817 L p .932 .969 .705 r
F P
0 g
s
.6013 .64065 m .60708 .6348 L .60182 .62295 L p .963 .918 .715 r
F P
0 g
s
.60182 .62295 m .59922 .62817 L .6013 .64065 L p .963 .918 .715 r
F P
0 g
s
.58704 .65056 m .59457 .64594 L .59612 .63313 L p .821 .968 .651 r
F P
0 g
s
.59922 .62817 m .59612 .63313 L .59457 .64594 L p .932 .969 .705 r
F P
0 g
s
.46984 .39679 m .45648 .41488 L .44165 .44935 L p 0 0 0 r
F P
0 g
s
.43231 .46868 m .44165 .44935 L .45648 .41488 L p 0 0 0 r
F P
0 g
s
.63316 .60468 m .63234 .59749 L .61793 .59579 L p .802 .67 .718 r
F P
0 g
s
.61793 .59579 m .61887 .60206 L .63316 .60468 L p .802 .67 .718 r
F P
0 g
s
.65372 .57178 m .6482 .56587 L .63594 .5748 L p .816 .688 .724 r
F P
0 g
s
.63594 .5748 m .64094 .58054 L .65372 .57178 L p .816 .688 .724 r
F P
0 g
s
.72316 .79485 m .74134 .77875 L .69529 .78801 L p .798 .97 .911 r
F P
0 g
s
.69529 .78801 m .6834 .80068 L .72316 .79485 L p .798 .97 .911 r
F P
0 g
s
.60708 .6348 m .61178 .62853 L .60387 .61756 L p .952 .851 .705 r
F P
0 g
s
.60387 .61756 m .60182 .62295 L .60708 .6348 L p .952 .851 .705 r
F P
0 g
s
.61079 .57951 m .60764 .57513 L .60005 .57191 L p .638 .434 .59 r
F P
0 g
s
.60005 .57191 m .60164 .57612 L .61079 .57951 L p .638 .434 .59 r
F P
0 g
s
.57893 .65439 m .58704 .65056 L .5926 .63777 L p .61 .874 .54 r
F P
0 g
s
.59612 .63313 m .5926 .63777 L .58704 .65056 L p .821 .968 .651 r
F P
0 g
s
.61178 .62853 m .61531 .62198 L .60533 .61206 L p .924 .787 .69 r
F P
0 g
s
.60533 .61206 m .60387 .61756 L .61178 .62853 L p .924 .787 .69 r
F P
0 g
s
.60451 .58538 m .60316 .58061 L .59657 .57442 L p .729 .474 .541 r
F P
0 g
s
.59657 .57442 m .59665 .57858 L .60451 .58538 L p .729 .474 .541 r
F P
0 g
s
.64472 .58715 m .64094 .58054 L .6269 .58468 L p .786 .668 .732 r
F P
0 g
s
.6269 .58468 m .63017 .59078 L .64472 .58715 L p .786 .668 .732 r
F P
0 g
s
.84612 .64127 m .84814 .61637 L .8169 .66606 L p .961 .945 .667 r
F P
0 g
s
.8169 .66606 m .81573 .6885 L .84612 .64127 L p .961 .945 .667 r
F P
0 g
s
.61531 .62198 m .61764 .61529 L .6062 .60652 L p .891 .729 .674 r
F P
0 g
s
.6062 .60652 m .60533 .61206 L .61531 .62198 L p .891 .729 .674 r
F P
0 g
s
.57049 .65738 m .57893 .65439 L .58729 .64389 L p 0 0 0 r
F P
0 g
s
.58729 .64389 m .58809 .64289 L p .58619 .64445 L 0 0 0 r
F P
0 g
s
.58619 .64445 m .57049 .65738 L .58729 .64389 L 0 0 0 r
F
.5867 .64378 m .57049 .65738 L .58809 .64289 L F
.58809 .64289 m .58876 .64205 L p .5867 .64378 L F P
0 g
s
.58876 .64205 m .58472 .64592 L .57049 .65738 L p 0 0 0 r
F P
0 g
s
.56199 .65945 m .57049 .65738 L .58263 .64761 L p 0 0 0 r
F P
0 g
s
.58263 .64761 m .58472 .64592 L p .58062 .64836 L 0 0 0 r
F P
0 g
s
.58062 .64836 m .56199 .65945 L .58263 .64761 L 0 0 0 r
F
.58472 .64592 m .58063 .64934 L .5794 .65001 L p F P
0 g
s
.5794 .65001 m .56338 .6587 L p .58061 .64838 L 0 0 0 r
F P
0 g
s
.58472 .64592 m .5794 .65001 L .58061 .64838 L 0 0 0 r
F
.58472 .64592 m .56338 .6587 L .56504 .65764 L F
.56338 .6587 m .56199 .65945 L p .56504 .65764 L F P
0 g
s
.55373 .66059 m .56199 .65945 L .58063 .64934 L p .081 0 0 r
F P
0 g
s
.58063 .64934 m .57663 .65231 L .55671 .65951 L p .081 0 0 r
F P
0 g
s
.58063 .64934 m .55671 .65951 L .55853 .65858 L .081 0 0 r
F
.55671 .65951 m .55373 .66059 L p .55853 .65858 L F P
0 g
s
.546 .6608 m .55373 .66059 L .57513 .65285 L p .22 0 0 r
F P
0 g
s
.57513 .65285 m .57663 .65231 L p .57328 .65324 L .22 0 0 r
F P
0 g
s
.57328 .65324 m .546 .6608 L .57513 .65285 L .22 0 0 r
F
.57663 .65231 m .57289 .65482 L .54961 .66 L p F P
0 g
s
.57663 .65231 m .54961 .66 L .55162 .65925 L .22 0 0 r
F
.54961 .66 m .546 .6608 L p .55162 .65925 L F P
0 g
s
.53913 .66012 m .546 .6608 L .57289 .65482 L p .32 0 0 r
F P
0 g
s
.57289 .65482 m .56955 .65689 L .54159 .65986 L p .32 0 0 r
F P
0 g
s
.54159 .65986 m .53913 .66012 L p .54401 .65935 L .32 0 0 r
F P
0 g
s
.57289 .65482 m .54159 .65986 L .54401 .65935 L .32 0 0 r
F
.5926 .63777 m .58876 .64205 L .57893 .65439 L p .61 .874 .54 r
F P
0 g
s
.6137 .58444 m .61079 .57951 L .60164 .57612 L p .679 .475 .603 r
F P
0 g
s
.60164 .57612 m .60316 .58061 L .6137 .58444 L p .679 .475 .603 r
F P
0 g
s
.63234 .59749 m .63017 .59078 L .61615 .58988 L p .77 .628 .703 r
F P
0 g
s
.61615 .58988 m .61793 .59579 L .63234 .59749 L p .77 .628 .703 r
F P
0 g
s
.61764 .61529 m .61881 .6086 L .6065 .60102 L p .856 .678 .66 r
F P
0 g
s
.6065 .60102 m .6062 .60652 L .61764 .61529 L p .856 .678 .66 r
F P
0 g
s
.47324 .63279 m .46526 .62313 L .44363 .59482 L p .601 .135 0 r
F P
0 g
s
.43829 .58064 m .44363 .59482 L .46526 .62313 L p 0 .001 .572 r
F P
0 g
s
.61817 .5747 m .61335 .57091 L .60447 .5713 L p .617 .462 .648 r
F P
0 g
s
.60447 .5713 m .60764 .57513 L .61817 .5747 L p .617 .462 .648 r
F P
0 g
s
.60558 .5904 m .60451 .58538 L .59665 .57858 L p .769 .506 .538 r
F P
0 g
s
.59665 .57858 m .59673 .58275 L .60558 .5904 L p .769 .506 .538 r
F P
0 g
s
.73216 .85342 m .74967 .83685 L .79162 .79891 L p 0 0 0 r
F P
0 g
s
.80932 .77755 m .79162 .79891 L .74967 .83685 L p .662 .927 .635 r
F P
0 g
s
.65041 .54836 m .64236 .54497 L .63408 .55738 L p .795 .632 .68 r
F P
0 g
s
.63408 .55738 m .64151 .56105 L .65041 .54836 L p .795 .632 .68 r
F P
0 g
s
.61881 .6086 m .61887 .60206 L .60627 .59563 L p .821 .632 .647 r
F P
0 g
s
.60627 .59563 m .6065 .60102 L .61881 .6086 L p .821 .632 .647 r
F P
0 g
s
.61615 .58988 m .6137 .58444 L .60316 .58061 L p .716 .514 .614 r
F P
0 g
s
.60316 .58061 m .60451 .58538 L .61615 .58988 L p .716 .514 .614 r
F P
0 g
s
.70872 .37577 m .73079 .3846 L .76376 .40616 L p .524 0 0 r
F P
0 g
s
.6482 .56587 m .64151 .56105 L .63009 .57002 L p .777 .644 .715 r
F P
0 g
s
.63009 .57002 m .63594 .5748 L .6482 .56587 L p .777 .644 .715 r
F P
0 g
s
.64094 .58054 m .63594 .5748 L .6228 .5793 L p .752 .626 .72 r
F P
0 g
s
.6228 .5793 m .6269 .58468 L .64094 .58054 L p .752 .626 .72 r
F P
0 g
s
.6228 .5793 m .61817 .5747 L .60764 .57513 L p .663 .507 .663 r
F P
0 g
s
.60764 .57513 m .61079 .57951 L .6228 .5793 L p .663 .507 .663 r
F P
0 g
s
.40597 .82243 m .38456 .80947 L .32964 .76642 L p .544 0 0 r
F P
0 g
s
.30793 .74505 m .32964 .76642 L .38456 .80947 L p 0 .105 .584 r
F P
0 g
s
.63017 .59078 m .6269 .58468 L .6137 .58444 L p .737 .588 .689 r
F P
0 g
s
.6137 .58444 m .61615 .58988 L .63017 .59078 L p .737 .588 .689 r
F P
0 g
s
.43262 .62394 m .42799 .58505 L p .4289 .60943 L .824 .581 .027 r
F P
0 g
s
.42799 .58505 m .42395 .56894 L .42891 .6097 L p .824 .581 .027 r
F P
0 g
s
.42466 .55195 m .42985 .59469 L p .42403 .56931 L 0 0 .225 r
F P
0 g
s
.42395 .56894 m .42396 .5687 L p .42403 .56931 L 0 0 .225 r
F P
0 g
s
.42396 .5687 m .42466 .55195 L p .42403 .56931 L 0 0 .225 r
F P
0 g
s
.42891 .6097 m .42895 .60987 L p .4289 .60943 L .824 .581 .027 r
F P
0 g
s
.42895 .60987 m .43262 .62394 L p .4289 .60943 L .824 .581 .027 r
F P
0 g
s
.61887 .60206 m .61793 .59579 L .60558 .5904 L p .787 .591 .635 r
F P
0 g
s
.60558 .5904 m .60627 .59563 L .61887 .60206 L p .787 .591 .635 r
F P
0 g
s
.60627 .59563 m .60558 .5904 L .59673 .58275 L p .809 .54 .531 r
F P
0 g
s
.59673 .58275 m .59682 .58692 L .60627 .59563 L p .809 .54 .531 r
F P
0 g
s
.4972 .70897 m .50692 .71328 L .48097 .68912 L p .665 .12 0 r
F P
0 g
s
.48097 .68912 m .46821 .68164 L .4972 .70897 L p .665 .12 0 r
F P
0 g
s
.78669 .42151 m .80472 .43938 L .83256 .48243 L p .771 .294 0 r
F P
0 g
s
.61793 .59579 m .61615 .58988 L .60451 .58538 L p .752 .552 .625 r
F P
0 g
s
.60451 .58538 m .60558 .5904 L .61793 .59579 L p .752 .552 .625 r
F P
0 g
s
.6269 .58468 m .6228 .5793 L .61079 .57951 L p .702 .548 .676 r
F P
0 g
s
.61079 .57951 m .6137 .58444 L .6269 .58468 L p .702 .548 .676 r
F P
0 g
s
.50961 .65497 m .50115 .65005 L .47324 .63279 L p .398 0 0 r
F P
0 g
s
.46526 .62313 m .47324 .63279 L .50115 .65005 L p 0 .237 .707 r
F P
0 g
s
.80932 .77755 m .82134 .755 L .84981 .69968 L p 0 0 0 r
F P
0 g
s
.85702 .67403 m .84981 .69968 L .82134 .755 L p .843 .899 .483 r
F P
0 g
s
.63009 .57002 m .62379 .56625 L .61335 .57091 L p .675 .546 .7 r
F P
0 g
s
.61335 .57091 m .61817 .5747 L .63009 .57002 L p .675 .546 .7 r
F P
0 g
s
.49838 .41927 m .48005 .43463 L .50221 .42028 L p .591 .91 .66 r
F P
0 g
s
.50221 .42028 m .51691 .40658 L .49838 .41927 L p .591 .91 .66 r
F P
0 g
s
.63594 .5748 m .63009 .57002 L .61817 .5747 L p .715 .586 .709 r
F P
0 g
s
.61817 .5747 m .6228 .5793 L .63594 .5748 L p .715 .586 .709 r
F P
0 g
s
.6065 .60102 m .60627 .59563 L .59682 .58692 L p .852 .576 .52 r
F P
0 g
s
.59682 .58692 m .5969 .59111 L .6065 .60102 L p .852 .576 .52 r
F P
0 g
s
.64151 .56105 m .63408 .55738 L .62379 .56625 L p .738 .605 .709 r
F P
0 g
s
.62379 .56625 m .63009 .57002 L .64151 .56105 L p .738 .605 .709 r
F P
0 g
s
.6062 .60652 m .6065 .60102 L .5969 .59111 L p .897 .615 .502 r
F P
0 g
s
.60533 .61206 m .6062 .60652 L .59698 .59531 L p .942 .658 .471 r
F P
0 g
s
.5969 .59111 m .59698 .59531 L .6062 .60652 L p .897 .615 .502 r
F P
0 g
s
.40597 .82243 m .43119 .83304 L .48597 .84527 L p 0 .42 .714 r
F P
0 g
s
.45151 .66255 m .45822 .67271 L .4405 .63702 L p .719 .322 0 r
F P
0 g
s
.4405 .63702 m .43262 .62394 L .45151 .66255 L p .719 .322 0 r
F P
0 g
s
.60387 .61756 m .60533 .61206 L .59706 .59952 L p .98 .699 .414 r
F P
0 g
s
.59698 .59531 m .59706 .59952 L .60533 .61206 L p .942 .658 .471 r
F P
0 g
s
.60182 .62295 m .60387 .61756 L .59714 .60374 L p .976 .717 .305 r
F P
0 g
s
.59706 .59952 m .59714 .60374 L .60387 .61756 L p .98 .699 .414 r
F P
0 g
s
.80863 .71077 m .81573 .6885 L .76999 .72445 L p .902 .961 .82 r
F P
0 g
s
.76999 .72445 m .765 .74316 L .80863 .71077 L p .902 .961 .82 r
F P
0 g
s
.59922 .62817 m .60182 .62295 L .59722 .60797 L p .848 .653 .113 r
F P
0 g
s
.59714 .60374 m .59722 .60797 L .60182 .62295 L p .976 .717 .305 r
F P
0 g
s
.44165 .44935 m .43231 .46868 L .43015 .50861 L p 0 0 .285 r
F P
0 g
s
.42615 .52684 m .43015 .50861 L .43231 .46868 L p 0 0 .106 r
F P
0 g
s
.50115 .65005 m .50961 .65497 L .53913 .66012 L p .182 0 0 r
F P
0 g
s
.59612 .63313 m .59922 .62817 L .5973 .6122 L p 0 0 .13 r
F P
0 g
s
.59722 .60797 m .5973 .6122 L .59922 .62817 L p .848 .653 .113 r
F P
0 g
s
.74134 .77875 m .75539 .76139 L .70431 .77457 L p .83 .938 .898 r
F P
0 g
s
.70431 .77457 m .69529 .78801 L .74134 .77875 L p .83 .938 .898 r
F P
0 g
s
.48774 .37983 m .46984 .39679 L .45622 .43058 L p .024 0 .12 r
F P
0 g
s
.44165 .44935 m .45622 .43058 L .46984 .39679 L p 0 0 0 r
F P
0 g
s
.5973 .6122 m .59739 .61645 L .59612 .63313 L p 0 0 .13 r
F P
0 g
s
.5926 .63777 m .59612 .63313 L .59739 .61645 L p 0 0 .319 r
F P
0 g
s
.59739 .61645 m .59747 .62071 L .5926 .63777 L p 0 0 .319 r
F P
0 g
s
.58876 .64205 m .5926 .63777 L .59747 .62071 L p .073 0 .425 r
F P
0 g
s
.68424 .36974 m .70872 .37577 L .73673 .39383 L p .532 0 0 r
F P
0 g
s
.25196 .652 m .24267 .62021 L .2272 .53989 L p .787 .518 0 r
F P
0 g
s
.22713 .50233 m .2272 .53989 L .24267 .62021 L p 0 0 .281 r
F P
0 g
s
.52093 .40562 m .49838 .41927 L .51691 .40658 L p 0 0 0 r
F P
0 g
s
.51691 .40658 m .53499 .39425 L .52093 .40562 L p 0 0 0 r
F P
0 g
s
.71088 .86848 m .6863 .88173 L .65327 .89015 L p .489 .899 .8 r
F P
0 g
s
.59747 .62071 m .59755 .62498 L .58876 .64205 L p .073 0 .425 r
F P
0 g
s
.58472 .64592 m .58876 .64205 L .59755 .62498 L p .251 .105 .479 r
F P
0 g
s
.48969 .7036 m .4972 .70897 L .46821 .68164 L p .54 .024 0 r
F P
0 g
s
.46821 .68164 m .45822 .67271 L .48969 .7036 L p .54 .024 0 r
F P
0 g
s
.4372 .56549 m .43829 .58064 L .46053 .61232 L p 0 .133 .674 r
F P
0 g
s
.46526 .62313 m .46053 .61232 L .43829 .58064 L p 0 .001 .572 r
F P
0 g
s
.46053 .61232 m .46526 .62313 L .49485 .64404 L p 0 .307 .795 r
F P
0 g
s
.50115 .65005 m .49485 .64404 L .46526 .62313 L p 0 .237 .707 r
F P
0 g
s
.59755 .62498 m .59763 .62926 L .58472 .64592 L p .251 .105 .479 r
F P
0 g
s
.58063 .64934 m .58472 .64592 L .59763 .62926 L p .373 .196 .509 r
F P
0 g
s
.53913 .66012 m .53342 .65861 L .50115 .65005 L p .182 0 0 r
F P
0 g
s
.49485 .64404 m .50115 .65005 L .53342 .65861 L p 0 .431 .774 r
F P
0 g
s
.42985 .59469 m .42891 .6097 L .42395 .56894 L p 0 0 .225 r
F P
0 g
s
.30793 .74505 m .29275 .72127 L .25196 .652 L p .645 .229 0 r
F P
0 g
s
.24267 .62021 m .25196 .652 L .29275 .72127 L p 0 0 .519 r
F P
0 g
s
.59763 .62926 m .59772 .63356 L .58063 .64934 L p .373 .196 .509 r
F P
0 g
s
.57663 .65231 m .58063 .64934 L .59772 .63356 L p .461 .263 .525 r
F P
0 g
s
.74967 .83685 m .76301 .81908 L .80932 .77755 L p .662 .927 .635 r
F P
0 g
s
.82134 .755 m .80932 .77755 L .76301 .81908 L p .833 .993 .742 r
F P
0 g
s
.85702 .67403 m .85725 .64819 L .8653 .58708 L p .828 .726 .198 r
F P
0 g
s
.85834 .56123 m .8653 .58708 L .85725 .64819 L p .981 .796 .389 r
F P
0 g
s
.46621 .45112 m .48005 .43463 L .4647 .46169 L p 0 0 0 r
F P
0 g
s
.54722 .3942 m .52093 .40562 L .53499 .39425 L p 0 0 0 r
F P
0 g
s
.53499 .39425 m .55607 .38372 L .54722 .3942 L p 0 0 0 r
F P
0 g
s
.59136 .84468 m .61281 .83904 L .60634 .81658 L p .722 .979 .914 r
F P
0 g
s
.61281 .83904 m .63318 .83167 L .61557 .81049 L p .789 .971 .914 r
F P
0 g
s
.61557 .81049 m .60634 .81658 L .61281 .83904 L p .789 .971 .914 r
F P
0 g
s
.83256 .48243 m .81258 .46142 L .78669 .42151 L p .771 .294 0 r
F P
0 g
s
.76376 .40616 m .78669 .42151 L .81258 .46142 L p .819 .338 .021 r
F P
0 g
s
.56931 .84852 m .59136 .84468 L .59658 .82189 L p .623 .959 .895 r
F P
0 g
s
.60634 .81658 m .59658 .82189 L .59136 .84468 L p .722 .979 .914 r
F P
0 g
s
.73673 .39383 m .70657 .38487 L .68424 .36974 L p .532 0 0 r
F P
0 g
s
.6582 .36669 m .68424 .36974 L .70657 .38487 L p .501 0 0 r
F P
0 g
s
.50993 .36456 m .48774 .37983 L .47596 .41299 L p .22 0 .216 r
F P
0 g
s
.45622 .43058 m .47596 .41299 L .48774 .37983 L p .024 0 .12 r
F P
0 g
s
.53342 .65861 m .53913 .66012 L .56955 .65689 L p .393 0 0 r
F P
0 g
s
.84814 .61637 m .84336 .59183 L .81215 .644 L p .967 .89 .7 r
F P
0 g
s
.81215 .644 m .8169 .66606 L .84814 .61637 L p .967 .89 .7 r
F P
0 g
s
.65327 .89015 m .66793 .88001 L .71088 .86848 L p .489 .899 .8 r
F P
0 g
s
.73216 .85342 m .71088 .86848 L .66793 .88001 L p .634 .964 .861 r
F P
0 g
s
.44853 .65145 m .45151 .66255 L .43262 .62394 L p 0 0 .453 r
F P
0 g
s
.43262 .62394 m .42891 .6097 L .44853 .65145 L p 0 0 .453 r
F P
0 g
s
.63318 .83167 m .652 .82271 L .62405 .80367 L p .827 .943 .901 r
F P
0 g
s
.62405 .80367 m .61557 .81049 L .63318 .83167 L p .827 .943 .901 r
F P
0 g
s
.59772 .63356 m .5978 .63786 L .57663 .65231 L p .461 .263 .525 r
F P
0 g
s
.57289 .65482 m .57663 .65231 L .5978 .63786 L p .529 .316 .534 r
F P
0 g
s
.5472 .85049 m .56931 .84852 L .58653 .82636 L p .498 .907 .857 r
F P
0 g
s
.59658 .82189 m .58653 .82636 L .56931 .84852 L p .623 .959 .895 r
F P
0 g
s
.75539 .76139 m .765 .74316 L .71029 .76061 L p .841 .897 .879 r
F P
0 g
s
.71029 .76061 m .70431 .77457 L .75539 .76139 L p .841 .897 .879 r
F P
0 g
s
.38456 .80947 m .40597 .82243 L .46915 .84005 L p 0 .439 .786 r
F P
0 g
s
.45622 .43058 m .44165 .44935 L .4394 .49031 L p .107 0 .387 r
F P
0 g
s
.43015 .50861 m .4394 .49031 L .44165 .44935 L p 0 0 .285 r
F P
0 g
s
.652 .82271 m .66886 .81231 L .63159 .79622 L p .842 .905 .88 r
F P
0 g
s
.63159 .79622 m .62405 .80367 L .652 .82271 L p .842 .905 .88 r
F P
0 g
s
.55607 .38372 m .57963 .37541 L .57661 .38551 L p .1 0 0 r
F P
0 g
s
.56955 .65689 m .57289 .65482 L .59788 .64217 L p .585 .359 .54 r
F P
0 g
s
.5978 .63786 m .59788 .64217 L .57289 .65482 L p .529 .316 .534 r
F P
0 g
s
.5381 .72737 m .54375 .7279 L .50692 .71328 L p .296 0 0 r
F P
0 g
s
.53382 .72625 m .5381 .72737 L .4972 .70897 L p 0 .343 .756 r
F P
0 g
s
.53114 .72466 m .53382 .72625 L .52199 .72018 L p 0 .398 .839 r
F P
0 g
s
.5168 .71779 m .5381 .72737 L p .51079 .71503 L .296 0 0 r
F P
0 g
s
.52199 .72018 m .48969 .7036 L p .52555 .72182 L 0 .398 .839 r
F P
0 g
s
.52555 .72182 m .53114 .72466 L .52199 .72018 L 0 .398 .839 r
F
.50692 .71328 m .4972 .70897 L .5168 .71779 L p .296 0 0 r
F P
0 g
s
.50692 .71328 m .5168 .71779 L .51079 .71503 L .296 0 0 r
F
.82134 .755 m .82737 .73178 L .85702 .67403 L p .843 .899 .483 r
F P
0 g
s
.85725 .64819 m .85702 .67403 L .82737 .73178 L p .966 .928 .607 r
F P
0 g
s
.52557 .85059 m .5472 .85049 L .57646 .82997 L p .362 .833 .808 r
F P
0 g
s
.58653 .82636 m .57646 .82997 L .5472 .85049 L p .498 .907 .857 r
F P
0 g
s
.70657 .38487 m .67435 .37954 L .6582 .36669 L p .501 0 0 r
F P
0 g
s
.6315 .36668 m .6582 .36669 L .67435 .37954 L p .444 0 0 r
F P
0 g
s
.81573 .6885 m .8169 .66606 L .7703 .70569 L p .906 .906 .812 r
F P
0 g
s
.7703 .70569 m .76999 .72445 L .81573 .6885 L p .906 .906 .812 r
F P
0 g
s
.48479 .69734 m .48969 .7036 L .45822 .67271 L p 0 .1 .636 r
F P
0 g
s
.45822 .67271 m .45151 .66255 L .48479 .69734 L p 0 .1 .636 r
F P
0 g
s
.29275 .72127 m .30793 .74505 L .36773 .79441 L p 0 .202 .716 r
F P
0 g
s
.38456 .80947 m .36773 .79441 L .30793 .74505 L p 0 .105 .584 r
F P
0 g
s
.49485 .64404 m .49111 .63715 L .46053 .61232 L p 0 .307 .795 r
F P
0 g
s
.49111 .63715 m .49485 .64404 L .52917 .65638 L p 0 .46 .852 r
F P
0 g
s
.53342 .65861 m .52917 .65638 L .49485 .64404 L p 0 .431 .774 r
F P
0 g
s
.56955 .65689 m .56677 .65856 L .53342 .65861 L p .393 0 0 r
F P
0 g
s
.52917 .65638 m .53342 .65861 L .56677 .65856 L p .44 0 0 r
F P
0 g
s
.46053 .61232 m .4595 .60067 L .4372 .56549 L p 0 .133 .674 r
F P
0 g
s
.4595 .60067 m .46053 .61232 L .49111 .63715 L p .084 .361 .83 r
F P
0 g
s
.57963 .37541 m .60503 .36964 L .60826 .37998 L p .25 0 0 r
F P
0 g
s
.67435 .37954 m .6412 .37793 L .6315 .36668 L p .444 0 0 r
F P
0 g
s
.60503 .36964 m .6315 .36668 L .6412 .37793 L p .361 0 0 r
F P
0 g
s
.56677 .65856 m .56955 .65689 L .59797 .64649 L p .632 .397 .543 r
F P
0 g
s
.59788 .64217 m .59797 .64649 L .56955 .65689 L p .585 .359 .54 r
F P
0 g
s
.44079 .54977 m .4372 .56549 L .4595 .60067 L p .113 .232 .71 r
F P
0 g
s
.66886 .81231 m .6834 .80068 L .638 .78821 L p .843 .864 .859 r
F P
0 g
s
.638 .78821 m .63159 .79622 L .66886 .81231 L p .843 .864 .859 r
F P
0 g
s
.6412 .37793 m .60826 .37998 L .60503 .36964 L p .361 0 0 r
F P
0 g
s
.47596 .41299 m .50061 .39721 L .50993 .36456 L p .22 0 .216 r
F P
0 g
s
.48562 .4458 m .4647 .46169 L .48005 .43463 L p 0 0 0 r
F P
0 g
s
.48005 .43463 m .49838 .41927 L .48562 .4458 L p 0 0 0 r
F P
0 g
s
.66793 .88001 m .6805 .86882 L .73216 .85342 L p .634 .964 .861 r
F P
0 g
s
.74967 .83685 m .73216 .85342 L .6805 .86882 L p .741 .988 .894 r
F P
0 g
s
.50497 .84882 m .52557 .85059 L .56662 .83272 L p .234 .751 .761 r
F P
0 g
s
.57646 .82997 m .56662 .83272 L .52557 .85059 L p .362 .833 .808 r
F P
0 g
s
.56677 .65856 m .56471 .65987 L .52917 .65638 L p .44 0 0 r
F P
0 g
s
.56471 .65987 m .56677 .65856 L .59805 .65083 L p .675 .431 .543 r
F P
0 g
s
.59797 .64649 m .59805 .65083 L .56677 .65856 L p .632 .397 .543 r
F P
0 g
s
.43579 .57937 m .42985 .59469 L .42466 .55195 L p 0 0 .404 r
F P
0 g
s
.42466 .55195 m .43052 .53456 L .43579 .57937 L p 0 0 .404 r
F P
0 g
s
.81258 .46142 m .78696 .44311 L .76376 .40616 L p .819 .338 .021 r
F P
0 g
s
.73673 .39383 m .76376 .40616 L .78696 .44311 L p .803 .341 .136 r
F P
0 g
s
.52917 .65638 m .52665 .65356 L .49111 .63715 L p 0 .46 .852 r
F P
0 g
s
.52665 .65356 m .52917 .65638 L .56471 .65987 L p .461 0 0 r
F P
0 g
s
.4972 .70897 m .48969 .7036 L .53382 .72625 L p 0 .343 .756 r
F P
0 g
s
.765 .74316 m .76999 .72445 L .71313 .74642 L p .838 .855 .858 r
F P
0 g
s
.71313 .74642 m .71029 .76061 L .765 .74316 L p .838 .855 .858 r
F P
0 g
s
.59805 .65083 m .59814 .65517 L .56471 .65987 L p .675 .431 .543 r
F P
0 g
s
.6834 .80068 m .69529 .78801 L .64317 .77978 L p .834 .823 .838 r
F P
0 g
s
.64317 .77978 m .638 .78821 L .6834 .80068 L p .834 .823 .838 r
F P
0 g
s
.76301 .81908 m .77188 .80047 L .82134 .755 L p .833 .993 .742 r
F P
0 g
s
.82737 .73178 m .82134 .755 L .77188 .80047 L p .909 .978 .785 r
F P
0 g
s
.47596 .41299 m .45622 .43058 L .45405 .47253 L p .278 .094 .442 r
F P
0 g
s
.4394 .49031 m .45405 .47253 L .45622 .43058 L p .107 0 .387 r
F P
0 g
s
.44969 .63975 m .44853 .65145 L .42891 .6097 L p 0 .038 .59 r
F P
0 g
s
.42891 .6097 m .42985 .59469 L .44969 .63975 L p 0 .038 .59 r
F P
0 g
s
.5635 .66091 m .56471 .65987 L .59814 .65517 L p .716 .463 .542 r
F P
0 g
s
.59814 .65517 m .59822 .65953 L .5635 .66091 L p .716 .463 .542 r
F P
0 g
s
.49111 .63715 m .49027 .62962 L .4595 .60067 L p .084 .361 .83 r
F P
0 g
s
.49027 .62962 m .49111 .63715 L .52665 .65356 L p .088 .485 .896 r
F P
0 g
s
.56471 .65987 m .5635 .66091 L .52665 .65356 L p .461 0 0 r
F P
0 g
s
.56325 .66173 m .5635 .66091 L .59822 .65953 L p .755 .495 .539 r
F P
0 g
s
.59822 .65953 m .5983 .66389 L .56325 .66173 L p .755 .495 .539 r
F P
0 g
s
.48597 .84527 m .50497 .84882 L .55731 .83462 L p .127 .675 .727 r
F P
0 g
s
.56662 .83272 m .55731 .83462 L .50497 .84882 L p .234 .751 .761 r
F P
0 g
s
.48283 .69044 m .48479 .69734 L .45151 .66255 L p 0 .216 .74 r
F P
0 g
s
.45151 .66255 m .44853 .65145 L .48283 .69044 L p 0 .216 .74 r
F P
0 g
s
.36773 .79441 m .38456 .80947 L .45503 .83331 L p 0 .463 .851 r
F P
0 g
s
.46915 .84005 m .45503 .83331 L .38456 .80947 L p 0 .439 .786 r
F P
0 g
s
.85725 .64819 m .85047 .62284 L .85834 .56123 L p .981 .796 .389 r
F P
0 g
s
.84429 .53666 m .85834 .56123 L .85047 .62284 L p .994 .769 .489 r
F P
0 g
s
.84336 .59183 m .83195 .56834 L .80167 .62291 L p .94 .827 .705 r
F P
0 g
s
.80167 .62291 m .81215 .644 L .84336 .59183 L p .94 .827 .705 r
F P
0 g
s
.4595 .60067 m .46252 .58855 L .44079 .54977 L p .113 .232 .71 r
F P
0 g
s
.46252 .58855 m .4595 .60067 L .49027 .62962 L p .221 .401 .829 r
F P
0 g
s
.51135 .43182 m .48562 .4458 L .49838 .41927 L p .173 0 .115 r
F P
0 g
s
.49838 .41927 m .52093 .40562 L .51135 .43182 L p .173 0 .115 r
F P
0 g
s
.56406 .66246 m .56325 .66173 L .5983 .66389 L p .795 .528 .534 r
F P
0 g
s
.5983 .66389 m .59839 .66827 L .56406 .66246 L p .795 .528 .534 r
F P
0 g
s
.69529 .78801 m .70431 .77457 L .647 .77102 L p .82 .785 .82 r
F P
0 g
s
.647 .77102 m .64317 .77978 L .69529 .78801 L p .82 .785 .82 r
F P
0 g
s
.52665 .65356 m .52608 .65031 L .49027 .62962 L p .088 .485 .896 r
F P
0 g
s
.52608 .65031 m .52665 .65356 L .56111 .66043 L p .446 0 0 r
F P
0 g
s
.55944 .65976 m .52608 .65031 L .56111 .66043 L .446 0 0 r
F
.56111 .66043 m .5635 .66091 L p .55944 .65976 L F P
0 g
s
.5635 .66091 m .56325 .66173 L .52608 .65031 L p .446 0 0 r
F P
0 g
s
.52767 .64683 m .52608 .65031 L .56083 .66099 L p .38 0 0 r
F P
0 g
s
.56083 .66099 m .56325 .66173 L p .55939 .66011 L .38 0 0 r
F P
0 g
s
.55939 .66011 m .52767 .64683 L .56083 .66099 L .38 0 0 r
F
.56325 .66173 m .56406 .66246 L .53115 .64833 L p F P
0 g
s
.56325 .66173 m .53115 .64833 L .53363 .64933 L .38 0 0 r
F
.56598 .66318 m .56406 .66246 L .59839 .66827 L p .837 .563 .524 r
F P
0 g
s
.56406 .66246 m .56598 .66318 L .53494 .6453 L p 0 .293 .701 r
F P
0 g
s
.53494 .6453 m .53153 .64334 L p .53715 .64664 L 0 .293 .701 r
F P
0 g
s
.56406 .66246 m .53494 .6453 L .53715 .64664 L 0 .293 .701 r
F
.53115 .64833 m .52767 .64683 L p .53363 .64933 L .38 0 0 r
F P
0 g
s
.6805 .86882 m .69072 .85677 L .74967 .83685 L p .741 .988 .894 r
F P
0 g
s
.76301 .81908 m .74967 .83685 L .69072 .85677 L p .807 .976 .9 r
F P
0 g
s
.59839 .66827 m .59847 .67266 L .56598 .66318 L p .837 .563 .524 r
F P
0 g
s
.8169 .66606 m .81215 .644 L .76598 .68732 L p .891 .851 .798 r
F P
0 g
s
.76598 .68732 m .7703 .70569 L .8169 .66606 L p .891 .851 .798 r
F P
0 g
s
.44934 .53398 m .44079 .54977 L .46252 .58855 L p .263 .301 .714 r
F P
0 g
s
.23758 .46387 m .22713 .50233 L .24268 .58677 L p 0 0 .44 r
F P
0 g
s
.24267 .62021 m .24268 .58677 L .22713 .50233 L p 0 0 .281 r
F P
0 g
s
.48969 .7036 m .48479 .69734 L .53114 .72466 L p 0 .398 .839 r
F P
0 g
s
.56904 .66401 m .56598 .66318 L .59847 .67266 L p .881 .602 .509 r
F P
0 g
s
.59847 .67266 m .59856 .67706 L .56904 .66401 L p .881 .602 .509 r
F P
0 g
s
.78696 .44311 m .75658 .42808 L .73673 .39383 L p .803 .341 .136 r
F P
0 g
s
.70657 .38487 m .73673 .39383 L .75658 .42808 L p .763 .323 .207 r
F P
0 g
s
.82737 .73178 m .82725 .70843 L .85725 .64819 L p .966 .928 .607 r
F P
0 g
s
.85047 .62284 m .85725 .64819 L .82725 .70843 L p .981 .88 .656 r
F P
0 g
s
.57323 .66508 m .56904 .66401 L .59856 .67706 L p .927 .643 .483 r
F P
0 g
s
.59856 .67706 m .59864 .68147 L .57323 .66508 L p .927 .643 .483 r
F P
0 g
s
.58867 .73402 m .58958 .73035 L .54375 .7279 L p .125 0 0 r
F P
0 g
s
.58802 .7376 m .58867 .73402 L .5381 .72737 L p 0 .476 .731 r
F P
0 g
s
.54375 .7279 m .5381 .72737 L .58727 .73383 L p .125 0 0 r
F P
0 g
s
.58727 .73383 m .58786 .73391 L p .58748 .73386 L .125 0 0 r
F P
0 g
s
.54375 .7279 m .58727 .73383 L .58748 .73386 L .125 0 0 r
F
.5381 .72737 m .53382 .72625 L .58717 .73742 L p 0 .476 .731 r
F P
0 g
s
.58717 .73742 m .58802 .7376 L p .5876 .73751 L 0 .476 .731 r
F P
0 g
s
.5381 .72737 m .58717 .73742 L .5876 .73751 L 0 .476 .731 r
F
.58767 .74112 m .58802 .7376 L .54353 .72829 L p 0 .494 .807 r
F P
0 g
s
.53919 .72773 m .58767 .74112 L .54353 .72829 L 0 .494 .807 r
F
.54353 .72829 m .53382 .72625 L p .53919 .72773 L F P
0 g
s
.53382 .72625 m .53114 .72466 L .58767 .74112 L p 0 .494 .807 r
F P
0 g
s
.58763 .74459 m .58767 .74112 L .54479 .72863 L p .02 .516 .872 r
F P
0 g
s
.54479 .72863 m .53114 .72466 L p .54113 .72818 L .02 .516 .872 r
F P
0 g
s
.54113 .72818 m .58763 .74459 L .54479 .72863 L .02 .516 .872 r
F
.58786 .73391 m .58867 .73402 L p .58828 .73397 L .125 0 0 r
F P
0 g
s
.54375 .7279 m .58786 .73391 L .58828 .73397 L .125 0 0 r
F
.49027 .62962 m .49261 .62172 L .46252 .58855 L p .221 .401 .829 r
F P
0 g
s
.49261 .62172 m .49027 .62962 L .52608 .65031 L p .198 .502 .907 r
F P
0 g
s
.76999 .72445 m .7703 .70569 L .71284 .73227 L p .827 .816 .839 r
F P
0 g
s
.71284 .73227 m .71313 .74642 L .76999 .72445 L p .827 .816 .839 r
F P
0 g
s
.24268 .58677 m .24267 .62021 L .28501 .69559 L p 0 .088 .632 r
F P
0 g
s
.29275 .72127 m .28501 .69559 L .24267 .62021 L p 0 0 .519 r
F P
0 g
s
.46915 .84005 m .48597 .84527 L .54878 .83572 L p .045 .614 .714 r
F P
0 g
s
.55731 .83462 m .54878 .83572 L .48597 .84527 L p .127 .675 .727 r
F P
0 g
s
.50061 .39721 m .47596 .41299 L .47404 .45589 L p .397 .185 .471 r
F P
0 g
s
.45405 .47253 m .47404 .45589 L .47596 .41299 L p .278 .094 .442 r
F P
0 g
s
.5785 .6665 m .57323 .66508 L .59864 .68147 L p .97 .686 .437 r
F P
0 g
s
.59864 .68147 m .59873 .68589 L .5785 .6665 L p .97 .686 .437 r
F P
0 g
s
.70431 .77457 m .71029 .76061 L .64942 .76207 L p .803 .751 .804 r
F P
0 g
s
.64942 .76207 m .647 .77102 L .70431 .77457 L p .803 .751 .804 r
F P
0 g
s
.44696 .56424 m .43579 .57937 L .43052 .53456 L p .109 .044 .494 r
F P
0 g
s
.43052 .53456 m .44179 .51731 L .44696 .56424 L p .109 .044 .494 r
F P
0 g
s
.52608 .65031 m .52767 .64683 L .49261 .62172 L p .198 .502 .907 r
F P
0 g
s
.54135 .42037 m .51135 .43182 L .52093 .40562 L p .33 0 .194 r
F P
0 g
s
.52093 .40562 m .54722 .3942 L .54135 .42037 L p .33 0 .194 r
F P
0 g
s
.78696 .44311 m .81258 .46142 L .8236 .5141 L p .913 .567 .371 r
F P
0 g
s
.45527 .62786 m .44969 .63975 L .42985 .59469 L p .111 .171 .646 r
F P
0 g
s
.42985 .59469 m .43579 .57937 L .45527 .62786 L p .111 .171 .646 r
F P
0 g
s
.28501 .69559 m .29275 .72127 L .35624 .77761 L p 0 .287 .787 r
F P
0 g
s
.36773 .79441 m .35624 .77761 L .29275 .72127 L p 0 .202 .716 r
F P
0 g
s
.53153 .64334 m .52767 .64683 L .56406 .66246 L p 0 .293 .701 r
F P
0 g
s
.48407 .68317 m .48283 .69044 L .44853 .65145 L p .108 .3 .776 r
F P
0 g
s
.44853 .65145 m .44969 .63975 L .48407 .68317 L p .108 .3 .776 r
F P
0 g
s
.46252 .58855 m .46985 .57636 L .44934 .53398 L p .263 .301 .714 r
F P
0 g
s
.46985 .57636 m .46252 .58855 L .49261 .62172 L p .326 .429 .814 r
F P
0 g
s
.77188 .80047 m .77608 .78141 L .82737 .73178 L p .909 .978 .785 r
F P
0 g
s
.82725 .70843 m .82737 .73178 L .77608 .78141 L p .925 .926 .79 r
F P
0 g
s
.69072 .85677 m .69836 .84406 L .76301 .81908 L p .807 .976 .9 r
F P
0 g
s
.77188 .80047 m .76301 .81908 L .69836 .84406 L p .84 .944 .89 r
F P
0 g
s
.75658 .42808 m .72253 .41675 L .70657 .38487 L p .763 .323 .207 r
F P
0 g
s
.67435 .37954 m .70657 .38487 L .72253 .41675 L p .714 .294 .248 r
F P
0 g
s
.53024 .72273 m .53114 .72466 L .48479 .69734 L p .097 .439 .877 r
F P
0 g
s
.48479 .69734 m .48283 .69044 L .53024 .72273 L p .097 .439 .877 r
F P
0 g
s
.57486 .412 m .54135 .42037 L .54722 .3942 L p .442 .073 .24 r
F P
0 g
s
.54722 .3942 m .57661 .38551 L .57486 .412 L p .442 .073 .24 r
F P
0 g
s
.71029 .76061 m .71313 .74642 L .65042 .75306 L p .784 .719 .791 r
F P
0 g
s
.65042 .75306 m .64942 .76207 L .71029 .76061 L p .784 .719 .791 r
F P
0 g
s
.53773 .64007 m .53153 .64334 L .56598 .66318 L p 0 .369 .816 r
F P
0 g
s
.56598 .66318 m .56904 .66401 L .53773 .64007 L p 0 .369 .816 r
F P
0 g
s
.49834 .61379 m .49261 .62172 L .52767 .64683 L p .294 .513 .897 r
F P
0 g
s
.52767 .64683 m .53153 .64334 L .49834 .61379 L p .294 .513 .897 r
F P
0 g
s
.463 .51865 m .44934 .53398 L .46985 .57636 L p .37 .352 .708 r
F P
0 g
s
.49261 .62172 m .49834 .61379 L .46985 .57636 L p .326 .429 .814 r
F P
0 g
s
.35624 .77761 m .36773 .79441 L .44416 .82525 L p .07 .487 .893 r
F P
0 g
s
.45503 .83331 m .44416 .82525 L .36773 .79441 L p 0 .463 .851 r
F P
0 g
s
.47404 .45589 m .49913 .44104 L .50061 .39721 L p .397 .185 .471 r
F P
0 g
s
.83195 .56834 m .81427 .54655 L .78584 .60333 L p .904 .769 .702 r
F P
0 g
s
.78584 .60333 m .80167 .62291 L .83195 .56834 L p .904 .769 .702 r
F P
0 g
s
.45503 .83331 m .46915 .84005 L .54131 .83608 L p 0 .571 .724 r
F P
0 g
s
.54878 .83572 m .54131 .83608 L .46915 .84005 L p .045 .614 .714 r
F P
0 g
s
.85047 .62284 m .83687 .59866 L .84429 .53666 L p .994 .769 .489 r
F P
0 g
s
.8236 .5141 m .84429 .53666 L .83687 .59866 L p .956 .716 .536 r
F P
0 g
s
.81215 .644 m .80167 .62291 L .75724 .66978 L p .868 .801 .782 r
F P
0 g
s
.75724 .66978 m .76598 .68732 L .81215 .644 L p .868 .801 .782 r
F P
0 g
s
.72253 .41675 m .68604 .40943 L .67435 .37954 L p .714 .294 .248 r
F P
0 g
s
.6412 .37793 m .67435 .37954 L .68604 .40943 L p .66 .256 .269 r
F P
0 g
s
.7703 .70569 m .76598 .68732 L .70951 .71844 L p .811 .779 .823 r
F P
0 g
s
.70951 .71844 m .71284 .73227 L .7703 .70569 L p .811 .779 .823 r
F P
0 g
s
.61092 .40718 m .57486 .412 L .57661 .38551 L p .529 .149 .265 r
F P
0 g
s
.57661 .38551 m .60826 .37998 L .61092 .40718 L p .529 .149 .265 r
F P
0 g
s
.54625 .63725 m .53773 .64007 L .56904 .66401 L p .077 .426 .87 r
F P
0 g
s
.56904 .66401 m .57323 .66508 L .54625 .63725 L p .077 .426 .87 r
F P
0 g
s
.68604 .40943 m .6484 .40626 L .6412 .37793 L p .66 .256 .269 r
F P
0 g
s
.60826 .37998 m .6412 .37793 L .6484 .40626 L p .599 .209 .274 r
F P
0 g
s
.61557 .81049 m .61766 .80881 L p .59456 .76634 L 0 0 .384 r
F P
0 g
s
.61766 .80881 m .62405 .80367 L .59456 .76634 L p 0 0 .384 r
F P
0 g
s
.53114 .72466 m .53024 .72273 L .58763 .74459 L p .02 .516 .872 r
F P
0 g
s
.58793 .74806 m .58763 .74459 L .53024 .72273 L p .11 .535 .914 r
F P
0 g
s
.53024 .72273 m .53126 .72064 L .58793 .74806 L p .11 .535 .914 r
F P
0 g
s
.58858 .75154 m .58793 .74806 L .53126 .72064 L p .201 .548 .93 r
F P
0 g
s
.53126 .72064 m .53429 .71856 L .58719 .7507 L p .201 .548 .93 r
F P
0 g
s
.53126 .72064 m .58719 .7507 L .58733 .75081 L .201 .548 .93 r
F
.53126 .72064 m .58778 .75106 L .58813 .7513 L F
.58719 .7507 m .58778 .75106 L p .58733 .75081 L F P
0 g
s
.58778 .75106 m .58858 .75154 L p .58813 .7513 L .201 .548 .93 r
F P
0 g
s
.58959 .75508 m .58858 .75154 L .53429 .71856 L p .283 .556 .928 r
F P
0 g
s
.53429 .71856 m .53936 .71668 L .58763 .75358 L p .283 .556 .928 r
F P
0 g
s
.58763 .75358 m .58959 .75508 L p .5878 .7539 L .283 .556 .928 r
F P
0 g
s
.53429 .71856 m .58763 .75358 L .5878 .7539 L .283 .556 .928 r
F
.59093 .75871 m .58959 .75508 L .58763 .75358 L p .353 .561 .915 r
F P
0 g
s
.58763 .75358 m .54848 .72365 L p .58999 .75793 L .353 .561 .915 r
F P
0 g
s
.58999 .75793 m .59093 .75871 L .58763 .75358 L .353 .561 .915 r
F
.54458 .72093 m .59093 .75871 L .54848 .72365 L F
.54848 .72365 m .53936 .71668 L p .54458 .72093 L F P
0 g
s
.53936 .71668 m .54644 .7152 L .5903 .75808 L p .353 .561 .915 r
F P
0 g
s
.5903 .75808 m .59093 .75871 L p .59054 .75838 L .353 .561 .915 r
F P
0 g
s
.53936 .71668 m .5903 .75808 L .59054 .75838 L .353 .561 .915 r
F
.5926 .76245 m .59093 .75871 L .5903 .75808 L p .413 .566 .897 r
F P
0 g
s
.5903 .75808 m .55732 .72583 L p .5926 .76245 L .413 .566 .897 r
F P
0 g
s
.55472 .72367 m .5926 .76245 L .55732 .72583 L .413 .566 .897 r
F
.55732 .72583 m .54644 .7152 L p .55472 .72367 L F P
0 g
s
.54644 .7152 m .55545 .71431 L .5926 .76245 L p .413 .566 .897 r
F P
0 g
s
.59456 .76634 m .5926 .76245 L .56225 .72311 L p .462 .571 .879 r
F P
0 g
s
.56225 .72311 m .55545 .71431 L p .55944 .71962 L .462 .571 .879 r
F P
0 g
s
.55944 .71962 m .59456 .76634 L .56225 .72311 L .462 .571 .879 r
F
.55545 .71431 m .5662 .7142 L .59456 .76634 L p F P
0 g
s
.59456 .76634 m .57454 .72954 L p .58889 .75592 L .504 .577 .862 r
F P
0 g
s
.57454 .72954 m .5662 .7142 L p .57354 .72769 L .504 .577 .862 r
F P
0 g
s
.57354 .72769 m .58889 .75592 L .57454 .72954 L .504 .577 .862 r
F
.59677 .7704 m .59456 .76634 L p .58889 .75592 L F P
0 g
s
.59456 .76634 m .59677 .7704 L .61557 .81049 L p 0 0 .384 r
F P
0 g
s
.60634 .81658 m .61557 .81049 L .59677 .7704 L p 0 0 .561 r
F P
0 g
s
.6484 .40626 m .61092 .40718 L .60826 .37998 L p .599 .209 .274 r
F P
0 g
s
.62405 .80367 m .63159 .79622 L .5926 .76245 L p .782 .344 0 r
F P
0 g
s
.5926 .76245 m .59456 .76634 L .62405 .80367 L p .782 .344 0 r
F P
0 g
s
.59677 .7704 m .59918 .77467 L .60634 .81658 L p 0 0 .561 r
F P
0 g
s
.59658 .82189 m .60634 .81658 L .59918 .77467 L p .005 .131 .645 r
F P
0 g
s
.46343 .54987 m .44696 .56424 L .44179 .51731 L p .28 .164 .537 r
F P
0 g
s
.44179 .51731 m .45854 .50081 L .46343 .54987 L p .28 .164 .537 r
F P
0 g
s
.71313 .74642 m .71284 .73227 L .65003 .74411 L p .764 .691 .782 r
F P
0 g
s
.65003 .74411 m .65042 .75306 L .71313 .74642 L p .764 .691 .782 r
F P
0 g
s
.63159 .79622 m .638 .78821 L .59093 .75871 L p .863 .413 .052 r
F P
0 g
s
.59093 .75871 m .5926 .76245 L .63159 .79622 L p .863 .413 .052 r
F P
0 g
s
.8236 .5141 m .79696 .49422 L .78696 .44311 L p .913 .567 .371 r
F P
0 g
s
.75658 .42808 m .78696 .44311 L .79696 .49422 L p .865 .53 .417 r
F P
0 g
s
.59918 .77467 m .60173 .77914 L .59658 .82189 L p .005 .131 .645 r
F P
0 g
s
.58653 .82636 m .59658 .82189 L .60173 .77914 L p .193 .233 .675 r
F P
0 g
s
.50754 .60617 m .49834 .61379 L .53153 .64334 L p .372 .521 .877 r
F P
0 g
s
.53153 .64334 m .53773 .64007 L .50754 .60617 L p .372 .521 .877 r
F P
0 g
s
.82725 .70843 m .82099 .68552 L .85047 .62284 L p .981 .88 .656 r
F P
0 g
s
.83687 .59866 m .85047 .62284 L .82099 .68552 L p .954 .817 .67 r
F P
0 g
s
.638 .78821 m .64317 .77978 L .58959 .75508 L p .862 .43 .186 r
F P
0 g
s
.58959 .75508 m .59093 .75871 L .638 .78821 L p .862 .43 .186 r
F P
0 g
s
.53126 .72064 m .53024 .72273 L .48283 .69044 L p .217 .468 .882 r
F P
0 g
s
.48283 .69044 m .48407 .68317 L .53126 .72064 L p .217 .468 .882 r
F P
0 g
s
.64533 .72689 m .64126 .71884 L .58958 .73035 L p .553 .237 .386 r
F P
0 g
s
.58958 .73035 m .58867 .73402 L .64533 .72689 L p .553 .237 .386 r
F P
0 g
s
.66793 .88001 m .65327 .89015 L .61143 .87261 L p .756 .927 .945 r
F P
0 g
s
.46985 .57636 m .48163 .56457 L .463 .51865 L p .37 .352 .708 r
F P
0 g
s
.48163 .56457 m .46985 .57636 L .49834 .61379 L p .407 .453 .796 r
F P
0 g
s
.69836 .84406 m .70327 .83091 L .77188 .80047 L p .84 .944 .89 r
F P
0 g
s
.77608 .78141 m .77188 .80047 L .70327 .83091 L p .85 .903 .872 r
F P
0 g
s
.55698 .63515 m .54625 .63725 L .57323 .66508 L p .214 .463 .88 r
F P
0 g
s
.57323 .66508 m .5785 .6665 L .55698 .63515 L p .214 .463 .88 r
F P
0 g
s
.48872 .67581 m .48407 .68317 L .44969 .63975 L p .253 .359 .778 r
F P
0 g
s
.44969 .63975 m .45527 .62786 L .48872 .67581 L p .253 .359 .778 r
F P
0 g
s
.60173 .77914 m .60435 .78385 L .58653 .82636 L p .193 .233 .675 r
F P
0 g
s
.57646 .82997 m .58653 .82636 L .60435 .78385 L p .323 .304 .683 r
F P
0 g
s
.46544 .61621 m .45527 .62786 L .43579 .57937 L p .272 .261 .664 r
F P
0 g
s
.43579 .57937 m .44696 .56424 L .46544 .61621 L p .272 .261 .664 r
F P
0 g
s
.64317 .77978 m .647 .77102 L .58858 .75154 L p .831 .422 .269 r
F P
0 g
s
.58858 .75154 m .58959 .75508 L .64317 .77978 L p .831 .422 .269 r
F P
0 g
s
.6483 .73535 m .64533 .72689 L .58867 .73402 L p .609 .281 .389 r
F P
0 g
s
.58867 .73402 m .58802 .7376 L .6483 .73535 L p .609 .281 .389 r
F P
0 g
s
.49834 .61379 m .50754 .60617 L .48163 .56457 L p .407 .453 .796 r
F P
0 g
s
.60435 .78385 m .60699 .78879 L .57646 .82997 L p .323 .304 .683 r
F P
0 g
s
.56662 .83272 m .57646 .82997 L .60699 .78879 L p .416 .356 .682 r
F P
0 g
s
.647 .77102 m .64942 .76207 L .58793 .74806 L p .79 .403 .321 r
F P
0 g
s
.58793 .74806 m .58858 .75154 L .647 .77102 L p .79 .403 .321 r
F P
0 g
s
.61143 .87261 m .61396 .86673 L .66793 .88001 L p .756 .927 .945 r
F P
0 g
s
.6805 .86882 m .66793 .88001 L .61396 .86673 L p .779 .905 .929 r
F P
0 g
s
.77608 .78141 m .77553 .76232 L .82725 .70843 L p .925 .926 .79 r
F P
0 g
s
.82099 .68552 m .82725 .70843 L .77553 .76232 L p .913 .868 .781 r
F P
0 g
s
.44416 .82525 m .45503 .83331 L .53515 .83578 L p 0 .548 .755 r
F P
0 g
s
.54131 .83608 m .53515 .83578 L .45503 .83331 L p 0 .571 .724 r
F P
0 g
s
.48174 .50435 m .463 .51865 L .48163 .56457 L p .45 .391 .7 r
F P
0 g
s
.71284 .73227 m .70951 .71844 L .6483 .73535 L p .742 .665 .774 r
F P
0 g
s
.6483 .73535 m .65003 .74411 L .71284 .73227 L p .742 .665 .774 r
F P
0 g
s
.65003 .74411 m .6483 .73535 L .58802 .7376 L p .658 .318 .386 r
F P
0 g
s
.58802 .7376 m .58767 .74112 L .65003 .74411 L p .658 .318 .386 r
F P
0 g
s
.64942 .76207 m .65042 .75306 L .58763 .74459 L p .748 .379 .354 r
F P
0 g
s
.58763 .74459 m .58793 .74806 L .64942 .76207 L p .748 .379 .354 r
F P
0 g
s
.76598 .68732 m .75724 .66978 L .70332 .70523 L p .793 .746 .81 r
F P
0 g
s
.70332 .70523 m .70951 .71844 L .76598 .68732 L p .793 .746 .81 r
F P
0 g
s
.5202 .59923 m .50754 .60617 L .53773 .64007 L p .435 .529 .855 r
F P
0 g
s
.53773 .64007 m .54625 .63725 L .5202 .59923 L p .435 .529 .855 r
F P
0 g
s
.60699 .78879 m .60955 .79397 L .56662 .83272 L p .416 .356 .682 r
F P
0 g
s
.55731 .83462 m .56662 .83272 L .60955 .79397 L p .486 .396 .68 r
F P
0 g
s
.65042 .75306 m .65003 .74411 L .58767 .74112 L p .704 .35 .374 r
F P
0 g
s
.58767 .74112 m .58763 .74459 L .65042 .75306 L p .704 .35 .374 r
F P
0 g
s
.25918 .42563 m .23758 .46387 L .25282 .55256 L p .106 .062 .519 r
F P
0 g
s
.24268 .58677 m .25282 .55256 L .23758 .46387 L p 0 0 .44 r
F P
0 g
s
.80167 .62291 m .78584 .60333 L .74443 .65346 L p .842 .757 .769 r
F P
0 g
s
.74443 .65346 m .75724 .66978 L .80167 .62291 L p .842 .757 .769 r
F P
0 g
s
.61396 .86673 m .61609 .86068 L .6805 .86882 L p .779 .905 .929 r
F P
0 g
s
.69072 .85677 m .6805 .86882 L .61609 .86068 L p .791 .878 .91 r
F P
0 g
s
.79696 .49422 m .76529 .47763 L .75658 .42808 L p .865 .53 .417 r
F P
0 g
s
.72253 .41675 m .75658 .42808 L .76529 .47763 L p .815 .493 .444 r
F P
0 g
s
.83687 .59866 m .81688 .57634 L .8236 .5141 L p .956 .716 .536 r
F P
0 g
s
.79696 .49422 m .8236 .5141 L .81688 .57634 L p .908 .664 .559 r
F P
0 g
s
.53429 .71856 m .53126 .72064 L .48407 .68317 L p .314 .488 .871 r
F P
0 g
s
.48407 .68317 m .48872 .67581 L .53429 .71856 L p .314 .488 .871 r
F P
0 g
s
.60955 .79397 m .61197 .79938 L .55731 .83462 L p .486 .396 .68 r
F P
0 g
s
.54878 .83572 m .55731 .83462 L .61197 .79938 L p .541 .43 .677 r
F P
0 g
s
.53946 .46205 m .50783 .47255 L .51135 .43182 L p .485 .226 .446 r
F P
0 g
s
.51135 .43182 m .54135 .42037 L .53946 .46205 L p .485 .226 .446 r
F P
0 g
s
.28501 .69559 m .28554 .66863 L .24268 .58677 L p 0 .088 .632 r
F P
0 g
s
.28554 .66863 m .28501 .69559 L .35078 .75948 L p .142 .35 .809 r
F P
0 g
s
.35624 .77761 m .35078 .75948 L .28501 .69559 L p 0 .287 .787 r
F P
0 g
s
.25282 .55256 m .24268 .58677 L .28554 .66863 L p .12 .203 .676 r
F P
0 g
s
.48163 .56457 m .49782 .55366 L .48174 .50435 L p .45 .391 .7 r
F P
0 g
s
.48507 .53685 m .46343 .54987 L .45854 .50081 L p .397 .248 .559 r
F P
0 g
s
.50534 .49168 m .48174 .50435 L .49782 .55366 L p .512 .423 .692 r
F P
0 g
s
.45854 .50081 m .48067 .48567 L .48507 .53685 L p .397 .248 .559 r
F P
0 g
s
.64533 .72689 m .6483 .73535 L .70951 .71844 L p .719 .641 .769 r
F P
0 g
s
.70951 .71844 m .70332 .70523 L .64533 .72689 L p .719 .641 .769 r
F P
0 g
s
.49782 .55366 m .48163 .56457 L .50754 .60617 L p .47 .473 .778 r
F P
0 g
s
.35078 .75948 m .35624 .77761 L .437 .81614 L p .169 .505 .911 r
F P
0 g
s
.44416 .82525 m .437 .81614 L .35624 .77761 L p .07 .487 .893 r
F P
0 g
s
.70327 .83091 m .70538 .81756 L .77608 .78141 L p .85 .903 .872 r
F P
0 g
s
.77553 .76232 m .77608 .78141 L .70538 .81756 L p .846 .86 .853 r
F P
0 g
s
.50754 .60617 m .5202 .59923 L .49782 .55366 L p .47 .473 .778 r
F P
0 g
s
.64126 .71884 m .64533 .72689 L .70332 .70523 L p .696 .619 .766 r
F P
0 g
s
.61609 .86068 m .61778 .8545 L .69072 .85677 L p .791 .878 .91 r
F P
0 g
s
.69836 .84406 m .69072 .85677 L .61778 .8545 L p .794 .849 .892 r
F P
0 g
s
.53616 .59336 m .5202 .59923 L .54625 .63725 L p .487 .538 .835 r
F P
0 g
s
.54625 .63725 m .55698 .63515 L .53616 .59336 L p .487 .538 .835 r
F P
0 g
s
.49686 .66872 m .48872 .67581 L .45527 .62786 L p .358 .401 .769 r
F P
0 g
s
.45527 .62786 m .46544 .61621 L .49686 .66872 L p .358 .401 .769 r
F P
0 g
s
.70332 .70523 m .69453 .69286 L .64126 .71884 L p .696 .619 .766 r
F P
0 g
s
.48022 .60529 m .46544 .61621 L .44696 .56424 L p .383 .324 .667 r
F P
0 g
s
.44696 .56424 m .46343 .54987 L .48022 .60529 L p .383 .324 .667 r
F P
0 g
s
.61197 .79938 m .61419 .805 L .54878 .83572 L p .541 .43 .677 r
F P
0 g
s
.54131 .83608 m .54878 .83572 L .61419 .805 L p .587 .46 .674 r
F P
0 g
s
.75724 .66978 m .74443 .65346 L .69453 .69286 L p .774 .717 .799 r
F P
0 g
s
.69453 .69286 m .70332 .70523 L .75724 .66978 L p .774 .717 .799 r
F P
0 g
s
.82099 .68552 m .80878 .66363 L .83687 .59866 L p .954 .817 .67 r
F P
0 g
s
.81688 .57634 m .83687 .59866 L .80878 .66363 L p .915 .758 .672 r
F P
0 g
s
.437 .81614 m .44416 .82525 L .53053 .83493 L p 0 .54 .801 r
F P
0 g
s
.53515 .83578 m .53053 .83493 L .44416 .82525 L p 0 .548 .755 r
F P
0 g
s
.76529 .47763 m .72971 .46478 L .72253 .41675 L p .815 .493 .444 r
F P
0 g
s
.68604 .40943 m .72253 .41675 L .72971 .46478 L p .767 .456 .46 r
F P
0 g
s
.57474 .45474 m .53946 .46205 L .54135 .42037 L p .557 .286 .461 r
F P
0 g
s
.54135 .42037 m .57486 .412 L .57474 .45474 L p .557 .286 .461 r
F P
0 g
s
.61778 .8545 m .61899 .84822 L .69836 .84406 L p .794 .849 .892 r
F P
0 g
s
.70327 .83091 m .69836 .84406 L .61899 .84822 L p .791 .819 .875 r
F P
0 g
s
.77553 .76232 m .77029 .74362 L .82099 .68552 L p .913 .868 .781 r
F P
0 g
s
.80878 .66363 m .82099 .68552 L .77029 .74362 L p .889 .813 .767 r
F P
0 g
s
.53936 .71668 m .53429 .71856 L .48872 .67581 L p .391 .503 .853 r
F P
0 g
s
.48872 .67581 m .49686 .66872 L .53936 .71668 L p .391 .503 .853 r
F P
0 g
s
.51824 .54412 m .49782 .55366 L .5202 .59923 L p .522 .491 .764 r
F P
0 g
s
.5202 .59923 m .53616 .59336 L .51824 .54412 L p .522 .491 .764 r
F P
0 g
s
.61419 .805 m .61612 .81083 L .54131 .83608 L p .587 .46 .674 r
F P
0 g
s
.53515 .83578 m .54131 .83608 L .61612 .81083 L p .627 .488 .673 r
F P
0 g
s
.49782 .55366 m .51824 .54412 L .50534 .49168 L p .512 .423 .692 r
F P
0 g
s
.51153 .52577 m .48507 .53685 L .48067 .48567 L p .482 .31 .57 r
F P
0 g
s
.48067 .48567 m .50783 .47255 L .51153 .52577 L p .482 .31 .57 r
F P
0 g
s
.70538 .81756 m .70466 .80425 L .77553 .76232 L p .846 .86 .853 r
F P
0 g
s
.77029 .74362 m .77553 .76232 L .70466 .80425 L p .834 .819 .834 r
F P
0 g
s
.61266 .45109 m .57474 .45474 L .57486 .412 L p .617 .336 .468 r
F P
0 g
s
.57486 .412 m .61092 .40718 L .61266 .45109 L p .617 .336 .468 r
F P
0 g
s
.81688 .57634 m .79116 .55649 L .79696 .49422 L p .908 .664 .559 r
F P
0 g
s
.76529 .47763 m .79696 .49422 L .79116 .55649 L p .861 .618 .57 r
F P
0 g
s
.72971 .46478 m .6915 .45601 L .68604 .40943 L p .767 .456 .46 r
F P
0 g
s
.6484 .40626 m .68604 .40943 L .6915 .45601 L p .719 .418 .468 r
F P
0 g
s
.61899 .84822 m .61971 .84188 L .70327 .83091 L p .791 .819 .875 r
F P
0 g
s
.70538 .81756 m .70327 .83091 L .61971 .84188 L p .783 .791 .859 r
F P
0 g
s
.50851 .66224 m .49686 .66872 L .46544 .61621 L p .437 .433 .757 r
F P
0 g
s
.46544 .61621 m .48022 .60529 L .50851 .66224 L p .437 .433 .757 r
F P
0 g
s
.65202 .45145 m .61266 .45109 L .61092 .40718 L p .67 .379 .471 r
F P
0 g
s
.61092 .40718 m .6484 .40626 L .65202 .45145 L p .67 .379 .471 r
F P
0 g
s
.6915 .45601 m .65202 .45145 L .6484 .40626 L p .719 .418 .468 r
F P
0 g
s
.61612 .81083 m .61771 .81683 L .53515 .83578 L p .627 .488 .673 r
F P
0 g
s
.53053 .83493 m .53515 .83578 L .61771 .81683 L p .663 .514 .672 r
F P
0 g
s
.49949 .59558 m .48022 .60529 L .46343 .54987 L p .464 .372 .666 r
F P
0 g
s
.46343 .54987 m .48507 .53685 L .49949 .59558 L p .464 .372 .666 r
F P
0 g
s
.54644 .7152 m .53936 .71668 L .49686 .66872 L p .452 .517 .835 r
F P
0 g
s
.59918 .77467 m .59677 .7704 L .57848 .71505 L p .541 .584 .847 r
F P
0 g
s
.5662 .7142 m .57848 .71505 L .59677 .7704 L p .504 .577 .862 r
F P
0 g
s
.437 .81614 m .43398 .80628 L .35078 .75948 L p .169 .505 .911 r
F P
0 g
s
.43398 .80628 m .437 .81614 L .52764 .83367 L p .015 .544 .853 r
F P
0 g
s
.53053 .83493 m .52764 .83367 L .437 .81614 L p 0 .54 .801 r
F P
0 g
s
.60173 .77914 m .59918 .77467 L .59197 .71701 L p .572 .593 .836 r
F P
0 g
s
.57848 .71505 m .59197 .71701 L .59918 .77467 L p .541 .584 .847 r
F P
0 g
s
.61971 .84188 m .61993 .83554 L .70538 .81756 L p .783 .791 .859 r
F P
0 g
s
.70466 .80425 m .70538 .81756 L .61993 .83554 L p .772 .764 .846 r
F P
0 g
s
.49686 .66872 m .50851 .66224 L .54644 .7152 L p .452 .517 .835 r
F P
0 g
s
.80878 .66363 m .79103 .64333 L .81688 .57634 L p .915 .758 .672 r
F P
0 g
s
.79116 .55649 m .81688 .57634 L .79103 .64333 L p .875 .707 .669 r
F P
0 g
s
.35078 .75948 m .35194 .74053 L .28554 .66863 L p .142 .35 .809 r
F P
0 g
s
.35194 .74053 m .35078 .75948 L .43398 .80628 L p .26 .519 .908 r
F P
0 g
s
.60435 .78385 m .60173 .77914 L .60633 .7202 L p .6 .603 .826 r
F P
0 g
s
.59197 .71701 m .60633 .7202 L .60173 .77914 L p .572 .593 .836 r
F P
0 g
s
.54226 .5172 m .51153 .52577 L .50783 .47255 L p .548 .359 .576 r
F P
0 g
s
.50783 .47255 m .53946 .46205 L .54226 .5172 L p .548 .359 .576 r
F P
0 g
s
.77029 .74362 m .76056 .72572 L .80878 .66363 L p .889 .813 .767 r
F P
0 g
s
.79103 .64333 m .80878 .66363 L .76056 .72572 L p .861 .764 .754 r
F P
0 g
s
.61771 .81683 m .6189 .82297 L .53053 .83493 L p .663 .514 .672 r
F P
0 g
s
.52764 .83367 m .53053 .83493 L .6189 .82297 L p .696 .541 .673 r
F P
0 g
s
.70466 .80425 m .7012 .79122 L .77029 .74362 L p .834 .819 .834 r
F P
0 g
s
.76056 .72572 m .77029 .74362 L .7012 .79122 L p .818 .781 .818 r
F P
0 g
s
.60699 .78879 m .60435 .78385 L .62115 .7247 L p .626 .615 .82 r
F P
0 g
s
.60633 .7202 m .62115 .7247 L .60435 .78385 L p .6 .603 .826 r
F P
0 g
s
.29216 .3889 m .25918 .42563 L .27366 .5186 L p .275 .176 .556 r
F P
0 g
s
.25282 .55256 m .27366 .5186 L .25918 .42563 L p .106 .062 .519 r
F P
0 g
s
.79116 .55649 m .76059 .53969 L .76529 .47763 L p .861 .618 .57 r
F P
0 g
s
.72971 .46478 m .76529 .47763 L .76059 .53969 L p .817 .577 .576 r
F P
0 g
s
.55545 .71431 m .54644 .7152 L .50851 .66224 L p .502 .53 .818 r
F P
0 g
s
.28554 .66863 m .29501 .64115 L .25282 .55256 L p .12 .203 .676 r
F P
0 g
s
.29501 .64115 m .28554 .66863 L .35194 .74053 L p .27 .395 .805 r
F P
0 g
s
.60955 .79397 m .60699 .78879 L .636 .73056 L p .649 .628 .815 r
F P
0 g
s
.62115 .7247 m .636 .73056 L .60699 .78879 L p .626 .615 .82 r
F P
0 g
s
.61993 .83554 m .61965 .82922 L .70466 .80425 L p .772 .764 .846 r
F P
0 g
s
.7012 .79122 m .70466 .80425 L .61965 .82922 L p .759 .739 .835 r
F P
0 g
s
.52351 .65672 m .50851 .66224 L .48022 .60529 L p .498 .46 .746 r
F P
0 g
s
.48022 .60529 m .49949 .59558 L .52351 .65672 L p .498 .46 .746 r
F P
0 g
s
.61197 .79938 m .60955 .79397 L .65042 .73777 L p .671 .642 .813 r
F P
0 g
s
.636 .73056 m .65042 .73777 L .60955 .79397 L p .649 .628 .815 r
F P
0 g
s
.27366 .5186 m .25282 .55256 L .29501 .64115 L p .273 .283 .688 r
F P
0 g
s
.61419 .805 m .61197 .79938 L .66397 .7463 L p .691 .658 .813 r
F P
0 g
s
.65042 .73777 m .66397 .7463 L .61197 .79938 L p .671 .642 .813 r
F P
0 g
s
.52293 .58758 m .49949 .59558 L .48507 .53685 L p .527 .41 .664 r
F P
0 g
s
.48507 .53685 m .51153 .52577 L .52293 .58758 L p .527 .41 .664 r
F P
0 g
s
.61612 .81083 m .61419 .805 L .6762 .75606 L p .71 .676 .815 r
F P
0 g
s
.66397 .7463 m .6762 .75606 L .61419 .805 L p .691 .658 .813 r
F P
0 g
s
.50851 .66224 m .52351 .65672 L .55545 .71431 L p .502 .53 .818 r
F P
0 g
s
.52764 .83367 m .52665 .83212 L .43398 .80628 L p .015 .544 .853 r
F P
0 g
s
.6189 .82297 m .61965 .82922 L .52764 .83367 L p .696 .541 .673 r
F P
0 g
s
.52665 .83212 m .52764 .83367 L .61965 .82922 L p .727 .568 .674 r
F P
0 g
s
.61771 .81683 m .61612 .81083 L .6867 .76691 L p .727 .695 .82 r
F P
0 g
s
.6762 .75606 m .6867 .76691 L .61612 .81083 L p .71 .676 .815 r
F P
0 g
s
.5662 .7142 m .55545 .71431 L .52351 .65672 L p .543 .543 .805 r
F P
0 g
s
.57647 .51165 m .54226 .5172 L .53946 .46205 L p .603 .4 .579 r
F P
0 g
s
.53946 .46205 m .57474 .45474 L .57647 .51165 L p .603 .4 .579 r
F P
0 g
s
.6189 .82297 m .61771 .81683 L .69514 .7787 L p .744 .716 .826 r
F P
0 g
s
.6867 .76691 m .69514 .7787 L .61771 .81683 L p .727 .695 .82 r
F P
0 g
s
.61965 .82922 m .6189 .82297 L .7012 .79122 L p .759 .739 .835 r
F P
0 g
s
.69514 .7787 m .7012 .79122 L .6189 .82297 L p .744 .716 .826 r
F P
0 g
s
.7012 .79122 m .69514 .7787 L .76056 .72572 L p .818 .781 .818 r
F P
0 g
s
.61965 .82922 m .61993 .83554 L .52665 .83212 L p .727 .568 .674 r
F P
0 g
s
.52768 .83047 m .52665 .83212 L .61993 .83554 L p .758 .597 .677 r
F P
0 g
s
.61993 .83554 m .61971 .84188 L .52768 .83047 L p .758 .597 .677 r
F P
0 g
s
.76059 .53969 m .72625 .52637 L .72971 .46478 L p .817 .577 .576 r
F P
0 g
s
.6915 .45601 m .72971 .46478 L .72625 .52637 L p .775 .54 .58 r
F P
0 g
s
.5308 .82887 m .52768 .83047 L .61971 .84188 L p .789 .628 .681 r
F P
0 g
s
.61971 .84188 m .61899 .84822 L .5308 .82887 L p .789 .628 .681 r
F P
0 g
s
.79103 .64333 m .76832 .62514 L .79116 .55649 L p .875 .707 .669 r
F P
0 g
s
.76059 .53969 m .79116 .55649 L .76832 .62514 L p .837 .663 .666 r
F P
0 g
s
.43398 .80628 m .43544 .79601 L .35194 .74053 L p .26 .519 .908 r
F P
0 g
s
.43544 .79601 m .43398 .80628 L .52665 .83212 L p .074 .553 .898 r
F P
0 g
s
.53601 .82751 m .5308 .82887 L .61899 .84822 L p .82 .662 .687 r
F P
0 g
s
.61899 .84822 m .61778 .8545 L .53601 .82751 L p .82 .662 .687 r
F P
0 g
s
.74667 .70904 m .76056 .72572 L .69514 .7787 L p .8 .748 .805 r
F P
0 g
s
.76056 .72572 m .74667 .70904 L .79103 .64333 L p .861 .764 .754 r
F P
0 g
s
.54326 .82658 m .53601 .82751 L .61778 .8545 L p .853 .701 .693 r
F P
0 g
s
.61778 .8545 m .61609 .86068 L .54326 .82658 L p .853 .701 .693 r
F P
0 g
s
.55244 .82625 m .54326 .82658 L .61609 .86068 L p .886 .746 .701 r
F P
0 g
s
.61609 .86068 m .61396 .86673 L .55244 .82625 L p .886 .746 .701 r
F P
0 g
s
.76832 .62514 m .79103 .64333 L .74667 .70904 L p .833 .723 .743 r
F P
0 g
s
.56335 .82669 m .55244 .82625 L .61396 .86673 L p .92 .798 .71 r
F P
0 g
s
.61396 .86673 m .61143 .87261 L .56335 .82669 L p .92 .798 .71 r
F P
0 g
s
.57848 .71505 m .5662 .7142 L .54161 .65252 L p .579 .557 .794 r
F P
0 g
s
.52351 .65672 m .54161 .65252 L .5662 .7142 L p .543 .543 .805 r
F P
0 g
s
.61318 .50956 m .57647 .51165 L .57474 .45474 L p .65 .437 .581 r
F P
0 g
s
.57474 .45474 m .61266 .45109 L .61318 .50956 L p .65 .437 .581 r
F P
0 g
s
.69514 .7787 m .6867 .76691 L .74667 .70904 L p .8 .748 .805 r
F P
0 g
s
.52665 .83212 m .52768 .83047 L .43544 .79601 L p .074 .553 .898 r
F P
0 g
s
.54161 .65252 m .52351 .65672 L .49949 .59558 L p .548 .484 .737 r
F P
0 g
s
.49949 .59558 m .52293 .58758 L .54161 .65252 L p .548 .484 .737 r
F P
0 g
s
.72625 .52637 m .68937 .51683 L .6915 .45601 L p .775 .54 .58 r
F P
0 g
s
.65202 .45145 m .6915 .45601 L .68937 .51683 L p .734 .505 .581 r
F P
0 g
s
.55002 .58175 m .52293 .58758 L .51153 .52577 L p .578 .444 .661 r
F P
0 g
s
.51153 .52577 m .54226 .5172 L .55002 .58175 L p .578 .444 .661 r
F P
0 g
s
.65124 .51123 m .61318 .50956 L .61266 .45109 L p .693 .471 .582 r
F P
0 g
s
.61266 .45109 m .65202 .45145 L .65124 .51123 L p .693 .471 .582 r
F P
0 g
s
.68937 .51683 m .65124 .51123 L .65202 .45145 L p .734 .505 .581 r
F P
0 g
s
.59197 .71701 m .57848 .71505 L .56241 .64995 L p .611 .572 .786 r
F P
0 g
s
.54161 .65252 m .56241 .64995 L .57848 .71505 L p .579 .557 .794 r
F P
0 g
s
.35194 .74053 m .36018 .72135 L .29501 .64115 L p .27 .395 .805 r
F P
0 g
s
.36018 .72135 m .35194 .74053 L .43544 .79601 L p .338 .528 .895 r
F P
0 g
s
.6867 .76691 m .6762 .75606 L .72909 .69395 L p .78 .717 .794 r
F P
0 g
s
.72909 .69395 m .74667 .70904 L .6867 .76691 L p .78 .717 .794 r
F P
0 g
s
.74667 .70904 m .72909 .69395 L .76832 .62514 L p .833 .723 .743 r
F P
0 g
s
.76832 .62514 m .74144 .60951 L .76059 .53969 L p .837 .663 .666 r
F P
0 g
s
.72625 .52637 m .76059 .53969 L .74144 .60951 L p .801 .625 .663 r
F P
0 g
s
.60633 .7202 m .59197 .71701 L .58541 .64932 L p .64 .588 .78 r
F P
0 g
s
.56241 .64995 m .58541 .64932 L .59197 .71701 L p .611 .572 .786 r
F P
0 g
s
.4416 .78572 m .43544 .79601 L .52768 .83047 L p .147 .563 .928 r
F P
0 g
s
.52768 .83047 m .5308 .82887 L .4416 .78572 L p .147 .563 .928 r
F P
0 g
s
.6762 .75606 m .66397 .7463 L .70843 .68076 L p .759 .69 .786 r
F P
0 g
s
.70843 .68076 m .72909 .69395 L .6762 .75606 L p .759 .69 .786 r
F P
0 g
s
.74144 .60951 m .76832 .62514 L .72909 .69395 L p .804 .686 .734 r
F P
0 g
s
.56241 .64995 m .54161 .65252 L .52293 .58758 L p .59 .507 .73 r
F P
0 g
s
.62115 .7247 m .60633 .7202 L .60996 .65086 L p .666 .605 .777 r
F P
0 g
s
.58541 .64932 m .60996 .65086 L .60633 .7202 L p .64 .588 .78 r
F P
0 g
s
.5801 .57852 m .55002 .58175 L .54226 .5172 L p .622 .474 .66 r
F P
0 g
s
.54226 .5172 m .57647 .51165 L .5801 .57852 L p .622 .474 .66 r
F P
0 g
s
.52293 .58758 m .55002 .58175 L .56241 .64995 L p .59 .507 .73 r
F P
0 g
s
.66397 .7463 m .65042 .73777 L .6854 .66972 L p .737 .666 .78 r
F P
0 g
s
.6854 .66972 m .70843 .68076 L .66397 .7463 L p .737 .666 .78 r
F P
0 g
s
.43544 .79601 m .4416 .78572 L .36018 .72135 L p .338 .528 .895 r
F P
0 g
s
.636 .73056 m .62115 .7247 L .63534 .65473 L p .691 .623 .776 r
F P
0 g
s
.60996 .65086 m .63534 .65473 L .62115 .7247 L p .666 .605 .777 r
F P
0 g
s
.65042 .73777 m .636 .73056 L .66076 .66101 L p .715 .644 .777 r
F P
0 g
s
.66076 .66101 m .6854 .66972 L .65042 .73777 L p .715 .644 .777 r
F P
0 g
s
.29501 .64115 m .31388 .61403 L .27366 .5186 L p .273 .283 .688 r
F P
0 g
s
.31388 .61403 m .29501 .64115 L .36018 .72135 L p .367 .428 .793 r
F P
0 g
s
.63534 .65473 m .66076 .66101 L .636 .73056 L p .691 .623 .776 r
F P
0 g
s
.33637 .35505 m .29216 .3889 L .30546 .48606 L p .393 .256 .573 r
F P
0 g
s
.27366 .5186 m .30546 .48606 L .29216 .3889 L p .275 .176 .556 r
F P
0 g
s
.72909 .69395 m .70843 .68076 L .74144 .60951 L p .804 .686 .734 r
F P
0 g
s
.74144 .60951 m .71132 .59682 L .72625 .52637 L p .801 .625 .663 r
F P
0 g
s
.68937 .51683 m .72625 .52637 L .71132 .59682 L p .767 .591 .661 r
F P
0 g
s
.45256 .77583 m .4416 .78572 L .5308 .82887 L p .223 .57 .94 r
F P
0 g
s
.5308 .82887 m .53601 .82751 L .45256 .77583 L p .223 .57 .94 r
F P
0 g
s
.58541 .64932 m .56241 .64995 L .55002 .58175 L p .626 .529 .725 r
F P
0 g
s
.61229 .57823 m .5801 .57852 L .57647 .51165 L p .661 .503 .659 r
F P
0 g
s
.57647 .51165 m .61318 .50956 L .61229 .57823 L p .661 .503 .659 r
F P
0 g
s
.30546 .48606 m .27366 .5186 L .31388 .61403 L p .382 .341 .688 r
F P
0 g
s
.71132 .59682 m .74144 .60951 L .70843 .68076 L p .776 .654 .728 r
F P
0 g
s
.55002 .58175 m .5801 .57852 L .58541 .64932 L p .626 .529 .725 r
F P
0 g
s
.71132 .59682 m .67901 .58731 L .68937 .51683 L p .767 .591 .661 r
F P
0 g
s
.65124 .51123 m .68937 .51683 L .67901 .58731 L p .732 .56 .659 r
F P
0 g
s
.70843 .68076 m .6854 .66972 L .71132 .59682 L p .776 .654 .728 r
F P
0 g
s
.64562 .58111 m .61229 .57823 L .61318 .50956 L p .698 .531 .658 r
F P
0 g
s
.61318 .50956 m .65124 .51123 L .64562 .58111 L p .698 .531 .658 r
F P
0 g
s
.67901 .58731 m .64562 .58111 L .65124 .51123 L p .732 .56 .659 r
F P
0 g
s
.60996 .65086 m .58541 .64932 L .5801 .57852 L p .659 .552 .722 r
F P
0 g
s
.46829 .76678 m .45256 .77583 L .53601 .82751 L p .296 .574 .936 r
F P
0 g
s
.53601 .82751 m .54326 .82658 L .46829 .76678 L p .296 .574 .936 r
F P
0 g
s
.6854 .66972 m .66076 .66101 L .67901 .58731 L p .748 .625 .724 r
F P
0 g
s
.67901 .58731 m .71132 .59682 L .6854 .66972 L p .748 .625 .724 r
F P
0 g
s
.36018 .72135 m .37576 .70259 L .31388 .61403 L p .367 .428 .793 r
F P
0 g
s
.37576 .70259 m .36018 .72135 L .4416 .78572 L p .404 .537 .877 r
F P
0 g
s
.5801 .57852 m .61229 .57823 L .60996 .65086 L p .659 .552 .722 r
F P
0 g
s
.4416 .78572 m .45256 .77583 L .37576 .70259 L p .404 .537 .877 r
F P
0 g
s
.63534 .65473 m .60996 .65086 L .61229 .57823 L p .69 .575 .72 r
F P
0 g
s
.66076 .66101 m .63534 .65473 L .64562 .58111 L p .719 .599 .721 r
F P
0 g
s
.64562 .58111 m .67901 .58731 L .66076 .66101 L p .719 .599 .721 r
F P
0 g
s
.61229 .57823 m .64562 .58111 L .63534 .65473 L p .69 .575 .72 r
F P
0 g
s
.48857 .75903 m .46829 .76678 L .54326 .82658 L p .361 .576 .923 r
F P
0 g
s
.54326 .82658 m .55244 .82625 L .48857 .75903 L p .361 .576 .923 r
F P
0 g
s
.51302 .75301 m .48857 .75903 L .55244 .82625 L p .417 .579 .906 r
F P
0 g
s
.55244 .82625 m .56335 .82669 L .51302 .75301 L p .417 .579 .906 r
F P
0 g
s
.39106 .32553 m .33637 .35505 L .34802 .45621 L p .479 .316 .582 r
F P
0 g
s
.30546 .48606 m .34802 .45621 L .33637 .35505 L p .393 .256 .573 r
F P
0 g
s
.31388 .61403 m .3423 .58821 L .30546 .48606 L p .382 .341 .688 r
F P
0 g
s
.3423 .58821 m .31388 .61403 L .37576 .70259 L p .441 .455 .778 r
F P
0 g
s
.39873 .68497 m .37576 .70259 L .45256 .77583 L p .458 .545 .858 r
F P
0 g
s
.45256 .77583 m .46829 .76678 L .39873 .68497 L p .458 .545 .858 r
F P
0 g
s
.34802 .45621 m .30546 .48606 L .3423 .58821 L p .463 .385 .683 r
F P
0 g
s
.37576 .70259 m .39873 .68497 L .3423 .58821 L p .441 .455 .778 r
F P
0 g
s
.42884 .66923 m .39873 .68497 L .46829 .76678 L p .504 .555 .841 r
F P
0 g
s
.46829 .76678 m .48857 .75903 L .42884 .66923 L p .504 .555 .841 r
F P
0 g
s
.34802 .45621 m .40065 .43035 L .39106 .32553 L p .479 .316 .582 r
F P
0 g
s
.3423 .58821 m .38005 .56475 L .34802 .45621 L p .463 .385 .683 r
F P
0 g
s
.38005 .56475 m .3423 .58821 L .39873 .68497 L p .5 .479 .765 r
F P
0 g
s
.39873 .68497 m .42884 .66923 L .38005 .56475 L p .5 .479 .765 r
F P
0 g
s
.46556 .65612 m .42884 .66923 L .48857 .75903 L p .544 .565 .826 r
F P
0 g
s
.48857 .75903 m .51302 .75301 L .46556 .65612 L p .544 .565 .826 r
F P
0 g
s
.40065 .43035 m .34802 .45621 L .38005 .56475 L p .526 .422 .679 r
F P
0 g
s
.42651 .54469 m .38005 .56475 L .42884 .66923 L p .548 .5 .754 r
F P
0 g
s
.42884 .66923 m .46556 .65612 L .42651 .54469 L p .548 .5 .754 r
F P
0 g
s
.38005 .56475 m .42651 .54469 L .40065 .43035 L p .526 .422 .679 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{263.813, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004700017b000`400?l00000o`00003oo`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool8
0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00IP3oool0
0`000000oooo0?ooo`2N0?ooo`00I03oool300000:00oooo001R0?ooo`8000000P1jD9@00`000000
oooo0?ooo`2N0?ooo`00H03oool2000000@0NU2D00<000000?ooo`3oool0WP3oool005l0oooo00<0
000007Y@U01jD9@0101jD9@00`000000oooo0?ooo`2N0?ooo`00G@3oool2000000P0NU2D00<00000
0?ooo`3oool0903oool3000007H0oooo001K0?ooo`8000002P1jD9@00`000000oooo0?ooo`0P0?oo
o`@0000000<0/?[P0000003;j>/00P00001d0?ooo`00F@3oool2000000`0NU2D00<000000?ooo`3o
ool07P3oool2000000@0/?[P00<000000<_Xj`3;j>/00P3;j>/200000780oooo001H0?ooo`030000
001jD9@0NU2D00`0NU2D00<000000?ooo`3oool0703oool3000000030;3jh0000000000000800000
1`3;j>/200000700oooo001G0?ooo`8000003P1jD9@00`000000oooo0?ooo`0K0?ooo`D000000P38
oN<010000000d>;U0=3Ri@3@h^D4000000<0bnS[00<000000?ooo`3oool0K@3oool005D0oooo0P00
00000`1T@I80000007Y@U00=07Y@U0030000003oool0oooo01X0oooo0`0000040<Smh`030000003@
h^D0d>;U00H0d>;U0`0000000`3Ic/l000000?ooo`1]0?ooo`00E03oool01@000000I46B06A1TP1T
@I80000000h0NU2D00<000000?ooo`3oool06@3oool4000000030<Smh`000000000000H000001@3@
h^D01@000000eLK;0000003Ic/l0000000T0oooo3@00001G0?ooo`00D`3oool00`000000I46B06A1
TP0206A1TP030000001jD9@0NU2D00`0NU2D00<000000?ooo`3oool0603oool20000000603P0=`00
000000000000003Gn>4000001P3Bf]l7000000050=G6b`00000000000000003oool01`00000305`0
00030000001a0000L@0000@0L@000P0000000`20000000000000000500000500oooo001A0?ooo`80
00001P1T@I800`000000NU2D07Y@U00;07Y@U0030000003oool0oooo01L0oooo0P00000203P0=`05
0000003Gn>40eoSQ0=Ohh@0000002P3Bf]l00`000000dKg70=6ma`05000000<0?`0000<0000005`0
001L00001@1L00000`000000L@00074000050740008000000`2000020000000308P0000000000000
00800000C03oool00500oooo00<0000006A1TP1T@I801P1T@I800`000000NU2D07Y@U00;07Y@U003
0000003oool0oooo01H0oooo00<0000003P0=`0h03L00P0h03L00`000000eoSQ0000000?00000003
01T000000000?`0000@0?`005@00000308000003000000280000R0000080R0000P00001:0?ooo`00
C`3oool00`000000I46B06A1TP0706A1TP030000001jD9@0NU2D00`0NU2D00<000000?ooo`3oool0
503oool2000000<0>00g0`0000000`3Nkm`000000=;CfP080=;CfP8000000`0I00000`000000?`00
03l000040000000308LV@`000000VCE600L0VCE600<000000:Q1A02X@D@01P2X@D@00`000000]T/o
00000005000000@0R0000P0000180?ooo`00C@3oool2000000X0I46B00<0000007Y@U01jD9@0301j
D9@00`000000oooo0?ooo`0C0?ooo`800000100h03L010000000g^oL0=k_g00000060=;CfP@00000
100I0004000000D0QbI300<0000009TeAP2I=DH01`2I=DH00`000000Z4540:Q1A0060:Q1A0030000
002fBcl0]T/o0080]T/o1000000308P000<00000AP3oool004`0oooo00<0000006A1TP1T@I802P1T
@I800`000000NU2D07Y@U00<07Y@U0030000003oool0oooo0180oooo00<0000000H07P000000100h
03L00`000000g^oL0000000:0000000301T00000000000000080000000<0LA8m000000279T<01P27
9T<00`000000VCE609TeAP0709TeAP030000002X@D@0Z45400H0Z45400<000000;I;?`2fBcl0102f
Bcl00`000000`e8d00000007000004@0oooo001;0?ooo`800000301T@I800`000000NU2D07Y@U00<
07Y@U0030000003oool0oooo0140oooo00@0000000H07P0601h000000`0h03L3000000030>3TeP00
0000d<_E00<0d<_E1P000005074B?@03000000279T<0QbI300D0QbI300<0000009TeAP2I=DH01`2I
=DH00`000000Z4540:Q1A0060:Q1A0030000002fBcl0]T/o00D0]T/o00<000000<=B=033DS@00P33
DS@600000480oooo001:0?ooo`0300000016;Hh0000000`0I46B00<0000007Y@U01jD9@0301jD9@0
0`000000oooo0?ooo`0@0?ooo`040000000601h01P0N000000@0>00g00@000000>3TeP3Pi=H00000
0`3@bmD40000000305@0<@000000LA8m00H0LA8m00<0000008LV@`279T<01P279T<00`000000VCE6
09TeAP0609TeAP030000002X@D@0Z45400L0Z45400<000000;I;?`2fBcl0102fBcl00`000000`e8d
0<=B=0050<=B=0@00000@@3oool004T0oooo00@0000004H]SP16;Hh00000301T@I800`000000NU2D
07Y@U00<07Y@U0030000003oool0oooo00l0oooo0P00000200H07P030000000h03L0>00g00<00000
0P3Pi=H6000000<0E00a00<00000074B?@1a4Sd01@1a4Sd00`000000QbI308LV@`0608LV@`030000
002I=DH0VCE600L0VCE600<000000:Q1A02X@D@01P2X@D@00`000000]T/o0;I;?`050;I;?`030000
0033DS@0`e8d00@0`e8d00<000000<eG8P3=Eb800`00000o0?ooo`00B03oool00`000000ARf>04H]
SP0204H]SP030000001T@I80I46B00T0I46B00<0000007Y@U01jD9@0301jD9@00`000000oooo0?oo
o`0>0?ooo`8000000`0601h00`000000>00g0000000206D_N0L000001@1D03400`000000LA8m074B
?@05074B?@03000000279T<0QbI300H0QbI300<0000009TeAP2I=DH00`2I=DH9000000D0Z45400<0
00000;I;?`2fBcl0102fBcl00`000000`e8d0<=B=0050<=B=0040000003=Eb80cELR0<eG8P800000
?P3oool004P0oooo00<0000004H]SP16;Hh00P16;Hh00`000000I46B06A1TP0:06A1TP030000001j
D9@0NU2D00/0NU2D00<000000?ooo`3oool03P3oool2000000801P0N0`00000306D_N0030000003O
f=00gmS@00<000001@1D03400`000000LA8m074B?@06074B?@03000000279T<0QbI30080QbI32P00
00040:]QN0030000002hJgL0^6]g0080^6]g200000050;I;?`0300000033DS@0`e8d00@0`e8d00<0
00000<eG8P3=Eb800`3=Eb82000003`0oooo00170?ooo`0300000016;Hh0ARf>00<0ARf>00<00000
06A1TP1T@I802P1T@I800`000000NU2D07Y@U00;07Y@U0030000003oool0oooo00d0oooo0P000003
00H07P030000001U;gP0IBmh00<0IBmh0`0000000`0/01d0000005@0<@0505@0<@030000001a4Sd0
LA8m00@0LA8m1`00000409eFM`030000002[HGP0Zf5h00L0Zf5h00<000000;Q[M`2hJgL01`2hJgL0
0`000000a7Ae0<AdM@04000000030;I;?`000000`e8d00H0`e8d00<000000<eG8P3=Eb800P3=Eb80
0`000000dEH50000000k0?ooo`00AP3oool00`000000ARf>04H]SP0404H]SP030000001T@I80I46B
00X0I46B00<0000007Y@U01jD9@0301jD9@00`000000oooo0?ooo`0;0?ooo`<000000P0601h20000
00D0IBmh0P00000202`07@030000001D0340E00a00@0E00a00<00000074B?@1a4Sd01000000208i9
MP030000002MEWL0WEIg00H0WEIg00<000000:]QN02[HGP01`2[HGP00`000000^6]g0;Q[M`070;Q[
M`0300000034M7D0a7Ae00@0a7Ae100000050<=B=0030000003=Eb80cELR00<0cELR00@000000=5F
1@0000000000>@3oool004D0oooo00<0000004H]SP16;Hh01@16;Hh00`000000I46B06A1TP0:06A1
TP030000001jD9@0NU2D00`0NU2D00<000000?ooo`3oool02`3oool2000000801P0N00<0000004LH
L@0000001@1U;gP01@000000;00M02`07@0/01d0000000D0E00a1000000608i9MP030000002MEWL0
WEIg00H0WEIg00<000000:]QN02[HGP01`2[HGP00`000000^6]g0;Q[M`070;Q[M`0300000034M7D0
a7Ae00H0a7Ae00<000000=1nL@0000000P0000030<=B=0030000003=Eb80cELR0080cELR00D00000
0=5F1@3AEPD0dEH50000000h0?ooo`00A03oool00`000000ARf>04H]SP0604H]SP030000001T@I80
I46B00X0I46B00<0000007Y@U01jD9@0301jD9@00`000000oooo0?ooo`0:0?ooo`D000000P176740
0`000000IBmh06D_N00306D_N0050000000/01d0;00M02`07@0000000`1D03420000000307`iLP00
0000STUf00L0STUf00<0000009eFM`2MEWL01P2MEWL00`000000Zf5h0:]QN0070:]QN0030000002h
JgL0^6]g00L0^6]g00<000000<AdM@34M7D01P34M7D00`000000d7ia0=1nL@020=1nL@@000001@3=
Eb801@000000dEH50=5F1@3AEPD0000003L0oooo00130?ooo`8000002@16;Hh00`000000I46B06A1
TP0906A1TP030000001jD9@0NU2D00`0NU2D00<000000?ooo`3oool02P3oool3000000@0AaQa00<0
000006D_N01U;gP00`1U;gP01@000000;00M02`07@000000E00a00<000000`1l>G800`000000STUf
08i9MP0608i9MP030000002MEWL0WEIg00H0WEIg00<000000:]QN02[HGP01`2[HGP00`000000^6]g
0;Q[M`070;Q[M`0300000034M7D0a7Ae00H0a7Ae00<000000=1nL@3@OW401@3@OW42000000D0cELR
00<000000=5F1@3AEPD00P00000f0?ooo`00@`3oool2000000T0ARf>00<0000006A1TP1T@I802@1T
@I800`000000NU2D07Y@U00;07Y@U08000002`3oool3000000D0AaQa00<0000006D_N01U;gP00`1U
;gP00`000000;00M02`07@02000000H0O3Ub00<0000008i9MP2>BGH01P2>BGH00`000000WEIg09eF
M`0709eFM`030000002[HGP0Zf5h00L0Zf5h00<000000;Q[M`2hJgL01P2hJgL00`000000a7Ae0<Ad
M@070<AdM@030000003@OW40d7ia00D0d7ia0`0000030<eG8P040000003AEPD0dEH50=5F1@800000
=@3oool00480oooo00<0000001/?Q00000002@16;Hh00`000000I46B06A1TP0906A1TP030000001j
D9@0NU2D00T0NU2D0P0000000`26K:d000000?ooo`0:0?ooo`<00000101767400`000000IBmh06D_
N00406D_N0@000001`1l>G800`000000STUf08i9MP0608i9MP030000002MEWL0WEIg00L0WEIg00<0
00000:]QN02[HGP01`2[HGP00`000000^6]g0;Q[M`070;Q[M`0300000034M7D0a7Ae00H0a7Ae00<0
00000=1nL@3@OW401@3@OW400`000000gHMZ0=f7JP0200000080cELR00@000000=5F1@3AEPD0dEH5
0P00000d0?ooo`00@P3oool00`0000006`n40000000904H]SP030000001T@I80I46B00X0I46B00<0
000007Y@U01jD9@01P1jD9@2000000<0QVb]00<000000?ooo`3oool02@3oool3000000@0AaQa00<0
000006D_N01U;gP0101U;gP010000000I2E[06@UJ`00000707`iLP030000002>BGH0STUf00H0STUf
00<0000009eFM`2MEWL01`2MEWL00`000000Zf5h0:]QN0070:]QN0030000002hJgL0^6]g00L0^6]g
00<000000<AdM@34M7D01P34M7D00`000000d7ia0=1nL@060=1nL@040000003MQfX0gHMZ0=f7JP<0
00000`3AEPD00`000000aD/00000000c0?ooo`00@@3oool01@0000006`n401/?Q00K3h@0000000P0
ARf>00<0000006A1TP1T@I802P1T@I800`000000NU2D07Y@U00307Y@U0<000001P26K:d00`000000
oooo0?ooo`070?ooo`80000000<06`1S0000001767400`1767400`000000IBmh06D_N00206D_N0<0
000000<0I2E[0000000000001P1l>G800`000000STUf08i9MP0708i9MP030000002MEWL0WEIg00L0
WEIg00<000000:]QN02[HGP01`2[HGP00`000000^6]g0;Q[M`070;Q[M`0300000034M7D0a7Ae00H0
a7Ae00<000000=1nL@3@OW401P3@OW400`000000gHMZ0=f7JP030=f7JP8000000`3AEPD00`000000
aD/00000000b0?ooo`00@03oool00`0000006`n401/?Q00201/?Q00300000016;Hh0ARf>00H0ARf>
00<0000006A1TP1T@I802P1T@I8010000000NU2D07Y@U01jD9@2000000T0QVb]00<000000?ooo`3o
ool01`3oool20000000301/0H`000000AaQa00<0AaQa00<0000006D_N01U;gP00P000000101iE9X0
I2E[0000001T9F/2000000H0O3Ub00<0000008i9MP2>BGH01`2>BGH00`000000WEIg09eFM`0709eF
M`030000002[HGP0Zf5h00L0Zf5h00<000000;Q[M`2hJgL01`2hJgL00`000000a7Ae0<AdM@060<Ad
M@030000003@OW40d7ia00H0d7ia00<000000=f7JP3MQfX0103MQfX3000000040=5F1@000000aD/0
00000380oooo00100?ooo`030000000K3h@06`n400806`n400<0000004H]SP16;Hh01`16;Hh00`00
0000I46B06A1TP0906A1TP040000001jD9@00000000000/0QVb]00<000000?ooo`3oool01P3oool2
000000806`1S00<0000004LHL@1767400P176743000000<0NEBJ00<0I2E[0000001T9F/00P000006
07`iLP030000002>BGH0STUf00L0STUf00<0000009eFM`2MEWL00`2MEWLC000000D0^6]g00<00000
0<AdM@34M7D01P34M7D00`000000d7ia0=1nL@060=1nL@030000003MQfX0gHMZ00@0gHMZ00P00000
0>VAGP3YTEh000000=5F1@000000aD/000000340oooo000o0?ooo`030000000K3h@06`n400<06`n4
00<0000004H]SP16;Hh01`16;Hh00`000000I46B06A1TP0906A1TP8000003@26K:d00`000000oooo
0?ooo`060?ooo`8000000P0K06<00`000000AaQa04LHL@0204LHL@800000101iE9X0101T9F/00000
06@UJ`00000707`iLP030000002>BGH0STUf00D0STUf200000040:I_U0030000002aN9@0/GRD00L0
/GRD00<000000;^1U02kPI@00P2kPI@7000000P0a7Ae00<000000=1nL@3@OW401P3@OW400`000000
gHMZ0=f7JP040=f7JP080000003YTEh0jI5N0000003AEPD000000<E;0000000`0?ooo`00?`3oool0
0`0000006`n401/?Q00301/?Q00300000016;Hh0ARf>00L0ARf>00<0000006A1TP1T@I801`1T@I83
000000l0QVb]00<000000?ooo`3oool0103oool3000000806`1S00@0000004LHL@176740AaQa0P00
000507UDVP<0I2E[00<0000007`iLP1l>G801@1l>G800`000000STUf08i9MP0500000080VVJD00<0
00000:I_U02VKi@01`2VKi@00`000000/GRD0;5hU0070;5hU0030000002kPI@0^h6D00L0^h6D00<0
00000<J:U00000000P0000050<AdM@030000003@OW40d7ia00H0d7ia00<000000=f7JP3MQfX0103M
QfX010000000jI5N0>VAGP3YTEh2000000030<E;00000000oooo02l0oooo000n0?ooo`030000000K
3h@06`n400@06`n400<0000004H]SP16;Hh01`16;Hh00`000000I46B06A1TP0606A1TP050000001f
HZh0MV:^07IR[P0000003P26K:d00`000000oooo0?ooo`040?ooo`030000000004P0000000806`1S
00H0000004LHL@176740000006A6V@00000207UDVP030000001T9F/0I2E[00<0I2E[00<0000007`i
LP1l>G80101l>G84000000L0VVJD00<000000:I_U02VKi@01`2VKi@00`000000/GRD0;5hU0070;5h
U0030000002kPI@0^h6D00L0^h6D00<000000<J:U036RY@00P36RY@4000000030<AdM@000000d7ia
00L0d7ia00<000000=f7JP3MQfX0103MQfX00`000000jI5N0>VAGP030>VAGP0300000035B`000000
02l0oooo000n0?ooo`030000000K3h@06`n400@06`n400<0000004H]SP16;Hh01`16;Hh00`000000
I46B06A1TP0506A1TP030000001fHZh0MV:^0080MV:^00<0000008I/[@26K:d03026K:d00`000000
oooo0?ooo`030?ooo`80000000L000180000000K06<06`1S000000176740000000<0I4JI00<00000
04<:H00000001@1T9F/00`000000O3Ub07`iLP0207`iLP80000000<0S5^C0000002JIY@0202JIY@0
0`000000YVnD0:I_U0070:I_U0030000002aN9@0/GRD00L0/GRD00<000000;^1U02kPI@01`2kPI@0
0`000000aXZD0<J:U0060<J:U0<000001`3@OW400`000000gHMZ0=f7JP040=f7JP030000003YTEh0
jI5N00<0jI5N0`00000_0?ooo`00?@3oool2000000H06`n400<0000004H]SP16;Hh01`16;Hh00`00
0000I46B06A1TP0306A1TP8000001@1fHZh00`000000QVb]08I/[@0<08I/[@030000003oool0oooo
00<0oooo00<000000000B00000000`0K06<2000000@0I4JI00<0000004<:H00000001@1T9F/00`00
0000O3Ub00000002000000<0S5^C00<0000009YVU02JIY@01`2JIY@00`000000YVnD0:I_U0070:I_
U0030000002aN9@0/GRD00L0/GRD00<000000;^1U02kPI@01`2kPI@00`000000aXZD0<J:U0070<J:
U0030000003ATi<00000008000001@3@OW400`000000gHMZ0=f7JP040=f7JP030000003YTEh0jI5N
0080jI5N1000000^0?ooo`00?@3oool2000000L06`n400<0000004H]SP16;Hh01`16;Hh01@000000
I46B06A1TP1T@I80000000L0MV:^00<0000008I/[@26K:d03@26K:d00`000000oooo0?ooo`020?oo
o`030000000004P0000000<06`1S00@0000006A6V@1TAYT0I4JI10132V000`000000I2E[06@UJ`02
06@UJ`<000001P2<Fi<00`000000VVJD09YVU00709YVU0030000002VKi@0YVnD00L0YVnD00<00000
0;5hU02aN9@01`2aN9@00`000000^h6D0;^1U0070;^1U00300000036RY@0aXZD00L0aXZD00<00000
0=6CT`3ATi<00P3ATi<4000000030=1nL@000000gHMZ00D0gHMZ00<000000>VAGP3YTEh00`3YTEh0
10000000lYQ900000000000]0?ooo`00?@3oool00`000000001`0000000601/?Q00300000016;Hh0
ARf>00L0ARf>00@0000006A1TP1T@I8000002@1fHZh00`000000QVb]08I/[@0<08I/[@030000003o
ool0oooo0080oooo00<000000000B00000000P0K06<20000000306A6V@000000@`YP00<0@`YP00@0
000006@UJ`1T9F/0I2E[0P0000000`1kCi40000008aKT`0608aKT`030000002JIY@0VVJD00L0VVJD
00<000000:I_U02VKi@01`2VKi@00`000000/GRD0;5hU0070;5hU0030000002kPI@0^h6D00L0^h6D
00<000000<J:U036RY@01`36RY@00`000000dI>C0=6CT`060=6CT`8000001P3MQfX00`000000jI5N
0>VAGP030>VAGP040000003bV4T0lYQ9000002d0oooo000m0?ooo`03000000000700000000H06`n4
00<0000004H]SP16;Hh01`16;Hh3000000X0MV:^00<0000008I/[@26K:d03026K:d010000000oooo
0?ooo`3oool2000000080000B00000006`1S00000018=9L000000180C000000404<:H0040000001T
9F/00000000000<0NdnA00<0000008aKT`2<Fi<01@2<Fi<00`000000VVJD09YVU00709YVU0030000
002VKi@0YVnD00L0YVnD00<000000;5hU02aN9@01`2aN9@00`000000^h6D0;^1U0070;^1U0030000
0036RY@0aXZD00L0aXZD00<000000=6CT`3ATi<01`3ATi<3000000@0gHMZ00<000000>VAGP3YTEh0
0`3YTEh01@000000lYQ90?:HB@3bV4T0000002`0oooo000l0?ooo`04000000000700001`000000H0
6`n400<0000004H]SP16;Hh01`16;Hh00`000000MV:^07IR[P0:07IR[P0300000026K:d0QVb]00`0
QVb]00@000000?ooo`3oool0oooo0P0000000`0004P000000000000204PdU`030000000B04`00000
00@0@`YP0P00000507]?T@030000002<Fi<0S5^C00D0S5^C00<0000009YVU02JIY@01`2JIY@00`00
0000YVnD0:I_U0070:I_U0030000002aN9@0/GRD00L0/GRD00<000000;^1U02kPI@01`2kPI@00`00
0000aXZD0<J:U0070<J:U0030000003ATi<0dI>C00L0dI>C00<000000=bNT@3LWY400P0000030=f7
JP030000003YTEh0jI5N0080jI5N0P0000020?:HB@800000:`3oool003`0oooo00@000000000L000
070000001P0K3h@00`000000ARf>04H]SP0604H]SP800000301fHZh00`000000QVb]08I/[@0<08I/
[@040000003oool0oooo0?ooo`80000000<0001800000018=9L00`18=9L0100B04`0000004<:H013
2V03000000H0NdnA00<0000008aKT`2<Fi<01@2<Fi<00`000000VVJD09YVU00709YVU0030000002V
Ki@0YVnD00L0YVnD00<000000;5hU02aN9@01`2aN9@00`000000^h6D0;^1U0070;^1U00300000036
RY@0aXZD00L0aXZD00<000000=6CT`3ATi<01`3ATi<00`000000g9jA0=bNT@020=bNT@80000000<0
gHMZ0000003YTEh00`3YTEh2000000040?:HB@000000lYQ9000002/0oooo000l0?ooo`0400000000
0700001`000000H06`n400<0000004H]SP16;Hh01@16;Hh010000000HEN`065G/000000<07IR[P03
00000026K:d0QVb]00`0QVb]00<000000?ooo`3oool00P000000100004P0000004PdU`0000020180
C004000000132V00@`YP00000080ICn?00<0000007]?T@1kCi40101kCi400`000000S5^C08aKT`06
08aKT`030000002JIY@0VVJD00H0VVJD00<000000:I_U02VKi@01`2VKi@00`000000/GRD0;5hU007
0;5hU0030000002kPI@0^h6D00L0^h6D00<000000<J:U036RY@01`36RY@00`000000dI>C0=6CT`06
0=6CT`030000003LWY40g9jA00D0g9jA0P0000050>VAGP80000000@0m;nD0?:HB@0000000000:P3o
ool003`0oooo00@000000000L000070000001P0K3h@00`000000ARf>04H]SP0404H]SP050000001Q
Ek00HEN`065G/0000000301fHZh00`000000QVb]08I/[@0<08I/[@030000003oool0oooo00@00000
00@0000X0000000B04`04P1<0`00000306DoS`030000001kCi40NdnA00@0NdnA00<0000008aKT`2<
Fi<01P2<Fi<00`000000VVJD09YVU00609YVU0030000002VKi@0YVnD00L0YVnD00<000000;5hU02a
N9@01`2aN9@00`000000^h6D0;^1U0070;^1U00300000036RY@0aXZD00H0aXZD00<000000=6CT`3A
Ti<01`3ATi<00`000000g9jA0=bNT@060=bNT@800000103YTEh00`000000lYQ90?BoU00200000003
0>fF90000000oooo02P0oooo000k0?ooo`03000000000700001`0080001`00<0000001/?Q00K3h@0
0`0K3h@00`000000ARf>04H]SP0304H]SP030000001QEk00HEN`0080HEN`00<0000007IR[P1fHZh0
2P1fHZh00`000000QVb]08I/[@0<08I/[@040000003oool0oooo00006`<0000000D0B3BG0000000B
04`04P1<0000000506DoS`030000001kCi40NdnA00@0NdnA00<0000008aKT`2<Fi<01P2<Fi<00`00
0000VVJD09YVU00609YVU0030000002VKi@0YVnD00L0YVnD00<000000;5hU02aN9@01`2aN9@00`00
0000^h6D0;^1U0070;^1U00300000036RY@0aXZD00H0aXZD00<000000=6CT`3ATi<01`3ATi<00`00
0000g9jA0=bNT@060=bNT@030000003XZHl0000000<0jI5N00L000000?:HB@3bV4T0m;nD0000003]
UR@0000002T0oooo000k0?ooo`03000000000700001`0080001`00<0000001/?Q00K3h@0100K3h@0
1@000000ARf>04H]SP16;Hh0000000H0HEN`00<0000007IR[P1fHZh02P1fHZh00`000000QVb]08I/
[@0;08I/[@050000003oool0oooo00006`0000000P0O6i02000000030180C0000000000000D0ICn?
00<0000007]?T@1kCi401@1kCi400`000000S5^C08aKT`0508aKT`030000002JIY@0VVJD00H0VVJD
00<000000:I_U02VKi@01`2VKi@00`000000/GRD0;5hU0070;5hU0030000002kPI@0^h6D00L0^h6D
00<000000<J:U036RY@01P36RY@00`000000dI>C0=6CT`070=6CT`030000003LWY40g9jA00H0g9jA
00<000000>RYS`3XZHl00P0000000`3YTEh00000000000030?:HB@030000003]UR@0000002P0oooo
000k0?ooo`03000000000700001`0080001`00<0000001/?Q00K3h@0100K3h@010000000ARf>04H]
SP000007065G/0030000001fHZh0MV:^00X0MV:^00<0000008I/[@26K:d03026K:d2000000090000
6`00000000000000:00000004P1<00000017:HT0000000D0ICn?00<0000007]?T@1kCi401@1kCi40
0`000000S5^C08aKT`0508aKT`030000002JIY@0VVJD00H0VVJD00<000000:I_U02VKi@00`2VKi@9
000000D0/GRD00<000000;^1U02kPI@01`2kPI@00`000000aXZD0<J:U0060<J:U0030000003ATi<0
dI>C00L0dI>C00<000000=bNT@3LWY401P3LWY400`000000j:V?0>RYS`020>RYS`030000003YTEh0
000000<0lYQ900<0m;nD000000000000:03oool003/0oooo00<000000000L00007000P0007000`00
00006`n401/?Q00401/?Q00300000016;Hh0000000P0HEN`00<0000007IR[P1fHZh02P1fHZh00`00
0000QVb]08I/[@0<08I/[@80000000T0000K000000000000000X0000000B04`0000004LYR@000000
1@1U?hl00`000000NdnA07]?T@0507]?T@030000002<Fi<0S5^C00D0S5^C00<0000009YVU02JIY@0
102JIY@8000000@0ZH2X00<000000;:7Z02bQjP00P2bQjP:000000D0^h6D00<000000<J:U036RY@0
1P36RY@00`000000dI>C0=6CT`070=6CT`030000003LWY40g9jA00D0g9jA00<000000>RYS`3XZHl0
103XZHl2000000<0lYQ900@000000?BoU000000000009`3oool003/0oooo0P0000030000L0030000
000K3h@06`n400@06`n40P00000:065G/0030000001fHZh0MV:^00T0MV:^00<0000008I/[@26K:d0
3026K:d5000000030000:000000000000080AbV900<0000006DoS`1U?hl0101U?hl00`000000NdnA
07]?T@0407]?T@030000002<Fi<0S5^C00D0S5^C00<0000009YVU02JIY@01000000209miZ0030000
002YP:P0ZH2X00L0ZH2X00<000000;:7Z02bQjP01`2bQjP00`000000^hnX0;^?Z0020;^?Z0L00000
1`36RY@00`000000dI>C0=6CT`070=6CT`030000003LWY40g9jA00D0g9jA00<000000>RYS`3XZHl0
1@3XZHl010000000lYQ90?:HB@3bV4T2000000030?k>R`000000oooo02H0oooo000k0?ooo`800000
0`0007000`0000006`n401/?Q00401/?Q0030000001QEk00HEN`00T0HEN`00<0000007IR[P1fHZh0
2P1fHZh00`000000QVb]08I/[@0;08I/[@D0000000<0000X00000017:HT00P17:HT00`000000ICn?
06DoS`0406DoS`030000001kCi40NdnA00@0NdnA00<0000008aKT`2<Fi<0102<Fi<4000000H0WgVX
00<000000:V0Z02YP:P01`2YP:P00`000000/XNX0;:7Z0070;:7Z0030000002kSjP0^hnX00L0^hnX
00<000000<BGZ@0000000P0000040<J:U0030000003ATi<0dI>C00L0dI>C00<000000=bNT@3LWY40
1@3LWY400`000000j:V?0>RYS`050>RYS`8000000P3bV4T010000000kIHT0?k>R`00000W0?ooo`00
>`3oool2000000@0001`00<0000001/?Q00K3h@00P0K3h@2000000/0HEN`00<0000007IR[P1fHZh0
2P1fHZh00`000000QVb]08I/[@0<08I/[@03000000000840002100<000000`17:HT00`000000ICn?
06DoS`0406DoS`030000001kCi40NdnA00@0NdnA00<0000008aKT`2<Fi<0100000000`2CLJT00000
09miZ00709miZ0030000002YP:P0ZH2X00L0ZH2X00<000000;:7Z02bQjP01`2bQjP00`000000^hnX
0;^?Z0070;^?Z00300000034UjT0a9NY0080a9NY0`0000000`36RY@000000=6CT`070=6CT`030000
003LWY40g9jA00H0g9jA00<000000>RYS`3XZHl01@3XZHl020000000m;N90000003bV4T000000>fF
903ncX/000009`3oool003/0oooo0P0000040000L0030000000K3h@06`n400806`n400<0000004E8
/00000002`1QEk000`000000MV:^07IR[P0907IR[P0300000026K:d0QVb]00`0QVb]00H000000000
P@000000000001/;OP00000404LYR@030000001U?hl0ICn?00<0ICn?00<0000007]?T@1kCi400`1k
Ci44000000D0Tg6Y00<0000009miZ02ONJP01P2ONJP00`000000ZH2X0:V0Z0070:V0Z0030000002b
QjP0/XNX00L0/XNX00<000000;^?Z02kSjP01`2kSjP00`000000a9NY0<BGZ@050<BGZ@<000001`3A
Ti<00`000000g9jA0=bNT@060=bNT@030000003XZHl0j:V?00D0j:V?00<000000?BgR@0000000P3b
V4T010000000kIHT00000000000V0?ooo`00>`3oool2000000@0001`00D0000001/?Q00K3h@06`n4
0000000204E8/0030000001QEk00HEN`00T0HEN`00<0000007IR[P1fHZh02P1fHZh00`000000QVb]
08I/[@0;08I/[@0600000000084000000000000K2gh000001017:HT00`000000ICn?06DoS`0306Do
S`040000001kCi40NdnA07]?T@80000000<0QVRY0000002CLJT01P2CLJT00`000000WgVX09miZ006
09miZ0030000002YP:P0ZH2X00L0ZH2X00<000000;:7Z02bQjP01P2bQjP00`000000^hnX0;^?Z007
0;^?Z00300000034UjT0a9NY00L0a9NY00<000000<fOZ@0000000P0000040=6CT`030000003LWY40
g9jA00H0g9jA00<000000>RYS`3XZHl0103XZHl020000000m;N90?BgR@3d]hT000000?:HB@000000
kIHT0P00000V0?ooo`00>`3oool2000000@0001`00D0000001/?Q00K3h@06`n40000000304E8/003
0000001QEk00HEN`00P0HEN`00<0000007IR[P1fHZh02P1fHZh00`000000QVb]08I/[@0;08I/[@<0
00000P0K2gh00`000000AbV904LYR@0204LYR@030000001U?hl0ICn?00<0ICn?00@0000007]?T@00
000000000`26J:T00`000000Tg6Y09=aZ@0509=aZ@030000002ONJP0WgVX00H0WgVX00<000000:V0
Z02YP:P01`2YP:P00`000000/XNX0;:7Z0060;:7Z0030000002kSjP0^hnX00L0^hnX00<000000<BG
Z@34UjT01`34UjT00`000000cInY0<fOZ@020<fOZ@<0000000<0dI>C0000003LWY401`3LWY400`00
0000j:V?0>RYS`040>RYS`030000003d]hT0m;N90080m;N90P000000103]UR@0000000000000000U
0?ooo`00>`3oool00`0000000017000000030000L0040000000K3h@06`n4000000@0ADR`00<00000
065G/01QEk002@1QEk000`000000MV:^07IR[P0907IR[P0300000026K:d0QVb]00`0QVb]0P000002
01/;OP0300000017:HT0AbV90080AbV900<0000006DoS`1U?hl00`1U?hl2000000H0QVRY00<00000
09=aZ@2CLJT01@2CLJT00`000000WgVX09miZ00509miZ0030000002YP:P0ZH2X00L0ZH2X00<00000
0;:7Z02bQjP01P2bQjP00`000000^hnX0;^?Z0070;^?Z00300000034UjT0a9NY00H0a9NY00<00000
0<fOZ@3=WjT01P3=WjT2000000P0g9jA00<000000>RYS`3XZHl0103XZHl00`000000m;N90?BgR@03
0?BgR@050000003]UR@000000<9m000000009@3oool003/0oooo00<000000000A`0000000`000700
100000006`n401/?Q000000504E8/0030000001QEk00HEN`00P0HEN`00<0000007IR[P1fHZh02@1f
HZh00`000000QVb]08I/[@0<08I/[@8000000P0K2gh00`000000AbV904LYR@0204LYR@040000001U
?hl0ICn?06DoS`<000001`26J:T00`000000Tg6Y09=aZ@0509=aZ@030000002ONJP0WgVX00D0WgVX
00<000000:V0Z02YP:P01`2YP:P00`000000/XNX0;:7Z0060;:7Z0030000002kSjP0^hnX00L0^hnX
00<000000<BGZ@34UjT01P34UjT00`000000cInY0<fOZ@070<fOZ@<000001@3LWY400`000000j:V?
0>RYS`050>RYS`030000003d]hT0m;N900<0m;N90P0000000`3]UR@0`Wd00000000U0?ooo`00>`3o
ool00`0000000017000000040000L08000001P15B;000`000000HEN`065G/008065G/0030000001f
HZh0MV:^00X0MV:^00<0000008I/[@26K:d02P26K:d3000000<06`]n00H0000004LYR@17:HT0AbV9
0000001U?hl2000000<0MUnZ00<0000008IXZ@26J:T01026J:T00`000000Tg6Y09=aZ@0509=aZ@03
0000002ONJP0WgVX00D0WgVX00<000000:V0Z02YP:P01P2YP:P00`000000/XNX0;:7Z0070;:7Z003
0000002kSjP0^hnX00L0^hnX00<000000<BGZ@34UjT01P34UjT00`000000cInY0<fOZ@060<fOZ@05
0000003FZJX0eZVZ0=JYZP000000103LWY400`000000j:V?0>RYS`050>RYS`030000003d]hT0m;N9
00<0m;N90P0000000`3]UR@0`Wd00?cGM00U0?ooo`00?03oool2000000@0001`0P00000704E8/003
0000001QEk00HEN`00P0HEN`00<0000007IR[P1fHZh02@1fHZh00`000000QVb]08I/[@0808I/[@80
000000<0S7o10000000000000`0K2gh010000000AbV904LYR@17:HT2000000D0MUnZ00<0000008IX
Z@26J:T01026J:T00`000000Tg6Y09=aZ@0509=aZ@030000002ONJP0WgVX00H0WgVX00<000000:V0
Z02YP:P01@2YP:P00`000000/XNX0;:7Z0070;:7Z0030000002kSjP0^hnX00L0^hnX00<000000<BG
Z@34UjT01P34UjT00`000000cInY0<fOZ@060<fOZ@030000003FZJX0eZVZ0080eZVZ0P0000020=bN
T@030000003XZHl0j:V?00D0j:V?00<000000?BgR@3d]hT00`3d]hT00`000000o/Am000000020000
02D0oooo000l0?ooo`800000100007000`000000ADR`04E8/00604E8/0030000001QEk00HEN`00P0
HEN`00<0000007IR[P1fHZh02@1fHZh00`000000QVb]08I/[@0508I/[@<00000102<Ol401@000000
6`]n01/;OP0K2gh000000080AbV90P00000607IOZP0300000026J:T0QVRY00@0QVRY00<0000009=a
Z@2CLJT01@2CLJT00`000000WgVX09miZ00609miZ0030000002YP:P0ZH2X00D0ZH2X00<000000;:7
Z02bQjP01`2bQjP00`000000^hnX0;^?Z0060;^?Z00300000034UjT0a9NY00H0a9NY00<000000<fO
Z@3=WjT01`3=WjT00`000000eZVZ0=JYZP040=JYZP<000001`3XZHl00`000000m;N90?BgR@020?Bg
R@070000003na7d0o/Am0?k4O@000000`Wd00000000T0?ooo`00?03oool00`000000001700000003
0000L00300000015B;00ADR`00H0ADR`00<00000065G/01QEk00201QEk000`000000MV:^07IR[P09
07IR[P0300000026K:d0QVb]0080QVb]0`00000708ao`@070000000K2gh06`]n01/;OP000000AbV9
00000002069BZP030000001fGjX0MUnZ00<0MUnZ00<0000008IXZ@26J:T01026J:T00`000000Tg6Y
09=aZ@0509=aZ@030000002ONJP0WgVX00H0WgVX00<000000:V0Z02YP:P01@2YP:P00`000000/XNX
0;:7Z0070;:7Z0030000002kSjP0^hnX00H0^hnX00<000000<BGZ@34UjT01P34UjT00`000000cInY
0<fOZ@070<fOZ@030000003FZJX0eZVZ00H0eZVZ00<000000>RYS`3XZHl01@3XZHl00`000000m;N9
0?BgR@020?BgR@040000003na7d0o/Am0?k4O@<00000903oool003`0oooo00<000000000A`000000
0P0007000`0000007S>]0000000804E8/0030000001QEk00HEN`00P0HEN`00<0000007IR[P1fHZh0
2@1fHZh010000000QVb]00000000000:08ao`@8000000P0K2gh2000000<0HU:Z00<0000007IOZP1f
GjX0101fGjX00`000000QVRY08IXZ@0408IXZ@030000002CLJT0Tg6Y00@0Tg6Y00<0000009miZ02O
NJP01P2ONJP00`000000ZH2X0:V0Z0050:V0Z0030000002bQjP0/XNX00L0/XNX00<000000;^?Z02k
SjP01P2kSjP00`000000a9NY0<BGZ@060<BGZ@030000003=WjT0cInY00H0cInY00<000000=JYZP3F
ZJX01`3FZJX3000000@0j:V?00<000000?BgR@3d]hT00`3d]hT00`000000o/Am0?k4O@020?k4O@80
0000903oool003`0oooo00<000000000A`0000000P0007000`0000007S>]0000000804E8/0030000
001QEk00HEN`00P0HEN`00<0000007IR[P1fHZh02@1fHZh2000000d0S7o100@0000001/;OP0K2gh0
0000101RDZX00`000000MUnZ07IOZP0407IOZP0300000026J:T0QVRY00@0QVRY00<0000009=aZ@2C
LJT0102CLJT00`000000WgVX09miZ00609miZ0030000002YP:P0ZH2X00D0ZH2X00<000000;:7Z02b
QjP01P2bQjP00`000000^hnX0;^?Z0070;^?Z00300000034UjT0a9NY00H0a9NY00<000000<fOZ@3=
WjT01P3=WjT00`000000eZVZ0=JYZP060=JYZP050000003O]:/0gkB[0=ndZ`0000000`3XZHl00`00
0000m;N90?BgR@030?BgR@030000003na7d0o/Am0080o/Am0P00000T0?ooo`00?03oool00`000000
0017000000020000L0040000000N<jd07S>]000000P0ADR`00<00000065G/01QEk001`1QEk000`00
0000MV:^07IR[P0707IR[P<000003P2<Ol40100000006`]n000000000005069BZP030000001fGjX0
MUnZ00<0MUnZ00<0000008IXZ@26J:T01026J:T00`000000Tg6Y09=aZ@0509=aZ@030000002ONJP0
WgVX00D0WgVX00<000000:V0Z02YP:P01@2YP:P00`000000/XNX0;:7Z0060;:7Z0030000002kSjP0
^hnX00L0^hnX00<000000<BGZ@34UjT01P34UjT00`000000cInY0<fOZ@060<fOZ@030000003FZJX0
eZVZ00H0eZVZ00<000000=ndZ`3O]:/00P3O]:/010000000j:V?0>RYS`0000050?BgR@030000003n
a7d0o/Am0080o/Am0P00000T0?ooo`00?@3oool2000000030000L00000007S>]00807S>]00<00000
04E8/015B;001P15B;000`000000HEN`065G/008065G/0030000001fHZh0MV:^00@0MV:^0P000003
07mj``030000002<Ol40S7o100/0S7o10P00000204E2Z@030000001RDZX0HU:Z0080HU:Z00<00000
07IOZP1fGjX00`1fGjX00`000000QVRY08IXZ@0408IXZ@030000002CLJT0Tg6Y00D0Tg6Y00<00000
09miZ02ONJP01@2ONJP00`000000ZH2X0:V0Z0050:V0Z0030000002bQjP0/XNX00H0/XNX00<00000
0;^?Z02kSjP01`2kSjP00`000000a9NY0<BGZ@050<BGZ@030000003=WjT0cInY00L0cInY00<00000
0=JYZP3FZJX01P3FZJX00`000000gkB[0=ndZ`030=ndZ`<000001@3d]hT00`000000o/Am0?k4O@02
0?k4O@800000903oool003d0oooo0P0000000`000700000001hc[@0301hc[@0300000015B;00ADR`
00H0ADR`00<00000065G/01QEk001`1QEk000`000000MV:^07IR[P0307IR[P030000001oN/<0Og[3
00<0Og[300<0000008ao`@2<Ol40302<Ol4010000000AD:Y04E2Z@000004069BZP030000001fGjX0
MUnZ00@0MUnZ00<0000008IXZ@26J:T00`26J:T00`000000Tg6Y09=aZ@0509=aZ@030000002ONJP0
WgVX00D0WgVX00<000000:V0Z02YP:P01@2YP:P00`000000/XNX0;:7Z0060;:7Z0030000002kSjP0
^hnX00H0^hnX00<000000<BGZ@34UjT01P34UjT00`000000cInY0<fOZ@060<fOZ@030000003FZJX0
eZVZ00H0eZVZ00<000000=ndZ`3O]:/01P3O]:/00`000000m;N90?BgR@030?BgR@070000003na7d0
o/Am0?k4O@000000nl]S0000000T0?ooo`00?@3oool01000000000170000L000000401hc[@030000
0015B;00ADR`00H0ADR`00<00000065G/01QEk001`1QEk0010000000MV:^07IR[P1fHZh2000000L0
Og[300<0000008ao`@2<Ol402`2<Ol4010000000AD:Y04E2Z@000005069BZP030000001fGjX0MUnZ
00<0MUnZ00<0000008IXZ@26J:T01026J:T00`000000Tg6Y09=aZ@0309=aZAd000001P2kSjP00`00
0000a9NY0<BGZ@060<BGZ@030000003=WjT0cInY00H0cInY00<000000=JYZP3FZJX01P3FZJX00`00
0000gkB[0=ndZ`060=ndZ`800000103d]hT01`000000o/Am0?k4O@3na7d000000?_;H`000000903o
ool003d0oooo00<000000000A`0000001P0N<jd00`000000ADR`04E8/00504E8/0030000001QEk00
HEN`00P0HEN`0`00000907mj``030000002<Ol40S7o100/0S7o100D0000004E2Z@15@ZT0AD:Y0000
0004069BZP030000001fGjX0MUnZ00<0MUnZ00<0000008IXZ@26J:T01026J:T00`000000Tg6Y0000
00030000000309N1^P000000X8Ni00H0X8Ni00<000000:R=^02XSKP01@2XSKP00`000000/9>h0;2C
^0060;2C^0030000002hVKP0^9Vh00@000000P2kSjP00`000000a9NY0<BGZ@060<BGZ@030000003=
WjT0cInY00H0cInY00<000000=JYZP3FZJX01P3FZJX00`000000gkB[0=ndZ`050=ndZ`040000003Z
`Z`0j/:/00000080m;N900<000000?k4O@3na7d00P3na7d010000000nl]S0?_;H`00000S0?ooo`00
?@3oool00`00000000170000000601hc[@0300000015B;00ADR`00H0ADR`00<00000065G/01QEk00
1`1QEk000`000000Og[307mj``0:07mj``030000002<Ol40S7o100/0S7o100@0000004E2Z@15@ZT0
0000101RDZX00`000000MUnZ07IOZP0307IOZP0300000026J:T0QVRY00<0QVRY0`00000509N1^P03
0000002PQkT0X8Ni00D0X8Ni00<000000:R=^02XSKP01@2XSKP00`000000/9>h0;2C^0060;2C^003
0000002hVKP0^9Vh00@0^9Vh100000060<BGZ@030000003=WjT0cInY00L0cInY00<000000=JYZP3F
ZJX01@3FZJX00`000000gkB[0=ndZ`060=ndZ`040000003Z`Z`0j/:/00000080m;N900<000000?k4
O@3na7d00P3na7d010000000nl]S0?_;H`00000S0?ooo`00?P3oool00`0004L000000000000601hc
[@0300000015B;00ADR`00D0ADR`00<00000065G/01QEk001P1QEk000`000000L7C70000000;07mj
``030000002<Ol40S7o100/0S7o100@0000004E2Z@15@ZT000001@1RDZX00`000000MUnZ07IOZP03
07IOZP0300000026J:T000000080000000<0S7^l0000002GPKX01@2GPKX00`000000X8Ni0:27^@05
0:27^@030000002XSKP0Z8fh00D0Z8fh00<000000;2C^02`TkP01P2`TkP00`000000^9Vh0;RI^006
0;RI^0030000002oWkT0000000<000000P34UjT00`000000cInY0<fOZ@060<fOZ@030000003FZJX0
eZVZ00H0eZVZ00<000000=ndZ`3O]:/01@3O]:/00`000000j/:/0>[2[0020>[2[0030000003d]hT0
000000@0o/Am00@000000?_;H`3kbf<000008`3oool003h0oooo0`00000601hc[@0300000015B;00
ADR`00H0ADR`00<00000065G/01QEk00101QEk0010000000L7C7071da`00000<07mj``030000002<
Ol40S7o100X0S7o100D0000004E2Z@15@ZT0AD:Y00000004069BZP030000001fGjX0MUnZ00<0MUnZ
0P00000508ak_0030000002GPKX0Uh6j00@0Uh6j00<000000:27^@2PQkT0102PQkT00`000000Z8fh
0:R=^0050:R=^0030000002`TkP0/9>h00D0/9>h00<000000;RI^02hVKP01P2hVKP00`000000_ini
0;nO^@040;nO^@<00000203=WjT00`000000eZVZ0=JYZP060=JYZP030000003O]:/0gkB[00D0gkB[
00<000000>[2[03Z`Z`00`3Z`Z`2000000@0o/Am00@000000?_;H`3kbf<000008`3oool003h0oooo
0P0000000`005Z40000001hc[@0501hc[@0300000015B;00ADR`00D0ADR`00<00000065G/01QEk00
0`1QEk000`000000L7C7071da`02071da`030000001oN/<0Og[300T0Og[300<0000008ao`@2<Ol40
2`2<Ol4010000000AD:Y04E2Z@000004069BZP040000001fGjX0MUnZ07IOZP<000001P2<Nk`00`00
0000Uh6j09N1^P0409N1^P030000002PQkT0X8Ni00@0X8Ni00<000000:R=^02XSKP01@2XSKP00`00
0000/9>h0;2C^0050;2C^0030000002hVKP0^9Vh00H0^9Vh00<000000;nO^@2oWkT01P2oWkT30000
00H0cInY00<000000=JYZP3FZJX01@3FZJX00`000000gkB[0=ndZ`060=ndZ`030000003Z`Z`0j/:/
00@0j/:/00<000000?k4O@3na7d00P3na7d010000000nl]S0?_;H`00000S0?ooo`00?P3oool20000
0003000FX@0000007S>]00D07S>]00<0000004E8/015B;001P15B;001@000000HEN`065G/01QEk00
000000D0L7C700<0000007mj``1oN/<02P1oN/<00`000000S7o108ao`@0:08ao`@0500000015@ZT0
AD:Y04E2Z@000000101RDZX3000000<0OgFn00<0000008ak_02<Nk`00`2<Nk`00`000000Uh6j09N1
^P0409N1^P030000002PQkT0X8Ni00@0X8Ni00<000000:R=^02XSKP01@2XSKP00`000000/9>h0;2C
^0050;2C^0030000002hVKP0^9Vh00H0^9Vh00<000000;nO^@2oWkT01@2oWkT010000000aZNj0<JW
^P36YkX2000000@0cInY00<000000=JYZP3FZJX01@3FZJX00`000000gkB[0=ndZ`050=ndZ`030000
003Z`Z`0j/:/00D0j/:/0P0000030?k4O@040000003kbf<00000000002<0oooo000n0?ooo`800000
0P005Z400`0000007S>]01hc[@0401hc[@0300000015B;00ADR`00D0ADR`00@00000065G/01QEk00
00001`1`M<L00`000000Og[307mj``0907mj``030000002<Ol40S7o100/0S7o100@0000004E2Z@15
@ZT00000101RDZX00`000000OgFn07me_P0307me_P030000002<Nk`0S7^l00<0S7^l00<0000009N1
^P2GPKX0102GPKX00`000000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00D0Z8fh00<000000;2C
^02`TkP01@2`TkP00`000000^9Vh0;RI^0060;RI^0030000002oWkT0_ini00D0_ini00<000000<JW
^P36YkX00`36YkX2000000030<fOZ@000000eZVZ00L0eZVZ00<000000=ndZ`3O]:/01@3O]:/00`00
0000j/:/0>[2[0040>[2[0030000003ddJ/000000080o/Am00<000000?_;H`3kbf<00P00000S0?oo
o`00?P3oool20000008001JQ00<0000001hc[@0N<jd0100N<jd00`000000ADR`04E8/00604E8/003
065G/0000000L7C700L0L7C700<0000007mj``1oN/<02P1oN/<00`000000S7o108ao`@0:08ao`@04
00000015@ZT0AD:Y000000<0HU:Z0P00000507me_P030000002<Nk`0S7^l00@0S7^l00<0000009N1
^P2GPKX00`2GPKX00`000000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00D0Z8fh00<000000;2C
^02`TkP01@2`TkP00`000000^9Vh0;RI^0050;RI^0030000002oWkT0_ini00H0_ini00<000000<JW
^P36YkX01@36YkX2000000L0eZVZ00<000000=ndZ`3O]:/01@3O]:/00`000000j/:/0>[2[0050>[2
[0060000003ddJ/0m=6[0000003na7d000000P3kbf<2000002<0oooo000o0?ooo`05000000005Z40
01JQ000FX@0000001P0N<jd00`000000ADR`04E8/00504E8/0030000001`M<L0L7C700P0L7C700<0
000007mj``1oN/<02@1oN/<00`000000S7o108ao`@0:08ao`@0400000015@ZT0AD:Y04E2Z@<00000
0P1_K/400`000000OgFn07me_P0307me_P030000002<Nk`0S7^l00<0S7^l00<0000009N1^P2GPKX0
0`2GPKX00`000000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00D0Z8fh00<000000;2C^02`TkP0
1@2`TkP00`000000^9Vh0;RI^0050;RI^0030000002oWkT0_ini00D0_ini00<000000<JW^P36YkX0
1`36YkX3000000D0eZVZ00<000000=ndZ`3O]:/01@3O]:/00`000000j/:/0>[2[0040>[2[0030000
003ddJ/0m=6[0080m=6[0P0000020?_;H`8000008`3oool003l0oooo00<00000000FX@005Z400P00
5Z400`0000007S>]01hc[@0301hc[@0300000015B;00ADR`00@0ADR`00<0000005e]b`0000002P1`
M<L00`000000Og[307mj``0907mj``030000002<Ol40S7o100X0S7o100@0000004E2Z@15@ZT00000
101_K/400`000000OgFn07me_P0307me_P030000002<Nk`0S7^l00<0S7^l00<0000009N1^P2GPKX0
102GPKX00`000000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00@0Z8fh00<000000;2C^02`TkP0
102`TkP00`000000^9Vh0;RI^0060;RI^0030000002oWkT0_ini00D0_ini00<000000<JW^P36YkX0
1P36YkX010000000cJnk0<f_^`3=[k/2000000<0eZVZ00<000000=ndZ`3O]:/01@3O]:/00`000000
j/:/0>[2[0040>[2[0030000003ddJ/0m=6[0080m=6[0P0000020?_;H`8000008`3oool003l0oooo
00<00000000FX@005Z400P005Z400`0000007S>]01hc[@0401hc[@0300000015B;00ADR`00<0ADR`
00<0000005e]b`0000002P1`M<L00`000000Og[307mj``0907mj``030000002<Ol40S7o100X0S7o1
00@0000004E2Z@000000FfK41@1_K/400`000000OgFn07me_P0307me_P030000002<Nk`0S7^l00<0
S7^l00<0000009N1^P2GPKX00`2GPKX00`000000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00@0
Z8fh00<000000;2C^02`TkP0102`TkP00`000000^9Vh0;RI^0060;RI^0030000002oWkT0_ini00D0
_ini00<000000<JW^P36YkX01P36YkX00`000000cJnk0<f_^`030<f_^`<000001`3O]:/00`000000
j/:/0>[2[0050>[2[0030000003ddJ/0m=6[00<0m=6[00<000000?_;H`3kbf<00P00000S0?ooo`00
?`3oool2000000@001JQ00<0000001hc[@0N<jd00`0N<jd00`000000ADR`04E8/00204E8/0050000
001MKL/0GFg;05e]b`0000002P1`M<L00`000000Og[307mj``0907mj``030000002<Ol40S7o100T0
S7o10P00000205]Va0030000001_K/40Kfk10080Kfk100<0000007me_P1oMKh00`1oMKh00`000000
S7^l08ak_00308ak_0030000002GPKX0Uh6j00<0Uh6j00<000000:27^@2PQkT0102PQkT00`000000
Z8fh0:R=^0040:R=^0030000002`TkP0/9>h00@0/9>h00<000000;RI^02hVKP01@2hVKP00`000000
_ini0;nO^@060;nO^@0300000036YkX0aZNj00D0aZNj00<000000<f_^`3=[k/01P3=[k/00`000000
gkB[0=ndZ`050=ndZ`030000003Z`Z`0j/:/00@0j/:/00<000000?CAZ`3ddJ/0103ddJ/00`000000
nl]S0?_;H`02000002<0oooo00100?ooo`03000000005Z4001JQ008001JQ00<0000001hc[@0N<jd0
100N<jd010000000ADR`04E8/000000505e]b`030000001`M<L0L7C700L0L7C700<0000007mj``1o
N/<02@1oN/<00`000000S7o108ao`@0:08ao`@050000001KI/@0FfK405]Va0000000101_K/400`00
0000OgFn07me_P0207me_P030000002<Nk`0S7^l00<0S7^l00<0000009N1^P2GPKX00`2GPKX00`00
0000X8Ni0:27^@040:27^@030000002XSKP0Z8fh00@0Z8fh00<000000;2C^02`TkP0102`TkP00`00
0000^9Vh0;RI^0050;RI^0030000002oWkT0_ini00D0_ini00<000000<JW^P36YkX01P36YkX00`00
0000cJnk0<f_^`050<f_^`030000003E^Kh0000000H0gkB[00<000000>[2[03Z`Z`0103Z`Z`00`00
0000m=6[0?CAZ`030?CAZ`050000003khJL000000?_;H`000000903oool00400oooo0P000004000F
X@030000000N<jd07S>]00<07S>]00<0000004E8/00000001P1MKL/00`000000L7C7071da`08071d
a`030000001oN/<0Og[300T0Og[300<0000008ao`@2<Ol402@2<Ol401@000000FfK405]Va01KI/@0
000000@0Kfk100<0000007me_P1oMKh00`1oMKh00`000000S7^l08ak_00308ak_0030000002GPKX0
Uh6j0080Uh6j00<000000:27^@2PQkT0102PQkT00`000000Z8fh0:R=^0040:R=^0030000002`TkP0
/9>h00@0/9>h00<000000;RI^02hVKP01@2hVKP00`000000_ini0;nO^@050;nO^@0300000036YkX0
aZNj00D0aZNj00<000000<f_^`3=[k/01P3=[k/010000000eKVn0=Fi_P0000040=ndZ`030000003Z
`Z`0j/:/00@0j/:/00<000000?CAZ`3ddJ/0103ddJ/00`000000nn6W00000002000002@0oooo0010
0?ooo`80000010005Z400`0000007S>]01hc[@0401hc[@0304E8/0000000GFg;00H0GFg;00<00000
071da`1`M<L01`1`M<L00`000000Og[307mj``0907mj``030000002<Ol40S7o100T0S7o100<00000
05]Va01KI/@00P1KI/@00`000000Kfk106m^`@0206m^`@030000001oMKh0OgFn0080OgFn00<00000
08ak_02<Nk`00`2<Nk`00`000000Uh6j09N1^P0209N1^P030000002PQkT0X8Ni00@0X8Ni00<00000
0:R=^02XSKP0102XSKP00`000000/9>h0;2C^0040;2C^0030000002hVKP0^9Vh00D0^9Vh00<00000
0;nO^@2oWkT01@2oWkT00`000000aZNj0<JW^P050<JW^P030000003=[k/0cJnk00D0cJnk00<00000
0=Fi_P3E^Kh00P3E^Kh200000080gkB[00<000000>[2[03Z`Z`0103Z`Z`00`000000m=6[0?CAZ`03
0?CAZ`030000003khJL0nn6W00<00000903oool00440oooo0P000004000FX@030000000N<jd07S>]
00<07S>]00<0000005e]b`1MKL/01`1MKL/00`000000L7C7071da`07071da`030000001oN/<0Og[3
00T0Og[300<0000008ao`@2<Ol402@2<Ol400`000000FfK405]Va00205]Va0050000001_K/40Kfk1
06m^`@000000101oMKh00`000000S7^l08ak_00308ak_0030000002GPKX0Uh6j00<0Uh6j00<00000
0:27^@2PQkT00`2PQkT00`000000Z8fh0:R=^0040:R=^0030000002`TkP0/9>h00@0/9>h00<00000
0;RI^02hVKP0102hVKP00`000000_ini0;nO^@050;nO^@0300000036YkX0aZNj00D0aZNj00<00000
0<f_^`3=[k/01P3=[k/00`000000eKVn0=Fi_P040=Fi_P8000001P3Z`Z`00`000000m=6[0?CAZ`04
0?CAZ`030000003khJL0nn6W00<00000903oool00440oooo0P000005000FX@030000000N<jd07S>]
00807S>]0P00000905e]b`030000001`M<L0L7C700L0L7C700<0000007mj``1oN/<0201oN/<00`00
0000S7o108ao`@0908ao`@8000000`1KI/@00`000000Kfk106m^`@0206m^`@030000001oMKh0OgFn
0080OgFn00<0000008ak_02<Nk`00P2<Nk`00`000000Uh6j09N1^P0309N1^P030000002PQkT0X8Ni
00<0X8Ni00<000000:R=^02XSKP0102XSKP00`000000/9>h0;2C^0030;2C^0030000002hVKP0^9Vh
00D0^9Vh00<000000;nO^@2oWkT01@2oWkT00`000000aZNj0<JW^P050<JW^P030000003=[k/0cJnk
00D0cJnk00<000000=Fi_P3E^Kh01P3E^Kh00`000000j/:/0>[2[0040>[2[0030000003ddJ/0m=6[
00<0m=6[00<000000?_QY`3khJL00P3khJL2000002@0oooo00120?ooo`80000010005Z401@000000
7S>]01hc[@0N<jd000000080AFG>00<0000005e]b`1MKL/01P1MKL/00`000000L7C7071da`07071d
a`030000001oN/<0Og[300T0Og[300<0000008ao`@2<Ol40202<Ol400`000000@5_70000000305]V
a0050000001_K/40Kfk106m^`@000000101oMKh00`000000S7^l08ak_00308ak_0030000002GPKX0
Uh6j00`000000`2XSKP00`000000/9>h0;2C^0030;2C^0030000002hVKP0^9Vh00D0^9Vh00<00000
0;nO^@2oWkT01@2oWkT00`000000aZNj0<JW^P050<JW^P030000003=[k/0cJnk00D0cJnk00<00000
0=Fi_P3E^Kh01@3E^Kh00`000000g<?1000000050>[2[0030000003ddJ/0m=6[00<0m=6[00<00000
0?_QY`3khJL00P3khJL2000002@0oooo00120?ooo`030000000008@0000000@001JQ00@0000001hc
[@0N<jd000000P15ILh00`000000GFg;05e]b`0705e]b`030000001`M<L0L7C700L0L7C700<00000
07mj``1oN/<0201oN/<00`000000S7o108ao`@0908ao`@800000101KI/@01@000000Kfk106m^`@1_
K/40000000@0OgFn00<0000008ak_02<Nk`01@00000209B>b`030000002LT/T0W9;900<0W9;900@0
00000:>Fa`2SU/L0XiK71P0000030;2C^0030000002hVKP0^9Vh00D0^9Vh00<000000;nO^@2oWkT0
102oWkT00`000000aZNj0<JW^P050<JW^P030000003=[k/0cJnk00D0cJnk00<000000=Fi_P3E^Kh0
1P3E^Kh010000000g<?10=c3`@0000030>[2[0030000003ddJ/0m=6[00<0m=6[00<000000?_QY`3k
hJL00P3khJL3000002@0oooo00120?ooo`<0000010005Z40100000007S>]01hc[@00000304EUcP03
0000001MKL/0GFg;00L0GFg;00<00000071da`1`M<L01P1`M<L00`000000Og[307mj``0907mj``03
0000002<Ol40S7o100L0S7o10P0000000`10FlL0000005]Va00205]Va0050000001_K/40Kfk106m^
`@000000101oMKh300000080Rh_>00<0000009B>b`2DS//00`2DS//509bBb@030000002SU/L0XiK7
00@0XiK700<000000:ZJaP2ZV/H01`0000030;RI^0030000002oWkT0_ini00D0_ini00<000000<JW
^P36YkX01@36YkX00`000000cJnk0<f_^`050<f_^`030000003E^Kh0eKVn00D0eKVn00<000000=c3
`@3L`l400P3L`l4010000000j/:/0>[2[00000050?CAZ`030000003khJL0nn6W0080nn6W0`00000T
0?ooo`00@`3oool00`000000002400000004000FX@030000000N<jd0000000@0AFG>00<0000005e]
b`1MKL/01P1MKL/00`000000L7C7071da`07071da`030000001oN/<0Og[300P0Og[300<0000008ao
`@2<Ol40102<Ol430000000508^@d`000000@5_7041Ka`0000000`1KI/@01P000000Kfk106m^`@1_
K/40000007me_P80000000<0P8OA08^;cP2;Rlh00`2;Rlh00`000000U8k;09B>b`0209B>b`030000
002LT/T0W9;90080W9;900<000000:>Fa`2SU/L0102SU/L00`000000ZY[60:ZJaP030:ZJaP040000
002`WlH0/9o60;2OaPD000001P2oWkT00`000000aZNj0<JW^P040<JW^P030000003=[k/0cJnk00D0
cJnk00<000000=Fi_P3E^Kh01@3E^Kh00`000000g<?10=c3`@040=c3`@030000003Z`Z`0m=6[00@0
m=6[00<000000?_QY`3khJL00P3khJL00`000000mnfK0000000U0?ooo`00@`3oool3000000@001JQ
0P00000604EUcP030000001MKL/0GFg;00H0GFg;00<00000071da`1`M<L01`1`M<L00`000000Og[3
07mj``0807mj``80S7o11000000508^@d`0400000010FlL0@5_700000080FfK400<0000006m^`@1_
K/400`0000030827d@030000002;Rlh0Rh_>0080Rh_>00<0000009B>b`2DS//00P2DS//00`000000
W9;909bBb@0209bBb@030000002SU/L0XiK700@0XiK700<000000:ZJaP2ZV/H00`2ZV/H00`000000
/9o60;2OaP040;2OaP040000002gY<H00000000000@0_ini00<000000<JW^P36YkX01036YkX00`00
0000cJnk0<f_^`040<f_^`030000003E^Kh0eKVn00H0eKVn00<000000=c3`@3L`l401@3L`l400`00
0000m=6[0?CAZ`030?CAZ`030000003khJL0nn6W0080nn6W00<000000?O]V`0000009@3oool004@0
oooo00<000000000Q000000010005Z400`000000AFG>04EUcP0504EUcP030000001MKL/0GFg;00H0
GFg;00<00000071da`1`M<L01P1`M<L00`000000Og[307mj``0807mj``8000002@2;T=<200000003
041Ka`000000FfK40080FfK40P00000207>4e@D0P8OA00D0000008^;cP2;Rlh0Rh_>0000000409B>
b`030000002LT/T0W9;900<0W9;900<000000:>Fa`2SU/L00`2SU/L00`000000ZY[60:ZJaP020:ZJ
aP030000002`WlH0/9o600@0/9o600<000000;NTaP2gY<H00P2gY<H2000000030;nO^@000000aZNj
00D0aZNj00<000000<f_^`3=[k/01@3=[k/00`000000eKVn0=Fi_P050=Fi_P030000003L`l40g<?1
00D0g<?10P0000040?CAZ`030000003khJL0nn6W0080nn6W00@000000?O]V`3gkI/000009@3oool0
04@0oooo0P0000000`0008@00000000FX@02000FX@8000001P15ILh00`000000GFg;05e]b`0605e]
b`030000001`M<L0L7C700L0L7C700<0000007mj``1oN/<01@1oN/<200000003086>e`000000Ri3C
00T0Ri3C0P0000001@10FlL0000005]Va0000000I83J00<0LhCE00<000000827d@20Qm400P20Qm40
0`000000Rh_>08^;cP0208^;cP030000002DS//0U8k;0080U8k;00<0000009bBb@2LT/T00P2LT/T0
0`000000XiK70:>Fa`030:>Fa`030000002ZV/H0ZY[60080ZY[600<000000;2OaP2`WlH0102`WlH0
0`000000]jC60;NTaP040;NTaP<000001@36YkX00`000000cJnk0<f_^`040<f_^`030000003E^Kh0
eKVn00D0eKVn00<000000=c3`@3L`l401@3L`l4010000000hm340>?@a00000030?CAZ`030000003k
hJL0nn6W0080nn6W00@000000?O]V`3gkI/000009@3oool004D0oooo00<000000000Q00000000`00
5Z400`00000095W?0000000604EUcP030000001MKL/0GFg;00H0GFg;00<00000071da`1`M<L01P1`
M<L00`000000Og[307mj``0407mj``0500000021S]L0PHkG086>e`0000002P2;T=<200000080@5_7
00@0000006B0fP1TP=X0I83J0`1cQ=D00`000000P8OA0827d@020827d@050000002;Rlh0Rh_>08^;
cP000000102DS//00`000000W9;909bBb@0209bBb@030000002SU/L0XiK700<0XiK700<000000:ZJ
aP2ZV/H00P2ZV/H00`000000/9o60;2OaP040;2OaP030000002gY<H0]jC600@0]jC600<000000;bZ
a`2lZ/L00`0000000`36YkX000000<f_^`060<f_^`030000003E^Kh0eKVn00D0eKVn00<000000=c3
`@3L`l401@3L`l4010000000hm340>?@a00000020?CAZ`030000003khJL0nn6W0080nn6W00D00000
0?O]V`3gkI/0mnfK0000000U0?ooo`00A@3oool2000000050000Q000000001JQ000FX@0000000P0T
FLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;00H0GFg;00<00000071da`1`M<L01P1`
M<L010000000Og[307mj``1oN/<2000000D0PHkG00<0000008^@d`2;T=<0202;T=<300000003051l
gP000000I83J0080I83J0`1cQ=D01@000000P8OA0827d@20Qm40000000@0Rh_>00D0000009B>b`2D
S//0U8k;0000000409bBb@030000002SU/L0XiK700<0XiK700<000000:ZJaP2ZV/H00P2ZV/H00`00
0000/9o60;2OaP030;2OaP030000002gY<H0]jC600D0]jC600<000000;bZa`2lZ/L00`2lZ/L20000
00H0cJnk00<000000=Fi_P3E^Kh01@3E^Kh00`000000g<?10=c3`@050=c3`@030000003Sd<@0hm34
0080hm3400<000000?CAZ`000000103khJL00`000000mnfK0?O]V`02000002D0oooo00160?ooo`05
0000000008@00000000FX@000000100TFLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;
00H0GFg;00<00000071da`1`M<L01@1`M<L010000000Og[3000000000008086>e`030000002;T=<0
Ri3C00L0Ri3C00<0000001]<aP0000000P1@O=h010000000I83J06B0fP00000307>4e@0500000020
Qm40P8OA0827d@0000000`2;Rlh01@000000U8k;09B>b`2DS//0000000@0W9;900<000000:>Fa`2S
U/L00`2SU/L00`000000ZY[60:ZJaP020:ZJaP030000002`WlH0/9o600<0/9o600<000000;NTaP2g
Y<H0102gY<H00`000000_:[70;bZa`040;bZa`0300000032/<T0000000D0cJnk00<000000=Fi_P3E
^Kh01@3E^Kh00`000000g<?10=c3`@040=c3`@030000003Sd<@0hm3400<0hm3400<000000?CAZ`3k
hJL00`3khJL01@000000mnfK0?O]V`3gkI/0000002H0oooo00170?ooo`040000000008@000000000
00@095W?00<0000004EUcP15ILh01@15ILh00`000000GFg;05e]b`0505e]b`030000001`M<L0L7C7
00H0L7C700<00000086>e`21S]L02021S]L00`000000Ri3C08^@d`0808^@d`030000000gMn400000
0080D7cN00@0000006B0fP1TP=X000000P1cQ=D01@000000P8OA0827d@20Qm40000000<0Rh_>00<0
000009B>b`2DS//00P2DS//01@000000W9;909bBb@2LT/T0000000@0XiK700<000000:ZJaP2ZV/H0
0`2ZV/H00`000000/9o60;2OaP030;2OaP030000002gY<H0]jC600@0]jC600<000000;bZa`2lZ/L0
102lZ/L00`000000`[390<:`b@0200000080cJnk00<000000=Fi_P3E^Kh01@3E^Kh00`000000g<?1
0=c3`@040=c3`@030000003Sd<@0hm3400D0hm3400<000000?_QY`3khJL00P3khJL00`000000mnfK
0?O]V`02000002H0oooo00170?ooo`040000000008@00000000000D095W?00<0000004EUcP15ILh0
1@15ILh00`000000GFg;05e]b`0505e]b`030000001`M<L0L7C700<0L7C70P0000000`1eRm/00000
086>e`09086>e`030000002;T=<0Ri3C00L0Ri3C00@0000003Mgh@0gMn4000000P1@O=h010000000
I83J06B0fP00000207>4e@0500000020Qm40P8OA0827d@0000000`2;Rlh01@000000U8k;09B>b`2D
S//0000000<0W9;900<000000:>Fa`2SU/L00P2SU/L00`000000ZY[60:ZJaP020:ZJaP030000002`
WlH0/9o600<0/9o600<000000;NTaP2gY<H0102gY<H00`000000_:[70;bZa`040;bZa`0300000032
/<T0`[3900<0`[3900<000000<f_^`0000001P3E^Kh00`000000g<?10=c3`@040=c3`@030000003S
d<@0hm3400D0hm340P0000030?_QY`040000003gkI/0mnfK0?O]V`8000009P3oool004P0oooo00<0
00000000Q00000001P0TFLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;00H0GFg;00D0
0000071da`1`M<L0L7C70000000407F;f`0300000021S]L0PHkG00P0PHkG00<0000008^@d`2;T=<0
1`2;T=<00`000000=gOQ03Mgh@0200000005051lgP000000I83J06B0fP0000000P1cQ=D010000000
P8OA0827d@00000308^;cP050000002DS//0U8k;09B>b`0000000`2LT/T00`000000XiK70:>Fa`02
0:>Fa`030000002ZV/H0ZY[60080ZY[600<000000;2OaP2`WlH00`2`WlH00`000000]jC60;NTaP03
0;NTaP030000002lZ/L0_:[700@0_:[700<000000<:`b@32/<T01@32/<T00`000000eKVn0=Fi_P05
0=Fi_P030000003L`l40g<?100<0g<?100<000000>?@a03Sd<@01@3Sd<@010000000jMk70>WNa`00
00020?_QY`030000003gkI/0mnfK008000009`3oool004P0oooo00@000000000Q000000000001P0T
FLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;00D0GFg;00@00000071da`0000000000
1P1eRm/00`000000PHkG086>e`07086>e`030000002;T=<0Ri3C00L0Ri3C00<0000001Q`h0000000
0P0gMn4020000000D7cN000000000000I83J0000001cQ=D000000`20Qm4010000000Rh_>08^;cP00
000409B>b`040000002LT/T0W9;9000000@0XiK700<000000:ZJaP2ZV/H00P2ZV/H00`000000/9o6
0;2OaP030;2OaP030000002gY<H0]jC600<0]jC600<000000;bZa`2lZ/L0102lZ/L00`000000`[39
0<:`b@040<:`b@0300000037]l/0000000D0eKVn00<000000=c3`@3L`l40103L`l400`000000hm34
0>?@a0040>?@a0070000003Yg/L0jMk70>WNa`000000nn6W000000030?O]V`8000009`3oool004T0
oooo00@000000000Q000000000001P0TFLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;
00D0GFg;00<0000007F;f`1eRm/01`1eRm/00`000000PHkG086>e`07086>e`030000002;T=<0Ri3C
00L0Ri3C00<0000001Q`h00000000P0gMn4020000000D7cN051lgP000000I83J0000001cQ=D00000
0P20Qm401@000000Rh_>08^;cP2;Rlh0000000<0U8k;00D0000009bBb@2LT/T0W9;9000000030:>F
a`030000002ZV/H0ZY[60080ZY[600<000000;2OaP2`WlH00`2`WlH00`000000]jC60;NTaP020;NT
aP030000002lZ/L0_:[700@0_:[700<000000<:`b@32/<T01032/<T010000000akO;0<Ngb`37]l/2
00000080eKVn00<000000=c3`@3L`l40103L`l400`000000hm340>?@a0050>?@a0070000003Yg/L0
jMk70>WNa`000000nn6W000000020?O]V`800000:03oool004X0oooo00@0002400000000BLT00000
1P0TFLl00`000000AFG>04EUcP0404EUcP030000001MKL/0GFg;00<0GFg;00<0000006N9h0000000
2@1eRm/00`000000PHkG086>e`07086>e`030000002;T=<0Ri3C00H0Ri3C0`000000100HL>000000
03Mgh@000002051lgP8000000P1cQ=D010000000P8OA0827d@00000208^;cP050000002DS//0U8k;
09B>b`0000000`2LT/T01@000000XiK70:>Fa`2SU/L0000000@0ZY[600<000000;2OaP2`WlH00P2`
WlH00`000000]jC60;NTaP030;NTaP030000002lZ/L0_:[700<0_:[700<000000<:`b@32/<T01032
/<T00`000000akO;0<Ngb`040<Ngb`030000003E^Kh0000000D0g<?100<000000>?@a03Sd<@01@3S
d<@00`000000jMk70>WNa`030>WNa`040000003gkI/0mnfK0?O]V`800000:03oool004X0oooo0P00
00020019b@030000000TFLl095W?00@095W?00<0000004EUcP15ILh01015ILh01@000000GFg;05e]
b`1MKL/0000000<0IhWP00<0000007F;f`1eRm/01P1eRm/00`000000PHkG086>e`07086>e`030000
002;T=<0Ri3C00L0Ri3C1@000000100gMn400000051lgP1@O=h200000080LhCE00<000000827d@00
00000`2;Rlh010000000U8k;09B>b`00000309bBb@050000002SU/L0XiK70:>Fa`000000102ZV/H0
0`000000/9o60;2OaP020;2OaP030000002gY<H0]jC60080]jC600<000000;bZa`2lZ/L0102lZ/L0
0`000000`[390<:`b@030<:`b@0300000037]l/0akO;00H0akO;00<000000=c3`@3L`l400`3L`l40
0`000000hm340>?@a0050>?@a0030000003Yg/L0jMk700@0jMk700<000000?O]V`3gkI/00P00000Y
0?ooo`00B`3oool01@00000004W90019b@00BLT0000000H095W?00<0000004EUcP15ILh00`15ILh0
1@000000GFg;05e]b`1MKL/0000000@0IhWP00<0000007F;f`1eRm/01P1eRm/00`000000PHkG086>
e`07086>e`030000002;T=<0Ri3C00H0Ri3C00<000000?ooo`3oool01P0000001@1@O=h000000000
001cQ=D000000080P8OA1@00000209B>b`040000002LT/T0W9;9000000<0XiK700D000000:ZJaP2Z
V/H0ZY[6000000050;2OaP030000002gY<H0]jC60080]jC600<000000;bZa`2lZ/L00`2lZ/L00`00
0000`[390<:`b@040<:`b@0300000037]l/0akO;00D0akO;00<000000<bocP0000000`3L`l400`00
0000hm340>?@a0050>?@a0030000003Yg/L0jMk700@0jMk70P0000020?O]V`800000:@3oool004/0
oooo0P0000030019b@030000000TFLl095W?00@095W?00<0000004EUcP15ILh00`15ILh00`000000
GFg;0000000606N9h0030000001eRm/0MH_K00H0MH_K00<00000086>e`21S]L01`21S]L00`000000
Ri3C08^@d`0608^@d`040000003oool0oooo0?ooo`<0000000<0=gOQ0000001@O=h01@0000001@1Y
T>D0MY;Q07JBh@000000PI?L00L000000P2SU/L01@000000ZY[60:ZJaP2ZV/H0000000@0/9o600<0
00000;NTaP2gY<H00P2gY<H00`000000_:[70;bZa`030;bZa`0300000032/<T0`[3900@0`[3900<0
00000<Ngb`37]l/01@37]l/010000000c;o>0<bocP0000030=c3`@030000003Sd<@0hm3400@0hm34
00<000000>WNa`3Yg/L0103Yg/L010000000k>g:0000003gkI/2000002X0oooo001<0?ooo`030000
0000BLT004W9008004W900<0000002AIc`0TFLl0100TFLl00`000000AFG>04EUcP0304EUcP030000
001WRN00IhWP00H0IhWP00<0000007F;f`1eRm/01P1eRm/00`000000PHkG086>e`06086>e`030000
002;T=<0Ri3C00H0Ri3C00<000000?ooo`3oool00`3oool40000000403><kP000000000005Z?jP80
JI3U00@0000007JBh@1fT^4000000P21Tm`01@000000RYGH08ZEf0000000TYOF00@000000P2ZV/H0
0`000000/9o60;2OaP020;2OaP050000002gY<H0]jC60;NTaP0000001P2lZ/L00`000000`[390<:`
b@030<:`b@0300000037]l/0akO;00D0akO;00<000000<bocP3<_lh00P3<_lh00`000000g<?10000
00060>?@a0030000003Yg/L0jMk700@0jMk700D000000>c]bP3/kLX000000?O]V`02000002X0oooo
001=0?ooo`0300000000BLT004W9008004W900<0000002AIc`0TFLl00`0TFLl00`000000AFG>04EU
cP0304EUcP800000201WRN000`000000MH_K07F;f`0607F;f`0300000021S]L0PHkG00H0PHkG00<0
000008^@d`2;T=<01P2;T=<00`000000oooo0?ooo`040?ooo`80000000D078SY03><kP0cS>h00000
05Z?jP0206V@i@80MY;Q00@00000086Cg021Tm`0PI?L0P2:UMP010000000TYOF09:GeP2BUmH209VJ
d`<00000102`WlH01@000000]jC60;NTaP2gY<H0000000D0_:[700<000000<:`b@32/<T00`32/<T0
0`000000akO;0<Ngb`050<Ngb`030000003<_lh0c;o>00@0c;o>00<000000>?@a03Sd<@0103Sd<@0
0`000000jMk70>WNa`040>WNa`040000003/kLX0k>g:0>c]bP<00000:`3oool004d0oooo0P000004
0019b@800000100TFLl01@000000AFG>04EUcP15ILh000000080EXOU0P00000706N9h0030000001e
Rm/0MH_K00H0MH_K00<00000086>e`21S]L01P21S]L00`000000Ri3C08^@d`0508^@d`8000001`3o
ool20000000401b8j@0cS>h0000005Z?jP80JI3U0P1fT^400`000000PI?L086Cg00208ZEf0040000
002BUmH0TYOF09:GeP@0VI[C00D0X9gA000000000000/9o6000000030;NTaP030000002lZ/L0_:[7
00<0_:[700<000000<:`b@32/<T00`32/<T00`000000akO;0<Ngb`050<Ngb`030000003<_lh0c;o>
00@0c;o>00<000000=77d@000000103Sd<@00`000000jMk70>WNa`040>WNa`030000003/kLX0k>g:
0080k>g:0`00000[0?ooo`00CP3oool2000000D004W900<0000002AIc`0TFLl00P0TFLl010000000
AFG>04EUcP00000405J7i@030000001WRN00IhWP00D0IhWP00<0000007F;f`1eRm/01P1eRm/00`00
0000PHkG086>e`05086>e`030000002;T=<0Ri3C00H0Ri3C300000000`0LR>T0<hc^0000000206V@
i@80MY;Q0P21Tm`00`000000RYGH08ZEf00309:GeP<0VI[C00@000000:2Md@2PWM40X9gA0`000002
0;NTaP030000002lZ/L0_:[700<0_:[700<000000<:`b@32/<T00P32/<T00`000000akO;0<Ngb`05
0<Ngb`030000003<_lh0c;o>00<0c;o>0P0000020=77d@030000003Sd<@0hm340080hm3400<00000
0>WNa`3Yg/L00`3Yg/L00`000000k>g:0>c]bP030>c]bP800000;03oool004l0oooo0`0000040019
b@030000000TFLl095W?008095W?0P00000605J7i@030000001WRN00IhWP00D0IhWP00<0000007F;
f`1eRm/01P1eRm/00`000000PHkG086>e`05086>e`030000002;T=<0Ri3C00D0Ri3C00<000000;U^
N`2iKW/0102iKW/00`000000[fEk0:mUN`050:mUN`070000001YT>D0000007JBh@000000PI?L0000
000208ZEf0<0TYOF0`2IV]<01@000000X9gA0:2Md@2PWM4000000080YZ3@0P0000050;bZa`030000
0032/<T0`[390080`[3900<000000<Ngb`37]l/01@37]l/00`000000c;o>0<bocP030<bocP030000
003Aam40dLOA00<0dLOA00@000000>?@a03Sd<@000001@3Yg/L00`000000k>g:0>c]bP030>c]bP<0
0000;03oool004l0oooo00@00000000c]`00<kL000001000BLT00`00000095W?02AIc`0202AIc`03
0000001FQnD0EXOU00D0EXOU0P00000606N9h08000001`1eRm/00`000000PHkG086>e`05086>e`03
0000002;T=<0Ri3C00D0Ri3C00<000000;U^N`2iKW/00`2iKW/00`000000[fEk0:mUN`070:mUN`03
06V@i@000000MY;Q0080PI?L0P2:UMP00`000000TYOF09:GeP0309VJd`050000002PWM40X9gA0:2M
d@0000000P2VX=000`000000ZjC@000000030;bZa`0300000032/<T0`[390080`[3900<000000<Ng
b`37]l/01037]l/2000000D0c;o>00<000000=77d@3Aam40103Aam400`000000hm34000000050>WN
a`030000003/kLX0k>g:00<0k>g:0`00000]0?ooo`00D03oool01000000003>g000c]`0000040019
b@040000000TFLl095W?02AIc`<000001`1FQnD00`000000IhWP06N9h00506N9h0030000001eRm/0
MH_K00D0MH_K00<00000086>e`21S]L01021S]L00`000000Ri3C08^@d`0508^@d`030000002iKW/0
^Fik00<0^Fik00<000000:mUN`2_IG/0202_IG/01`1YT>D0000000000021Tm`0000008ZEf0000000
0P2BUmH209VJd`050000002PWM40X9gA0:2Md@0000000`2VX=030:^Td080000000<0_:[700000032
/<T00`32/<T00`000000akO;0<Ngb`030<Ngb`030000003<_lh0c;o>00@0c;o>00<000000=77d@3A
am401P3Aam400`000000jMk70>WNa`030>WNa`030000003/kLX0k>g:00<0k>g:00@000000>Sjb000
00000000;@3oool00540oooo00@00000000c]`00<kL000001000BLT01000000095W?02AIc`000002
04:4j0030000001FQnD0EXOU00D0EXOU00<0000006N9h01WRN001@1WRN000`000000MH_K07F;f`04
07F;f`0300000021S]L0PHkG00D0PHkG00<0000008^@d`2;T=<01@2;T=<00`000000^Fik0;U^N`02
0;U^N`030000002_IG/0[fEk00T0[fEk00H0JI3U07JBh@21Tm`0000008ZEf000000209:GeP80VI[C
00D000000:2Md@2PWM40X9gA000000020:JPd0030000002[Y=00ZjC@00<0ZjC@00<000000<:`b@32
/<T00P32/<T00`000000akO;0<Ngb`030<Ngb`030000003<_lh0c;o>00@0c;o>00<000000=77d@3A
am401@3Aam43000000@0jMk700<000000>c]bP3/kLX00`3/kLX010000000j?[80>Sjb000000^0?oo
o`00DP3oool200000003000c]`00000004W900<004W900<0000002AIc`0000000`12Q>P2000000H0
EXOU00<0000006N9h01WRN001@1WRN000`000000MH_K07F;f`0407F;f`0300000021S]L0PHkG00D0
PHkG00<0000008^@d`2;T=<00`2;T=<2000000@0^Fik00<000000:mUN`2_IG/02@2_IG/020000000
JI3U07JBh@21Tm`0RYGH0000002BUmH000000P2IV]<010000000X9gA0:2Md@0000020:JPd0030000
002[Y=00ZjC@00<0ZjC@00H000000;2Xd000000000000<:`b@0000050<Ngb`030000003<_lh0c;o>
00<0c;o>0P0000070=77d@040000003EdMD0eM7E000000<0jMk700<000000>c]bP3/kLX00`3/kLX0
0`000000j?[80>Sjb002000002h0oooo001C0?ooo`80000000<003>g00000000BLT00`00BLT20000
00D0@XCX00<0000005J7i@1FQnD0101FQnD2000000H0IhWP00<0000007F;f`1eRm/0101eRm/00`00
0000PHkG086>e`04086>e`030000002;T=<0Ri3C00<000000P1ZU>L01@000000^Fik0;U^N`2iKW/0
000000/0[fEk00@000000:ALN`000000PI?L0P000000102BUmH0000009VJd`0000030:2Md@040000
002VX=00YZ3@000000@0ZjC@00<000000;2Xd02`Z=000P2`Z=000`000000akO;0<Ngb`030<Ngb`03
0000003<_lh0c;o>00<0c;o>00<000000=77d@3Aam401P3Aam400`000000eM7E0=GAe@020=GAe@03
0000003Yg/L0000000D0k>g:00D000000>Sjb03Xn/P0j?[80000000_0?ooo`00E03oool200000003
000c]`00000004W900<004W900<0000004:4j012Q>P01012Q>P2000000H0EXOU00<0000006N9h01W
RN00101WRN000`000000MH_K07F;f`0407F;f`0300000021S]L0PHkG00<0PHkG0`00000506ZDi`05
0000002iKW/0^Fik0;U^N`0000002`2_IG/00`000000Y5ak0:ALN`030000000409:GeP000000VI[C
00000080X9gA00@000000:JPd02VX=000000102[Y=000`000000/:S@0;2Xd0020;2Xd080]Jg@00D0
00000<Ngb`37]l/0akO;000000050<bocP030000003Aam40dLOA00D0dLOA0P0000050=GAe@800000
103/kLX2000000<0j?[800<000000?ooo`3oool0;P3oool005D0oooo0P0000000`00<kL000000000
00020019b@<000001P12Q>P00`000000EXOU05J7i@0405J7i@030000001WRN00IhWP00@0IhWP00<0
000007F;f`1eRm/0101eRm/00`000000PHkG086>e`0200000080G9?/00<0000006ZDi`1ZU>L0101Z
U>L01@000000^Fik0;U^N`2iKW/0000000/0[fEk00D000000:ALN`2TG7/0000008ZEf00200000007
09VJd`000000X9gA0:2Md@000000YZ3@000000040:^Td0050000002`Z=00/:S@0;2Xd0000000102e
[M000`000000akO;000000050<bocP030000003Aam40dLOA00D0dLOA00<000000=GAe@3EdMD01@3E
dMD00`000000k>g:0>c]bP020>c]bP030000003Xn/P0j?[80080j?[80P00000`0?ooo`00EP3oool2
0000008003>g00<000000019b@0000000P0[PNT2000000D0@XCX00<0000005J7i@1FQnD0101FQnD2
000000D0IhWP00<0000007F;f`1eRm/00`1eRm/3000000D0G9?/00<0000006ZDi`1ZU>L0101ZU>L0
10000000^Fik0;U^N`00000;0:mUN`040000002TG7/0Y5ak0:ALN`<0000000@0VI[C0000002PWM40
00000P2VX=001@000000ZjC@0:^Td02[Y=00000000<0/:S@00<000000;F]d02e[M00102e[M000`00
0000c;o>0<bocP030<bocP030000003Aam40dLOA00D0dLOA00<000000=GAe@3EdMD0103EdMD30000
00<0k>g:00<000000>Sjb03Xn/P00P3Xn/P200000340oooo001G0?ooo`<0000000@003>g00000000
BLT000000`0[PNT2000000@0@XCX0P00000605J7i@030000001WRN00IhWP00<0IhWP00<0000007F;
f`1eRm/00P00000204^Bk`030000001LTn`0G9?/00@0G9?/00<0000006ZDi`1ZU>L00`1ZU>L01000
0000^Fik0;U^N`00000;0:mUN`040000002TG7/0Y5ak0:ALN`@000000P2PWM400`000000YZ3@0000
00030:^Td0050000002`Z=00/:S@0;2Xd00000001@2e[M0010000000^[7A0;Zad@0000020<bocP80
00001P3Aam42000000D0eM7E0P0000020=SLfP040000003/kLX0k>g:000000@0j?[800<000000=Gn
_@000000<@3oool005T0oooo0P0000000`00<kL000000000000502^1j@8000001012Q>P00`000000
EXOU05J7i@0405J7i@030000001WRN00IhWP00<0IhWP0P00000504^Bk`030000001LTn`0G9?/00@0
G9?/00<0000006ZDi`1ZU>L00`1ZU>L00`000000^Fik0000000;0:mUN`040000002TG7/0Y5ak0:AL
N`@0000000@0X9gA0000002VX=0000000`2[Y=001@000000/:S@0;2Xd02`Z=00000000D0]Jg@00L0
00000;Zad@2j/M40^[7A0000003<_lh0000000L0dLOA00<000000=GAe@3EdMD0103EdMD00`000000
f=cJ0=SLfP020=SLfP030000003/kLX0000000@0j?[800<000000=Gn_@000000<P3oool005X0oooo
0P0000000`00<kL000000000000602^1j@8000000`12Q>P2000000D0EXOU0P00000206N9h0040000
000iTO000000000000D0Bi;_0P00000505bCk0030000001ZU>L0JYCW00<0JYCW0P00000;0:mUN`03
0000002TG7/0Y5ak0080Y5ak00L00B6U000000000000X9gA0000002VX=0000000080ZjC@00D00000
0;2Xd02`Z=00/:S@000000040;F]d0030000002j/M40^[7A00@0^[7A00<000000=77d@3Aam40103A
am42000000D0eM7E0P0000050=SLfP8000000`3Xn/P200000080eOjm00<000000?ooo`3oool0<03o
ool005/0oooo0P0000001000<kL0000000000000000602^1j@0300000012Q>P0@XCX0080@XCX00<0
000005J7i@1FQnD0101FQnD00`000000IhWP0000000303VAl0030000001;T^l0Bi;_00@0Bi;_00<0
000005bCk01LTn`00`1LTn`00`000000JYCW06ZDi`0306ZDi`030000002_IG/0[fEk00T0[fEk00<0
00000:ALN`2TG7/00P2TG7/01P018JD000000:2Md@000000YZ3@00000080ZjC@00<000000;2Xd02`
Z=000P0000030;F]d08000001@2j/M400`000000_[OC000000050=77d@030000003EdMD0eM7E00@0
eM7E00<000000=SLfP3Hg=X01@3Hg=X01@000000j?[80>Sjb03Xn/P0000000<0eOjm00<000000?oo
o`3oool0<@3oool005d0oooo0P000002015li08000001@0[PNT2000000<0@XCX0P00000505J7i@80
0000100iTO02000000D0Bi;_00<0000005bCk01LTn`00`1LTn`00`000000JYCW06ZDi`0206ZDi`03
0000002_IG/0[fEk00T0[fEk00<000000:ALN`2TG7/00P2TG7/00`018JD000000:2Md@0200000080
ZjC@00@000000;2Xd02`Z=000000102e[M000`000000^[7A0;Zad@030;Zad@030000002n]m<0_[OC
0080_[OC00D000000=77d@3Aam40dLOA000000050=GAe@8000001P3Hg=X300000080j?[800@00000
0=Gn_@3Eo[d0eOjm0P00000c0?ooo`00GP3oool2000000<04GcT0P00000502^1j@8000000`12Q>P0
1@000000EXOU05J7i@1FQnD0000000809I3]0P00000403VAl0800000101;T^l00`000000G9?/05bC
k00305bCk0030000001ZU>L0JYCW0080JYCW4@0000001P1BCJh000000:JPd0000000ZjC@00000080
/:S@00@000000;F]d02e[M00]Jg@0P0000040;Zad@030000002n]m<0_[OC00@0_[OC00@000000=77
d@0000000000103EdMD2000000H0f=cJ0P0000020=WWg`030000003Xn/P0000000<0eOjm0P00000d
0?ooo`00G`3oool3000000<04GcT0P00000502^1j@8000000P12Q>P010000000EXOU05J7i@000004
02F@k@800000100iTO000`000000Bi;_04^Bk`0204^Bk`030000001LTn`0G9?/0080G9?/00<00000
06ZDi`1ZU>L00`1ZU>L00`000000XD9B0:52DP070:52DP030000002C=e40TcMA0080TcMA00H0DTf^
06YK[P1ZFjh000000:^Td00000020;2Xd0050000002e[M00]Jg@0;F]d0000000102j/M42000000L0
_[OC0P0000050=GAe@030000003Hg=X0f=cJ00@0f=cJ0P0000030=WWg`030000003Xn/P0000000<0
eOjm0P00000e0?ooo`00H@3oool3000000<04GcT0P00000502^1j@8000000P12Q>P2000000H09I3]
0P00000303VAl08000000`1;T^l2000000<0G9?/00<0000006ZDi`1ZU>L00P1ZU>L00`000000XD9B
0:52DP070:52DP030000002C=e40TcMA0080TcMA0P1ZFjh0101lIJh000000000002`Z=0200000080
]Jg@0P0000030;Zad@8000001P2n]m<3000000030<:me@000000eM7E0080eM7E0P0000050=SLfP80
00001@3Iiml2000000<0eOjm00<000000:W]XP000000=@3oool00680oooo1@000002015li0800000
1@0[PNT010000000@XCX0000000BSND2000000H09I3]0P00000303VAl0030000001;T^l0Bi;_0080
Bi;_00D0000005bCk01LTn`0G9?/0000000406ZDi`030000002Q@U80XD9B00H0XD9B00@0000009<g
D@2C=e40TcMA0P1ZFjh207aU[P030000002`Z=0000000080]Jg@0P0000030;Zad@8000001P2n]m<2
000000D0`[gE00<000000=GAe@0000001@3Hg=X2000000H0fNOO0P0000020=Gn_@80000000<0ZNfR
0000003oool0=@3oool006<0oooo0P000002001ff@8000000P0AO>@2000000D0:h7Y0P00000201:=
i@<000001@0UT>d200000080>I7`0P00000304^Bk`050000001LTn`0G9?/05bCk0000000101ZU>L0
0`000000XD9B0:52DP050:52DP080000002C=e40TcMA06YK[P000000O6F^0000002:KZd200000080
]Jg@00@000000;Zad@2j/M40^[7A0P0000050;jgd`<000001P32_MD2000000D0f=cJ0P0000060=WW
g`80000000@0eo7S0000003Eo[d000000P2YkJ800`000000oooo0?ooo`0e0?ooo`00I@3oool20000
008007KI0`0000000`0AO>@000000000000302^1j@0300000003RmX0000000<0000000@04XgU0000
000000000000100UT>d200000080>I7`00D0000004^Bk`1;T^l0Bi;_0000000305bCk0050000001Z
U>L0JYCW06ZDi`0000001`2Q@U800`000000TcMA06YK[P0207aU[P0408Y^[@000000UWF/09Ie[0<0
00000P2j/M42000000@0_[OC0`0000060<:me@<0000000<0aL?H0000003Hg=X00P3Hg=X2000000H0
fNOO0P0000020=Oah`030000003Eo[d000000080ZNfR00<000000?ooo`3oool0=P3oool006H0oooo
0`000003001ff@80000000D04GcT000000000000:h7Y0000000500>;fP<0000000<04XgU00000000
0000100UT>d20000000303VAl000000000000080Bi;_00D0000005bCk01LTn`0G9?/0000000306ZD
i`030000002Q@U80XD9B00D0XD9B00@0JU^^07aU[P2:KZd000000`2FMJ`200000080^[7A0P000003
0;jgd`<000001@32_MD4000000@0aL?H00@000000=SLfP00000000001P3Iiml2000000@0eo7S0P00
00020:W]XP030000003oool0oooo03L0oooo001W0?ooo`D000000P00M]T7000000H00h_J1P000003
02F@k@80000000@0>I7`000000000000Bi;_0P00000205bCk0050000001ZU>L0JYCW06ZDi`000000
1@2Q@U800`1ZFjh0RVj]09Ie[00209Ie[0030000002PO:`0X7b/00@000000`2n]m<2000000D0`[gE
0`0000060<G3f0@000001@3Iiml3000000D0eo7S0P0000020:W]XP030000003oool0oooo03P0oooo
001Y0?ooo`0300000000L<T00739008000000`00M]T300000003002:c@000000000000<000001003
RmX6000000809I3]0P0000001@0iTO00000004^Bk`1;T^l000000080G9?/00D0000006ZDi`1ZU>L0
JYCW000000030:52DP0306YK[P2FMJ`0UWF/0080X7b/0P0000040:V3[0030000002n]m<000000080
00001032_MD3000000D0aL?H100000020<S:f`030000003Iiml0fNOO0080fNOO0P0000070=Oah`80
000000<0ZNfR000000000000>`3oool006X0oooo0`0000001000L<T00000000000000002001ff@D0
00000P00R/d4000000@00h_J1000000202F@k@<000000P1;T^l010000000G9?/05bCk000000206ZD
i`060000002Q@U80XD9B0000002PO:`000001P2YPj`5000000<0`[gE100000030<G3f0D000001@38
b]/010000000fNOO0=WWg`3Iiml2000000H0eo7S100000000`2YkJ8000000?ooo`0l0?ooo`00K03o
ool70000008007KI00<00000002<`@00S<402`00000200>;fP@0000000<09I3]0000000000002@00
00020:V3[0<00000202bRZ`00`000000`[gE0<:me@0200000080aL?H1@00000:0<S:f`040000003I
iml00000000000D0eo7S0`0000030<kiiP800000?P3oool006h0oooo0P0000000`00JkH000000000
000200000003001ff@00000008c100P008c11`00000200>;fP/0000000<0jlbe0000002bRZ`03@00
00000`35`mP0000000000002000000`0b<[K1@0000050=Oah`8000001@3>nNH2000003l0oooo001`
0?ooo`@0000000<006^f0000000000007P0000000`3[c;D000000<:H[@0:0<:H[@<000002@38b]/7
000000<0b]7O00@000000=Oah`3GlN<0eo7S0`0000070<kiiP030000003oool0oooo03h0oooo001c
0?oooa8000000`0;WKH:00000080G=G>1@0000040<VP[P0300000032V:d0`YR]0080`YR]00@00000
0<S:f`38b]/0b<[K200000090<[Ag`030000003GlN<0000000800000203>nNH200000440oooo001g
0?ooo`L00000100;WKH6000000808:bj0`0000000`0k`<8000000000000205cEcP8000000P1oj=/3
000000040>_<]@0000000000000000D0bJ2^1000000<0<[Ag`L00000203>nNH400000480oooo001k
0?ooo`L00000100P[;X400000080>l320P00000205cEcP800000101oj=/01@000000WoGU00000000
0000jlbe0080f[>a00H000000=6Y[`00000000000<VP[P0000050<[Ag`X00000103;fN@00`000000
c_WV0<kiiP050<kiiP<0000000<0_OcT000000000000@`3oool00840oooo600000000`3oool00000
0>_<]@040=Zc/@030000003AZJl0000000D000003P3;fN@010000000c_WV0<kiiP3>nNH4000000<0
_OcT00<000000?ooo`3oool0@`3oool009/0oooo00<000000>_<]@3[c;D0103J/k4:000000T0bmWT
00<000000<kiiP0000000P0000050;gli0800000AP3oool009`0oooo00H000000>_<]@3[c;D0h[jc
0=Zc/@00000:0<[Pj0/00000102mo>@5000004L0oooo002M0?ooo`030000003[c;D0jlbe00H00000
3P3:h>P010000000_OcT0;gli02mo>@300000080X_KL00<000000?ooo`3oool0A`3oool009h0oooo
00@000000>_<]@3[c;D000001037ind8000000D0b^3X00<000000;gli00000000P0000030:;fg080
0000BP3oool009l0oooo0P0000020<7]l@@000001`37ind6000000D0X_KL0P00001<0?ooo`00X03o
ool00`000000`Nga0<7]l@040<7]l@<000001`37ind010000000X_KL0:;fg02Rm]`5000004d0oooo
002R0?ooo`8000001P31kO4400000080anO]00<000000:;fg00000000P0000000`1mi/`000000000
001?0?ooo`00Y03oool2000000P0`Nga0`00000207gVc0<00000D@3oool00:H0oooo0P0000060<7]
l@030000001mi/`0000000800000E03oool00:P0oooo0P0000020<7]l@@00000E`3oool00:X0oooo
0`00001J0?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00
o`3oool80?ooo`00o`3oool80?ooo`00o`3oool80?ooo`00\
\>"],
  ImageRangeCache->{{{0, 262.813}, {286.938, 0}} -> {0.0498988, \
-6.63897*^-05, 0.00323038, 0.00323038}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.49464 .52916 m .53467 .52936 L .53561 .58771 L p .706 .531 .649 r
F P
0 g
s
.53467 .52936 m .57375 .52804 L .57248 .58544 L p .686 .514 .648 r
F P
0 g
s
.57248 .58544 m .53561 .58771 L .53467 .52936 L p .686 .514 .648 r
F P
0 g
s
.45455 .5274 m .49464 .52916 L .4978 .58864 L p .726 .546 .648 r
F P
0 g
s
.53561 .58771 m .4978 .58864 L .49464 .52916 L p .706 .531 .649 r
F P
0 g
s
.57375 .52804 m .61104 .52528 L .61055 .53327 L p .665 .495 .646 r
F P
0 g
s
.61055 .53327 m .58678 .56571 L .62263 .53421 L .664 .528 .688 r
F
.58678 .56571 m .62353 .56197 L .62263 .53421 L p F P
0 g
s
.62353 .56197 m .58678 .56571 L .58515 .62723 L p .659 .496 .652 r
F P
0 g
s
.61104 .52528 m .63402 .52256 L p .61446 .53135 L .64 .474 .642 r
F P
0 g
s
.65452 .49459 m .62149 .49874 L .62243 .52777 L p .641 .51 .687 r
F P
0 g
s
.62243 .52777 m .62353 .56197 L p .63881 .52875 L .641 .51 .687 r
F P
0 g
s
.64573 .52117 m .64497 .529 L p .62499 .52792 L .64 .474 .642 r
F P
0 g
s
.64497 .529 m .62353 .56197 L .65615 .52945 L .641 .51 .687 r
F
.62353 .56197 m .65744 .55695 L .65615 .52945 L p F P
0 g
s
.65744 .55695 m .62353 .56197 L .62018 .6228 L p .634 .474 .649 r
F P
0 g
s
.64573 .52117 m .66649 .51764 L p .64851 .52698 L .61 .446 .635 r
F P
0 g
s
.68403 .48927 m .65452 .49459 L .65586 .52317 L p .613 .488 .686 r
F P
0 g
s
.65586 .52317 m .65744 .55695 L p .67058 .52351 L .613 .488 .686 r
F P
0 g
s
.6771 .51584 m .67607 .52352 L p .65816 .52322 L .61 .446 .635 r
F P
0 g
s
.67607 .52352 m .65744 .55695 L .68612 .52354 L .613 .488 .686 r
F
.65744 .55695 m .68778 .5508 L .68612 .52354 L p F P
0 g
s
.68778 .5508 m .65744 .55695 L .65251 .61724 L p .603 .447 .643 r
F P
0 g
s
.6771 .51584 m .69519 .5116 L p .67918 .52143 L .571 .41 .624 r
F P
0 g
s
.70938 .48292 m .68403 .48927 L .68574 .5174 L p .577 .461 .684 r
F P
0 g
s
.68574 .5174 m .68778 .5508 L p .69847 .51718 L .577 .461 .684 r
F P
0 g
s
.70445 .50943 m .70319 .51698 L p .68774 .51737 L .571 .41 .624 r
F P
0 g
s
.70319 .51698 m .68778 .5508 L .71188 .51661 L .577 .461 .684 r
F
.68778 .5508 m .71389 .54364 L .71188 .51661 L p F P
0 g
s
.71389 .54364 m .68778 .5508 L .68145 .61065 L p .562 .411 .633 r
F P
0 g
s
.68145 .61065 m .70635 .60315 L .71389 .54364 L p .562 .411 .633 r
F P
0 g
s
.7352 .53565 m .71389 .54364 L .70635 .60315 L p .501 .356 .616 r
F P
0 g
s
.71646 .55694 m .69527 .56453 L .70319 .51698 L p .513 .356 .605 r
F P
0 g
s
.70319 .51698 m .70445 .50943 L p .70582 .51484 L .513 .356 .605 r
F P
0 g
s
.70445 .50943 m .71949 .5046 L p .71144 .51063 L .513 .356 .605 r
F P
0 g
s
.70582 .51484 m .70487 .51107 L .71144 .51063 L .513 .356 .605 r
F
.70487 .51107 m .70445 .50943 L .71144 .51063 L F
.73001 .47573 m .70938 .48292 L .71144 .51063 L p .526 .423 .68 r
F P
0 g
s
.71144 .51063 m .71389 .54364 L p .72189 .50993 L .526 .423 .68 r
F P
0 g
s
.69847 .51718 m .68774 .51737 L .70319 .51698 L .571 .41 .624 r
F
.67607 .52352 m .6771 .51584 L p .67918 .52143 L F P
0 g
s
.67058 .52351 m .65816 .52322 L .67607 .52352 L .61 .446 .635 r
F
.64497 .529 m .64573 .52117 L p .64851 .52698 L F P
0 g
s
.63881 .52875 m .62499 .52792 L .64497 .529 L .64 .474 .642 r
F
.61055 .53327 m .61104 .52528 L p .61446 .53135 L F P
0 g
s
.60883 .53314 m .57375 .52804 L .61055 .53327 L .665 .495 .646 r
F
.61023 .53325 m .61002 .53353 L .61055 .53327 L .664 .528 .688 r
F
.61002 .53353 m .58678 .56571 L .61055 .53327 L F
.60386 .53275 m .60159 .53713 L .61023 .53325 L F
.60159 .53713 m .58678 .56571 L .61023 .53325 L F
.57499 .53001 m .57375 .52804 L .61055 .53339 L .665 .495 .646 r
F
.62263 .53421 m .62149 .49874 L p .60386 .53275 L .664 .528 .688 r
F P
0 g
s
.63402 .52256 m .64573 .52117 L p .61446 .53135 L .64 .474 .642 r
F P
0 g
s
.65615 .52945 m .65452 .49459 L p .63881 .52875 L .641 .51 .687 r
F P
0 g
s
.66649 .51764 m .6771 .51584 L p .64851 .52698 L .61 .446 .635 r
F P
0 g
s
.68612 .52354 m .68403 .48927 L p .67058 .52351 L .613 .488 .686 r
F P
0 g
s
.69519 .5116 m .70445 .50943 L p .67918 .52143 L .571 .41 .624 r
F P
0 g
s
.70938 .48292 m .69847 .51718 L .70295 .51699 L .577 .461 .684 r
F
.71188 .51661 m .71144 .51063 L p .70295 .51699 L F P
0 g
s
.71144 .51063 m .70938 .48292 L p .70295 .51699 L .577 .461 .684 r
F P
0 g
s
.71389 .54364 m .7352 .53565 L .73288 .50885 L p .526 .423 .68 r
F P
0 g
s
.7272 .50212 m .72574 .50955 L p .71253 .51085 L .513 .356 .605 r
F P
0 g
s
.71949 .5046 m .7272 .50212 L p .70582 .51484 L .513 .356 .605 r
F P
0 g
s
.73288 .50885 m .73237 .50302 L p .72783 .50738 L .526 .423 .68 r
F P
0 g
s
.72574 .50955 m .7272 .50212 L p .72783 .50738 L .419 .268 .568 r
F P
0 g
s
.72783 .50738 m .72554 .50957 L .72574 .50955 L .526 .423 .68 r
F
.72783 .50738 m .72574 .50955 L .73288 .50885 L F
.72189 .50993 m .71389 .54364 L .73288 .50885 L F
.70635 .60315 m .72668 .5949 L .7352 .53565 L p .501 .356 .616 r
F P
0 g
s
.7328 .54872 m .71646 .55694 L .72574 .50955 L p .419 .268 .568 r
F P
0 g
s
.7328 .54872 m .72574 .50955 L .72783 .50738 L .419 .268 .568 r
F
.7272 .50212 m .73885 .49682 L p .72783 .50738 L F P
0 g
s
.74547 .46791 m .73001 .47573 L .73237 .50302 L p .445 .362 .669 r
F P
0 g
s
.73237 .50302 m .7352 .53565 L p .74031 .50194 L .445 .362 .669 r
F P
0 g
s
.74483 .49409 m .74322 .50142 L p .73362 .50285 L .419 .268 .568 r
F P
0 g
s
.74322 .50142 m .7352 .53565 L .74865 .50046 L .445 .362 .669 r
F
.7352 .53565 m .75124 .52702 L .74865 .50046 L p F P
0 g
s
.75124 .52702 m .7352 .53565 L .72668 .5949 L p .399 .265 .58 r
F P
0 g
s
.74393 .54005 m .7328 .54872 L .74322 .50142 L p .232 .094 .479 r
F P
0 g
s
.74322 .50142 m .74483 .49409 L p .74473 .49923 L .232 .094 .479 r
F P
0 g
s
.74483 .49409 m .75285 .48846 L p .74809 .49477 L .232 .094 .479 r
F P
0 g
s
.74473 .49923 m .7448 .49563 L .74809 .49477 L .232 .094 .479 r
F
.7448 .49563 m .74483 .49409 L .74809 .49477 L F
.75542 .45968 m .74547 .46791 L .74809 .49477 L p .293 .248 .636 r
F P
0 g
s
.74809 .49477 m .75124 .52702 L p .75333 .49341 L .293 .248 .636 r
F P
0 g
s
.74031 .50194 m .73362 .50285 L .74322 .50142 L .419 .268 .568 r
F
.73885 .49682 m .74483 .49409 L p .72783 .50738 L F P
0 g
s
.74547 .46791 m .74031 .50194 L .74306 .50145 L .445 .362 .669 r
F
.74865 .50046 m .74809 .49477 L p .74306 .50145 L F P
0 g
s
.74809 .49477 m .74547 .46791 L p .74306 .50145 L .445 .362 .669 r
F P
0 g
s
.75124 .52702 m .76164 .51796 L .75883 .49164 L p .293 .248 .636 r
F P
0 g
s
.75697 .48556 m .75524 .4928 L p .74857 .49494 L .232 .094 .479 r
F P
0 g
s
.75285 .48846 m .75697 .48556 L p .74473 .49923 L .232 .094 .479 r
F P
0 g
s
.75883 .49164 m .75824 .48611 L p .75616 .49061 L .293 .248 .636 r
F P
0 g
s
.75524 .4928 m .75697 .48556 L p .75616 .49061 L 0 0 .204 r
F P
0 g
s
.75616 .49061 m .75513 .49283 L .75524 .4928 L .293 .248 .636 r
F
.75616 .49061 m .75524 .4928 L .75883 .49164 L F
.75333 .49341 m .75124 .52702 L .75883 .49164 L F
.74393 .54005 m .75524 .4928 L p .75005 .52834 L 0 0 .204 r
F P
0 g
s
.74964 .53114 m .75524 .4928 L .75616 .49061 L 0 0 .204 r
F
.75824 .48611 m .76164 .51796 L p .76065 .48458 L 0 0 .505 r
F P
0 g
s
.74964 .53114 m .75616 .49061 L .75862 .48586 L 0 0 .204 r
F
.76164 .51796 m .76619 .50869 L .76323 .48264 L p 0 0 .505 r
F P
0 g
s
.76334 .47676 m .76154 .48391 L p .75862 .48586 L 0 0 .204 r
F P
0 g
s
.76065 .48458 m .75862 .48586 L .76154 .48391 L 0 0 .204 r
F
.75697 .48556 m .76118 .47976 L p .75616 .49061 L F P
0 g
s
.76118 .47976 m .76334 .47676 L p .75616 .49061 L 0 0 .204 r
F P
0 g
s
.75967 .45127 m .76065 .48458 L .76149 .48394 L 0 0 .505 r
F
.75967 .45127 m .76149 .48394 L .76186 .48175 L F
.76262 .47725 m .76258 .47689 L p .76186 .48175 L F P
0 g
s
.76258 .47689 m .75967 .45127 L p .76186 .48175 L 0 0 .505 r
F P
0 g
s
.76065 .48458 m .76164 .51796 L .76323 .48264 L 0 0 .505 r
F
.76154 .48391 m .76151 .48403 L p .76065 .48458 L 0 0 .204 r
F P
0 g
s
.76151 .48403 m .74964 .53114 L p .75862 .48586 L 0 0 .204 r
F P
0 g
s
.74964 .53114 m .74913 .53194 L p .75005 .52834 L 0 0 .204 r
F P
0 g
s
.74913 .53194 m .74393 .54005 L p .75005 .52834 L 0 0 .204 r
F P
0 g
s
.74983 .52221 m .74964 .53114 L .76154 .48391 L p .884 .846 .387 r
F P
0 g
s
.76154 .48391 m .76334 .47676 L p .76186 .48175 L .884 .846 .387 r
F P
0 g
s
.74983 .52221 m .76154 .48391 L .76186 .48175 L .884 .846 .387 r
F
.75967 .45127 m .75824 .48611 L .76065 .48458 L 0 0 .505 r
F
.75967 .45127 m .75542 .45968 L .75824 .48611 L p F P
0 g
s
.75542 .45968 m .75967 .45127 L .73838 .39919 L p .084 .197 .685 r
F P
0 g
s
.73673 .39242 m .73838 .39919 L .75931 .45039 L p 0 0 .397 r
F P
0 g
s
.75931 .45039 m .75967 .45127 L p .7593 .45032 L 0 0 .397 r
F P
0 g
s
.73673 .39242 m .75931 .45039 L .7593 .45032 L 0 0 .397 r
F
.74983 .52221 m .76186 .48175 L .76248 .47742 L .884 .846 .387 r
F
.76246 .47729 m .76248 .47742 L .76254 .477 L F
.74983 .52221 m .76248 .47742 L .76246 .47729 L F
.76199 .47511 m .74983 .52221 L p .76246 .47729 L F P
0 g
s
.76246 .47729 m .76254 .477 L .76216 .47567 L .884 .846 .387 r
F
.76246 .47729 m .76216 .47567 L .76199 .47511 L F
.75967 .45127 m .75816 .44292 L .73673 .39242 L p 0 0 .397 r
F P
0 g
s
.75846 .44536 m .76216 .47567 L .75842 .44516 L .766 .559 0 r
F
.76186 .48175 m .76229 .4803 L .76285 .47585 L .884 .846 .387 r
F
.75816 .44292 m .75967 .45127 L .76262 .47725 L p .766 .559 0 r
F P
0 g
s
.75816 .44292 m .76262 .47725 L .76216 .47567 L .766 .559 0 r
F
.76186 .48175 m .76285 .47585 L .76385 .46793 L .884 .846 .387 r
F
.76334 .47676 m .76339 .47601 L p .76229 .4803 L F P
0 g
s
.76339 .47601 m .76385 .46793 L p .76229 .4803 L .884 .846 .387 r
F P
0 g
s
.76323 .48264 m .76262 .47725 L p .76149 .48394 L 0 0 .505 r
F P
0 g
s
.76216 .47567 m .76619 .50869 L .76214 .4756 L .766 .559 0 r
F
.76216 .47567 m .76214 .4756 L .75842 .44516 L F
.75542 .45968 m .75333 .49341 L .75513 .49283 L .293 .248 .636 r
F
.75824 .48611 m .75542 .45968 L p .75513 .49283 L F P
0 g
s
.74393 .54005 m .74473 .49923 L .74857 .49494 L .232 .094 .479 r
F
.75524 .4928 m .74393 .54005 L p .74857 .49494 L F P
0 g
s
.7446 .51347 m .74983 .52221 L .76203 .47498 L p .981 .869 .651 r
F P
0 g
s
.75842 .44516 m .76214 .4756 L .76204 .47502 L .766 .559 0 r
F
.762 .47478 m .76204 .47502 L .76203 .47498 L F
.75842 .44516 m .76204 .47502 L .762 .47478 L F
.75542 .45968 m .74809 .49477 L .75333 .49341 L .293 .248 .636 r
F
.75102 .43489 m .75816 .44292 L .76117 .46844 L p .993 .747 .441 r
F P
0 g
s
.7446 .51347 m .76175 .47289 L .76075 .46863 L .981 .869 .651 r
F
.76054 .46851 m .76075 .46863 L .76064 .4682 L F
.7446 .51347 m .76075 .46863 L .76054 .46851 L F
.75672 .46641 m .7446 .51347 L p .76064 .4682 L F P
0 g
s
.7446 .51347 m .76203 .47498 L .76175 .47289 L .981 .869 .651 r
F
.76482 .49946 m .75764 .49049 L .75461 .46501 L p .993 .747 .441 r
F P
0 g
s
.74547 .46791 m .75542 .45968 L .73483 .40607 L p .348 .36 .731 r
F P
0 g
s
.73838 .39919 m .73483 .40607 L .75542 .45968 L p .084 .197 .685 r
F P
0 g
s
.75461 .46501 m .75102 .43489 L p .75787 .46693 L .993 .747 .441 r
F P
0 g
s
.75102 .43489 m .76117 .46844 L .75787 .46693 L .993 .747 .441 r
F
.75854 .45932 m .75672 .46641 L p .76064 .4682 L .981 .869 .651 r
F P
0 g
s
.75787 .46693 m .76482 .49946 L .75461 .46501 L .993 .747 .441 r
F
.76035 .46226 m .75854 .45932 L p .76175 .47289 L .981 .869 .651 r
F P
0 g
s
.76117 .46844 m .76482 .49946 L p .75787 .46693 L .993 .747 .441 r
F P
0 g
s
.76112 .46808 m .75842 .44516 L p .76203 .47498 L .766 .559 0 r
F P
0 g
s
.76385 .46793 m .76035 .46226 L p .76175 .47289 L .981 .869 .651 r
F P
0 g
s
.76203 .47498 m .76385 .46793 L p .76175 .47289 L .981 .869 .651 r
F P
0 g
s
.76178 .47368 m .76112 .46808 L p .76203 .47498 L .766 .559 0 r
F P
0 g
s
.76619 .50869 m .76482 .49946 L .76178 .47368 L p .766 .559 0 r
F P
0 g
s
.76214 .4756 m .76619 .50869 L .76178 .47368 L .766 .559 0 r
F
.75842 .44516 m .75816 .44292 L p .75846 .44536 L F P
0 g
s
.76262 .47725 m .76619 .50869 L p .76216 .47567 L .766 .559 0 r
F P
0 g
s
.76385 .46793 m .76199 .47511 L p .76254 .477 L .884 .846 .387 r
F P
0 g
s
.74393 .54005 m .74322 .50142 L .74473 .49923 L .232 .094 .479 r
F
.74306 .50145 m .74299 .50175 L .74322 .50142 L .445 .362 .669 r
F
.74299 .50175 m .7352 .53565 L .74322 .50142 L F
.74031 .50194 m .73971 .50589 L .74306 .50145 L F
.73971 .50589 m .7352 .53565 L .74306 .50145 L F
.74322 .50142 m .74319 .50155 L p .74031 .50194 L .419 .268 .568 r
F P
0 g
s
.74547 .46791 m .73237 .50302 L .74031 .50194 L .445 .362 .669 r
F
.7328 .54872 m .72783 .50738 L .73362 .50285 L .419 .268 .568 r
F
.74319 .50155 m .7328 .54872 L p .73362 .50285 L F P
0 g
s
.73001 .47573 m .72189 .50993 L .72554 .50957 L .526 .423 .68 r
F
.73237 .50302 m .73001 .47573 L p .72554 .50957 L F P
0 g
s
.71646 .55694 m .70582 .51484 L .71253 .51085 L .513 .356 .605 r
F
.72574 .50955 m .71646 .55694 L p .71253 .51085 L F P
0 g
s
.73001 .47573 m .71144 .51063 L .72189 .50993 L .526 .423 .68 r
F
.71646 .55694 m .70319 .51698 L .70582 .51484 L .513 .356 .605 r
F
.70295 .51699 m .70281 .51729 L .70319 .51698 L .577 .461 .684 r
F
.70281 .51729 m .68778 .5508 L .70319 .51698 L F
.69847 .51718 m .69715 .52134 L .70295 .51699 L F
.69715 .52134 m .68778 .5508 L .70295 .51699 L F
.70319 .51698 m .70317 .5171 L p .69847 .51718 L .571 .41 .624 r
F P
0 g
s
.70938 .48292 m .68574 .5174 L .69847 .51718 L .577 .461 .684 r
F
.69527 .56453 m .67918 .52143 L .68774 .51737 L .571 .41 .624 r
F
.70317 .5171 m .69527 .56453 L p .68774 .51737 L F P
0 g
s
.65251 .61724 m .68145 .61065 L .68778 .5508 L p .603 .447 .643 r
F P
0 g
s
.69527 .56453 m .66967 .57132 L .67607 .52352 L p .571 .41 .624 r
F P
0 g
s
.69527 .56453 m .67607 .52352 L .67918 .52143 L .571 .41 .624 r
F
.67579 .52352 m .67563 .52381 L .67607 .52352 L .613 .488 .686 r
F
.67563 .52381 m .65744 .55695 L .67607 .52352 L F
.67058 .52351 m .66891 .52774 L .67579 .52352 L F
.66891 .52774 m .65744 .55695 L .67579 .52352 L F
.67607 .52352 m .67605 .52364 L p .67058 .52351 L .61 .446 .635 r
F P
0 g
s
.68403 .48927 m .65586 .52317 L .67058 .52351 L .613 .488 .686 r
F
.66967 .57132 m .64851 .52698 L .65816 .52322 L .61 .446 .635 r
F
.67605 .52364 m .66967 .57132 L p .65816 .52322 L F P
0 g
s
.62018 .6228 m .65251 .61724 L .65744 .55695 L p .634 .474 .649 r
F P
0 g
s
.66967 .57132 m .64025 .57715 L .64497 .529 L p .61 .446 .635 r
F P
0 g
s
.66967 .57132 m .64497 .529 L .64851 .52698 L .61 .446 .635 r
F
.64466 .52898 m .64448 .52927 L .64497 .529 L .641 .51 .687 r
F
.64448 .52927 m .62353 .56197 L .64497 .529 L F
.63881 .52875 m .63683 .53306 L .64466 .52898 L F
.63683 .53306 m .62353 .56197 L .64466 .52898 L F
.64497 .529 m .64495 .52911 L p .63881 .52875 L .64 .474 .642 r
F P
0 g
s
.65452 .49459 m .62243 .52777 L .63881 .52875 L .641 .51 .687 r
F
.64025 .57715 m .61446 .53135 L .62499 .52792 L .64 .474 .642 r
F
.64495 .52911 m .64025 .57715 L p .62499 .52792 L F P
0 g
s
.58515 .62723 m .62018 .6228 L .62353 .56197 L p .659 .496 .652 r
F P
0 g
s
.64025 .57715 m .60761 .58189 L .61055 .53327 L p .64 .474 .642 r
F P
0 g
s
.64025 .57715 m .61055 .53327 L .61446 .53135 L .64 .474 .642 r
F
.61055 .53327 m .61055 .53339 L p .60883 .53314 L .665 .495 .646 r
F P
0 g
s
.62149 .49874 m .58565 .50157 L .58617 .53107 L p .664 .528 .688 r
F P
0 g
s
.58617 .53107 m .58678 .56571 L p .60386 .53275 L .664 .528 .688 r
F P
0 g
s
.62149 .49874 m .58617 .53107 L .60386 .53275 L .664 .528 .688 r
F
.61055 .53339 m .60761 .58189 L p .57499 .53001 L .665 .495 .646 r
F P
0 g
s
.60761 .58189 m .57248 .58544 L .57375 .52804 L p .665 .495 .646 r
F P
0 g
s
.58565 .50157 m .62149 .49874 L .61455 .43716 L p .665 .554 .719 r
F P
0 g
s
.61455 .43716 m .58202 .43888 L .58565 .50157 L p .665 .554 .719 r
F P
0 g
s
.41529 .52405 m .45455 .5274 L .45989 .58819 L p .746 .562 .646 r
F P
0 g
s
.4978 .58864 m .45989 .58819 L .45455 .5274 L p .726 .546 .648 r
F P
0 g
s
.58202 .43888 m .61455 .43716 L .60339 .38099 L p .662 .578 .751 r
F P
0 g
s
.60339 .38099 m .57624 .38141 L .58202 .43888 L p .662 .578 .751 r
F P
0 g
s
.62149 .49874 m .65452 .49459 L .64446 .43419 L p .643 .539 .721 r
F P
0 g
s
.64446 .43419 m .61455 .43716 L .62149 .49874 L p .643 .539 .721 r
F P
0 g
s
.37782 .51913 m .41529 .52405 L .42277 .58634 L p .767 .578 .642 r
F P
0 g
s
.45989 .58819 m .42277 .58634 L .41529 .52405 L p .746 .562 .646 r
F P
0 g
s
.61455 .43716 m .64446 .43419 L .62828 .37946 L p .641 .566 .755 r
F P
0 g
s
.62828 .37946 m .60339 .38099 L .61455 .43716 L p .641 .566 .755 r
F P
0 g
s
.4978 .58864 m .53561 .58771 L .53736 .63563 L p .698 .489 .602 r
F P
0 g
s
.53561 .58771 m .57248 .58544 L .56956 .63252 L p .676 .47 .6 r
F P
0 g
s
.56956 .63252 m .53736 .63563 L .53561 .58771 L p .676 .47 .6 r
F P
0 g
s
.45989 .58819 m .4978 .58864 L .50431 .63764 L p .718 .506 .601 r
F P
0 g
s
.53736 .63563 m .50431 .63764 L .4978 .58864 L p .698 .489 .602 r
F P
0 g
s
.57624 .38141 m .60339 .38099 L .5889 .33356 L p .65 .603 .788 r
F P
0 g
s
.5889 .33356 m .56876 .33259 L .57624 .38141 L p .65 .603 .788 r
F P
0 g
s
.62018 .6228 m .58515 .62723 L .58067 .68185 L p .649 .452 .604 r
F P
0 g
s
.57248 .58544 m .60761 .58189 L .60018 .62835 L p .651 .447 .594 r
F P
0 g
s
.60018 .62835 m .56956 .63252 L .57248 .58544 L p .651 .447 .594 r
F P
0 g
s
.65452 .49459 m .68403 .48927 L .67111 .4301 L p .617 .522 .724 r
F P
0 g
s
.67111 .4301 m .64446 .43419 L .65452 .49459 L p .617 .522 .724 r
F P
0 g
s
.42277 .58634 m .45989 .58819 L .47115 .63851 L p .739 .521 .597 r
F P
0 g
s
.50431 .63764 m .47115 .63851 L .45989 .58819 L p .718 .506 .601 r
F P
0 g
s
.3431 .51267 m .37782 .51913 L .38733 .58312 L p .791 .595 .636 r
F P
0 g
s
.42277 .58634 m .38733 .58312 L .37782 .51913 L p .767 .578 .642 r
F P
0 g
s
.64446 .43419 m .67111 .4301 L .65037 .37697 L p .616 .553 .761 r
F P
0 g
s
.65037 .37697 m .62828 .37946 L .64446 .43419 L p .616 .553 .761 r
F P
0 g
s
.60339 .38099 m .62828 .37946 L .6073 .33368 L p .629 .594 .795 r
F P
0 g
s
.6073 .33368 m .5889 .33356 L .60339 .38099 L p .629 .594 .795 r
F P
0 g
s
.65251 .61724 m .62018 .6228 L .61125 .67697 L p .62 .425 .596 r
F P
0 g
s
.60761 .58189 m .64025 .57715 L .62855 .62319 L p .622 .418 .585 r
F P
0 g
s
.58067 .68185 m .61125 .67697 L .62018 .6228 L p .649 .452 .604 r
F P
0 g
s
.62855 .62319 m .60018 .62835 L .60761 .58189 L p .622 .418 .585 r
F P
0 g
s
.38733 .58312 m .42277 .58634 L .43868 .63824 L p .762 .535 .589 r
F P
0 g
s
.47115 .63851 m .43868 .63824 L .42277 .58634 L p .739 .521 .597 r
F P
0 g
s
.62828 .37946 m .65037 .37697 L .62356 .33308 L p .603 .585 .805 r
F P
0 g
s
.62356 .33308 m .6073 .33368 L .62828 .37946 L p .603 .585 .805 r
F P
0 g
s
.68403 .48927 m .70938 .48292 L .69391 .42505 L p .585 .501 .727 r
F P
0 g
s
.69391 .42505 m .67111 .4301 L .68403 .48927 L p .585 .501 .727 r
F P
0 g
s
.68145 .61065 m .65251 .61724 L .63946 .67117 L p .584 .388 .582 r
F P
0 g
s
.64025 .57715 m .66967 .57132 L .65404 .61713 L p .585 .38 .569 r
F P
0 g
s
.61125 .67697 m .63946 .67117 L .65251 .61724 L p .62 .425 .596 r
F P
0 g
s
.65404 .61713 m .62855 .62319 L .64025 .57715 L p .585 .38 .569 r
F P
0 g
s
.67111 .4301 m .69391 .42505 L .66917 .37367 L p .585 .538 .769 r
F P
0 g
s
.66917 .37367 m .65037 .37697 L .67111 .4301 L p .585 .538 .769 r
F P
0 g
s
.3121 .50475 m .3431 .51267 L .35449 .57855 L p .82 .615 .625 r
F P
0 g
s
.38733 .58312 m .35449 .57855 L .3431 .51267 L p .791 .595 .636 r
F P
0 g
s
.35449 .57855 m .38733 .58312 L .40771 .63685 L p .786 .549 .577 r
F P
0 g
s
.43868 .63824 m .40771 .63685 L .38733 .58312 L p .762 .535 .589 r
F P
0 g
s
.56876 .33259 m .5889 .33356 L .57216 .29769 L p .605 .619 .839 r
F P
0 g
s
.57216 .29769 m .56012 .29532 L .56876 .33259 L p .605 .619 .839 r
F P
0 g
s
.50431 .63764 m .53736 .63563 L .5398 .67023 L p .674 .417 .525 r
F P
0 g
s
.53736 .63563 m .56956 .63252 L .56521 .66644 L p .648 .392 .518 r
F P
0 g
s
.56521 .66644 m .5398 .67023 L .53736 .63563 L p .648 .392 .518 r
F P
0 g
s
.47115 .63851 m .50431 .63764 L .51367 .6732 L p .697 .437 .526 r
F P
0 g
s
.5398 .67023 m .51367 .6732 L .50431 .63764 L p .674 .417 .525 r
F P
0 g
s
.65037 .37697 m .66917 .37367 L .6373 .33186 L p .57 .575 .819 r
F P
0 g
s
.6373 .33186 m .62356 .33308 L .65037 .37697 L p .57 .575 .819 r
F P
0 g
s
.56956 .63252 m .60018 .62835 L .58933 .66184 L p .616 .358 .504 r
F P
0 g
s
.58933 .66184 m .56521 .66644 L .56956 .63252 L p .616 .358 .504 r
F P
0 g
s
.5889 .33356 m .6073 .33368 L .58312 .29954 L p .575 .615 .855 r
F P
0 g
s
.58312 .29954 m .57216 .29769 L .5889 .33356 L p .575 .615 .855 r
F P
0 g
s
.43868 .63824 m .47115 .63851 L .48746 .6753 L p .72 .453 .521 r
F P
0 g
s
.51367 .6732 m .48746 .6753 L .47115 .63851 L p .697 .437 .526 r
F P
0 g
s
.66967 .57132 m .69527 .56453 L .67611 .61028 L p .534 .325 .543 r
F P
0 g
s
.67611 .61028 m .65404 .61713 L .66967 .57132 L p .534 .325 .543 r
F P
0 g
s
.60018 .62835 m .62855 .62319 L .6116 .65649 L p .576 .312 .479 r
F P
0 g
s
.6116 .65649 m .58933 .66184 L .60018 .62835 L p .576 .312 .479 r
F P
0 g
s
.70938 .48292 m .73001 .47573 L .71238 .41922 L p .539 .474 .731 r
F P
0 g
s
.71238 .41922 m .69391 .42505 L .70938 .48292 L p .539 .474 .731 r
F P
0 g
s
.69391 .42505 m .71238 .41922 L .68429 .36971 L p .543 .519 .779 r
F P
0 g
s
.68429 .36971 m .66917 .37367 L .69391 .42505 L p .543 .519 .779 r
F P
0 g
s
.6073 .33368 m .62356 .33308 L .59275 .30096 L p .534 .61 .875 r
F P
0 g
s
.59275 .30096 m .58312 .29954 L .6073 .33368 L p .534 .61 .875 r
F P
0 g
s
.61125 .67697 m .58067 .68185 L .57336 .72521 L p .624 .377 .524 r
F P
0 g
s
.40771 .63685 m .43868 .63824 L .4618 .67655 L p .742 .464 .51 r
F P
0 g
s
.48746 .6753 m .4618 .67655 L .43868 .63824 L p .72 .453 .521 r
F P
0 g
s
.35449 .57855 m .32518 .57271 L .3121 .50475 L p .82 .615 .625 r
F P
0 g
s
.32518 .57271 m .35449 .57855 L .37906 .63437 L p .816 .562 .555 r
F P
0 g
s
.40771 .63685 m .37906 .63437 L .35449 .57855 L p .786 .549 .577 r
F P
0 g
s
.63946 .67117 m .66467 .66452 L .68145 .61065 L p .584 .388 .582 r
F P
0 g
s
.70635 .60315 m .68145 .61065 L .66467 .66452 L p .533 .336 .559 r
F P
0 g
s
.66917 .37367 m .68429 .36971 L .64826 .33017 L p .525 .564 .837 r
F P
0 g
s
.64826 .33017 m .6373 .33186 L .66917 .37367 L p .525 .564 .837 r
F P
0 g
s
.28578 .49548 m .3121 .50475 L .32518 .57271 L p .857 .639 .606 r
F P
0 g
s
.57336 .72521 m .59683 .72015 L .61125 .67697 L p .624 .377 .524 r
F P
0 g
s
.63946 .67117 m .61125 .67697 L .59683 .72015 L p .587 .337 .505 r
F P
0 g
s
.62855 .62319 m .65404 .61713 L .63152 .65047 L p .519 .243 .436 r
F P
0 g
s
.63152 .65047 m .6116 .65649 L .62855 .62319 L p .519 .243 .436 r
F P
0 g
s
.62356 .33308 m .6373 .33186 L .60083 .30202 L p .475 .603 .9 r
F P
0 g
s
.60083 .30202 m .59275 .30096 L .62356 .33308 L p .475 .603 .9 r
F P
0 g
s
.69527 .56453 m .71646 .55694 L .69428 .60278 L p .452 .237 .495 r
F P
0 g
s
.69428 .60278 m .67611 .61028 L .69527 .56453 L p .452 .237 .495 r
F P
0 g
s
.37906 .63437 m .40771 .63685 L .43737 .67695 L p .765 .472 .489 r
F P
0 g
s
.4618 .67655 m .43737 .67695 L .40771 .63685 L p .742 .464 .51 r
F P
0 g
s
.59683 .72015 m .61845 .71441 L .63946 .67117 L p .587 .337 .505 r
F P
0 g
s
.66467 .66452 m .63946 .67117 L .61845 .71441 L p .537 .279 .472 r
F P
0 g
s
.72612 .41283 m .71238 .41922 L .73001 .47573 L p .47 .433 .734 r
F P
0 g
s
.71238 .41922 m .72612 .41283 L .69541 .3653 L p .479 .492 .793 r
F P
0 g
s
.69541 .3653 m .68429 .36971 L .71238 .41922 L p .479 .492 .793 r
F P
0 g
s
.56012 .29532 m .57216 .29769 L .55439 .27549 L p .072 .329 .807 r
F P
0 g
s
.55439 .27549 m .55094 .27182 L .56012 .29532 L p .072 .329 .807 r
F P
0 g
s
.73001 .47573 m .74547 .46791 L .72612 .41283 L p .47 .433 .734 r
F P
0 g
s
.65404 .61713 m .67611 .61028 L .64867 .64386 L p .428 .133 .36 r
F P
0 g
s
.64867 .64386 m .63152 .65047 L .65404 .61713 L p .428 .133 .36 r
F P
0 g
s
.6373 .33186 m .64826 .33017 L .6072 .30281 L p .382 .589 .925 r
F P
0 g
s
.6072 .30281 m .60083 .30202 L .6373 .33186 L p .382 .589 .925 r
F P
0 g
s
.66467 .66452 m .68634 .65713 L .70635 .60315 L p .533 .336 .559 r
F P
0 g
s
.72668 .5949 m .70635 .60315 L .68634 .65713 L p .453 .252 .517 r
F P
0 g
s
.68429 .36971 m .69541 .3653 L .6562 .32816 L p .456 .547 .86 r
F P
0 g
s
.6562 .32816 m .64826 .33017 L .68429 .36971 L p .456 .547 .86 r
F P
0 g
s
.57216 .29769 m .58312 .29954 L .55752 .27901 L p 0 .018 .552 r
F P
0 g
s
.56025 .2824 m .55752 .27901 L .58085 .29772 L p .813 .33 0 r
F P
0 g
s
.56025 .2824 m .58085 .29772 L .58079 .2977 L .813 .33 0 r
F
.58059 .29765 m .58125 .29804 L .58072 .29774 L F
.56025 .2824 m .58076 .29767 L .58059 .29765 L F
.58076 .29767 m .58125 .29804 L .58059 .29765 L F
.58312 .29954 m .59275 .30096 L .59135 .30016 L p F P
0 g
s
.59135 .30016 m .56025 .2824 L p .58072 .29774 L .813 .33 0 r
F P
0 g
s
.58085 .29772 m .58125 .29804 L p .58079 .2977 L .813 .33 0 r
F P
0 g
s
.58125 .29804 m .58312 .29954 L p .58072 .29774 L .813 .33 0 r
F P
0 g
s
.58072 .29774 m .58312 .29954 L .59135 .30016 L .813 .33 0 r
F
.55752 .27901 m .55439 .27549 L .57083 .29602 L p 0 .018 .552 r
F P
0 g
s
.55752 .27901 m .57083 .29602 L .57059 .29567 L 0 .018 .552 r
F
.56252 .2857 m .56025 .2824 L .59275 .30096 L p .859 .458 .276 r
F P
0 g
s
.59275 .30096 m .60083 .30202 L .56402 .28634 L p .859 .458 .276 r
F P
0 g
s
.56415 .28652 m .59275 .30096 L .56402 .28634 L .859 .458 .276 r
F
.56402 .28634 m .56252 .2857 L p .56415 .28652 L F P
0 g
s
.5643 .28893 m .56252 .2857 L .60083 .30202 L p .83 .491 .413 r
F P
0 g
s
.60083 .30202 m .6072 .30281 L .56597 .28947 L p .83 .491 .413 r
F P
0 g
s
.56626 .28963 m .60083 .30202 L .56597 .28947 L .83 .491 .413 r
F
.56597 .28947 m .5643 .28893 L p .56626 .28963 L F P
0 g
s
.56554 .29211 m .5643 .28893 L .6072 .30281 L p .797 .497 .481 r
F P
0 g
s
.6072 .30281 m .61175 .30342 L .56862 .29286 L p .797 .497 .481 r
F P
0 g
s
.56888 .29297 m .6072 .30281 L .56862 .29286 L .797 .497 .481 r
F
.64826 .33017 m .6562 .32816 L .61175 .30342 L p .223 .549 .93 r
F P
0 g
s
.61175 .30342 m .6072 .30281 L .64826 .33017 L p .223 .549 .93 r
F P
0 g
s
.61442 .30394 m .61175 .30342 L .64326 .32096 L p 0 .439 .845 r
F P
0 g
s
.64326 .32096 m .6562 .32816 L p .63962 .31855 L 0 .439 .845 r
F P
0 g
s
.61442 .30394 m .64326 .32096 L .63962 .31855 L 0 .439 .845 r
F
.66101 .32598 m .66264 .32378 L .62338 .30781 L p .359 0 0 r
F P
0 g
s
.6562 .32816 m .66101 .32598 L .61442 .30394 L p 0 .439 .845 r
F P
0 g
s
.61519 .30448 m .61442 .30394 L .66101 .32598 L p .359 0 0 r
F P
0 g
s
.62338 .30781 m .61519 .30448 L p .62604 .30957 L .359 0 0 r
F P
0 g
s
.62604 .30957 m .66101 .32598 L .62338 .30781 L .359 0 0 r
F
.61175 .30342 m .61442 .30394 L .5711 .29615 L p .768 .493 .519 r
F P
0 g
s
.57083 .29602 m .57216 .29769 L p .57059 .29567 L 0 .018 .552 r
F P
0 g
s
.5711 .29615 m .56625 .29527 L p .57134 .29618 L .768 .493 .519 r
F P
0 g
s
.57134 .29618 m .61175 .30342 L .5711 .29615 L .768 .493 .519 r
F
.56862 .29286 m .56554 .29211 L p .56888 .29297 L .797 .497 .481 r
F P
0 g
s
.32518 .57271 m .30033 .56571 L .28578 .49548 L p .857 .639 .606 r
F P
0 g
s
.30033 .56571 m .32518 .57271 L .35355 .63086 L p .852 .574 .517 r
F P
0 g
s
.37906 .63437 m .35355 .63086 L .32518 .57271 L p .816 .562 .555 r
F P
0 g
s
.51367 .6732 m .5398 .67023 L .54274 .68937 L p .592 .253 .363 r
F P
0 g
s
.5398 .67023 m .56521 .66644 L .55977 .68511 L p .545 .196 .326 r
F P
0 g
s
.55977 .68511 m .54274 .68937 L .5398 .67023 L p .545 .196 .326 r
F P
0 g
s
.48746 .6753 m .51367 .6732 L .52521 .69308 L p .628 .291 .382 r
F P
0 g
s
.54274 .68937 m .52521 .69308 L .51367 .6732 L p .592 .253 .363 r
F P
0 g
s
.56521 .66644 m .58933 .66184 L .57589 .68032 L p .477 .109 .262 r
F P
0 g
s
.57589 .68032 m .55977 .68511 L .56521 .66644 L p .477 .109 .262 r
F P
0 g
s
.35355 .63086 m .37906 .63437 L .41482 .67656 L p .791 .475 .453 r
F P
0 g
s
.43737 .67695 m .41482 .67656 L .37906 .63437 L p .765 .472 .489 r
F P
0 g
s
.71646 .55694 m .7328 .54872 L .70816 .59476 L p .303 .077 .396 r
F P
0 g
s
.70816 .59476 m .69428 .60278 L .71646 .55694 L p .303 .077 .396 r
F P
0 g
s
.61845 .71441 m .63772 .70806 L .66467 .66452 L p .537 .279 .472 r
F P
0 g
s
.68634 .65713 m .66467 .66452 L .63772 .70806 L p .461 .189 .415 r
F P
0 g
s
.4618 .67655 m .48746 .6753 L .50761 .69624 L p .656 .318 .387 r
F P
0 g
s
.52521 .69308 m .50761 .69624 L .48746 .6753 L p .628 .291 .382 r
F P
0 g
s
.2651 .48499 m .28578 .49548 L .30033 .56571 L p .907 .669 .568 r
F P
0 g
s
.58933 .66184 m .6116 .65649 L .59072 .67505 L p .369 0 .149 r
F P
0 g
s
.59072 .67505 m .57589 .68032 L .58933 .66184 L p .369 0 .149 r
F P
0 g
s
.67611 .61028 m .69428 .60278 L .66268 .63675 L p .262 0 .212 r
F P
0 g
s
.66268 .63675 m .64867 .64386 L .67611 .61028 L p .262 0 .212 r
F P
0 g
s
.51898 .39845 m .53159 .40181 L .5285 .43182 L p .704 .596 .733 r
F P
0 g
s
.5285 .43182 m .51333 .4293 L .51898 .39845 L p .704 .596 .733 r
F P
0 g
s
.54306 .43368 m .5285 .43182 L .53159 .40181 L p .685 .581 .733 r
F P
0 g
s
.51333 .4293 m .5285 .43182 L .52725 .4608 L p .709 .576 .703 r
F P
0 g
s
.5285 .43182 m .54306 .43368 L .54284 .46158 L p .69 .559 .702 r
F P
0 g
s
.54284 .46158 m .52725 .4608 L .5285 .43182 L p .69 .559 .702 r
F P
0 g
s
.50627 .3945 m .51898 .39845 L .51333 .4293 L p .721 .612 .735 r
F P
0 g
s
.51333 .4293 m .49797 .42608 L .50627 .3945 L p .721 .612 .735 r
F P
0 g
s
.49797 .42608 m .51333 .4293 L .51092 .45933 L p .728 .593 .705 r
F P
0 g
s
.52725 .4608 m .51092 .45933 L .51333 .4293 L p .709 .576 .703 r
F P
0 g
s
.51092 .45933 m .52725 .4608 L .52771 .48662 L p .709 .55 .671 r
F P
0 g
s
.52725 .4608 m .54284 .46158 L .54302 .48626 L p .687 .531 .669 r
F P
0 g
s
.54302 .48626 m .52771 .48662 L .52725 .4608 L p .687 .531 .669 r
F P
0 g
s
.51092 .45933 m .49431 .45712 L .49797 .42608 L p .728 .593 .705 r
F P
0 g
s
.49431 .45712 m .51092 .45933 L .51157 .48632 L p .729 .567 .671 r
F P
0 g
s
.52771 .48662 m .51157 .48632 L .51092 .45933 L p .709 .55 .671 r
F P
0 g
s
.43737 .67695 m .4618 .67655 L .4904 .69883 L p .68 .334 .38 r
F P
0 g
s
.50761 .69624 m .4904 .69883 L .4618 .67655 L p .656 .318 .387 r
F P
0 g
s
.53159 .40181 m .54374 .40461 L .54306 .43368 L p .685 .581 .733 r
F P
0 g
s
.55663 .43494 m .54306 .43368 L .54374 .40461 L p .665 .566 .733 r
F P
0 g
s
.54306 .43368 m .55663 .43494 L .55727 .46174 L p .669 .542 .701 r
F P
0 g
s
.55727 .46174 m .54284 .46158 L .54306 .43368 L p .669 .542 .701 r
F P
0 g
s
.73483 .40607 m .72612 .41283 L .74547 .46791 L p .348 .36 .731 r
F P
0 g
s
.72612 .41283 m .73483 .40607 L .70233 .36061 L p .371 .445 .808 r
F P
0 g
s
.70233 .36061 m .69541 .3653 L .72612 .41283 L p .371 .445 .808 r
F P
0 g
s
.49384 .38992 m .50627 .3945 L .49797 .42608 L p .739 .629 .737 r
F P
0 g
s
.49797 .42608 m .48288 .42213 L .49384 .38992 L p .739 .629 .737 r
F P
0 g
s
.48288 .42213 m .49797 .42608 L .49431 .45712 L p .748 .61 .706 r
F P
0 g
s
.54284 .46158 m .55727 .46174 L .55711 .4853 L p .664 .511 .667 r
F P
0 g
s
.55711 .4853 m .54302 .48626 L .54284 .46158 L p .664 .511 .667 r
F P
0 g
s
.49431 .45712 m .47791 .45415 L .48288 .42213 L p .748 .61 .706 r
F P
0 g
s
.47791 .45415 m .49431 .45712 L .49507 .4853 L p .75 .585 .671 r
F P
0 g
s
.51157 .48632 m .49507 .4853 L .49431 .45712 L p .729 .567 .671 r
F P
0 g
s
.69541 .3653 m .70233 .36061 L .66101 .32598 L p .34 .515 .883 r
F P
0 g
s
.66101 .32598 m .6562 .32816 L .69541 .3653 L p .34 .515 .883 r
F P
0 g
s
.6116 .65649 m .63152 .65047 L .60392 .66934 L p .179 0 0 r
F P
0 g
s
.60392 .66934 m .59072 .67505 L .6116 .65649 L p .179 0 0 r
F P
0 g
s
.54374 .40461 m .55512 .4069 L .55663 .43494 L p .665 .566 .733 r
F P
0 g
s
.56886 .43568 m .55663 .43494 L .55512 .4069 L p .642 .549 .734 r
F P
0 g
s
.55663 .43494 m .56886 .43568 L .57021 .46137 L p .644 .522 .7 r
F P
0 g
s
.57021 .46137 m .55727 .46174 L .55663 .43494 L p .644 .522 .7 r
F P
0 g
s
.52778 .36931 m .53647 .37324 L .53159 .40181 L p .689 .61 .763 r
F P
0 g
s
.53159 .40181 m .51898 .39845 L .52778 .36931 L p .689 .61 .763 r
F P
0 g
s
.54374 .40461 m .53159 .40181 L .53647 .37324 L p .671 .597 .764 r
F P
0 g
s
.51907 .36496 m .52778 .36931 L .51898 .39845 L p .706 .624 .764 r
F P
0 g
s
.51898 .39845 m .50627 .3945 L .51907 .36496 L p .706 .624 .764 r
F P
0 g
s
.59683 .72015 m .57336 .72521 L .56347 .75307 L p .538 .196 .337 r
F P
0 g
s
.55727 .46174 m .57021 .46137 L .56963 .48383 L p .637 .487 .662 r
F P
0 g
s
.56963 .48383 m .55711 .4853 L .55727 .46174 L p .637 .487 .662 r
F P
0 g
s
.48208 .38472 m .49384 .38992 L .48288 .42213 L p .757 .648 .74 r
F P
0 g
s
.48288 .42213 m .46852 .41745 L .48208 .38472 L p .757 .648 .74 r
F P
0 g
s
.46852 .41745 m .48288 .42213 L .47791 .45415 L p .768 .63 .707 r
F P
0 g
s
.68634 .65713 m .70399 .64911 L .72668 .5949 L p .453 .252 .517 r
F P
0 g
s
.74198 .58606 m .72668 .5949 L .70399 .64911 L p .306 .101 .429 r
F P
0 g
s
.72668 .5949 m .74198 .58606 L .75124 .52702 L p .399 .265 .58 r
F P
0 g
s
.51157 .48632 m .52771 .48662 L .52965 .50755 L p .701 .513 .631 r
F P
0 g
s
.52771 .48662 m .54302 .48626 L .54356 .50606 L p .677 .491 .628 r
F P
0 g
s
.54356 .50606 m .52965 .50755 L .52771 .48662 L p .677 .491 .628 r
F P
0 g
s
.53647 .37324 m .54487 .37677 L .54374 .40461 L p .671 .597 .764 r
F P
0 g
s
.55512 .4069 m .54374 .40461 L .54487 .37677 L p .651 .583 .766 r
F P
0 g
s
.49507 .4853 m .51157 .48632 L .5149 .50845 L p .723 .532 .631 r
F P
0 g
s
.52965 .50755 m .5149 .50845 L .51157 .48632 L p .701 .513 .631 r
F P
0 g
s
.51059 .36018 m .51907 .36496 L .50627 .3945 L p .722 .639 .766 r
F P
0 g
s
.50627 .3945 m .49384 .38992 L .51059 .36018 L p .722 .639 .766 r
F P
0 g
s
.47791 .45415 m .46223 .45039 L .46852 .41745 L p .768 .63 .707 r
F P
0 g
s
.46223 .45039 m .47791 .45415 L .4787 .48354 L p .773 .604 .67 r
F P
0 g
s
.49507 .4853 m .4787 .48354 L .47791 .45415 L p .75 .585 .671 r
F P
0 g
s
.54302 .48626 m .55711 .4853 L .55625 .50404 L p .65 .466 .621 r
F P
0 g
s
.55625 .50404 m .54356 .50606 L .54302 .48626 L p .65 .466 .621 r
F P
0 g
s
.4787 .48354 m .49507 .4853 L .49972 .5087 L p .746 .55 .629 r
F P
0 g
s
.5149 .50845 m .49972 .5087 L .49507 .4853 L p .723 .532 .631 r
F P
0 g
s
.55512 .4069 m .56545 .40874 L .56886 .43568 L p .642 .549 .734 r
F P
0 g
s
.57949 .436 m .56886 .43568 L .56545 .40874 L p .614 .53 .736 r
F P
0 g
s
.56886 .43568 m .57949 .436 L .58135 .46055 L p .614 .499 .699 r
F P
0 g
s
.58135 .46055 m .57021 .46137 L .56886 .43568 L p .614 .499 .699 r
F P
0 g
s
.54487 .37677 m .55278 .37995 L .55512 .4069 L p .651 .583 .766 r
F P
0 g
s
.56545 .40874 m .55512 .4069 L .55278 .37995 L p .627 .569 .77 r
F P
0 g
s
.63772 .70806 m .65423 .70116 L .68634 .65713 L p .461 .189 .415 r
F P
0 g
s
.70399 .64911 m .68634 .65713 L .65423 .70116 L p .328 .035 .306 r
F P
0 g
s
.50261 .35496 m .51059 .36018 L .49384 .38992 L p .737 .656 .769 r
F P
0 g
s
.49384 .38992 m .48208 .38472 L .50261 .35496 L p .737 .656 .769 r
F P
0 g
s
.57021 .46137 m .58135 .46055 L .58029 .48195 L p .603 .456 .655 r
F P
0 g
s
.58029 .48195 m .56963 .48383 L .57021 .46137 L p .603 .456 .655 r
F P
0 g
s
.56347 .75307 m .57741 .74811 L .59683 .72015 L p .538 .196 .337 r
F P
0 g
s
.61845 .71441 m .59683 .72015 L .57741 .74811 L p .469 .11 .272 r
F P
0 g
s
.41482 .67656 m .43737 .67695 L .47405 .70089 L p .702 .34 .359 r
F P
0 g
s
.4904 .69883 m .47405 .70089 L .43737 .67695 L p .68 .334 .38 r
F P
0 g
s
.55711 .4853 m .56963 .48383 L .56742 .50157 L p .616 .433 .611 r
F P
0 g
s
.56742 .50157 m .55625 .50404 L .55711 .4853 L p .616 .433 .611 r
F P
0 g
s
.47138 .37891 m .48208 .38472 L .46852 .41745 L p .777 .67 .745 r
F P
0 g
s
.46852 .41745 m .45538 .41203 L .47138 .37891 L p .777 .67 .745 r
F P
0 g
s
.45538 .41203 m .46852 .41745 L .46223 .45039 L p .792 .653 .709 r
F P
0 g
s
.35355 .63086 m .33199 .62643 L .30033 .56571 L p .852 .574 .517 r
F P
0 g
s
.33199 .62643 m .35355 .63086 L .39484 .67541 L p .819 .467 .391 r
F P
0 g
s
.41482 .67656 m .39484 .67541 L .35355 .63086 L p .791 .475 .453 r
F P
0 g
s
.4787 .48354 m .46298 .48102 L .46223 .45039 L p .773 .604 .67 r
F P
0 g
s
.46298 .48102 m .4787 .48354 L .48459 .50828 L p .77 .568 .625 r
F P
0 g
s
.49972 .5087 m .48459 .50828 L .4787 .48354 L p .746 .55 .629 r
F P
0 g
s
.55278 .37995 m .55998 .3828 L .56545 .40874 L p .627 .569 .77 r
F P
0 g
s
.57448 .4102 m .56545 .40874 L .55998 .3828 L p .596 .553 .776 r
F P
0 g
s
.56545 .40874 m .57448 .4102 L .57949 .436 L p .614 .53 .736 r
F P
0 g
s
.30033 .56571 m .28082 .55767 L .2651 .48499 L p .907 .669 .568 r
F P
0 g
s
.28082 .55767 m .30033 .56571 L .33199 .62643 L p .896 .581 .442 r
F P
0 g
s
.46223 .45039 m .44781 .44586 L .45538 .41203 L p .792 .653 .709 r
F P
0 g
s
.44781 .44586 m .46223 .45039 L .46298 .48102 L p .799 .626 .667 r
F P
0 g
s
.63152 .65047 m .64867 .64386 L .6152 .66326 L p 0 0 0 r
F P
0 g
s
.6152 .66326 m .60392 .66934 L .63152 .65047 L p 0 0 0 r
F P
0 g
s
.76164 .51796 m .75124 .52702 L .74198 .58606 L p .191 .08 .489 r
F P
0 g
s
.69428 .60278 m .70816 .59476 L .67326 .62927 L p 0 0 0 r
F P
0 g
s
.67326 .62927 m .66268 .63675 L .69428 .60278 L p 0 0 0 r
F P
0 g
s
.4954 .34932 m .50261 .35496 L .48208 .38472 L p .754 .675 .775 r
F P
0 g
s
.48208 .38472 m .47138 .37891 L .4954 .34932 L p .754 .675 .775 r
F P
0 g
s
.7328 .54872 m .74393 .54005 L .71748 .58638 L p 0 0 .151 r
F P
0 g
s
.71748 .58638 m .70816 .59476 L .7328 .54872 L p 0 0 .151 r
F P
0 g
s
.5883 .43597 m .57949 .436 L .57448 .4102 L p .576 .505 .739 r
F P
0 g
s
.57949 .436 m .5883 .43597 L .59047 .45938 L p .574 .468 .696 r
F P
0 g
s
.59047 .45938 m .58135 .46055 L .57949 .436 L p .574 .468 .696 r
F P
0 g
s
.56963 .48383 m .58029 .48195 L .5768 .49874 L p .571 .387 .593 r
F P
0 g
s
.5768 .49874 m .56742 .50157 L .56963 .48383 L p .571 .387 .593 r
F P
0 g
s
.58135 .46055 m .59047 .45938 L .5889 .47974 L p .555 .413 .643 r
F P
0 g
s
.5889 .47974 m .58029 .48195 L .58135 .46055 L p .555 .413 .643 r
F P
0 g
s
.5149 .50845 m .52965 .50755 L .53274 .52243 L p .678 .454 .574 r
F P
0 g
s
.52965 .50755 m .54356 .50606 L .54436 .5199 L p .648 .424 .565 r
F P
0 g
s
.54436 .5199 m .53274 .52243 L .52965 .50755 L p .648 .424 .565 r
F P
0 g
s
.53585 .34019 m .5394 .34454 L .52778 .36931 L p .673 .621 .789 r
F P
0 g
s
.52778 .36931 m .51907 .36496 L .53585 .34019 L p .673 .621 .789 r
F P
0 g
s
.53647 .37324 m .52778 .36931 L .5394 .34454 L p .655 .609 .791 r
F P
0 g
s
.49972 .5087 m .5149 .50845 L .52032 .52446 L p .704 .477 .577 r
F P
0 g
s
.53274 .52243 m .52032 .52446 L .5149 .50845 L p .678 .454 .574 r
F P
0 g
s
.5394 .34454 m .54296 .34872 L .53647 .37324 L p .655 .609 .791 r
F P
0 g
s
.54487 .37677 m .53647 .37324 L .54296 .34872 L p .633 .597 .796 r
F P
0 g
s
.53241 .33566 m .53585 .34019 L .51907 .36496 L p .689 .633 .788 r
F P
0 g
s
.51907 .36496 m .51059 .36018 L .53241 .33566 L p .689 .633 .788 r
F P
0 g
s
.54296 .34872 m .54641 .35273 L .54487 .37677 L p .633 .597 .796 r
F P
0 g
s
.55278 .37995 m .54487 .37677 L .54641 .35273 L p .607 .585 .803 r
F P
0 g
s
.54356 .50606 m .55625 .50404 L .55486 .51694 L p .611 .385 .549 r
F P
0 g
s
.55486 .51694 m .54436 .5199 L .54356 .50606 L p .611 .385 .549 r
F P
0 g
s
.55998 .3828 m .56631 .38539 L .57448 .4102 L p .596 .553 .776 r
F P
0 g
s
.58203 .41137 m .57448 .4102 L .56631 .38539 L p .553 .532 .785 r
F P
0 g
s
.57448 .4102 m .58203 .41137 L .5883 .43597 L p .576 .505 .739 r
F P
0 g
s
.57741 .74811 m .59022 .74276 L .61845 .71441 L p .469 .11 .272 r
F P
0 g
s
.63772 .70806 m .61845 .71441 L .59022 .74276 L p .36 0 .161 r
F P
0 g
s
.48459 .50828 m .49972 .5087 L .50745 .52595 L p .729 .496 .575 r
F P
0 g
s
.52032 .52446 m .50745 .52595 L .49972 .5087 L p .704 .477 .577 r
F P
0 g
s
.46214 .37253 m .47138 .37891 L .45538 .41203 L p .8 .697 .751 r
F P
0 g
s
.45538 .41203 m .44395 .40593 L .46214 .37253 L p .8 .697 .751 r
F P
0 g
s
.44395 .40593 m .45538 .41203 L .44781 .44586 L p .82 .682 .711 r
F P
0 g
s
.52919 .33095 m .53241 .33566 L .51059 .36018 L p .704 .646 .789 r
F P
0 g
s
.51059 .36018 m .50261 .35496 L .52919 .33095 L p .704 .646 .789 r
F P
0 g
s
.46298 .48102 m .44845 .47774 L .44781 .44586 L p .799 .626 .667 r
F P
0 g
s
.44845 .47774 m .46298 .48102 L .46999 .50718 L p .798 .587 .616 r
F P
0 g
s
.48459 .50828 m .46999 .50718 L .46298 .48102 L p .77 .568 .625 r
F P
0 g
s
.55094 .27182 m .55439 .27549 L .53689 .26818 L p .847 .949 .883 r
F P
0 g
s
.53689 .26818 m .5419 .26346 L .55094 .27182 L p .847 .949 .883 r
F P
0 g
s
.54641 .35273 m .54968 .35659 L .55278 .37995 L p .607 .585 .803 r
F P
0 g
s
.55998 .3828 m .55278 .37995 L .54968 .35659 L p .572 .571 .813 r
F P
0 g
s
.56625 .29527 m .56554 .29211 L .61175 .30342 L p .768 .493 .519 r
F P
0 g
s
.48922 .34329 m .4954 .34932 L .47138 .37891 L p .771 .698 .782 r
F P
0 g
s
.47138 .37891 m .46214 .37253 L .48922 .34329 L p .771 .698 .782 r
F P
0 g
s
.55439 .27549 m .55752 .27901 L .53237 .27312 L p .847 .879 .863 r
F P
0 g
s
.53237 .27312 m .53689 .26818 L .55439 .27549 L p .847 .879 .863 r
F P
0 g
s
.55625 .50404 m .56742 .50157 L .56399 .51362 L p .559 .326 .519 r
F P
0 g
s
.56399 .51362 m .55486 .51694 L .55625 .50404 L p .559 .326 .519 r
F P
0 g
s
.70493 .35586 m .70233 .36061 L .73483 .40607 L p .156 .344 .801 r
F P
0 g
s
.70233 .36061 m .70493 .35586 L .66264 .32378 L p .123 .437 .875 r
F P
0 g
s
.66264 .32378 m .66101 .32598 L .70233 .36061 L p .123 .437 .875 r
F P
0 g
s
.59514 .43571 m .5883 .43597 L .58203 .41137 L p .52 .471 .742 r
F P
0 g
s
.5883 .43597 m .59514 .43571 L .59744 .45799 L p .514 .422 .689 r
F P
0 g
s
.59744 .45799 m .59047 .45938 L .5883 .43597 L p .514 .422 .689 r
F P
0 g
s
.44781 .44586 m .43519 .4406 L .44395 .40593 L p .82 .682 .711 r
F P
0 g
s
.43519 .4406 m .44781 .44586 L .44845 .47774 L p .831 .653 .662 r
F P
0 g
s
.58029 .48195 m .5889 .47974 L .58423 .49564 L p .5 .313 .559 r
F P
0 g
s
.58423 .49564 m .5768 .49874 L .58029 .48195 L p .5 .313 .559 r
F P
0 g
s
.5263 .32607 m .52919 .33095 L .50261 .35496 L p .718 .661 .792 r
F P
0 g
s
.50261 .35496 m .4954 .34932 L .5263 .32607 L p .718 .661 .792 r
F P
0 g
s
.46999 .50718 m .48459 .50828 L .49455 .52688 L p .754 .513 .567 r
F P
0 g
s
.50745 .52595 m .49455 .52688 L .48459 .50828 L p .729 .496 .575 r
F P
0 g
s
.54968 .35659 m .55266 .36033 L .55998 .3828 L p .572 .571 .813 r
F P
0 g
s
.56631 .38539 m .55998 .3828 L .55266 .36033 L p .522 .552 .828 r
F P
0 g
s
.55752 .27901 m .56025 .2824 L .52846 .27824 L p .83 .82 .839 r
F P
0 g
s
.52846 .27824 m .53237 .27312 L .55752 .27901 L p .83 .82 .839 r
F P
0 g
s
.73483 .40607 m .73838 .39919 L .70493 .35586 L p .156 .344 .801 r
F P
0 g
s
.39484 .67541 m .41482 .67656 L .45902 .70243 L p .72 .336 .32 r
F P
0 g
s
.47405 .70089 m .45902 .70243 L .41482 .67656 L p .702 .34 .359 r
F P
0 g
s
.59047 .45938 m .59744 .45799 L .59532 .47734 L p .477 .343 .619 r
F P
0 g
s
.59532 .47734 m .5889 .47974 L .59047 .45938 L p .477 .343 .619 r
F P
0 g
s
.56631 .38539 m .57165 .38776 L .58203 .41137 L p .553 .532 .785 r
F P
0 g
s
.58796 .41234 m .58203 .41137 L .57165 .38776 L p .488 .502 .797 r
F P
0 g
s
.58203 .41137 m .58796 .41234 L .59514 .43571 L p .52 .471 .742 r
F P
0 g
s
.62433 .65686 m .6152 .66326 L .64867 .64386 L p .539 .913 .748 r
F P
0 g
s
.64867 .64386 m .66268 .63675 L .62433 .65686 L p .539 .913 .748 r
F P
0 g
s
.56742 .50157 m .5768 .49874 L .57153 .51 L p .474 .229 .461 r
F P
0 g
s
.57153 .51 m .56399 .51362 L .56742 .50157 L p .474 .229 .461 r
F P
0 g
s
.56025 .2824 m .56252 .2857 L .52523 .2835 L p .811 .775 .819 r
F P
0 g
s
.52523 .2835 m .52846 .27824 L .56025 .2824 L p .811 .775 .819 r
F P
0 g
s
.25095 .4735 m .2651 .48499 L .28082 .55767 L p .967 .7 .475 r
F P
0 g
s
.52384 .32104 m .5263 .32607 L .4954 .34932 L p .732 .677 .797 r
F P
0 g
s
.4954 .34932 m .48922 .34329 L .52384 .32104 L p .732 .677 .797 r
F P
0 g
s
.55266 .36033 m .5553 .36394 L .56631 .38539 L p .522 .552 .828 r
F P
0 g
s
.57165 .38776 m .56631 .38539 L .5553 .36394 L p .441 .523 .846 r
F P
0 g
s
.65423 .70116 m .6676 .69382 L .70399 .64911 L p .328 .035 .306 r
F P
0 g
s
.71722 .6406 m .70399 .64911 L .6676 .69382 L p .06 0 .072 r
F P
0 g
s
.70399 .64911 m .71722 .6406 L .74198 .58606 L p .306 .101 .429 r
F P
0 g
s
.75192 .57682 m .74198 .58606 L .71722 .6406 L p 0 0 .206 r
F P
0 g
s
.74198 .58606 m .75192 .57682 L .76164 .51796 L p .191 .08 .489 r
F P
0 g
s
.44845 .47774 m .43566 .47376 L .43519 .4406 L p .831 .653 .662 r
F P
0 g
s
.43566 .47376 m .44845 .47774 L .45644 .50539 L p .832 .609 .6 r
F P
0 g
s
.46999 .50718 m .45644 .50539 L .44845 .47774 L p .798 .587 .616 r
F P
0 g
s
.56252 .2857 m .5643 .28893 L .52275 .28887 L p .792 .739 .803 r
F P
0 g
s
.52275 .28887 m .52523 .2835 L .56252 .2857 L p .792 .739 .803 r
F P
0 g
s
.48432 .3369 m .48922 .34329 L .46214 .37253 L p .79 .726 .792 r
F P
0 g
s
.46214 .37253 m .45473 .36562 L .48432 .3369 L p .79 .726 .792 r
F P
0 g
s
.45473 .36562 m .46214 .37253 L .44395 .40593 L p .827 .732 .76 r
F P
0 g
s
.59022 .74276 m .6016 .73706 L .63772 .70806 L p .36 0 .161 r
F P
0 g
s
.65423 .70116 m .63772 .70806 L .6016 .73706 L p .17 0 0 r
F P
0 g
s
.45644 .50539 m .46999 .50718 L .48205 .52723 L p .782 .528 .552 r
F P
0 g
s
.49455 .52688 m .48205 .52723 L .46999 .50718 L p .754 .513 .567 r
F P
0 g
s
.44395 .40593 m .43468 .3992 L .45473 .36562 L p .827 .732 .76 r
F P
0 g
s
.43468 .3992 m .44395 .40593 L .43519 .4406 L p .855 .719 .712 r
F P
0 g
s
.61442 .30394 m .61519 .30448 L .56642 .29845 L p .742 .485 .541 r
F P
0 g
s
.56642 .29845 m .56625 .29527 L .61442 .30394 L p .742 .485 .541 r
F P
0 g
s
.59993 .43533 m .59514 .43571 L .58796 .41234 L p .425 .413 .743 r
F P
0 g
s
.59514 .43571 m .59993 .43533 L .60217 .45648 L p .409 .342 .671 r
F P
0 g
s
.60217 .45648 m .59744 .45799 L .59514 .43571 L p .409 .342 .671 r
F P
0 g
s
.5889 .47974 m .59532 .47734 L .58961 .49237 L p .366 .175 .483 r
F P
0 g
s
.58961 .49237 m .58423 .49564 L .5889 .47974 L p .366 .175 .483 r
F P
0 g
s
.52032 .52446 m .53274 .52243 L .53657 .53067 L p .617 .343 .48 r
F P
0 g
s
.53274 .52243 m .54436 .5199 L .54532 .52729 L p .565 .284 .448 r
F P
0 g
s
.54532 .52729 m .53657 .53067 L .53274 .52243 L p .565 .284 .448 r
F P
0 g
s
.50745 .52595 m .52032 .52446 L .52712 .53368 L p .655 .383 .496 r
F P
0 g
s
.53657 .53067 m .52712 .53368 L .52032 .52446 L p .617 .343 .48 r
F P
0 g
s
.57165 .38776 m .57588 .38998 L .58796 .41234 L p .488 .502 .797 r
F P
0 g
s
.59221 .41317 m .58796 .41234 L .57588 .38998 L p .372 .447 .809 r
F P
0 g
s
.58796 .41234 m .59221 .41317 L .59993 .43533 L p .425 .413 .743 r
F P
0 g
s
.54436 .5199 m .55486 .51694 L .55314 .52358 L p .484 .186 .385 r
F P
0 g
s
.55314 .52358 m .54532 .52729 L .54436 .5199 L p .484 .186 .385 r
F P
0 g
s
.5643 .28893 m .56554 .29211 L .52104 .2943 L p .775 .71 .791 r
F P
0 g
s
.52104 .2943 m .52275 .28887 L .5643 .28893 L p .775 .71 .791 r
F P
0 g
s
.5768 .49874 m .58423 .49564 L .57735 .50618 L p .304 .036 .33 r
F P
0 g
s
.57735 .50618 m .57153 .51 L .5768 .49874 L p .304 .036 .33 r
F P
0 g
s
.5553 .36394 m .55753 .36748 L .56496 .37816 L p .441 .523 .846 r
F P
0 g
s
.56496 .37816 m .56669 .38063 L p .56501 .37817 L .441 .523 .846 r
F P
0 g
s
.56501 .37817 m .5553 .36394 L .56496 .37816 L .441 .523 .846 r
F
.56786 .38224 m .5553 .36394 L .56669 .38063 L F
.56669 .38063 m .57165 .38776 L p .56786 .38224 L F P
0 g
s
.57588 .38998 m .57165 .38776 L .55753 .36748 L p .29 .464 .86 r
F P
0 g
s
.55753 .36748 m .55932 .37094 L .57588 .38998 L p .29 .464 .86 r
F P
0 g
s
.57896 .39211 m .57588 .38998 L .56123 .37315 L p 0 .304 .798 r
F P
0 g
s
.57588 .38998 m .57896 .39211 L .59221 .41317 L p .372 .447 .809 r
F P
0 g
s
.59476 .41398 m .59221 .41317 L .57896 .39211 L p .116 .317 .788 r
F P
0 g
s
.57896 .39211 m .58087 .39421 L .59476 .41398 L p .116 .317 .788 r
F P
0 g
s
.58087 .39421 m .57896 .39211 L .56428 .3779 L p .587 .071 0 r
F P
0 g
s
.56428 .3779 m .56063 .37437 L p .5642 .37787 L .587 .071 0 r
F P
0 g
s
.58087 .39421 m .56428 .3779 L .5642 .37787 L .587 .071 0 r
F
.56123 .37315 m .55932 .37094 L p .56077 .37251 L 0 .304 .798 r
F P
0 g
s
.57896 .39211 m .56123 .37315 L .56077 .37251 L 0 .304 .798 r
F
.59744 .45799 m .60217 .45648 L .59952 .47483 L p .326 .207 .561 r
F P
0 g
s
.59952 .47483 m .59532 .47734 L .59744 .45799 L p .326 .207 .561 r
F P
0 g
s
.52192 .31586 m .52384 .32104 L .48922 .34329 L p .745 .695 .804 r
F P
0 g
s
.48922 .34329 m .48432 .3369 L .52192 .31586 L p .745 .695 .804 r
F P
0 g
s
.49455 .52688 m .50745 .52595 L .51726 .53628 L p .686 .411 .5 r
F P
0 g
s
.52712 .53368 m .51726 .53628 L .50745 .52595 L p .655 .383 .496 r
F P
0 g
s
.43519 .4406 m .42487 .43466 L .43468 .3992 L p .855 .719 .712 r
F P
0 g
s
.42487 .43466 m .43519 .4406 L .43566 .47376 L p .873 .689 .65 r
F P
0 g
s
.52521 .69308 m .54274 .68937 L .54597 .69187 L p .212 0 0 r
F P
0 g
s
.54274 .68937 m .55977 .68511 L .55365 .68743 L p 0 0 0 r
F P
0 g
s
.55365 .68743 m .54597 .69187 L .54274 .68937 L p 0 0 0 r
F P
0 g
s
.68022 .62153 m .67326 .62927 L .70816 .59476 L p .597 .889 .59 r
F P
0 g
s
.70816 .59476 m .71748 .58638 L .68022 .62153 L p .597 .889 .59 r
F P
0 g
s
.50761 .69624 m .52521 .69308 L .53805 .69607 L p .381 0 .151 r
F P
0 g
s
.54597 .69187 m .53805 .69607 L .52521 .69308 L p .212 0 0 r
F P
0 g
s
.55486 .51694 m .56399 .51362 L .55982 .51961 L p .33 .002 .25 r
F P
0 g
s
.55982 .51961 m .55314 .52358 L .55486 .51694 L p .33 .002 .25 r
F P
0 g
s
.55977 .68511 m .57589 .68032 L .56089 .68275 L p .474 .869 .687 r
F P
0 g
s
.56089 .68275 m .55365 .68743 L .55977 .68511 L p .474 .869 .687 r
F P
0 g
s
.56554 .29211 m .56625 .29527 L .52013 .29976 L p .759 .687 .782 r
F P
0 g
s
.52013 .29976 m .52104 .2943 L .56554 .29211 L p .759 .687 .782 r
F P
0 g
s
.33199 .62643 m .31517 .6212 L .28082 .55767 L p .896 .581 .442 r
F P
0 g
s
.31517 .6212 m .33199 .62643 L .37805 .6736 L p .842 .437 .275 r
F P
0 g
s
.39484 .67541 m .37805 .6736 L .33199 .62643 L p .819 .467 .391 r
F P
0 g
s
.5581 .31901 m .55571 .32282 L .53585 .34019 L p .622 .566 .77 r
F P
0 g
s
.53585 .34019 m .53241 .33566 L .5581 .31901 L p .622 .566 .77 r
F P
0 g
s
.5394 .34454 m .53585 .34019 L .55571 .32282 L p .592 .549 .776 r
F P
0 g
s
.55571 .32282 m .55322 .32677 L .5394 .34454 L p .592 .549 .776 r
F P
0 g
s
.54296 .34872 m .5394 .34454 L .55322 .32677 L p .552 .529 .783 r
F P
0 g
s
.56032 .31531 m .5581 .31901 L .53241 .33566 L p .646 .58 .767 r
F P
0 g
s
.53241 .33566 m .52919 .33095 L .56032 .31531 L p .646 .58 .767 r
F P
0 g
s
.55322 .32677 m .55073 .33085 L .54296 .34872 L p .552 .529 .783 r
F P
0 g
s
.54641 .35273 m .54296 .34872 L .55073 .33085 L p .491 .5 .793 r
F P
0 g
s
.48205 .52723 m .49455 .52688 L .50732 .53845 L p .713 .43 .495 r
F P
0 g
s
.51726 .53628 m .50732 .53845 L .49455 .52688 L p .686 .411 .5 r
F P
0 g
s
.5623 .31175 m .56032 .31531 L .52919 .33095 L p .666 .593 .765 r
F P
0 g
s
.52919 .33095 m .5263 .32607 L .5623 .31175 L p .666 .593 .765 r
F P
0 g
s
.55073 .33085 m .54829 .33505 L .54641 .35273 L p .491 .5 .793 r
F P
0 g
s
.54968 .35659 m .54641 .35273 L .54829 .33505 L p .389 .451 .803 r
F P
0 g
s
.4904 .69883 m .50761 .69624 L .5301 .70002 L p .48 .105 .249 r
F P
0 g
s
.53805 .69607 m .5301 .70002 L .50761 .69624 L p .381 0 .151 r
F P
0 g
s
.56396 .30829 m .5623 .31175 L .5263 .32607 L p .683 .607 .764 r
F P
0 g
s
.5263 .32607 m .52384 .32104 L .56396 .30829 L p .683 .607 .764 r
F P
0 g
s
.59532 .47734 m .59952 .47483 L .59293 .48904 L p .036 0 .265 r
F P
0 g
s
.59293 .48904 m .58961 .49237 L .59532 .47734 L p .036 0 .265 r
F P
0 g
s
.45644 .50539 m .44445 .50296 L .43566 .47376 L p .832 .609 .6 r
F P
0 g
s
.44445 .50296 m .45644 .50539 L .47039 .52702 L p .814 .541 .526 r
F P
0 g
s
.48205 .52723 m .47039 .52702 L .45644 .50539 L p .782 .528 .552 r
F P
0 g
s
.57589 .68032 m .59072 .67505 L .56753 .67786 L p .733 .989 .883 r
F P
0 g
s
.56753 .67786 m .56089 .68275 L .57589 .68032 L p .733 .989 .883 r
F P
0 g
s
.60266 .43491 m .59993 .43533 L .59221 .41317 L p .226 .29 .72 r
F P
0 g
s
.59993 .43533 m .60266 .43491 L .6047 .45495 L p .173 .163 .605 r
F P
0 g
s
.6047 .45495 m .60217 .45648 L .59993 .43533 L p .173 .163 .605 r
F P
0 g
s
.56625 .29527 m .56642 .29845 L .52 .30519 L p .744 .667 .775 r
F P
0 g
s
.52 .30519 m .52013 .29976 L .56625 .29527 L p .744 .667 .775 r
F P
0 g
s
.54829 .33505 m .54599 .33937 L .54968 .35659 L p .389 .451 .803 r
F P
0 g
s
.55266 .36033 m .54968 .35659 L .54599 .33937 L p .183 .346 .793 r
F P
0 g
s
.59221 .41317 m .59476 .41398 L .60266 .43491 L p .226 .29 .72 r
F P
0 g
s
.58423 .49564 m .58961 .49237 L .5814 .50225 L p 0 0 0 r
F P
0 g
s
.5814 .50225 m .57735 .50618 L .58423 .49564 L p 0 0 0 r
F P
0 g
s
.52062 .31057 m .52192 .31586 L .48432 .3369 L p .759 .717 .813 r
F P
0 g
s
.48432 .3369 m .48092 .33021 L .52062 .31057 L p .759 .717 .813 r
F P
0 g
s
.48092 .33021 m .48432 .3369 L .45473 .36562 L p .811 .761 .806 r
F P
0 g
s
.56399 .51362 m .57153 .51 L .56523 .51543 L p 0 0 0 r
F P
0 g
s
.56523 .51543 m .55982 .51961 L .56399 .51362 L p 0 0 0 r
F P
0 g
s
.45473 .36562 m .44949 .35826 L .48092 .33021 L p .811 .761 .806 r
F P
0 g
s
.44949 .35826 m .45473 .36562 L .43468 .3992 L p .86 .779 .77 r
F P
0 g
s
.72207 .57781 m .71748 .58638 L .74393 .54005 L p .651 .816 .385 r
F P
0 g
s
.74393 .54005 m .74964 .53114 L .72207 .57781 L p .651 .816 .385 r
F P
0 g
s
.61411 .30512 m .61519 .30448 L .66264 .32378 L p .566 0 0 r
F P
0 g
s
.61519 .30448 m .61411 .30512 L .56607 .30166 L p .718 .473 .554 r
F P
0 g
s
.56607 .30166 m .56642 .29845 L .61519 .30448 L p .718 .473 .554 r
F P
0 g
s
.66112 .32172 m .66264 .32378 L .70493 .35586 L p 0 .237 .708 r
F P
0 g
s
.66264 .32378 m .66112 .32172 L .61411 .30512 L p .566 0 0 r
F P
0 g
s
.56524 .30494 m .56396 .30829 L .52384 .32104 L p .699 .62 .765 r
F P
0 g
s
.52384 .32104 m .52192 .31586 L .56524 .30494 L p .699 .62 .765 r
F P
0 g
s
.66268 .63675 m .67326 .62927 L .63113 .65022 L p .753 .986 .902 r
F P
0 g
s
.63113 .65022 m .62433 .65686 L .66268 .63675 L p .753 .986 .902 r
F P
0 g
s
.43566 .47376 m .42514 .46911 L .42487 .43466 L p .873 .689 .65 r
F P
0 g
s
.42514 .46911 m .43566 .47376 L .44445 .50296 L p .876 .635 .57 r
F P
0 g
s
.76619 .50869 m .76164 .51796 L .75192 .57682 L p 0 0 .189 r
F P
0 g
s
.54599 .33937 m .54388 .34378 L .55266 .36033 L p .183 .346 .793 r
F P
0 g
s
.5553 .36394 m .55266 .36033 L .54388 .34378 L p 0 .07 .63 r
F P
0 g
s
.37805 .6736 m .39484 .67541 L .44577 .7035 L p .734 .315 .253 r
F P
0 g
s
.45902 .70243 m .44577 .7035 L .39484 .67541 L p .72 .336 .32 r
F P
0 g
s
.60217 .45648 m .6047 .45495 L .60152 .47234 L p 0 0 .355 r
F P
0 g
s
.60152 .47234 m .60052 .47359 L p .60168 .46845 L 0 0 .355 r
F P
0 g
s
.60145 .46997 m .60152 .47234 L .6047 .45495 L p .86 .793 .299 r
F P
0 g
s
.60511 .45352 m .60145 .46997 L p .60392 .45854 L .86 .793 .299 r
F P
0 g
s
.6047 .45495 m .60488 .45433 L p .60392 .45854 L .86 .793 .299 r
F P
0 g
s
.60488 .45433 m .60511 .45352 L p .60392 .45854 L .86 .793 .299 r
F P
0 g
s
.59952 .47483 m .60217 .45648 L p .60168 .46845 L 0 0 .355 r
F P
0 g
s
.60052 .47359 m .59952 .47483 L p .60168 .46845 L 0 0 .355 r
F P
0 g
s
.43468 .3992 m .42803 .39191 L .44949 .35826 L p .86 .779 .77 r
F P
0 g
s
.42803 .39191 m .43468 .3992 L .42487 .43466 L p .902 .773 .709 r
F P
0 g
s
.56642 .29845 m .56607 .30166 L .52062 .31057 L p .729 .65 .77 r
F P
0 g
s
.52062 .31057 m .52 .30519 L .56642 .29845 L p .729 .65 .77 r
F P
0 g
s
.56607 .30166 m .56524 .30494 L .52192 .31586 L p .714 .634 .767 r
F P
0 g
s
.52192 .31586 m .52062 .31057 L .56607 .30166 L p .714 .634 .767 r
F P
0 g
s
.47039 .52702 m .48205 .52723 L .49763 .54018 L p .74 .444 .48 r
F P
0 g
s
.50732 .53845 m .49763 .54018 L .48205 .52723 L p .713 .43 .495 r
F P
0 g
s
.6016 .73706 m .60678 .73385 L p .65423 .70116 L .17 0 0 r
F P
0 g
s
.61788 .72646 m .65423 .70116 L p .60678 .73385 L .17 0 0 r
F P
0 g
s
.6676 .69382 m .65423 .70116 L .61129 .73105 L p 0 0 0 r
F P
0 g
s
.6676 .69382 m .67756 .68612 L .71722 .6406 L p .06 0 .072 r
F P
0 g
s
.67756 .68612 m .67142 .69087 L p .61909 .72479 L .549 .913 .732 r
F P
0 g
s
.67142 .69087 m .6676 .69382 L .65194 .70382 L p .549 .913 .732 r
F P
0 g
s
.65194 .70382 m .61909 .72479 L p .67142 .69087 L .549 .913 .732 r
F P
0 g
s
.60678 .73385 m .61129 .73105 L .61788 .72646 L p .17 0 0 r
F P
0 g
s
.70325 .35124 m .70493 .35586 L .73838 .39919 L p 0 .086 .637 r
F P
0 g
s
.70493 .35586 m .70325 .35124 L .66112 .32172 L p 0 .237 .708 r
F P
0 g
s
.54388 .34378 m .54201 .34828 L .5553 .36394 L p 0 .07 .63 r
F P
0 g
s
.55753 .36748 m .5553 .36394 L .54201 .34828 L p .81 .356 0 r
F P
0 g
s
.55932 .37094 m .56063 .37437 L .57896 .39211 L p 0 .304 .798 r
F P
0 g
s
.47405 .70089 m .4904 .69883 L .52234 .70372 L p .544 .183 .305 r
F P
0 g
s
.5301 .70002 m .52234 .70372 L .4904 .69883 L p .48 .105 .249 r
F P
0 g
s
.59072 .67505 m .60392 .66934 L .57341 .67277 L p .812 .949 .911 r
F P
0 g
s
.57341 .67277 m .56753 .67786 L .59072 .67505 L p .812 .949 .911 r
F P
0 g
s
.57153 .51 m .57735 .50618 L .56928 .51111 L p .651 .928 .651 r
F P
0 g
s
.56928 .51111 m .56523 .51543 L .57153 .51 L p .651 .928 .651 r
F P
0 g
s
.28082 .55767 m .26751 .54878 L .25095 .4735 L p .967 .7 .475 r
F P
0 g
s
.26751 .54878 m .28082 .55767 L .31517 .6212 L p .93 .556 .268 r
F P
0 g
s
.52 .30519 m .52062 .31057 L .48092 .33021 L p .773 .743 .826 r
F P
0 g
s
.56524 .30494 m .56607 .30166 L .61411 .30512 L p .694 .458 .561 r
F P
0 g
s
.54201 .34828 m .54042 .35284 L .55753 .36748 L p .81 .356 0 r
F P
0 g
s
.55932 .37094 m .55753 .36748 L .54042 .35284 L p .903 .521 .293 r
F P
0 g
s
.48092 .33021 m .47922 .32328 L .52 .30519 L p .773 .743 .826 r
F P
0 g
s
.47922 .32328 m .48092 .33021 L .44949 .35826 L p .834 .807 .825 r
F P
0 g
s
.58961 .49237 m .59293 .48904 L .58368 .49828 L p .797 .967 .658 r
F P
0 g
s
.58368 .49828 m .5814 .50225 L .58961 .49237 L p .797 .967 .658 r
F P
0 g
s
.59565 .41483 m .59476 .41398 L .58087 .39421 L p 0 0 .511 r
F P
0 g
s
.59476 .41398 m .59565 .41483 L .60342 .43456 L p 0 0 .526 r
F P
0 g
s
.60342 .43456 m .60266 .43491 L .59476 .41398 L p 0 0 .526 r
F P
0 g
s
.52712 .53368 m .53657 .53067 L .54068 .53237 L p .443 .119 .32 r
F P
0 g
s
.54532 .52729 m .54633 .52838 L p .54175 .52945 L .267 0 .168 r
F P
0 g
s
.5413 .52884 m .54532 .52729 L p .54175 .52945 L .267 0 .168 r
F P
0 g
s
.54633 .52838 m .54068 .53237 L .53657 .53067 L p .267 0 .168 r
F P
0 g
s
.55314 .52358 m .55129 .52418 L p .54841 .52568 L 0 0 0 r
F P
0 g
s
.54532 .52729 m .5493 .5254 L p .54841 .52568 L 0 0 0 r
F P
0 g
s
.5493 .5254 m .55314 .52358 L p .54841 .52568 L 0 0 0 r
F P
0 g
s
.54953 .51956 m .54727 .52395 L .54679 .52619 L p .857 .944 .581 r
F P
0 g
s
.55129 .52418 m .54633 .52838 L .54532 .52729 L p 0 0 0 r
F P
0 g
s
.54679 .52619 m .54633 .52838 L p .54716 .52607 L .857 .944 .581 r
F P
0 g
s
.54953 .51956 m .54679 .52619 L .54716 .52607 L .857 .944 .581 r
F
.54068 .53237 m .54633 .52838 L .5472 .52428 L p 0 0 0 r
F P
0 g
s
.5472 .52428 m .54727 .52395 L p .54647 .52497 L 0 0 0 r
F P
0 g
s
.54647 .52497 m .54068 .53237 L .5472 .52428 L 0 0 0 r
F
.54727 .52395 m .54465 .52825 L .54249 .53049 L p F P
0 g
s
.54249 .53049 m .54068 .53237 L p .54233 .53026 L 0 0 0 r
F P
0 g
s
.54727 .52395 m .54249 .53049 L .54233 .53026 L 0 0 0 r
F
.54068 .53237 m .53452 .53612 L .52712 .53368 L p .443 .119 .32 r
F P
0 g
s
.53452 .53612 m .54068 .53237 L .54465 .52825 L p .191 0 .286 r
F P
0 g
s
.54465 .52825 m .54174 .53243 L .53503 .53586 L p .191 0 .286 r
F P
0 g
s
.53503 .53586 m .53452 .53612 L p .5358 .53512 L .191 0 .286 r
F P
0 g
s
.54465 .52825 m .53503 .53586 L .5358 .53512 L .191 0 .286 r
F
.53657 .53067 m .5413 .52884 L p .54175 .52945 L .267 0 .168 r
F P
0 g
s
.59424 .48575 m .59293 .48904 L .59399 .48675 L p .717 .822 .366 r
F P
0 g
s
.59399 .48675 m .59952 .47483 L p .59611 .48188 L .717 .822 .366 r
F P
0 g
s
.59424 .48575 m .59399 .48675 L .59611 .48188 L .717 .822 .366 r
F
.60152 .47234 m .60145 .46997 L .60089 .47089 L p .959 .925 .723 r
F P
0 g
s
.60089 .47089 m .59368 .48258 L p .59859 .47617 L .959 .925 .723 r
F P
0 g
s
.59952 .47483 m .60152 .47234 L .59424 .48575 L p .717 .822 .366 r
F P
0 g
s
.59859 .47617 m .60152 .47234 L .60089 .47089 L .959 .925 .723 r
F
.51726 .53628 m .52712 .53368 L .53452 .53612 L p .536 .227 .391 r
F P
0 g
s
.52013 .29976 m .52 .30519 L .47922 .32328 L p .787 .775 .842 r
F P
0 g
s
.42487 .43466 m .41736 .42814 L .42803 .39191 L p .902 .773 .709 r
F P
0 g
s
.41736 .42814 m .42487 .43466 L .42514 .46911 L p .93 .738 .621 r
F P
0 g
s
.60266 .43491 m .60342 .43456 L .60511 .45352 L p 0 0 .265 r
F P
0 g
s
.6047 .45495 m .60266 .43491 L p .60474 .45073 L 0 0 .265 r
F P
0 g
s
.60233 .43438 m .60357 .45228 L p .60344 .43667 L .992 .757 .386 r
F P
0 g
s
.60342 .43456 m .60324 .43453 L p .60344 .43667 L .992 .757 .386 r
F P
0 g
s
.60324 .43453 m .60233 .43438 L p .60344 .43667 L .992 .757 .386 r
F P
0 g
s
.60511 .45352 m .60503 .45381 L p .60474 .45073 L 0 0 .265 r
F P
0 g
s
.60503 .45381 m .6047 .45495 L p .60474 .45073 L 0 0 .265 r
F P
0 g
s
.54042 .35284 m .53915 .35746 L .55932 .37094 L p .903 .521 .293 r
F P
0 g
s
.56063 .37437 m .55932 .37094 L .53915 .35746 L p .867 .551 .45 r
F P
0 g
s
.61411 .30512 m .61128 .30595 L .56524 .30494 L p .694 .458 .561 r
F P
0 g
s
.56396 .30829 m .56524 .30494 L .61128 .30595 L p .669 .439 .563 r
F P
0 g
s
.73838 .39919 m .73673 .39242 L .70325 .35124 L p 0 .086 .637 r
F P
0 g
s
.56063 .37437 m .56147 .37778 L .58087 .39421 L p .587 .071 0 r
F P
0 g
s
.58163 .39634 m .58087 .39421 L .56147 .37778 L p .83 .365 .098 r
F P
0 g
s
.58087 .39421 m .58163 .39634 L .59565 .41483 L p 0 0 .511 r
F P
0 g
s
.50732 .53845 m .51726 .53628 L .52804 .5396 L p .593 .291 .426 r
F P
0 g
s
.53452 .53612 m .52804 .5396 L .51726 .53628 L p .536 .227 .391 r
F P
0 g
s
.61128 .30595 m .61411 .30512 L .66112 .32172 L p .642 .122 0 r
F P
0 g
s
.72576 .63175 m .71722 .6406 L .67756 .68612 L p 0 0 0 r
F P
0 g
s
.71722 .6406 m .72576 .63175 L .75192 .57682 L p 0 0 .206 r
F P
0 g
s
.4129 .45819 m .4174 .46388 L .41914 .46969 L p .973 .662 .309 r
F P
0 g
s
.41914 .46969 m .41999 .47249 L p .41829 .46907 L .973 .662 .309 r
F P
0 g
s
.41829 .46907 m .4129 .45819 L .41914 .46969 L .973 .662 .309 r
F
.4196 .47179 m .41851 .46957 L .41999 .47249 L F
.41851 .46957 m .4129 .45819 L .41856 .46962 L F
.41851 .46957 m .41856 .46962 L .41999 .47249 L F
.417 .47426 m .418 .46886 L p .41656 .47215 L .993 .857 .596 r
F P
0 g
s
.4165 .46777 m .41625 .46852 L .418 .46886 L .993 .857 .596 r
F
.41625 .46852 m .41075 .48545 L .41695 .47128 L F
.41625 .46852 m .41695 .47128 L .418 .46886 L F
.42106 .47446 m .41999 .47249 L .41403 .49025 L .932 .783 .673 r
F
.418 .46886 m .41744 .47189 L p .41999 .47249 L F P
0 g
s
.41744 .47189 m .41403 .49025 L p .41999 .47249 L .932 .783 .673 r
F P
0 g
s
.41403 .49025 m .42074 .49464 L .42367 .479 L p .932 .783 .673 r
F P
0 g
s
.42313 .47806 m .41403 .49025 L .42367 .479 L .932 .783 .673 r
F
.4174 .46388 m .42514 .46911 L .42682 .47464 L p .934 .664 .502 r
F P
0 g
s
.42409 .47678 m .42463 .4739 L p .41785 .48167 L .932 .783 .673 r
F P
0 g
s
.42433 .47379 m .41785 .48167 L .42463 .4739 L .932 .783 .673 r
F
.42175 .47292 m .4174 .46388 L .42682 .47464 L .934 .664 .502 r
F
.41999 .47249 m .4174 .46388 L p .42168 .47289 L F P
0 g
s
.42175 .47292 m .41973 .47203 L .42106 .47446 L .932 .783 .673 r
F
.42168 .4729 m .42168 .47289 L .42175 .47292 L .934 .664 .502 r
F
.42168 .47289 m .4174 .46388 L .42175 .47292 L F
.41494 .46366 m .41412 .46066 L .42004 .47268 L .973 .662 .309 r
F
.42514 .46911 m .4174 .46388 L .41736 .42814 L p .93 .738 .621 r
F P
0 g
s
.42705 .46101 m .418 .46886 L .41973 .47203 L .932 .783 .673 r
F
.42705 .46101 m .41973 .47203 L .42175 .47292 L F
.42175 .47291 m .41785 .48167 L .42474 .47329 L F
.42367 .479 m .42409 .47678 L p .42313 .47806 L F P
0 g
s
.41785 .48167 m .41403 .49025 L .4238 .47716 L .932 .783 .673 r
F
.42374 .47706 m .4238 .47716 L .42409 .47678 L F
.41785 .48167 m .4238 .47716 L .42374 .47706 L F
.4165 .46777 m .41647 .46774 L .41075 .48545 L .993 .857 .596 r
F
.41553 .46728 m .41422 .46274 L p .41607 .46754 L .973 .662 .309 r
F P
0 g
s
.41413 .46658 m .41075 .48545 L p .41597 .46929 L .993 .857 .596 r
F P
0 g
s
.41647 .46774 m .41553 .46728 L .41597 .46929 L .993 .857 .596 r
F
.41553 .46728 m .41413 .46658 L .41597 .46929 L F
.41501 .46479 m .41422 .46274 L .41473 .46351 L .973 .662 .309 r
F
.41501 .46479 m .41473 .46351 L .41509 .46405 L F
.41647 .46774 m .41501 .46479 L .41509 .46405 L F
.41607 .46754 m .41501 .46479 L .41647 .46774 L F
.41422 .46274 m .4129 .45819 L p .41509 .46405 L F P
0 g
s
.41494 .46366 m .4129 .45819 L .41412 .46066 L .973 .662 .309 r
F
.4174 .46388 m .4129 .45819 L .4131 .42113 L p .994 .796 .528 r
F P
0 g
s
.41247 .41379 m .4131 .42113 L .4129 .45819 L p .85 .695 .163 r
F P
0 g
s
.4129 .45819 m .41204 .45216 L .41247 .41379 L p .85 .695 .163 r
F P
0 g
s
.41321 .45652 m .41204 .45216 L .41469 .4636 L 0 0 .222 r
F
.4147 .46341 m .41469 .4636 L .41538 .46655 L F
.41321 .45652 m .41469 .4636 L .4147 .46341 L F
.41204 .45216 m .4129 .45819 L .41484 .4649 L p F P
0 g
s
.41484 .4649 m .41553 .46728 L p .41482 .46417 L 0 0 .222 r
F P
0 g
s
.41482 .46417 m .41204 .45216 L .41484 .4649 L 0 0 .222 r
F
.4131 .42113 m .41736 .42814 L .4174 .46388 L p .994 .796 .528 r
F P
0 g
s
.41378 .45854 m .41466 .46175 L p .41477 .45789 L .02 .106 .614 r
F P
0 g
s
.41716 .44967 m .41747 .4435 L .41519 .45708 L p .815 .755 .237 r
F P
0 g
s
.41519 .45708 m .41509 .45768 L p .41515 .45743 L .815 .755 .237 r
F P
0 g
s
.41716 .44967 m .41519 .45708 L .41515 .45743 L .815 .755 .237 r
F
.41716 .44967 m .41509 .45768 L .41495 .459 L F
.41586 .45042 m .41515 .44595 L .41466 .46175 L .02 .106 .614 r
F
.41716 .44967 m .41466 .4602 L .41474 .46224 L .815 .755 .237 r
F
.41474 .46226 m .41474 .46224 L .41474 .46226 L F
.41716 .44967 m .41474 .46224 L .41474 .46226 L F
.41466 .46175 m .41331 .4568 L p .41471 .46204 L 0 0 .222 r
F P
0 g
s
.4147 .46341 m .41481 .46281 L p .41474 .46226 L .815 .755 .237 r
F P
0 g
s
.41481 .46281 m .41716 .44967 L p .41474 .46226 L .815 .755 .237 r
F P
0 g
s
.41474 .46226 m .41474 .46226 L .41481 .46281 L .815 .755 .237 r
F
.41509 .46405 m .41494 .46366 L .42004 .47268 L .973 .662 .309 r
F
.41538 .46655 m .41204 .45216 L .41553 .46728 L 0 0 .222 r
F
.42004 .47268 m .42717 .49637 L p .41509 .46405 L .973 .662 .309 r
F P
0 g
s
.42047 .45555 m .41427 .46578 L .41647 .46774 L .993 .857 .596 r
F
.42717 .49637 m .41607 .46754 L .41647 .46774 L .973 .662 .309 r
F
.41427 .46578 m .41413 .46658 L p .41647 .46774 L .993 .857 .596 r
F P
0 g
s
.42717 .49637 m .42282 .49239 L .41553 .46728 L p .973 .662 .309 r
F P
0 g
s
.42717 .49637 m .41553 .46728 L .41607 .46754 L .973 .662 .309 r
F
.42047 .45555 m .41716 .44967 L .4147 .46341 L p .993 .857 .596 r
F P
0 g
s
.42047 .45555 m .4147 .46341 L .41496 .46464 L .993 .857 .596 r
F
.42185 .48811 m .41471 .46194 L p .42153 .48759 L 0 0 .222 r
F P
0 g
s
.41366 .45819 m .41321 .45652 L .4148 .46386 L 0 0 .222 r
F
.4148 .46367 m .4148 .46386 L .41559 .46748 L F
.41366 .45819 m .4148 .46386 L .4148 .46367 L F
.41321 .45652 m .41538 .46655 L .41559 .46748 L F
.41559 .46748 m .42282 .49239 L p .41366 .45819 L F P
0 g
s
.41474 .46226 m .41474 .46224 L .41126 .48038 L .815 .755 .237 r
F
.41466 .4602 m .41453 .461 L p .41474 .46224 L F P
0 g
s
.42282 .49239 m .41331 .4568 L .41366 .45819 L 0 0 .222 r
F
.41453 .461 m .41126 .48038 L p .41474 .46224 L .815 .755 .237 r
F P
0 g
s
.41471 .46194 m .41466 .46175 L p .41471 .46195 L 0 0 .222 r
F P
0 g
s
.42153 .48759 m .41471 .46194 L .41471 .46195 L 0 0 .222 r
F
.42153 .48759 m .41466 .46175 L .41471 .46204 L F
.41509 .45768 m .41519 .45708 L p .41681 .45655 L 0 0 .333 r
F P
0 g
s
.41519 .45708 m .41747 .4435 L p .41681 .45654 L 0 0 .333 r
F P
0 g
s
.41681 .45654 m .41681 .45655 L .41519 .45708 L 0 0 .333 r
F
.42047 .45555 m .41647 .46774 L .4165 .46776 L .993 .857 .596 r
F
.42682 .47464 m .43453 .49992 L p .42168 .4729 L .934 .664 .502 r
F P
0 g
s
.42682 .47464 m .42514 .46911 L p .42784 .47384 L .876 .635 .57 r
F P
0 g
s
.42474 .47329 m .42705 .46101 L p .42175 .47291 L .932 .783 .673 r
F P
0 g
s
.43453 .49992 m .42717 .49637 L .42004 .47268 L p .934 .664 .502 r
F P
0 g
s
.42004 .47268 m .41999 .47249 L p .42009 .47269 L .934 .664 .502 r
F P
0 g
s
.43453 .49992 m .42004 .47268 L .42009 .47269 L .934 .664 .502 r
F
.43453 .49992 m .41999 .47249 L .42168 .47289 L F
.418 .46886 m .42047 .45555 L p .4165 .46777 L .993 .857 .596 r
F P
0 g
s
.42705 .46101 m .42047 .45555 L .418 .46886 L p .932 .783 .673 r
F P
0 g
s
.41999 .47249 m .42004 .47268 L p .4196 .47179 L .973 .662 .309 r
F P
0 g
s
.42185 .48811 m .42457 .48367 L .41772 .45624 L p .02 .106 .614 r
F P
0 g
s
.41716 .44967 m .42047 .45555 L .43571 .42569 L p .937 .87 .746 r
F P
0 g
s
.43571 .42569 m .43265 .41921 L .41716 .44967 L p .937 .87 .746 r
F P
0 g
s
.41716 .44967 m .43265 .41921 L p .42052 .43863 L .951 .953 .665 r
F P
0 g
s
.41747 .4435 m .41738 .44526 L p .42052 .43863 L .951 .953 .665 r
F P
0 g
s
.41738 .44526 m .41716 .44967 L p .42052 .43863 L .951 .953 .665 r
F P
0 g
s
.43279 .41244 m .43265 .41921 L .455 .39593 L p .896 .91 .825 r
F P
0 g
s
.455 .39593 m .45502 .38908 L .43279 .41244 L p .896 .91 .825 r
F P
0 g
s
.43265 .41921 m .43279 .41244 L .41747 .4435 L p .951 .953 .665 r
F P
0 g
s
.4364 .40553 m .43279 .41244 L .45502 .38908 L p .88 .992 .788 r
F P
0 g
s
.4364 .40553 m .4217 .4372 L p .43092 .41662 L 0 0 0 r
F P
0 g
s
.43279 .41244 m .43387 .41038 L p .43092 .41662 L 0 0 0 r
F P
0 g
s
.43387 .41038 m .4364 .40553 L p .43092 .41662 L 0 0 0 r
F P
0 g
s
.41747 .4435 m .4217 .4372 L .41945 .45183 L p 0 0 .333 r
F P
0 g
s
.41747 .4435 m .41945 .45183 L .4187 .45359 L 0 0 .333 r
F
.42047 .45555 m .42705 .46101 L .44165 .43176 L p .885 .791 .752 r
F P
0 g
s
.44165 .43176 m .43571 .42569 L .42047 .45555 L p .885 .791 .752 r
F P
0 g
s
.41767 .45604 m .42457 .48367 L p .42296 .45078 L .329 .316 .693 r
F P
0 g
s
.41945 .45183 m .4217 .4372 L p .42293 .45078 L .288 .168 .538 r
F P
0 g
s
.4217 .4372 m .43 .43095 L .42795 .44603 L p .288 .168 .538 r
F P
0 g
s
.4217 .4372 m .42795 .44603 L .42688 .44749 L .288 .168 .538 r
F
.42477 .45033 m .43119 .47922 L p .43326 .44516 L .466 .407 .707 r
F P
0 g
s
.42795 .44603 m .43 .43095 L p .43324 .44516 L .45 .313 .602 r
F P
0 g
s
.43571 .42569 m .44165 .43176 L .46249 .40877 L p .831 .771 .796 r
F P
0 g
s
.43 .43095 m .44242 .42492 L .44065 .44048 L p .45 .313 .602 r
F P
0 g
s
.43 .43095 m .44065 .44048 L .43907 .44197 L .45 .313 .602 r
F
.43607 .44481 m .44181 .47494 L p .4477 .43987 L .541 .457 .709 r
F P
0 g
s
.44065 .44048 m .44242 .42492 L p .4477 .43987 L .534 .389 .63 r
F P
0 g
s
.44242 .42492 m .45888 .41933 L .45743 .43537 L p .534 .389 .63 r
F P
0 g
s
.44242 .42492 m .45743 .43537 L .45534 .43688 L .534 .389 .63 r
F
.45149 .43966 m .45152 .43986 L p .45763 .43536 L .589 .489 .709 r
F P
0 g
s
.45763 .43536 m .45743 .43537 L .45149 .43966 L .589 .489 .709 r
F
.45888 .41933 m .46615 .43511 L .46612 .43511 L .587 .436 .643 r
F
.45743 .43537 m .45748 .43477 L p .46612 .43511 L F P
0 g
s
.45748 .43477 m .45888 .41933 L p .46612 .43511 L .587 .436 .643 r
F P
0 g
s
.45637 .471 m .4747 .4676 L .47087 .43529 L p .589 .489 .709 r
F P
0 g
s
.45888 .41933 m .47911 .41438 L .47803 .4309 L p .587 .436 .643 r
F P
0 g
s
.47084 .43509 m .47087 .43529 L p .47826 .4309 L .624 .513 .707 r
F P
0 g
s
.47826 .4309 m .47803 .4309 L .47084 .43509 L .624 .513 .707 r
F
.47911 .41438 m .48826 .43107 L .48819 .43107 L .625 .469 .651 r
F
.47803 .4309 m .47807 .4303 L p .48819 .43107 L F P
0 g
s
.47807 .4303 m .47911 .41438 L p .48819 .43107 L .625 .469 .651 r
F P
0 g
s
.4747 .4676 m .49645 .4649 L .49377 .4315 L p .624 .513 .707 r
F P
0 g
s
.4747 .4676 m .49377 .4315 L .48826 .43108 L .624 .513 .707 r
F
.48819 .43107 m .48826 .43108 L .48819 .43107 L F
.4747 .4676 m .48826 .43108 L .48819 .43107 L F
.47911 .41438 m .49902 .42873 L .49843 .42902 L .625 .469 .651 r
F
.49375 .4313 m .49377 .4315 L p .50228 .42728 L .651 .533 .706 r
F P
0 g
s
.50271 .41025 m .51353 .42795 L .51341 .42794 L .654 .495 .656 r
F
.50204 .42726 m .50206 .42666 L p .51341 .42794 L F P
0 g
s
.50206 .42666 m .50271 .41025 L p .51341 .42794 L .654 .495 .656 r
F P
0 g
s
.49645 .4649 m .52112 .46308 L .51969 .42865 L p .651 .533 .706 r
F P
0 g
s
.49645 .4649 m .51969 .42865 L .51353 .42795 L .651 .533 .706 r
F
.51341 .42794 m .51353 .42795 L .51341 .42794 L F
.49645 .4649 m .51353 .42795 L .51341 .42794 L F
.50271 .41025 m .5291 .40712 L .52881 .42836 L p .654 .495 .656 r
F P
0 g
s
.50271 .41025 m .52881 .42836 L .52762 .42833 L .654 .495 .656 r
F
.51353 .42795 m .5288 .42919 L .51353 .42795 L F
.50271 .41025 m .52762 .42833 L .51353 .42795 L F
.52762 .42833 m .5288 .42919 L .51353 .42795 L F
.49377 .4315 m .49645 .4649 L p .51341 .42794 L .651 .533 .706 r
F P
0 g
s
.51341 .42794 m .51632 .42162 L .50255 .42765 L .651 .533 .706 r
F
.51341 .42794 m .50255 .42765 L .49377 .4315 L F
.51632 .42162 m .51709 .41994 L .50158 .42762 L F
.50255 .42765 m .50158 .42762 L .49377 .4315 L F
.51632 .42162 m .50158 .42762 L .50255 .42765 L F
.52881 .42836 m .5288 .42919 L p .52762 .42833 L .654 .495 .656 r
F P
0 g
s
.50228 .42728 m .50204 .42726 L .49375 .4313 L .651 .533 .706 r
F
.51341 .42794 m .52849 .4524 L .50204 .42726 L .654 .495 .656 r
F
.51353 .42795 m .51353 .42795 L .51341 .42794 L F
.51353 .42795 m .52849 .4524 L .51341 .42794 L F
.51969 .42865 m .51915 .41545 L p .51341 .42794 L .651 .533 .706 r
F P
0 g
s
.5288 .42919 m .52849 .4524 L p .51353 .42795 L .654 .495 .656 r
F P
0 g
s
.50228 .42728 m .51709 .41994 L .50204 .42726 L .651 .533 .706 r
F
.52849 .4524 m .50097 .45428 L .50204 .42726 L p .654 .495 .656 r
F P
0 g
s
.47087 .43529 m .4747 .4676 L p .48819 .43107 L .624 .513 .707 r
F P
0 g
s
.47911 .41438 m .50081 .43082 L .48826 .43107 L .625 .469 .651 r
F
.48819 .43107 m .49043 .42501 L .47853 .43126 L .624 .513 .707 r
F
.48819 .43107 m .47853 .43126 L .47087 .43529 L F
.48826 .43107 m .50186 .43162 L .48826 .43108 L .625 .469 .651 r
F
.50081 .43082 m .50186 .43162 L .48826 .43107 L F
.49043 .42501 m .49106 .4233 L .47762 .43128 L .624 .513 .707 r
F
.49043 .42501 m .47762 .43128 L .47853 .43126 L F
.48826 .43107 m .48951 .43336 L .47803 .4309 L .625 .469 .651 r
F
.48951 .43336 m .50097 .45428 L .48317 .43614 L F
.47853 .43126 m .47762 .43128 L .47087 .43529 L .624 .513 .707 r
F
.48951 .43336 m .48317 .43614 L .47803 .4309 L .625 .469 .651 r
F
.49843 .42902 m .5019 .4308 L .50081 .43082 L F
.49902 .42873 m .5019 .4308 L .49843 .42902 L F
.47911 .41438 m .50271 .41025 L .5019 .4308 L p F P
0 g
s
.51915 .41545 m .49274 .41874 L .49375 .4313 L p .651 .533 .706 r
F P
0 g
s
.51709 .41994 m .51915 .41545 L .49375 .4313 L .651 .533 .706 r
F
.5019 .4308 m .50186 .43162 L p .50081 .43082 L .625 .469 .651 r
F P
0 g
s
.49377 .4315 m .49274 .41874 L p .48819 .43107 L .624 .513 .707 r
F P
0 g
s
.50186 .43162 m .50097 .45428 L p .48826 .43108 L .625 .469 .651 r
F P
0 g
s
.50097 .45428 m .47631 .45716 L .47803 .4309 L p .625 .469 .651 r
F P
0 g
s
.47826 .4309 m .49106 .4233 L .47803 .4309 L .624 .513 .707 r
F
.45637 .471 m .47087 .43529 L .46612 .43511 L .589 .489 .709 r
F
.45152 .43986 m .45637 .471 L p .46612 .43511 L F P
0 g
s
.46615 .43511 m .47776 .43507 L .46615 .43511 L .587 .436 .643 r
F
.45888 .41933 m .47686 .43432 L .46615 .43511 L F
.47686 .43432 m .47776 .43507 L .46615 .43511 L F
.46769 .42933 m .46816 .42761 L .45708 .43577 L .589 .489 .709 r
F
.4579 .43571 m .45708 .43577 L .45152 .43986 L F
.46769 .42933 m .45708 .43577 L .4579 .43571 L F
.46612 .43511 m .46769 .42933 L .45847 .43534 L F
.46612 .43511 m .45847 .43534 L .45152 .43986 L F
.47631 .45716 m .45512 .46089 L .45676 .44271 L p .587 .436 .643 r
F P
0 g
s
.45676 .44271 m .45743 .43537 L p .46159 .44017 L .587 .436 .643 r
F P
0 g
s
.46159 .44017 m .47631 .45716 L .45676 .44271 L .587 .436 .643 r
F
.47803 .4309 m .47781 .43425 L p .47546 .4324 L F P
0 g
s
.45888 .41933 m .47803 .4309 L .47546 .4324 L .587 .436 .643 r
F
.45888 .41933 m .47781 .43425 L .47686 .43432 L F
.49274 .41874 m .46941 .423 L .47084 .43509 L p .624 .513 .707 r
F P
0 g
s
.49106 .4233 m .49274 .41874 L .47084 .43509 L .624 .513 .707 r
F
.44242 .42492 m .45714 .43854 L .4477 .43987 L .534 .389 .63 r
F
.44181 .47494 m .45637 .471 L .45149 .43966 L p .541 .457 .709 r
F P
0 g
s
.44181 .47494 m .45149 .43966 L .4477 .43987 L .541 .457 .709 r
F
.4477 .43987 m .44065 .44048 L .43607 .44481 L F
.4477 .43987 m .4477 .43987 L .45512 .46089 L .534 .389 .63 r
F
.45714 .43854 m .45707 .43936 L p .4477 .43987 L F P
0 g
s
.45707 .43936 m .45512 .46089 L p .4477 .43987 L .534 .389 .63 r
F P
0 g
s
.45149 .43966 m .44969 .42806 L p .4477 .43987 L .541 .457 .709 r
F P
0 g
s
.46941 .423 m .44969 .42806 L .45096 .43622 L p .589 .489 .709 r
F P
0 g
s
.45096 .43622 m .45149 .43966 L p .45556 .43588 L .589 .489 .709 r
F P
0 g
s
.45556 .43588 m .46941 .423 L .45096 .43622 L .589 .489 .709 r
F
.47781 .43425 m .47776 .43507 L p .47686 .43432 L .587 .436 .643 r
F P
0 g
s
.47087 .43529 m .47084 .43509 L p .46615 .43511 L .589 .489 .709 r
F P
0 g
s
.47776 .43507 m .47631 .45716 L p .46615 .43511 L .587 .436 .643 r
F P
0 g
s
.46612 .43511 m .46615 .43511 L .46941 .423 L .589 .489 .709 r
F
.47084 .43509 m .46941 .423 L p .46615 .43511 L F P
0 g
s
.46615 .43511 m .47631 .45716 L .45743 .43537 L .587 .436 .643 r
F
.45763 .43536 m .46816 .42761 L .45743 .43537 L .589 .489 .709 r
F
.43119 .47922 m .44181 .47494 L .43607 .44481 L p .466 .407 .707 r
F P
0 g
s
.43119 .47922 m .43607 .44481 L .43326 .44515 L .466 .407 .707 r
F
.43326 .44516 m .43326 .44515 L .43324 .44516 L F
.43326 .44516 m .42795 .44603 L .42477 .45033 L F
.43324 .44516 m .43326 .44515 L .43782 .46527 L .45 .313 .602 r
F
.44031 .44348 m .44021 .44429 L p .43326 .44515 L F P
0 g
s
.44021 .44429 m .43782 .46527 L p .43326 .44515 L .45 .313 .602 r
F P
0 g
s
.43 .43095 m .44031 .44348 L .43324 .44516 L .45 .313 .602 r
F
.43607 .44481 m .43395 .4337 L p .43326 .44515 L .466 .407 .707 r
F P
0 g
s
.45512 .46089 m .43782 .46527 L .43985 .44746 L p .534 .389 .63 r
F P
0 g
s
.43985 .44746 m .44065 .44048 L p .44379 .4449 L .534 .389 .63 r
F P
0 g
s
.44379 .4449 m .45512 .46089 L .43985 .44746 L .534 .389 .63 r
F
.46816 .42761 m .46941 .423 L .45149 .43966 L .589 .489 .709 r
F
.45743 .43537 m .45714 .43854 L p .45534 .43688 L .534 .389 .63 r
F P
0 g
s
.4477 .43987 m .44891 .43268 L .44065 .44048 L .541 .457 .709 r
F
.4477 .43987 m .45512 .46089 L .44065 .44048 L .534 .389 .63 r
F
.44969 .42806 m .43395 .4337 L .43607 .44481 L p .541 .457 .709 r
F P
0 g
s
.44891 .43268 m .44969 .42806 L .43607 .44481 L .541 .457 .709 r
F
.44065 .44048 m .44031 .44348 L p .43907 .44197 L .45 .313 .602 r
F P
0 g
s
.43324 .44516 m .43367 .4383 L .42795 .44603 L .466 .407 .707 r
F
.43326 .44515 m .43367 .4383 L .43324 .44516 L F
.42463 .4739 m .42474 .47329 L p .42433 .47379 L .932 .783 .673 r
F P
0 g
s
.44445 .50296 m .43453 .49992 L .42682 .47464 L p .876 .635 .57 r
F P
0 g
s
.44445 .50296 m .42682 .47464 L .42784 .47384 L .876 .635 .57 r
F
.42457 .48367 m .43119 .47922 L .42477 .45033 L p .329 .316 .693 r
F P
0 g
s
.42457 .48367 m .42477 .45033 L .42296 .45077 L .329 .316 .693 r
F
.42296 .45078 m .42296 .45077 L .42293 .45078 L F
.42296 .45078 m .41945 .45183 L .41767 .45604 L F
.42293 .45078 m .42296 .45077 L .4247 .47011 L .288 .168 .538 r
F
.42757 .44886 m .42746 .44967 L p .42296 .45077 L F P
0 g
s
.42746 .44967 m .4247 .47011 L p .42296 .45077 L .288 .168 .538 r
F P
0 g
s
.4217 .4372 m .42757 .44886 L .42293 .45078 L .288 .168 .538 r
F
.42477 .45033 m .42242 .43974 L p .42296 .45077 L .329 .316 .693 r
F P
0 g
s
.43782 .46527 m .4247 .47011 L .42795 .44603 L p .45 .313 .602 r
F P
0 g
s
.43324 .44516 m .43782 .46527 L .42795 .44603 L .45 .313 .602 r
F
.43395 .4337 m .42242 .43974 L .42477 .45033 L p .466 .407 .707 r
F P
0 g
s
.43367 .4383 m .43395 .4337 L .42477 .45033 L .466 .407 .707 r
F
.42795 .44603 m .42757 .44886 L p .42688 .44749 L .288 .168 .538 r
F P
0 g
s
.42293 .45078 m .42264 .44428 L .41945 .45183 L .329 .316 .693 r
F
.42296 .45077 m .42264 .44428 L .42293 .45078 L F
.42185 .48811 m .41772 .45624 L .41706 .45646 L .02 .106 .614 r
F
.4165 .46776 m .41647 .46774 L .4165 .46777 L .993 .857 .596 r
F
.41466 .46175 m .42185 .48811 L p .41683 .45653 L .02 .106 .614 r
F P
0 g
s
.41747 .4435 m .41884 .45468 L .41681 .45654 L 0 0 .333 r
F
.41683 .45653 m .41586 .45042 L .41503 .45818 L .02 .106 .614 r
F
.41683 .45653 m .41503 .45818 L .41466 .46175 L F
.41884 .45468 m .41891 .45531 L .41683 .45653 L 0 0 .333 r
F
.41884 .45468 m .41683 .45653 L .41681 .45654 L F
.41683 .45653 m .41597 .44926 L .41586 .45042 L .02 .106 .614 r
F
.42185 .48811 m .41705 .4564 L .41683 .45653 L F
.41705 .4564 m .41597 .44926 L .41683 .45653 L F
.41075 .48545 m .41403 .49025 L .417 .47426 L p .993 .857 .596 r
F P
0 g
s
.41656 .47215 m .41075 .48545 L .417 .47426 L .993 .857 .596 r
F
.4247 .47011 m .41585 .47521 L .41945 .45183 L p .288 .168 .538 r
F P
0 g
s
.42293 .45078 m .4247 .47011 L .41945 .45183 L .288 .168 .538 r
F
.42242 .43974 m .41515 .44595 L .41767 .45604 L p .329 .316 .693 r
F P
0 g
s
.42264 .44428 m .42242 .43974 L .41767 .45604 L .329 .316 .693 r
F
.41945 .45183 m .41891 .45531 L p .4187 .45359 L 0 0 .333 r
F P
0 g
s
.41772 .45624 m .41767 .45604 L p .41706 .45646 L .02 .106 .614 r
F P
0 g
s
.41706 .45646 m .41767 .45604 L .41705 .4564 L .02 .106 .614 r
F
.41891 .45531 m .41585 .47521 L p .41681 .45654 L 0 0 .333 r
F P
0 g
s
.41767 .45604 m .41597 .44926 L p .41705 .4564 L .02 .106 .614 r
F P
0 g
s
.41597 .44926 m .41515 .44595 L p .41586 .45042 L .02 .106 .614 r
F P
0 g
s
.41509 .45768 m .41466 .4602 L p .41495 .459 L .815 .755 .237 r
F P
0 g
s
.41126 .48038 m .41075 .48545 L .4147 .46341 L p .815 .755 .237 r
F P
0 g
s
.41474 .46226 m .41126 .48038 L .4147 .46341 L .815 .755 .237 r
F
.41553 .46728 m .41559 .46748 L p .41538 .46655 L 0 0 .222 r
F P
0 g
s
.4147 .46341 m .41427 .46578 L p .41496 .46464 L .993 .857 .596 r
F P
0 g
s
.41585 .47521 m .41126 .48038 L .41509 .45768 L p 0 0 .333 r
F P
0 g
s
.41681 .45655 m .41585 .47521 L .41509 .45768 L 0 0 .333 r
F
.41515 .44595 m .41204 .45216 L .41378 .45854 L p .02 .106 .614 r
F P
0 g
s
.41477 .45789 m .41515 .44595 L .41378 .45854 L .02 .106 .614 r
F
.42282 .49239 m .42263 .49158 L p .42153 .48759 L 0 0 .222 r
F P
0 g
s
.42263 .49158 m .42185 .48811 L p .42153 .48759 L 0 0 .222 r
F P
0 g
s
.41331 .4568 m .41204 .45216 L p .41366 .45819 L 0 0 .222 r
F P
0 g
s
.43453 .49992 m .44445 .50296 L .46004 .52625 L p .854 .551 .476 r
F P
0 g
s
.47039 .52702 m .46004 .52625 L .44445 .50296 L p .814 .541 .526 r
F P
0 g
s
.57735 .50618 m .5814 .50225 L .57193 .50672 L p .876 .968 .849 r
F P
0 g
s
.57193 .50672 m .56928 .51111 L .57735 .50618 L p .876 .968 .849 r
F P
0 g
s
.52104 .2943 m .52013 .29976 L .47937 .3162 L p .8 .814 .862 r
F P
0 g
s
.47922 .32328 m .47937 .3162 L .52013 .29976 L p .787 .775 .842 r
F P
0 g
s
.55314 .52358 m .55982 .51961 L .55546 .51982 L p .687 .949 .681 r
F P
0 g
s
.55546 .51982 m .55129 .52418 L .55314 .52358 L p .687 .949 .681 r
F P
0 g
s
.46004 .52625 m .47039 .52702 L .48855 .54146 L p .768 .45 .449 r
F P
0 g
s
.49763 .54018 m .48855 .54146 L .47039 .52702 L p .74 .444 .48 r
F P
0 g
s
.44949 .35826 m .44672 .35054 L .47922 .32328 L p .834 .807 .825 r
F P
0 g
s
.44672 .35054 m .44949 .35826 L .42803 .39191 L p .9 .845 .781 r
F P
0 g
s
.60392 .66934 m .6152 .66326 L .57839 .66752 L p .819 .881 .89 r
F P
0 g
s
.57839 .66752 m .57341 .67277 L .60392 .66934 L p .819 .881 .89 r
F P
0 g
s
.53915 .35746 m .53822 .36211 L .56063 .37437 L p .867 .551 .45 r
F P
0 g
s
.56147 .37778 m .56063 .37437 L .53822 .36211 L p .827 .551 .522 r
F P
0 g
s
.45902 .70243 m .47405 .70089 L .51498 .70717 L p .589 .234 .335 r
F P
0 g
s
.52234 .70372 m .51498 .70717 L .47405 .70089 L p .544 .183 .305 r
F P
0 g
s
.61128 .30595 m .60685 .30705 L .56396 .30829 L p .669 .439 .563 r
F P
0 g
s
.5623 .31175 m .56396 .30829 L .60685 .30705 L p .641 .415 .56 r
F P
0 g
s
.49763 .54018 m .50732 .53845 L .52145 .54279 L p .634 .332 .441 r
F P
0 g
s
.52804 .5396 m .52145 .54279 L .50732 .53845 L p .593 .291 .426 r
F P
0 g
s
.52275 .28887 m .52104 .2943 L .48148 .30906 L p .81 .863 .888 r
F P
0 g
s
.47937 .3162 m .48148 .30906 L .52104 .2943 L p .8 .814 .862 r
F P
0 g
s
.55982 .51961 m .56523 .51543 L .55873 .51533 L p .883 .968 .841 r
F P
0 g
s
.55873 .51533 m .55546 .51982 L .55982 .51961 L p .883 .968 .841 r
F P
0 g
s
.46249 .40877 m .45758 .40253 L .43571 .42569 L p .831 .771 .796 r
F P
0 g
s
.45758 .40253 m .46249 .40877 L .48719 .39319 L p .776 .728 .808 r
F P
0 g
s
.53822 .36211 m .53762 .36678 L .56147 .37778 L p .827 .551 .522 r
F P
0 g
s
.56184 .38121 m .56147 .37778 L .53762 .36678 L p .794 .544 .56 r
F P
0 g
s
.56147 .37778 m .56184 .38121 L .58163 .39634 L p .83 .365 .098 r
F P
0 g
s
.48719 .39319 m .4836 .38719 L .45758 .40253 L p .776 .728 .808 r
F P
0 g
s
.4836 .38719 m .48719 .39319 L .51327 .38546 L p .729 .664 .785 r
F P
0 g
s
.60685 .30705 m .60099 .30848 L .5623 .31175 L p .641 .415 .56 r
F P
0 g
s
.56032 .31531 m .5623 .31175 L .60099 .30848 L p .608 .383 .551 r
F P
0 g
s
.59293 .48904 m .59424 .48575 L .58427 .49437 L p .911 .929 .812 r
F P
0 g
s
.58427 .49437 m .58368 .49828 L .59293 .48904 L p .911 .929 .812 r
F P
0 g
s
.59498 .4158 m .59565 .41483 L .58163 .39634 L p .877 .439 .09 r
F P
0 g
s
.59565 .41483 m .59498 .4158 L .60233 .43438 L p .919 .562 .118 r
F P
0 g
s
.60233 .43438 m .60342 .43456 L .59565 .41483 L p .919 .562 .118 r
F P
0 g
s
.47937 .3162 m .47922 .32328 L .44672 .35054 L p .857 .868 .847 r
F P
0 g
s
.58131 .39854 m .58163 .39634 L .56184 .38121 L p .836 .46 .34 r
F P
0 g
s
.58163 .39634 m .58131 .39854 L .59498 .4158 L p .877 .439 .09 r
F P
0 g
s
.66112 .32172 m .65659 .31994 L .61128 .30595 L p .642 .122 0 r
F P
0 g
s
.65659 .31994 m .66112 .32172 L .70325 .35124 L p .618 .057 0 r
F P
0 g
s
.75192 .57682 m .75627 .56737 L .76619 .50869 L p 0 0 .189 r
F P
0 g
s
.75627 .56737 m .75192 .57682 L .72576 .63175 L p .654 .781 .318 r
F P
0 g
s
.52523 .2835 m .52275 .28887 L .48559 .30194 L p .806 .919 .914 r
F P
0 g
s
.48148 .30906 m .48559 .30194 L .52275 .28887 L p .81 .863 .888 r
F P
0 g
s
.59368 .48258 m .59424 .48575 L .60152 .47234 L p .959 .925 .723 r
F P
0 g
s
.5814 .50225 m .58368 .49828 L .57321 .50234 L p .863 .859 .835 r
F P
0 g
s
.57321 .50234 m .57193 .50672 L .5814 .50225 L p .863 .859 .835 r
F P
0 g
s
.71748 .58638 m .72207 .57781 L .68346 .61366 L p .853 .994 .83 r
F P
0 g
s
.68346 .61366 m .68022 .62153 L .71748 .58638 L p .853 .994 .83 r
F P
0 g
s
.42803 .39191 m .42437 .38419 L .44672 .35054 L p .9 .845 .781 r
F P
0 g
s
.42437 .38419 m .42803 .39191 L .41736 .42814 L p .961 .849 .687 r
F P
0 g
s
.60357 .45228 m .60511 .45352 L .60342 .43456 L p .992 .757 .386 r
F P
0 g
s
.51327 .38546 m .51115 .38005 L .4836 .38719 L p .729 .664 .785 r
F P
0 g
s
.51115 .38005 m .51327 .38546 L .53837 .38529 L p .705 .584 .718 r
F P
0 g
s
.48855 .54146 m .49763 .54018 L .51499 .54569 L p .667 .358 .441 r
F P
0 g
s
.52145 .54279 m .51499 .54569 L .49763 .54018 L p .634 .332 .441 r
F P
0 g
s
.60099 .30848 m .59395 .31031 L .56032 .31531 L p .608 .383 .551 r
F P
0 g
s
.5581 .31901 m .56032 .31531 L .59395 .31031 L p .564 .339 .533 r
F P
0 g
s
.67326 .62927 m .68022 .62153 L .63549 .64343 L p .809 .933 .914 r
F P
0 g
s
.63549 .64343 m .63113 .65022 L .67326 .62927 L p .809 .933 .914 r
F P
0 g
s
.53762 .36678 m .53736 .37145 L .56184 .38121 L p .794 .544 .56 r
F P
0 g
s
.56176 .38466 m .56184 .38121 L .53736 .37145 L p .766 .534 .583 r
F P
0 g
s
.56184 .38121 m .56176 .38466 L .58131 .39854 L p .836 .46 .34 r
F P
0 g
s
.56523 .51543 m .56928 .51111 L .56107 .51076 L p .874 .865 .827 r
F P
0 g
s
.56107 .51076 m .55873 .51533 L .56523 .51543 L p .874 .865 .827 r
F P
0 g
s
.61129 .73105 m .61909 .72479 L .6676 .69382 L p 0 0 0 r
F P
0 g
s
.60685 .30705 m .61128 .30595 L .65659 .31994 L p .657 .187 .127 r
F P
0 g
s
.52846 .27824 m .52523 .2835 L .4917 .29496 L p .766 .971 .924 r
F P
0 g
s
.48559 .30194 m .4917 .29496 L .52523 .2835 L p .806 .919 .914 r
F P
0 g
s
.59395 .31031 m .58598 .31256 L .5581 .31901 L p .564 .339 .533 r
F P
0 g
s
.55571 .32282 m .5581 .31901 L .58448 .3129 L p .5 .273 .501 r
F P
0 g
s
.58448 .3129 m .58503 .31278 L p .58414 .31308 L .5 .273 .501 r
F P
0 g
s
.55571 .32282 m .58448 .3129 L .58414 .31308 L .5 .273 .501 r
F
.55571 .32282 m .58503 .31278 L .58401 .31323 L F
.58598 .31256 m .57735 .31526 L .55571 .32282 L p F P
0 g
s
.55322 .32677 m .55571 .32282 L .57621 .31566 L p .395 .163 .439 r
F P
0 g
s
.57621 .31566 m .57735 .31526 L p .57551 .31614 L .395 .163 .439 r
F P
0 g
s
.55322 .32677 m .57621 .31566 L .57551 .31614 L .395 .163 .439 r
F
.57735 .31526 m .56836 .31843 L .56786 .31871 L p F P
0 g
s
.56786 .31871 m .55349 .32662 L p .5755 .31615 L .395 .163 .439 r
F P
0 g
s
.5755 .31615 m .57735 .31526 L .56786 .31871 L .395 .163 .439 r
F
.55402 .32639 m .57735 .31526 L .55349 .32662 L F
.55349 .32662 m .55322 .32677 L p .55402 .32639 L F P
0 g
s
.55073 .33085 m .55322 .32677 L .56836 .31843 L p .19 0 .302 r
F P
0 g
s
.56836 .31843 m .55928 .32206 L .55108 .33049 L p .19 0 .302 r
F P
0 g
s
.55108 .33049 m .55073 .33085 L p .55171 .33016 L .19 0 .302 r
F P
0 g
s
.55171 .33016 m .56836 .31843 L .55108 .33049 L .19 0 .302 r
F
.54829 .33505 m .55073 .33085 L .55928 .32206 L p 0 0 0 r
F P
0 g
s
.55928 .32206 m .55039 .32613 L .54838 .33469 L p 0 0 0 r
F P
0 g
s
.54838 .33469 m .54829 .33505 L p .54891 .33432 L 0 0 0 r
F P
0 g
s
.54891 .33432 m .55928 .32206 L .54838 .33469 L 0 0 0 r
F
.58503 .31278 m .58598 .31256 L p .58401 .31323 L .5 .273 .501 r
F P
0 g
s
.6152 .66326 m .62433 .65686 L .58238 .66214 L p .806 .823 .864 r
F P
0 g
s
.58238 .66214 m .57839 .66752 L .6152 .66326 L p .806 .823 .864 r
F P
0 g
s
.53736 .37145 m .53741 .3761 L .56176 .38466 L p .766 .534 .583 r
F P
0 g
s
.56127 .38817 m .56176 .38466 L .53741 .3761 L p .742 .523 .598 r
F P
0 g
s
.56176 .38466 m .56127 .38817 L .58 .40088 L p .806 .487 .45 r
F P
0 g
s
.58 .40088 m .58131 .39854 L .56176 .38466 L p .806 .487 .45 r
F P
0 g
s
.60511 .45352 m .60357 .45228 L .59951 .4678 L p .979 .846 .639 r
F P
0 g
s
.59951 .4678 m .60145 .46997 L .60511 .45352 L p .979 .846 .639 r
F P
0 g
s
.46004 .52625 m .45143 .52499 L .43453 .49992 L p .854 .551 .476 r
F P
0 g
s
.45143 .52499 m .46004 .52625 L .48045 .54233 L p .797 .447 .393 r
F P
0 g
s
.48855 .54146 m .48045 .54233 L .46004 .52625 L p .768 .45 .449 r
F P
0 g
s
.58131 .39854 m .58 .40088 L .59291 .41697 L p .884 .535 .383 r
F P
0 g
s
.59291 .41697 m .59498 .4158 L .58131 .39854 L p .884 .535 .383 r
F P
0 g
s
.48167 .38093 m .4836 .38719 L .51115 .38005 L p .745 .685 .793 r
F P
0 g
s
.51115 .38005 m .50998 .37448 L .48167 .38093 L p .745 .685 .793 r
F P
0 g
s
.50998 .37448 m .51115 .38005 L .53776 .38071 L p .723 .601 .72 r
F P
0 g
s
.53837 .38529 m .53776 .38071 L .51115 .38005 L p .705 .584 .718 r
F P
0 g
s
.53776 .38071 m .53837 .38529 L .56042 .39174 L p .72 .511 .607 r
F P
0 g
s
.53237 .27312 m .52846 .27824 L .49974 .28823 L p .634 .964 .865 r
F P
0 g
s
.4917 .29496 m .49974 .28823 L .52846 .27824 L p .766 .971 .924 r
F P
0 g
s
.53776 .38071 m .53741 .3761 L .50998 .37448 L p .723 .601 .72 r
F P
0 g
s
.53741 .3761 m .53776 .38071 L .56127 .38817 L p .742 .523 .598 r
F P
0 g
s
.56042 .39174 m .56127 .38817 L .53776 .38071 L p .72 .511 .607 r
F P
0 g
s
.57741 .74811 m .56347 .75307 L .55144 .76159 L p 0 0 0 r
F P
0 g
s
.50989 .36879 m .50998 .37448 L .53741 .3761 L p .741 .618 .723 r
F P
0 g
s
.53741 .3761 m .53736 .37145 L .50989 .36879 L p .741 .618 .723 r
F P
0 g
s
.56928 .51111 m .57193 .50672 L .56247 .50617 L p .84 .785 .799 r
F P
0 g
s
.56247 .50617 m .56107 .51076 L .56928 .51111 L p .84 .785 .799 r
F P
0 g
s
.44577 .7035 m .45902 .70243 L .50825 .71041 L p .622 .267 .347 r
F P
0 g
s
.51498 .70717 m .50825 .71041 L .45902 .70243 L p .589 .234 .335 r
F P
0 g
s
.455 .39593 m .45758 .40253 L .4836 .38719 L p .796 .763 .823 r
F P
0 g
s
.4836 .38719 m .48167 .38093 L .455 .39593 L p .796 .763 .823 r
F P
0 g
s
.37805 .6736 m .36506 .67122 L .31517 .6212 L p .842 .437 .275 r
F P
0 g
s
.36506 .67122 m .37805 .6736 L .43472 .70415 L p .734 .266 .138 r
F P
0 g
s
.44577 .7035 m .43472 .70415 L .37805 .6736 L p .734 .315 .253 r
F P
0 g
s
.51095 .36304 m .50989 .36879 L .53736 .37145 L p .76 .638 .726 r
F P
0 g
s
.53736 .37145 m .53762 .36678 L .51095 .36304 L p .76 .638 .726 r
F P
0 g
s
.59498 .4158 m .59291 .41697 L .59959 .43443 L p .938 .643 .455 r
F P
0 g
s
.59959 .43443 m .60233 .43438 L .59498 .4158 L p .938 .643 .455 r
F P
0 g
s
.59424 .48575 m .59368 .48258 L .58331 .4906 L p .866 .821 .803 r
F P
0 g
s
.58331 .4906 m .58427 .49437 L .59424 .48575 L p .866 .821 .803 r
F P
0 g
s
.58368 .49828 m .58427 .49437 L .5732 .49802 L p .827 .779 .807 r
F P
0 g
s
.5732 .49802 m .57321 .50234 L .58368 .49828 L p .827 .779 .807 r
F P
0 g
s
.51323 .35728 m .51095 .36304 L .53762 .36678 L p .781 .66 .73 r
F P
0 g
s
.53762 .36678 m .53822 .36211 L .51323 .35728 L p .781 .66 .73 r
F P
0 g
s
.56127 .38817 m .56042 .39174 L .57783 .40338 L p .775 .493 .508 r
F P
0 g
s
.57783 .40338 m .58 .40088 L .56127 .38817 L p .775 .493 .508 r
F P
0 g
s
.53689 .26818 m .53237 .27312 L .50956 .28184 L p .361 .807 .665 r
F P
0 g
s
.49974 .28823 m .50956 .28184 L .53237 .27312 L p .634 .964 .865 r
F P
0 g
s
.48045 .54233 m .48855 .54146 L .5089 .54829 L p .695 .373 .428 r
F P
0 g
s
.51499 .54569 m .5089 .54829 L .48855 .54146 L p .667 .358 .441 r
F P
0 g
s
.44672 .35054 m .44669 .34258 L .47937 .3162 L p .857 .868 .847 r
F P
0 g
s
.44669 .34258 m .44672 .35054 L .42437 .38419 L p .935 .936 .774 r
F P
0 g
s
.48148 .30906 m .47937 .3162 L .44669 .34258 L p .868 .946 .864 r
F P
0 g
s
.51674 .35157 m .51323 .35728 L .53822 .36211 L p .804 .688 .736 r
F P
0 g
s
.53822 .36211 m .53915 .35746 L .51674 .35157 L p .804 .688 .736 r
F P
0 g
s
.42717 .49637 m .43453 .49992 L .45143 .52499 L p .899 .547 .37 r
F P
0 g
s
.24415 .46124 m .25095 .4735 L .26751 .54878 L p .939 .648 .186 r
F P
0 g
s
.41736 .42814 m .4131 .42113 L .42437 .38419 L p .961 .849 .687 r
F P
0 g
s
.52146 .34599 m .51674 .35157 L .53915 .35746 L p .833 .723 .743 r
F P
0 g
s
.53915 .35746 m .54042 .35284 L .52146 .34599 L p .833 .723 .743 r
F P
0 g
s
.70325 .35124 m .69742 .34695 L .65659 .31994 L p .618 .057 0 r
F P
0 g
s
.69742 .34695 m .70325 .35124 L .73673 .39242 L p .775 .291 0 r
F P
0 g
s
.52804 .5396 m .53452 .53612 L .54174 .53243 L p .399 .155 .424 r
F P
0 g
s
.55039 .32613 m .54196 .33061 L .54599 .33937 L p .833 .932 .555 r
F P
0 g
s
.54388 .34378 m .54599 .33937 L .54196 .33061 L p .952 .932 .739 r
F P
0 g
s
.54196 .33061 m .5342 .33544 L .54388 .34378 L p .952 .932 .739 r
F P
0 g
s
.5342 .33544 m .54196 .33061 L .53789 .33225 L p .449 .855 .678 r
F P
0 g
s
.53789 .33225 m .54196 .33061 L p .54735 .32924 L 0 0 0 r
F P
0 g
s
.54599 .33937 m .54829 .33505 L .54992 .32816 L p .833 .932 .555 r
F P
0 g
s
.54599 .33937 m .54992 .32816 L .54969 .32826 L .833 .932 .555 r
F
.55256 .32793 m .54563 .32997 L p .54735 .32924 L 0 0 0 r
F P
0 g
s
.54563 .32997 m .53789 .33225 L p .54735 .32924 L 0 0 0 r
F P
0 g
s
.54992 .32816 m .55039 .32613 L p .54969 .32826 L .833 .932 .555 r
F P
0 g
s
.5419 .26346 m .53689 .26818 L .52096 .2759 L p 0 0 0 r
F P
0 g
s
.50956 .28184 m .52096 .2759 L .53689 .26818 L p .361 .807 .665 r
F P
0 g
s
.54633 .52838 m .55129 .52418 L .54953 .51956 L p .857 .944 .581 r
F P
0 g
s
.52731 .34059 m .52146 .34599 L .54042 .35284 L p .869 .772 .752 r
F P
0 g
s
.54042 .35284 m .54201 .34828 L .52731 .34059 L p .869 .772 .752 r
F P
0 g
s
.5342 .33544 m .52731 .34059 L .54201 .34828 L p .914 .84 .758 r
F P
0 g
s
.54201 .34828 m .54388 .34378 L .5342 .33544 L p .914 .84 .758 r
F P
0 g
s
.55144 .76159 m .5539 .75706 L .57741 .74811 L p 0 0 0 r
F P
0 g
s
.59022 .74276 m .57741 .74811 L .5539 .75706 L p .31 .786 .693 r
F P
0 g
s
.31517 .6212 m .30381 .61531 L .26751 .54878 L p .93 .556 .268 r
F P
0 g
s
.30381 .61531 m .31517 .6212 L .36506 .67122 L p .82 .34 .033 r
F P
0 g
s
.43265 .41921 m .43571 .42569 L .45758 .40253 L p .863 .829 .812 r
F P
0 g
s
.45758 .40253 m .455 .39593 L .43265 .41921 L p .863 .829 .812 r
F P
0 g
s
.60145 .46997 m .59951 .4678 L .59145 .47963 L p .9 .817 .757 r
F P
0 g
s
.59145 .47963 m .59368 .48258 L .60145 .46997 L p .9 .817 .757 r
F P
0 g
s
.4816 .37447 m .48167 .38093 L .50998 .37448 L p .762 .709 .802 r
F P
0 g
s
.50998 .37448 m .50989 .36879 L .4816 .37447 L p .762 .709 .802 r
F P
0 g
s
.52096 .2759 m .53367 .2705 L .5419 .26346 L p 0 0 0 r
F P
0 g
s
.60233 .43438 m .59959 .43443 L .60031 .45131 L p .943 .732 .589 r
F P
0 g
s
.60031 .45131 m .60357 .45228 L .60233 .43438 L p .943 .732 .589 r
F P
0 g
s
.52145 .54279 m .52804 .5396 L .53866 .53648 L p .504 .264 .484 r
F P
0 g
s
.54174 .53243 m .53866 .53648 L .52804 .5396 L p .399 .155 .424 r
F P
0 g
s
.55129 .52418 m .55546 .51982 L .55138 .5151 L p .953 .917 .739 r
F P
0 g
s
.55138 .5151 m .54953 .51956 L .55129 .52418 L p .953 .917 .739 r
F P
0 g
s
.41796 .52727 m .42426 .53024 L .42074 .49464 L p .96 .733 .551 r
F P
0 g
s
.42074 .49464 m .41403 .49025 L .41796 .52727 L p .96 .733 .551 r
F P
0 g
s
.58 .40088 m .57783 .40338 L .58962 .41839 L p .838 .547 .496 r
F P
0 g
s
.58962 .41839 m .59291 .41697 L .58 .40088 L p .838 .547 .496 r
F P
0 g
s
.57193 .50672 m .57321 .50234 L .56295 .50159 L p .809 .729 .777 r
F P
0 g
s
.56295 .50159 m .56247 .50617 L .57193 .50672 L p .809 .729 .777 r
F P
0 g
s
.74964 .53114 m .74983 .52221 L .72189 .56923 L p .939 .965 .725 r
F P
0 g
s
.72189 .56923 m .72207 .57781 L .74964 .53114 L p .939 .965 .725 r
F P
0 g
s
.65659 .31994 m .64928 .31857 L .60685 .30705 L p .657 .187 .127 r
F P
0 g
s
.60099 .30848 m .60685 .30705 L .64928 .31857 L p .647 .213 .204 r
F P
0 g
s
.55546 .51982 m .55873 .51533 L .55278 .51058 L p .908 .82 .748 r
F P
0 g
s
.55278 .51058 m .55138 .5151 L .55546 .51982 L p .908 .82 .748 r
F P
0 g
s
.51499 .54569 m .52145 .54279 L .53549 .5404 L p .567 .329 .514 r
F P
0 g
s
.53866 .53648 m .53549 .5404 L .52145 .54279 L p .504 .264 .484 r
F P
0 g
s
.58427 .49437 m .58331 .4906 L .57205 .49383 L p .795 .723 .785 r
F P
0 g
s
.57205 .49383 m .5732 .49802 L .58427 .49437 L p .795 .723 .785 r
F P
0 g
s
.60357 .45228 m .60031 .45131 L .59595 .46592 L p .903 .762 .696 r
F P
0 g
s
.59595 .46592 m .59951 .4678 L .60357 .45228 L p .903 .762 .696 r
F P
0 g
s
.59291 .41697 m .58962 .41839 L .59545 .4348 L p .874 .626 .561 r
F P
0 g
s
.59545 .4348 m .59959 .43443 L .59291 .41697 L p .874 .626 .561 r
F P
0 g
s
.48355 .36791 m .4816 .37447 L .50989 .36879 L p .779 .738 .816 r
F P
0 g
s
.50989 .36879 m .51095 .36304 L .48355 .36791 L p .779 .738 .816 r
F P
0 g
s
.55873 .51533 m .56107 .51076 L .55371 .50604 L p .862 .751 .738 r
F P
0 g
s
.55371 .50604 m .55278 .51058 L .55873 .51533 L p .862 .751 .738 r
F P
0 g
s
.5539 .75706 m .55615 .75246 L .59022 .74276 L p .31 .786 .693 r
F P
0 g
s
.6016 .73706 m .59022 .74276 L .55615 .75246 L p .551 .931 .877 r
F P
0 g
s
.59368 .48258 m .59145 .47963 L .58101 .48703 L p .822 .75 .784 r
F P
0 g
s
.58101 .48703 m .58331 .4906 L .59368 .48258 L p .822 .75 .784 r
F P
0 g
s
.76482 .49946 m .76619 .50869 L .75627 .56737 L p .936 .84 .398 r
F P
0 g
s
.62433 .65686 m .63113 .65022 L .58531 .65666 L p .79 .778 .842 r
F P
0 g
s
.58531 .65666 m .58238 .66214 L .62433 .65686 L p .79 .778 .842 r
F P
0 g
s
.45502 .38908 m .455 .39593 L .48167 .38093 L p .817 .808 .842 r
F P
0 g
s
.48167 .38093 m .4816 .37447 L .45502 .38908 L p .817 .808 .842 r
F P
0 g
s
.57321 .50234 m .5732 .49802 L .5626 .49708 L p .782 .688 .76 r
F P
0 g
s
.5626 .49708 m .56295 .50159 L .57321 .50234 L p .782 .688 .76 r
F P
0 g
s
.64928 .31857 m .65659 .31994 L .69742 .34695 L p .744 .243 .034 r
F P
0 g
s
.48045 .54233 m .47368 .54282 L .45143 .52499 L p .797 .447 .393 r
F P
0 g
s
.47368 .54282 m .48045 .54233 L .50344 .55062 L p .72 .378 .399 r
F P
0 g
s
.5089 .54829 m .50344 .55062 L .48045 .54233 L p .695 .373 .428 r
F P
0 g
s
.5089 .54829 m .51499 .54569 L .53236 .54417 L p .611 .371 .529 r
F P
0 g
s
.53549 .5404 m .53236 .54417 L .51499 .54569 L p .567 .329 .514 r
F P
0 g
s
.56107 .51076 m .56247 .50617 L .55418 .50149 L p .826 .702 .728 r
F P
0 g
s
.55418 .50149 m .55371 .50604 L .56107 .51076 L p .826 .702 .728 r
F P
0 g
s
.48559 .30194 m .48148 .30906 L .44956 .3345 L p .802 1 .822 r
F P
0 g
s
.44669 .34258 m .44956 .3345 L .48148 .30906 L p .868 .946 .864 r
F P
0 g
s
.45143 .52499 m .44499 .52328 L .42717 .49637 L p .899 .547 .37 r
F P
0 g
s
.44499 .52328 m .45143 .52499 L .47368 .54282 L p .823 .421 .285 r
F P
0 g
s
.42437 .38419 m .42404 .37616 L .44669 .34258 L p .935 .936 .774 r
F P
0 g
s
.42404 .37616 m .42437 .38419 L .4131 .42113 L p .965 .91 .554 r
F P
0 g
s
.59951 .4678 m .59595 .46592 L .58784 .47697 L p .844 .744 .753 r
F P
0 g
s
.58784 .47697 m .59145 .47963 L .59951 .4678 L p .844 .744 .753 r
F P
0 g
s
.59959 .43443 m .59545 .4348 L .59564 .45069 L p .873 .683 .643 r
F P
0 g
s
.59564 .45069 m .60031 .45131 L .59959 .43443 L p .873 .683 .643 r
F P
0 g
s
.67756 .68612 m .6839 .67818 L .72576 .63175 L p 0 0 0 r
F P
0 g
s
.72943 .62274 m .72576 .63175 L .6839 .67818 L p .837 .996 .761 r
F P
0 g
s
.72576 .63175 m .72943 .62274 L .75627 .56737 L p .654 .781 .318 r
F P
0 g
s
.43307 .56362 m .43841 .5649 L .42426 .53024 L p .949 .625 .381 r
F P
0 g
s
.42426 .53024 m .41796 .52727 L .43307 .56362 L p .949 .625 .381 r
F P
0 g
s
.4876 .36134 m .48355 .36791 L .51095 .36304 L p .796 .775 .833 r
F P
0 g
s
.51095 .36304 m .51323 .35728 L .4876 .36134 L p .796 .775 .833 r
F P
0 g
s
.43472 .70415 m .44577 .7035 L .50234 .71343 L p .649 .287 .345 r
F P
0 g
s
.50825 .71041 m .50234 .71343 L .44577 .7035 L p .622 .267 .347 r
F P
0 g
s
.58331 .4906 m .58101 .48703 L .56992 .48981 L p .767 .683 .77 r
F P
0 g
s
.56992 .48981 m .57205 .49383 L .58331 .4906 L p .767 .683 .77 r
F P
0 g
s
.56247 .50617 m .56295 .50159 L .55421 .49697 L p .797 .667 .719 r
F P
0 g
s
.55421 .49697 m .55418 .50149 L .56247 .50617 L p .797 .667 .719 r
F P
0 g
s
.5732 .49802 m .57205 .49383 L .56152 .49268 L p .759 .655 .747 r
F P
0 g
s
.56152 .49268 m .5626 .49708 L .5732 .49802 L p .759 .655 .747 r
F P
0 g
s
.73003 .38598 m .73673 .39242 L .75816 .44292 L p .933 .565 .167 r
F P
0 g
s
.73673 .39242 m .73003 .38598 L .69742 .34695 L p .775 .291 0 r
F P
0 g
s
.64928 .31857 m .63948 .31775 L .60099 .30848 L p .647 .213 .204 r
F P
0 g
s
.59395 .31031 m .60099 .30848 L .63948 .31775 L p .625 .214 .244 r
F P
0 g
s
.68022 .62153 m .68346 .61366 L .63737 .63656 L p .809 .869 .891 r
F P
0 g
s
.63737 .63656 m .63549 .64343 L .68022 .62153 L p .809 .869 .891 r
F P
0 g
s
.61909 .72479 m .62484 .71834 L .67756 .68612 L p .549 .913 .732 r
F P
0 g
s
.6839 .67818 m .67756 .68612 L .62484 .71834 L p .764 .989 .892 r
F P
0 g
s
.50344 .55062 m .5089 .54829 L .52939 .54779 L p .644 .401 .535 r
F P
0 g
s
.53236 .54417 m .52939 .54779 L .5089 .54829 L p .611 .371 .529 r
F P
0 g
s
.55615 .75246 m .55814 .74781 L .6016 .73706 L p .551 .931 .877 r
F P
0 g
s
.61129 .73105 m .6016 .73706 L .55814 .74781 L p .69 .959 .947 r
F P
0 g
s
.59145 .47963 m .58784 .47697 L .57762 .48372 L p .787 .702 .77 r
F P
0 g
s
.57762 .48372 m .58101 .48703 L .59145 .47963 L p .787 .702 .77 r
F P
0 g
s
.44956 .3345 m .44669 .34258 L .42404 .37616 L p .843 .963 .633 r
F P
0 g
s
.60031 .45131 m .59564 .45069 L .59109 .46439 L p .844 .704 .708 r
F P
0 g
s
.59109 .46439 m .59595 .46592 L .60031 .45131 L p .844 .704 .708 r
F P
0 g
s
.56295 .50159 m .5626 .49708 L .55385 .49248 L p .773 .638 .712 r
F P
0 g
s
.55385 .49248 m .55421 .49697 L .56295 .50159 L p .773 .638 .712 r
F P
0 g
s
.57205 .49383 m .56992 .48981 L .55985 .4884 L p .738 .628 .737 r
F P
0 g
s
.55985 .4884 m .56152 .49268 L .57205 .49383 L p .738 .628 .737 r
F P
0 g
s
.54727 .52395 m .54953 .51956 L .54805 .51105 L p 0 0 .211 r
F P
0 g
s
.54805 .51105 m .54806 .51531 L .54727 .52395 L p 0 0 .211 r
F P
0 g
s
.54465 .52825 m .54727 .52395 L .54806 .51531 L p .128 .087 .538 r
F P
0 g
s
.45784 .3821 m .45502 .38908 L .4816 .37447 L p .837 .868 .867 r
F P
0 g
s
.4816 .37447 m .48355 .36791 L .45784 .3821 L p .837 .868 .867 r
F P
0 g
s
.42282 .49239 m .42717 .49637 L .44499 .52328 L p .894 .473 .105 r
F P
0 g
s
.49379 .35487 m .4876 .36134 L .51323 .35728 L p .813 .822 .857 r
F P
0 g
s
.51323 .35728 m .51674 .35157 L .49379 .35487 L p .813 .822 .857 r
F P
0 g
s
.54806 .51531 m .54807 .51958 L .54465 .52825 L p .128 .087 .538 r
F P
0 g
s
.54174 .53243 m .54465 .52825 L .54807 .51958 L p .372 .282 .624 r
F P
0 g
s
.54953 .51956 m .55138 .5151 L .54803 .5068 L p .975 .782 .361 r
F P
0 g
s
.54803 .5068 m .54805 .51105 L .54953 .51956 L p .975 .782 .361 r
F P
0 g
s
.55138 .5151 m .55278 .51058 L .54802 .50254 L p .972 .772 .576 r
F P
0 g
s
.54802 .50254 m .54803 .5068 L .55138 .5151 L p .972 .772 .576 r
F P
0 g
s
.5626 .49708 m .56152 .49268 L .55315 .48806 L p .752 .615 .706 r
F P
0 g
s
.55315 .48806 m .55385 .49248 L .5626 .49708 L p .752 .615 .706 r
F P
0 g
s
.54807 .51958 m .54809 .52384 L .54174 .53243 L p .372 .282 .624 r
F P
0 g
s
.53866 .53648 m .54174 .53243 L .54809 .52384 L p .486 .375 .652 r
F P
0 g
s
.58101 .48703 m .57762 .48372 L .56704 .48602 L p .743 .651 .758 r
F P
0 g
s
.56704 .48602 m .56992 .48981 L .58101 .48703 L p .743 .651 .758 r
F P
0 g
s
.59595 .46592 m .59109 .46439 L .58314 .47464 L p .803 .696 .747 r
F P
0 g
s
.58314 .47464 m .58784 .47697 L .59595 .46592 L p .803 .696 .747 r
F P
0 g
s
.55278 .51058 m .55371 .50604 L .54801 .49829 L p .907 .717 .635 r
F P
0 g
s
.54801 .49829 m .54802 .50254 L .55278 .51058 L p .907 .717 .635 r
F P
0 g
s
.54791 .46858 m .54792 .47282 L .55107 .47946 L p .705 .552 .677 r
F P
0 g
s
.55107 .47946 m .54986 .4753 L .54791 .46858 L p .705 .552 .677 r
F P
0 g
s
.72207 .57781 m .72189 .56923 L .68298 .60579 L p .874 .916 .853 r
F P
0 g
s
.68298 .60579 m .68346 .61366 L .72207 .57781 L p .874 .916 .853 r
F P
0 g
s
.53549 .5404 m .53866 .53648 L .5481 .52811 L p .553 .428 .664 r
F P
0 g
s
.54809 .52384 m .5481 .52811 L .53866 .53648 L p .486 .375 .652 r
F P
0 g
s
.47368 .54282 m .46859 .54297 L .44499 .52328 L p .823 .421 .285 r
F P
0 g
s
.46859 .54297 m .47368 .54282 L .49886 .55269 L p .743 .369 .345 r
F P
0 g
s
.50344 .55062 m .49886 .55269 L .47368 .54282 L p .72 .378 .399 r
F P
0 g
s
.55371 .50604 m .55418 .50149 L .54799 .49404 L p .856 .676 .657 r
F P
0 g
s
.54799 .49404 m .54801 .49829 L .55371 .50604 L p .856 .676 .657 r
F P
0 g
s
.26751 .54878 m .26116 .53925 L .24415 .46124 L p .939 .648 .186 r
F P
0 g
s
.3014 .61089 m .30381 .61531 L p .30133 .61089 L .767 .357 0 r
F P
0 g
s
.36506 .67122 m .35644 .66839 L .30381 .61531 L p .82 .34 .033 r
F P
0 g
s
.30381 .61531 m .29855 .60894 L .26116 .53925 L p .767 .357 0 r
F P
0 g
s
.29855 .60894 m .30381 .61531 L .34982 .66171 L p .578 .073 0 r
F P
0 g
s
.34982 .66171 m .35644 .66839 L p .35065 .66244 L .578 .073 0 r
F P
0 g
s
.35065 .66244 m .29855 .60894 L .34982 .66171 L .578 .073 0 r
F
.35644 .66839 m .36506 .67122 L .42628 .70446 L p .694 .162 0 r
F P
0 g
s
.42628 .70446 m .42081 .70451 L .35644 .66839 L p .694 .162 0 r
F P
0 g
s
.35644 .66839 m .35267 .66525 L .30038 .61084 L p .578 .073 0 r
F P
0 g
s
.35644 .66839 m .30038 .61084 L .30041 .61084 L .578 .073 0 r
F
.35267 .66525 m .35644 .66839 L .42081 .70451 L p .54 0 0 r
F P
0 g
s
.42081 .70451 m .4186 .70439 L .35625 .66738 L p .54 0 0 r
F P
0 g
s
.35625 .66738 m .35267 .66525 L p .35605 .6672 L .54 0 0 r
F P
0 g
s
.42081 .70451 m .35625 .66738 L .35605 .6672 L .54 0 0 r
F
.30038 .61084 m .29855 .60894 L p .30041 .61084 L .578 .073 0 r
F P
0 g
s
.26116 .53925 m .26751 .54878 L .3014 .61089 L p .767 .357 0 r
F P
0 g
s
.30133 .61089 m .26116 .53925 L .3014 .61089 L .767 .357 0 r
F
.4917 .29496 m .48559 .30194 L .45544 .32644 L p .489 .834 .557 r
F P
0 g
s
.44956 .3345 m .45544 .32644 L .48559 .30194 L p .802 1 .822 r
F P
0 g
s
.5522 .48372 m .55107 .47946 L .54792 .47282 L p .725 .568 .677 r
F P
0 g
s
.54792 .47282 m .54794 .47706 L .5522 .48372 L p .725 .568 .677 r
F P
0 g
s
.63113 .65022 m .63549 .64343 L .58712 .65111 L p .773 .743 .826 r
F P
0 g
s
.58712 .65111 m .58531 .65666 L .63113 .65022 L p .773 .743 .826 r
F P
0 g
s
.56152 .49268 m .55985 .4884 L .5522 .48372 L p .733 .593 .7 r
F P
0 g
s
.5522 .48372 m .55315 .48806 L .56152 .49268 L p .733 .593 .7 r
F P
0 g
s
.49886 .55269 m .50344 .55062 L .52672 .55128 L p .672 .422 .535 r
F P
0 g
s
.52939 .54779 m .52672 .55128 L .50344 .55062 L p .644 .401 .535 r
F P
0 g
s
.55418 .50149 m .55421 .49697 L .54798 .48979 L p .819 .645 .667 r
F P
0 g
s
.54798 .48979 m .54799 .49404 L .55418 .50149 L p .819 .645 .667 r
F P
0 g
s
.4131 .42113 m .41247 .41379 L .42404 .37616 L p .965 .91 .554 r
F P
0 g
s
.63948 .31775 m .62757 .31756 L .59395 .31031 L p .625 .214 .244 r
F P
0 g
s
.58598 .31256 m .59395 .31031 L .62757 .31756 L p .593 .194 .256 r
F P
0 g
s
.56992 .48981 m .56704 .48602 L .55774 .4843 L p .718 .604 .728 r
F P
0 g
s
.55774 .4843 m .55985 .4884 L .56992 .48981 L p .718 .604 .728 r
F P
0 g
s
.55774 .4843 m .55538 .48037 L .54986 .4753 L p .697 .555 .689 r
F P
0 g
s
.54986 .4753 m .55107 .47946 L .55774 .4843 L p .697 .555 .689 r
F P
0 g
s
.55315 .48806 m .5522 .48372 L .54794 .47706 L p .744 .584 .676 r
F P
0 g
s
.54794 .47706 m .54795 .4813 L .55315 .48806 L p .744 .584 .676 r
F P
0 g
s
.55421 .49697 m .55385 .49248 L .54797 .48554 L p .79 .621 .672 r
F P
0 g
s
.54797 .48554 m .54798 .48979 L .55421 .49697 L p .79 .621 .672 r
F P
0 g
s
.53236 .54417 m .53549 .5404 L .54811 .53238 L p .597 .464 .671 r
F P
0 g
s
.5481 .52811 m .54811 .53238 L .53549 .5404 L p .553 .428 .664 r
F P
0 g
s
.58784 .47697 m .58314 .47464 L .57343 .48072 L p .758 .666 .76 r
F P
0 g
s
.57343 .48072 m .57762 .48372 L .58784 .47697 L p .758 .666 .76 r
F P
0 g
s
.55985 .4884 m .55774 .4843 L .55107 .47946 L p .715 .574 .695 r
F P
0 g
s
.55107 .47946 m .5522 .48372 L .55985 .4884 L p .715 .574 .695 r
F P
0 g
s
.55385 .49248 m .55315 .48806 L .54795 .4813 L p .766 .601 .675 r
F P
0 g
s
.54795 .4813 m .54797 .48554 L .55385 .49248 L p .766 .601 .675 r
F P
0 g
s
.41796 .52727 m .41403 .49025 L p .41499 .52336 L .981 .737 .333 r
F P
0 g
s
.41403 .49025 m .41075 .48545 L .415 .52395 L p .981 .737 .333 r
F P
0 g
s
.41126 .48038 m .41572 .52041 L p .41086 .48621 L 0 0 .253 r
F P
0 g
s
.41075 .48545 m .41076 .48534 L p .41086 .48621 L 0 0 .253 r
F P
0 g
s
.41076 .48534 m .41126 .48038 L p .41086 .48621 L 0 0 .253 r
F P
0 g
s
.415 .52395 m .41506 .52401 L p .41499 .52336 L .981 .737 .333 r
F P
0 g
s
.41506 .52401 m .41796 .52727 L p .41499 .52336 L .981 .737 .333 r
F P
0 g
s
.755 .55792 m .75627 .56737 L .72943 .62274 L p .956 .95 .687 r
F P
0 g
s
.75627 .56737 m .755 .55792 L .76482 .49946 L p .936 .84 .398 r
F P
0 g
s
.50208 .34862 m .49379 .35487 L .51674 .35157 L p .825 .882 .885 r
F P
0 g
s
.51674 .35157 m .52146 .34599 L .50208 .34862 L p .825 .882 .885 r
F P
0 g
s
.55538 .48037 m .55774 .4843 L .56704 .48602 L p .698 .58 .72 r
F P
0 g
s
.45922 .59607 m .46315 .59554 L .43841 .5649 L p .881 .461 .199 r
F P
0 g
s
.43841 .5649 m .43307 .56362 L .45922 .59607 L p .881 .461 .199 r
F P
0 g
s
.57762 .48372 m .57343 .48072 L .56365 .48248 L p .72 .623 .749 r
F P
0 g
s
.56365 .48248 m .56704 .48602 L .57762 .48372 L p .72 .623 .749 r
F P
0 g
s
.56704 .48602 m .56365 .48248 L .55538 .48037 L p .698 .58 .72 r
F P
0 g
s
.52939 .54779 m .53236 .54417 L .54813 .53665 L p .629 .49 .674 r
F P
0 g
s
.54811 .53238 m .54813 .53665 L .53236 .54417 L p .597 .464 .671 r
F P
0 g
s
.55814 .74781 m .55983 .74311 L .61129 .73105 L p .69 .959 .947 r
F P
0 g
s
.61909 .72479 m .61129 .73105 L .55983 .74311 L p .748 .926 .949 r
F P
0 g
s
.68771 .34318 m .69742 .34695 L .73003 .38598 L p .87 .453 .226 r
F P
0 g
s
.69742 .34695 m .68771 .34318 L .64928 .31857 L p .744 .243 .034 r
F P
0 g
s
.63948 .31775 m .64928 .31857 L .68771 .34318 L p .757 .322 .218 r
F P
0 g
s
.54597 .69187 m .54786 .69077 L p .54731 .67351 L 0 .129 .657 r
F P
0 g
s
.54786 .69077 m .55365 .68743 L .54731 .67351 L p 0 .129 .657 r
F P
0 g
s
.55365 .68743 m .56089 .68275 L .54551 .66927 L p .675 .324 0 r
F P
0 g
s
.54551 .66927 m .54731 .67351 L .55365 .68743 L p .675 .324 0 r
F P
0 g
s
.56089 .68275 m .56753 .67786 L .54386 .66509 L p .949 .594 .257 r
F P
0 g
s
.54386 .66509 m .54551 .66927 L .56089 .68275 L p .949 .594 .257 r
F P
0 g
s
.56753 .67786 m .57341 .67277 L .54241 .66097 L p .92 .621 .462 r
F P
0 g
s
.54241 .66097 m .54386 .66509 L .56753 .67786 L p .92 .621 .462 r
F P
0 g
s
.57341 .67277 m .57839 .66752 L .54119 .65688 L p .869 .608 .542 r
F P
0 g
s
.54119 .65688 m .54241 .66097 L .57341 .67277 L p .869 .608 .542 r
F P
0 g
s
.57839 .66752 m .58238 .66214 L .54022 .65283 L p .828 .591 .58 r
F P
0 g
s
.54022 .65283 m .54119 .65688 L .57839 .66752 L p .828 .591 .58 r
F P
0 g
s
.58238 .66214 m .58531 .65666 L .53951 .64881 L p .796 .575 .602 r
F P
0 g
s
.53951 .64881 m .54022 .65283 L .58238 .66214 L p .796 .575 .602 r
F P
0 g
s
.58531 .65666 m .58712 .65111 L .53908 .6448 L p .77 .56 .615 r
F P
0 g
s
.53908 .6448 m .53951 .64881 L .58531 .65666 L p .77 .56 .615 r
F P
0 g
s
.53892 .6408 m .53908 .6448 L .58712 .65111 L p .747 .545 .623 r
F P
0 g
s
.54731 .67351 m .54128 .64481 L p .54718 .6693 L .582 .627 .861 r
F P
0 g
s
.54923 .67781 m .54731 .67351 L p .54718 .6693 L .582 .627 .861 r
F P
0 g
s
.54731 .67351 m .54923 .67781 L .54597 .69187 L p 0 .129 .657 r
F P
0 g
s
.53805 .69607 m .54597 .69187 L .54923 .67781 L p .294 .339 .738 r
F P
0 g
s
.44499 .52328 m .44112 .52123 L .42282 .49239 L p .894 .473 .105 r
F P
0 g
s
.44112 .52123 m .44499 .52328 L .46859 .54297 L p .812 .332 .056 r
F P
0 g
s
.43472 .70415 m .42628 .70446 L .36506 .67122 L p .734 .266 .138 r
F P
0 g
s
.54923 .67781 m .55121 .68217 L .53805 .69607 L p .294 .339 .738 r
F P
0 g
s
.5301 .70002 m .53805 .69607 L .55121 .68217 L p .443 .428 .747 r
F P
0 g
s
.52672 .55128 m .52939 .54779 L .54814 .54093 L p .656 .512 .676 r
F P
0 g
s
.54813 .53665 m .54814 .54093 L .52939 .54779 L p .629 .49 .674 r
F P
0 g
s
.75816 .44292 m .75102 .43489 L .73003 .38598 L p .933 .565 .167 r
F P
0 g
s
.62757 .31756 m .61398 .31808 L .58598 .31256 L p .593 .194 .256 r
F P
0 g
s
.57735 .31526 m .58598 .31256 L .61398 .31808 L p .549 .153 .243 r
F P
0 g
s
.51233 .34269 m .50208 .34862 L .52146 .34599 L p .815 .951 .908 r
F P
0 g
s
.52146 .34599 m .52731 .34059 L .51233 .34269 L p .815 .951 .908 r
F P
0 g
s
.4636 .37512 m .45784 .3821 L .48355 .36791 L p .841 .945 .889 r
F P
0 g
s
.48355 .36791 m .4876 .36134 L .4636 .37512 L p .841 .945 .889 r
F P
0 g
s
.49886 .55269 m .49539 .55453 L .46859 .54297 L p .743 .369 .345 r
F P
0 g
s
.49539 .55453 m .49886 .55269 L .52446 .55465 L p .697 .437 .527 r
F P
0 g
s
.52672 .55128 m .52446 .55465 L .49886 .55269 L p .672 .422 .535 r
F P
0 g
s
.55121 .68217 m .55319 .6866 L .5301 .70002 L p .443 .428 .747 r
F P
0 g
s
.52234 .70372 m .5301 .70002 L .55319 .6866 L p .524 .476 .745 r
F P
0 g
s
.45544 .32644 m .46435 .31856 L .4917 .29496 L p .489 .834 .557 r
F P
0 g
s
.49974 .28823 m .4917 .29496 L .46435 .31856 L p 0 0 0 r
F P
0 g
s
.42628 .70446 m .43472 .70415 L .49747 .71628 L p .671 .296 .327 r
F P
0 g
s
.50234 .71343 m .49747 .71628 L .43472 .70415 L p .649 .287 .345 r
F P
0 g
s
.42404 .37616 m .42729 .36797 L .44956 .3345 L p .843 .963 .633 r
F P
0 g
s
.42729 .36797 m .42404 .37616 L .41247 .41379 L p 0 0 0 r
F P
0 g
s
.45502 .38908 m .45784 .3821 L .4364 .40553 L p .88 .992 .788 r
F P
0 g
s
.52446 .55465 m .52672 .55128 L .54815 .5452 L p .678 .53 .677 r
F P
0 g
s
.54814 .54093 m .54815 .5452 L .52672 .55128 L p .656 .512 .676 r
F P
0 g
s
.45544 .32644 m .44956 .3345 L .42729 .36797 L p 0 0 0 r
F P
0 g
s
.52436 .3372 m .51233 .34269 L .52731 .34059 L p .726 .988 .879 r
F P
0 g
s
.52731 .34059 m .5342 .33544 L .52436 .3372 L p .726 .988 .879 r
F P
0 g
s
.4307 .56207 m .43307 .56362 L .41796 .52727 L p .867 .498 .006 r
F P
0 g
s
.41796 .52727 m .415 .52395 L .4307 .56207 L p .867 .498 .006 r
F P
0 g
s
.46859 .54297 m .46549 .54285 L .44112 .52123 L p .812 .332 .056 r
F P
0 g
s
.46549 .54285 m .46859 .54297 L .49539 .55453 L p .759 .336 .247 r
F P
0 g
s
.51498 .70717 m .52234 .70372 L .55513 .69109 L p .575 .507 .741 r
F P
0 g
s
.55319 .6866 m .55513 .69109 L .52234 .70372 L p .524 .476 .745 r
F P
0 g
s
.61398 .31808 m .59918 .31937 L .57735 .31526 L p .549 .153 .243 r
F P
0 g
s
.56836 .31843 m .57735 .31526 L .59918 .31937 L p .487 .083 .2 r
F P
0 g
s
.63549 .64343 m .63737 .63656 L .58783 .64554 L p .756 .714 .813 r
F P
0 g
s
.58783 .64554 m .58712 .65111 L .63549 .64343 L p .756 .714 .813 r
F P
0 g
s
.68346 .61366 m .68298 .60579 L .6368 .62972 L p .796 .815 .867 r
F P
0 g
s
.6368 .62972 m .63737 .63656 L .68346 .61366 L p .796 .815 .867 r
F P
0 g
s
.62484 .71834 m .62842 .71176 L .6839 .67818 L p .764 .989 .892 r
F P
0 g
s
.68652 .67012 m .6839 .67818 L .62842 .71176 L p .818 .937 .907 r
F P
0 g
s
.6839 .67818 m .68652 .67012 L .72943 .62274 L p .837 .996 .761 r
F P
0 g
s
.55983 .74311 m .56117 .73836 L .61909 .72479 L p .748 .926 .949 r
F P
0 g
s
.62484 .71834 m .61909 .72479 L .56117 .73836 L p .766 .88 .929 r
F P
0 g
s
.52446 .55465 m .52274 .5579 L .49539 .55453 L p .697 .437 .527 r
F P
0 g
s
.52274 .5579 m .52446 .55465 L .54817 .54948 L p .699 .547 .677 r
F P
0 g
s
.54815 .5452 m .54817 .54948 L .52446 .55465 L p .678 .53 .677 r
F P
0 g
s
.74983 .52221 m .7446 .51347 L .71704 .56081 L p .92 .875 .775 r
F P
0 g
s
.71704 .56081 m .72189 .56923 L .74983 .52221 L p .92 .875 .775 r
F P
0 g
s
.53789 .33225 m .52436 .3372 L .5342 .33544 L p .449 .855 .678 r
F P
0 g
s
.49526 .62142 m .49746 .61909 L .46315 .59554 L p .785 .316 .123 r
F P
0 g
s
.46315 .59554 m .45922 .59607 L .49526 .62142 L p .785 .316 .123 r
F P
0 g
s
.59918 .31937 m .58368 .32144 L .56836 .31843 L p .487 .083 .2 r
F P
0 g
s
.55928 .32206 m .56836 .31843 L .58368 .32144 L p .39 0 .114 r
F P
0 g
s
.49539 .55453 m .49325 .5562 L .46549 .54285 L p .759 .336 .247 r
F P
0 g
s
.49325 .5562 m .49539 .55453 L .52274 .5579 L p .721 .448 .512 r
F P
0 g
s
.50825 .71041 m .51498 .70717 L .55696 .69565 L p .611 .529 .738 r
F P
0 g
s
.55513 .69109 m .55696 .69565 L .51498 .70717 L p .575 .507 .741 r
F P
0 g
s
.54196 .33061 m .55039 .32613 L .55256 .32793 L p 0 0 0 r
F P
0 g
s
.42185 .48811 m .42282 .49239 L .44112 .52123 L p 0 0 .439 r
F P
0 g
s
.58368 .32144 m .56798 .32431 L .55928 .32206 L p .39 0 .114 r
F P
0 g
s
.55039 .32613 m .55928 .32206 L .56798 .32431 L p .227 0 0 r
F P
0 g
s
.50956 .28184 m .49974 .28823 L .4762 .31102 L p .273 0 .146 r
F P
0 g
s
.46435 .31856 m .4762 .31102 L .49974 .28823 L p 0 0 0 r
F P
0 g
s
.56798 .32431 m .55256 .32793 L .55039 .32613 L p .227 0 0 r
F P
0 g
s
.47234 .3683 m .4636 .37512 L .4876 .36134 L p .768 .996 .855 r
F P
0 g
s
.4876 .36134 m .49379 .35487 L .47234 .3683 L p .768 .996 .855 r
F P
0 g
s
.54817 .54948 m .54818 .55376 L .52274 .5579 L p .699 .547 .677 r
F P
0 g
s
.72821 .61371 m .72943 .62274 L .68652 .67012 L p .896 .939 .833 r
F P
0 g
s
.72943 .62274 m .72821 .61371 L .755 .55792 L p .956 .95 .687 r
F P
0 g
s
.52274 .5579 m .52166 .56107 L .49325 .5562 L p .721 .448 .512 r
F P
0 g
s
.52166 .56107 m .52274 .5579 L .54818 .55376 L p .718 .562 .677 r
F P
0 g
s
.68771 .34318 m .67451 .34009 L .63948 .31775 L p .757 .322 .218 r
F P
0 g
s
.62757 .31756 m .63948 .31775 L .67451 .34009 L p .741 .352 .315 r
F P
0 g
s
.54818 .55376 m .54819 .55805 L .52166 .56107 L p .718 .562 .677 r
F P
0 g
s
.45761 .59642 m .45922 .59607 L .43307 .56362 L p .725 .247 0 r
F P
0 g
s
.43307 .56362 m .4307 .56207 L .45761 .59642 L p .725 .247 0 r
F P
0 g
s
.52132 .56417 m .52166 .56107 L .54819 .55805 L p .738 .579 .677 r
F P
0 g
s
.54819 .55805 m .54821 .56233 L .52132 .56417 L p .738 .579 .677 r
F P
0 g
s
.75764 .49049 m .76482 .49946 L .755 .55792 L p .979 .835 .629 r
F P
0 g
s
.71856 .3801 m .73003 .38598 L .75102 .43489 L p .928 .615 .428 r
F P
0 g
s
.73003 .38598 m .71856 .3801 L .68771 .34318 L p .87 .453 .226 r
F P
0 g
s
.41247 .41379 m .41578 .40627 L .42729 .36797 L p 0 0 0 r
F P
0 g
s
.41578 .40627 m .41247 .41379 L .41204 .45216 L p 0 0 .394 r
F P
0 g
s
.52178 .56725 m .52132 .56417 L .54821 .56233 L p .758 .595 .675 r
F P
0 g
s
.54821 .56233 m .54822 .56662 L .52178 .56725 L p .758 .595 .675 r
F P
0 g
s
.44112 .52123 m .44016 .51892 L .42185 .48811 L p 0 0 .439 r
F P
0 g
s
.44701 .52645 m .46549 .54285 L p .45144 .52958 L .591 .072 0 r
F P
0 g
s
.45144 .52958 m .44016 .51892 L .44701 .52645 L .591 .072 0 r
F
.46549 .54285 m .46465 .54254 L .44016 .51892 L p F P
0 g
s
.46465 .54254 m .46628 .54213 L .46061 .53605 L p 0 .277 .78 r
F P
0 g
s
.46061 .53605 m .44237 .51648 L p .4568 .53336 L 0 .277 .78 r
F P
0 g
s
.46465 .54254 m .46061 .53605 L .4568 .53336 L 0 .277 .78 r
F
.44016 .51892 m .44112 .52123 L .44701 .52645 L p .591 .072 0 r
F P
0 g
s
.50234 .71343 m .50825 .71041 L .55863 .70027 L p .639 .548 .735 r
F P
0 g
s
.55696 .69565 m .55863 .70027 L .50825 .71041 L p .611 .529 .738 r
F P
0 g
s
.52311 .57032 m .52178 .56725 L .54822 .56662 L p .782 .614 .673 r
F P
0 g
s
.54822 .56662 m .54824 .57091 L .52311 .57032 L p .782 .614 .673 r
F P
0 g
s
.4217 .4372 m .41747 .4435 L .43279 .41244 L p 0 0 0 r
F P
0 g
s
.52532 .57343 m .52311 .57032 L .54824 .57091 L p .809 .637 .669 r
F P
0 g
s
.54824 .57091 m .54825 .57521 L .52532 .57343 L p .809 .637 .669 r
F P
0 g
s
.41572 .52041 m .415 .52395 L .41075 .48545 L p 0 0 .253 r
F P
0 g
s
.49262 .55774 m .49325 .5562 L .52166 .56107 L p .745 .452 .487 r
F P
0 g
s
.52166 .56107 m .52132 .56417 L .49262 .55774 L p .745 .452 .487 r
F P
0 g
s
.44363 .39864 m .4364 .40553 L .45784 .3821 L p .566 .834 .481 r
F P
0 g
s
.45784 .3821 m .4636 .37512 L .44363 .39864 L p .566 .834 .481 r
F P
0 g
s
.52096 .2759 m .50956 .28184 L .49078 .30398 L p .429 .09 .287 r
F P
0 g
s
.4762 .31102 m .49078 .30398 L .50956 .28184 L p .273 0 .146 r
F P
0 g
s
.52841 .57662 m .52532 .57343 L .54825 .57521 L p .843 .665 .661 r
F P
0 g
s
.54825 .57521 m .54826 .5795 L .52841 .57662 L p .843 .665 .661 r
F P
0 g
s
.49325 .5562 m .49262 .55774 L .46465 .54254 L p .746 .252 .059 r
F P
0 g
s
.46465 .54254 m .46549 .54285 L .48631 .55286 L p .746 .252 .059 r
F P
0 g
s
.48444 .55199 m .46465 .54254 L .48631 .55286 L .746 .252 .059 r
F
.46628 .54213 m .46465 .54254 L .48539 .55381 L p .616 .052 0 r
F P
0 g
s
.48539 .55381 m .49262 .55774 L p .48434 .55283 L .616 .052 0 r
F P
0 g
s
.48434 .55283 m .46628 .54213 L .48539 .55381 L .616 .052 0 r
F
.49262 .55774 m .49364 .55921 L .47516 .54767 L p F P
0 g
s
.49262 .55774 m .47516 .54767 L .47737 .5487 L .616 .052 0 r
F
.48631 .55286 m .49325 .5562 L p .48444 .55199 L .746 .252 .059 r
F P
0 g
s
.49364 .55921 m .49262 .55774 L .52132 .56417 L p .77 .45 .445 r
F P
0 g
s
.52132 .56417 m .52178 .56725 L .49364 .55921 L p .77 .45 .445 r
F P
0 g
s
.49643 .56069 m .49364 .55921 L .52178 .56725 L p .795 .433 .372 r
F P
0 g
s
.49364 .55921 m .49643 .56069 L .47928 .54813 L p 0 .264 .722 r
F P
0 g
s
.47928 .54813 m .47053 .54172 L p .48052 .54928 L 0 .264 .722 r
F P
0 g
s
.49364 .55921 m .47928 .54813 L .48052 .54928 L 0 .264 .722 r
F
.47516 .54767 m .46628 .54213 L p .47737 .5487 L .616 .052 0 r
F P
0 g
s
.56117 .73836 m .56214 .73358 L .62484 .71834 L p .766 .88 .929 r
F P
0 g
s
.62842 .71176 m .62484 .71834 L .56214 .73358 L p .766 .836 .906 r
F P
0 g
s
.72189 .56923 m .71704 .56081 L .67889 .59806 L p .849 .84 .836 r
F P
0 g
s
.67889 .59806 m .68298 .60579 L .72189 .56923 L p .849 .84 .836 r
F P
0 g
s
.53234 .57991 m .52841 .57662 L .54826 .5795 L p .888 .702 .645 r
F P
0 g
s
.54826 .5795 m .54828 .5838 L .53234 .57991 L p .888 .702 .645 r
F P
0 g
s
.46435 .31856 m .45544 .32644 L .43427 .35979 L p .164 0 .246 r
F P
0 g
s
.42729 .36797 m .43427 .35979 L .45544 .32644 L p 0 0 0 r
F P
0 g
s
.63737 .63656 m .6368 .62972 L .58745 .63999 L p .74 .691 .804 r
F P
0 g
s
.58745 .63999 m .58783 .64554 L .63737 .63656 L p .74 .691 .804 r
F P
0 g
s
.67451 .34009 m .68771 .34318 L .71856 .3801 L p .844 .491 .386 r
F P
0 g
s
.53903 .63679 m .53938 .63278 L .49746 .61909 L p .726 .338 .314 r
F P
0 g
s
.49746 .61909 m .49526 .62142 L .53903 .63679 L p .726 .338 .314 r
F P
0 g
s
.24538 .4485 m .24415 .46124 L .26116 .53925 L p 0 0 .392 r
F P
0 g
s
.53704 .58334 m .53234 .57991 L .54828 .5838 L p .949 .753 .604 r
F P
0 g
s
.54828 .5838 m .54829 .5881 L .53704 .58334 L p .949 .753 .604 r
F P
0 g
s
.48399 .36177 m .47234 .3683 L .49379 .35487 L p .455 .835 .601 r
F P
0 g
s
.49379 .35487 m .50208 .34862 L .48399 .36177 L p .455 .835 .601 r
F P
0 g
s
.42081 .70451 m .42628 .70446 L .4938 .71899 L p .688 .292 .291 r
F P
0 g
s
.49747 .71628 m .4938 .71899 L .42628 .70446 L p .671 .296 .327 r
F P
0 g
s
.54242 .58695 m .53704 .58334 L .54829 .5881 L p .999 .798 .467 r
F P
0 g
s
.54829 .5881 m .5483 .59241 L .54242 .58695 L p .999 .798 .467 r
F P
0 g
s
.49445 .62366 m .49526 .62142 L .45922 .59607 L p .687 .143 0 r
F P
0 g
s
.45922 .59607 m .45761 .59642 L .49445 .62366 L p .687 .143 0 r
F P
0 g
s
.43427 .35979 m .42729 .36797 L .41578 .40627 L p .106 0 .375 r
F P
0 g
s
.49747 .71628 m .50234 .71343 L .56009 .70494 L p .662 .564 .734 r
F P
0 g
s
.55863 .70027 m .56009 .70494 L .50234 .71343 L p .639 .548 .735 r
F P
0 g
s
.53367 .2705 m .52096 .2759 L .50781 .29758 L p .519 .197 .362 r
F P
0 g
s
.49078 .30398 m .50781 .29758 L .52096 .2759 L p .429 .09 .287 r
F P
0 g
s
.58712 .65111 m .58783 .64554 L .53892 .6408 L p .747 .545 .623 r
F P
0 g
s
.41204 .45216 m .41515 .44595 L .41578 .40627 L p 0 0 .394 r
F P
0 g
s
.67451 .34009 m .65831 .33783 L .62757 .31756 L p .741 .352 .315 r
F P
0 g
s
.61398 .31808 m .62757 .31756 L .65831 .33783 L p .718 .359 .367 r
F P
0 g
s
.43157 .56036 m .4307 .56207 L .415 .52395 L p 0 0 .552 r
F P
0 g
s
.415 .52395 m .41572 .52041 L .43157 .56036 L p 0 0 .552 r
F P
0 g
s
.68298 .60579 m .67889 .59806 L .63387 .62297 L p .78 .774 .847 r
F P
0 g
s
.63387 .62297 m .6368 .62972 L .68298 .60579 L p .78 .774 .847 r
F P
0 g
s
.74819 .5487 m .755 .55792 L .72821 .61371 L p .931 .863 .75 r
F P
0 g
s
.755 .55792 m .74819 .5487 L .75764 .49049 L p .979 .835 .629 r
F P
0 g
s
.62842 .71176 m .6298 .70511 L .68652 .67012 L p .818 .937 .907 r
F P
0 g
s
.6854 .66206 m .68652 .67012 L .6298 .70511 L p .817 .871 .886 r
F P
0 g
s
.68652 .67012 m .6854 .66206 L .72821 .61371 L p .896 .939 .833 r
F P
0 g
s
.50781 .29758 m .52687 .29198 L .53367 .2705 L p .519 .197 .362 r
F P
0 g
s
.52178 .56725 m .52311 .57032 L .49643 .56069 L p .795 .433 .372 r
F P
0 g
s
.53892 .6408 m .53903 .63679 L .49526 .62142 L p .734 .301 .223 r
F P
0 g
s
.49526 .62142 m .49445 .62366 L .53892 .6408 L p .734 .301 .223 r
F P
0 g
s
.58783 .64554 m .58745 .63999 L .53903 .63679 L p .725 .531 .628 r
F P
0 g
s
.53903 .63679 m .53892 .6408 L .58783 .64554 L p .725 .531 .628 r
F P
0 g
s
.49838 .35571 m .48399 .36177 L .50208 .34862 L p 0 0 0 r
F P
0 g
s
.50208 .34862 m .51233 .34269 L .49838 .35571 L p 0 0 0 r
F P
0 g
s
.56214 .73358 m .56272 .72879 L .62842 .71176 L p .766 .836 .906 r
F P
0 g
s
.6298 .70511 m .62842 .71176 L .56272 .72879 L p .76 .799 .885 r
F P
0 g
s
.58745 .63999 m .58604 .63449 L .53938 .63278 L p .705 .516 .63 r
F P
0 g
s
.53938 .63278 m .53903 .63679 L .58745 .63999 L p .705 .516 .63 r
F P
0 g
s
.42457 .48367 m .42185 .48811 L .44016 .51892 L p .058 .243 .738 r
F P
0 g
s
.4938 .71899 m .49747 .71628 L .56129 .70965 L p .682 .579 .733 r
F P
0 g
s
.56009 .70494 m .56129 .70965 L .49747 .71628 L p .662 .564 .734 r
F P
0 g
s
.73853 .42741 m .75102 .43489 L .75764 .49049 L p .934 .71 .576 r
F P
0 g
s
.75102 .43489 m .73853 .42741 L .71856 .3801 L p .928 .615 .428 r
F P
0 g
s
.6368 .62972 m .63387 .62297 L .58604 .63449 L p .725 .672 .798 r
F P
0 g
s
.58604 .63449 m .58745 .63999 L .6368 .62972 L p .725 .672 .798 r
F P
0 g
s
.44237 .51648 m .44016 .51892 L .46465 .54254 L p 0 .277 .78 r
F P
0 g
s
.45452 .39195 m .44363 .39864 L .4636 .37512 L p 0 0 .03 r
F P
0 g
s
.4636 .37512 m .47234 .3683 L .45452 .39195 L p 0 0 .03 r
F P
0 g
s
.4585 .59668 m .45761 .59642 L .4307 .56207 L p 0 .157 .698 r
F P
0 g
s
.4307 .56207 m .43157 .56036 L .4585 .59668 L p 0 .157 .698 r
F P
0 g
s
.44016 .51892 m .44237 .51648 L .42457 .48367 L p .058 .243 .738 r
F P
0 g
s
.50102 .56224 m .49643 .56069 L .51921 .56891 L p .81 .384 .234 r
F P
0 g
s
.51921 .56891 m .52138 .5697 L p .51918 .56889 L .81 .384 .234 r
F P
0 g
s
.51918 .56889 m .50102 .56224 L .51921 .56891 L .81 .384 .234 r
F
.52071 .56944 m .50102 .56224 L .52138 .5697 L F
.52138 .5697 m .52311 .57032 L p .52071 .56944 L F P
0 g
s
.52311 .57032 m .52532 .57343 L .50102 .56224 L p .81 .384 .234 r
F P
0 g
s
.5074 .56394 m .50102 .56224 L .52532 .57343 L p .76 .247 0 r
F P
0 g
s
.52532 .57343 m .52841 .57662 L .50948 .56519 L p .76 .247 0 r
F P
0 g
s
.52532 .57343 m .50948 .56519 L .5105 .56558 L .76 .247 0 r
F
.50948 .56519 m .5074 .56394 L p .5105 .56558 L F P
0 g
s
.5155 .56586 m .5074 .56394 L .52841 .57662 L p .457 0 0 r
F P
0 g
s
.52841 .57662 m .53234 .57991 L .51848 .56835 L p .457 0 0 r
F P
0 g
s
.51848 .56835 m .5155 .56586 L p .51854 .56839 L .457 0 0 r
F P
0 g
s
.52841 .57662 m .51848 .56835 L .51854 .56839 L .457 0 0 r
F
.4762 .31102 m .46435 .31856 L .44502 .3518 L p .386 .137 .409 r
F P
0 g
s
.43427 .35979 m .44502 .3518 L .46435 .31856 L p .164 0 .246 r
F P
0 g
s
.43 .43095 m .4217 .4372 L .4364 .40553 L p .059 0 .267 r
F P
0 g
s
.4364 .40553 m .44363 .39864 L .43 .43095 L p .059 0 .267 r
F P
0 g
s
.65831 .33783 m .63969 .33652 L .61398 .31808 L p .718 .359 .367 r
F P
0 g
s
.59918 .31937 m .61398 .31808 L .63969 .33652 L p .692 .351 .395 r
F P
0 g
s
.53908 .6448 m .53892 .6408 L .49445 .62366 L p .719 .225 .065 r
F P
0 g
s
.41578 .40627 m .4232 .39874 L .43427 .35979 L p .106 0 .375 r
F P
0 g
s
.4232 .39874 m .41578 .40627 L .41515 .44595 L p .266 .19 .581 r
F P
0 g
s
.49513 .62586 m .49445 .62366 L .45761 .59642 L p 0 .169 .642 r
F P
0 g
s
.45761 .59642 m .4585 .59668 L .49513 .62586 L p 0 .169 .642 r
F P
0 g
s
.26116 .53925 m .26242 .52934 L .24538 .4485 L p 0 0 .392 r
F P
0 g
s
.26242 .52934 m .26116 .53925 L .29855 .60894 L p 0 .083 .64 r
F P
0 g
s
.51523 .35025 m .49838 .35571 L .51233 .34269 L p .29 0 .113 r
F P
0 g
s
.51233 .34269 m .52436 .3372 L .51523 .35025 L p .29 0 .113 r
F P
0 g
s
.53951 .64881 m .53908 .6448 L .49513 .62586 L p .632 .07 0 r
F P
0 g
s
.49445 .62366 m .49513 .62586 L .53908 .6448 L p .719 .225 .065 r
F P
0 g
s
.47053 .54172 m .46628 .54213 L .49364 .55921 L p 0 .264 .722 r
F P
0 g
s
.71856 .3801 m .70277 .37499 L .67451 .34009 L p .844 .491 .386 r
F P
0 g
s
.65831 .33783 m .67451 .34009 L .70277 .37499 L p .808 .495 .461 r
F P
0 g
s
.72219 .60486 m .72821 .61371 L .6854 .66206 L p .87 .854 .824 r
F P
0 g
s
.72821 .61371 m .72219 .60486 L .74819 .5487 L p .931 .863 .75 r
F P
0 g
s
.42037 .51681 m .41572 .52041 L .41126 .48038 L p .12 .122 .586 r
F P
0 g
s
.41126 .48038 m .41585 .47521 L .42037 .51681 L p .12 .122 .586 r
F P
0 g
s
.4938 .71899 m .49149 .72159 L .42081 .70451 L p .688 .292 .291 r
F P
0 g
s
.49149 .72159 m .4938 .71899 L .56218 .71441 L p .7 .594 .734 r
F P
0 g
s
.56129 .70965 m .56218 .71441 L .4938 .71899 L p .682 .579 .733 r
F P
0 g
s
.54022 .65283 m .53951 .64881 L .49737 .62808 L p .383 0 0 r
F P
0 g
s
.54119 .65688 m .54022 .65283 L .50119 .63038 L p 0 .424 .851 r
F P
0 g
s
.49737 .62808 m .50119 .63038 L .53799 .65155 L p .383 0 0 r
F P
0 g
s
.49737 .62808 m .53799 .65155 L .538 .65155 L .383 0 0 r
F
.49737 .62808 m .53867 .65194 L .53876 .65199 L F
.49737 .62808 m .53964 .6525 L .53988 .65263 L F
.50119 .63038 m .50656 .6328 L .54031 .65627 L p 0 .424 .851 r
F P
0 g
s
.54031 .65627 m .54119 .65688 L p .54045 .65639 L 0 .424 .851 r
F P
0 g
s
.50119 .63038 m .54031 .65627 L .54045 .65639 L 0 .424 .851 r
F
.54241 .66097 m .54119 .65688 L .51285 .63717 L p .243 .541 .925 r
F P
0 g
s
.51019 .63565 m .54241 .66097 L .51285 .63717 L .243 .541 .925 r
F
.51285 .63717 m .50656 .6328 L p .51019 .63565 L F P
0 g
s
.49513 .62586 m .49737 .62808 L .53782 .64797 L p .632 .07 0 r
F P
0 g
s
.50656 .6328 m .51341 .6354 L .54241 .66097 L p .243 .541 .925 r
F P
0 g
s
.54386 .66509 m .54241 .66097 L .52189 .64287 L p .396 .586 .919 r
F P
0 g
s
.52068 .64248 m .54386 .66509 L .52189 .64287 L .396 .586 .919 r
F
.52189 .64287 m .51341 .6354 L p .52068 .64248 L F P
0 g
s
.49513 .62586 m .53782 .64797 L .53803 .64804 L .632 .07 0 r
F
.51341 .6354 m .52161 .63824 L .54386 .66509 L p .396 .586 .919 r
F P
0 g
s
.54551 .66927 m .54386 .66509 L .52812 .6461 L p .485 .606 .898 r
F P
0 g
s
.52732 .64566 m .54551 .66927 L .52812 .6461 L .485 .606 .898 r
F
.52812 .6461 m .52161 .63824 L p .52732 .64566 L F P
0 g
s
.52161 .63824 m .53097 .64137 L .54551 .66927 L p .485 .606 .898 r
F P
0 g
s
.54731 .67351 m .54551 .66927 L .53576 .65056 L p .542 .618 .877 r
F P
0 g
s
.53576 .65056 m .53097 .64137 L p .53561 .65049 L .542 .618 .877 r
F P
0 g
s
.53561 .65049 m .54731 .67351 L .53576 .65056 L .542 .618 .877 r
F
.53799 .65155 m .53867 .65194 L p .538 .65155 L .383 0 0 r
F P
0 g
s
.53867 .65194 m .53964 .6525 L p .53876 .65199 L .383 0 0 r
F P
0 g
s
.53964 .6525 m .54022 .65283 L p .53988 .65263 L .383 0 0 r
F P
0 g
s
.53782 .64797 m .53951 .64881 L p .53803 .64804 L .632 .07 0 r
F P
0 g
s
.49149 .72159 m .49065 .72413 L .4186 .70439 L p .699 .272 .23 r
F P
0 g
s
.4186 .70439 m .42081 .70451 L .48714 .72054 L p .699 .272 .23 r
F P
0 g
s
.48404 .71983 m .4186 .70439 L .48714 .72054 L .699 .272 .23 r
F
.41987 .7042 m .4186 .70439 L .4804 .72132 L p .698 .226 .127 r
F P
0 g
s
.47923 .72095 m .41987 .7042 L .4804 .72132 L .698 .226 .127 r
F
.48336 .72208 m .41987 .7042 L .48618 .72291 L F
.4804 .72132 m .48618 .72291 L p .47923 .72095 L F P
0 g
s
.49065 .72413 m .49138 .72666 L .43148 .70784 L p .698 .226 .127 r
F P
0 g
s
.48618 .72291 m .49065 .72413 L p .48336 .72208 L .698 .226 .127 r
F P
0 g
s
.49065 .72413 m .43148 .70784 L .43852 .70945 L .698 .226 .127 r
F
.43148 .70784 m .41987 .7042 L p .43852 .70945 L F P
0 g
s
.42476 .70405 m .41987 .7042 L .4811 .72343 L p .664 .135 0 r
F P
0 g
s
.4811 .72343 m .49138 .72666 L p .47984 .72274 L .664 .135 0 r
F P
0 g
s
.47984 .72274 m .42476 .70405 L .4811 .72343 L .664 .135 0 r
F
.49138 .72666 m .49371 .72922 L .48935 .72762 L p F P
0 g
s
.48935 .72762 m .43618 .70822 L p .48018 .72292 L .664 .135 0 r
F P
0 g
s
.49138 .72666 m .48935 .72762 L .48018 .72292 L .664 .135 0 r
F
.49138 .72666 m .43618 .70822 L .44261 .71011 L F
.43618 .70822 m .42476 .70405 L p .44261 .71011 L F P
0 g
s
.4333 .70407 m .42476 .70405 L .49371 .72922 L p .55 0 0 r
F P
0 g
s
.49371 .72922 m .49764 .73185 L .45226 .71225 L p .55 0 0 r
F P
0 g
s
.49371 .72922 m .45226 .71225 L .4554 .71327 L .55 0 0 r
F
.50313 .73462 m .49764 .73185 L .56117 .73836 L p .797 .693 .749 r
F P
0 g
s
.56214 .73358 m .56117 .73836 L .49764 .73185 L p .775 .666 .744 r
F P
0 g
s
.49764 .73185 m .49371 .72922 L .56214 .73358 L p .775 .666 .744 r
F P
0 g
s
.49764 .73185 m .50313 .73462 L .46275 .71344 L p 0 .271 .657 r
F P
0 g
s
.46275 .71344 m .44543 .70436 L p .46482 .71457 L 0 .271 .657 r
F P
0 g
s
.49764 .73185 m .46275 .71344 L .46482 .71457 L 0 .271 .657 r
F
.45226 .71225 m .4333 .70407 L p .4554 .71327 L .55 0 0 r
F P
0 g
s
.48714 .72054 m .49149 .72159 L p .48404 .71983 L .699 .272 .23 r
F P
0 g
s
.70277 .37499 m .71856 .3801 L .73853 .42741 L p .874 .602 .524 r
F P
0 g
s
.44502 .3518 m .43427 .35979 L .4232 .39874 L p .366 .198 .516 r
F P
0 g
s
.56272 .72879 m .56292 .72399 L .6298 .70511 L p .76 .799 .885 r
F P
0 g
s
.62899 .69847 m .6298 .70511 L .56292 .72399 L p .75 .769 .868 r
F P
0 g
s
.6298 .70511 m .62899 .69847 L .6854 .66206 L p .817 .871 .886 r
F P
0 g
s
.63969 .33652 m .61932 .33622 L .59918 .31937 L p .692 .351 .395 r
F P
0 g
s
.58368 .32144 m .59918 .31937 L .61932 .33622 L p .663 .333 .405 r
F P
0 g
s
.53414 .34554 m .51523 .35025 L .52436 .3372 L p .443 .084 .261 r
F P
0 g
s
.52436 .3372 m .53789 .33225 L .53414 .34554 L p .443 .084 .261 r
F P
0 g
s
.74494 .48203 m .75764 .49049 L .74819 .5487 L p .914 .761 .678 r
F P
0 g
s
.75764 .49049 m .74494 .48203 L .73853 .42741 L p .934 .71 .576 r
F P
0 g
s
.41515 .44595 m .42242 .43974 L .4232 .39874 L p .266 .19 .581 r
F P
0 g
s
.469 .38563 m .45452 .39195 L .47234 .3683 L p .315 .023 .299 r
F P
0 g
s
.47234 .3683 m .48399 .36177 L .469 .38563 L p .315 .023 .299 r
F P
0 g
s
.44795 .51404 m .44237 .51648 L .46628 .54213 L p .261 .443 .852 r
F P
0 g
s
.46628 .54213 m .47053 .54172 L .44795 .51404 L p .261 .443 .852 r
F P
0 g
s
.55615 .75246 m .5539 .75706 L .52771 .74415 L p .9 .838 .775 r
F P
0 g
s
.53799 .74786 m .52771 .74415 L .5539 .75706 L p .939 .927 .766 r
F P
0 g
s
.5539 .75706 m .55144 .76159 L .53799 .74786 L p .939 .927 .766 r
F P
0 g
s
.49078 .30398 m .4762 .31102 L .45946 .3442 L p .498 .259 .483 r
F P
0 g
s
.44502 .3518 m .45946 .3442 L .4762 .31102 L p .386 .137 .409 r
F P
0 g
s
.52771 .74415 m .51833 .74073 L .55615 .75246 L p .9 .838 .775 r
F P
0 g
s
.55814 .74781 m .55615 .75246 L .51833 .74073 L p .858 .773 .766 r
F P
0 g
s
.51833 .74073 m .51007 .73757 L .55814 .74781 L p .858 .773 .766 r
F P
0 g
s
.55983 .74311 m .55814 .74781 L .51007 .73757 L p .825 .727 .757 r
F P
0 g
s
.49737 .62808 m .49513 .62586 L .4585 .59668 L p .076 .413 .863 r
F P
0 g
s
.61932 .33622 m .59788 .33699 L .58368 .32144 L p .663 .333 .405 r
F P
0 g
s
.56798 .32431 m .58368 .32144 L .59788 .33699 L p .63 .304 .401 r
F P
0 g
s
.43589 .55863 m .43157 .56036 L .41572 .52041 L p .211 .281 .719 r
F P
0 g
s
.41572 .52041 m .42037 .51681 L .43589 .55863 L p .211 .281 .719 r
F P
0 g
s
.68066 .65412 m .6854 .66206 L .62899 .69847 L p .803 .817 .863 r
F P
0 g
s
.6854 .66206 m .68066 .65412 L .72219 .60486 L p .87 .854 .824 r
F P
0 g
s
.55461 .3417 m .53414 .34554 L .53789 .33225 L p .53 .192 .339 r
F P
0 g
s
.53789 .33225 m .55256 .32793 L .55461 .3417 L p .53 .192 .339 r
F P
0 g
s
.51007 .73757 m .50313 .73462 L .55983 .74311 L p .825 .727 .757 r
F P
0 g
s
.56117 .73836 m .55983 .74311 L .50313 .73462 L p .797 .693 .749 r
F P
0 g
s
.47746 .54142 m .47053 .54172 L .49643 .56069 L p .151 .469 .892 r
F P
0 g
s
.49643 .56069 m .50102 .56224 L .47746 .54142 L p .151 .469 .892 r
F P
0 g
s
.52517 .56807 m .5155 .56586 L .53234 .57991 L p .022 .375 .841 r
F P
0 g
s
.53234 .57991 m .53704 .58334 L .52517 .56807 L p .022 .375 .841 r
F P
0 g
s
.49065 .72413 m .49149 .72159 L .56273 .71919 L p .718 .609 .735 r
F P
0 g
s
.56218 .71441 m .56273 .71919 L .49149 .72159 L p .7 .594 .734 r
F P
0 g
s
.56272 .72879 m .56214 .73358 L .49371 .72922 L p .754 .645 .74 r
F P
0 g
s
.29855 .60894 m .29994 .60231 L .26242 .52934 L p 0 .083 .64 r
F P
0 g
s
.29994 .60231 m .29855 .60894 L .35267 .66525 L p 0 .265 .773 r
F P
0 g
s
.59788 .33699 m .57608 .33883 L .56798 .32431 L p .63 .304 .401 r
F P
0 g
s
.55256 .32793 m .56798 .32431 L .57608 .33883 L p .588 .259 .38 r
F P
0 g
s
.57608 .33883 m .55461 .3417 L .55256 .32793 L p .588 .259 .38 r
F P
0 g
s
.43119 .47922 m .42457 .48367 L .44237 .51648 L p .338 .397 .776 r
F P
0 g
s
.44237 .51648 m .44795 .51404 L .43119 .47922 L p .338 .397 .776 r
F P
0 g
s
.49371 .72922 m .49138 .72666 L .56272 .72879 L p .754 .645 .74 r
F P
0 g
s
.56292 .72399 m .56272 .72879 L .49138 .72666 L p .736 .626 .737 r
F P
0 g
s
.46203 .59694 m .4585 .59668 L .43157 .56036 L p .221 .382 .812 r
F P
0 g
s
.43157 .56036 m .43589 .55863 L .46203 .59694 L p .221 .382 .812 r
F P
0 g
s
.4585 .59668 m .46203 .59694 L .49737 .62808 L p .076 .413 .863 r
F P
0 g
s
.49138 .72666 m .49065 .72413 L .56292 .72399 L p .736 .626 .737 r
F P
0 g
s
.56273 .71919 m .56292 .72399 L .49065 .72413 L p .718 .609 .735 r
F P
0 g
s
.56292 .72399 m .56273 .71919 L .62899 .69847 L p .75 .769 .868 r
F P
0 g
s
.62606 .6919 m .62899 .69847 L .56273 .71919 L p .739 .743 .855 r
F P
0 g
s
.62899 .69847 m .62606 .6919 L .68066 .65412 L p .803 .817 .863 r
F P
0 g
s
.44242 .42492 m .43 .43095 L .44363 .39864 L p .349 .147 .458 r
F P
0 g
s
.44363 .39864 m .45452 .39195 L .44242 .42492 L p .349 .147 .458 r
F P
0 g
s
.5362 .57064 m .52517 .56807 L .53704 .58334 L p .307 .501 .884 r
F P
0 g
s
.53704 .58334 m .54242 .58695 L .5362 .57064 L p .307 .501 .884 r
F P
0 g
s
.53097 .64137 m .54128 .64481 L .54731 .67351 L p .542 .618 .877 r
F P
0 g
s
.56273 .71919 m .56218 .71441 L .62606 .6919 L p .739 .743 .855 r
F P
0 g
s
.55121 .68217 m .54923 .67781 L .55227 .64862 L p .612 .635 .85 r
F P
0 g
s
.54128 .64481 m .55227 .64862 L .54923 .67781 L p .582 .627 .861 r
F P
0 g
s
.56218 .71441 m .56129 .70965 L .62115 .68548 L p .727 .722 .846 r
F P
0 g
s
.62115 .68548 m .62606 .6919 L .56218 .71441 L p .727 .722 .846 r
F P
0 g
s
.56129 .70965 m .56009 .70494 L .61445 .67925 L p .714 .704 .839 r
F P
0 g
s
.61445 .67925 m .62115 .68548 L .56129 .70965 L p .714 .704 .839 r
F P
0 g
s
.55319 .6866 m .55121 .68217 L .56363 .6528 L p .635 .643 .841 r
F P
0 g
s
.55227 .64862 m .56363 .6528 L .55121 .68217 L p .612 .635 .85 r
F P
0 g
s
.70277 .37499 m .68323 .37082 L .65831 .33783 L p .808 .495 .461 r
F P
0 g
s
.63969 .33652 m .65831 .33783 L .68323 .37082 L p .776 .489 .501 r
F P
0 g
s
.56009 .70494 m .55863 .70027 L .60619 .67329 L p .701 .688 .835 r
F P
0 g
s
.60619 .67329 m .61445 .67925 L .56009 .70494 L p .701 .688 .835 r
F P
0 g
s
.55513 .69109 m .55319 .6866 L .57504 .65736 L p .655 .653 .836 r
F P
0 g
s
.56363 .6528 m .57504 .65736 L .55319 .6866 L p .635 .643 .841 r
F P
0 g
s
.55863 .70027 m .55696 .69565 L .59666 .66763 L p .687 .675 .833 r
F P
0 g
s
.59666 .66763 m .60619 .67329 L .55863 .70027 L p .687 .675 .833 r
F P
0 g
s
.55696 .69565 m .55513 .69109 L .58617 .66231 L p .672 .663 .833 r
F P
0 g
s
.57504 .65736 m .58617 .66231 L .55513 .69109 L p .655 .653 .836 r
F P
0 g
s
.58617 .66231 m .59666 .66763 L .55696 .69565 L p .672 .663 .833 r
F P
0 g
s
.50119 .63038 m .49737 .62808 L .46203 .59694 L p .32 .514 .889 r
F P
0 g
s
.73611 .53991 m .74819 .5487 L .72219 .60486 L p .88 .786 .752 r
F P
0 g
s
.74819 .5487 m .73611 .53991 L .74494 .48203 L p .914 .761 .678 r
F P
0 g
s
.4232 .39874 m .43481 .39141 L .44502 .3518 L p .366 .198 .516 r
F P
0 g
s
.43481 .39141 m .4232 .39874 L .42242 .43974 L p .437 .329 .633 r
F P
0 g
s
.50781 .29758 m .49078 .30398 L .47737 .33719 L p .564 .331 .521 r
F P
0 g
s
.45946 .3442 m .47737 .33719 L .49078 .30398 L p .498 .259 .483 r
F P
0 g
s
.35267 .66525 m .35412 .66196 L .29994 .60231 L p 0 .265 .773 r
F P
0 g
s
.35412 .66196 m .35267 .66525 L .4186 .70439 L p 0 .301 .739 r
F P
0 g
s
.48707 .54135 m .47746 .54142 L .50102 .56224 L p .364 .544 .898 r
F P
0 g
s
.50102 .56224 m .5074 .56394 L .48707 .54135 L p .364 .544 .898 r
F P
0 g
s
.48685 .37989 m .469 .38563 L .48399 .36177 L p .463 .193 .418 r
F P
0 g
s
.48399 .36177 m .49838 .35571 L .48685 .37989 L p .463 .193 .418 r
F P
0 g
s
.45946 .3442 m .44502 .3518 L .43481 .39141 L p .487 .314 .571 r
F P
0 g
s
.72116 .42071 m .73853 .42741 L .74494 .48203 L p .874 .668 .62 r
F P
0 g
s
.73853 .42741 m .72116 .42071 L .70277 .37499 L p .874 .602 .524 r
F P
0 g
s
.45697 .51173 m .44795 .51404 L .47053 .54172 L p .425 .506 .838 r
F P
0 g
s
.47053 .54172 m .47746 .54142 L .45697 .51173 L p .425 .506 .838 r
F P
0 g
s
.4186 .70439 m .41987 .7042 L .35412 .66196 L p 0 .301 .739 r
F P
0 g
s
.4291 .51331 m .42037 .51681 L .41585 .47521 L p .374 .313 .66 r
F P
0 g
s
.41585 .47521 m .4247 .47011 L .4291 .51331 L p .374 .313 .66 r
F P
0 g
s
.62606 .6919 m .62115 .68548 L .67249 .64642 L p .785 .775 .843 r
F P
0 g
s
.67249 .64642 m .68066 .65412 L .62606 .6919 L p .785 .775 .843 r
F P
0 g
s
.68323 .37082 m .70277 .37499 L .72116 .42071 L p .829 .582 .566 r
F P
0 g
s
.71162 .59635 m .72219 .60486 L .68066 .65412 L p .838 .791 .807 r
F P
0 g
s
.72219 .60486 m .71162 .59635 L .73611 .53991 L p .88 .786 .752 r
F P
0 g
s
.50656 .6328 m .50119 .63038 L .46827 .59731 L p .448 .554 .871 r
F P
0 g
s
.46203 .59694 m .46827 .59731 L .50119 .63038 L p .32 .514 .889 r
F P
0 g
s
.25517 .43561 m .24538 .4485 L .26242 .52934 L p .161 .185 .638 r
F P
0 g
s
.68066 .65412 m .67249 .64642 L .71162 .59635 L p .838 .791 .807 r
F P
0 g
s
.46827 .59731 m .46203 .59694 L .43589 .55863 L p .407 .469 .812 r
F P
0 g
s
.52687 .29198 m .50781 .29758 L .49838 .33095 L p .61 .379 .542 r
F P
0 g
s
.47737 .33719 m .49838 .33095 L .50781 .29758 L p .564 .331 .521 r
F P
0 g
s
.49921 .54161 m .48707 .54135 L .5074 .56394 L p .476 .574 .874 r
F P
0 g
s
.5074 .56394 m .5155 .56586 L .49921 .54161 L p .476 .574 .874 r
F P
0 g
s
.42242 .43974 m .43395 .4337 L .43481 .39141 L p .437 .329 .633 r
F P
0 g
s
.68323 .37082 m .66064 .36774 L .63969 .33652 L p .776 .489 .501 r
F P
0 g
s
.61932 .33622 m .63969 .33652 L .66064 .36774 L p .748 .478 .523 r
F P
0 g
s
.44181 .47494 m .43119 .47922 L .44795 .51404 L p .468 .463 .77 r
F P
0 g
s
.44795 .51404 m .45697 .51173 L .44181 .47494 L p .468 .463 .77 r
F P
0 g
s
.44377 .557 m .43589 .55863 L .42037 .51681 L p .409 .402 .741 r
F P
0 g
s
.42037 .51681 m .4291 .51331 L .44377 .557 L p .409 .402 .741 r
F P
0 g
s
.50771 .37488 m .48685 .37989 L .49838 .35571 L p .545 .288 .477 r
F P
0 g
s
.49838 .35571 m .51523 .35025 L .50771 .37488 L p .545 .288 .477 r
F P
0 g
s
.45888 .41933 m .44242 .42492 L .45452 .39195 L p .481 .283 .534 r
F P
0 g
s
.45452 .39195 m .469 .38563 L .45888 .41933 L p .481 .283 .534 r
F P
0 g
s
.43589 .55863 m .44377 .557 L .46827 .59731 L p .407 .469 .812 r
F P
0 g
s
.62115 .68548 m .61445 .67925 L .6612 .63908 L p .768 .742 .829 r
F P
0 g
s
.6612 .63908 m .67249 .64642 L .62115 .68548 L p .768 .742 .829 r
F P
0 g
s
.49838 .33095 m .52201 .32565 L .52687 .29198 L p .61 .379 .542 r
F P
0 g
s
.51341 .6354 m .50656 .6328 L .47719 .59788 L p .522 .575 .85 r
F P
0 g
s
.46827 .59731 m .47719 .59788 L .50656 .6328 L p .448 .554 .871 r
F P
0 g
s
.4694 .50972 m .45697 .51173 L .47746 .54142 L p .513 .537 .818 r
F P
0 g
s
.47746 .54142 m .48707 .54135 L .4694 .50972 L p .513 .537 .818 r
F P
0 g
s
.72717 .47429 m .74494 .48203 L .73611 .53991 L p .861 .708 .691 r
F P
0 g
s
.74494 .48203 m .72717 .47429 L .72116 .42071 L p .874 .668 .62 r
F P
0 g
s
.47737 .33719 m .45946 .3442 L .45054 .38449 L p .557 .38 .598 r
F P
0 g
s
.43481 .39141 m .45054 .38449 L .45946 .3442 L p .487 .314 .571 r
F P
0 g
s
.51369 .54232 m .49921 .54161 L .5155 .56586 L p .542 .589 .851 r
F P
0 g
s
.5155 .56586 m .52517 .56807 L .51369 .54232 L p .542 .589 .851 r
F P
0 g
s
.45054 .38449 m .43481 .39141 L .43395 .4337 L p .525 .401 .652 r
F P
0 g
s
.53108 .37079 m .50771 .37488 L .51523 .35025 L p .598 .349 .51 r
F P
0 g
s
.51523 .35025 m .53414 .34554 L .53108 .37079 L p .598 .349 .51 r
F P
0 g
s
.66064 .36774 m .63579 .36586 L .61932 .33622 L p .748 .478 .523 r
F P
0 g
s
.59788 .33699 m .61932 .33622 L .63579 .36586 L p .721 .463 .535 r
F P
0 g
s
.26242 .52934 m .27175 .51933 L .25517 .43561 L p .161 .185 .638 r
F P
0 g
s
.27175 .51933 m .26242 .52934 L .29994 .60231 L p .237 .329 .756 r
F P
0 g
s
.47719 .59788 m .46827 .59731 L .44377 .557 L p .502 .511 .798 r
F P
0 g
s
.36105 .65869 m .35412 .66196 L .41987 .7042 L p .121 .479 .897 r
F P
0 g
s
.41987 .7042 m .42476 .70405 L .36105 .65869 L p .121 .479 .897 r
F P
0 g
s
.61445 .67925 m .60619 .67329 L .64718 .6322 L p .752 .715 .818 r
F P
0 g
s
.64718 .6322 m .6612 .63908 L .61445 .67925 L p .752 .715 .818 r
F P
0 g
s
.52161 .63824 m .51341 .6354 L .48868 .59875 L p .571 .59 .833 r
F P
0 g
s
.47719 .59788 m .48868 .59875 L .51341 .6354 L p .522 .575 .85 r
F P
0 g
s
.53019 .54357 m .51369 .54232 L .52517 .56807 L p .586 .601 .834 r
F P
0 g
s
.52517 .56807 m .5362 .57064 L .53019 .54357 L p .586 .601 .834 r
F P
0 g
s
.44193 .51007 m .4291 .51331 L .4247 .47011 L p .491 .401 .681 r
F P
0 g
s
.4247 .47011 m .43782 .46527 L .44193 .51007 L p .491 .401 .681 r
F P
0 g
s
.72116 .42071 m .69954 .41498 L .68323 .37082 L p .829 .582 .566 r
F P
0 g
s
.66064 .36774 m .68323 .37082 L .69954 .41498 L p .794 .564 .589 r
F P
0 g
s
.67249 .64642 m .6612 .63908 L .69689 .58834 L p .809 .745 .793 r
F P
0 g
s
.69689 .58834 m .71162 .59635 L .67249 .64642 L p .809 .745 .793 r
F P
0 g
s
.55635 .36775 m .53108 .37079 L .53414 .34554 L p .637 .39 .528 r
F P
0 g
s
.53414 .34554 m .55461 .3417 L .55635 .36775 L p .637 .39 .528 r
F P
0 g
s
.71921 .53174 m .73611 .53991 L .71162 .59635 L p .839 .733 .747 r
F P
0 g
s
.73611 .53991 m .71921 .53174 L .72717 .47429 L p .861 .708 .691 r
F P
0 g
s
.69954 .41498 m .72116 .42071 L .72717 .47429 L p .83 .635 .64 r
F P
0 g
s
.63579 .36586 m .60954 .36523 L .59788 .33699 L p .721 .463 .535 r
F P
0 g
s
.57608 .33883 m .59788 .33699 L .60954 .36523 L p .696 .444 .539 r
F P
0 g
s
.47911 .41438 m .45888 .41933 L .469 .38563 L p .555 .359 .571 r
F P
0 g
s
.469 .38563 m .48685 .37989 L .47911 .41438 L p .555 .359 .571 r
F P
0 g
s
.45637 .471 m .44181 .47494 L .45697 .51173 L p .54 .5 .76 r
F P
0 g
s
.45697 .51173 m .4694 .50972 L .45637 .471 L p .54 .5 .76 r
F P
0 g
s
.48509 .50816 m .4694 .50972 L .48707 .54135 L p .567 .557 .802 r
F P
0 g
s
.48707 .54135 m .49921 .54161 L .48509 .50816 L p .567 .557 .802 r
F P
0 g
s
.44543 .70436 m .4333 .70407 L .49764 .73185 L p 0 .271 .657 r
F P
0 g
s
.58277 .36587 m .55635 .36775 L .55461 .3417 L p .668 .421 .537 r
F P
0 g
s
.55461 .3417 m .57608 .33883 L .58277 .36587 L p .668 .421 .537 r
F P
0 g
s
.71162 .59635 m .69689 .58834 L .71921 .53174 L p .839 .733 .747 r
F P
0 g
s
.43395 .4337 m .44969 .42806 L .45054 .38449 L p .525 .401 .652 r
F P
0 g
s
.60954 .36523 m .58277 .36587 L .57608 .33883 L p .696 .444 .539 r
F P
0 g
s
.29994 .60231 m .30834 .59565 L .27175 .51933 L p .237 .329 .756 r
F P
0 g
s
.30834 .59565 m .29994 .60231 L .35412 .66196 L p .252 .432 .846 r
F P
0 g
s
.35412 .66196 m .36105 .65869 L .30834 .59565 L p .252 .432 .846 r
F P
0 g
s
.53097 .64137 m .52161 .63824 L .50253 .60003 L p .605 .601 .821 r
F P
0 g
s
.48868 .59875 m .50253 .60003 L .52161 .63824 L p .571 .59 .833 r
F P
0 g
s
.60619 .67329 m .59666 .66763 L .63093 .62587 L p .737 .694 .81 r
F P
0 g
s
.63093 .62587 m .64718 .6322 L .60619 .67329 L p .737 .694 .81 r
F P
0 g
s
.44377 .557 m .4552 .55563 L .47719 .59788 L p .502 .511 .798 r
F P
0 g
s
.4552 .55563 m .44377 .557 L .4291 .51331 L p .507 .461 .74 r
F P
0 g
s
.4291 .51331 m .44193 .51007 L .4552 .55563 L p .507 .461 .74 r
F P
0 g
s
.49838 .33095 m .47737 .33719 L .47017 .37817 L p .603 .424 .612 r
F P
0 g
s
.45054 .38449 m .47017 .37817 L .47737 .33719 L p .557 .38 .598 r
F P
0 g
s
.54128 .64481 m .53097 .64137 L .51845 .6018 L p .632 .612 .812 r
F P
0 g
s
.50253 .60003 m .51845 .6018 L .53097 .64137 L p .605 .601 .821 r
F P
0 g
s
.59666 .66763 m .58617 .66231 L .61297 .62016 L p .721 .676 .805 r
F P
0 g
s
.61297 .62016 m .63093 .62587 L .59666 .66763 L p .721 .676 .805 r
F P
0 g
s
.48868 .59875 m .47719 .59788 L .4552 .55563 L p .56 .537 .786 r
F P
0 g
s
.47017 .37817 m .45054 .38449 L .44969 .42806 L p .58 .445 .661 r
F P
0 g
s
.46094 .70504 m .44543 .70436 L .50313 .73462 L p .024 .469 .876 r
F P
0 g
s
.50313 .73462 m .51007 .73757 L .46094 .70504 L p .024 .469 .876 r
F P
0 g
s
.55227 .64862 m .54128 .64481 L .53604 .60414 L p .654 .623 .806 r
F P
0 g
s
.51845 .6018 m .53604 .60414 L .54128 .64481 L p .632 .612 .812 r
F P
0 g
s
.50271 .41025 m .47911 .41438 L .48685 .37989 L p .603 .409 .591 r
F P
0 g
s
.48685 .37989 m .50771 .37488 L .50271 .41025 L p .603 .409 .591 r
F P
0 g
s
.50375 .50718 m .48509 .50816 L .49921 .54161 L p .605 .572 .79 r
F P
0 g
s
.49921 .54161 m .51369 .54232 L .50375 .50718 L p .605 .572 .79 r
F P
0 g
s
.58617 .66231 m .57504 .65736 L .5939 .61512 L p .706 .66 .802 r
F P
0 g
s
.5939 .61512 m .61297 .62016 L .58617 .66231 L p .706 .66 .802 r
F P
0 g
s
.69954 .41498 m .67442 .41038 L .66064 .36774 L p .794 .564 .589 r
F P
0 g
s
.63579 .36586 m .66064 .36774 L .67442 .41038 L p .765 .546 .602 r
F P
0 g
s
.6612 .63908 m .64718 .6322 L .67851 .58097 L p .786 .711 .782 r
F P
0 g
s
.67851 .58097 m .69689 .58834 L .6612 .63908 L p .786 .711 .782 r
F P
0 g
s
.70497 .46748 m .72717 .47429 L .71921 .53174 L p .822 .67 .695 r
F P
0 g
s
.72717 .47429 m .70497 .46748 L .69954 .41498 L p .83 .635 .64 r
F P
0 g
s
.56363 .6528 m .55227 .64862 L .55484 .60712 L p .673 .634 .802 r
F P
0 g
s
.53604 .60414 m .55484 .60712 L .55227 .64862 L p .654 .623 .806 r
F P
0 g
s
.52201 .32565 m .49838 .33095 L .4933 .37267 L p .638 .456 .62 r
F P
0 g
s
.47017 .37817 m .4933 .37267 L .49838 .33095 L p .603 .424 .612 r
F P
0 g
s
.57504 .65736 m .56363 .6528 L .57432 .61077 L p .69 .646 .801 r
F P
0 g
s
.57432 .61077 m .5939 .61512 L .57504 .65736 L p .69 .646 .801 r
F P
0 g
s
.4747 .4676 m .45637 .471 L .4694 .50972 L p .587 .525 .752 r
F P
0 g
s
.4694 .50972 m .48509 .50816 L .4747 .4676 L p .587 .525 .752 r
F P
0 g
s
.37357 .65563 m .36105 .65869 L .42476 .70405 L p .329 .554 .916 r
F P
0 g
s
.42476 .70405 m .4333 .70407 L .37357 .65563 L p .329 .554 .916 r
F P
0 g
s
.55484 .60712 m .57432 .61077 L .56363 .6528 L p .673 .634 .802 r
F P
0 g
s
.45873 .50727 m .44193 .51007 L .43782 .46527 L p .557 .451 .689 r
F P
0 g
s
.43782 .46527 m .45512 .46089 L .45873 .50727 L p .557 .451 .689 r
F P
0 g
s
.47953 .70622 m .46094 .70504 L .51007 .73757 L p .261 .566 .936 r
F P
0 g
s
.51007 .73757 m .51833 .74073 L .47953 .70622 L p .261 .566 .936 r
F P
0 g
s
.67442 .41038 m .69954 .41498 L .70497 .46748 L p .796 .61 .649 r
F P
0 g
s
.4552 .55563 m .47006 .55465 L .48868 .59875 L p .56 .537 .786 r
F P
0 g
s
.47006 .55465 m .4552 .55563 L .44193 .51007 L p .565 .497 .737 r
F P
0 g
s
.44969 .42806 m .46941 .423 L .47017 .37817 L p .58 .445 .661 r
F P
0 g
s
.50253 .60003 m .48868 .59875 L .47006 .55465 L p .6 .556 .777 r
F P
0 g
s
.52496 .50692 m .50375 .50718 L .51369 .54232 L p .634 .584 .781 r
F P
0 g
s
.51369 .54232 m .53019 .54357 L .52496 .50692 L p .634 .584 .781 r
F P
0 g
s
.69689 .58834 m .67851 .58097 L .69807 .52439 L p .807 .695 .741 r
F P
0 g
s
.69807 .52439 m .71921 .53174 L .69689 .58834 L p .807 .695 .741 r
F P
0 g
s
.71921 .53174 m .69807 .52439 L .70497 .46748 L p .822 .67 .695 r
F P
0 g
s
.44193 .51007 m .45873 .50727 L .47006 .55465 L p .565 .497 .737 r
F P
0 g
s
.5291 .40712 m .50271 .41025 L .50771 .37488 L p .639 .443 .602 r
F P
0 g
s
.50771 .37488 m .53108 .37079 L .5291 .40712 L p .639 .443 .602 r
F P
0 g
s
.4933 .37267 m .5194 .36818 L .52201 .32565 L p .638 .456 .62 r
F P
0 g
s
.67442 .41038 m .6467 .40706 L .63579 .36586 L p .765 .546 .602 r
F P
0 g
s
.60954 .36523 m .63579 .36586 L .6467 .40706 L p .74 .529 .609 r
F P
0 g
s
.50075 .708 m .47953 .70622 L .51833 .74073 L p .402 .605 .93 r
F P
0 g
s
.51833 .74073 m .52771 .74415 L .50075 .708 L p .402 .605 .93 r
F P
0 g
s
.4933 .37267 m .47017 .37817 L .46941 .423 L p .619 .476 .666 r
F P
0 g
s
.2738 .42295 m .25517 .43561 L .27175 .51933 L p .387 .344 .688 r
F P
0 g
s
.64718 .6322 m .63093 .62587 L .65712 .57439 L p .765 .684 .774 r
F P
0 g
s
.65712 .57439 m .67851 .58097 L .64718 .6322 L p .765 .684 .774 r
F P
0 g
s
.49645 .4649 m .4747 .4676 L .48509 .50816 L p .621 .544 .746 r
F P
0 g
s
.48509 .50816 m .50375 .50718 L .49645 .4649 L p .621 .544 .746 r
F P
0 g
s
.52407 .71044 m .50075 .708 L .52771 .74415 L p .488 .621 .908 r
F P
0 g
s
.52771 .74415 m .53799 .74786 L .52407 .71044 L p .488 .621 .908 r
F P
0 g
s
.55757 .40515 m .5291 .40712 L .53108 .37079 L p .667 .47 .609 r
F P
0 g
s
.53108 .37079 m .55635 .36775 L .55757 .40515 L p .667 .47 .609 r
F P
0 g
s
.51845 .6018 m .50253 .60003 L .48808 .5542 L p .63 .572 .771 r
F P
0 g
s
.47006 .55465 m .48808 .5542 L .50253 .60003 L p .6 .556 .777 r
F P
0 g
s
.32395 .58923 m .30834 .59565 L .36105 .65869 L p .416 .5 .837 r
F P
0 g
s
.36105 .65869 m .37357 .65563 L .32395 .58923 L p .416 .5 .837 r
F P
0 g
s
.6467 .40706 m .61733 .40507 L .60954 .36523 L p .74 .529 .609 r
F P
0 g
s
.58277 .36587 m .60954 .36523 L .61733 .40507 L p .716 .512 .612 r
F P
0 g
s
.39161 .65297 m .37357 .65563 L .4333 .70407 L p .447 .584 .897 r
F P
0 g
s
.4333 .70407 m .44543 .70436 L .39161 .65297 L p .447 .584 .897 r
F P
0 g
s
.47922 .5051 m .45873 .50727 L .45512 .46089 L p .601 .484 .692 r
F P
0 g
s
.45512 .46089 m .47631 .45716 L .47922 .5051 L p .601 .484 .692 r
F P
0 g
s
.58729 .40444 m .55757 .40515 L .55635 .36775 L p .693 .492 .612 r
F P
0 g
s
.55635 .36775 m .58277 .36587 L .58729 .40444 L p .693 .492 .612 r
F P
0 g
s
.61733 .40507 m .58729 .40444 L .58277 .36587 L p .716 .512 .612 r
F P
0 g
s
.67911 .46176 m .70497 .46748 L .69807 .52439 L p .792 .642 .696 r
F P
0 g
s
.70497 .46748 m .67911 .46176 L .67442 .41038 L p .796 .61 .649 r
F P
0 g
s
.48808 .5542 m .47006 .55465 L .45873 .50727 L p .606 .522 .734 r
F P
0 g
s
.63093 .62587 m .61297 .62016 L .63344 .56868 L p .746 .663 .768 r
F P
0 g
s
.63344 .56868 m .65712 .57439 L .63093 .62587 L p .746 .663 .768 r
F P
0 g
s
.46941 .423 m .49274 .41874 L .4933 .37267 L p .619 .476 .666 r
F P
0 g
s
.6467 .40706 m .67442 .41038 L .67911 .46176 L p .769 .589 .655 r
F P
0 g
s
.27175 .51933 m .28942 .50956 L .2738 .42295 L p .387 .344 .688 r
F P
0 g
s
.28942 .50956 m .27175 .51933 L .30834 .59565 L p .417 .429 .765 r
F P
0 g
s
.5194 .36818 m .4933 .37267 L .49274 .41874 L p .648 .5 .669 r
F P
0 g
s
.30834 .59565 m .32395 .58923 L .28942 .50956 L p .417 .429 .765 r
F P
0 g
s
.67851 .58097 m .65712 .57439 L .67343 .518 L p .781 .666 .736 r
F P
0 g
s
.67343 .518 m .69807 .52439 L .67851 .58097 L p .781 .666 .736 r
F P
0 g
s
.53604 .60414 m .51845 .6018 L .5089 .55442 L p .654 .586 .766 r
F P
0 g
s
.48808 .5542 m .5089 .55442 L .51845 .6018 L p .63 .572 .771 r
F P
0 g
s
.45873 .50727 m .47922 .5051 L .48808 .5542 L p .606 .522 .734 r
F P
0 g
s
.52112 .46308 m .49645 .4649 L .50375 .50718 L p .648 .56 .742 r
F P
0 g
s
.50375 .50718 m .52496 .50692 L .52112 .46308 L p .648 .56 .742 r
F P
0 g
s
.69807 .52439 m .67343 .518 L .67911 .46176 L p .792 .642 .696 r
F P
0 g
s
.61297 .62016 m .5939 .61512 L .60827 .56391 L p .728 .644 .765 r
F P
0 g
s
.60827 .56391 m .63344 .56868 L .61297 .62016 L p .728 .644 .765 r
F P
0 g
s
.55484 .60712 m .53604 .60414 L .532 .55542 L p .675 .6 .764 r
F P
0 g
s
.5089 .55442 m .532 .55542 L .53604 .60414 L p .654 .586 .766 r
F P
0 g
s
.49274 .41874 m .51915 .41545 L .5194 .36818 L p .648 .5 .669 r
F P
0 g
s
.5939 .61512 m .57432 .61077 L .58243 .56012 L p .711 .628 .763 r
F P
0 g
s
.58243 .56012 m .60827 .56391 L .5939 .61512 L p .711 .628 .763 r
F P
0 g
s
.5089 .55442 m .48808 .5542 L .47922 .5051 L p .636 .542 .731 r
F P
0 g
s
.67911 .46176 m .65049 .45726 L .6467 .40706 L p .769 .589 .655 r
F P
0 g
s
.61733 .40507 m .6467 .40706 L .65049 .45726 L p .745 .57 .658 r
F P
0 g
s
.57432 .61077 m .55484 .60712 L .55674 .5573 L p .693 .613 .763 r
F P
0 g
s
.532 .55542 m .55674 .5573 L .55484 .60712 L p .675 .6 .764 r
F P
0 g
s
.50299 .50372 m .47922 .5051 L .47631 .45716 L p .634 .51 .694 r
F P
0 g
s
.47631 .45716 m .50097 .45428 L .50299 .50372 L p .634 .51 .694 r
F P
0 g
s
.55674 .5573 m .58243 .56012 L .57432 .61077 L p .693 .613 .763 r
F P
0 g
s
.41492 .65091 m .39161 .65297 L .44543 .70436 L p .519 .6 .874 r
F P
0 g
s
.44543 .70436 m .46094 .70504 L .41492 .65091 L p .519 .6 .874 r
F P
0 g
s
.65049 .45726 m .67911 .46176 L .67343 .518 L p .766 .619 .696 r
F P
0 g
s
.65712 .57439 m .63344 .56868 L .64615 .51269 L p .759 .643 .733 r
F P
0 g
s
.64615 .51269 m .67343 .518 L .65712 .57439 L p .759 .643 .733 r
F P
0 g
s
.47922 .5051 m .50299 .50372 L .5089 .55442 L p .636 .542 .731 r
F P
0 g
s
.55811 .45168 m .52849 .4524 L .5291 .40712 L p .679 .516 .658 r
F P
0 g
s
.5291 .40712 m .55757 .40515 L .55811 .45168 L p .679 .516 .658 r
F P
0 g
s
.65049 .45726 m .6201 .45407 L .61733 .40507 L p .745 .57 .658 r
F P
0 g
s
.58729 .40444 m .61733 .40507 L .6201 .45407 L p .723 .553 .659 r
F P
0 g
s
.67343 .518 m .64615 .51269 L .65049 .45726 L p .766 .619 .696 r
F P
0 g
s
.34673 .58331 m .32395 .58923 L .37357 .65563 L p .505 .533 .819 r
F P
0 g
s
.37357 .65563 m .39161 .65297 L .34673 .58331 L p .505 .533 .819 r
F P
0 g
s
.532 .55542 m .5089 .55442 L .50299 .50372 L p .661 .559 .73 r
F P
0 g
s
.58897 .45221 m .55811 .45168 L .55757 .40515 L p .701 .535 .659 r
F P
0 g
s
.55757 .40515 m .58729 .40444 L .58897 .45221 L p .701 .535 .659 r
F P
0 g
s
.6201 .45407 m .58897 .45221 L .58729 .40444 L p .723 .553 .659 r
F P
0 g
s
.52944 .50326 m .50299 .50372 L .50097 .45428 L p .66 .53 .695 r
F P
0 g
s
.50097 .45428 m .52849 .4524 L .52944 .50326 L p .66 .53 .695 r
F P
0 g
s
.63344 .56868 m .60827 .56391 L .61715 .50855 L p .739 .624 .731 r
F P
0 g
s
.61715 .50855 m .64615 .51269 L .63344 .56868 L p .739 .624 .731 r
F P
0 g
s
.6201 .45407 m .65049 .45726 L .64615 .51269 L p .744 .6 .696 r
F P
0 g
s
.50299 .50372 m .52944 .50326 L .532 .55542 L p .661 .559 .73 r
F P
0 g
s
.55674 .5573 m .532 .55542 L .52944 .50326 L p .682 .575 .729 r
F P
0 g
s
.3013 .41092 m .2738 .42295 L .28942 .50956 L p .496 .42 .7 r
F P
0 g
s
.44304 .64963 m .41492 .65091 L .46094 .70504 L p .567 .61 .855 r
F P
0 g
s
.46094 .70504 m .47953 .70622 L .44304 .64963 L p .567 .61 .855 r
F P
0 g
s
.60827 .56391 m .58243 .56012 L .58739 .50561 L p .72 .606 .729 r
F P
0 g
s
.58739 .50561 m .61715 .50855 L .60827 .56391 L p .72 .606 .729 r
F P
0 g
s
.64615 .51269 m .61715 .50855 L .6201 .45407 L p .744 .6 .696 r
F P
0 g
s
.55785 .50386 m .52944 .50326 L .52849 .4524 L p .683 .548 .695 r
F P
0 g
s
.52849 .4524 m .55811 .45168 L .55785 .50386 L p .683 .548 .695 r
F P
0 g
s
.58243 .56012 m .55674 .5573 L .55785 .50386 L p .701 .59 .729 r
F P
0 g
s
.52944 .50326 m .55785 .50386 L .55674 .5573 L p .682 .575 .729 r
F P
0 g
s
.55785 .50386 m .58739 .50561 L .58243 .56012 L p .701 .59 .729 r
F P
0 g
s
.58897 .45221 m .6201 .45407 L .61715 .50855 L p .724 .582 .696 r
F P
0 g
s
.31544 .50037 m .28942 .50956 L .32395 .58923 L p .51 .479 .759 r
F P
0 g
s
.32395 .58923 m .34673 .58331 L .31544 .50037 L p .51 .479 .759 r
F P
0 g
s
.58739 .50561 m .55785 .50386 L .55811 .45168 L p .704 .565 .696 r
F P
0 g
s
.55811 .45168 m .58897 .45221 L .58739 .50561 L p .704 .565 .696 r
F P
0 g
s
.28942 .50956 m .31544 .50037 L .3013 .41092 L p .496 .42 .7 r
F P
0 g
s
.61715 .50855 m .58739 .50561 L .58897 .45221 L p .724 .582 .696 r
F P
0 g
s
.47532 .64931 m .44304 .64963 L .47953 .70622 L p .602 .619 .841 r
F P
0 g
s
.47953 .70622 m .50075 .708 L .47532 .64931 L p .602 .619 .841 r
F P
0 g
s
.37641 .57817 m .34673 .58331 L .39161 .65297 L p .561 .555 .804 r
F P
0 g
s
.39161 .65297 m .41492 .65091 L .37641 .57817 L p .561 .555 .804 r
F P
0 g
s
.51089 .65008 m .47532 .64931 L .50075 .708 L p .629 .628 .83 r
F P
0 g
s
.50075 .708 m .52407 .71044 L .51089 .65008 L p .629 .628 .83 r
F P
0 g
s
.3495 .49212 m .31544 .50037 L .34673 .58331 L p .567 .511 .752 r
F P
0 g
s
.34673 .58331 m .37641 .57817 L .3495 .49212 L p .567 .511 .752 r
F P
0 g
s
.33734 .39996 m .3013 .41092 L .31544 .50037 L p .56 .464 .703 r
F P
0 g
s
.41242 .57409 m .37641 .57817 L .41492 .65091 L p .6 .571 .792 r
F P
0 g
s
.41492 .65091 m .44304 .64963 L .41242 .57409 L p .6 .571 .792 r
F P
0 g
s
.31544 .50037 m .3495 .49212 L .33734 .39996 L p .56 .464 .703 r
F P
0 g
s
.4539 .57132 m .41242 .57409 L .44304 .64963 L p .63 .584 .784 r
F P
0 g
s
.44304 .64963 m .47532 .64931 L .4539 .57132 L p .63 .584 .784 r
F P
0 g
s
.39096 .48517 m .3495 .49212 L .37641 .57817 L p .606 .533 .746 r
F P
0 g
s
.37641 .57817 m .41242 .57409 L .39096 .48517 L p .606 .533 .746 r
F P
0 g
s
.38126 .39048 m .33734 .39996 L .3495 .49212 L p .603 .495 .704 r
F P
0 g
s
.49973 .57008 m .4539 .57132 L .47532 .64931 L p .654 .597 .779 r
F P
0 g
s
.47532 .64931 m .51089 .65008 L .49973 .57008 L p .654 .597 .779 r
F P
0 g
s
.3495 .49212 m .39096 .48517 L .38126 .39048 L p .603 .495 .704 r
F P
0 g
s
.43885 .47987 m .39096 .48517 L .41242 .57409 L p .636 .552 .742 r
F P
0 g
s
.41242 .57409 m .4539 .57132 L .43885 .47987 L p .636 .552 .742 r
F P
0 g
s
.432 .38288 m .38126 .39048 L .39096 .48517 L p .635 .519 .704 r
F P
0 g
s
.39096 .48517 m .43885 .47987 L .432 .38288 L p .635 .519 .704 r
F P
0 g
s
.49183 .47649 m .43885 .47987 L .4539 .57132 L p .661 .568 .739 r
F P
0 g
s
.4539 .57132 m .49973 .57008 L .49183 .47649 L p .661 .568 .739 r
F P
0 g
s
.48816 .37752 m .432 .38288 L .43885 .47987 L p .661 .538 .703 r
F P
0 g
s
.43885 .47987 m .49183 .47649 L .48816 .37752 L p .661 .538 .703 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00V`3oool00`000000oooo0?ooo`220?ooo`00VP3oool00`000000f?;R000000230?ooo`00
V03oool2000000040=SQg0000000000000000880oooo002F0?ooo`80000000<0Q39L0000003HhM`0
0P3HhM`200000840oooo002D0?ooo`<0000000<0Q39L000000000000100000000`3HhM`000000?oo
o`1o0?ooo`00TP3oool3000000<0Q39L00<000000<o6d@0000001P00001o0?ooo`00T03oool20000
0080KAM900@0000008@bG024<U`0Q39L2`00001m0?ooo`00S`3oool200000080KAM900@0000008@b
G024<U`0Q39L3P00001k0?ooo`00SP3oool200000080KAM900@0000008@bG024<U`0Q39L0P000004
0<JebP/00000N@3oool008d0oooo00<0000004D09@0000000P1]5dT01@24<U`00000000000000000
W66:00D000000`32[lP;000007H0oooo002<0?ooo`040000001502D0000006dGB@<00000102LHHX0
0`000000`Zo80000000C000007<0oooo002;0?ooo`030000001502D000000080000000<0T5B50000
002LHHX00`2LHHX9000000030;ZVa@000000000000d00000L@3oool008X0oooo00@0000004D09@00
000000000`2@E8D00`000000W66:09aQRP0209aQRP<000000`2jY/DF000006h0oooo00280?ooo`D0
00000`2@E8D00`000000W66:09aQRP0309aQRP030000002jY/D0000001L0000000<0Z2lP00000000
00000P00001[0?ooo`00Q`3oool30000000307m2N`000000T5B500<0T5B500<0000009aQRP2LHHX0
0`2LHHX2000000040;JRa0000000000000000080/Yk33`0000000`2O=Sh0000000000008000006P0
oooo00260?ooo`8000000`1o@W/00`000000T5B5091DQ@02091DQ@030000002LHHX0W66:00<0W66:
0P0000030;:N``80000000<0[Y_30000000000002000000208`W?Q400000I@3oool008@0oooo0P00
00000`1R8fP0000007m2N`0207m2N`030000002@E8D0T5B50080T5B500<0000009aQRP2LHHX00P2L
HHX010000000/Yk30;:N``2bW/<6000000030:FDa0000000000000<000000`1l5C<E000006<0oooo
00230?ooo`80000000<0HR=X0000001o@W/00P1o@W/00`000000T5B5091DQ@02091DQ@030000002L
HHX0W66:00<0W66:0`0000000`2^Vl<0000000000002000000030:FDa00000000000008000000`1S
01d500000080ZEEW00<000000;5II@2aFFD00P2aFFD200000080]e]M0P000000102mFU0000000000
0031DSL400000640oooo00220?ooo`050000000Y03h00000068SJ00000000`1o@W/00`000000T5B5
091DQ@02091DQ@040000002LHHX0W66:09aQRP<0000000<0^jg<0000000000000P0000020:FDa080
00000P0j000500000080XDeV00<000000:UEI`2YEFL00P2YEFL00`000000/EUU0;5II@030;5II@05
0000002gFed0]e]M0;MKG@0000000P2mFU02000000040<5B=`000000_Sh800000600oooo00210?oo
o`050000000Y03h00000068SJ0000000101o@W/010000000T5B5091DQ@2@E8D500000080XgBN1000
00020:FDa0H000000P2F@V400`000000XDeV0:5=IP030:5=IP030000002YEFL0ZEEW0080ZEEW0P00
00040;5II@040000002gFed0]e]M0;MKG@8000000P2mFU000`000000`E8g00000003000005h0oooo
00210?ooo`8000000P1R8fP01P000000Od9k07m2N`1o@W/00000091DQ@<0000000<0VVbL0000002S
M9h0102SM9h3000000030:FDa000000000000080000000<0Qc5F0000002F@V40102F@V400`000000
XDeV0:5=IP030:5=IP030000002YEFL0ZEEW00<0ZEEW00<000000;5II@2aFFD00P2aFFD2000000<0
]e]M0P000000102mFU00000000000031DSL3000005d0oooo00200?ooo`050000000Y03h00000068S
J00000000`1o@W/3000000@0VVbL00<000000:=dWP2SM9h00`2SM9h400000003074E@P000000Qc5F
0080Qc5F00<0000009I2H@2F@V400`2F@V400`000000XDeV0:5=IP020:5=IQP0000000@0`E8g0000
000000000000F`3oool00800oooo0P000002068SJ00607m2N`00000000000000002>HIT00000102J
K9`00`000000XgBN0:=dWP040:=dWP050000001a5D80LAE2074E@P0000001@27<EH010000000UT9Q
09I2H@2F@V4600000080/W6900<000000;QfR02hMXP0102hMXP00`000000_gZ50;mjQ@030;mjQ@03
00000036OH00aWf00080aWf000<000000<inMP0000001P00001J0?ooo`00O`3oool200000080HR=X
0P00000308iQV@030000002JK9`0VVbL00<0VVbL00<000000:=dWP2SM9h0102SM9h01@000000LAE2
074E@P1a5D80000000<0Qc5F1P0000020:][R@030000002bLHT0/W6900@0/W6900<000000;QfR02h
MXP00`2hMXP00`000000_gZ50;mjQ@030;mjQ@0300000036OH00aWf000<0aWf000@000000<inMP3>
OWH0cWif1P00001H0?ooo`00OP3oool00`000000:@0n068SJ003000000@0SV6I00<0000009Y/W02J
K9`00`2JK9`00`000000XgBN0:=dWP040:=dWP030000001a5D80000000D000000P2SHhL00`000000
Zf^90:][R@030:][R@030000002bLHT0/W6900@0/W6900<000000;QfR02hMXP0102hMXP00`000000
_gZ50;mjQ@030;mjQ@0300000036OH00aWf00080aWf000<000000<inMP3>OWH00P3>OWH00`000000
f7eR0=QmHP03000005L0oooo001n0?ooo`<000000P1lD9800`000000SV6I08iQV@0208iQV@030000
002JK9`0VVbL00<0VVbL00<000000:=dWP2SM9h0102SM9h200000080VEV200<000000:=SQ`2SHhL0
0`2SHhL00`000000Zf^90:][R@040:][R@030000002bLHT0/W6900<0/W6900<000000;QfR02hMXP0
102hMXP00`000000_gZ50;mjQ@040;mjQ@0300000036OH00aWf00080aWf000D000000<inMP3>OWH0
cWif000000030=QmHP030000003NLcT0000005H0oooo001m0?ooo`<000000P1lD9800`000000SV6I
08iQV@0308iQV@030000002JK9`0VVbL00<0VVbL00<000000:=dWP2SM9h0102SM9h01@000000VEV2
09UIPP2IFH80000000D0Xf>700<000000:][R@2[JhT0102[JhT00`000000/W690;9aR@040;9aR@03
0000002hMXP0^7J800@0^7J800<000000;mjQ@2oNXD00`2oNXD00`000000aWf00<ImP0030<ImP005
0000003>OWH0cWif0<inMP0000000P3HOF8010000000gW<i0=ic>@00001E0?ooo`00O03oool30000
00<0O52B00<0000008iQV@2>HIT00P2>HIT00`000000VVbL09Y/W00409Y/W0030000002SM9h0XgBN
00@0XgBN00D0000009UIPP2IFH80VEV2000000050:=SQ`030000002[JhT0Zf^900@0Zf^900<00000
0;9aR@2bLHT0102bLHT00`000000^7J80;QfR0040;QfR0030000002oNXD0_gZ500@0_gZ500<00000
0<ImP036OH000`36OH001@000000cWif0<inMP3>OWH000000080f7eR00@000000=ic>@0000000000
E03oool007`0oooo00<0000005dbQ00000000`1lD9800`000000SV6I08iQV@0208iQV@030000002J
K9`0VVbL00<0VVbL00<000000:=dWP2SM9h01@2SM9h010000000VEV209UIPP0000060:=SQ`030000
002[JhT0Zf^900@0Zf^900<000000;9aR@2bLHT01@2bLHT00`000000^7J80;QfR0040;QfR0030000
002oNXD0_gZ500@0_gZ500<000000<ImP036OH000`36OH001@000000cWif0<inMP3>OWH000000080
f7eR00<000000=ic>@000000E03oool007/0oooo0P0000000`1M<X@0000007a@TP0207a@TP030000
002>HIT0SV6I0080SV6I00<0000009Y/W02JK9`00`2JK9`00`000000XgBN0:=dWP050:=dWP040000
002IFH80VEV2000000H0Xf>700<000000:][R@2[JhT01@2[JhT010000000/W690;9aR@2bLHT70000
00<0^7J800<000000;mjQ@2oNXD0102oNXD00`000000aWf00<ImP0030<ImP0030000003>OWH0cWif
0080cWif00H000000=QmHP3HOF8000000=ic>@00001C0?ooo`00NP3oool200000080GC:400D00000
07a@TP1lD980O52B0000000408iQV@030000002JK9`0VVbL00<0VVbL00<000000:=dWP2SM9h00P2S
M9h400000080VEV200@000000:=SQ`2SHhL0Xf>73`0000030;N3W0040000002mQi/0_HNK0;f7V`l0
00000P36OH001@000000cWif0<inMP3>OWH0000000<0f7eR00<000000=ic>@000000DP3oool007T0
oooo0`0000000`1M<X@0000007a@TP0307a@TP050000002>HIT0SV6I08iQV@0000001@2JK9`60000
00<0YGn[1`0000030:YhV`030000002aOI`0/GfL00D0/GfL00<000000;N3W02gPi`0102gPi`00`00
0000_HNK0;f7V`050;f7V`0300000033RiX0`h^J00@0`h^J00@000000<^@UP3;T9H0bi2F1P000000
0`3>OWH000000=QmHP020=QmHP030000003NLcT000000540oooo001i0?ooo`050000000K05l00000
05dbQ00000000`1lD9800`000000SV6I08iQV@0208iQV@030000002JK9`0000000<0000000<0WWVZ
0000002UOj/01P2UOj/010000000Xg6J0:=aVP0000060:YhV`030000002aOI`0/GfL00D0/GfL00<0
00000;N3W02gPi`01@2gPi`00`000000_HNK0;f7V`050;f7V`0300000033RiX0`h^J00@0`h^J00<0
00000<^@UP3;T9H00`3;T9H00`000000e9B@0=BDT004000000050=QmHP000000gW<i0=ic>@000000
D03oool007T0oooo00D0000001/0G`000000GC:40000000307a@TP030000002>HIT0SV6I00X00000
1`2UOj/010000000Xg6J0:=aVP0000060:YhV`030000002aOI`0/GfL00D0/GfL00<000000;N3W02g
Pi`01@2gPi`00`000000_HNK0;f7V`050;f7V`0300000033RiX0`h^J00@0`h^J00<000000<^@UP3;
T9H0103;T9H01P000000e9B@0=BDT03DU90000000=nJQP<0000000<0gW<i000000000000C`3oool0
07P0oooo300000080:V9/`8000001`2UOj/010000000Xg6J0:=aVP0000060:YhV`030000002aOI`0
/GfL00D0/GfL00<000000;N3W02gPi`01@2gPi`00`000000_HNK0;f7V`050;f7V`0300000033RiX0
`h^J00@0`h^J00<000000<^@UP3;T9H0103;T9H00`000000e9B@0=BDT0020=BDT0030000003OVXH0
giZ600@00000C`3oool007D0oooo100000020::4]0030000002YRK<0ZHVc00h0ZHVc0P0000070:Eo
Z`040000002SLIX0Xg6J000000H0ZWRK00<000000;5mW02aOI`01@2aOI`00`000000]h>L0;N3W005
0;N3W0030000002mQi/0_HNK00D0_HNK00<000000<>;VP33RiX01@33RiX00`000000bi2F0<^@UP03
0<^@UP030000003DU900e9B@0080e9B@00H000000=nJQP3OVXH0giZ60000003]WFd2000004h0oooo
001`0?ooo`D000001P2RQ;@00`000000ZHVc0:V9/`0>0:V9/`8000001`2UOj/00`000000Xg6J0000
00080:YhV`030000002aOI`0/GfL00D0/GfL00<000000;N3W02gPi`01@2gPi`00`000000_HNK0;f7
V`050;f7V`0300000033RiX0`h^J00@0`h^J00<000000<^@UP3;T9H0103;T9H00`000000e9B@0=BD
T0020=BDT0060000003OVXH0giZ60=nJQP000000kIe]0P00001=0?ooo`00JP3oool6000000/0XXBd
00<000000:V9/`2YRK<03P2YRK<2000000H0YGn[00@000000:=aVP2SLIX00000202ZN9/00`000000
/GfL0;5mW0050;5mW0030000002gPi`0]h>L00D0]h>L00<000000;f7V`2mQi/01@2mQi/00`000000
`h^J0<>;VP040<>;VP030000003;T9H0bi2F00@0bi2F00<000000=BDT03DU9000P3DU9001@000000
giZ60=nJQP3OVXH000000080kIe]0P00001<0?ooo`00I03oool6000000<0VWjd00<000000::4]02R
Q;@02`2RQ;@00`000000ZHVc0:V9/`0>0:V9/`8000001P2UOj/010000000Xg6J0:=aVP0000080:Yh
V`030000002aOI`0/GfL00D0/GfL00<000000;N3W02gPi`01@2gPi`00`000000_HNK0;f7V`050;f7
V`0300000033RiX0`h^J00D0`h^J00<000000<^@UP3;T9H00`3;T9H00`000000e9B@0=BDT0020=BD
T0030000003OVXH0giZ60080giZ600@000000>fMK@0000000000C03oool005l0oooo1@00000909Yn
]0030000002RQ;@0XXBd00/0XXBd00<000000:V9/`2YRK<03P2YRK<2000000H0YGn[00@000000:=a
VP2SLIX00000202ZN9/00`000000/GfL0;5mW0050;5mW0030000002gPi`0]h>L00D0]h>L00<00000
0;f7V`2mQi/01@2mQi/00`000000`h^J0<>;VP050<>;VP030000003;T9H0bi2F00<0bi2F00<00000
0=BDT03DU9000`3DU9001@000000giZ60=nJQP3OVXH000000080kIe]0P00001;0?ooo`00G03oool3
0000000308mf/`000000VWjd00/0VWjd00<000000::4]02RQ;@02`2RQ;@00`000000ZHVc0:V9/`0>
0:V9/`8000001P2UOj/010000000Xg6J0:=aVP0000080:YhV`030000002aOI`0/GfL00D0/GfL00<0
00000;N3W02gPi`01P2gPi`00`000000_HNK0;f7V`050;f7V`0300000033RiX0`h^J00@0`h^J00<0
00000<^@UP3;T9H0103;T9H00`000000e9B@0=BDT0020=BDT0050000003OVXH0giZ60=nJQP000000
0P3]WFd2000004/0oooo001H0?ooo`@00000102?M[<00`000000VWjd09Yn]00:09Yn]0030000002R
Q;@0XXBd00/0XXBd00<000000:V9/`2YRK<03P2YRK<2000000H0YGn[:@0000040<>;VP030000003;
T9H0bi2F00<0bi2F00<000000=BDT03DU9000P3DU9000`000000giZ60=nJQP020=nJQP030000003]
WFd0kIe]00800000BP3oool005H0oooo0P00000808mf/`030000002JO[@0VWjd00/0VWjd00<00000
0::4]02RQ;@02`2RQ;@00`000000ZHVc0:V9/`0=0:V9/`8000001P2UOj/010000000YgjW0:MnY`00
00080:f4Z0030000002cR:P0/hRX00D0/hRX00<000000;V=Z02iSJP01P2iSJP00`000000_Y6X0;jA
Z0050;jAZ00400000034UZL0a9JW0<BFY`H00000103;T9H00`000000e9B@0=BDT0030=BDT0050000
003OVXH0giZ60=nJQP0000000P3]WFd2000004X0oooo001D0?ooo`<000002P2?M[<00`000000VWjd
09Yn]00:09Yn]0030000002RQ;@0XXBd00/0XXBd00<000000:V9/`2YRK<03@2YRK<2000000H0YGn[
00@000000:MnY`2WOZL00000202]Q:P00`000000/hRX0;>8Z0050;>8Z0030000002iSJP0^HfX00H0
^HfX00<000000;jAZ02nTJP01@2nTJP00`000000a9JW0<BFY`050<BFY`030000003;W:H0000000<0
000000<0bi2F0000003DU9000`3DU9001@000000giZ60=nJQP3OVXH000000080kIe]0P00001:0?oo
o`00DP3oool200000080OV^c00<0000008mf/`2?M[<0202?M[<00`000000VWjd09Yn]00:09Yn]003
0000002RQ;@0XXBd00/0XXBd00<000000:V9/`2YRK<03@2YRK<2000000<0YGn[100000020:MnY`03
0000002]Q:P0[HBX00H0[HBX00<000000;>8Z02cR:P01@2cR:P00`000000^HfX0;V=Z0060;V=Z003
0000002nTJP0_Y6X00D0_Y6X00<000000<BFY`34UZL01@34UZL00`000000bibV0<^LYP030<^LYP@0
00000`3DU9001@000000giZ60=nJQP3OVXH000000080kIe]0P0000190?ooo`00D03oool2000000@0
OV^c00<0000008mf/`2?M[<0202?M[<00`000000VWjd09Yn]00:09Yn]0030000002RQ;@0XXBd00/0
XXBd00<000000:V9/`2YRK<03@2YRK<5000000<0YXRd00@000000:MnY`2WOZL00000202]Q:P00`00
0000/hRX0;>8Z0050;>8Z0030000002iSJP0^HfX00H0^HfX00<000000;jAZ02nTJP01@2nTJP00`00
0000a9JW0<BFY`050<BFY`030000003;W:H0bibV00@0bibV00<000000=BRX`3DXZ<01@0000020=nJ
QP030000003]WFd0kIe]00800000B@3oool004h0oooo0P00000707i[/`030000002?M[<0SgJc00L0
SgJc00<0000009Yn]02JO[@02P2JO[@00`000000XXBd0::4]00;0::4]0030000002YRK<0ZHVc00d0
ZHVc0P0000060:J8]0040000002WOZL0YgjW000000P0[HBX00<000000;>8Z02cR:P01@2cR:P00`00
0000^HfX0;V=Z0060;V=Z0030000002nTJP0_Y6X00D0_Y6X00<000000<BFY`34UZL01@34UZL00`00
0000bibV0<^LYP040<^LYP030000003DXZ<0e::S00<0e::S00H000000=n[WP00000000000=nJQP00
00020>fMK@800000B03oool004d0oooo0P00000807i[/`030000002?M[<0SgJc00L0SgJc00<00000
09Yn]02JO[@02P2JO[@00`000000XXBd0::4]00;0::4]0030000002YRK<0ZHVc00d0ZHVc0P000002
0:J8]0030000002VR;@0YXRd0080YXRd00<000000:MnY`000000202]Q:P00`000000/hRX0;>8Z005
0;>8Z0030000002iSJP0^HfX00H0^HfX00<000000;jAZ02nTJP01@2nTJP00`000000a9JW0<BFY`05
0<BFY`030000003;W:H0bibV00@0bibV00<000000=BRX`3DXZ<00`3DXZ<010000000gj^N0=n[WP3O
Zih200000080kIe]0P0000180?ooo`00B`3oool20000000306=H/0000000OV^c00L0OV^c00<00000
08mf/`2?M[<01`2?M[<00`000000VWjd09Yn]00:09Yn]0030000002RQ;@0XXBd00/0XXBd00<00000
0:V9/`2YRK<03P2YRK<010000000WgRV09mhYP0000060:MnY`030000002]Q:P0[HBX00H0[HBX00<0
00000;>8Z02cR:P01P2cR:P00`000000^HfX0;V=Z0050;V=Z0030000002nTJP0_Y6X00D0_Y6X00<0
00000<BFY`34UZL01@34UZL00`000000bibV0<^LYP050<^LYP030000003DXZ<0e::S0080e::S00<0
00000=n[WP3OZih00P3OZih3000000030>fMK@000000oooo04L0oooo001:0?ooo`030000001SF;00
HeR`0080HeR`00<0000007i[/`1nJk<01@1nJk<00`000000SgJc08mf/`0708mf/`030000002JO[@0
VWjd00X0VWjd00<000000::4]02RQ;@02`2RQ;@00`000000ZHVc0:V9/`0>0:V9/`040000002ON:H0
WgRV000000H0YgjW00<000000:f4Z02]Q:P01P2]Q:P00`000000/hRX0;>8Z0060;>8Z0030000002i
SJP0^HfX00D0^HfX00<000000;jAZ02nTJP01P2nTJP00`000000a9JW0<BFY`040<BFY`030000003;
W:H0bibV00D0bibV00<000000=BRX`3DXZ<00P3DXZ<00`000000gj^N0=n[WP020=n[WP030000003_
]I<0kkFC00<00000A`3oool004T0oooo00<0000006=H/01SF;000`1SF;000`000000OV^c07i[/`05
07i[/`030000002?M[<0SgJc00P0SgJc00<0000009Yn]02JO[@02@2JO[@00`000000XXBd0::4]00;
0::4]0030000002YRK<0ZHVc00h0ZHVc00@0000009mhYP2ON:H000001P2WOZL00`000000[HBX0:f4
Z0060:f4Z0030000002cR:P0/hRX00H0/hRX00<000000;V=Z02iSJP01@2iSJP00`000000_Y6X0;jA
Z0060;jAZ00300000034UZL0a9JW00D0a9JW00<000000<^LYP3;W:H0103;W:H00`000000e::S0=BR
X`030=BRX`050000003OZih0gj^N0=n[WP0000000`3_]I<2000004L0oooo00180?ooo`8000001@1S
F;000`000000OV^c07i[/`0507i[/`030000002?M[<0SgJc00P0SgJc00<0000009Yn]02JO[@02P2J
O[@00`000000XXBd0::4]00:0::4]0030000002YRK<0ZHVc00h0ZHVc00@0000009mhYP2ON:H00000
1P2WOZL00`000000[HBX0:f4Z0060:f4Z0030000002cR:P0/hRX00H0/hRX00<000000;V=Z02iSJP0
1@2iSJP00`000000_Y6X0;jAZ0060;jAZ00300000034UZL0a9JW00D0a9JW00<000000<^LYP3;W:H0
103;W:H00`000000e::S0=BRX`030=BRX`050000003OZih0gj^N0=n[WP0000000`3_]I<3000004H0
oooo00170?ooo`030000000Y;j<0000000D0HeR`00<0000007i[/`1nJk<01P1nJk<00`000000SgJc
08mf/`0708mf/`030000002JO[@0VWjd00X0VWjd00<000000::4]02RQ;@02P2RQ;@00`000000ZHVc
0:V9/`0>0:V9/`030000002ON:H0000000L0YgjW00<000000:f4Z02]Q:P01P2]Q:P00`000000/hRX
0;>8Z0060;>8Z0030000002iSJP0^HfX00D0^HfX00<000000;jAZ02nTJP01P2nTJP00`000000a9JW
0<BFY`050<BFY`030000003;W:H0bibV00@0bibV00<000000=BRX`3DXZ<00`3DXZ<00`000000gj^N
0=n[WP020=n[WP060000003_]I<0kkFC0000003n_g000000AP3oool004H0oooo00@0000002T_X`0Y
;j<000001@1SF;000`000000OV^c07i[/`0607i[/`030000002?M[<0SgJc00L0SgJc00<0000009Yn
]02JO[@02P2JO[@00`000000XXBd0::4]00:0::4]0030000002YRK<0ZHVc00h0ZHVc00<000000:J8
]00000001`2WOZL00`000000[HBX0:f4Z0060:f4Z0030000002cR:P0/hRX00H0/hRX00<000000;V=
Z02iSJP01@2iSJP00`000000_Y6X0;jAZ0060;jAZ00300000034UZL0a9JW00D0a9JW00<000000<^L
YP3;W:H0103;W:H00`000000e::S0=BRX`030=BRX`030000003OZih0gj^N0080gj^N00D000000>ne
T`3_]I<000000?joL002000004D0oooo00160?ooo`050000000Y;j<0:BnS02T_X`0000001@1SF;00
0`000000OV^c07i[/`0507i[/`030000002?M[<0SgJc00L0SgJc00<0000009Yn]02JO[@02P2JO[@0
0`000000XXBd0::4]00:0::4]0030000002YRK<0ZHVc00h0ZHVc00<0000009mhYP000000102WOZLI
000000@0^HfX00<000000;jAZ02nTJP01P2nTJP00`000000a9JW0<BFY`050<BFY`030000003;W:H0
bibV00@0bibV00<000000=BRX`3DXZ<00`3DXZ<00`000000gj^N0=n[WP020=n[WP040000003_]I<0
kkFC0>neT`<00000A@3oool004H0oooo00D0000002T_X`0Y;j<0:BnS0000000506=H/0030000001n
Jk<0OV^c00D0OV^c00<0000008mf/`2?M[<01`2?M[<00`000000VWjd09Yn]00:09Yn]0030000002R
Q;@0XXBd00X0XXBd00<000000:V9/`2YRK<03P2YRK<7000000<0Z8Na00<000000:j</@2^S;401P2^
S;400`000000]92b0;B@/P060;B@/P040000002iU;80^IBb0;VD/PT00000102nTJP00`000000a9JW
0<BFY`050<BFY`030000003;W:H0bibV00@0bibV00<000000=BRX`3DXZ<00`3DXZ<00`000000gj^N
0=n[WP020=n[WP040000003_]I<0kkFC0>neT`<00000A@3oool004H0oooo0P00000202T_X`030000
001SF;00HeR`00<0HeR`00<0000007i[/`1nJk<01@1nJk<00`000000SgJc08mf/`0808mf/`030000
002JO[@0VWjd00T0VWjd00<000000::4]02RQ;@02`2RQ;@00`000000ZHVc0:V9/`0=0:V9/`030000
002RP[40000000L0Z8Na00<000000:j</@2^S;401P2^S;400`000000]92b0;B@/P060;B@/P030000
002iU;80^IBb00D0^IBb00<000000;jI/P2nVK800P2nVK88000000@0a9JW00<000000<^LYP3;W:H0
1@3;W:H00`000000e::S0=BRX`020=BRX`030000003OZih0gj^N0080gj^N00@000000>neT`3_]I<0
kkFC0`0000150?ooo`00AP3oool200000080:BnS00<0000006=H/01SF;000`1SF;000`000000OV^c
07i[/`0507i[/`030000002?M[<0SgJc00P0SgJc00<0000009Yn]02JO[@02@2JO[@00`000000XXBd
0::4]00;0::4]0030000002YRK<0ZHVc00d0ZHVc00<000000::2/@0000001`2XQk400`000000[Xba
0:j</@060:j</@030000002dT;80]92b00H0]92b00<000000;VD/P2iU;801@2iU;800`000000_YVb
0;jI/P060;jI/P0400000034W[80a9jb0<BN/PH000001P3;W:H00`000000e::S0=BRX`020=BRX`03
0000003OZih0gj^N0080gj^N00@000000>neT`3_]I<0kkFC0`0000150?ooo`00AP3oool200000080
:BnS00<0000006=H/01SF;000`1SF;000`000000OV^c07i[/`0507i[/`030000002?M[<0SgJc00P0
SgJc00<0000009Yn]02JO[@02@2JO[@00`000000XXBd0::4]00;0::4]0030000002YRK<0ZHVc00d0
ZHVc00<000000::2/@0000001`2XQk400`000000[Xba0:j</@060:j</@030000002dT;80]92b00H0
]92b00<000000;VD/P2iU;801@2iU;800`000000_YVb0;jI/P060;jI/P0300000034W[80a9jb00D0
a9jb00<000000<ZT/P0000000`0000020<^LYP030000003DXZ<0e::S00<0e::S00D000000=n[WP3O
Zih0gj^N000000030>neT`<00000A@3oool004H0oooo0P00000202T_X`030000001SF;00HeR`00@0
HeR`00<0000007i[/`1nJk<01@1nJk<00`000000SgJc08mf/`0708mf/`030000002JO[@0VWjd00T0
VWjd00<000000::4]02RQ;@02`2RQ;@00`000000ZHVc0:V9/`0=0:V9/`030000002RP[40000000L0
Z8Na00<000000:j</@2^S;401P2^S;400`000000]92b0;B@/P060;B@/P030000002iU;80^IBb00D0
^IBb00<000000;jI/P2nVK801P2nVK800`000000a9jb0<BN/P050<BN/P030000003:Y;80bZBb00<0
bZBb100000040=BRX`050000003OZih0gj^N0=n[WP0000000`3_]I<010000000o[m`000000000014
0?ooo`00A`3oool200000080:BnS00<0000006=H/01SF;000`1SF;000`000000OV^c07i[/`0507i[
/`030000002?M[<0SgJc00L0SgJc00<0000009Yn]02JO[@02P2JO[@00`000000XXBd0::4]00:0::4
]0030000002YRK<0ZHVc00d0ZHVc00<000000::2/@0000001`2XQk400`000000[Xba0:j</@060:j<
/@030000002dT;80]92b00H0]92b00<000000;VD/P2iU;801@2iU;800`000000_YVb0;jI/P060;jI
/P0300000034W[80a9jb00D0a9jb00<000000<ZT/P3:Y;801@3:Y;800`000000dZ^a000000020000
00030=BRX`000000gj^N00<0gj^N00D000000>neT`3_]I<000000?joL002000004@0oooo00170?oo
o`8000000P0Y;j<00`000000HeR`06=H/00306=H/0030000001nJk<0OV^c00D0OV^c00<0000008mf
/`2?M[<01`2?M[<00`000000VWjd09Yn]00:09Yn]0030000002RQ;@0XXBd00X0XXBd00<000000:V9
/`2YRK<01P2YRK<8000000030::2/@000000Z8Na00H0Z8Na00<000000:j</@2^S;401P2^S;400`00
0000]92b0;B@/P060;B@/P030000002iU;80^IBb00D0^IBb00<000000;jI/P2nVK801P2nVK800`00
0000a9jb0<BN/P050<BN/P030000003:Y;80bZBb00D0bZBb00<000000=:[/@3BZk400P3BZk430000
00<0gj^N00D000000>neT`3_]I<000000?joL002000004@0oooo00170?ooo`8000000P0Y;j<00`00
0000HeR`06=H/00306=H/0030000001nJk<0OV^c00D0OV^c00<0000008mf/`2?M[<01`2?M[<00`00
0000VWjd09Yn]00:09Yn]0030000002RQ;@0XXBd00L0XXBd300000070:VA_@030000002RP[400000
00L0Z8Na00<000000:j</@2^S;401P2^S;400`000000]92b0;B@/P050;B@/P030000002iU;80^IBb
00H0^IBb00<000000;jI/P2nVK801P2nVK800`000000a9jb0<BN/P050<BN/P030000003:Y;80bZBb
00D0bZBb00<000000=:[/@3BZk400`3BZk401P000000g;F`000000000000gj^N000000<0kkFC0P00
00150?ooo`00A`3oool200000080:BnS00<0000006=H/01SF;000`1SF;000`000000OV^c07i[/`05
07i[/`030000002?M[<0SgJc00P0SgJc00<0000009Yn]02JO[@02@2JO[@010000000XXBd0::4]02R
Q;@6000000<0XXfm00<000000:VA_@2YTKd03@2YTKd010000000XX:a0::2/@0000060:R7/@030000
002^S;40[Xba00H0[Xba00<000000;B@/P2dT;801@2dT;800`000000^IBb0;VD/P060;VD/P030000
002nVK80_YVb00H0_YVb00<000000<BN/P34W[801@34W[800`000000bZBb0<ZT/P040<ZT/P030000
003BZk40dZ^a00@0dZ^a00@000000=be/03L]K00g;F`0P0000030>neT`<00000A03oool004L0oooo
0P00000202T_X`030000001SF;00HeR`00@0HeR`00<0000007i[/`1nJk<0101nJk<00`000000SgJc
08mf/`0808mf/`030000002JO[@0VWjd00L0VWjd1P0000090::=_@030000002YTKd0ZI6m00d0ZI6m
00@000000::2/@2RP[4000001P2XQk400`000000[Xba0:j</@060:j</@030000002dT;80]92b00D0
]92b00<000000;VD/P2iU;801P2iU;800`000000_YVb0;jI/P050;jI/P0300000034W[80a9jb00H0
a9jb00<000000<ZT/P3:Y;80103:Y;800`000000dZ^a0=:[/@040=:[/@030000003L]K00g;F`0080
g;F`0`000000103_]I<000000000000000140?ooo`00A`3oool01@000000001T0000000Y;j<00000
00H0HeR`00<0000007i[/`1nJk<01@1nJk<00`000000SgJc08mf/`0708mf/`040000002JO[@0VWjd
09Yn]0H000000P2KR;h00`000000XXfm0::=_@0;0::=_@030000002YTKd0ZI6m00`0ZI6m00@00000
0::2/@2RP[4000001P2XQk400`000000[Xba0:j</@060:j</@030000002dT;80]92b00D0]92b00<0
00000;VD/P2iU;801P2iU;800`000000_YVb0;jI/P050;jI/P0300000034W[80a9jb00D0a9jb00<0
00000<ZT/P3:Y;801@3:Y;800`000000dZ^a0=:[/@030=:[/@030000003L]K00g;F`00<0g;F`00<0
00000>W2[@3Y`Zd0100000140?ooo`00B03oool01@0006@0000002T_X`0Y;j<0000000D0HeR`00<0
000007i[/`1nJk<01@1nJk<00`000000SgJc08mf/`0508mf/`H00000202KR;h00`000000XXfm0::=
_@0;0::=_@030000002YTKd0ZI6m00`0ZI6m00@000000::2/@2RP[4000001P2XQk400`000000[Xba
0:j</@060:j</@030000002dT;80]92b00D0]92b00<000000;VD/P2iU;801P2iU;800`000000_YVb
0;jI/P050;jI/P0300000034W[80a9jb00D0a9jb00<000000<ZT/P3:Y;801@3:Y;800`000000dZ^a
0=:[/@030=:[/@030000003L]K00g;F`00<0g;F`00@000000>W2[@3Y`Zd0jL:]0`0000140?ooo`00
B03oool200000080:BnS00<0000006=H/01SF;000`1SF;000`000000OV^c07i[/`0507i[/`030000
002?M[<0SgJc00D000000P2AP/000`000000VhRn09^8_P0:09^8_P030000002RSKd0XXfm00X0XXfm
00<000000:VA_@2YTKd0302YTKd010000000XX:a0::2/@0000060:R7/@030000002^S;40[Xba00H0
[Xba00<000000;B@/P2dT;801@2dT;800`000000^IBb0;VD/P060;VD/P030000002nVK80_YVb00D0
_YVb00<000000<BN/P34W[801@34W[800`000000bZBb0<ZT/P050<ZT/P030000003BZk40dZ^a00<0
dZ^a00<000000=be/03L]K000P3L]K000`000000jL:]0>W2[@020>W2[@<00000A03oool004P0oooo
0P00000202T_X`030000001SF;00HeR`00<0HeR`00<0000007i[/`1nJk<0101nJk<4000000P0TH;0
00<0000009^8_P2KR;h02@2KR;h00`000000XXfm0::=_@0:0::=_@030000002YTKd0ZI6m00d0ZI6m
00<000000::2/@0000001P2XQk400`000000[Xba0:j</@060:j</@030000002dT;80]92b00D0]92b
00<000000;VD/P2iU;801P2iU;800`000000_YVb0;jI/P050;jI/P0300000034W[80a9jb00D0a9jb
00<000000<ZT/P3:Y;801@3:Y;800`000000dZ^a0=:[/@030=:[/@030000003L]K00g;F`0080g;F`
00D000000>W2[@3Y`Zd0jL:]000000020?[EX@030000003oool0oooo0480oooo00180?ooo`800000
0P0Y;j<00`000000HeR`06=H/00406=H/0040000001nJk<0OV^c07i[/`80000000<0PW[20000002A
P/002@2AP/000`000000VhRn09^8_P0909^8_P030000002RSKd0XXfm00X0XXfm00<000000:VA_@2Y
TKd03@2YTKdF000000@0]92b00<000000;VD/P2iU;801P2iU;800`000000_YVb0;jI/P050;jI/P03
00000034W[80a9jb00D0a9jb00<000000<ZT/P3:Y;801@3:Y;800`000000dZ^a0=:[/@030=:[/@03
0000003L]K00g;F`0080g;F`00D000000>W2[@3Y`Zd0jL:]000000020?[EX@030000003oool0oooo
0480oooo00180?ooo`050000000006@0000002T_X`0000001P1SF;0010000000OV^c000000000004
089j`P030000002AP/00TH;000L0TH;000<0000009^8_P2KR;h02@2KR;h00`000000XXfm0::=_@0;
0::=_@030000002YTKd0ZI6m00`0ZI6m00<000000:::^`0000001P2YSkX00`000000[Y>j0:jC^P06
0:jC^P040000002cUkX0/iNj0;>G^Pl000001P2nVK800`000000a9jb0<BN/P050<BN/P030000003:
Y;80bZBb00D0bZBb00<000000=:[/@3BZk400`3BZk400`000000g;F`0=be/0020=be/0050000003Y
`Zd0jL:]0>W2[@0000000P3jeJ400`000000oooo0?ooo`120?ooo`00B@3oool0100006@0000002T_
X`00000606=H/08000001P22N/800`000000TH;00962`0080962`0030000002KR;h0VhRn00T0VhRn
00<000000::=_@2RSKd02P2RSKd00`000000ZI6m0:VA_@0<0:VA_@030000002RR[/0000000H0ZHnj
00<000000:jC^P2^TkX01P2^TkX00`000000/iNj0;>G^P050;>G^P030000002hVkX0^9^j00H0^9^j
00<000000;fO^`0000000`0000020;jI/P0300000034W[80a9jb00D0a9jb00<000000<ZT/P3:Y;80
103:Y;800`000000dZ^a0=:[/@040=:[/@030000003L]K00g;F`0080g;F`00H000000>W2[@3Y`Zd0
jL:]0000003jeJ42000004@0oooo00190?ooo`050000I0000000:BnS02T_X`0000000`1SF;030000
00L0PW[200<000000962`02AP/00202AP/000`000000VhRn09^8_P0909^8_P030000002RSKd0XXfm
00X0XXfm00<000000:VA_@2YTKd0302YTKd00`000000XXZk000000060:V?^P030000002^TkX0[Y>j
00H0[Y>j00<000000;>G^P2cUkX01@2cUkX00`000000^9^j0;RK^P060;RK^P030000002mWk/0_Ink
00<0_Ink1P0000040<BN/P030000003:Y;80bZBb00@0bZBb00<000000=:[/@3BZk40103BZk400`00
0000g;F`0=be/0020=be/0060000003Y`Zd0jL:]0>W2[@000000n]FQ0P0000140?ooo`00B@3oool2
00000080:BnS00@0000006=H/000000000000`1ZKL<00`000000PW[2089j`P05089j`P030000002A
P/00TH;000L0TH;000<0000009^8_P2KR;h02@2KR;h00`000000XXfm0::=_@0:0::=_@030000002Y
TKd0ZI6m00`0ZI6m00@000000:::^`2RR[/000001@2YSkX00`000000[Y>j0:jC^P060:jC^P030000
002cUkX0/iNj00D0/iNj00<000000;RK^P2hVkX01@2hVkX00`000000_Ink0;fO^`060;fO^`040000
0032Y;/0`ZBk0<:T^`H000001@3:Y;800`000000dZ^a0=:[/@030=:[/@030000003L]K00g;F`00<0
g;F`00H000000>W2[@3Y`Zd0jL:]0000003jeJ42000004@0oooo00190?ooo`040000000006@0:BnS
02T_X`8000001@1ZKL<00`000000PW[2089j`P05089j`P030000002AP/00TH;000P0TH;000<00000
09^8_P2KR;h0202KR;h00`000000XXfm0::=_@0:0::=_@030000002YTKd0ZI6m00`0ZI6m00@00000
0:::^`2RR[/000001@2YSkX00`000000[Y>j0:jC^P060:jC^P030000002cUkX0/iNj00D0/iNj00<0
00000;RK^P2hVkX01@2hVkX00`000000_Ink0;fO^`050;fO^`0300000032Y;/0`ZBk00H0`ZBk00<0
00000<NZ_00000000`0000000`3:Y;8000000=:[/@040=:[/@030000003L]K00g;F`00<0g;F`00@0
00000>W2[@3Y`Zd000000P3jeJ42000004@0oooo00190?ooo`060000000006@0:BnS0000000lE<40
00001P1ZKL<00`000000PW[2089j`P05089j`P030000002AP/00TH;000L0TH;000<0000009^8_P2K
R;h02@2KR;h00`000000XXfm0::=_@090::=_@030000002YTKd0ZI6m00`0ZI6m00@000000:::^`2R
R[/000001@2YSkX00`000000[Y>j0:jC^P060:jC^P030000002cUkX0/iNj00D0/iNj00<000000;RK
^P2hVkX01@2hVkX00`000000_Ink0;fO^`050;fO^`0300000032Y;/0`ZBk00D0`ZBk00<000000<NZ
_037Z[`01037Z[`3000000@0dZ^a00<000000=be/03L]K000P3L]K001@000000jL:]0>W2[@3Y`Zd0
00000080n]FQ00<000000?ooo`3oool0@`3oool004T0oooo00<000000000I00000000P0lE<400`00
0000JVg306Y]``0406Y]``0300000022N/80PW[200D0PW[200<000000962`02AP/001`2AP/000`00
0000VhRn09^8_P0909^8_P030000002RSKd0XXfm00X0XXfm00<000000:VA_@2YTKd02`2YTKd01000
0000XXZk0:::^`0000050:V?^P030000002^TkX0[Y>j00H0[Y>j00<000000;>G^P2cUkX01@2cUkX0
0`000000^9^j0;RK^P050;RK^P030000002mWk/0_Ink00D0_Ink00<000000<:T^`32Y;/01@32Y;/0
0`000000ajZl0<NZ_0050<NZ_0030000003>/Kd000000080000000<0dZ^a0000003L]K000`3L]K00
1@000000jL:]0>W2[@3Y`Zd000000080n]FQ00<000000?ooo`3oool0@`3oool004X0oooo00<0001T
0000000000000P0lE<400`000000JVg306Y]``0306Y]``0300000022N/80PW[200D0PW[200<00000
0962`02AP/00202AP/000`000000VhRn09^8_P0809^8_P030000002RSKd0XXfm00X0XXfm00<00000
0:VA_@2YTKd02`2YTKd010000000XXZk0:::^`0000060:V?^P030000002^TkX0[Y>j00@0[Y>j00<0
00000;>G^P2cUkX01P2cUkX00`000000^9^j0;RK^P050;RK^P030000002mWk/0_Ink00D0_Ink00<0
00000<:T^`32Y;/01@32Y;/00`000000ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m00<0c[6m0`00
00030=be/0080000003Y`Zd0jL:]0>W2[@000000n]FQ0000003_efE50?ooo`00BP3oool00`000000
01FS0000000203aD`@030000001ZKL<0JVg300@0JVg300<00000089j`P22N/801@22N/800`000000
TH;00962`0070962`0030000002KR;h0VhRn00P0VhRn00<000000::=_@2RSKd02P2RSKd00`000000
ZI6m0:VA_@0;0:VA_@040000002RR[/0XXZk000000H0ZHnj00<000000:jC^P2^TkX0102^TkX00`00
0000/iNj0;>G^P050;>G^P030000002hVkX0^9^j00D0^9^j00<000000;fO^`2mWk/01@2mWk/00`00
0000`ZBk0<:T^`050<:T^`0300000037Z[`0ajZl00D0ajZl00<000000<ja_@3>/Kd0103>/Kd01P00
0000e[^o000000000000g;F`000000<0jL:]00@000000?[EX@0000000000A@3oool004X0oooo00@0
0000000EX`005J<000000P0lE<400`000000JVg306Y]``0306Y]``0300000022N/80PW[200D0PW[2
00<000000962`02AP/001`2AP/000`000000VhRn09^8_P0909^8_P030000002RSKd0XXfm00T0XXfm
00<000000:VA_@2YTKd02`2YTKd010000000XXZk0:::^`0000060:V?^P030000002^TkX0[Y>j00@0
[Y>j00<000000;>G^P2cUkX01@2cUkX00`000000^9^j0;RK^P050;RK^P030000002mWk/0_Ink00D0
_Ink00<000000<:T^`32Y;/01@32Y;/00`000000ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m00@0
c[6m00<000000=Jk_`3F^kl00P3F^kl2000000<0jL:]00@000000?[EX@0000000000A@3oool004/0
oooo00<00000000EX`0000000P0lE<400`000000JVg306Y]``0406Y]``0300000022N/80PW[200@0
PW[200<000000962`02AP/00202AP/000`000000VhRn09^8_P0809^8_P030000002RSKd0XXfm00T0
XXfm00<000000:VA_@2YTKd02`2YTKd010000000XXZk0:::^`0000060:V?^P030000002^TkX0[Y>j
00@0[Y>j00<000000;>G^P2cUkX01@2cUkX00`000000^9^j0;RK^P050;RK^P030000002mWk/0_Ink
00D0_Ink00<000000<:T^`32Y;/01@32Y;/00`000000ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m
00@0c[6m00<000000=Jk_`3F^kl00`3F^kl2000000040>W2[@000000n]FQ0?[EX@800000A@3oool0
04/0oooo00@00000000EX`005J<000000P0lE<400`000000JVg306Y]``0306Y]``0300000022N/80
PW[200D0PW[200<000000962`02AP/001`2AP/000`000000VhRn09^8_P0809^8_P030000002RSKd0
XXfm00X0XXfm00<000000:VA_@2YTKd02P2YTKd01@000000XXZk0:::^`2RR[/0000000D0ZHnj00<0
00000:jC^P2^TkX0102^TkX00`000000/iNj0;>G^P050;>G^P030000002hVkX0^9^j00D0^9^j00<0
00000;fO^`2mWk/01@2mWk/00`000000`ZBk0<:T^`040<:T^`0300000037Z[`0ajZl00D0ajZl00<0
00000<ja_@3>/Kd00`3>/Kd00`000000e[^o0=Jk_`030=Jk_`030000003QbL00hLW0008000000P3j
eJ42000004D0oooo001<0?ooo`03000000005J<000000080?5C100<0000006Y]``1ZKL<00`1ZKL<0
0`000000PW[2089j`P05089j`P030000002AP/00TH;000L0TH;000<0000009^8_P2KR;h0202KR;h0
0`000000XXfm0::=_@0:0::=_@030000002YTKd0ZI6m00/0ZI6m00@000000:::^`2RR[/000001@2Y
SkX00`000000[Y>j0:jC^P040:jC^P030000002cUkX0/iNj00D0/iNj00<000000;RK^P2hVkX01@2h
VkX00`000000_Ink0;fO^`040;fO^`0300000032Y;/0`ZBk00D0`ZBk00<000000<NZ_037Z[`01037
Z[`00`000000c[6m0<ja_@040<ja_@030000003F^kl0e[^o00<0e[^o00D000000>79`03QbL00hLW0
000000020?[EX@800000A@3oool004`0oooo00@00000000EX`005J<000000P0lE<400`000000JVg3
06Y]``0306Y]``0300000022N/80PW[200D0PW[200<000000962`02AP/001`2AP/000`000000VhRn
09^8_P0809^8_P030000002RSKd0XXfm00T0XXfm00<000000:VA_@2YTKd02`2YTKd010000000XXZk
0:::^`0000050:V?^P030000002^TkX0[Y>j00@0[Y>j00<000000;>G^P2cUkX01@2cUkX00`000000
^9^j0;RK^P050;RK^P030000002mWk/0_Ink00@0_Ink00<000000<:T^`32Y;/01@32Y;/00`000000
ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m00@0c[6m00<000000=Jk_`3F^kl00P3F^kl00`000000
hLW00>79`0020>79`080000000<0n]FQ0>oGI@3oool0A@3oool004d0oooo00<00000000EX`000000
0P0lE<400`000000JVg306Y]``0306Y]``0300000022N/80PW[200D0PW[200<000000962`02AP/00
1`2AP/000`000000VhRn09^8_P0809^8_P030000002RSKd0XXfm00T0XXfm00<000000:VA_@2YTKd0
2`2YTKdD000000@0/iNj00<000000;RK^P2hVkX0102hVkX00`000000_Ink0;fO^`050;fO^`030000
0032Y;/0`ZBk00D0`ZBk00<000000<NZ_037Z[`01037Z[`00`000000c[6m0<ja_@030<ja_@030000
003F^kl0e[^o00<0e[^o00T000000>79`03QbL00hLW00000003^g;l000000?[EX@3_efD0AP3oool0
04d0oooo00@00000000EX`005J<000000P0lE<400`000000JVg306Y]``0206Y]``0300000022N/80
PW[200D0PW[200<000000962`02AP/001`2AP/000`000000VhRn09^8_P0809^8_P030000002RSKd0
XXfm00T0XXfm00<000000:VA_@2YTKd02`2YTKd010000000XI;50:6Ba@0000050:NFa0030000002/
VL<0[9W300@0[9W300@000000;6L``2aW<<0/Ic3200000030;RK^P030000002mWk/0_Ink00D0_Ink
00<000000<:T^`32Y;/01032Y;/00`000000ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m00@0c[6m
00<000000=Jk_`3F^kl00`3F^kl01@000000hLW00>79`03QbL0000000080k]bo00<000000>oGI@3o
ool0A@3oool004h0oooo00<00000000EX`0000000P0lE<400`000000JVg306Y]``0306Y]``030000
0022N/80PW[200D0PW[200<000000962`02AP/001`2AP/000`000000VhRn09^8_P0709^8_P030000
002RSKd0XXfm00X0XXfm00<000000:VA_@2YTKd02P2YTKd010000000XI;50:6Ba@0000050:NFa003
0000002/VL<0[9W300@0[9W300<000000;6L``2aW<<01@2aW<<010000000]Z330;JP``2fX<<50000
00D0_Ink00<000000<:T^`32Y;/01@32Y;/00`000000ajZl0<NZ_0040<NZ_0030000003>/Kd0c[6m
00@0c[6m00<000000=Jk_`3F^kl00P3F^kl01@000000hLW00>79`03QbL0000000080k]bo0P000000
0`3_efD0oooo0?ooo`140?ooo`00CP3oool01000000001FS000EX`00000203aD`@030000001ZKL<0
JVg30080JVg300<00000089j`P22N/801@22N/800`000000TH;00962`0070962`0030000002KR;h0
VhRn00P0VhRn00<000000::=_@2RSKd02@2RSKd00`000000ZI6m0:VA_@0:0:VA_@040000002QT/D0
XI;5000000D0YiK400<000000:bI``2/VL<0102/VL<00`000000/Ic30;6L``050;6L``030000002f
X<<0]Z3300@0]Z3300<000000;ZT``0000000`0000000`2mWk/000000<:T^`060<:T^`0300000037
Z[`0ajZl00<0ajZl00<000000<ja_@3>/Kd0103>/Kd00`000000e[^o0=Jk_`030=Jk_`050000003Q
bL00hLW00>79`00000000P3^g;l00`000000m?>_000000160?ooo`00C`3oool00`00000001FS0000
000203aD`@030000001ZKL<0JVg300<0JVg300<00000089j`P22N/801022N/800`000000TH;00962
`0070962`0030000002KR;h0VhRn00P0VhRn00<000000::=_@2RSKd0102RSKdC000000<0XI;500<0
00000:NFa02WU/@00P2WU/@00`000000[9W30:bI``040:bI``030000002aW<<0/Ic300@0/Ic300<0
00000;JP``2fX<<0102fX<<00`000000^ZC30;ZT``040;ZT``D000000`32Y;/00`000000ajZl0<NZ
_0040<NZ_0030000003>/Kd0c[6m00@0c[6m00<000000=Jk_`3F^kl00P3F^kl01@000000hLW00>79
`03QbL0000000080k]bo00<000000?Cc[`000000A`3oool004l0oooo00@00000000EX`005J<00000
0P0lE<400`000000JVg306Y]``0206Y]``0300000022N/80PW[200D0PW[200<000000962`02AP/00
1`2AP/000`000000VhRn09^8_P0309^8_P/000001@2QULP00`000000YiS70:NHa`0:0:NHa`050000
002QT/D0XI;50:6Ba@000000102WU/@00`000000[9W30:bI``040:bI``030000002aW<<0/Ic300@0
/Ic300<000000;JP``2fX<<0102fX<<00`000000^ZC30;ZT``050;ZT``040000002nZL@0_ZW40;jY
a0D000001@37Z[`00`000000c[6m0<ja_@030<ja_@030000003F^kl0e[^o00<0e[^o00D000000>79
`03QbL00hLW0000000020>kL_`030000003dljl0000004L0oooo001@0?ooo`03000000005J<00000
0080?5C100<0000006Y]``1ZKL<00P1ZKL<00`000000PW[2089j`P05089j`P030000002AP/00TH;0
00D0TH;02000000409VBbP030000002QULP0XIG800X0XIG800<000000:NHa`2WV<L02@2WV<L01@00
0000XI;50:6Ba@2QT/D0000000@0YiK400<000000:bI``2/VL<0102/VL<00`000000/Ic30;6L``04
0;6L``030000002fX<<0]Z3300@0]Z3300<000000;ZT``2jY<<0102jY<<00`000000_ZW40;jYa005
0;jYa00300000033[lH000000080000000<0ajZl0000003>/Kd01@3>/Kd00`000000e[^o0=Jk_`02
0=Jk_`050000003QbL00hLW00>79`00000000P3^g;l00`000000m?>_000000180?ooo`00D@3oool0
0`00000001FS0000000203aD`@030000001ZKL<0JVg30080JVg300<00000089j`P22N/801@22N/80
0`000000TH;00962`004000000<0Shk=00<0000009VBbP2IT/X01`2IT/X00`000000XIG80:6Eb009
0:6Eb0030000002WV<L0YiS700T0YiS700D000000:6Ba@2QT/D0XI;5000000040:NFa0030000002/
VL<0[9W300@0[9W300<000000;6L``2aW<<0102aW<<00`000000]Z330;JP``040;JP``030000002j
Y<<0^ZC300@0^ZC300<000000;jYa02nZL@0102nZL@00`000000`jo60<>_aP030<>_aP<000001@3>
/Kd00`000000e[^o0=Jk_`020=Jk_`050000003QbL00hLW00>79`00000000P3^g;l00`000000m?>_
000000180?ooo`00D@3oool00`00000001FS0000000203aD`@030000001ZKL<0JVg30080JVg300<0
0000089j`P22N/801022N/84000000L0Shk=00<0000009VBbP2IT/X01`2IT/X00`000000XIG80:6E
b0090:6Eb0030000002WV<L0YiS700X0YiS700@000000:6Ba@2QT/D000001@2WU/@00`000000[9W3
0:bI``030:bI``030000002aW<<0/Ic300@0/Ic300<000000;JP``2fX<<00`2fX<<00`000000^ZC3
0;ZT``040;ZT``030000002nZL@0_ZW400D0_ZW400<000000<>_aP33[lH00`33[lH00`000000bKK8
0<Vfb003000000030<ja_@000000e[^o00@0e[^o00T000000>79`03QbL00hLW00000003^g;l00000
0?Cc[`000000B@3oool00580oooo00<00000000EX`0000000P0lE<400`000000JVg306Y]``0206Y]
``80PW[2100000020868d@030000002?S/d0Shk=00L0Shk=00<0000009VBbP2IT/X01`2IT/X00`00
0000XIG80:6Eb0080:6Eb0030000002WV<L0YiS700X0YiS700@000000:6Ba@2QT/D000001@2WU/@0
0`000000[9W30:bI``030:bI``030000002aW<<0/Ic300<0/Ic300<000000;JP``2fX<<0102fX<<0
0`000000^ZC30;ZT``040;ZT``030000002nZL@0_ZW400@0_ZW400<000000<>_aP33[lH01033[lH0
0`000000bKK80<Vfb0030<Vfb0800000103F^kl01@000000hLW00>79`03QbL0000000080k]bo00<0
00000?Cc[`000000B@3oool00580oooo00<00000000EX`0000000P0lE<4010000000JVg306Y]``1Z
KL<3000000H0PHSA00<0000008n>c@2?S/d01`2?S/d00`000000VI;:09VBbP0709VBbP030000002Q
ULP0XIG800T0XIG800<000000:NHa`2WV<L02@2WV<L01@000000XI;50:6Ba@2QT/D0000000@0YiK4
00<000000:bI``2/VL<00`2/VL<00`000000/Ic30;6L``030;6L``030000002fX<<0]Z3300@0]Z33
00<000000;ZT``2jY<<00`2jY<<00`000000_ZW40;jYa0050;jYa00300000033[lH0`jo600<0`jo6
00<000000<Vfb039]/P01039]/P00`000000ckk;000000030=Jk_`090000003QbL00hLW00>79`000
0000k]bo0000003dljl0000004X0oooo001C0?ooo`03000000005J<000000080?5C10`00000206Yo
eP0300000021R=40PHSA00D0PHSA00<0000008n>c@2?S/d01`2?S/d00`000000VI;:09VBbP0609VB
bP030000002QULP0XIG800T0XIG800<000000:NHa`2WV<L02@2WV<L01@000000XI;50:6Ba@2QT/D0
000000@0YiK400<000000:bI``2/VL<00`2/VL<00`000000/Ic30;6L``030;6L``030000002fX<<0
]Z3300@0]Z3300<000000;ZT``2jY<<00`2jY<<00`000000_ZW40;jYa0040;jYa00300000033[lH0
`jo600@0`jo600<000000<Vfb039]/P01039]/P00`000000ckk;0<nnb`02000000050=Jk_`3QbL00
hLW00>79`00000000P3^g;l00`000000m?>_0000001:0?ooo`00D`3oool01`00000001FS0000000l
E<400000041^f0000000101ZOmH00`000000PHSA0868d@050868d@030000002?S/d0Shk=00H0Shk=
00<0000009VBbP2IT/X01`2IT/X00`000000XIG80:6Eb0080:6Eb0030000002WV<L0YiS700T0YiS7
00D000000:6Ba@2QT/D0XI;5000000040:NFa0030000002/VL<0[9W300<0[9W300<000000;6L``2a
W<<00`2aW<<00`000000]Z330;JP``030;JP``030000002jY<<0^ZC300@0^ZC300<000000;jYa02n
ZL@0102nZL@00`000000`jo60<>_aP030<>_aP0300000039]/P0bKK800@0bKK800<000000<nnb`3?
_//00`3?_//02@000000hLW00>79`03QbL0000000>kL_`000000m?>_0000001;0?ooo`00E03oool0
0`00000001FS00000003041^f0050000001ZOmH0JWoF06YoeP0000001`21R=400`000000Shk=08n>
c@0708n>c@030000002IT/X0VI;:00H0VI;:00<000000:6Eb02QULP0202QULP00`000000YiS70:NH
a`090:NHa`L000000P2WU/@00`000000[9W30:bI``030:bI``030000002aW<<0/Ic300<0/Ic300<0
00000;JP``2fX<<00`2fX<<00`000000^ZC30;ZT``030;ZT``030000002nZL@0_ZW400@0_ZW400<0
00000<>_aP33[lH00`33[lH00`000000bKK80<Vfb0040<Vfb0030000003?_//0ckk;00<0ckk;00D0
00000=K:cP00000000000>79`0020>kL_`030000003dljl0000004/0oooo001D0?ooo`80000000D0
04?500000010K]P0@6kH0000000406YoeP0300000021R=40PHSA00D0PHSA00<0000008n>c@2?S/d0
1P2?S/d00`000000VI;:09VBbP0709VBbP030000002QULP0XIG800P0XIG800<000000:NHa`2WV<L0
202WV<L01@000000VYWB09ZIdP2JVM8000000080XIc?1@0000030:bI``030000002aW<<0/Ic30080
/Ic300<000000;JP``2fX<<0102fX<<00`000000^ZC30;ZT``030;ZT``030000002nZL@0_ZW400@0
_ZW400<000000<>_aP33[lH00`33[lH00`000000bKK80<Vfb0030<Vfb0030000003?_//0ckk;00<0
ckk;00<000000=K:cP3Fb/h00P3Fb/h01@000000k]bo0000003dljl0000004`0oooo001E0?ooo`04
00000000@lD004?500000080@6kH00<0000006YoeP1ZOmH00P1ZOmH00`000000PHSA0868d@050868
d@030000002?S/d0Shk=00H0Shk=00<0000009VBbP2IT/X01P2IT/X00`000000XIG80:6Eb0080:6E
b0030000002WV<L0YiS700P0YiS70P00000309ZIdP050000002QW<l0XIc?0:6Lc`0000000P2WWlh6
00000080/Ic300<000000;JP``2fX<<0102fX<<00`000000^ZC30;ZT``020;ZT``030000002nZL@0
_ZW400@0_ZW400<000000<>_aP33[lH00`33[lH00`000000bKK80<Vfb0040<Vfb0030000003?_//0
ckk;00<0ckk;00@000000=K:cP3Fb/h0e/[>0P000000103^g;l000000?Cc[`00001<0?ooo`00EP3o
ool01000000004?50013a@000002041^f0030000001ZOmH0JWoF0080JWoF00<000000868d@21R=40
1021R=400`000000Shk=08n>c@0608n>c@030000002IT/X0VI;:00H0VI;:00<000000:6Eb02QULP0
202QULP00`000000YiS70:NHa`090:NHa`050000002JVM80VYWB09ZIdP0000000`2QW<l00`000000
Yio>0:NOcP030:NOcP030000002/X/d0[:;=00D000000`2fX<<00`000000^ZC30;ZT``030;ZT``03
0000002nZL@0_ZW400@0_ZW400<000000<>_aP33[lH00`33[lH00`000000bKK80<Vfb0030<Vfb003
0000003?_//0ckk;00<0ckk;00D000000=K:cP3Fb/h0e/[>000000020=kJdP040000003dljl0m?>_
000004`0oooo001G0?ooo`0400000000@lD004?500000080@6kH00<0000006YoeP1ZOmH00P1ZOmH0
0`000000PHSA0868d@040868d@030000002?S/d0Shk=00H0Shk=00<0000009VBbP2IT/X01P2IT/X0
0`000000XIG80:6Eb0070:6Eb0030000002WV<L0YiS700T0YiS70P00000209ZIdP050000002QW<l0
XIc?0:6Lc`0000001@2WWlh00`000000[:;=0:bRc@020:bRc@030000002`YLd0/:G=00H000000P2j
Y<<00`000000_ZW40;jYa0040;jYa00300000033[lH0`jo600<0`jo600<000000<Vfb039]/P00`39
]/P00`000000ckk;0<nnb`030<nnb`050000003Fb/h0e/[>0=K:cP0000000`3Nf]800`000000m?>_
0000001=0?ooo`00F03oool00`00000004?500000003041^f0050000001ZOmH0JWoF06YoeP000000
1P21R=400`000000Shk=08n>c@0608n>c@030000002IT/X0VI;:00H0VI;:00<000000:6Eb02QULP0
202QULP00`000000YiS70:NHa`080:NHa`8000000`2JVM801@000000XIc?0:6Lc`2QW<l0000000@0
Yio>00D000000:bRc@2/X/d0[:;=000000060;2Uc@030000002dZ<d0]:S=00@000001@2nZL@00`00
0000`jo60<>_aP020<>_aP0300000039]/P0bKK800<0bKK800<000000<nnb`3?_//00`3?_//00`00
0000e/[>0=K:cP020=K:cP030000003Nf]80g][B0080000000<0m?>_0000003oool0C03oool005T0
oooo00<000000013a@0000000P10K]P00`000000JWoF06YoeP0206YoeP0300000021R=40PHSA00@0
PHSA00<0000008n>c@2?S/d01P2?S/d00`000000VI;:09VBbP0609VBbP030000002QULP0XIG800L0
XIG800<000000:NHa`2WV<L0202WV<L00`000000TYOE0000000209ZIdP050000002QW<l0XIc?0:6L
c`000000102WWlh01@000000[:;=0:bRc@2/X/d0000000D0/:G=00<000000;BXc@2dZ<d00P2dZ<d0
0`000000^:g>0;R]cP03000000030;jYa0000000`jo600@0`jo600<000000<Vfb039]/P00`39]/P0
0`000000ckk;0<nnb`020<nnb`030000003Fb/h0e/[>0080e/[>00@000000=kJdP3Nf]8000000P3U
l=D00`000000oooo0?ooo`1<0?ooo`00FP3oool00`00000004?500000002041^f0030000001ZOmH0
JWoF0080JWoF00<000000868d@21R=401021R=400`000000Shk=08n>c@0508n>c@030000002IT/X0
VI;:00H0VI;:00<000000:6Eb02QULP01`2QULP00`000000YiS70:NHa`080:NHa`030000002BUmD0
00000080VYWB00D000000:6Lc`2QW<l0XIc?000000040:NOcP050000002/X/d0[:;=0:bRc@000000
1@2`YLd00`000000]:S=0;BXc@020;BXc@030000002h[Lh0^:g>00<0^:g>0P0000040<>_aP030000
0039]/P0bKK800<0bKK800<000000<nnb`3?_//00`3?_//01@000000e/[>0=K:cP3Fb/h000000080
g][B00<000000>G`e@3Ul=D00P00001>0?ooo`00F`3oool00`00000004?500000002041^f0030000
001ZOmH0JWoF0080JWoF00<000000868d@21R=400`21R=400`000000Shk=08n>c@0608n>c@030000
002IT/X0VI;:00H0VI;:00<000000:6Eb02QULP01P2QULP00`000000YiS70:NHa`080:NHa`800000
00D0TYOE0000002JVM80VYWB000000020:6Lc`050000002WWlh0Yio>0:NOcP000000102/X/d00`00
0000/:G=0;2Uc@020;2Uc@030000002dZ<d0]:S=0080]:S=00<000000;R]cP2h[Lh0102h[Lh01000
0000_;7?0000000000020<>_aP0300000039]/P0bKK80080bKK800<000000<nnb`3?_//00`3?_//0
1@000000e/[>0=K:cP3Fb/h0000000<0g][B00@000000>G`e@0000000000C`3oool005`0oooo00<0
00000013a@0000000P10K]P01@000000JWoF06YoeP1ZOmH0000000H0PHSA00<0000008n>c@2?S/d0
1@2?S/d00`000000VI;:09VBbP0609VBbP030000002QULP0XIG800L0XIG800<000000:NHa`2WV<L0
1`2WV<L20000000509:Ge@000000VYWB09ZIdP0000000P2QW<l01@000000Yio>0:NOcP2WWlh00000
00<0[:;=00<000000;2Uc@2`YLd00`2`YLd00`000000]:S=0;BXc@020;BXc@030000002h[Lh0^:g>
00<0^:g>00<000000;bac`2l/Ll00P2l/Ll2000000@0bKK800<000000<nnb`3?_//00`3?_//01@00
0000e/[>0=K:cP3Fb/h0000000<0g][B00D000000>G`e@000000e_k20000001?0?ooo`00G@3oool0
1@00000004?500000010K]P0000000@0JWoF00<000000868d@21R=401021R=400`000000Shk=08n>
c@0508n>c@030000002IT/X0VI;:00D0VI;:00<000000:6Eb02QULP01`2QULP00`000000YiS70:NH
a`070:NHa`<0000000@0TYOE0000002JVM8000000P2QW<l01@000000Yio>0:NOcP2WWlh0000000<0
[:;=00<000000;2Uc@2`YLd00P2`YLd00`000000]:S=0;BXc@020;BXc@030000002h[Lh0^:g>00<0
^:g>00<000000;bac`2l/Ll00`2l/Ll010000000`;OA0000000000020<Vfb0030000003?_//0ckk;
0080ckk;00D000000=K:cP3Fb/h0e/[>000000030=kJdP030000003Ul=D0iO3E00800000D03oool0
05h0oooo00D000000013a@000000@6kH0000000406YoeP0300000021R=40PHSA00<0PHSA00<00000
08n>c@2?S/d01@2?S/d00`000000VI;:09VBbP0609VBbP030000002QULP0XIG800H0XIG800<00000
0:NHa`2WV<L0202WV<L50000000509ZIdP000000XIc?0:6Lc`0000000P2WWlh01@000000[:;=0:bR
c@2/X/d0000000@0/:G=00<000000;BXc@2dZ<d00P2dZ<d00`000000^:g>0;R]cP030;R]cP030000
002l/Ll0_;7?0080_;7?00<000000<2gd@30]m400P30]m42000000D0ckk;00@000000=K:cP3Fb/h0
00000`3Nf]800`000000iO3E0>G`e@0200000540oooo001O0?ooo`0500000000@lD00000041^f000
0000101ZOmH00`000000PHSA0868d@030868d@030000002?S/d0Shk=00D0Shk=00<0000009VBbP2I
T/X01@2IT/X00`000000XIG80:6Eb0060:6Eb0030000002WV<L0YiS700P0YiS700D000000:aZQP2/
JXH0000007bKi@03000000050:6Lc`000000Yio>0:NOcP0000000`2/X/d00`000000/:G=0;2Uc@02
0;2Uc@050000002dZ<d0]:S=0;BXc@0000001@2h[Lh00`000000_;7?0;bac`020;bac`0300000030
]m40`;OA00<0`;OA00@000000<Bme000000000000P3?_//01@000000e/[>0=K:cP3Fb/h000000080
g][B00<000000>G`e@3Ul=D00P00001B0?ooo`00H03oool200000080@6kH00<0000006YoeP1ZOmH0
0P1ZOmH00`000000PHSA0868d@030868d@030000002?S/d0Shk=00@0Shk=00<0000009VBbP2IT/X0
1P2IT/X00`000000XIG80:6Eb0060:6Eb0030000002WV<L0YiS700L0YiS700P000000:aZQP2/JXH0
[6Z60000001lVnD0000008ZNh0<0000000D0Yio>0000002/X/d0[:;=000000040;2Uc@030000002d
Z<d0]:S=0080]:S=00<000000;R]cP2h[Lh00P2h[Lh00`000000_;7?0;bac`020;bac`0300000030
]m40`;OA00<0`;OA00<000000<Bme034_M@00P34_M@2000000<0e/[>00@000000=kJdP3Nf]800000
0P3Ul=D2000005<0oooo001Q0?ooo`8000000P10K]P01@000000JWoF06YoeP1ZOmH0000000D0PHSA
00<0000008n>c@2?S/d00P2?S/dO000000@0[6Z600H0000007bKi@000000RYkP0000002DX=`30000
00030:bRc@000000/:G=00<0/:G=00D000000;BXc@2dZ<d0]:S=000000040;R]cP030000002l/Ll0
_;7?0080_;7?00<000000<2gd@30]m400P30]m42000000@0a;gD0P0000001038a]L000000=K:cP00
00020=kJdP030000003Ul=D0iO3E00800000E03oool00680oooo0P0000000`10K]P0000006YoeP03
06YoeP0400000021R=40PHSA0868d@H000001024VMl00`000000TIcJ096LfP05096LfP030000002J
W]L0VYkG00D0VYkG00<000000:6Pe02QX=@01`2QX=@00`000000[6Z60:aZQP030:aZQP80000000@0
RYkP0000002DX=`0U:3L0P2LX]T300000080/:G=00<000000;BXc@2dZ<d00P2dZ<d01@000000^:g>
0;R]cP2h[Lh0000000@0_;7?00<000000<2gd@30]m400P30]m400`000000a;gD0<Bme0030<Bme003
00000038a]L0b<KG0080b<KG00H000000=kJdP3Nf]80g][B0000003Ul=D2000005D0oooo001S0?oo
o`80000000<0@6kH0000001ZOmH00P1ZOmH4000000<0LYGU00<0000008BIg`24VMl01@24VMl00`00
0000TIcJ096LfP04096LfP030000002JW]L0VYkG00H0VYkG00<000000:6Pe02QX=@01P2QX=@00`00
0000[6Z60:aZQP040:aZQP0307bKi@000000RYkP0080U:3L0`2LX]T20::Te`<000000`2dZ<d01@00
0000^:g>0;R]cP2h[Lh0000000@0_;7?00<000000<2gd@30]m400P30]m400`000000a;gD0<Bme003
0<Bme00400000038a]L0b<KG0<S6e`<000000P3Nf]801@000000iO3E0000003Fo/80000005D0oooo
001T0?ooo`H000000P1DSNX00`000000LYGU07:Ei@0307:Ei@0300000024VMl0Q9WO00@0Q9WO00<0
0000096LfP2AW=X01@2AW=X00`000000VYkG09ZNe`0509ZNe`030000002QX=@0XJ3D00L0XJ3D00<0
00000:aZQP2/JXH0102/JXH010000000RYkP09BPg02DX=`209bRf@060000002RY=L0XZCG0::Te`00
0000YjOF0P0000000`2dZ<d000000;R]cP020;R]cP050000002l/Ll0_;7?0;bac`0000001030]m40
0`000000a;gD0<Bme0020<Bme08000000`38a]L010000000cM7L0<gAg03=dM`200000080iO3E0P00
001F0?ooo`00I03oool00`2C4P00000000000003000000<0E8gZ0P00000407:Ei@0300000024VMl0
Q9WO00@0Q9WO00<00000096LfP2AW=X0102AW=X00`000000VYkG09ZNe`0609ZNe`030000002QX=@0
XJ3D00H0XJ3D00<000000:aZQP2/JXH0102/JXH400000080W:;I00@000000::Te`2RY=L00000102W
YmH200000080^:g>00D000000;bac`2l/Ll0_;7?000000040<2gd@0300000034_M@0a;gD0080a;gD
00@000000<S6e`38a]L0b<KG0P0000040<gAg0030000003Ul=D0iO3E00800000E`3oool006H0oooo
0`0000000`0NN^D0000005B=jP0305B=jP030000001bUND0LYGU0080LYGU00<0000008BIg`24VMl0
1024VMl00`000000TIcJ096LfP04096LfP030000002JW]L0VYkG00D0VYkG00<000000:6Pe02QX=@0
1P2QX=@00`000000[6Z60:aZQP040:aZQP@0000000<0W:;I0000002RY=L00P2RY=L010000000YjOF
0:NWeP2WYmH30:bYe@8000000`2l/Ll010000000`;OA0<2gd@30]m42000000@0a;gD00D000000<S6
e`38a]L0b<KG000000040<gAg0<0000000<0iO3E000000000000F03oool006L0oooo1@00000405B=
jP030000001bUND0LYGU0080LYGU00<0000008BIg`24VMl01024VMl00`000000TIcJ096LfP04096L
fP030000002JW]L0VYkG00@0VYkG00<000000:6Pe02QX=@01P2QX=@010000000[6Z60:aZQP2/JXH7
0000000509bRf@000000XZCG0::Te`0000000`2WYmH30:bYe@80000000@0[jcE0000002l/Ll00000
0`30]m400`000000a;gD0<Bme0020<Bme08000000`38a]L00`000000cM7L0<gAg0020<gAg0040000
003Ag^80dMkR0=7NhP800000F@3oool006T0oooo1@00000305B=jP030000001bUND0LYGU0080LYGU
00<0000008BIg`24VMl01024VMl00`000000TIcJ096LfP03096LfP030000002JW]L0VYkG00D0VYkG
00<000000:6Pe02QX=@01P2QX=@3000000<0Ud1L00P0000008/bD`2;<U<0000009bRf@000000XZCG
000000<0YjOF0`2/ZMD00`000000[jcE0:n/e@020:n/e@8000000P30]m400`000000a;gD0<Bme002
0<Bme00400000038a]L0b<KG0<S6e`8000000`3=dM`200000080dMkR0`00001J0?ooo`00J`3oool4
000000<0E8gZ00<0000007:Ei@1bUND00P1bUND00`000000Q9WO08BIg`0308BIg`030000002AW=X0
TIcJ00@0TIcJ00<0000009ZNe`2JW]L0102JW]L00`000000XJ3D0:6Pe0060:6Pe0030000002G@5`0
Ud1L00<0Ud1L00<0000008/bD`2;<U<00P0000001@2RY=L000000:NWeP2WYmH000000080[:WE0P00
00030:n/e@8000000P2c/=D2000000@0a;gD00D000000<S6e`38a]L0b<KG000000030<gAg0800000
0P3Ag^82000000030=7_j0000000oooo05X0oooo001/0?ooo`@000000`1DSNX2000000<0LYGU00<0
000008BIg`24VMl00`24VMl00`000000TIcJ096LfP04096LfP030000002JW]L0VYkG00@0VYkG00<0
00000:6Pe02QX=@01@2QX=@00`000000Ud1L09M0G00409M0G0080000002;<U<0BeJl0000002RY=L0
00000:NWeP0000020:bYe@040000002_[=D0[jcE0:n/e@8000000`2c/=D2000000030;JdeP000000
a;gD008000000P38a]L2000000<0cM7L00H000000=7NhP3Ag^80dMkR0000003AknP2000005`0oooo
001^0?ooo`@000000`1DSNX01@000000LYGU07:Ei@1bUND0000000D0Q9WO00<00000096LfP2AW=X0
0`2AW=X00`000000VYkG09ZNe`0409ZNe`030000002QX=@0XJ3D00D0XJ3D0P00000509M0G0030000
001;E[`0LFfo0080000000<0YjOF0000002/ZMD00P0000020:n/e@8000000`2c/=D2000000<0][CF
0P0000030<S6e`040000003=dM`0cM7L0<gAg08000000P3Ag^82000000030=7_j0000000000005d0
oooo001_0?ooo`@000000`1DSNX01@000000LYGU07:Ei@1bUND0000000D0Q9WO00<00000096LfP2A
W=X00`2AW=X00`000000VYkG09ZNe`0409ZNe`030000002QX=@0XJ3D00D0XJ3D00@0000009M0G02G
@5`0Ud1L0`000002075]_`050000002WYmH000000:bYe@0000000P2_[=D2000000<0/k3E0P000003
0;JdeP80000000<0^[SH00000038a]L00P0000030<gAg0030000003Ag^80dMkR0080000000@0dNoX
0000000000000000GP3oool00740oooo1000000205B=jP050000001bUND0LYGU07:Ei@0000001@24
VMl00`000000TIcJ096LfP02096LfP030000002JW]L0VYkG00@0VYkG00<000000:6Pe02QX=@01@2Q
X=@400000080=P0000<0LFfo08Ii_P26NKh0100000000`2_[=D00000000000030;>`e@8000000P2f
]=H3000000<0^[SH0P0000030<gAg080000000@0dMkR000000000000dNoX1000001O0?ooo`00L`3o
ool300000080E8gZ00D0000007:Ei@1bUND0LYGU0000000508BIg`030000002AW=X0TIcJ0080TIcJ
00<0000009ZNe`2JW]L00`2JW]L00`000000XJ3D0:6Pe0050:6Pe0030000001Q02H0H@0V00800000
00@0QWVn0000002CPKd0Th6m0P0000000`2_[=D00000000000030;>`e@8000000P2f]=H2000000@0
^[SH0P0000001@2m_]X000000<gAg03=dM`000000080dMkR00<000000=7_j03AknP01000001P0?oo
o`00M03oool300000080E8gZ0P00000207:Ei@0300000024VMl0Q9WO0080Q9WO00<00000096LfP2A
W=X00`2AW=X00`000000VYkG09ZNe`0309ZNe`030000002QX=@0XJ3D00@0XJ3D100000000`2CPKd0
00000000000209b7_0<000000`2c/=D200000080][CF0P0000030;Zhf0<000000`2m_]X200000080
dMkR0P0000000`3AknP000000000000300000640oooo001f0?ooo`8000000`1DSNX010000000LYGU
07:Ei@00000408BIg`030000002AW=X0TIcJ0080TIcJ00<0000009ZNe`2JW]L00`2JW]L00`000000
XJ3D0:6Pe0050:6Pe080000000@0W8Nl0000000000000000102SS;`01@000000/k3E000000000000
][CF00<000000`2j^=P2000000<0_KkJ0`000000102oa=h000000=7NhP0000020=7_j00400000033
oN@00000000006<0oooo001h0?oooa@000000`2JW]L00`000000XJ3D0:6Pe0040:6Pe08000001@2S
S;`5000000030;JdeP000000000000<0^[SH0`0000020;fnfP<000000`2oa=h200000080dNoX1@00
001T0?ooo`00NP3oool6000000030015Z0000000000000801WSP0P00000304:@k`030000001VV^h0
000000d000000`2YT;/600000080^[SH0`0000000`2m_]X000000000000200000080_lCN10000000
1@32c>8000000=7_j0000000`ogT00800000IP3oool007d0oooo1@0000000`00AJP0000000000002
00Ihh00500000012T>l0@Y3_04:@k`000000101VV^h00`000000O9kX07bNj00307bNj0D000001P2^
U;/01@000000^[SH000000000000_KkJ00<000000P2oa=h4000000@0`/cR0P0000001033oN@00000
00000000001W0?ooo`00P@3oool3000000040015Z0000000000000Ihh08000000P12T>l00`000000
IY[^06JJkP0206JJkP030000001lW^P0O9kX00<0O9kX30000000102m_]X000000000002oa=h40000
00@0`/cR1@0000000`33oN@000000000001Y0?ooo`00P`3oool60000000500Ihh0000000@Y3_04:@
k`0000000`1VV^h00`000000O9kX07bNj00307bNj0`0000000@0_lCN00000000000000001032c>84
00000080a=KW1000001[0?ooo`00QP3oool70000000304:@k`00000000000080IY[^00<0000007bN
j01lW^P00P1lW^P<000000@0`/cR100000020<CFi`@0000000<0a>7]000000000000K03oool008T0
oooo1P0000001@12T>l0000006JJkP1VV^h0000000@0O9kX00<000000;bP_02lX;`01P2lX;`00`00
0000`/cR0<;<hP03000000030<CFi`000000000000<000000P34hNd3000006h0oooo002;0?ooo`D0
000000D0@Y3_0000001VV^h0IY[^0000000307bNj0/000000P34e^L300000080a>7]1`00001_0?oo
o`00S@3oool40000000504:@k`000000IY[^06JJkP0000000`1lW^P;000000030<CQk@0000000000
00<0000000<0_ngb0000000000000P00001a0?ooo`00T@3oool30000000306JJkP000000O9kX0080
O9kX00<000000<ba_`3</Kl01@3</Kl3000000<0_ngb0`000000102`mO80000000000000001b0?oo
o`00T`3oool400000080O9kX1@0000020<ba_`040000002okO80_ngb0;o]lP80000000<0/?Gb0000
000000000`00001d0?ooo`00UP3oool30000000307bNj0000000000000H0000000<0/?Gb00000000
00001@00001f0?ooo`00V03oool@000007P0oooo002J0?ooo`8000000P3Ve/H400000080ClVa00<0
00000?ooo`3oool0N@3oool009`0oooo0`00000204o9/@800000O@3oool009d0oooo1000001o0?oo
o`00WP3oool00`000000oooo0?ooo`1o0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.00005*^-06, -5.00005*^-06, \
0.00348436, 0.00348436}}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
    \(ViewPoint\  -> \ {1.0109405079950224, \ \(-5.733328523707276\), \ 
        1.451531373598006}\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 959}},
AutoGeneratedPackage->None,
WindowSize->{648, 789},
WindowMargins->{{Automatic, 303}, {63, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 626, 12, 278, "Title"],

Cell[CellGroupData[{
Cell[2427, 69, 59, 0, 47, "Subsection"],
Cell[2489, 71, 3428, 59, 1488, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5954, 135, 57, 0, 47, "Subsection"],
Cell[6014, 137, 582, 9, 109, "Text"],

Cell[CellGroupData[{
Cell[6621, 150, 285, 4, 84, "Input"],

Cell[CellGroupData[{
Cell[6931, 158, 228553, 9081, 296, 163852, 8278, "GraphicsData", \
"PostScript", "Graphics"],
Cell[235487, 9241, 215795, 8877, 296, 164187, 8235, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],
Cell[451309, 18122, 126, 2, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

