(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    164712,       4690]*)
(*NotebookOutlinePosition[    165378,       4713]*)
(*  CellTagsIndexPosition[    165334,       4709]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Polinomios de Taylor", "Subtitle"],

Cell[TextData[{
  "La expansi\[OAcute]n de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  ", como serie de potencias, alrededor de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y hasta la potencia ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", es dada por el comando ",
  StyleBox["Series[f[x],{x,a,n}]",
    FontWeight->"Bold"],
  ":"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Clear[f, a];\)\), "\[IndentingNewLine]", 
    \(Series[f[x], {x, a, 4}]\)}], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(f[a]\), "+", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "a", "]"}], " ", \((x - a)\)}], 
        "+", 
        RowBox[{\(1\/2\), " ", 
          RowBox[{
            SuperscriptBox["f", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "a", "]"}], 
          " ", \(\((x - a)\)\^2\)}], "+", 
        RowBox[{\(1\/6\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "a", "]"}], 
          " ", \(\((x - a)\)\^3\)}], "+", 
        RowBox[{\(1\/24\), " ", 
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((4)\),
                Derivative],
              MultilineFunction->None], "[", "a", "]"}], 
          " ", \(\((x - a)\)\^4\)}], "+", 
        InterpretationBox[\(O[x - a]\^5\),
          SeriesData[ x, a, {}, 0, 5, 1]]}],
      SeriesData[ x, a, {
        f[ a], 
        Derivative[ 1][ f][ a], 
        Times[ 
          Rational[ 1, 2], 
          Derivative[ 2][ f][ a]], 
        Times[ 
          Rational[ 1, 6], 
          Derivative[ 3][ f][ a]], 
        Times[ 
          Rational[ 1, 24], 
          Derivative[ 4][ f][ a]]}, 0, 5, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "La primera parte, excluyendo el t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm\`O[x - a]\^5\)]],
  ", corresponde al polinomio de Taylor de grado 4, el cual se obtiene \
aplicando al resultado anterior la orden: "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Normal[%]\)], "Input"],

Cell[BoxData[
    RowBox[{\(f[a]\), "+", 
      RowBox[{\((\(-a\) + x)\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/2\), " ", \(\((\(-a\) + x)\)\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/6\), " ", \(\((\(-a\) + x)\)\^3\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/24\), " ", \(\((\(-a\) + x)\)\^4\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Consecuentemente, la siguiente funci\[OAcute]n calcula el polinonimio de \
Taylor de grado ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " para una funci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  ", alrededor de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Taylor[exp_, \ {x_, \ x0_, \ n_}]\  := \ 
      Normal[Series[exp, {x, x0, n}]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Taylor[Cos[x], {x, 0, 10}]\)], "Input"],

Cell[BoxData[
    \(1 - x\^2\/2 + x\^4\/24 - x\^6\/720 + x\^8\/40320 - 
      x\^10\/3628800\)], "Output"]
}, Open  ]],

Cell[TextData[{
  " El polinomio de Taylor ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\_n\)(x)\)]],
  ", de grado ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", tiene la caracter\[IAcute]stica de que sus primeras ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " derivadas coinciden con ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", es decir:\n        ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\_n\)(a) = f(a)\)]],
  ",   ",
  Cell[BoxData[
      \(TraditionalForm\`P\_n' \((a)\) = \ f' \((a)\)\)]],
  ",  \[CenterEllipsis] ,  ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\_n\^\((n)\)\)(a)\  = \ \(f\^\((n)\)\)(a)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(T5[x_]\  = \ Taylor[f[x], {x, a, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{\(f[a]\), "+", 
      RowBox[{\((\(-a\) + x)\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/2\), " ", \(\((\(-a\) + x)\)\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/6\), " ", \(\((\(-a\) + x)\)\^3\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/24\), " ", \(\((\(-a\) + x)\)\^4\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/120\), " ", \(\((\(-a\) + x)\)\^5\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((5)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[T5[x]\ , x]\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["f", "\[Prime]",
          MultilineFunction->None], "[", "a", "]"}], "+", 
      RowBox[{\((\(-a\) + x)\), " ", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/2\), " ", \(\((\(-a\) + x)\)\^2\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/6\), " ", \(\((\(-a\) + x)\)\^3\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "+", 
      RowBox[{\(1\/24\), " ", \(\((\(-a\) + x)\)\^4\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((5)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. {x \[Rule] a}\)], "Input"],

Cell[BoxData[
    RowBox[{
      SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "a", "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[D[T5[x], {x, n}] /. {x \[Rule] a}, {n, 1, 5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "a", "]"}], ",", 
        RowBox[{
          SuperscriptBox["f", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "a", "]"}], ",", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}], ",", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}], ",", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((5)\),
              Derivative],
            MultilineFunction->None], "[", "a", "]"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
    RowBox[{\(En\ las\ anteriores\ \[OAcute]rdenes\ observe\ \(que : \
\[IndentingNewLine]\ \ \ D[
              T5[x], {x, n}]\) = \(T5\^\((n)\)\) \((x)\)\ \ \ \ y\), 
      " "}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{"       ", 
          StyleBox[" ",
            FontWeight->"Plain"], " "}]], 
      RowBox[{\(D[T5[x], {x, n}]\  /. \ {x \[RightArrow] a}\), 
        StyleBox[" ",
          FontWeight->"Bold"], "=", 
        StyleBox[" ",
          FontWeight->"Bold"], 
        RowBox[{
          FormBox[\(\(T5\^\((n)\)\)(a)\),
            "TraditionalForm"], "."}]}]}]}], "Text"],

Cell[TextData[{
  "Esta coincidencia del polinomio de Taylor y sus derivadas con la funci\
\[OAcute]n, en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", provoca un comportamiento del polinomio muy similar al de la funci\
\[OAcute]n, en todo un vecindario al rededor de ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ": "
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Colors`\>"]\)], "Input"],

Cell[BoxData[
    \(PlotTaylor[f_, {x_, a_, b_}, {x0_, n_}, Opc___]\  := \ 
      Module[{T}, \[IndentingNewLine]T[t_]\  = \ 
          Taylor[f[t], {t, x0, n}]; \[IndentingNewLine]\ \ \ \ Plot[{f[x], 
            T[x]}, {x, a, b}, Opc]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PlotTaylor[
      Cos, {x, 0, 2  \[Pi]}, {\[Pi], 
        5}, \[IndentingNewLine]PlotStyle \[Rule] {Blue, Red}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.309017 0.294302 [
[.17539 .29652 -3 -9 ]
[.17539 .29652 3 0 ]
[.32696 .29652 -3 -9 ]
[.32696 .29652 3 0 ]
[.47854 .29652 -3 -9 ]
[.47854 .29652 3 0 ]
[.63011 .29652 -3 -9 ]
[.63011 .29652 3 0 ]
[.78169 .29652 -3 -9 ]
[.78169 .29652 3 0 ]
[.93327 .29652 -3 -9 ]
[.93327 .29652 3 0 ]
[.01131 .01471 -12 -4.5 ]
[.01131 .01471 0 4.5 ]
[.01131 .16187 -24 -4.5 ]
[.01131 .16187 0 4.5 ]
[.01131 .45617 -18 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .30902 m
.17539 .31527 L
s
[(1)] .17539 .29652 0 1 Mshowa
.32696 .30902 m
.32696 .31527 L
s
[(2)] .32696 .29652 0 1 Mshowa
.47854 .30902 m
.47854 .31527 L
s
[(3)] .47854 .29652 0 1 Mshowa
.63011 .30902 m
.63011 .31527 L
s
[(4)] .63011 .29652 0 1 Mshowa
.78169 .30902 m
.78169 .31527 L
s
[(5)] .78169 .29652 0 1 Mshowa
.93327 .30902 m
.93327 .31527 L
s
[(6)] .93327 .29652 0 1 Mshowa
.125 Mabswid
.05412 .30902 m
.05412 .31277 L
s
.08444 .30902 m
.08444 .31277 L
s
.11476 .30902 m
.11476 .31277 L
s
.14507 .30902 m
.14507 .31277 L
s
.2057 .30902 m
.2057 .31277 L
s
.23602 .30902 m
.23602 .31277 L
s
.26633 .30902 m
.26633 .31277 L
s
.29665 .30902 m
.29665 .31277 L
s
.35728 .30902 m
.35728 .31277 L
s
.38759 .30902 m
.38759 .31277 L
s
.41791 .30902 m
.41791 .31277 L
s
.44822 .30902 m
.44822 .31277 L
s
.50885 .30902 m
.50885 .31277 L
s
.53917 .30902 m
.53917 .31277 L
s
.56948 .30902 m
.56948 .31277 L
s
.5998 .30902 m
.5998 .31277 L
s
.66043 .30902 m
.66043 .31277 L
s
.69074 .30902 m
.69074 .31277 L
s
.72106 .30902 m
.72106 .31277 L
s
.75138 .30902 m
.75138 .31277 L
s
.81201 .30902 m
.81201 .31277 L
s
.84232 .30902 m
.84232 .31277 L
s
.87264 .30902 m
.87264 .31277 L
s
.90295 .30902 m
.90295 .31277 L
s
.96358 .30902 m
.96358 .31277 L
s
.9939 .30902 m
.9939 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.02381 .01471 m
.03006 .01471 L
s
[(-1)] .01131 .01471 1 0 Mshowa
.02381 .16187 m
.03006 .16187 L
s
[(-0.5)] .01131 .16187 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(0.5)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04414 m
.02756 .04414 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .60332 m
.02499 .60331 L
.02605 .60329 L
.02729 .60324 L
.02846 .60318 L
.03053 .60303 L
.03279 .6028 L
.03527 .60248 L
.0379 .60205 L
.04262 .60106 L
.04749 .59974 L
.05205 .59822 L
.06244 .59381 L
.07305 .58793 L
.08274 .58135 L
.10458 .56251 L
.14429 .51515 L
.18248 .45627 L
.22313 .38349 L
.26226 .30833 L
.30384 .22863 L
.34391 .15746 L
.38246 .09886 L
.402 .07411 L
.42346 .05145 L
.44388 .03466 L
.45301 .02874 L
.46295 .02346 L
.46838 .0211 L
.4734 .01924 L
.4781 .01778 L
.4833 .0165 L
.48553 .01605 L
.48794 .01565 L
.49002 .01535 L
.4923 .01509 L
.49473 .01489 L
.49605 .01481 L
.49728 .01476 L
.49844 .01473 L
.49949 .01472 L
.50071 .01472 L
.50186 .01474 L
.50301 .01477 L
.50425 .01483 L
.50542 .0149 L
.50648 .01498 L
.5091 .01524 L
.51158 .01557 L
.5165 .01646 L
Mistroke
.52187 .01777 L
.53144 .02102 L
.54032 .02507 L
.56088 .03814 L
.5795 .05428 L
.61962 .1017 L
.65822 .16102 L
.69928 .23447 L
.73882 .31042 L
.77684 .38344 L
.81732 .45593 L
.85628 .51593 L
.87613 .54149 L
.89769 .56473 L
.91843 .58221 L
.92832 .58876 L
.93759 .59383 L
.94643 .59767 L
.95595 .6007 L
.9611 .60186 L
.96369 .60232 L
.96652 .60272 L
.96894 .60298 L
.9703 .6031 L
.97153 .60318 L
.97268 .60324 L
.97393 .60329 L
.97511 .60331 L
.97619 .60332 L
Mfstroke
1 0 0 r
.02381 .27255 m
.04262 .33792 L
.06244 .38942 L
.07286 .40996 L
.08255 .42537 L
.0932 .43842 L
.09916 .44407 L
.10458 .44821 L
.10941 .45114 L
.11206 .45245 L
.11454 .45349 L
.11891 .4549 L
.12123 .45544 L
.12244 .45565 L
.12373 .45584 L
.12445 .45593 L
.12511 .456 L
.12639 .4561 L
.12711 .45613 L
.12788 .45616 L
.12862 .45617 L
.12929 .45616 L
.13052 .45613 L
.13121 .45609 L
.13186 .45604 L
.13317 .45592 L
.13458 .45573 L
.13725 .45526 L
.13977 .45465 L
.14451 .45311 L
.1491 .45113 L
.15416 .44843 L
.16442 .44137 L
.18284 .42392 L
.20219 .40003 L
.22304 .36931 L
.26418 .29904 L
.30381 .22683 L
.34191 .16027 L
.38248 .09875 L
.42152 .05328 L
.44287 .03537 L
.45266 .02895 L
.46302 .02343 L
.47255 .01953 L
.47797 .01782 L
.48303 .01656 L
.48542 .01608 L
.48768 .01569 L
.48974 .01539 L
Mistroke
.49193 .01513 L
.49317 .01501 L
.4943 .01492 L
.49545 .01485 L
.4965 .01479 L
.49774 .01475 L
.49838 .01473 L
.49907 .01472 L
.50022 .01472 L
.50148 .01473 L
.50279 .01476 L
.504 .01482 L
.50533 .0149 L
.50674 .01501 L
.50911 .01525 L
.51172 .01559 L
.51652 .01646 L
.52103 .01754 L
.53111 .02089 L
.54196 .02592 L
.56204 .03902 L
.58315 .05789 L
.62131 .10394 L
.66193 .16668 L
.70102 .2356 L
.74257 .31115 L
.78261 .37806 L
.80096 .40425 L
.82113 .42815 L
.83073 .43734 L
.84104 .44539 L
.84673 .44895 L
.85193 .45162 L
.85715 .4537 L
.8597 .4545 L
.8621 .45511 L
.8643 .45555 L
.86544 .45574 L
.86668 .4559 L
.86796 .45603 L
.86866 .45608 L
.86932 .45612 L
.87049 .45616 L
.87174 .45617 L
.87242 .45615 L
.87306 .45613 L
.87376 .45609 L
.8745 .45603 L
.87574 .45591 L
.8771 .45573 L
Mistroke
.87962 .45526 L
.88198 .45466 L
.88662 .45303 L
.89086 .451 L
.89575 .44799 L
.9004 .44444 L
.90999 .43492 L
.92022 .42132 L
.93861 .3871 L
.95796 .33614 L
.97619 .27255 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{203.813, 126},
  ImageMargins->{{84.3125, 0}, {0, 8.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004a0000_B000`400?l00000o`00003oo`3ooolb
0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb
0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb
0?ooo`00703oool7000000@0oooo00<000000?ooo`3oool0o`3oool80?ooo`007`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0?l0oooo203oool001l0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`3o0?ooo`P0oooo000O0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0o`3oool80?ooo`004`3oool6000000H0oooo00<000000?ooo`3oool01@3oool3
000007P0oooo3P3o00210?ooo`007`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
07H0oooo0P3o000>0?ooo`80o`00O`3oool001l0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`1c0?ooo`<0o`004P3oool20?l007d0oooo000M0?ooo`<000001`3oool00`000000oooo
0?ooo`1a0?ooo`80o`0000<0003o0?ooo`3oool0503oool00`3o0000003o0?ooo`1j0?ooo`007`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0700oooo00<0o`000000o`3oool0603o
ool20?l007X0oooo000W0?ooo`030000003oool0oooo06l0oooo00<0o`000?ooo`3oool06`3oool2
0?l007P0oooo000W0?ooo`030000003oool0oooo06h0oooo00<0o`000?ooo`3oool07P3oool00`3o
0000oooo0?ooo`1e0?ooo`009`3oool00`000000oooo0?ooo`1]0?ooo`030?l0003oool0oooo0200
oooo00<0o`000?ooo`3oool0M03oool002L0oooo0P00001/0?ooo`80o`00903oool00`3o0000003o
0?ooo`1c0?ooo`009`3oool00`000000oooo0?ooo`1Z0?ooo`030?l000000?l0oooo02D0oooo0P3o
001c0?ooo`009`3oool00`000000oooo0?ooo`1Y0?ooo`030?l000000?l0oooo02P0oooo00<0o`00
0?ooo`3oool0L03oool002L0oooo00<000000?ooo`3oool0J03oool00`3o0000003o0?ooo`0Z0?oo
o`030?l0003oool0oooo06l0oooo000W0?ooo`030000003oool0oooo06L0oooo00<0o`000000o`3o
ool0;03oool00`3o0000oooo0?ooo`1^0?ooo`009`3oool00`000000oooo0?ooo`1V0?ooo`030?l0
00000?l0oooo02h0oooo00<0o`000?ooo`3oool0K@3oool002L0oooo00<000000?ooo`3oool0I@3o
ool00`3o0000003o0?ooo`0_0?ooo`030?l0003oool0oooo06d0oooo000W0?ooo`030000003oool0
oooo06@0oooo00<0o`000000o`3oool0<@3oool00`3o0000oooo0?ooo`1/0?ooo`009`3oool20000
06@0oooo00<0o`000000o`3oool0<`3oool00`3o0000oooo0?ooo`1[0?ooo`009`3oool00`000000
oooo0?ooo`1S0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool0JP3oool002L0oooo
00<000000?ooo`3oool0HP3oool00`3o0000oooo0?ooo`0e0?ooo`030?l000000?l0oooo06X0oooo
000W0?ooo`030000003oool0oooo0640oooo00<0o`000?ooo`3oool0=`3oool00`3o0000003o0?oo
o`1Y0?ooo`009`3oool00`000000oooo0?ooo`1P0?ooo`030?l0003oool0oooo03T0oooo00<0o`00
0?ooo`3oool0J03oool002L0oooo00<000000?ooo`3oool0G`3oool00`3o0000oooo0?ooo`0k0?oo
o`030?l0003oool0oooo06L0oooo000W0?ooo`030000003oool0oooo05h0oooo00<0o`000?ooo`3o
ool0?03oool00`3o0000003o0?ooo`1W0?ooo`009`3oool00`000000oooo0?ooo`1M0?ooo`030?l0
003oool0oooo03h0oooo00<0o`000000o`3oool0IP3oool002L0oooo0P00001N0?ooo`030?l0003o
ool0oooo03l0oooo00<0o`000000o`3oool0I@3oool002L0oooo00<000000?ooo`3oool0G03oool0
0`3o0000oooo0?ooo`110?ooo`030?l0003oool0oooo06@0oooo000W0?ooo`030000003oool0oooo
05/0oooo00<0o`000?ooo`3oool0@P3oool00`3o0000003o0?ooo`1T0?ooo`009`3oool00`000000
oooo0?ooo`1K0?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool0H`3oool002L0oooo
00<000000?ooo`3oool0FP3oool00`3o0000oooo0?ooo`150?ooo`030?l0003oool0oooo0680oooo
000W0?ooo`030000003oool0oooo05T0oooo00<0o`000000o`3oool0AP3oool00`3o0000003o0?oo
o`1R0?ooo`009`3oool00`000000oooo0?ooo`1I0?ooo`030?l0003oool0oooo04L0oooo00<0o`00
0?ooo`3oool0H@3oool002L0oooo00<000000?ooo`3oool0F03oool00`3o0000oooo0?ooo`190?oo
o`030?l0003oool0oooo0600oooo000W0?ooo`800000F@3oool00`3o0000oooo0?ooo`190?ooo`03
0?l000000?l0oooo0600oooo000W0?ooo`030000003oool0oooo05L0oooo00<0o`000?ooo`3oool0
B`3oool00`3o0000oooo0?ooo`1O0?ooo`009`3oool00`000000oooo0?ooo`1F0?ooo`030?l0003o
ool0oooo04`0oooo00<0o`000000o`3oool0G`3oool002L0oooo00<000000?ooo`3oool0EP3oool0
0`3o0000oooo0?ooo`1=0?ooo`030?l0003oool0oooo05h0oooo000;0?ooo`@000001P3oool20000
00H0oooo100000060?ooo`030000003oool0oooo05D0oooo00<0o`000?ooo`3oool0C`3oool00`3o
0000oooo0?ooo`1M0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0
oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1D0?ooo`030?l000000?l0oooo0500oooo00<0o`000000o`3oool0G@3oool000X0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0E03oool00`3o0000oooo0?ooo`1A0?ooo`030?l0003oool0oooo05`0oooo
000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo05<0oooo00<0o`000?ooo`3oool0D`3oool00`3o0000oooo0?oo
o`1K0?ooo`0000<0oooo000000000000100000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`<00000DP3oool00`3o0000003o0?ooo`1D
0?ooo`030?l000000?l0oooo05/0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool02`3oool4000000H0oooo00<000000?ooo`3oool0DP3oool00`3o0000oooo0?ooo`1E0?oo
o`030?l0003oool0oooo05X0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0540oooo00<0o`000000o`3o
ool0E`3oool00`3o0000oooo0?ooo`1I0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1A0?ooo`030?l0
003oool0oooo05L0oooo00<0o`000?ooo`3oool0F@3oool000/0oooo1000000>0?ooo`D000001@3o
ool00`000000oooo0?ooo`1@0?ooo`030?l000000?l0oooo05T0oooo00<0o`000?ooo`3oool0F03o
ool002L0oooo00<000000?ooo`3oool0D03oool00`3o0000oooo0?ooo`1I0?ooo`030?l0003oool0
oooo05P0oooo000W0?ooo`030000003oool0oooo04l0oooo00<0o`000000o`3oool0F`3oool00`3o
0000oooo0?ooo`1G0?ooo`009`3oool00`000000oooo0?ooo`1?0?ooo`030?l0003oool0oooo05/0
oooo00<0o`000?ooo`3oool0E`3oool002L0oooo0P00001?0?ooo`030?l0003oool0oooo05d0oooo
00<0o`000?ooo`3oool0EP3oool002L0oooo00<000000?ooo`3oool0C@3oool00`3o0000003o0?oo
o`1N0?ooo`030000o`3o0000oooo05H0oooo000W0?ooo`030000003oool0oooo04d0oooo00<0o`00
0?ooo`3oool0G`3oool00`3o0000oooo0?ooo`1E0?ooo`009`3oool00`000000oooo0?ooo`1<0?oo
o`030?l000000?l0oooo0640oooo00<0o`000?ooo`3oool0E03oool002L0oooo00<000000?ooo`3o
ool0C03oool00`3o0000oooo0?ooo`1Q0?ooo`030?l0003oool0oooo05@0oooo000W0?ooo`030000
003oool0oooo04/0oooo00<0o`000000o`3oool0H`3oool00`3o0000oooo0?ooo`1C0?ooo`009`3o
ool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0oooo06<0oooo00<0003o0?l0003oool0D`3o
ool002L0oooo00<000000?ooo`3oool0BP3oool00`3o0000003o0?ooo`1U0?ooo`030?l0003oool0
oooo0580oooo000W0?ooo`800000B`3oool00`3o0000oooo0?ooo`1U0?ooo`030000o`3o0000oooo
0580oooo000W0?ooo`030000003oool0oooo04T0oooo00<0o`000000o`3oool0I`3oool00`3o0000
oooo0?ooo`1A0?ooo`009`3oool00`000000oooo0?ooo`180?ooo`030?l000000?l0oooo06P0oooo
00<0003o0?l0003oool0D@3oool002L0oooo00<000000?ooo`3oool0B03oool00`3o0000oooo0?oo
o`1Y0?ooo`030?l0003oool0oooo0500oooo000W0?ooo`030000003oool0oooo04L0oooo00<0o`00
0000o`3oool0J`3oool00`3o0000oooo0?ooo`1?0?ooo`009`3oool00`000000oooo0?ooo`170?oo
o`030?l0003oool0oooo06/0oooo00<0003o0?l0003oool0C`3oool002L0oooo00<000000?ooo`3o
ool0AP3oool00`3o0000003o0?ooo`1]0?ooo`030?l0003oool0oooo04h0oooo000W0?ooo`030000
003oool0oooo04H0oooo00<0o`000?ooo`3oool0K@3oool00`000?l0o`000?ooo`1>0?ooo`009`3o
ool2000002@0oooo1`00000K0?ooo`030?l000000?l0oooo00@0oooo1P00000T0?ooo`@000009P3o
ool4000001<0oooo00<0o`000?ooo`3oool03P3oool4000002L0oooo1000000@0?ooo`009`3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo01`0oooo00<0o`000?ooo`3oool0103oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0180oooo00<0003o0?l0003oool03@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0=0?ooo`009`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
01/0oooo00<0o`000000o`3oool01P3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool04`3oool00`3o0000oooo0?ooo`0A0?ooo`030000003oool0oooo
02<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`009`3oool00`000000
oooo0?ooo`0V0?ooo`030000003oool0oooo01X0oooo00<0o`000000o`3oool0203oool00`000000
oooo0?ooo`0Y0?ooo`030000003oool0oooo0240oooo1P00000D0?ooo`030000o`3o0000oooo0140
oooo00<000000?ooo`3oool08`3oool2000000<0oooo00<000000?ooo`3oool03@3oool002L0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0J0?ooo`030?l000000?l0oooo00T0oooo
00<000000?ooo`3oool09P3oool2000002D0oooo00@000000?ooo`3oool000005P3oool00`3o0000
oooo0?ooo`0@0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`0000000P00000@0?ooo`00
9`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo01T0oooo00<0o`000000o`3oool0
2`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0280oooo00@000000?ooo`3oool0
00005P3oool00`000?l0o`000?ooo`0<0?ooo`@000009P3oool00`000000oooo0?ooo`0B0?ooo`00
9`3oool00`3o0000oooo0?ooo`0V0?ooo`030000003oool0oooo01T0oooo00<0o`000000o`3oool0
1`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0000000G0?ooo`030?l0003oool0oooo00/0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo00@0oooo000W0?ooo`030?l0003o
ool0oooo02@0oooo0`00000J0?ooo`030?l000000?l0oooo00P0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0000000G0?ooo`030000o`3o0000oooo00/0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`090?ooo`030?l0003oool0oooo00@0oooo000W0?ooo`030000003o0000
oooo02H0oooo00<000000?ooo`3oool0603oool00`3o0000003o0?ooo`090?ooo`@000009@3oool4
000002L0oooo0P00000H0?ooo`030000o`3o0000oooo00X0oooo1@00000X0?ooo`<000001`3oool0
0`3o0000oooo0?ooo`050?ooo`009`3oool00`000000o`000?ooo`100?ooo`030?l000000?l0oooo
07P0oooo00<0003o0?l0003oool0@@3oool00`3o0000oooo0?ooo`050?ooo`009`3oool00`000000
o`000?ooo`100?ooo`030?l000000?l0oooo07T0oooo00<0003o0?l0003oool0@03oool00`3o0000
oooo0?ooo`050?ooo`009`3oool00`000000o`000?ooo`0o0?ooo`030?l000000?l0oooo07X0oooo
00<0003o0?l0003oool0@03oool00`3o0000oooo0?ooo`050?ooo`009`3oool00`000000oooo0?l0
000o0?ooo`030?l000000?l0oooo07/0oooo00<0003o0?l0003oool0?P3oool00`3o0000oooo0?oo
o`060?ooo`009`3oool00`000000oooo0?l0000n0?ooo`030?l000000?l0oooo07`0oooo00<0003o
0?l0003oool0?P3oool00`3o0000oooo0?ooo`060?ooo`009`3oool00`000000oooo0?l0000m0?oo
o`030?l0003oool0003o07h0oooo00<0003o0?l0003oool0?@3oool00`3o0000oooo0?ooo`060?oo
o`00803oool:000000030?l000000000000003X0000000<0o`000000o`000000OP0000000`000?l0
o`000000000l000000030?l000000000000000L00000000W0?ooo`040000003oool0oooo0?l000@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool00P3oool0103o0000003o0?ooo`0000070?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`050000o`3o0000oooo
0?ooo`0000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01@3oool00`000000o`000?ooo`060?ooo`4000000@3oool002L0oooo00@000000?oo
o`3oool0o`00103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`040?l000000?l0oooo000000L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo00@0
003o0?l0003oool000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000o`000?ooo`060?ooo`4000000@3oool002L0oooo00D0
00000?ooo`3oool0oooo0?l0000i0?ooo`030?l000000?l0oooo0880oooo00<0003o0?l0003oool0
>@3oool00`3o0000oooo0?ooo`080?ooo`009`3oool01@000000oooo0?ooo`3oool0o`0003T0oooo
00<0o`000000o`3oool0P`3oool00`000?l0o`000?ooo`0h0?ooo`030?l0003oool0oooo00P0oooo
000W0?ooo`050000003oool0oooo0?ooo`3o0000>03oool00`3o0000003o0?ooo`240?ooo`030000
o`3o0000oooo03P0oooo00<0o`000?ooo`3oool0203oool002L0oooo00D000000?ooo`3oool0oooo
0?l0000g0?ooo`030?l0003oool0003o08H0oooo00<0003o0?l0003oool0=`3oool00`3o0000oooo
0?ooo`080?ooo`009`3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo03@0oooo00<0
o`000000o`3oool0QP3oool00`000?l0oooo0?l0000f0?ooo`030?l0003oool0oooo00T0oooo000W
0?ooo`8000000`3oool00`3o0000oooo0?ooo`0c0?ooo`030?l0003oool0003o08P0oooo00<0003o
0?l0003oool0=@3oool00`3o0000oooo0?ooo`090?ooo`009`3oool00`000000oooo0?ooo`020?oo
o`030?l0003oool0oooo03<0oooo00<0o`000000o`3oool0R03oool00`000?l0oooo0?l0000e0?oo
o`030?l0003oool0oooo00T0oooo000W0?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3o
ool0<@3oool00`3o0000oooo0000o`2:0?ooo`030000o`3o0000oooo03<0oooo00<0o`000?ooo`3o
ool02P3oool002L0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`0`0?ooo`030?l0
003oool0003o08/0oooo00<0003o0?ooo`3o0000<`3oool00`3o0000oooo0?ooo`0:0?ooo`009`3o
ool00`000000oooo0?ooo`030?ooo`030?l0003oool0oooo0300oooo00<0o`000?ooo`000?l0S03o
ool00`000?l0oooo0?l0000b0?ooo`030?l0003oool0oooo00X0oooo000W0?ooo`030000003oool0
oooo00@0oooo00<0o`000?ooo`3oool0;P3oool00`3o0000oooo0000o`2>0?ooo`030000o`3o0000
oooo0300oooo00<0o`000?ooo`3oool02`3oool002L0oooo00<000000?ooo`3oool0103oool00`3o
0000oooo0?ooo`0^0?ooo`030?l0003oool0003o08h0oooo00<0003o0?ooo`3o0000<03oool00`3o
0000oooo0?ooo`0;0?ooo`009`3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo02d0
oooo00<0o`000?ooo`000?l0T03oool00`000?l0oooo0?l0000^0?ooo`030?l0003oool0oooo00`0
oooo000W0?ooo`8000001P3oool00`3o0000oooo0?ooo`0/0?ooo`030?l0003oool0003o0900oooo
00<0003o0?ooo`3o0000;P3oool00`3o0000oooo0?ooo`0<0?ooo`009`3oool00`000000oooo0?oo
o`050?ooo`030?l0003oool0oooo02/0oooo00<0o`000?ooo`000?l0TP3oool00`000?l0oooo0?l0
000]0?ooo`030?l0003oool0oooo00`0oooo000W0?ooo`030000003oool0oooo00H0oooo00<0o`00
0?ooo`3oool0:@3oool0103o0000oooo0?ooo`000?nB0?ooo`030000o`3oool0o`0002`0oooo00<0
o`000?ooo`3oool03@3oool002L0oooo00<000000?ooo`3oool01P3oool00`3o0000oooo0?ooo`0X
0?ooo`040?l0003oool0oooo0000oi@0oooo00<0003o0?ooo`3o0000:`3oool00`3o0000oooo0?oo
o`0=0?ooo`009`3oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo02P0oooo00@0o`00
0?ooo`3oool0003oU03oool010000?l0oooo0?ooo`3o000Z0?ooo`030?l0003oool0oooo00d0oooo
000W0?ooo`030000003oool0oooo00L0oooo00<0o`000?ooo`3oool09P3oool0103o0000oooo0?oo
o`000?nF0?ooo`030000o`3oool0o`0002T0oooo00<0o`000?ooo`3oool03P3oool002L0oooo00<0
00000?ooo`3oool01`3oool00`3o0000oooo0?ooo`0U0?ooo`040?l0003oool0oooo0000oiP0oooo
00<0003o0?ooo`3o0000:03oool00`3o0000oooo0?ooo`0>0?ooo`009`3oool00`000000oooo0?oo
o`070?ooo`030?l0003oool0oooo02@0oooo00D0o`000?ooo`3oool0oooo0000o`2H0?ooo`040000
o`3oool0oooo0?l002H0oooo00<0o`000?ooo`3oool03`3oool002L0oooo0P0000090?ooo`030?l0
003oool0oooo02<0oooo00@0o`000?ooo`3oool0003oVP3oool010000?l0oooo0?ooo`3o000U0?oo
o`030?l0003oool0oooo00l0oooo000W0?ooo`030000003oool0oooo00P0oooo00<0o`000?ooo`3o
ool08P3oool01@3o0000oooo0?ooo`3oool0003o09X0oooo00@0003o0?ooo`3oool0o`00903oool0
0`3o0000oooo0?ooo`0@0?ooo`009`3oool00`000000oooo0?ooo`090?ooo`030?l0003oool0oooo
0200oooo00D0o`000?ooo`3oool0oooo0000o`2L0?ooo`040000o`3oool0oooo0?l002<0oooo00<0
o`000?ooo`3oool0403oool002L0oooo00<000000?ooo`3oool02@3oool00`3o0000oooo0?ooo`0P
0?ooo`050?l0003oool0oooo0?ooo`000?l0W03oool01@000?l0oooo0?ooo`3oool0o`000240oooo
00<0o`000?ooo`3oool04@3oool002L0oooo00<000000?ooo`3oool02P3oool00`3o0000oooo0?oo
o`0N0?ooo`050?l0003oool0oooo0?ooo`000?l0WP3oool01@000?l0oooo0?ooo`3oool0o`000200
oooo00<0o`000?ooo`3oool04@3oool002L0oooo00<000000?ooo`3oool02`3oool00`3o0000oooo
0?ooo`0L0?ooo`030?l0003oool0oooo0080oooo00<0003o0?ooo`3oool0W@3oool01@000?l0oooo
0?ooo`3oool0o`0001h0oooo00<0o`000?ooo`3oool04P3oool002L0oooo00<000000?ooo`3oool0
2`3oool00`3o0000oooo0?ooo`0K0?ooo`030?l0003oool0oooo0080oooo00<0003o0?ooo`3oool0
WP3oool01@000?l0oooo0?ooo`3oool0o`0001h0oooo00<0o`000?ooo`3oool04P3oool002L0oooo
00<000000?ooo`3oool0303oool00`3o0000oooo0?ooo`0J0?ooo`050?l0003oool0oooo0?ooo`00
0?l0XP3oool01@000?l0oooo0?ooo`3oool0o`0001`0oooo00<0o`000?ooo`3oool04`3oool002L0
oooo0P00000>0?ooo`030?l0003oool0oooo01P0oooo00<0o`000?ooo`3oool00P3oool00`000?l0
oooo0?ooo`2P0?ooo`030000o`3oool0oooo0080oooo00<0o`000?ooo`3oool0603oool00`3o0000
oooo0?ooo`0D0?ooo`009`3oool00`000000oooo0?ooo`0>0?ooo`030?l0003oool0oooo01H0oooo
00<0o`000?ooo`3oool00P3oool00`000?l0oooo0?ooo`2R0?ooo`030000o`3oool0oooo0080oooo
00<0o`000?ooo`3oool05P3oool00`3o0000oooo0?ooo`0E0?ooo`009`3oool00`000000oooo0?oo
o`0>0?ooo`030?l0003oool0oooo01@0oooo0P3o00050?ooo`030000o`3oool0oooo0:<0oooo00<0
003o0?ooo`3oool00P3oool00`3o0000oooo0?ooo`0E0?ooo`030?l0003oool0oooo01D0oooo000W
0?ooo`030000003oool0oooo00l0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?ooo`04
0?ooo`030000o`3oool0oooo0:@0oooo00<0003o0?ooo`3oool00`3oool00`3o0000oooo0?ooo`0C
0?ooo`030?l0003oool0oooo01H0oooo000W0?ooo`030000003oool0oooo0100oooo00<0o`000?oo
o`3oool0403oool00`3o0000oooo0?ooo`050?ooo`030000o`3oool0oooo0:D0oooo00<0003o0?oo
o`3oool00`3oool00`3o0000oooo0?ooo`0@0?ooo`80o`006@3oool000/0oooo100000060?ooo`80
00001P3oool4000000H0oooo00<000000?ooo`3oool04@3oool00`3o0000oooo0?ooo`0=0?ooo`80
o`001`3oool00`000?l0oooo0?ooo`2V0?ooo`030000o`3oool0oooo00@0oooo00<0o`000?ooo`3o
ool03P3oool00`3o0000oooo0?ooo`0I0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00<0oooo0P0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0B0?ooo`80o`00303oool00`3o0000oooo0?ooo`070?ooo`030000
o`3oool0oooo0:L0oooo00<0003o0?ooo`3oool0103oool00`3o0000oooo0?ooo`0<0?ooo`030?l0
003oool0oooo01X0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo0P3o00090?ooo`030?l0003o
ool0oooo00L0oooo00<0003o0?ooo`3oool0Z03oool00`000?l0oooo0?ooo`050?ooo`<0o`002P3o
ool00`3o0000oooo0?ooo`0K0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool00`3oool3000001H0oooo2@3o000:0?ooo`030000o`3oool0
oooo0:T0oooo00<0003o0?ooo`3oool01`3oool:0?l001h0oooo000:0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
02P0oooo00<0003o0?ooo`3oool0Z`3oool00`000?l0oooo0?ooo`0^0?ooo`002P3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo100000060?ooo`030000003oool0oooo02L0
oooo00<0003o0?ooo`3oool0[03oool00`000?l0oooo0?ooo`0^0?ooo`002P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`0W0?ooo`030000o`3oool0oooo0:d0oooo00<0003o0?ooo`3oool0;@3oool000X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool09P3oool00`000?l0oooo0?ooo`2^0?ooo`030000o`3oool0oooo02d0oooo000;
0?ooo`@000003P3oool5000000D0oooo00<000000?ooo`3oool09@3oool00`000?l0oooo0?ooo`2`
0?ooo`030000o`3oool0oooo02`0oooo000W0?ooo`030000003oool0oooo02D0oooo00<0003o0?oo
o`3oool0/@3oool00`000?l0oooo0?ooo`0[0?ooo`009`3oool00`000000oooo0?ooo`0T0?ooo`03
0000o`3oool0oooo0;80oooo00<0003o0?ooo`3oool0:`3oool002L0oooo0P00000U0?ooo`030000
o`3oool0oooo0;<0oooo00<0003o0?ooo`3oool0:P3oool002L0oooo00<000000?ooo`3oool08`3o
ool00`000?l0oooo0?ooo`2d0?ooo`030000o`3oool0oooo02X0oooo000W0?ooo`030000003oool0
oooo0280oooo00<0003o0?ooo`3oool0]P3oool00`000?l0oooo0?ooo`0Y0?ooo`009`3oool00`00
0000oooo0?ooo`0R0?ooo`030000o`3oool0oooo0;H0oooo00<0003o0?ooo`3oool0:@3oool002L0
oooo00<000000?ooo`3oool08@3oool00`000?l0oooo0?ooo`2h0?ooo`030000o`3oool0oooo02P0
oooo000W0?ooo`030000003oool0oooo0200oooo00<0003o0?ooo`3oool0^P3oool00`000?l0oooo
0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`0P0?ooo`030000o`3oool0oooo0;X0oooo00<0
003o0?ooo`3oool09`3oool002L0oooo00<000000?ooo`3oool07`3oool00`000?l0oooo0?ooo`2l
0?ooo`030000o`3oool0oooo02H0oooo000W0?ooo`800000803oool00`000?l0oooo0?ooo`2l0?oo
o`030000o`3oool0oooo02H0oooo000W0?ooo`030000003oool0oooo01h0oooo00<0003o0?ooo`3o
ool0_P3oool00`000?l0oooo0?ooo`0U0?ooo`009`3oool00`000000oooo0?ooo`0M0?ooo`030000
o`3oool0oooo0<00oooo00<0003o0?ooo`3oool0903oool002L0oooo00<000000?ooo`3oool0703o
ool00`000?l0oooo0?ooo`320?ooo`030000o`3oool0oooo02<0oooo000W0?ooo`030000003oool0
oooo01/0oooo00<0003o0?ooo`3oool0a03oool00`000?l0oooo0?ooo`0R0?ooo`009`3oool00`00
0000oooo0?ooo`0J0?ooo`030000o`3oool0oooo0<D0oooo00<0003o0?ooo`3oool08P3oool002L0
oooo00<000000?ooo`3oool06@3oool00`000?l0oooo0?ooo`370?ooo`030000o`3oool0oooo0240
oooo000W0?ooo`030000003oool0oooo01P0oooo00<0003o0?ooo`3oool0b@3oool00`000?l0oooo
0?ooo`0P0?ooo`009`3oool2000001T0oooo00<0003o0?ooo`3oool0bP3oool00`000?l0oooo0?oo
o`0O0?ooo`009`3oool00`000000oooo0?ooo`0G0?ooo`030000o`3oool0oooo0<`0oooo00<0003o
0?ooo`3oool07P3oool002L0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`3>0?oo
o`030000o`3oool0oooo01d0oooo000W0?ooo`030000003oool0oooo01D0oooo00<0003o0?ooo`3o
ool0c`3oool00`000?l0oooo0?ooo`0M0?ooo`009`3oool00`000000oooo0?ooo`0D0?ooo`030000
o`3oool0oooo0=40oooo00<0003o0?ooo`3oool0703oool002L0oooo00<000000?ooo`3oool04`3o
ool00`000?l0oooo0?ooo`3C0?ooo`030000o`3oool0oooo01/0oooo000W0?ooo`030000003oool0
oooo0180oooo00<0003o0?ooo`3oool0e@3oool00`000?l0oooo0?ooo`0J0?ooo`009`3oool00`00
0000oooo0?ooo`0A0?ooo`030000o`3oool0oooo0=L0oooo00<0003o0?ooo`3oool06@3oool002L0
oooo0P00000A0?ooo`030000o`3oool0oooo0=T0oooo00<0003o0?ooo`3oool0603oool002L0oooo
00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`3K0?ooo`80003o603oool002L0oooo00<0
00000?ooo`3oool03P3oool00`000?l0oooo0?ooo`3N0?ooo`030000o`3oool0oooo01D0oooo000W
0?ooo`030000003oool0oooo00`0oooo0P000?oR0?ooo`030000o`3oool0oooo01@0oooo000W0?oo
o`030000003oool0oooo00X0oooo0P000?oU0?ooo`80003o503oool001`0oooo1`0000040?ooo`03
0000003oool0oooo00P0oooo0P000?oY0?ooo`030000o`3oool0oooo0140oooo000O0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`3Z0?ooo`<0003o
403oool001l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`80003ol03o
ool20000o`h0oooo000O0?ooo`030000003oool0oooo00D0oooo20000?od0?ooo`P0003o1P3oool0
01l0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooo`P0oooo000O0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3oool80?ooo`007`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0?l0oooo203oool001d0oooo0`0000070?ooo`030000003o
ool0oooo0?l0oooo203oool001l0oooo00<000000?ooo`3oool0o`3oool@0?ooo`00o`3ooolb0?oo
o`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?oo
o`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00o`3ooolb0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 304.688}, {188, 0}} -> {-0.956451, -1.17531, \
0.0364148, 0.0187549}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[PlotTaylor[
        Cos, {x, 0, 2  \[Pi]}, {\[Pi], 
          n}, \[IndentingNewLine]PlotStyle \[Rule] {Blue, 
            Red}, \[IndentingNewLine]PlotRange \[Rule] {\(-1.1\), 4.1}], {n, 
        1, 6}]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .01189 m
.06244 .01189 L
.10458 .01189 L
.14415 .01189 L
.18221 .01189 L
.22272 .01189 L
.26171 .01189 L
.30316 .01189 L
.34309 .01189 L
.3815 .01189 L
.42237 .01189 L
.46172 .01189 L
.49955 .01189 L
.53984 .01189 L
.57861 .01189 L
.61984 .01189 L
.65954 .01189 L
.69774 .01189 L
.73838 .01189 L
.77751 .01189 L
.81909 .01189 L
.85916 .01189 L
.89771 .01189 L
.93871 .01189 L
.97619 .01189 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooonP3o00060?ooo`0000<0oooo000000000000100000060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0K`3oool70000o`L0oooo2@000?mg0?ooo`003@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06X0oooo1@000?lG0?ooo`80003oM@3o
ool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1W0?ooo`<0003o7P3oool3
0000og80oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`1U0?ooo`80003o903oool20000
og00oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H`3oool20000obP0
oooo0`000?m]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80003o;@3oool20000of/0oooo
000E0?ooo`800000H03oool20000oc40oooo0P000?mY0?ooo`005@3oool00`000000oooo0?ooo`1M
0?ooo`80003o=@3oool20000ofL0oooo000E0?ooo`030000003oool0oooo05/0oooo0P000?li0?oo
o`80003oI@3oool001D0oooo00<000000?ooo`3oool0F@3oool20000ocd0oooo0P000?mS0?ooo`00
5@3oool00`000000oooo0?ooo`1G0?ooo`80003o@@3oool20000of40oooo000E0?ooo`030000003o
ool0oooo05H0oooo00<0003o0?ooo`3oool0@`3oool20000oel0oooo000E0?ooo`800000E@3oool2
0000odP0oooo00<0003o0?ooo`3oool0G03oool001D0oooo00<000000?ooo`3oool0DP3oool20000
od/0oooo0P000?mL0?ooo`005@3oool00`000000oooo0?ooo`1A0?ooo`030000o`3oool0oooo04d0
oooo0P000?mJ0?ooo`005@3oool00`000000oooo0?ooo`0Q0?ooo`L000008@3oool600000080003o
803oool4000002D0oooo100000050?ooo`030000o`3oool0oooo01/0oooo1000000T0?ooo`@00000
403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo0080oooo00<0003o0?ooo`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool01@3oool20000oaX0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3o
ool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`040000003oool0
oooo0000obL0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`070?ooo`030000o`3o
ool0oooo01`0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00d0oooo000E0?ooo`8000009@3oool00`000000oooo0?ooo`0T0?ooo`80003o:03oool0
0`000000oooo0?ooo`0P0?ooo`H000002@3oool00`000?l0oooo0?ooo`0K0?ooo`030000003oool0
oooo0200oooo0P0000030?ooo`030000003oool0oooo00d0oooo000E0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool08`3oool00`000?l0oooo0000000V0?ooo`800000903oool01000
0000oooo0?ooo`00000;0?ooo`80003o6`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
000000800000403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0R0?oo
o`050000o`3oool0oooo0?ooo`0000009`3oool00`000000oooo0?ooo`0Q0?ooo`040000003oool0
oooo000000d0oooo00<0003o0?ooo`3oool0503oool4000002<0oooo00<000000?ooo`3oool04P3o
ool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0P0?ooo`80003o00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`0000003P3oool00`000?l0oooo0?ooo`0C0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool04@3oool001D0oooo00<000000?ooo`3oool08P3oool300000240oooo00@0003o0?oo
o`3oool00000103oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0000000?0?ooo`80003o4`3oool00`000000oooo0?ooo`0V
0?ooo`030000003oool0oooo0100oooo000E0?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool07@3oool20000o`@0oooo1000000S0?ooo`@000009P3oool200000140oooo00<0003o0?oo
o`3oool0403oool5000002D0oooo0`00000?0?ooo`005@3oool2000004@0oooo00<0003o0?ooo`3o
ool0J@3oool00`000?l0oooo0?ooo`1;0?ooo`005@3oool00`000000oooo0?ooo`120?ooo`030000
o`3oool0oooo06/0oooo0P000?m;0?ooo`005@3oool00`000000oooo0?ooo`100?ooo`80003oL03o
ool00`000?l0oooo0?ooo`180?ooo`005@3oool00`000000oooo0?ooo`0o0?ooo`030000o`3oool0
oooo0740oooo00<0003o0?ooo`3oool0A`3oool001D0oooo00<000000?ooo`3oool0?P3oool00`00
0?l0oooo0?ooo`1c0?ooo`030000o`3oool0oooo04H0oooo000E0?ooo`030000003oool0oooo03`0
oooo0P000?mg0?ooo`80003oAP3oool000l0ooooA00000000`000?l000000000001i000000030000
o`000000000004<00000000E0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00`3o
ool00`000?l0oooo000000070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`020?ooo`040000o`3oool0oooo000000L0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1@3oool100000040oooo000E0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool04@3o
ool20000oa80oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003o
ool0oooo01X0oooo0P000?l80?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool03`3o
ool001D0oooo00<000000?ooo`3oool0=`3oool00`000?l0oooo0?ooo`210?ooo`030000o`3oool0
oooo03l0oooo000E0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool0P`3oool00`00
0?l0oooo0?ooo`0n0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0oooo08D0
oooo0P000?ln0?ooo`005@3oool00`000000oooo0?ooo`0c0?ooo`80003oRP3oool00`000?l0oooo
0?ooo`0k0?ooo`005@3oool2000003<0oooo00<0003o0?ooo`3oool0R`3oool20000oc/0oooo000E
0?ooo`030000003oool0oooo0340oooo00<0003o0?ooo`3oool0SP3oool00`000?l0oooo0?ooo`0h
0?ooo`005@3oool00`000000oooo0?ooo`0_0?ooo`80003oTP3oool20000ocP0oooo000E0?ooo`03
0000003oool0oooo02h0oooo00<0003o0?ooo`3oool0U03oool00`000?l0oooo0?ooo`0e0?ooo`00
5@3oool00`000000oooo0?ooo`0]0?ooo`030000o`3oool0oooo09H0oooo00<0003o0?ooo`3oool0
=03oool001D0oooo00<000000?ooo`3oool0:`3oool20000oiX0oooo0P000?ld0?ooo`005@3oool2
000002/0oooo00<0003o0?ooo`3oool0W03oool00`000?l0oooo0?ooo`0a0?ooo`005@3oool00`00
0000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo09h0oooo00<0003o0?ooo`3oool0<03oool001D0
oooo00<000000?ooo`3oool09`3oool20000oj80oooo0P000?l`0?ooo`005@3oool00`000000oooo
0?ooo`0V0?ooo`030000o`3oool0oooo0:@0oooo00<0003o0?ooo`3oool0;@3oool001D0oooo00<0
00000?ooo`3oool0903oool20000ojP0oooo0P000?l]0?ooo`005@3oool00`000000oooo0?ooo`0R
0?ooo`80003o[03oool20000ob/0oooo000E0?ooo`8000008P3oool00`000?l0oooo0?ooo`2^0?oo
o`030000o`3oool0oooo02P0oooo000E0?ooo`030000003oool0oooo01l0oooo0P000?nb0?ooo`80
003o:03oool001D0oooo00<000000?ooo`3oool07@3oool20000okH0oooo0P000?lV0?ooo`005@3o
ool00`000000oooo0?ooo`0L0?ooo`030000o`3oool0oooo0;P0oooo00<0003o0?ooo`3oool08`3o
ool001D0oooo00<000000?ooo`3oool06P3oool20000ok`0oooo0P000?lS0?ooo`005@3oool00`00
0000oooo0?ooo`0H0?ooo`80003o`03oool20000ob40oooo000E0?ooo`8000005`3oool20000ol@0
oooo0P000?lO0?ooo`005@3oool00`000000oooo0?ooo`0D0?ooo`80003ob03oool30000oa`0oooo
000E0?ooo`030000003oool0oooo0140oooo0`000?o=0?ooo`<0003o6@3oool000X0oooo1`000004
0?ooo`030000003oool0oooo00h0oooo0`000?oC0?ooo`80003o5`3oool000d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`80003of03oool30000oa@0oooo000=0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool02@3oool30000omd0oooo0P000?lB0?ooo`00
3@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0003ohP3oool:0000o`P0oooo
000=0?ooo`030000003oool0oooo00D0oooo0`000?od0?ooo`<0003o1P3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3m0?ooo`003@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo0?d0oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`3m0?ooo`00
3@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0
oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?oo
o`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3o
ool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?oo
o`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`800000
oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool0
00X0oooo1P0000050?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`002`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo0?d0oooo000<0?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool200000?h0oooo000>0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0o@3oool000X0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`002`3o
ool4000000H0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool0
01D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo
0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m
0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000
003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0
oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0
oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<00000
0?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3o
ool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3o
ool001D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`002`3oool4000000H0
oooo00<000000?ooo`3oool0o@3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0?d0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0o@3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool2000000H0oooo0P00003n0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?d0oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
o@3oool000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0?d0oooo000;0?ooo`@000001P3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?oo
o`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`800000
oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool0
01D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo
00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m
0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`00
5@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool0
0`000000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0
oooo000<0?ooo`@000001@3oool00`000000oooo0?ooo`3m0?ooo`003P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0?d0oooo000>0?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0o@3oool000X0oooo1P0000050?ooo`030000003oool0oooo0?d0oooo000;0?ooo`04
0000003oool0oooo000000H0oooo0P00003n0?ooo`002`3oool010000000oooo0?ooo`0000060?oo
o`030000003oool0oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool0o@3oool000`0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`3m0?ooo`003@3o
ool200000?l0oooo1`3oool00?l0oooo5P3oool00?l0oooo5P3oool00?l0oooo5P3oool00001\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .5984 m
.06244 .50709 L
.10458 .41631 L
.14415 .33941 L
.18221 .2731 L
.22272 .21075 L
.26171 .15875 L
.30316 .11211 L
.34309 .07557 L
.3815 .04821 L
.40095 .03726 L
.42237 .02747 L
.44268 .02038 L
.45178 .0179 L
.46172 .01568 L
.4671 .01469 L
.4721 .0139 L
.47727 .01322 L
.48196 .01273 L
.48658 .01235 L
.4887 .01222 L
.49093 .0121 L
.49332 .012 L
.49438 .01197 L
.49552 .01194 L
.49675 .01191 L
.49789 .0119 L
.49859 .01189 L
.49925 .01189 L
.50049 .01189 L
.50163 .01189 L
.50286 .01191 L
.50401 .01193 L
.50508 .01195 L
.50754 .01203 L
.51014 .01215 L
.51268 .0123 L
.51504 .01247 L
.5204 .01296 L
.5293 .01411 L
.53882 .01578 L
.54906 .01811 L
.56016 .02125 L
.58032 .02857 L
.60019 .03785 L
.62123 .0499 L
.65912 .07738 L
.69946 .11479 L
.73829 .15875 L
.77956 .21404 L
Mistroke
.81932 .27563 L
.85757 .34259 L
.89827 .42215 L
.93745 .50684 L
.97619 .5984 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooo0P00001g0?ooo`P0o`00O`3oool000030?ooo`000000000000@00000
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo1`3o00070?ooo`030000
o`3o0000o`0000D0o`0000<0003o0?ooo`3oool0M@3oool000d0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1Z0?ooo`80003o0`3o000F0?ooo`<0o`00M@3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1W0?ooo`030000o`3o0000o`000080o`00703oool3
0?l00780oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`1U0?ooo`<0o`008`3oool20?l0
0700oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H`3oool20?l002P0
oooo0`3o001]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80o`00;@3oool30?l006X0oooo
000E0?ooo`800000H03oool00`000?l0o`000?ooo`0`0?ooo`030000o`3o0000o`0006P0oooo000E
0?ooo`030000003oool0oooo05d0oooo00<0003o0?l0003o0000=03oool00`000?l0o`000?l0001V
0?ooo`005@3oool00`000000oooo0?ooo`1K0?ooo`030000o`3o0000o`0003P0oooo00<0003o0?l0
003o0000I03oool001D0oooo00<000000?ooo`3oool0F@3oool00`000?l0o`000?l0000l0?ooo`03
0000o`3o0000oooo0680oooo000E0?ooo`030000003oool0oooo05L0oooo00<0003o0?l0003o0000
@03oool20?l00640oooo000E0?ooo`030000003oool0oooo05H0oooo00<0003o0?l0003oool0@`3o
ool00`3o0000003o0?ooo`1N0?ooo`005@3oool2000005D0oooo0P000?l00`3o0000oooo0?ooo`14
0?ooo`030?l000000?l0oooo05d0oooo000E0?ooo`030000003oool0oooo0580oooo0P000?l20?l0
04P0oooo0P3o00000`000?l0oooo0?ooo`1J0?ooo`005@3oool00`000000oooo0?ooo`1A0?ooo`03
0000o`3oool0o`0004`0oooo00<0o`000000o`000?l0FP3oool001D0oooo00<000000?ooo`3oool0
8@3oool700000240oooo1P0000020000o`80o`007P3oool4000002D0oooo100000030?ooo`80o`00
00<0003o0?ooo`3oool06`3oool4000002@0oooo1000000@0?ooo`005@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool00`000?l0oooo0?l0
000O0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`040?ooo`030?l000000?l0003o01X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool001D0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`060000003oool0oooo0000o`3oool0o`00
9@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0oooo00<0o`000?ooo`000?l0
7P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
3@3oool001D0oooo0P00000U0?ooo`030000003oool0oooo02@0oooo0P000?l00`3oool0o`000?oo
o`0U0?ooo`030000003oool0oooo0200oooo1P0000070?ooo`030?l0003oool0003o01d0oooo00<0
00000?ooo`3oool0803oool2000000<0oooo00<000000?ooo`3oool03@3oool001D0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`040000o`3oool000000?l002D0oooo0P00
000T0?ooo`040000003oool0oooo000000T0oooo00@0o`000?ooo`000?l0003o6`3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0000000800000403oool001D0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`0R0?ooo`050000o`3oool0oooo0?l0000000009`3oool00`000000
oooo0?ooo`0Q0?ooo`040000003oool0oooo000000X0oooo00@0o`000?ooo`3oool0003o5P3oool4
000002<0oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0P0?ooo`80003o00<000000?ooo`3o00000P3oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`0000002`3oool20?l000030?ooo`000?l0oooo
01@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0A0?ooo`005@3oool00`000000
oooo0?ooo`0R0?ooo`<000008@3oool01@000?l0oooo0?ooo`000000o`0000<0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0280oooo00<000000?oo
o`0000003@3oool0103o0000oooo0000o`000?lC0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0M0?oo
o`80003o0`3oool00`3o0000000000000002000002<0oooo1000000V0?ooo`8000003P3oool0103o
0000oooo0?ooo`000?lB0?ooo`D000009@3oool3000000l0oooo000E0?ooo`800000A03oool00`00
0?l0oooo0?ooo`020?ooo`030?l0003oool0oooo0640oooo00@0o`000?ooo`3oool0003oC@3oool0
01D0oooo00<000000?ooo`3oool0@P3oool00`000?l0oooo0?ooo`020?ooo`030?l0003oool0oooo
06<0oooo00<0o`000?ooo`3oool00P000?m;0?ooo`005@3oool00`000000oooo0?ooo`100?ooo`80
003o103oool00`3o0000oooo0?ooo`1U0?ooo`050?l0003oool0oooo0?ooo`000?l0BP3oool001D0
oooo00<000000?ooo`3oool0?`3oool00`000?l0oooo0?ooo`030?ooo`030?l0003oool0oooo06L0
oooo00D0o`000?ooo`3oool0oooo0000o`190?ooo`005@3oool00`000000oooo0?ooo`0n0?ooo`03
0000o`3oool0oooo00<0oooo00<0o`000?ooo`3oool0J@3oool01@3o0000oooo0?ooo`3oool0003o
04P0oooo000E0?ooo`030000003oool0oooo03`0oooo0P000?l50?ooo`030?l0003oool0oooo06X0
oooo00<0o`000?ooo`3oool00P3oool20000odH0oooo000?0?oood@0000000<0003o000000000000
100000000`3o000000000000001/000000030?l000000000000000<0000000<0003o000000000000
@`00000001D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000o`3o
ool0000000@0oooo00@0o`000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030?l0
00000000oooo00<0oooo00@0003o0?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0A0?ooo`80003o
1P3oool00`3o0000oooo0?ooo`090?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo00<0oooo0P000?l80?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool03`3oool001D0oooo00<000000?ooo`3oool0=`3o
ool00`000?l0oooo0?ooo`060?ooo`030?l0003oool0oooo0740oooo00<0o`000?ooo`3oool0103o
ool00`000?l0oooo0?ooo`0o0?ooo`005@3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0
oooo00H0oooo00<0o`000?ooo`3oool0L`3oool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0
oooo03h0oooo000E0?ooo`030000003oool0oooo03D0oooo00<0003o0?ooo`3oool01P3oool00`3o
0000oooo0?ooo`1d0?ooo`030?l0003oool0oooo00D0oooo0P000?ln0?ooo`005@3oool00`000000
oooo0?ooo`0c0?ooo`80003o203oool00`3o0000oooo0?ooo`1f0?ooo`030?l0003oool0oooo00H0
oooo00<0003o0?ooo`3oool0>`3oool001D0oooo0P00000c0?ooo`030000o`3oool0oooo00L0oooo
00<0o`000?ooo`3oool0N03oool00`3o0000oooo0?ooo`060?ooo`80003o>`3oool001D0oooo00<0
00000?ooo`3oool0<@3oool00`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo07X0oooo00<0
o`000?ooo`3oool01`3oool00`000?l0oooo0?ooo`0h0?ooo`005@3oool00`000000oooo0?ooo`0_
0?ooo`80003o2@3oool00`3o0000oooo0?ooo`1l0?ooo`030?l0003oool0oooo00L0oooo0P000?lh
0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooo`030000o`3oool0oooo00P0oooo00<0o`000?oo
o`3oool0OP3oool00`3o0000oooo0?ooo`080?ooo`030000o`3oool0oooo03D0oooo000E0?ooo`03
0000003oool0oooo02d0oooo00<0003o0?ooo`3oool02@3oool00`3o0000oooo0?ooo`1n0?ooo`03
0?l0003oool0oooo00T0oooo00<0003o0?ooo`3oool0=03oool001D0oooo00<000000?ooo`3oool0
:`3oool20000o`/0oooo00<0o`000?ooo`3oool0P03oool00`3o0000oooo0?ooo`090?ooo`80003o
=03oool001D0oooo0P00000[0?ooo`030000o`3oool0oooo00X0oooo00<0o`000?ooo`3oool0PP3o
ool00`3o0000oooo0?ooo`0:0?ooo`030000o`3oool0oooo0340oooo000E0?ooo`030000003oool0
oooo02T0oooo00<0003o0?ooo`3oool02P3oool00`3o0000oooo0?ooo`240?ooo`030?l0003oool0
oooo00X0oooo00<0003o0?ooo`3oool0<03oool001D0oooo00<000000?ooo`3oool09`3oool20000
o`d0oooo00<0o`000?ooo`3oool0Q03oool00`3o0000oooo0?ooo`0;0?ooo`80003o<03oool001D0
oooo00<000000?ooo`3oool09P3oool00`000?l0oooo0?ooo`0<0?ooo`030?l0003oool0oooo08H0
oooo00<0o`000?ooo`3oool0303oool00`000?l0oooo0?ooo`0]0?ooo`005@3oool00`000000oooo
0?ooo`0T0?ooo`80003o3P3oool00`3o0000oooo0?ooo`280?ooo`030?l0003oool0oooo00`0oooo
0P000?l]0?ooo`005@3oool00`000000oooo0?ooo`0R0?ooo`80003o3`3oool00`3o0000oooo0?oo
o`2:0?ooo`030?l0003oool0oooo00d0oooo0P000?l[0?ooo`005@3oool200000280oooo00<0003o
0?ooo`3oool03`3oool00`3o0000oooo0?ooo`2;0?ooo`030?l0003oool0oooo00h0oooo00<0003o
0?ooo`3oool0:03oool001D0oooo00<000000?ooo`3oool07`3oool20000oa40oooo00<0o`000?oo
o`3oool0S03oool00`3o0000oooo0?ooo`0?0?ooo`80003o:03oool001D0oooo00<000000?ooo`3o
ool07@3oool20000oa80oooo00<0o`000?ooo`3oool0SP3oool00`3o0000oooo0?ooo`0@0?ooo`80
003o9P3oool001D0oooo00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`0A0?ooo`030?l0
003oool0oooo0900oooo00<0o`000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0S0?ooo`005@3o
ool00`000000oooo0?ooo`0J0?ooo`80003o503oool00`3o0000oooo0?ooo`2A0?ooo`030?l0003o
ool0oooo0140oooo0P000?lS0?ooo`005@3oool00`000000oooo0?ooo`0H0?ooo`80003o5@3oool0
0`3o0000oooo0?ooo`2B0?ooo`030?l0003oool0oooo01<0oooo0P000?lQ0?ooo`005@3oool20000
01L0oooo0P000?lF0?ooo`030?l0003oool0oooo09@0oooo00<0o`000?ooo`3oool0503oool20000
oal0oooo000E0?ooo`030000003oool0oooo01@0oooo0P000?lH0?ooo`030?l0003oool0oooo09@0
oooo00<0o`000?ooo`3oool05P3oool30000oa`0oooo000E0?ooo`030000003oool0oooo0140oooo
0`000?lI0?ooo`030?l0003oool0oooo09H0oooo00<0o`000?ooo`3oool0603oool30000oaT0oooo
000:0?ooo`L00000103oool00`000000oooo0?ooo`0>0?ooo`<0003o6`3oool00`3o0000oooo0?oo
o`2H0?ooo`030?l0003oool0oooo01X0oooo0P000?lG0?ooo`003@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00`0oooo0P000?lN0?ooo`030?l0003oool0oooo09P0oooo00<0o`00
0?ooo`3oool0703oool30000oa@0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool02@3oool30000oal0oooo00<0o`000?ooo`3oool0VP3oool00`3o0000oooo0?ooo`0N0?oo
o`80003o4P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090000ob80
oooo00<0o`000?ooo`3oool0V`3oool00`3o0000oooo0?ooo`0O0?ooo`X0003o203oool000d0oooo
00<000000?ooo`3oool01@3oool30000obX0oooo00<0o`000?ooo`3oool0W03oool00`3o0000oooo
0?ooo`0X0?ooo`<0003o1P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0Y0?ooo`030?l0003oool0oooo09h0oooo00<0o`000?ooo`3oool0<03oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo09h0oooo00<0o`00
0?ooo`3oool0<03oool000/0oooo0`0000070?ooo`030000003oool0oooo02P0oooo00<0o`000?oo
o`3oool0X03oool00`3o0000oooo0?ooo`0_0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo02L0oooo00<0o`000?ooo`3oool0XP3oool00`3o0000oooo0?ooo`0^0?ooo`00
5@3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo0:80oooo00<0o`000?ooo`3oool0
;P3oool001D0oooo0P00000W0?ooo`030?l0003oool0oooo0:@0oooo00<0o`000?ooo`3oool0;@3o
ool001D0oooo00<000000?ooo`3oool09@3oool00`3o0000oooo0?ooo`2V0?ooo`030?l0003oool0
oooo02`0oooo000E0?ooo`030000003oool0oooo02D0oooo00<0o`000?ooo`3oool0YP3oool00`3o
0000oooo0?ooo`0/0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030?l0003oool0oooo0:P0
oooo00<0o`000?ooo`3oool0:`3oool001D0oooo00<000000?ooo`3oool0903oool00`3o0000oooo
0?ooo`2X0?ooo`030?l0003oool0oooo02/0oooo000E0?ooo`030000003oool0oooo02<0oooo00<0
o`000?ooo`3oool0ZP3oool00`3o0000oooo0?ooo`0Z0?ooo`005@3oool2000002<0oooo00<0o`00
0?ooo`3oool0Z`3oool00`3o0000oooo0?ooo`0Z0?ooo`005@3oool00`000000oooo0?ooo`0R0?oo
o`030?l0003oool0oooo0:`0oooo00<0o`000?ooo`3oool0:@3oool001D0oooo00<000000?ooo`3o
ool08@3oool00`3o0000oooo0?ooo`2]0?ooo`030?l0003oool0oooo02T0oooo000E0?ooo`030000
003oool0oooo0240oooo00<0o`000?ooo`3oool0[P3oool00`3o0000oooo0?ooo`0X0?ooo`005@3o
ool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0;00oooo00<0o`000?ooo`3oool09`3o
ool001D0oooo00<000000?ooo`3oool0803oool00`3o0000oooo0?ooo`2`0?ooo`030?l0003oool0
oooo02L0oooo000E0?ooo`800000803oool00`3o0000oooo0?ooo`2b0?ooo`030?l0003oool0oooo
02H0oooo000E0?ooo`030000003oool0oooo01h0oooo00<0o`000?ooo`3oool0/`3oool00`3o0000
oooo0?ooo`0V0?ooo`005@3oool00`000000oooo0?ooo`0N0?ooo`030?l0003oool0oooo0;@0oooo
00<0o`000?ooo`3oool09@3oool001D0oooo00<000000?ooo`3oool07@3oool00`3o0000oooo0?oo
o`2e0?ooo`030?l0003oool0oooo02D0oooo000E0?ooo`030000003oool0oooo01d0oooo00<0o`00
0?ooo`3oool0]P3oool00`3o0000oooo0?ooo`0T0?ooo`005@3oool00`000000oooo0?ooo`0L0?oo
o`030?l0003oool0oooo0;L0oooo00<0o`000?ooo`3oool0903oool001D0oooo0P00000L0?ooo`03
0?l0003oool0oooo0;T0oooo00<0o`000?ooo`3oool08`3oool001D0oooo00<000000?ooo`3oool0
6`3oool00`3o0000oooo0?ooo`2j0?ooo`030?l0003oool0oooo0280oooo000E0?ooo`030000003o
ool0oooo01X0oooo00<0o`000?ooo`3oool0^`3oool00`3o0000oooo0?ooo`0R0?ooo`002P3oool6
000000D0oooo00<000000?ooo`3oool06P3oool00`3o0000oooo0?ooo`2l0?ooo`030?l0003oool0
oooo0240oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0I0?ooo`030?l0003oool0oooo0;d0oooo00<0o`000?ooo`3oool08@3oool000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030?l0003oool0oooo0;h0
oooo00<0o`000?ooo`3oool0803oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0H0?ooo`030?l0003oool0oooo0;l0oooo00<0o`000?ooo`3oool0803oool000d0oooo00<0
00000?ooo`3oool01@3oool2000001T0oooo00<0o`000?ooo`3oool0`03oool00`3o0000oooo0?oo
o`0O0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo00<0o`00
0?ooo`3oool0`@3oool00`3o0000oooo0?ooo`0O0?ooo`002P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0?ooo`320?oo
o`030?l0003oool0oooo01h0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0F0?ooo`030?l0003oool0oooo0<<0oooo00<0o`000?ooo`3o
ool07P3oool000/0oooo100000060?ooo`030000003oool0oooo01H0oooo00<0o`000?ooo`3oool0
a03oool00`3o0000oooo0?ooo`0M0?ooo`005@3oool00`000000oooo0?ooo`0E0?ooo`030?l0003o
ool0oooo0<D0oooo00<0o`000?ooo`3oool07@3oool001D0oooo0P00000F0?ooo`030?l0003oool0
oooo0<H0oooo00<0o`000?ooo`3oool0703oool001D0oooo00<000000?ooo`3oool0503oool00`3o
0000oooo0?ooo`370?ooo`030?l0003oool0oooo01`0oooo000E0?ooo`030000003oool0oooo01@0
oooo00<0o`000?ooo`3oool0b03oool00`3o0000oooo0?ooo`0K0?ooo`005@3oool00`000000oooo
0?ooo`0C0?ooo`030?l0003oool0oooo0<T0oooo00<0o`000?ooo`3oool06`3oool001D0oooo00<0
00000?ooo`3oool04`3oool00`3o0000oooo0?ooo`3:0?ooo`030?l0003oool0oooo01X0oooo000E
0?ooo`030000003oool0oooo0180oooo00<0o`000?ooo`3oool0b`3oool00`3o0000oooo0?ooo`0J
0?ooo`005@3oool2000001<0oooo00<0o`000?ooo`3oool0c03oool00`3o0000oooo0?ooo`0I0?oo
o`005@3oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo0<`0oooo00<0o`000?ooo`3o
ool06@3oool001D0oooo00<000000?ooo`3oool04@3oool00`3o0000oooo0?ooo`3>0?ooo`030?l0
003oool0oooo01P0oooo000E0?ooo`030000003oool0oooo0140oooo00<0o`000?ooo`3oool0cP3o
ool00`3o0000oooo0?ooo`0H0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`030?l0003oool0
oooo0=00oooo00<0o`000?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool0403oool00`3o
0000oooo0?ooo`3@0?ooo`030?l0003oool0oooo01L0oooo000E0?ooo`800000403oool00`3o0000
oooo0?ooo`3B0?ooo`030?l0003oool0oooo01H0oooo000E0?ooo`030000003oool0oooo00l0oooo
00<0o`000?ooo`3oool0dP3oool00`3o0000oooo0?ooo`0F0?ooo`005@3oool00`000000oooo0?oo
o`0>0?ooo`030?l0003oool0oooo0=@0oooo00<0o`000?ooo`3oool05@3oool001D0oooo00<00000
0?ooo`3oool03P3oool00`3o0000oooo0?ooo`3D0?ooo`030?l0003oool0oooo01D0oooo000E0?oo
o`030000003oool0oooo00d0oooo00<0o`000?ooo`3oool0eP3oool00`3o0000oooo0?ooo`0D0?oo
o`005@3oool00`000000oooo0?ooo`0=0?ooo`030?l0003oool0oooo0=H0oooo00<0o`000?ooo`3o
ool0503oool001D0oooo00<000000?ooo`3oool0303oool00`3o0000oooo0?ooo`3H0?ooo`030?l0
003oool0oooo01<0oooo000E0?ooo`8000003@3oool00`3o0000oooo0?ooo`3H0?ooo`030?l0003o
ool0oooo01<0oooo000E0?ooo`030000003oool0oooo00`0oooo00<0o`000?ooo`3oool0f03oool0
0`3o0000oooo0?ooo`0C0?ooo`002`3oool4000000H0oooo00<000000?ooo`3oool02`3oool00`3o
0000oooo0?ooo`3J0?ooo`030?l0003oool0oooo0180oooo000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030?l0003oool0oooo0=X0
oooo00<0o`000?ooo`3oool04P3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0:0?ooo`030?l0003oool0oooo0=`0oooo00<0o`000?ooo`3oool04@3oool000l0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo0=`0oooo00<0
o`000?ooo`3oool04@3oool000d0oooo0P0000060?ooo`8000002P3oool00`3o0000oooo0?ooo`3N
0?ooo`030?l0003oool0oooo0100oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02@3oool00`3o0000oooo0?ooo`3N0?ooo`030?l0003oool0oooo0100oooo000?0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00`3o0000oooo0?ooo`3P0?ooo`03
0?l0003oool0oooo00l0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`080?ooo`030?l0003oool0oooo0>00oooo00<0o`000?ooo`3oool0
3`3oool000/0oooo100000060?ooo`030000003oool0oooo00L0oooo00<0o`000?ooo`3oool0hP3o
ool00`3o0000oooo0?ooo`0>0?ooo`005@3oool00`000000oooo0?ooo`070?ooo`030?l0003oool0
oooo0>80oooo00<0o`000?ooo`3oool03P3oool001D0oooo0P0000080?ooo`030?l0003oool0oooo
0>80oooo00<0o`000?ooo`3oool03P3oool001D0oooo00<000000?ooo`3oool01P3oool00`3o0000
oooo0?ooo`3T0?ooo`030?l0003oool0oooo00d0oooo000E0?ooo`030000003oool0oooo00H0oooo
00<0o`000?ooo`3oool0i03oool00`3o0000oooo0?ooo`0=0?ooo`005@3oool00`000000oooo0?oo
o`050?ooo`030?l0003oool0oooo0>H0oooo00<0o`000?ooo`3oool0303oool001D0oooo00<00000
0?ooo`3oool01@3oool00`3o0000oooo0?ooo`3V0?ooo`030?l0003oool0oooo00`0oooo000E0?oo
o`030000003oool0oooo00@0oooo00<0o`000?ooo`3oool0i`3oool00`3o0000oooo0?ooo`0<0?oo
o`005@3oool2000000D0oooo00<0o`000?ooo`3oool0j03oool00`3o0000oooo0?ooo`0;0?ooo`00
5@3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo0>P0oooo00<0o`000?ooo`3oool0
2`3oool001D0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`3Z0?ooo`030?l0003o
ool0oooo00X0oooo000E0?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3oool0jP3oool0
0`3o0000oooo0?ooo`0:0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo
0>`0oooo00<0o`000?ooo`3oool02@3oool001D0oooo00<000000?ooo`3oool00P3oool00`3o0000
oooo0?ooo`3/0?ooo`030?l0003oool0oooo00T0oooo000E0?ooo`8000000`3oool00`3o0000oooo
0?ooo`3/0?ooo`030?l0003oool0oooo00T0oooo000E0?ooo`050000003oool0oooo0?ooo`3o0000
l03oool00`3o0000oooo0?ooo`080?ooo`005@3oool01@000000oooo0?ooo`3oool0o`000?00oooo
00<0o`000?ooo`3oool0203oool001D0oooo00@000000?ooo`3oool0o`00lP3oool00`3o0000oooo
0?ooo`070?ooo`005@3oool010000000oooo0?ooo`3o003b0?ooo`030?l0003oool0oooo00L0oooo
000E0?ooo`030000003oool0o`000?<0oooo00<0o`000?ooo`3oool01`3oool001D0oooo00<00000
0?ooo`3o0000m03oool00`3o0000oooo0?ooo`060?ooo`005@3oool2000000030?l0003oool0oooo
0?80oooo00<0o`000?ooo`3oool01P3oool001D0oooo00<000000?l0003oool0m@3oool00`3o0000
oooo0?ooo`050?ooo`00303oool4000000D0oooo00<000000?l0003oool0m@3oool00`3o0000oooo
0?ooo`050?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo0?H0oooo00<0
o`000?ooo`3oool0103oool000h0oooo00<000000?ooo`3oool0103oool00`3o0000oooo0?ooo`3f
0?ooo`030?l0003oool0oooo00@0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?oo
o`002`3oool010000000oooo0?ooo`0000060?ooo`800000oP3oool000/0oooo00@000000?ooo`3o
ool000001P3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo000000060?ooo`03
0000003oool0oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0
o@3oool000d0oooo0P00003o0?ooo`L0oooo003o0?oooaH0oooo003o0?oooaH0oooo003o0?oooaH0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .5984 m
.06244 .50709 L
.10458 .41631 L
.14415 .33941 L
.18221 .2731 L
.22272 .21075 L
.26171 .15875 L
.30316 .11211 L
.34309 .07557 L
.3815 .04821 L
.40095 .03726 L
.42237 .02747 L
.44268 .02038 L
.45178 .0179 L
.46172 .01568 L
.4671 .01469 L
.4721 .0139 L
.47727 .01322 L
.48196 .01273 L
.48658 .01235 L
.4887 .01222 L
.49093 .0121 L
.49332 .012 L
.49438 .01197 L
.49552 .01194 L
.49675 .01191 L
.49789 .0119 L
.49859 .01189 L
.49925 .01189 L
.50049 .01189 L
.50163 .01189 L
.50286 .01191 L
.50401 .01193 L
.50508 .01195 L
.50754 .01203 L
.51014 .01215 L
.51268 .0123 L
.51504 .01247 L
.5204 .01296 L
.5293 .01411 L
.53882 .01578 L
.54906 .01811 L
.56016 .02125 L
.58032 .02857 L
.60019 .03785 L
.62123 .0499 L
.65912 .07738 L
.69946 .11479 L
.73829 .15875 L
.77956 .21404 L
Mistroke
.81932 .27563 L
.85757 .34259 L
.89827 .42215 L
.93745 .50684 L
.97619 .5984 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooo0P00001g0?ooo`P0o`00O`3oool000030?ooo`000000000000@00000
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo1`3o00070?ooo`030000
o`3o0000o`0000D0o`0000<0003o0?ooo`3oool0M@3oool000d0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1Z0?ooo`80003o0`3o000F0?ooo`<0o`00M@3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1W0?ooo`030000o`3o0000o`000080o`00703oool3
0?l00780oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`1U0?ooo`<0o`008`3oool20?l0
0700oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H`3oool20?l002P0
oooo0`3o001]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80o`00;@3oool30?l006X0oooo
000E0?ooo`800000H03oool00`000?l0o`000?ooo`0`0?ooo`030000o`3o0000o`0006P0oooo000E
0?ooo`030000003oool0oooo05d0oooo00<0003o0?l0003o0000=03oool00`000?l0o`000?l0001V
0?ooo`005@3oool00`000000oooo0?ooo`1K0?ooo`030000o`3o0000o`0003P0oooo00<0003o0?l0
003o0000I03oool001D0oooo00<000000?ooo`3oool0F@3oool00`000?l0o`000?l0000l0?ooo`03
0000o`3o0000oooo0680oooo000E0?ooo`030000003oool0oooo05L0oooo00<0003o0?l0003o0000
@03oool20?l00640oooo000E0?ooo`030000003oool0oooo05H0oooo00<0003o0?l0003oool0@`3o
ool00`3o0000003o0?ooo`1N0?ooo`005@3oool2000005D0oooo0P000?l00`3o0000oooo0?ooo`14
0?ooo`030?l000000?l0oooo05d0oooo000E0?ooo`030000003oool0oooo0580oooo0P000?l20?l0
04P0oooo0P3o00000`000?l0oooo0?ooo`1J0?ooo`005@3oool00`000000oooo0?ooo`1A0?ooo`03
0000o`3oool0o`0004`0oooo00<0o`000000o`000?l0FP3oool001D0oooo00<000000?ooo`3oool0
8@3oool700000240oooo1P0000020000o`80o`007P3oool4000002D0oooo100000030?ooo`80o`00
00<0003o0?ooo`3oool06`3oool4000002@0oooo1000000@0?ooo`005@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool00`000?l0oooo0?l0
000O0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0903oool00`000000oooo0?oo
o`040?ooo`030?l000000?l0003o01X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool001D0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`060000003oool0oooo0000o`3oool0o`00
9@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0oooo00<0o`000?ooo`000?l0
7P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
3@3oool001D0oooo0P00000U0?ooo`030000003oool0oooo02@0oooo0P000?l00`3oool0o`000?oo
o`0U0?ooo`030000003oool0oooo0200oooo1P0000070?ooo`030?l0003oool0003o01d0oooo00<0
00000?ooo`3oool0803oool2000000<0oooo00<000000?ooo`3oool03@3oool001D0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`040000o`3oool000000?l002D0oooo0P00
000T0?ooo`040000003oool0oooo000000T0oooo00@0o`000?ooo`000?l0003o6`3oool00`000000
oooo0?ooo`0P0?ooo`030000003oool0000000800000403oool001D0oooo00<000000?ooo`3oool0
903oool00`000000oooo0?ooo`0R0?ooo`050000o`3oool0oooo0?l0000000009`3oool00`000000
oooo0?ooo`0Q0?ooo`040000003oool0oooo000000X0oooo00@0o`000?ooo`3oool0003o5P3oool4
000002<0oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0P0?ooo`80003o00<000000?ooo`3o00000P3oool00`000000oooo0?ooo`0T0?oo
o`030000003oool0oooo0280oooo00<000000?ooo`0000002`3oool20?l000030?ooo`000?l0oooo
01@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0A0?ooo`005@3oool00`000000
oooo0?ooo`0R0?ooo`<000008@3oool01@000?l0oooo0?ooo`000000o`0000<0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0280oooo00<000000?oo
o`0000003@3oool0103o0000oooo0000o`000?lC0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0M0?oo
o`80003o0`3oool00`3o0000000000000002000002<0oooo1000000V0?ooo`8000003P3oool0103o
0000oooo0?ooo`000?lB0?ooo`D000009@3oool3000000l0oooo000E0?ooo`800000A03oool00`00
0?l0oooo0?ooo`020?ooo`030?l0003oool0oooo0640oooo00@0o`000?ooo`3oool0003oC@3oool0
01D0oooo00<000000?ooo`3oool0@P3oool00`000?l0oooo0?ooo`020?ooo`030?l0003oool0oooo
06<0oooo00<0o`000?ooo`3oool00P000?m;0?ooo`005@3oool00`000000oooo0?ooo`100?ooo`80
003o103oool00`3o0000oooo0?ooo`1U0?ooo`050?l0003oool0oooo0?ooo`000?l0BP3oool001D0
oooo00<000000?ooo`3oool0?`3oool00`000?l0oooo0?ooo`030?ooo`030?l0003oool0oooo06L0
oooo00D0o`000?ooo`3oool0oooo0000o`190?ooo`005@3oool00`000000oooo0?ooo`0n0?ooo`03
0000o`3oool0oooo00<0oooo00<0o`000?ooo`3oool0J@3oool01@3o0000oooo0?ooo`3oool0003o
04P0oooo000E0?ooo`030000003oool0oooo03`0oooo0P000?l50?ooo`030?l0003oool0oooo06X0
oooo00<0o`000?ooo`3oool00P3oool20000odH0oooo000?0?oood@0000000<0003o000000000000
100000000`3o000000000000001/000000030?l000000000000000<0000000<0003o000000000000
@`00000001D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000o`3o
ool0000000@0oooo00@0o`000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030?l0
00000000oooo00<0oooo00@0003o0?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`40
00000@3oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0A0?ooo`80003o
1P3oool00`3o0000oooo0?ooo`090?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
9@3oool00`000000oooo0?ooo`0D0?ooo`030?l0003oool0oooo00<0oooo0P000?l80?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool03`3oool001D0oooo00<000000?ooo`3oool0=`3o
ool00`000?l0oooo0?ooo`060?ooo`030?l0003oool0oooo0740oooo00<0o`000?ooo`3oool0103o
ool00`000?l0oooo0?ooo`0o0?ooo`005@3oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0
oooo00H0oooo00<0o`000?ooo`3oool0L`3oool00`3o0000oooo0?ooo`040?ooo`030000o`3oool0
oooo03h0oooo000E0?ooo`030000003oool0oooo03D0oooo00<0003o0?ooo`3oool01P3oool00`3o
0000oooo0?ooo`1d0?ooo`030?l0003oool0oooo00D0oooo0P000?ln0?ooo`005@3oool00`000000
oooo0?ooo`0c0?ooo`80003o203oool00`3o0000oooo0?ooo`1f0?ooo`030?l0003oool0oooo00H0
oooo00<0003o0?ooo`3oool0>`3oool001D0oooo0P00000c0?ooo`030000o`3oool0oooo00L0oooo
00<0o`000?ooo`3oool0N03oool00`3o0000oooo0?ooo`060?ooo`80003o>`3oool001D0oooo00<0
00000?ooo`3oool0<@3oool00`000?l0oooo0?ooo`070?ooo`030?l0003oool0oooo07X0oooo00<0
o`000?ooo`3oool01`3oool00`000?l0oooo0?ooo`0h0?ooo`005@3oool00`000000oooo0?ooo`0_
0?ooo`80003o2@3oool00`3o0000oooo0?ooo`1l0?ooo`030?l0003oool0oooo00L0oooo0P000?lh
0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooo`030000o`3oool0oooo00P0oooo00<0o`000?oo
o`3oool0OP3oool00`3o0000oooo0?ooo`080?ooo`030000o`3oool0oooo03D0oooo000E0?ooo`03
0000003oool0oooo02d0oooo00<0003o0?ooo`3oool02@3oool00`3o0000oooo0?ooo`1n0?ooo`03
0?l0003oool0oooo00T0oooo00<0003o0?ooo`3oool0=03oool001D0oooo00<000000?ooo`3oool0
:`3oool20000o`/0oooo00<0o`000?ooo`3oool0P03oool00`3o0000oooo0?ooo`090?ooo`80003o
=03oool001D0oooo0P00000[0?ooo`030000o`3oool0oooo00X0oooo00<0o`000?ooo`3oool0PP3o
ool00`3o0000oooo0?ooo`0:0?ooo`030000o`3oool0oooo0340oooo000E0?ooo`030000003oool0
oooo02T0oooo00<0003o0?ooo`3oool02P3oool00`3o0000oooo0?ooo`240?ooo`030?l0003oool0
oooo00X0oooo00<0003o0?ooo`3oool0<03oool001D0oooo00<000000?ooo`3oool09`3oool20000
o`d0oooo00<0o`000?ooo`3oool0Q03oool00`3o0000oooo0?ooo`0;0?ooo`80003o<03oool001D0
oooo00<000000?ooo`3oool09P3oool00`000?l0oooo0?ooo`0<0?ooo`030?l0003oool0oooo08H0
oooo00<0o`000?ooo`3oool0303oool00`000?l0oooo0?ooo`0]0?ooo`005@3oool00`000000oooo
0?ooo`0T0?ooo`80003o3P3oool00`3o0000oooo0?ooo`280?ooo`030?l0003oool0oooo00`0oooo
0P000?l]0?ooo`005@3oool00`000000oooo0?ooo`0R0?ooo`80003o3`3oool00`3o0000oooo0?oo
o`2:0?ooo`030?l0003oool0oooo00d0oooo0P000?l[0?ooo`005@3oool200000280oooo00<0003o
0?ooo`3oool03`3oool00`3o0000oooo0?ooo`2;0?ooo`030?l0003oool0oooo00h0oooo00<0003o
0?ooo`3oool0:03oool001D0oooo00<000000?ooo`3oool07`3oool20000oa40oooo00<0o`000?oo
o`3oool0S03oool00`3o0000oooo0?ooo`0?0?ooo`80003o:03oool001D0oooo00<000000?ooo`3o
ool07@3oool20000oa80oooo00<0o`000?ooo`3oool0SP3oool00`3o0000oooo0?ooo`0@0?ooo`80
003o9P3oool001D0oooo00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`0A0?ooo`030?l0
003oool0oooo0900oooo00<0o`000?ooo`3oool04@3oool00`000?l0oooo0?ooo`0S0?ooo`005@3o
ool00`000000oooo0?ooo`0J0?ooo`80003o503oool00`3o0000oooo0?ooo`2A0?ooo`030?l0003o
ool0oooo0140oooo0P000?lS0?ooo`005@3oool00`000000oooo0?ooo`0H0?ooo`80003o5@3oool0
0`3o0000oooo0?ooo`2B0?ooo`030?l0003oool0oooo01<0oooo0P000?lQ0?ooo`005@3oool20000
01L0oooo0P000?lF0?ooo`030?l0003oool0oooo09@0oooo00<0o`000?ooo`3oool0503oool20000
oal0oooo000E0?ooo`030000003oool0oooo01@0oooo0P000?lH0?ooo`030?l0003oool0oooo09@0
oooo00<0o`000?ooo`3oool05P3oool30000oa`0oooo000E0?ooo`030000003oool0oooo0140oooo
0`000?lI0?ooo`030?l0003oool0oooo09H0oooo00<0o`000?ooo`3oool0603oool30000oaT0oooo
000:0?ooo`L00000103oool00`000000oooo0?ooo`0>0?ooo`<0003o6`3oool00`3o0000oooo0?oo
o`2H0?ooo`030?l0003oool0oooo01X0oooo0P000?lG0?ooo`003@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00`0oooo0P000?lN0?ooo`030?l0003oool0oooo09P0oooo00<0o`00
0?ooo`3oool0703oool30000oa@0oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool02@3oool30000oal0oooo00<0o`000?ooo`3oool0VP3oool00`3o0000oooo0?ooo`0N0?oo
o`80003o4P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090000ob80
oooo00<0o`000?ooo`3oool0V`3oool00`3o0000oooo0?ooo`0O0?ooo`X0003o203oool000d0oooo
00<000000?ooo`3oool01@3oool30000obX0oooo00<0o`000?ooo`3oool0W03oool00`3o0000oooo
0?ooo`0X0?ooo`<0003o1P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0Y0?ooo`030?l0003oool0oooo09h0oooo00<0o`000?ooo`3oool0<03oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo09h0oooo00<0o`00
0?ooo`3oool0<03oool000/0oooo0`0000070?ooo`030000003oool0oooo02P0oooo00<0o`000?oo
o`3oool0X03oool00`3o0000oooo0?ooo`0_0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo02L0oooo00<0o`000?ooo`3oool0XP3oool00`3o0000oooo0?ooo`0^0?ooo`00
5@3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo0:80oooo00<0o`000?ooo`3oool0
;P3oool001D0oooo0P00000W0?ooo`030?l0003oool0oooo0:@0oooo00<0o`000?ooo`3oool0;@3o
ool001D0oooo00<000000?ooo`3oool09@3oool00`3o0000oooo0?ooo`2V0?ooo`030?l0003oool0
oooo02`0oooo000E0?ooo`030000003oool0oooo02D0oooo00<0o`000?ooo`3oool0YP3oool00`3o
0000oooo0?ooo`0/0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030?l0003oool0oooo0:P0
oooo00<0o`000?ooo`3oool0:`3oool001D0oooo00<000000?ooo`3oool0903oool00`3o0000oooo
0?ooo`2X0?ooo`030?l0003oool0oooo02/0oooo000E0?ooo`030000003oool0oooo02<0oooo00<0
o`000?ooo`3oool0ZP3oool00`3o0000oooo0?ooo`0Z0?ooo`005@3oool2000002<0oooo00<0o`00
0?ooo`3oool0Z`3oool00`3o0000oooo0?ooo`0Z0?ooo`005@3oool00`000000oooo0?ooo`0R0?oo
o`030?l0003oool0oooo0:`0oooo00<0o`000?ooo`3oool0:@3oool001D0oooo00<000000?ooo`3o
ool08@3oool00`3o0000oooo0?ooo`2]0?ooo`030?l0003oool0oooo02T0oooo000E0?ooo`030000
003oool0oooo0240oooo00<0o`000?ooo`3oool0[P3oool00`3o0000oooo0?ooo`0X0?ooo`005@3o
ool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0;00oooo00<0o`000?ooo`3oool09`3o
ool001D0oooo00<000000?ooo`3oool0803oool00`3o0000oooo0?ooo`2`0?ooo`030?l0003oool0
oooo02L0oooo000E0?ooo`800000803oool00`3o0000oooo0?ooo`2b0?ooo`030?l0003oool0oooo
02H0oooo000E0?ooo`030000003oool0oooo01h0oooo00<0o`000?ooo`3oool0/`3oool00`3o0000
oooo0?ooo`0V0?ooo`005@3oool00`000000oooo0?ooo`0N0?ooo`030?l0003oool0oooo0;@0oooo
00<0o`000?ooo`3oool09@3oool001D0oooo00<000000?ooo`3oool07@3oool00`3o0000oooo0?oo
o`2e0?ooo`030?l0003oool0oooo02D0oooo000E0?ooo`030000003oool0oooo01d0oooo00<0o`00
0?ooo`3oool0]P3oool00`3o0000oooo0?ooo`0T0?ooo`005@3oool00`000000oooo0?ooo`0L0?oo
o`030?l0003oool0oooo0;L0oooo00<0o`000?ooo`3oool0903oool001D0oooo0P00000L0?ooo`03
0?l0003oool0oooo0;T0oooo00<0o`000?ooo`3oool08`3oool001D0oooo00<000000?ooo`3oool0
6`3oool00`3o0000oooo0?ooo`2j0?ooo`030?l0003oool0oooo0280oooo000E0?ooo`030000003o
ool0oooo01X0oooo00<0o`000?ooo`3oool0^`3oool00`3o0000oooo0?ooo`0R0?ooo`002P3oool6
000000D0oooo00<000000?ooo`3oool06P3oool00`3o0000oooo0?ooo`2l0?ooo`030?l0003oool0
oooo0240oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0I0?ooo`030?l0003oool0oooo0;d0oooo00<0o`000?ooo`3oool08@3oool000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0I0?ooo`030?l0003oool0oooo0;h0
oooo00<0o`000?ooo`3oool0803oool000`0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0H0?ooo`030?l0003oool0oooo0;l0oooo00<0o`000?ooo`3oool0803oool000d0oooo00<0
00000?ooo`3oool01@3oool2000001T0oooo00<0o`000?ooo`3oool0`03oool00`3o0000oooo0?oo
o`0O0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo00<0o`00
0?ooo`3oool0`@3oool00`3o0000oooo0?ooo`0O0?ooo`002P3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0?ooo`320?oo
o`030?l0003oool0oooo01h0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0F0?ooo`030?l0003oool0oooo0<<0oooo00<0o`000?ooo`3o
ool07P3oool000/0oooo100000060?ooo`030000003oool0oooo01H0oooo00<0o`000?ooo`3oool0
a03oool00`3o0000oooo0?ooo`0M0?ooo`005@3oool00`000000oooo0?ooo`0E0?ooo`030?l0003o
ool0oooo0<D0oooo00<0o`000?ooo`3oool07@3oool001D0oooo0P00000F0?ooo`030?l0003oool0
oooo0<H0oooo00<0o`000?ooo`3oool0703oool001D0oooo00<000000?ooo`3oool0503oool00`3o
0000oooo0?ooo`370?ooo`030?l0003oool0oooo01`0oooo000E0?ooo`030000003oool0oooo01@0
oooo00<0o`000?ooo`3oool0b03oool00`3o0000oooo0?ooo`0K0?ooo`005@3oool00`000000oooo
0?ooo`0C0?ooo`030?l0003oool0oooo0<T0oooo00<0o`000?ooo`3oool06`3oool001D0oooo00<0
00000?ooo`3oool04`3oool00`3o0000oooo0?ooo`3:0?ooo`030?l0003oool0oooo01X0oooo000E
0?ooo`030000003oool0oooo0180oooo00<0o`000?ooo`3oool0b`3oool00`3o0000oooo0?ooo`0J
0?ooo`005@3oool2000001<0oooo00<0o`000?ooo`3oool0c03oool00`3o0000oooo0?ooo`0I0?oo
o`005@3oool00`000000oooo0?ooo`0B0?ooo`030?l0003oool0oooo0<`0oooo00<0o`000?ooo`3o
ool06@3oool001D0oooo00<000000?ooo`3oool04@3oool00`3o0000oooo0?ooo`3>0?ooo`030?l0
003oool0oooo01P0oooo000E0?ooo`030000003oool0oooo0140oooo00<0o`000?ooo`3oool0cP3o
ool00`3o0000oooo0?ooo`0H0?ooo`005@3oool00`000000oooo0?ooo`0@0?ooo`030?l0003oool0
oooo0=00oooo00<0o`000?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool0403oool00`3o
0000oooo0?ooo`3@0?ooo`030?l0003oool0oooo01L0oooo000E0?ooo`800000403oool00`3o0000
oooo0?ooo`3B0?ooo`030?l0003oool0oooo01H0oooo000E0?ooo`030000003oool0oooo00l0oooo
00<0o`000?ooo`3oool0dP3oool00`3o0000oooo0?ooo`0F0?ooo`005@3oool00`000000oooo0?oo
o`0>0?ooo`030?l0003oool0oooo0=@0oooo00<0o`000?ooo`3oool05@3oool001D0oooo00<00000
0?ooo`3oool03P3oool00`3o0000oooo0?ooo`3D0?ooo`030?l0003oool0oooo01D0oooo000E0?oo
o`030000003oool0oooo00d0oooo00<0o`000?ooo`3oool0eP3oool00`3o0000oooo0?ooo`0D0?oo
o`005@3oool00`000000oooo0?ooo`0=0?ooo`030?l0003oool0oooo0=H0oooo00<0o`000?ooo`3o
ool0503oool001D0oooo00<000000?ooo`3oool0303oool00`3o0000oooo0?ooo`3H0?ooo`030?l0
003oool0oooo01<0oooo000E0?ooo`8000003@3oool00`3o0000oooo0?ooo`3H0?ooo`030?l0003o
ool0oooo01<0oooo000E0?ooo`030000003oool0oooo00`0oooo00<0o`000?ooo`3oool0f03oool0
0`3o0000oooo0?ooo`0C0?ooo`002`3oool4000000H0oooo00<000000?ooo`3oool02`3oool00`3o
0000oooo0?ooo`3J0?ooo`030?l0003oool0oooo0180oooo000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030?l0003oool0oooo0=X0
oooo00<0o`000?ooo`3oool04P3oool000l0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0:0?ooo`030?l0003oool0oooo0=`0oooo00<0o`000?ooo`3oool04@3oool000l0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo0=`0oooo00<0
o`000?ooo`3oool04@3oool000d0oooo0P0000060?ooo`8000002P3oool00`3o0000oooo0?ooo`3N
0?ooo`030?l0003oool0oooo0100oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool02@3oool00`3o0000oooo0?ooo`3N0?ooo`030?l0003oool0oooo0100oooo000?0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0203oool00`3o0000oooo0?ooo`3P0?ooo`03
0?l0003oool0oooo00l0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`080?ooo`030?l0003oool0oooo0>00oooo00<0o`000?ooo`3oool0
3`3oool000/0oooo100000060?ooo`030000003oool0oooo00L0oooo00<0o`000?ooo`3oool0hP3o
ool00`3o0000oooo0?ooo`0>0?ooo`005@3oool00`000000oooo0?ooo`070?ooo`030?l0003oool0
oooo0>80oooo00<0o`000?ooo`3oool03P3oool001D0oooo0P0000080?ooo`030?l0003oool0oooo
0>80oooo00<0o`000?ooo`3oool03P3oool001D0oooo00<000000?ooo`3oool01P3oool00`3o0000
oooo0?ooo`3T0?ooo`030?l0003oool0oooo00d0oooo000E0?ooo`030000003oool0oooo00H0oooo
00<0o`000?ooo`3oool0i03oool00`3o0000oooo0?ooo`0=0?ooo`005@3oool00`000000oooo0?oo
o`050?ooo`030?l0003oool0oooo0>H0oooo00<0o`000?ooo`3oool0303oool001D0oooo00<00000
0?ooo`3oool01@3oool00`3o0000oooo0?ooo`3V0?ooo`030?l0003oool0oooo00`0oooo000E0?oo
o`030000003oool0oooo00@0oooo00<0o`000?ooo`3oool0i`3oool00`3o0000oooo0?ooo`0<0?oo
o`005@3oool2000000D0oooo00<0o`000?ooo`3oool0j03oool00`3o0000oooo0?ooo`0;0?ooo`00
5@3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo0>P0oooo00<0o`000?ooo`3oool0
2`3oool001D0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`3Z0?ooo`030?l0003o
ool0oooo00X0oooo000E0?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3oool0jP3oool0
0`3o0000oooo0?ooo`0:0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo
0>`0oooo00<0o`000?ooo`3oool02@3oool001D0oooo00<000000?ooo`3oool00P3oool00`3o0000
oooo0?ooo`3/0?ooo`030?l0003oool0oooo00T0oooo000E0?ooo`8000000`3oool00`3o0000oooo
0?ooo`3/0?ooo`030?l0003oool0oooo00T0oooo000E0?ooo`050000003oool0oooo0?ooo`3o0000
l03oool00`3o0000oooo0?ooo`080?ooo`005@3oool01@000000oooo0?ooo`3oool0o`000?00oooo
00<0o`000?ooo`3oool0203oool001D0oooo00@000000?ooo`3oool0o`00lP3oool00`3o0000oooo
0?ooo`070?ooo`005@3oool010000000oooo0?ooo`3o003b0?ooo`030?l0003oool0oooo00L0oooo
000E0?ooo`030000003oool0o`000?<0oooo00<0o`000?ooo`3oool01`3oool001D0oooo00<00000
0?ooo`3o0000m03oool00`3o0000oooo0?ooo`060?ooo`005@3oool2000000030?l0003oool0oooo
0?80oooo00<0o`000?ooo`3oool01P3oool001D0oooo00<000000?l0003oool0m@3oool00`3o0000
oooo0?ooo`050?ooo`00303oool4000000D0oooo00<000000?l0003oool0m@3oool00`3o0000oooo
0?ooo`050?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo0?H0oooo00<0
o`000?ooo`3oool0103oool000h0oooo00<000000?ooo`3oool0103oool00`3o0000oooo0?ooo`3f
0?ooo`030?l0003oool0oooo00@0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?oo
o`002`3oool010000000oooo0?ooo`0000060?ooo`800000oP3oool000/0oooo00@000000?ooo`3o
ool000001P3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo000000060?ooo`03
0000003oool0oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0
o@3oool000d0oooo0P00003o0?ooo`L0oooo003o0?oooaH0oooo003o0?oooaH0oooo003o0?oooaH0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .11601 m
.04262 .14241 L
.06244 .16321 L
.07286 .1715 L
.08255 .17773 L
.0932 .183 L
.09916 .18528 L
.10458 .18695 L
.10941 .18814 L
.11206 .18866 L
.11454 .18908 L
.11891 .18965 L
.12123 .18987 L
.12244 .18996 L
.12373 .19003 L
.12445 .19007 L
.12511 .1901 L
.12639 .19014 L
.12711 .19015 L
.12788 .19016 L
.12862 .19016 L
.12929 .19016 L
.13052 .19015 L
.13121 .19013 L
.13186 .19011 L
.13317 .19006 L
.13458 .18999 L
.13725 .1898 L
.13977 .18955 L
.14451 .18893 L
.1491 .18813 L
.15416 .18704 L
.16442 .18419 L
.18284 .17714 L
.20219 .16749 L
.22304 .15509 L
.26418 .12671 L
.30381 .09755 L
.34191 .07067 L
.38248 .04582 L
.42152 .02746 L
.44287 .02023 L
.45266 .01764 L
.46302 .01541 L
.47255 .01383 L
.47797 .01314 L
.48303 .01263 L
.48542 .01243 L
.48768 .01228 L
.48974 .01216 L
Mistroke
.49193 .01205 L
.49317 .01201 L
.4943 .01197 L
.49545 .01194 L
.4965 .01192 L
.49774 .0119 L
.49838 .01189 L
.49907 .01189 L
.50022 .01189 L
.50148 .01189 L
.50279 .01191 L
.504 .01193 L
.50533 .01196 L
.50674 .012 L
.50911 .0121 L
.51172 .01224 L
.51652 .01259 L
.52103 .01303 L
.53111 .01438 L
.54196 .01641 L
.56204 .0217 L
.58315 .02932 L
.62131 .04792 L
.66193 .07326 L
.70102 .10109 L
.74257 .1316 L
.78261 .15862 L
.80096 .1692 L
.82113 .17885 L
.83073 .18256 L
.84104 .18581 L
.84673 .18725 L
.85193 .18833 L
.85715 .18917 L
.8597 .18949 L
.8621 .18974 L
.8643 .18992 L
.86544 .18999 L
.86668 .19006 L
.86796 .19011 L
.86866 .19013 L
.86932 .19014 L
.87049 .19016 L
.87174 .19016 L
.87242 .19016 L
.87306 .19015 L
.87376 .19013 L
.8745 .19011 L
.87574 .19006 L
.8771 .18999 L
Mistroke
.87962 .1898 L
.88198 .18955 L
.88662 .1889 L
.89086 .18808 L
.89575 .18686 L
.9004 .18543 L
.90999 .18158 L
.92022 .17609 L
.93861 .16227 L
.95796 .14169 L
.97619 .11601 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooo0P00001g0?ooo`P0o`00O`3oool000030?ooo`000000000000@00000
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo1`3o00070?ooo`030000
o`3o0000o`0000<0o`000`000?mg0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo06X0oooo0`000?l20?l001@0oooo103o00000`000?l0oooo0?ooo`1c0?ooo`003@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo06L0oooo0P000?l40?l001X0oooo1@3o001a
0?ooo`002`3oool3000000L0oooo00<000000?ooo`3oool0I@3oool40?l00280oooo00<0003o0?l0
003o0000K`3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`80
o`00:03oool00`000?l0o`000?l0001]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80o`00
;@3oool20?l006/0oooo000E0?ooo`800000H03oool20?l00340oooo0P3o001Y0?ooo`005@3oool0
0`000000oooo0?ooo`1M0?ooo`80o`00=@3oool20?l006L0oooo000E0?ooo`030000003oool0oooo
05/0oooo0P3o000i0?ooo`80o`00I@3oool001D0oooo00<000000?ooo`3oool0F@3oool20?l003d0
oooo0P3o001S0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030000o`3o0000oooo0400oooo
0P3o001Q0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`80o`00A03oool20?l005l0oooo000E
0?ooo`800000E@3oool20?l004P0oooo0P3o001M0?ooo`005@3oool00`000000oooo0?ooo`1B0?oo
o`030000o`3o0000oooo04X0oooo00<0003o0?l0003o0000F`3oool001D0oooo00<000000?ooo`3o
ool0D@3oool20?l004h0oooo00<0003o0?l0003o0000F@3oool001D0oooo00<000000?ooo`3oool0
8@3oool700000240oooo1P0000000`000?l0o`000?ooo`0O0?ooo`@000009@3oool4000000D0oooo
00<0003o0?l0003oool06`3oool4000002@0oooo1000000@0?ooo`005@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool20?l00200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0oooo00<0
003o0?l0003oool06@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`005@3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3oool0o`009`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00L0oooo0P3o000M0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`005@3oool2000002D0oooo00<00000
0?ooo`3oool0903oool00`000?l0o`000?ooo`0W0?ooo`030000003oool0oooo0200oooo1P000009
0?ooo`030000o`3o0000oooo01/0oooo00<000000?ooo`3oool0803oool2000000<0oooo00<00000
0?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0S0?oo
o`80o`0000<000000?ooo`3oool0903oool2000002@0oooo00@000000?ooo`3oool000002`3oool0
0`000?l0o`000?ooo`0J0?ooo`030000003oool0oooo0200oooo00<000000?ooo`0000000P00000@
0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0280oooo00D0o`000?oo
o`3oool0oooo0000000W0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool000003@3o
ool00`3o0000oooo0?ooo`0D0?ooo`@000008`3oool00`000000oooo0?ooo`0B0?ooo`005@3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0200oooo0P3o00000`000000oooo0?ooo`02
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0000000>
0?ooo`80o`00503oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0140oooo000E0?oo
o`030000003oool0oooo0280oooo0`00000Q0?ooo`040?l0003oool0oooo000000@0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`0000003`3oool00`000?l0o`000?ooo`0B0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0M0?oo
o`80o`00103oool4000002<0oooo1000000V0?ooo`8000004@3oool00`3o0000oooo0?ooo`0@0?oo
o`D000009@3oool3000000l0oooo000E0?ooo`800000A03oool00`3o0000oooo0?ooo`1Y0?ooo`80
o`00C03oool001D0oooo00<000000?ooo`3oool0@P3oool00`3o0000oooo0?ooo`1[0?ooo`030000
o`3o0000oooo04X0oooo000E0?ooo`030000003oool0oooo0400oooo0P3o001`0?ooo`030?l0003o
ool0oooo04P0oooo000E0?ooo`030?l0003oool0oooo03l0oooo00<0o`000?ooo`3oool0L@3oool2
0?l00440oooo00<0o`000?ooo`3oool0103oool001D0oooo00<000000?l0003oool0?@3oool20?l0
07D0oooo00<0003o0?l0003oool0?P3oool00`3o0000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?l0000l0?ooo`030?l000000?l0oooo07H0oooo00<0003o0?l0003oool0?03oool00`3o0000
oooo0?ooo`060?ooo`003`3oool8000000030?l000000000000003P000000P3o001k00000080o`00
>P0000000`3o0000000000000007000000005@3oool010000000oooo0?ooo`3o00040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0080oooo00@0o`000000o`3oool000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000?l0o`000?ooo`0000070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030?l0003oool0oooo00D0oooo0@0000010?ooo`005@3oool01@000000oooo0?ooo`3oool0o`00
0280oooo00<000000?ooo`3oool04@3oool00`3o0000003o0?ooo`0A0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0J0?ooo`030000o`3o0000o`00
00L0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo
00P0oooo000E0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0<@3oool20?l008<0
oooo00<0003o0?l0003oool0<`3oool00`3o0000oooo0?ooo`090?ooo`005@3oool00`000000oooo
0?ooo`030?ooo`030?l0003oool0oooo02l0oooo00<0o`000000o`3oool0Q03oool00`000?l0o`00
0?ooo`0a0?ooo`030?l0003oool0oooo00X0oooo000E0?ooo`030000003oool0oooo00@0oooo00<0
o`000?ooo`3oool0;@3oool00`3o0000003o0?ooo`260?ooo`030000o`3o0000o`0002l0oooo00<0
o`000?ooo`3oool02`3oool001D0oooo00<000000?ooo`3oool0103oool00`3o0000oooo0?ooo`0[
0?ooo`80o`0000<0003o0?ooo`3oool0R03oool00`000?l0o`000?ooo`0/0?ooo`030?l0003oool0
oooo00`0oooo000E0?ooo`8000001P3oool00`3o0000oooo0?ooo`0Y0?ooo`030?l000000?l0oooo
08`0oooo00<0003o0?l0003o0000:`3oool00`3o0000oooo0?ooo`0<0?ooo`005@3oool00`000000
oooo0?ooo`060?ooo`030?l0003oool0oooo02H0oooo0P3o00000`000?l0oooo0?ooo`2>0?ooo`03
0000o`3o0000oooo02P0oooo00<0o`000?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool0
1`3oool00`3o0000oooo0?ooo`0S0?ooo`80o`000P000?nB0?ooo`030000o`3o0000o`0002H0oooo
00<0o`000?ooo`3oool03P3oool001D0oooo00<000000?ooo`3oool0203oool20?l00240oooo0P3o
00000`3oool0003o0?ooo`2E0?ooo`030000o`3o0000o`000280oooo0P3o000A0?ooo`005@3oool0
0`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo01`0oooo0P3o00020?ooo`030000o`3oool0
oooo09H0oooo00@0003o0?ooo`3o0000o`007P3oool20?l001<0oooo000E0?ooo`030000003oool0
oooo00/0oooo00<0o`000?ooo`3oool06@3oool20?l00080oooo0P000?nJ0?ooo`80003o00@0oooo
0?l0003o0000o`006P3oool00`3o0000oooo0?ooo`0C0?ooo`005@3oool2000000d0oooo0P3o000G
0?ooo`80o`000`3oool00`000?l0oooo0?ooo`2L0?ooo`040000o`3oool0oooo0?ooo`80o`005`3o
ool00`3o0000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`80o`004@3oool4
0?l000@0oooo00<0003o0?ooo`3oool0WP3oool00`000?l0oooo0?ooo`020?ooo`<0o`004P3oool2
0?l001L0oooo000E0?ooo`030000003oool0oooo0100oooo103o000:0?ooo`<0o`001P3oool20000
oj80oooo0P000?l50?ooo`<0o`002`3oool40?l001T0oooo000E0?ooo`030000003oool0oooo01@0
oooo2P3o00080?ooo`030000o`3oool0oooo0:@0oooo00<0003o0?ooo`3oool01@3oool;0?l001d0
oooo000E0?ooo`030000003oool0oooo02@0oooo0P000?nX0?ooo`80003o;@3oool001D0oooo00<0
00000?ooo`3oool08P3oool20000oj`0oooo0P000?l[0?ooo`005@3oool200000280oooo00<0003o
0?ooo`3oool0[P3oool00`000?l0oooo0?ooo`0X0?ooo`005@3oool00`000000oooo0?ooo`0O0?oo
o`80003o/P3oool20000obP0oooo000E0?ooo`030000003oool0oooo01d0oooo0P000?nf0?ooo`80
003o9P3oool001D0oooo00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`2h0?ooo`030000
o`3oool0oooo02<0oooo000E0?ooo`030000003oool0oooo01X0oooo0P000?nl0?ooo`80003o8`3o
ool001D0oooo00<000000?ooo`3oool0603oool20000ol00oooo0P000?lQ0?ooo`005@3oool20000
01L0oooo0P000?o40?ooo`80003o7`3oool001D0oooo00<000000?ooo`3oool0503oool20000olP0
oooo0`000?lL0?ooo`005@3oool00`000000oooo0?ooo`0A0?ooo`<0003oc@3oool30000oaT0oooo
000:0?ooo`L00000103oool00`000000oooo0?ooo`0>0?ooo`<0003od`3oool20000oaL0oooo000=
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool20000omP0oooo0`000?lD
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0`000?oM0?oo
o`80003o4P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090000on80
oooo2P000?l80?ooo`003@3oool00`000000oooo0?ooo`050?ooo`<0003om03oool30000o`H0oooo
000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o@3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3m0?ooo`002`3oool3000000L0oooo00<000000?oo
o`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m0?ooo`00
5@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0
oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0
oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E
0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3o
ool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3o
ool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000
oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?oo
o`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?ooo`002P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o@3oool000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0?d0oooo000=0?ooo`030000003oool0oooo00D0oooo0P00
003n0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?d0oooo000:0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?oo
o`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0o@3oool000/0oooo100000060?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0
oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?oo
o`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3o
ool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?oo
o`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000
003oool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool0
00/0oooo100000060?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0?d0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo0P0000060?ooo`800000oP3oool000l0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3m0?ooo`002`3oool4000000H0oooo00<000000?ooo`3oool0o@3o
ool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000
oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?oo
o`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo
0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?oo
o`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0
o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`00303oool4000000D0oooo00<000000?ooo`3oool0o@3oool000h0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3m0?ooo`003P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0?d0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m
0?ooo`002`3oool010000000oooo0?ooo`0000060?ooo`800000oP3oool000/0oooo00@000000?oo
o`3oool000001P3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo000000060?oo
o`030000003oool0oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool0o@3oool000d0oooo0P00003o0?ooo`L0oooo003o0?oooaH0oooo003o0?oooaH0oooo003o0?oo
oaH0oooo0000\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .11601 m
.04262 .14241 L
.06244 .16321 L
.07286 .1715 L
.08255 .17773 L
.0932 .183 L
.09916 .18528 L
.10458 .18695 L
.10941 .18814 L
.11206 .18866 L
.11454 .18908 L
.11891 .18965 L
.12123 .18987 L
.12244 .18996 L
.12373 .19003 L
.12445 .19007 L
.12511 .1901 L
.12639 .19014 L
.12711 .19015 L
.12788 .19016 L
.12862 .19016 L
.12929 .19016 L
.13052 .19015 L
.13121 .19013 L
.13186 .19011 L
.13317 .19006 L
.13458 .18999 L
.13725 .1898 L
.13977 .18955 L
.14451 .18893 L
.1491 .18813 L
.15416 .18704 L
.16442 .18419 L
.18284 .17714 L
.20219 .16749 L
.22304 .15509 L
.26418 .12671 L
.30381 .09755 L
.34191 .07067 L
.38248 .04582 L
.42152 .02746 L
.44287 .02023 L
.45266 .01764 L
.46302 .01541 L
.47255 .01383 L
.47797 .01314 L
.48303 .01263 L
.48542 .01243 L
.48768 .01228 L
.48974 .01216 L
Mistroke
.49193 .01205 L
.49317 .01201 L
.4943 .01197 L
.49545 .01194 L
.4965 .01192 L
.49774 .0119 L
.49838 .01189 L
.49907 .01189 L
.50022 .01189 L
.50148 .01189 L
.50279 .01191 L
.504 .01193 L
.50533 .01196 L
.50674 .012 L
.50911 .0121 L
.51172 .01224 L
.51652 .01259 L
.52103 .01303 L
.53111 .01438 L
.54196 .01641 L
.56204 .0217 L
.58315 .02932 L
.62131 .04792 L
.66193 .07326 L
.70102 .10109 L
.74257 .1316 L
.78261 .15862 L
.80096 .1692 L
.82113 .17885 L
.83073 .18256 L
.84104 .18581 L
.84673 .18725 L
.85193 .18833 L
.85715 .18917 L
.8597 .18949 L
.8621 .18974 L
.8643 .18992 L
.86544 .18999 L
.86668 .19006 L
.86796 .19011 L
.86866 .19013 L
.86932 .19014 L
.87049 .19016 L
.87174 .19016 L
.87242 .19016 L
.87306 .19015 L
.87376 .19013 L
.8745 .19011 L
.87574 .19006 L
.8771 .18999 L
Mistroke
.87962 .1898 L
.88198 .18955 L
.88662 .1889 L
.89086 .18808 L
.89575 .18686 L
.9004 .18543 L
.90999 .18158 L
.92022 .17609 L
.93861 .16227 L
.95796 .14169 L
.97619 .11601 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooo0P00001g0?ooo`P0o`00O`3oool000030?ooo`000000000000@00000
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo1`3o00070?ooo`030000
o`3o0000o`0000<0o`000`000?mg0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo06X0oooo0`000?l20?l001@0oooo103o00000`000?l0oooo0?ooo`1c0?ooo`003@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo06L0oooo0P000?l40?l001X0oooo1@3o001a
0?ooo`002`3oool3000000L0oooo00<000000?ooo`3oool0I@3oool40?l00280oooo00<0003o0?l0
003o0000K`3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1S0?ooo`80
o`00:03oool00`000?l0o`000?l0001]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80o`00
;@3oool20?l006/0oooo000E0?ooo`800000H03oool20?l00340oooo0P3o001Y0?ooo`005@3oool0
0`000000oooo0?ooo`1M0?ooo`80o`00=@3oool20?l006L0oooo000E0?ooo`030000003oool0oooo
05/0oooo0P3o000i0?ooo`80o`00I@3oool001D0oooo00<000000?ooo`3oool0F@3oool20?l003d0
oooo0P3o001S0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030000o`3o0000oooo0400oooo
0P3o001Q0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`80o`00A03oool20?l005l0oooo000E
0?ooo`800000E@3oool20?l004P0oooo0P3o001M0?ooo`005@3oool00`000000oooo0?ooo`1B0?oo
o`030000o`3o0000oooo04X0oooo00<0003o0?l0003o0000F`3oool001D0oooo00<000000?ooo`3o
ool0D@3oool20?l004h0oooo00<0003o0?l0003o0000F@3oool001D0oooo00<000000?ooo`3oool0
8@3oool700000240oooo1P0000000`000?l0o`000?ooo`0O0?ooo`@000009@3oool4000000D0oooo
00<0003o0?l0003oool06`3oool4000002@0oooo1000000@0?ooo`005@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool00P3oool20?l00200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00D0oooo00<0
003o0?l0003oool06@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`005@3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3oool0o`009`3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo00L0oooo0P3o000M0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?ooo`005@3oool2000002D0oooo00<00000
0?ooo`3oool0903oool00`000?l0o`000?ooo`0W0?ooo`030000003oool0oooo0200oooo1P000009
0?ooo`030000o`3o0000oooo01/0oooo00<000000?ooo`3oool0803oool2000000<0oooo00<00000
0?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0S0?oo
o`80o`0000<000000?ooo`3oool0903oool2000002@0oooo00@000000?ooo`3oool000002`3oool0
0`000?l0o`000?ooo`0J0?ooo`030000003oool0oooo0200oooo00<000000?ooo`0000000P00000@
0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0280oooo00D0o`000?oo
o`3oool0oooo0000000W0?ooo`030000003oool0oooo0240oooo00@000000?ooo`3oool000003@3o
ool00`3o0000oooo0?ooo`0D0?ooo`@000008`3oool00`000000oooo0?ooo`0B0?ooo`005@3oool0
0`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0200oooo0P3o00000`000000oooo0?ooo`02
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0000000>
0?ooo`80o`00503oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0140oooo000E0?oo
o`030000003oool0oooo0280oooo0`00000Q0?ooo`040?l0003oool0oooo000000@0oooo00<00000
0?ooo`3oool07`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0280oooo00<00000
0?ooo`0000003`3oool00`000?l0o`000?ooo`0B0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0M0?oo
o`80o`00103oool4000002<0oooo1000000V0?ooo`8000004@3oool00`3o0000oooo0?ooo`0@0?oo
o`D000009@3oool3000000l0oooo000E0?ooo`800000A03oool00`3o0000oooo0?ooo`1Y0?ooo`80
o`00C03oool001D0oooo00<000000?ooo`3oool0@P3oool00`3o0000oooo0?ooo`1[0?ooo`030000
o`3o0000oooo04X0oooo000E0?ooo`030000003oool0oooo0400oooo0P3o001`0?ooo`030?l0003o
ool0oooo04P0oooo000E0?ooo`030?l0003oool0oooo03l0oooo00<0o`000?ooo`3oool0L@3oool2
0?l00440oooo00<0o`000?ooo`3oool0103oool001D0oooo00<000000?l0003oool0?@3oool20?l0
07D0oooo00<0003o0?l0003oool0?P3oool00`3o0000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?l0000l0?ooo`030?l000000?l0oooo07H0oooo00<0003o0?l0003oool0?03oool00`3o0000
oooo0?ooo`060?ooo`003`3oool8000000030?l000000000000003P000000P3o001k00000080o`00
>P0000000`3o0000000000000007000000005@3oool010000000oooo0?ooo`3o00040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0080oooo00@0o`000000o`3oool000001`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool010000?l0o`000?ooo`0000070?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?oo
o`030?l0003oool0oooo00D0oooo0@0000010?ooo`005@3oool01@000000oooo0?ooo`3oool0o`00
0280oooo00<000000?ooo`3oool04@3oool00`3o0000003o0?ooo`0A0?ooo`030000003oool0oooo
02D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0J0?ooo`030000o`3o0000o`00
00L0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo
00P0oooo000E0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0<@3oool20?l008<0
oooo00<0003o0?l0003oool0<`3oool00`3o0000oooo0?ooo`090?ooo`005@3oool00`000000oooo
0?ooo`030?ooo`030?l0003oool0oooo02l0oooo00<0o`000000o`3oool0Q03oool00`000?l0o`00
0?ooo`0a0?ooo`030?l0003oool0oooo00X0oooo000E0?ooo`030000003oool0oooo00@0oooo00<0
o`000?ooo`3oool0;@3oool00`3o0000003o0?ooo`260?ooo`030000o`3o0000o`0002l0oooo00<0
o`000?ooo`3oool02`3oool001D0oooo00<000000?ooo`3oool0103oool00`3o0000oooo0?ooo`0[
0?ooo`80o`0000<0003o0?ooo`3oool0R03oool00`000?l0o`000?ooo`0/0?ooo`030?l0003oool0
oooo00`0oooo000E0?ooo`8000001P3oool00`3o0000oooo0?ooo`0Y0?ooo`030?l000000?l0oooo
08`0oooo00<0003o0?l0003o0000:`3oool00`3o0000oooo0?ooo`0<0?ooo`005@3oool00`000000
oooo0?ooo`060?ooo`030?l0003oool0oooo02H0oooo0P3o00000`000?l0oooo0?ooo`2>0?ooo`03
0000o`3o0000oooo02P0oooo00<0o`000?ooo`3oool03@3oool001D0oooo00<000000?ooo`3oool0
1`3oool00`3o0000oooo0?ooo`0S0?ooo`80o`000P000?nB0?ooo`030000o`3o0000o`0002H0oooo
00<0o`000?ooo`3oool03P3oool001D0oooo00<000000?ooo`3oool0203oool20?l00240oooo0P3o
00000`3oool0003o0?ooo`2E0?ooo`030000o`3o0000o`000280oooo0P3o000A0?ooo`005@3oool0
0`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo01`0oooo0P3o00020?ooo`030000o`3oool0
oooo09H0oooo00@0003o0?ooo`3o0000o`007P3oool20?l001<0oooo000E0?ooo`030000003oool0
oooo00/0oooo00<0o`000?ooo`3oool06@3oool20?l00080oooo0P000?nJ0?ooo`80003o00@0oooo
0?l0003o0000o`006P3oool00`3o0000oooo0?ooo`0C0?ooo`005@3oool2000000d0oooo0P3o000G
0?ooo`80o`000`3oool00`000?l0oooo0?ooo`2L0?ooo`040000o`3oool0oooo0?ooo`80o`005`3o
ool00`3o0000oooo0?ooo`0D0?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`80o`004@3oool4
0?l000@0oooo00<0003o0?ooo`3oool0WP3oool00`000?l0oooo0?ooo`020?ooo`<0o`004P3oool2
0?l001L0oooo000E0?ooo`030000003oool0oooo0100oooo103o000:0?ooo`<0o`001P3oool20000
oj80oooo0P000?l50?ooo`<0o`002`3oool40?l001T0oooo000E0?ooo`030000003oool0oooo01@0
oooo2P3o00080?ooo`030000o`3oool0oooo0:@0oooo00<0003o0?ooo`3oool01@3oool;0?l001d0
oooo000E0?ooo`030000003oool0oooo02@0oooo0P000?nX0?ooo`80003o;@3oool001D0oooo00<0
00000?ooo`3oool08P3oool20000oj`0oooo0P000?l[0?ooo`005@3oool200000280oooo00<0003o
0?ooo`3oool0[P3oool00`000?l0oooo0?ooo`0X0?ooo`005@3oool00`000000oooo0?ooo`0O0?oo
o`80003o/P3oool20000obP0oooo000E0?ooo`030000003oool0oooo01d0oooo0P000?nf0?ooo`80
003o9P3oool001D0oooo00<000000?ooo`3oool0703oool00`000?l0oooo0?ooo`2h0?ooo`030000
o`3oool0oooo02<0oooo000E0?ooo`030000003oool0oooo01X0oooo0P000?nl0?ooo`80003o8`3o
ool001D0oooo00<000000?ooo`3oool0603oool20000ol00oooo0P000?lQ0?ooo`005@3oool20000
01L0oooo0P000?o40?ooo`80003o7`3oool001D0oooo00<000000?ooo`3oool0503oool20000olP0
oooo0`000?lL0?ooo`005@3oool00`000000oooo0?ooo`0A0?ooo`<0003oc@3oool30000oaT0oooo
000:0?ooo`L00000103oool00`000000oooo0?ooo`0>0?ooo`<0003od`3oool20000oaL0oooo000=
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool20000omP0oooo0`000?lD
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0`000?oM0?oo
o`80003o4P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090000on80
oooo2P000?l80?ooo`003@3oool00`000000oooo0?ooo`050?ooo`<0003om03oool30000o`H0oooo
000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o@3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`3m0?ooo`002`3oool3000000L0oooo00<000000?oo
o`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m0?ooo`00
5@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0
oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0
oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E
0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3o
ool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3o
ool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000
oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?oo
o`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?ooo`002P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o@3oool000/0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0?d0oooo000=0?ooo`030000003oool0oooo00D0oooo0P00
003n0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?d0oooo000:0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?oo
o`002P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0o@3oool000/0oooo100000060?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0
oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?oo
o`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3o
ool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?oo
o`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000
003oool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool0
00/0oooo100000060?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo0?d0oooo000?0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo0P0000060?ooo`800000oP3oool000l0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3m0?ooo`002`3oool4000000H0oooo00<000000?ooo`3oool0o@3o
ool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000
oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?oo
o`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003o
ool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo
0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?oo
o`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0
o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`00303oool4000000D0oooo00<000000?ooo`3oool0o@3oool000h0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3m0?ooo`003P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0?d0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m
0?ooo`002`3oool010000000oooo0?ooo`0000060?ooo`800000oP3oool000/0oooo00@000000?oo
o`3oool000001P3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo000000060?oo
o`030000003oool0oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3o
ool0o@3oool000d0oooo0P00003o0?ooo`L0oooo003o0?oooaH0oooo003o0?oooaH0oooo003o0?oo
oaH0oooo0000\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.151576 0.130738 0.118853 [
[.17539 .11824 -3 -9 ]
[.17539 .11824 3 0 ]
[.32696 .11824 -3 -9 ]
[.32696 .11824 3 0 ]
[.47854 .11824 -3 -9 ]
[.47854 .11824 3 0 ]
[.63011 .11824 -3 -9 ]
[.63011 .11824 3 0 ]
[.78169 .11824 -3 -9 ]
[.78169 .11824 3 0 ]
[.93327 .11824 -3 -9 ]
[.93327 .11824 3 0 ]
[.01131 .01189 -12 -4.5 ]
[.01131 .01189 0 4.5 ]
[.01131 .24959 -6 -4.5 ]
[.01131 .24959 0 4.5 ]
[.01131 .36844 -6 -4.5 ]
[.01131 .36844 0 4.5 ]
[.01131 .4873 -6 -4.5 ]
[.01131 .4873 0 4.5 ]
[.01131 .60615 -6 -4.5 ]
[.01131 .60615 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .13074 m
.17539 .13699 L
s
[(1)] .17539 .11824 0 1 Mshowa
.32696 .13074 m
.32696 .13699 L
s
[(2)] .32696 .11824 0 1 Mshowa
.47854 .13074 m
.47854 .13699 L
s
[(3)] .47854 .11824 0 1 Mshowa
.63011 .13074 m
.63011 .13699 L
s
[(4)] .63011 .11824 0 1 Mshowa
.78169 .13074 m
.78169 .13699 L
s
[(5)] .78169 .11824 0 1 Mshowa
.93327 .13074 m
.93327 .13699 L
s
[(6)] .93327 .11824 0 1 Mshowa
.125 Mabswid
.05412 .13074 m
.05412 .13449 L
s
.08444 .13074 m
.08444 .13449 L
s
.11476 .13074 m
.11476 .13449 L
s
.14507 .13074 m
.14507 .13449 L
s
.2057 .13074 m
.2057 .13449 L
s
.23602 .13074 m
.23602 .13449 L
s
.26633 .13074 m
.26633 .13449 L
s
.29665 .13074 m
.29665 .13449 L
s
.35728 .13074 m
.35728 .13449 L
s
.38759 .13074 m
.38759 .13449 L
s
.41791 .13074 m
.41791 .13449 L
s
.44822 .13074 m
.44822 .13449 L
s
.50885 .13074 m
.50885 .13449 L
s
.53917 .13074 m
.53917 .13449 L
s
.56948 .13074 m
.56948 .13449 L
s
.5998 .13074 m
.5998 .13449 L
s
.66043 .13074 m
.66043 .13449 L
s
.69074 .13074 m
.69074 .13449 L
s
.72106 .13074 m
.72106 .13449 L
s
.75138 .13074 m
.75138 .13449 L
s
.81201 .13074 m
.81201 .13449 L
s
.84232 .13074 m
.84232 .13449 L
s
.87264 .13074 m
.87264 .13449 L
s
.90295 .13074 m
.90295 .13449 L
s
.96358 .13074 m
.96358 .13449 L
s
.9939 .13074 m
.9939 .13449 L
s
.25 Mabswid
0 .13074 m
1 .13074 L
s
.02381 .01189 m
.03006 .01189 L
s
[(-1)] .01131 .01189 1 0 Mshowa
.02381 .24959 m
.03006 .24959 L
s
[(1)] .01131 .24959 1 0 Mshowa
.02381 .36844 m
.03006 .36844 L
s
[(2)] .01131 .36844 1 0 Mshowa
.02381 .4873 m
.03006 .4873 L
s
[(3)] .01131 .4873 1 0 Mshowa
.02381 .60615 m
.03006 .60615 L
s
[(4)] .01131 .60615 1 0 Mshowa
.125 Mabswid
.02381 .03566 m
.02756 .03566 L
s
.02381 .05943 m
.02756 .05943 L
s
.02381 .0832 m
.02756 .0832 L
s
.02381 .10697 m
.02756 .10697 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .17828 m
.02756 .17828 L
s
.02381 .20205 m
.02756 .20205 L
s
.02381 .22582 m
.02756 .22582 L
s
.02381 .27336 m
.02756 .27336 L
s
.02381 .29713 m
.02756 .29713 L
s
.02381 .3209 m
.02756 .3209 L
s
.02381 .34467 m
.02756 .34467 L
s
.02381 .39221 m
.02756 .39221 L
s
.02381 .41598 m
.02756 .41598 L
s
.02381 .43975 m
.02756 .43975 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .51107 m
.02756 .51107 L
s
.02381 .53484 m
.02756 .53484 L
s
.02381 .55861 m
.02756 .55861 L
s
.02381 .58238 m
.02756 .58238 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .24959 m
.02499 .24959 L
.02605 .24958 L
.02729 .24956 L
.02846 .24953 L
.03053 .24947 L
.03279 .24938 L
.03527 .24925 L
.0379 .24908 L
.04262 .24868 L
.04749 .24814 L
.05205 .24753 L
.06244 .24575 L
.07305 .24338 L
.08274 .24072 L
.10458 .23311 L
.14429 .21398 L
.18248 .1902 L
.22313 .16081 L
.26226 .13046 L
.30384 .09827 L
.34391 .06953 L
.38246 .04587 L
.402 .03587 L
.42346 .02672 L
.44388 .01994 L
.45301 .01755 L
.46295 .01542 L
.46838 .01446 L
.4734 .01371 L
.4781 .01312 L
.4833 .01261 L
.48553 .01243 L
.48794 .01226 L
.49002 .01214 L
.4923 .01204 L
.49473 .01196 L
.49605 .01193 L
.49728 .0119 L
.49844 .01189 L
.49949 .01189 L
.50071 .01189 L
.50186 .01189 L
.50301 .01191 L
.50425 .01193 L
.50542 .01196 L
.50648 .01199 L
.5091 .0121 L
.51158 .01223 L
.5165 .01259 L
Mistroke
.52187 .01312 L
.53144 .01443 L
.54032 .01607 L
.56088 .02134 L
.5795 .02786 L
.61962 .04702 L
.65822 .07097 L
.69928 .10063 L
.73882 .13131 L
.77684 .16079 L
.81732 .19007 L
.85628 .2143 L
.87613 .22462 L
.89769 .23401 L
.91843 .24107 L
.92832 .24371 L
.93759 .24576 L
.94643 .24731 L
.95595 .24853 L
.9611 .249 L
.96369 .24919 L
.96652 .24935 L
.96894 .24945 L
.9703 .2495 L
.97153 .24953 L
.97268 .24956 L
.97393 .24958 L
.97511 .24959 L
.97619 .24959 L
Mfstroke
1 0 0 r
.02381 .27471 m
.06244 .25873 L
.10458 .23898 L
.14415 .21662 L
.18221 .19144 L
.22272 .16148 L
.26171 .131 L
.30316 .09881 L
.34309 .07009 L
.3815 .04639 L
.40095 .03637 L
.42237 .02714 L
.44268 .02028 L
.45178 .01785 L
.46172 .01566 L
.4671 .01467 L
.4721 .01389 L
.47727 .01322 L
.48196 .01273 L
.48658 .01235 L
.4887 .01222 L
.49093 .0121 L
.49332 .012 L
.49438 .01197 L
.49552 .01194 L
.49675 .01191 L
.49789 .0119 L
.49859 .01189 L
.49925 .01189 L
.50049 .01189 L
.50163 .01189 L
.50286 .01191 L
.50401 .01193 L
.50508 .01195 L
.50754 .01203 L
.51014 .01215 L
.51268 .0123 L
.51504 .01247 L
.5204 .01296 L
.5293 .0141 L
.53882 .01576 L
.54906 .01806 L
.56016 .02113 L
.58032 .02818 L
.62123 .04792 L
.66064 .07262 L
.69852 .10009 L
.73886 .13145 L
.77769 .16179 L
.81897 .19226 L
Mistroke
.85873 .21838 L
.89697 .23978 L
.93767 .25878 L
.97619 .27471 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{185.25, 114.5},
  ImageMargins->{{85, 0}, {0, 0.625}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004E0000Zb000`400?l00000o`00003oo`3ooolF
0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`00o`3ooolF0?ooo`002P3oool7000000@0oooo00<0
00000?ooo`3oool0o@3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3m
0?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?d0oooo000=0?ooo`03
0000003oool0oooo00D0oooo0P00001g0?ooo`P0o`00O`3oool000030?ooo`000000000000@00000
1P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo1`3o00070?ooo`030000
o`3o0000o`0000D0o`0000<0003o0?ooo`3oool0M@3oool000d0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`1Z0?ooo`80003o0`3o000F0?ooo`<0o`00M@3oool000d0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`1W0?ooo`030000o`3o0000o`000080o`00703oool3
0?l00780oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`1U0?ooo`<0o`008`3oool20?l0
0700oooo000=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0H`3oool20?l002P0
oooo0`3o001]0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`80o`00;@3oool20?l006/0oooo
000E0?ooo`800000H03oool20?l00340oooo0P3o001Y0?ooo`005@3oool00`000000oooo0?ooo`1L
0?ooo`<0o`00=@3oool20?l006L0oooo000E0?ooo`030000003oool0oooo05X0oooo0P3o00000`00
0?l0oooo0?ooo`0g0?ooo`80o`00I@3oool001D0oooo00<000000?ooo`3oool0F03oool20?l00003
0000o`3oool0oooo03/0oooo0P3o001S0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030?l0
00000?l0oooo0400oooo0P3o001Q0?ooo`005@3oool00`000000oooo0?ooo`1F0?ooo`030?l0003o
ool0oooo04<0oooo0P3o001O0?ooo`005@3oool2000005D0oooo0P3o00180?ooo`80o`00G@3oool0
01D0oooo00<000000?ooo`3oool0DP3oool00`000?l0o`000?ooo`1:0?ooo`030000o`3o0000o`00
05/0oooo000E0?ooo`030000003oool0oooo0540oooo0P3o001>0?ooo`030000o`3o0000o`0005T0
oooo000E0?ooo`030000003oool0oooo0240oooo1`00000Q0?ooo`H0000000<0003o0?l0003oool0
7`3oool4000002D0oooo100000050?ooo`030000o`3o0000oooo01/0oooo1000000T0?ooo`@00000
403oool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo0080oooo0P3o000P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0903o
ool00`000000oooo0?ooo`050?ooo`030000o`3o0000oooo01T0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3o
ool001D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0S0?ooo`040000003oool0
oooo0?l002L0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`070?ooo`80o`007@3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3o
ool001D0oooo0P00000U0?ooo`030000003oool0oooo02@0oooo00<0003o0?l0003oool09`3oool0
0`000000oooo0?ooo`0P0?ooo`H000002@3oool00`000?l0o`000?ooo`0K0?ooo`030000003oool0
oooo0200oooo0P0000030?ooo`030000003oool0oooo00d0oooo000E0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool08`3oool20?l000030000003oool0oooo02@0oooo0P00000T0?oo
o`040000003oool0oooo000000/0oooo00<0003o0?l0003oool06P3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0000000800000403oool001D0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0R0?ooo`050?l0003oool0oooo0?ooo`0000009`3oool00`000000oooo0?ooo`0Q
0?ooo`040000003oool0oooo000000d0oooo0P3o000E0?ooo`@000008`3oool00`000000oooo0?oo
o`0B0?ooo`005@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo0200oooo0P3o0000
0`000000oooo0?ooo`020?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0000000>0?ooo`030000o`3o0000oooo01<0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0A0?ooo`005@3oool00`000000oooo0?ooo`0R0?ooo`<000008@3oool0103o
0000oooo0?ooo`0000040?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0R0?ooo`030000003oool0000000l0oooo00<0003o0?l0003oool04P3oool0
0`000000oooo0?ooo`0V0?ooo`030000003oool0oooo0100oooo000E0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool07@3oool00`000?l0o`000?ooo`030?ooo`@000008`3oool40000
02H0oooo0P00000A0?ooo`030?l0003oool0oooo0100oooo1@00000U0?ooo`<000003`3oool001D0
oooo0P0000140?ooo`80o`00JP3oool20?l004`0oooo000E0?ooo`030000003oool0oooo0480oooo
00<0o`000?ooo`3oool0J`3oool00`000?l0o`000?ooo`1:0?ooo`005@3oool00`000000oooo0?oo
o`100?ooo`030000o`3o0000oooo06l0oooo00<0o`000?ooo`3oool0B03oool001D0oooo00<00000
0?ooo`3oool0?`3oool00`000?l0o`000?ooo`1a0?ooo`030?l0003oool0oooo04L0oooo000E0?oo
o`030000003oool0oooo03h0oooo00<0003o0?l0003oool0L`3oool00`3o0000oooo0?ooo`160?oo
o`005@3oool00`000000oooo0?ooo`0l0?ooo`030000o`3o0000o`0007H0oooo0P3o00160?ooo`00
3`3ooom4000000030000o`3o0000000007T0000000<0o`00000000000000@`00000001D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`030000o`3o0000000000L0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00@0
o`000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`4000000@3oool001D0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`0A0?ooo`030000o`3o0000o`000140oooo00<0
00000?ooo`3oool09@3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01X0oooo00<0
o`000000o`3oool01`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00l0oooo000E
0?ooo`030000003oool0oooo03L0oooo00<0003o0?l0003oool0P03oool20?l00440oooo000E0?oo
o`030000003oool0oooo03H0oooo00<0003o0?l0003oool0P`3oool00`3o0000oooo0?ooo`0n0?oo
o`005@3oool00`000000oooo0?ooo`0e0?ooo`80o`00QP3oool00`3o0000003o0?ooo`0m0?ooo`00
5@3oool00`000000oooo0?ooo`0c0?ooo`030000o`3o0000oooo08P0oooo00<0o`000000o`3oool0
?03oool001D0oooo0P00000c0?ooo`80o`00R`3oool20?l000030000o`3oool0oooo03T0oooo000E
0?ooo`030000003oool0oooo0340oooo00<0o`000?ooo`3oool0S@3oool00`3o0000003o0?ooo`0i
0?ooo`005@3oool00`000000oooo0?ooo`0_0?ooo`80o`00T@3oool00`3o0000003o0000o`0h0?oo
o`005@3oool00`000000oooo0?ooo`0^0?ooo`030?l0003oool0oooo0980oooo0P3o00000`000?l0
oooo0?ooo`0e0?ooo`005@3oool00`000000oooo0?ooo`0]0?ooo`030?l0003oool0oooo09D0oooo
00<0o`000000o`3oool0=@3oool001D0oooo00<000000?ooo`3oool0:`3oool20?l009T0oooo00<0
o`000000o`000?l0=03oool001D0oooo0P00000[0?ooo`030?l0003oool0oooo09X0oooo0P3o0000
0`000?l0oooo0?ooo`0a0?ooo`005@3oool00`000000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo
09d0oooo00<0o`000000o`3oool0<@3oool001D0oooo00<000000?ooo`3oool09`3oool20?l00:40
oooo00<0o`000000o`000?l0<03oool001D0oooo00<000000?ooo`3oool09P3oool00`3o0000oooo
0?ooo`2R0?ooo`80o`0000<0003o0?ooo`3oool0;@3oool001D0oooo00<000000?ooo`3oool0903o
ool20?l00:L0oooo00<0o`000000o`000?l0;@3oool001D0oooo00<000000?ooo`3oool08P3oool0
0`000?l0o`000?ooo`2Y0?ooo`80o`000P000?l[0?ooo`005@3oool200000280oooo00<0003o0?l0
003oool0[03oool20?l000030000o`3oool0oooo02P0oooo000E0?ooo`030000003oool0oooo01l0
oooo00<0003o0?l0003o0000/03oool00`3o0000003o0000o`0X0?ooo`005@3oool00`000000oooo
0?ooo`0M0?ooo`80003o00<0o`000?ooo`3oool0/@3oool20?l00080003o9P3oool001D0oooo00<0
00000?ooo`3oool0703oool00`000?l0o`000?l0002f0?ooo`80o`0000<0003o0?ooo`3oool08`3o
ool001D0oooo00<000000?ooo`3oool06P3oool20000o`030?l0003oool0oooo0;P0oooo00<0o`00
0000o`000?l08`3oool001D0oooo00<000000?ooo`3oool0603oool20000o`80o`00_03oool20?l0
0080003o8@3oool001D0oooo0P00000G0?ooo`80003o0P3o00300?ooo`80o`000P000?lO0?ooo`00
5@3oool00`000000oooo0?ooo`0D0?ooo`80003o00<0oooo0?l0003oool0``3oool00`3o0000oooo
0000o`020000oa`0oooo000E0?ooo`030000003oool0oooo0140oooo0`000?l00`3oool0o`000?l0
00360?ooo`80o`000P3oool30000oaT0oooo000:0?ooo`L00000103oool00`000000oooo0?ooo`0>
0?ooo`<0003o0P3oool20?l00<X0oooo0P3o00030?ooo`80003o5`3oool000d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`80003o0`3oool20?l00<h0oooo0P3o00030?oo
o`<0003o503oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`<0
003o0`3oool20?l00=80oooo0P3o00040?ooo`80003o4P3oool000d0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`090000o`@0oooo0P3o003F0?ooo`80o`00103oool:0000o`P0oooo
000=0?ooo`030000003oool0oooo00D0oooo0`000?l;0?ooo`80o`00fP3oool20?l000/0oooo0`00
0?l60?ooo`003@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00T0oooo0P3o003N
0?ooo`80o`004P3oool000d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?oo
o`<0o`00hP3oool30?l000l0oooo000;0?ooo`<000001`3oool00`000000oooo0?ooo`040?ooo`80
o`00j03oool20?l000d0oooo000=0?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool0
oooo0`3o003/0?ooo`<0o`002P3oool001D0oooo00@000000?ooo`3o0000o`00lP3oool20?l000P0
oooo000E0?ooo`80o`00mP3oool20?l000H0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E
0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`03
0000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`800000oP3o
ool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0
oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3o
ool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool20000
0?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?ooo`002P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o@3oool000/0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0?d0oooo000=0?ooo`030000003oool0oooo00D0oooo0P00003n0?ooo`003P3o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`002P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0o@3oool000/0
oooo100000060?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?oo
o`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0
o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`00
0000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo
0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m
0?ooo`005@3oool200000?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000
003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0
oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0
oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0o@3oool000/0oooo10000006
0?ooo`030000003oool0oooo0?d0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0?d0oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
o@3oool000d0oooo0P0000060?ooo`800000oP3oool000l0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`3m0?ooo`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0?d0oooo000:0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`3m0?ooo`002`3oool4000000H0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<0
00000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m0?oo
o`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3o
ool00`000000oooo0?ooo`3m0?ooo`005@3oool00`000000oooo0?ooo`3m0?ooo`005@3oool20000
0?h0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo
000E0?ooo`030000003oool0oooo0?d0oooo000E0?ooo`030000003oool0oooo0?d0oooo000E0?oo
o`030000003oool0oooo0?d0oooo000E0?ooo`800000oP3oool001D0oooo00<000000?ooo`3oool0
o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool0
01D0oooo00<000000?ooo`3oool0o@3oool001D0oooo00<000000?ooo`3oool0o@3oool001D0oooo
00<000000?ooo`3oool0o@3oool001D0oooo0P00003n0?ooo`005@3oool00`000000oooo0?ooo`3m
0?ooo`00303oool4000000D0oooo00<000000?ooo`3oool0o@3oool000h0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`3m0?ooo`003P3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo0?d0oooo000:0?ooo`H000001@3oool00`000000oooo0?ooo`3m0?ooo`002`3oool0
10000000oooo0?ooo`0000060?ooo`800000oP3oool000/0oooo00@000000?ooo`3oool000001P3o
ool00`000000oooo0?ooo`3m0?ooo`00303oool00`000000oooo000000060?ooo`030000003oool0
oooo0?d0oooo000<0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0o@3oool000d0
oooo0P00003o0?ooo`L0oooo003o0?oooaH0oooo003o0?oooaH0oooo003o0?oooaH0oooo0000\
\>"],
  ImageRangeCache->{{{0, 276.875}, {170.75, 0}} -> {-0.536037, -1.24342, \
0.0377951, 0.0482009}}]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1400}, {0, 959}},
WindowSize->{729, 817},
WindowMargins->{{312, Automatic}, {42, Automatic}},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 40, 0, 95, "Subtitle"],
Cell[1819, 55, 403, 14, 73, "Text"],

Cell[CellGroupData[{
Cell[2247, 73, 108, 2, 68, "Input"],
Cell[2358, 77, 1357, 40, 101, "Output"]
}, Open  ]],
Cell[3730, 120, 256, 6, 73, "Text"],

Cell[CellGroupData[{
Cell[4011, 130, 42, 1, 42, "Input"],
Cell[4056, 133, 851, 21, 101, "Output"]
}, Open  ]],
Cell[4922, 157, 343, 12, 73, "Text"],
Cell[5268, 171, 112, 2, 68, "Input"],

Cell[CellGroupData[{
Cell[5405, 177, 59, 1, 42, "Input"],
Cell[5467, 180, 106, 2, 62, "Output"]
}, Open  ]],
Cell[5588, 185, 732, 26, 99, "Text"],

Cell[CellGroupData[{
Cell[6345, 215, 69, 1, 42, "Input"],
Cell[6417, 218, 1079, 27, 128, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7533, 250, 46, 1, 42, "Input"],
Cell[7582, 253, 994, 26, 101, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8613, 284, 51, 1, 42, "Input"],
Cell[8667, 287, 126, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8830, 295, 84, 1, 42, "Input"],
Cell[8917, 298, 800, 23, 43, "Output"]
}, Open  ]],
Cell[9732, 324, 633, 17, 96, "Text"],
Cell[10368, 343, 356, 10, 99, "Text"],
Cell[10727, 355, 62, 1, 42, "Input"],
Cell[10792, 358, 250, 4, 120, "Input"],

Cell[CellGroupData[{
Cell[11067, 366, 144, 3, 68, "Input"],
Cell[11214, 371, 28992, 717, 214, 6332, 433, "GraphicsData", "PostScript", \
"Graphics"],
Cell[40209, 1090, 130, 3, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40376, 1098, 239, 5, 94, "Input"],

Cell[CellGroupData[{
Cell[40640, 1107, 17101, 514, 185, 5191, 363, "GraphicsData", "PostScript", \
"Graphics"],
Cell[57744, 1623, 24641, 633, 185, 5671, 394, "GraphicsData", "PostScript", \
"Graphics"],
Cell[82388, 2258, 24641, 633, 185, 5671, 394, "GraphicsData", "PostScript", \
"Graphics"],
Cell[107032, 2893, 19628, 617, 185, 6567, 451, "GraphicsData", "PostScript", \
"Graphics"],
Cell[126663, 3512, 19628, 617, 185, 6567, 451, "GraphicsData", "PostScript", \
"Graphics"],
Cell[146294, 4131, 18378, 554, 185, 5658, 393, "GraphicsData", "PostScript", \
"Graphics"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

